/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.Drawable2;
import com.ibm.graph.GraphObject;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.DrawVertex;
import com.ibm.research.util.Dict;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class Draw2Vertex
extends DrawVertex
implements Drawable2 {
    protected int iTranslationX = 0;
    protected int iTranslationY = 0;
    private static String strClassName = "Draw2Vertex";

    public boolean contains(Net net, GraphObject graphObject, int n, int n2) {
        try {
            return this.getBounds(net, (Vertex)graphObject).contains(n, n2);
        }
        catch (NullPointerException nullPointerException) {
            if (net == null) {
                System.out.println("?![" + strClassName + ".contains(Net," + graphObject + "," + n + "," + n2 + ")] Null net.");
            }
            if (graphObject == null) {
                System.out.println("?![" + strClassName + ".contains(Net," + graphObject + "," + n + "," + n2 + ")] Null vertex.");
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            System.out.println("?![" + strClassName + ".contains(Net," + graphObject + "," + n + "," + n2 + ")] Graph object is not an instance of Vertex.");
            return false;
        }
        catch (NotDrawableException notDrawableException) {
            return false;
        }
    }

    public void draw(Net net, GraphObject graphObject, Graphics graphics) {
        Dict dict;
        Object object;
        Vertex vertex;
        try {
            vertex = (Vertex)graphObject;
        }
        catch (ClassCastException classCastException) {
            System.out.println("[" + strClassName + ".draw(Net," + graphObject + ",Graphics)] Graph object is not of class Vertex.");
            return;
        }
        try {
            object = vertex.systemdict.get(net);
        }
        catch (NullPointerException nullPointerException) {
            object = vertex.systemdict;
        }
        try {
            dict = (Dict)object;
        }
        catch (ClassCastException classCastException) {
            System.out.println("!![" + strClassName + ".draw(Net," + graphObject + ",Graphics)] Value of net-key is not a Dict. Using systemdict instead.");
            dict = vertex.systemdict;
        }
        try {
            if (dict != null) {
                this.drawVertex(dict, vertex, graphics);
            } else {
                this.drawVertex(vertex.systemdict, vertex, graphics);
            }
        }
        catch (NotDrawableException notDrawableException) {
            if (this.iVerbose > 0) {
                System.out.println("[" + strClassName + ".draw(Net," + graphObject + ",Graphics)] Not drawable: unspecified location.");
            }
            return;
        }
        catch (NullPointerException nullPointerException) {
            if (vertex == null) {
                System.out.println("[" + strClassName + ".draw(Net," + vertex + ",Graphics)] Vertex is null.");
            }
            if (graphics == null) {
                System.out.println("[" + strClassName + ".draw(Net," + vertex + ",Graphics)] Graphics is null.");
            }
            System.out.println("[" + strClassName + ".draw(Net," + vertex + ",Graphics)] Null pointer exception. [BUG?]");
            nullPointerException.printStackTrace();
            return;
        }
    }

    protected void drawVertex(Vertex vertex, Graphics graphics) throws NotDrawableException {
        this.drawVertex(vertex.systemdict, vertex, graphics);
    }

    protected abstract void drawVertex(Dict var1, Vertex var2, Graphics var3) throws NotDrawableException;

    public Rectangle getBounds(Net net, GraphObject graphObject) throws NotDrawableException {
        Dict dict;
        Vertex vertex;
        try {
            vertex = (Vertex)graphObject;
        }
        catch (ClassCastException classCastException) {
            System.out.println("[" + strClassName + ".getBounds(Net," + graphObject + ")] Graph object is not an instance of Vertex.");
            throw new NotDrawableException();
        }
        try {
            dict = (Dict)vertex.systemdict.get(net);
        }
        catch (ClassCastException classCastException) {
            System.out.println("?![" + strClassName + ".getBounds(Net," + graphObject + ")] Value of netdict is not an instance of Dict.");
            return this.getBoundsVertex(vertex.systemdict, vertex);
        }
        if (dict == null) {
            dict = vertex.systemdict;
        }
        return this.getBoundsVertex(dict, vertex);
    }

    protected Rectangle getBoundsVertex(Vertex vertex) throws NotDrawableException {
        return this.getBoundsVertex(vertex.systemdict, vertex);
    }

    public abstract Rectangle getBoundsVertex(Dict var1, Vertex var2) throws NotDrawableException;

    protected Dict getNetDict(Net net, Vertex vertex) {
        Object v;
        if (vertex.systemdict.containsKey(net) && (v = vertex.systemdict.get(net)) instanceof Dict) {
            return (Dict)v;
        }
        return null;
    }

    protected Dict getNetOrSystemDict(Net net, Vertex vertex) {
        Dict dict = this.getNetDict(net, vertex);
        if (dict == null) {
            dict = vertex.systemdict;
        }
        return dict;
    }

    public Dimension getSize(Net net, GraphObject graphObject) throws NotDrawableException {
        Dict dict;
        Vertex vertex;
        try {
            vertex = (Vertex)graphObject;
        }
        catch (ClassCastException classCastException) {
            System.out.println("[" + strClassName + ".getSize(Net," + graphObject + ")] Graph object is not an instance of Vertex.");
            throw new NotDrawableException();
        }
        try {
            dict = (Dict)vertex.systemdict.get(net);
        }
        catch (NullPointerException nullPointerException) {
            if (vertex == null) {
                System.out.println("[" + strClassName + ".getSize(Net," + vertex + ")] Vertex is null.");
                throw new NotDrawableException();
            }
            if (net == null) {
                return this.getSizeVertex(vertex.systemdict, vertex);
            }
            System.out.println("[" + strClassName + ".getSize(Net," + vertex + ")] Null pointer exception. [BUG?]");
            nullPointerException.printStackTrace();
            throw new NotDrawableException();
        }
        catch (ClassCastException classCastException) {
            System.out.println("?![" + strClassName + ".getSize(Net," + graphObject + ")] Value of netdict is not an instance of Dict.");
            return this.getSizeVertex(vertex.systemdict, vertex);
        }
        if (dict == null) {
            dict = vertex.systemdict;
        }
        return this.getSizeVertex(dict, vertex);
    }

    protected Dimension getSizeVertex(Vertex vertex) throws NotDrawableException {
        return this.getSizeVertex(vertex.systemdict, vertex);
    }

    protected abstract Dimension getSizeVertex(Dict var1, Vertex var2) throws NotDrawableException;

    public int getTranslationX() {
        return this.iTranslationX;
    }

    public int getTranslationY() {
        return this.iTranslationY;
    }

    public static int getX(Net net, Vertex vertex) throws NotDrawableException {
        Dict dict;
        Object v = vertex.systemdict.get(net);
        try {
            dict = (Dict)v;
        }
        catch (ClassCastException classCastException) {
            return DrawVertex.getX(vertex.systemdict);
        }
        try {
            return DrawVertex.getX(dict);
        }
        catch (NullPointerException nullPointerException) {
            return DrawVertex.getX(vertex.systemdict);
        }
        catch (NotDrawableException notDrawableException) {
            return DrawVertex.getX(vertex.systemdict);
        }
    }

    public static int getY(Net net, Vertex vertex) throws NotDrawableException {
        Dict dict;
        Object v = vertex.systemdict.get(net);
        try {
            dict = (Dict)v;
        }
        catch (ClassCastException classCastException) {
            return DrawVertex.getY(vertex.systemdict);
        }
        try {
            return DrawVertex.getY(dict);
        }
        catch (NullPointerException nullPointerException) {
            return DrawVertex.getY(vertex.systemdict);
        }
        catch (NotDrawableException notDrawableException) {
            return DrawVertex.getY(vertex.systemdict);
        }
    }

    public void setTranslationX(int n) {
        this.iTranslationX = n;
    }

    public void setTranslationY(int n) {
        this.iTranslationY = n;
    }

    public Point translate(int n, int n2) {
        return new Point(n + this.iTranslationX, n2 + this.iTranslationY);
    }

    public Point translate(Point point) {
        return new Point(point.x + this.iTranslationX, point.y + this.iTranslationY);
    }
}

