/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.Edge;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw2EdgePath;
import com.ibm.research.awt.PolygonUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Draw2EdgeParabolaDirectedArrow
extends Draw2EdgePath {
    private static int _iDefaultArrowHeadLength = 20;
    private static int _iDefaultArrowHeadWidth = 12;
    private double _dFlatness = 0.0;
    double dContainment = 3.0;
    int _iSubdivideCount = 1;
    Point2D pointArrow;
    private static String strClassName = "Draw2EdgeParabolaDirectedArrow";
    private Polygon _polygonPath;
    private boolean _zArrowHeadStroke = true;
    private boolean _zArrowHeadFill = false;
    private Color _colorArrowHeadStroke = Color.black;
    private Color _colorArrowHeadFill = Color.black;
    private Polygon _polygonPathTransformed;

    public Draw2EdgeParabolaDirectedArrow() {
        this(0.0);
    }

    public Draw2EdgeParabolaDirectedArrow(double d) {
        this._dFlatness = d;
        this._polygonPath = new Polygon();
        this._polygonPath.addPoint(0, 0);
        this._polygonPath.addPoint(-_iDefaultArrowHeadLength, _iDefaultArrowHeadWidth >> 1);
        this._polygonPath.addPoint(-_iDefaultArrowHeadLength, -_iDefaultArrowHeadWidth >> 1);
        this._polygonPath.addPoint(0, 0);
        this._polygonPathTransformed = new Polygon((int[])this._polygonPath.xpoints.clone(), (int[])this._polygonPath.ypoints.clone(), this._polygonPath.npoints);
    }

    public static void setDefaultArrowHeadLength(int n) {
        _iDefaultArrowHeadLength = n;
    }

    public static int getDefaultArrowHeadLength() {
        return _iDefaultArrowHeadLength;
    }

    public static void setDefaultArrowHeadWidth(int n) {
        _iDefaultArrowHeadWidth = n;
    }

    public static int getDefaultArrowHeadWidth() {
        return _iDefaultArrowHeadWidth;
    }

    public void setFlatness(double d) {
        this._dFlatness = d;
    }

    public double getFlatness() {
        return this._dFlatness;
    }

    public void setContainment(double d) {
        this.dContainment = d;
    }

    public double getContainment() {
        return this.dContainment;
    }

    public void setSubdivideCount(int n) {
        this._iSubdivideCount = n;
    }

    public int getSubdivideCount() {
        return this._iSubdivideCount;
    }

    public void setArrowHeadFill(boolean bl) {
        this._zArrowHeadFill = bl;
    }

    public boolean getArrowHeadFill() {
        return this._zArrowHeadFill;
    }

    public void setColorArrowHeadFill(Color color) {
        this._colorArrowHeadFill = color;
    }

    public Color getColorArrowHeadFill() {
        return this._colorArrowHeadFill;
    }

    public void setArrowHeadStroke(boolean bl) {
        this._zArrowHeadStroke = bl;
    }

    public boolean getArrowHeadStroke() {
        return this._zArrowHeadStroke;
    }

    public void setColorArrowHeadStroke(Color color) {
        this._colorArrowHeadStroke = color;
    }

    public Color getColorArrowHeadStroke() {
        return this._colorArrowHeadStroke;
    }

    protected void drawEdge(Edge edge, Graphics graphics) {
        this._draw(null, edge, graphics);
    }

    protected void drawEdge(Net net, Edge edge, Graphics graphics) {
        this._draw(net, edge, graphics);
    }

    protected Rectangle getBoundsEdge(Edge edge) throws NotDrawableException {
        return this._getBounds(null, edge);
    }

    protected Rectangle getBoundsEdge(Net net, Edge edge) throws NotDrawableException {
        return this._getBounds(net, edge);
    }

    protected Dimension getSizeEdge(Edge edge) throws NotDrawableException {
        return this._getSize(null, edge);
    }

    protected Dimension getSizeEdge(Net net, Edge edge) throws NotDrawableException {
        return this._getSize(net, edge);
    }

    protected boolean containsEdge(Edge edge, int n, int n2) {
        return this._contains(null, edge, n, n2);
    }

    protected boolean containsEdge(Net net, Edge edge, int n, int n2) {
        return this._contains(net, edge, n, n2);
    }

    private void _draw(Net net, Edge edge, Graphics graphics) {
        if (this.zVisible) {
            Color color;
            block7: {
                color = graphics.getColor();
                try {
                    Graphics2D graphics2D;
                    EdgeEnds edgeEnds = this._getEdgeEnds(net, edge);
                    graphics.setColor(this.colorPath);
                    CubicCurve2D.Double double_ = this._getShape(edgeEnds);
                    try {
                        graphics2D = (Graphics2D)graphics;
                    }
                    catch (ClassCastException classCastException) {
                        System.err.println(this._drawMethod(net, edge, graphics) + " This edge-drawable class can only be used with Java components that use Graphics2D, such as Swing components.");
                        return;
                    }
                    graphics2D.draw(double_);
                    CubicCurve2D.Double double_2 = new CubicCurve2D.Double();
                    CubicCurve2D.Double double_3 = new CubicCurve2D.Double();
                    double_.subdivide(double_2, double_3);
                    this.pointArrow = double_2.getP2();
                    float f = (edgeEnds.pointTo.x + (int)this.pointArrow.getX()) / 2 - edgeEnds.pointFrom.x;
                    float f2 = (edgeEnds.pointTo.y + (int)this.pointArrow.getY()) / 2 - edgeEnds.pointFrom.y;
                    double d = Math.atan2(f2, f);
                    PolygonUtil.rotate_translate(this._polygonPath, d, (int)this.pointArrow.getX(), (int)this.pointArrow.getY(), this._polygonPathTransformed);
                    if (this._zArrowHeadFill && this._colorArrowHeadFill != null) {
                        graphics.setColor(this._colorArrowHeadFill);
                        graphics.fillPolygon(this._polygonPathTransformed);
                    }
                    if (this._zArrowHeadStroke && this._colorArrowHeadStroke != null) {
                        graphics.setColor(this._colorArrowHeadStroke);
                        graphics.drawPolygon(this._polygonPathTransformed);
                    }
                }
                catch (NotDrawableException notDrawableException) {
                    if (this.iVerbose <= 0) break block7;
                    System.out.println(this._drawMethod(net, edge, graphics) + "Edge not drawable.");
                }
            }
            graphics.setColor(color);
        }
    }

    private String _drawMethod(Net net, Edge edge, Graphics graphics) {
        return "[" + strClassName + "._draw(Net," + edge + ",Graphics)]";
    }

    private Rectangle _getBounds(Net net, Edge edge) throws NotDrawableException {
        EdgeEnds edgeEnds = this._getEdgeEnds(net, edge);
        Rectangle2D rectangle2D = this._getShape(edgeEnds).getBounds2D();
        Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        rectangle.add(edgeEnds.pointTo.x, edgeEnds.pointTo.y);
        return rectangle;
    }

    private Dimension _getSize(Net net, Edge edge) throws NotDrawableException {
        Rectangle rectangle = this._getBounds(net, edge);
        try {
            return new Dimension(rectangle.width, rectangle.height);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("[" + strClassName + "] Edge (" + edge + ") has either or both end vertices without a location.  Size can not be determined.");
            return null;
        }
    }

    private boolean _contains(Net net, Edge edge, int n, int n2) {
        if (this.zVisible) {
            try {
                EdgeEnds edgeEnds = this._getEdgeEnds(net, edge);
                CubicCurve2D.Double double_ = this._getShape(edgeEnds);
                int n3 = 1;
                int n4 = 0;
                while (n4 < this._iSubdivideCount) {
                    n3 *= 2;
                    ++n4;
                }
                CubicCurve2D[] cubicCurve2DArray = new CubicCurve2D[n3];
                int n5 = 0;
                while (n5 < n3) {
                    cubicCurve2DArray[n5] = new CubicCurve2D.Double();
                    ++n5;
                }
                this._subdivide(double_, cubicCurve2DArray, 0, n3 / 2);
                int n6 = 0;
                while (n6 < n3) {
                    if (cubicCurve2DArray[n6].intersects((double)n - this.dContainment, (double)n2 - this.dContainment, this.dContainment * 2.0, this.dContainment * 2.0)) {
                        return true;
                    }
                    ++n6;
                }
            }
            catch (NotDrawableException notDrawableException) {
                System.out.println("[" + strClassName + "] Edge (" + edge + ") has either or both end vertices without a location.  Edge not drawn.");
            }
        }
        return false;
    }

    private EdgeEnds _getEdgeEnds(Net net, Edge edge) throws NotDrawableException {
        EdgeEnds edgeEnds = new EdgeEnds();
        edgeEnds.vertexFrom = edge.getFromVertex();
        edgeEnds.vertexTo = edge.getToVertex();
        if (net != null) {
            edgeEnds.pointFrom = edgeEnds.vertexFrom.getLocation(net);
            edgeEnds.pointTo = edgeEnds.vertexTo.getLocation(net);
        } else {
            edgeEnds.pointFrom = edgeEnds.vertexFrom.getLocation();
            edgeEnds.pointTo = edgeEnds.vertexTo.getLocation();
        }
        return edgeEnds;
    }

    private double _distanceBetweenTwoPoints(int n, int n2, int n3, int n4) {
        return Math.sqrt((n4 - n2) * (n4 - n2) + (n3 - n) * (n3 - n));
    }

    private CubicCurve2D.Double _getShape(EdgeEnds edgeEnds) {
        CubicCurve2D.Double double_ = new CubicCurve2D.Double();
        double_.x1 = edgeEnds.pointFrom.x;
        double_.y1 = edgeEnds.pointFrom.y;
        double_.x2 = edgeEnds.pointTo.x;
        double_.y2 = edgeEnds.pointTo.y;
        double_.ctrlx1 = (double_.x2 + double_.x1) / 2.0;
        double_.ctrly1 = (double_.y2 + double_.y1) / 2.0;
        double d = this._distanceBetweenTwoPoints(edgeEnds.pointFrom.x, edgeEnds.pointFrom.y, edgeEnds.pointTo.x, edgeEnds.pointTo.y);
        double d2 = this._dFlatness * (double)(edgeEnds.pointTo.y - edgeEnds.pointFrom.y) / d;
        double d3 = this._dFlatness * (double)(edgeEnds.pointTo.x - edgeEnds.pointFrom.x) / d;
        double_.ctrlx1 -= d2;
        double_.ctrly1 += d3;
        double_.ctrlx2 = double_.ctrlx1;
        double_.ctrly2 = double_.ctrly1;
        return double_;
    }

    private void _subdivide(CubicCurve2D cubicCurve2D, CubicCurve2D[] cubicCurve2DArray, int n, int n2) {
        cubicCurve2D.subdivide(cubicCurve2DArray[n], cubicCurve2DArray[n2]);
        if (n2 - n <= 1) {
            return;
        }
        this._subdivide(cubicCurve2DArray[n], cubicCurve2DArray, n, n + (n2 - n) / 2);
        this._subdivide(cubicCurve2DArray[n2], cubicCurve2DArray, n2, n2 + (n2 - n) / 2);
    }

    private class EdgeEnds {
        public Vertex vertexFrom;
        public Vertex vertexTo;
        public Point pointFrom;
        public Point pointTo;

        private EdgeEnds() {
        }
    }
}

