/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.Edge;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw2EdgePath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Rectangle2D;

public class Draw2EdgeParabola
extends Draw2EdgePath {
    private static int _iDefaultArrowHeadLength = 20;
    private static int _iDefaultArrowHeadWidth = 12;
    private double _dFlatness = 0.0;
    double dContainment = 3.0;
    int _iSubdivideCount = 1;
    private static String strClassName = "Draw2EdgeParabola";

    public Draw2EdgeParabola() {
        this(0.0);
    }

    public Draw2EdgeParabola(double d) {
        this._dFlatness = d;
    }

    private boolean _contains(Net net, Edge edge, int n, int n2) {
        block6: {
            if (!this.zVisible) break block6;
            try {
                EdgeEnds edgeEnds = this._getEdgeEnds(net, edge);
                CubicCurve2D.Double double_ = this._getShape(edgeEnds);
                int n3 = 1;
                int n4 = 0;
                while (n4 < this._iSubdivideCount) {
                    n3 *= 2;
                    ++n4;
                }
                CubicCurve2D[] cubicCurve2DArray = new CubicCurve2D[n3];
                int n5 = 0;
                while (n5 < n3) {
                    cubicCurve2DArray[n5] = new CubicCurve2D.Double();
                    ++n5;
                }
                this._subdivide(double_, cubicCurve2DArray, 0, n3 / 2);
                int n6 = 0;
                while (n6 < n3) {
                    if (cubicCurve2DArray[n6].intersects((double)n - this.dContainment, (double)n2 - this.dContainment, this.dContainment * 2.0, this.dContainment * 2.0)) {
                        return true;
                    }
                    ++n6;
                }
            }
            catch (NotDrawableException notDrawableException) {
                System.out.println("[" + strClassName + "] Edge (" + edge + ") has either or both end vertices without a location.  Edge not drawn.");
            }
        }
        return false;
    }

    private double _distanceBetweenTwoPoints(int n, int n2, int n3, int n4) {
        return Math.sqrt((n4 - n2) * (n4 - n2) + (n3 - n) * (n3 - n));
    }

    private void _draw(Net net, Edge edge, Graphics graphics) {
        if (this.zVisible) {
            Color color;
            block3: {
                color = graphics.getColor();
                try {
                    EdgeEnds edgeEnds = this._getEdgeEnds(net, edge);
                    graphics.setColor(this.colorPath);
                    CubicCurve2D.Double double_ = this._getShape(edgeEnds);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.draw(double_);
                }
                catch (NotDrawableException notDrawableException) {
                    if (this.iVerbose <= 0) break block3;
                    System.out.println("[" + strClassName + "._draw(Net," + edge + ",Graphics)] Edge not drawable.");
                }
            }
            graphics.setColor(color);
        }
    }

    private Rectangle _getBounds(Net net, Edge edge) throws NotDrawableException {
        EdgeEnds edgeEnds = this._getEdgeEnds(net, edge);
        Rectangle2D rectangle2D = this._getShape(edgeEnds).getBounds2D();
        Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        rectangle.add(edgeEnds.pointTo.x, edgeEnds.pointTo.y);
        return rectangle;
    }

    private EdgeEnds _getEdgeEnds(Net net, Edge edge) throws NotDrawableException {
        EdgeEnds edgeEnds = new EdgeEnds();
        edgeEnds.vertexFrom = edge.getFromVertex();
        edgeEnds.vertexTo = edge.getToVertex();
        if (net != null) {
            edgeEnds.pointFrom = edgeEnds.vertexFrom.getLocation(net);
            edgeEnds.pointTo = edgeEnds.vertexTo.getLocation(net);
        } else {
            edgeEnds.pointFrom = edgeEnds.vertexFrom.getLocation();
            edgeEnds.pointTo = edgeEnds.vertexTo.getLocation();
        }
        return edgeEnds;
    }

    private CubicCurve2D.Double _getShape(EdgeEnds edgeEnds) {
        CubicCurve2D.Double double_ = new CubicCurve2D.Double();
        double_.x1 = edgeEnds.pointFrom.x;
        double_.y1 = edgeEnds.pointFrom.y;
        double_.x2 = edgeEnds.pointTo.x;
        double_.y2 = edgeEnds.pointTo.y;
        double_.ctrlx1 = (double_.x2 + double_.x1) / 2.0;
        double_.ctrly1 = (double_.y2 + double_.y1) / 2.0;
        double d = this._distanceBetweenTwoPoints(edgeEnds.pointFrom.x, edgeEnds.pointFrom.y, edgeEnds.pointTo.x, edgeEnds.pointTo.y);
        double d2 = this._dFlatness * (double)(edgeEnds.pointTo.y - edgeEnds.pointFrom.y) / d;
        double d3 = this._dFlatness * (double)(edgeEnds.pointTo.x - edgeEnds.pointFrom.x) / d;
        double_.ctrlx1 -= d2;
        double_.ctrly1 += d3;
        double_.ctrlx2 = double_.ctrlx1;
        double_.ctrly2 = double_.ctrly1;
        return double_;
    }

    private Dimension _getSize(Net net, Edge edge) throws NotDrawableException {
        Rectangle rectangle = this._getBounds(net, edge);
        try {
            return new Dimension(rectangle.width, rectangle.height);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("[" + strClassName + "] Edge (" + edge + ") has either or both end vertices without a location.  Size can not be determined.");
            return null;
        }
    }

    private void _subdivide(CubicCurve2D cubicCurve2D, CubicCurve2D[] cubicCurve2DArray, int n, int n2) {
        cubicCurve2D.subdivide(cubicCurve2DArray[n], cubicCurve2DArray[n2]);
        if (n2 - n <= 1) {
            return;
        }
        this._subdivide(cubicCurve2DArray[n], cubicCurve2DArray, n, n + (n2 - n) / 2);
        this._subdivide(cubicCurve2DArray[n2], cubicCurve2DArray, n2, n2 + (n2 - n) / 2);
    }

    protected boolean containsEdge(Edge edge, int n, int n2) {
        return this._contains(null, edge, n, n2);
    }

    protected boolean containsEdge(Net net, Edge edge, int n, int n2) {
        return this._contains(net, edge, n, n2);
    }

    protected void drawEdge(Edge edge, Graphics graphics) {
        this._draw(null, edge, graphics);
    }

    protected void drawEdge(Net net, Edge edge, Graphics graphics) {
        this._draw(net, edge, graphics);
    }

    protected Rectangle getBoundsEdge(Edge edge) throws NotDrawableException {
        return this._getBounds(null, edge);
    }

    protected Rectangle getBoundsEdge(Net net, Edge edge) throws NotDrawableException {
        return this._getBounds(net, edge);
    }

    public double getContainment() {
        return this.dContainment;
    }

    public static int getDefaultArrowHeadLength() {
        return _iDefaultArrowHeadLength;
    }

    public static int getDefaultArrowHeadWidth() {
        return _iDefaultArrowHeadWidth;
    }

    public double getFlatness() {
        return this._dFlatness;
    }

    protected Dimension getSizeEdge(Edge edge) throws NotDrawableException {
        return this._getSize(null, edge);
    }

    protected Dimension getSizeEdge(Net net, Edge edge) throws NotDrawableException {
        return this._getSize(net, edge);
    }

    public int getSubdivideCount() {
        return this._iSubdivideCount;
    }

    public void setContainment(double d) {
        this.dContainment = d;
    }

    public static void setDefaultArrowHeadLength(int n) {
        _iDefaultArrowHeadLength = n;
    }

    public static void setDefaultArrowHeadWidth(int n) {
        _iDefaultArrowHeadWidth = n;
    }

    public void setFlatness(double d) {
        this._dFlatness = d;
    }

    public void setSubdivideCount(int n) {
        this._iSubdivideCount = n;
    }

    private class EdgeEnds {
        public Vertex vertexFrom;
        public Vertex vertexTo;
        public Point pointFrom;
        public Point pointTo;

        EdgeEnds() {
        }
    }
}

