/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.Edge;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw2EdgePath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class Draw2EdgeLoopEllipse
extends Draw2EdgePath {
    private static final String strClassName = "Draw2EdgeLoopEllipse";
    private int _iEllipseWidth = 50;
    private int _iEllipseHeight = 25;

    private boolean _contains(Net net, Edge edge, int n, int n2) {
        if (this.zVisible) {
            try {
                LoopEnd loopEnd = this._getLoopEnd(net, edge);
                if (!this.getBounds(net, edge).contains(n, n2)) {
                    return false;
                }
            }
            catch (NotDrawableException notDrawableException) {
                System.out.println("[Draw2EdgeLoopEllipse] Edge (" + edge + ") has either or both end vertices without a location.  Edge not drawn.");
                return false;
            }
            return true;
        }
        return false;
    }

    private void _draw(Net net, Edge edge, Graphics graphics) {
        if (this.zVisible) {
            Color color;
            block3: {
                color = graphics.getColor();
                try {
                    LoopEnd loopEnd = this._getLoopEnd(net, edge);
                    graphics.setColor(this.colorPath);
                    graphics.drawArc(loopEnd.point.x, loopEnd.point.y - (this._iEllipseHeight >> 1), this._iEllipseWidth, this._iEllipseHeight, 0, 360);
                }
                catch (NotDrawableException notDrawableException) {
                    if (this.iVerbose <= 0) break block3;
                    System.out.println(notDrawableException);
                }
            }
            graphics.setColor(color);
        }
    }

    private Rectangle _getBounds(Net net, Edge edge) throws NotDrawableException {
        LoopEnd loopEnd = this._getLoopEnd(net, edge);
        Rectangle rectangle = new Rectangle(loopEnd.point.x, loopEnd.point.y - (this._iEllipseHeight >> 1), this._iEllipseWidth, this._iEllipseHeight);
        return rectangle;
    }

    private LoopEnd _getLoopEnd(Net net, Edge edge) throws NotDrawableException {
        LoopEnd loopEnd = new LoopEnd();
        loopEnd.vertex = edge.getFromVertex();
        if (loopEnd.vertex != edge.getToVertex()) {
            throw new NotDrawableException("[Draw2EdgeLoopEllipse] Edge (" + edge + ") is not a loop.");
        }
        loopEnd.point = net != null ? loopEnd.vertex.getLocation(net) : loopEnd.vertex.getLocation();
        return loopEnd;
    }

    private Dimension _getSize(Net net, Edge edge) throws NotDrawableException {
        Rectangle rectangle = this._getBounds(net, edge);
        try {
            return new Dimension(rectangle.width, rectangle.height);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("[Draw2EdgeLoopEllipse] Edge (" + edge + ") has either or both end vertices without a location.  Size can not be determined.");
            return null;
        }
    }

    protected boolean containsEdge(Edge edge, int n, int n2) {
        return this._contains(null, edge, n, n2);
    }

    protected boolean containsEdge(Net net, Edge edge, int n, int n2) {
        return this._contains(net, edge, n, n2);
    }

    protected void drawEdge(Edge edge, Graphics graphics) {
        this._draw(null, edge, graphics);
    }

    protected void drawEdge(Net net, Edge edge, Graphics graphics) {
        this._draw(net, edge, graphics);
    }

    protected Rectangle getBoundsEdge(Edge edge) throws NotDrawableException {
        return this._getBounds(null, edge);
    }

    protected Rectangle getBoundsEdge(Net net, Edge edge) throws NotDrawableException {
        return this._getBounds(net, edge);
    }

    public int getEllipseHeight() {
        return this._iEllipseHeight;
    }

    public int getEllipseWidth() {
        return this._iEllipseWidth;
    }

    protected Dimension getSizeEdge(Edge edge) throws NotDrawableException {
        return this._getSize(null, edge);
    }

    protected Dimension getSizeEdge(Net net, Edge edge) throws NotDrawableException {
        return this._getSize(net, edge);
    }

    public void setEllipseSize(int n, int n2) {
        this._iEllipseWidth = n;
        this._iEllipseHeight = n2;
    }

    private class LoopEnd {
        public Vertex vertex;
        public Point point;

        LoopEnd() {
        }
    }
}

