/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.Edge;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw2EdgePath;
import com.ibm.research.geometry.Line;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class Draw2EdgeLine
extends Draw2EdgePath {
    double dContainment = 3.0;
    private static String strClassName = "Draw2EdgeLine";

    private boolean _contains(Net net, Edge edge, int n, int n2) {
        if (this.zVisible) {
            EdgeEnds edgeEnds;
            try {
                edgeEnds = this._getEdgeEnds(net, edge);
                if (!this.getBounds(net, edge).contains(n, n2)) {
                    return false;
                }
            }
            catch (NotDrawableException notDrawableException) {
                System.out.println("[" + strClassName + "] Edge (" + edge + ") has either or both end vertices without a location.  Edge not drawn.");
                return false;
            }
            Point point = new Point(n, n2);
            if (Math.abs(Line.getDistance(edgeEnds.pointFrom, edgeEnds.pointTo, point)) < this.dContainment) {
                return true;
            }
        }
        return false;
    }

    private void _draw(Net net, Edge edge, Graphics graphics) {
        if (this.zVisible) {
            Color color;
            block3: {
                color = graphics.getColor();
                try {
                    EdgeEnds edgeEnds = this._getEdgeEnds(net, edge);
                    graphics.setColor(this.colorPath);
                    graphics.drawLine(edgeEnds.pointFrom.x, edgeEnds.pointFrom.y, edgeEnds.pointTo.x, edgeEnds.pointTo.y);
                }
                catch (NotDrawableException notDrawableException) {
                    if (this.iVerbose <= 0) break block3;
                    System.out.println("[" + strClassName + "._draw(Net," + edge + ",Graphics)] Edge not drawable.");
                }
            }
            graphics.setColor(color);
        }
    }

    private Rectangle _getBounds(Net net, Edge edge) throws NotDrawableException {
        EdgeEnds edgeEnds = this._getEdgeEnds(net, edge);
        Rectangle rectangle = new Rectangle(edgeEnds.pointFrom.x - 1, edgeEnds.pointFrom.y - 1, 2, 2);
        rectangle.add(edgeEnds.pointTo.x, edgeEnds.pointTo.y);
        return rectangle;
    }

    private EdgeEnds _getEdgeEnds(Net net, Edge edge) throws NotDrawableException {
        EdgeEnds edgeEnds = new EdgeEnds();
        edgeEnds.vertexFrom = edge.getFromVertex();
        edgeEnds.vertexTo = edge.getToVertex();
        if (net != null) {
            edgeEnds.pointFrom = edgeEnds.vertexFrom.getLocation(net);
            edgeEnds.pointTo = edgeEnds.vertexTo.getLocation(net);
        } else {
            edgeEnds.pointFrom = edgeEnds.vertexFrom.getLocation();
            edgeEnds.pointTo = edgeEnds.vertexTo.getLocation();
        }
        return edgeEnds;
    }

    private Dimension _getSize(Net net, Edge edge) throws NotDrawableException {
        Rectangle rectangle = this._getBounds(net, edge);
        try {
            return new Dimension(rectangle.width, rectangle.height);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("[" + strClassName + "] Edge (" + edge + ") has either or both end vertices without a location.  Size can not be determined.");
            return null;
        }
    }

    protected boolean containsEdge(Edge edge, int n, int n2) {
        return this._contains(null, edge, n, n2);
    }

    protected boolean containsEdge(Net net, Edge edge, int n, int n2) {
        return this._contains(net, edge, n, n2);
    }

    protected void drawEdge(Edge edge, Graphics graphics) {
        this._draw(null, edge, graphics);
    }

    protected void drawEdge(Net net, Edge edge, Graphics graphics) {
        this._draw(net, edge, graphics);
    }

    protected Rectangle getBoundsEdge(Edge edge) throws NotDrawableException {
        return this._getBounds(null, edge);
    }

    protected Rectangle getBoundsEdge(Net net, Edge edge) throws NotDrawableException {
        return this._getBounds(net, edge);
    }

    public double getContainment() {
        return this.dContainment;
    }

    protected Dimension getSizeEdge(Edge edge) throws NotDrawableException {
        return this._getSize(null, edge);
    }

    protected Dimension getSizeEdge(Net net, Edge edge) throws NotDrawableException {
        return this._getSize(net, edge);
    }

    public void setContainment(double d) {
        this.dContainment = d;
    }

    private class EdgeEnds {
        public Vertex vertexFrom;
        public Vertex vertexTo;
        public Point pointFrom;
        public Point pointTo;

        EdgeEnds() {
        }
    }
}

