/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.awt;

import com.ibm.graph.GraphGroup;
import com.ibm.graph.Net;
import com.ibm.graph.awt.GraphGroupCanvas;
import com.ibm.graph.draw.DrawNet;
import com.ibm.research.util.ObservableOutOfMemoryError;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Observer;

public class GraphGroupCanvasDoubleBuffered
extends GraphGroupCanvas {
    private Dimension _dimMinimumSize = null;
    private static final String _strClassName = "GraphGroupCanvasDoubleBuffered";
    private Rectangle _rectBounds;
    private boolean _zBoundsChanged = true;
    private boolean _hasListeners = false;
    private boolean _zValid = false;
    private int iVerbose = 0;
    private int _iGraphCanvasSizeMarginRange = 100;
    private int _iGraphCanvasSizeMarginRangeHalf = 50;
    private Image imageOffscreen = null;
    private int iWidthOffscreen;
    private int iHeightOffscreen;
    private ObservableOutOfMemoryError observableOutOfMemoryError = new ObservableOutOfMemoryError(this);

    public GraphGroupCanvasDoubleBuffered() {
    }

    public GraphGroupCanvasDoubleBuffered(GraphGroup graphGroup) {
        super(graphGroup);
    }

    public GraphGroupCanvasDoubleBuffered(Net net) {
        super(net);
    }

    private boolean _needsNewOffscreenBuffer() {
        return this.imageOffscreen == null || this.getSize().width != this.iWidthOffscreen || this.getSize().height != this.iHeightOffscreen;
    }

    private void _validate(GraphGroup graphGroup) {
        int n = 0;
        int n2 = 0;
        if (this._rectBounds.x < 0 || this._rectBounds.x > this._iGraphCanvasSizeMarginRange) {
            n = this._iGraphCanvasSizeMarginRangeHalf - this._rectBounds.x;
        }
        if (this._rectBounds.y < 0 || this._rectBounds.y > this._iGraphCanvasSizeMarginRange) {
            n2 = this._iGraphCanvasSizeMarginRangeHalf - this._rectBounds.y;
        }
        if (n != 0 || n2 != 0) {
            Enumeration enumeration = graphGroup.elements();
            while (enumeration.hasMoreElements()) {
                Net net = (Net)enumeration.nextElement();
                DrawNet.translate(net, (int)((double)n), (int)((double)n2));
            }
            this._rectBounds = graphGroup.getBounds();
            this._zBoundsChanged = true;
        }
        if (this._dimMinimumSize != null) {
            this.setSize(Math.max(this._rectBounds.width + this._iGraphCanvasSizeMarginRange * 2, this._dimMinimumSize.width), Math.max(this._rectBounds.height + this._iGraphCanvasSizeMarginRange * 2, this._dimMinimumSize.height));
        } else {
            this.setSize(this._rectBounds.width + this._iGraphCanvasSizeMarginRange * 2, this._rectBounds.height + this._iGraphCanvasSizeMarginRange * 2);
        }
    }

    public void addOutOfMemoryErrorObserver(Observer observer) {
        this.observableOutOfMemoryError.addObserver(observer);
    }

    public void deleteOutOfMemoryErrorObserver(Observer observer) {
        this.observableOutOfMemoryError.deleteObserver(observer);
    }

    public int getGraphCanvasSizeMarginRange() {
        return this._iGraphCanvasSizeMarginRange;
    }

    public Dimension getMinimumSize() {
        if (this._dimMinimumSize == null) {
            return super.getMinimumSize();
        }
        return this._dimMinimumSize;
    }

    public void invalidate() {
        super.invalidate();
        this._zValid = false;
    }

    public void paint(Graphics graphics) {
        if (this._needsNewOffscreenBuffer()) {
            this.iWidthOffscreen = this.getSize().width;
            this.iHeightOffscreen = this.getSize().height;
            if (this.iWidthOffscreen != 0 && this.iHeightOffscreen != 0) {
                try {
                    Image image = this.createImage(this.iWidthOffscreen, this.iHeightOffscreen);
                    this.paintGraphGroup(image);
                    this.imageOffscreen = image;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.observableOutOfMemoryError.setOutOfMemoryError(outOfMemoryError);
                }
            } else {
                this.imageOffscreen = null;
            }
        }
        if (this.imageOffscreen != null) {
            if (this._zBoundsChanged) {
                this.paintGraphGroup(this.imageOffscreen);
                this._zBoundsChanged = false;
            }
            graphics.drawImage(this.imageOffscreen, 0, 0, this);
        }
    }

    private void paintGraphGroup(Image image) {
        Graphics graphics = image.getGraphics();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.iWidthOffscreen, this.iHeightOffscreen);
        Enumeration enumeration = this.graphGroup.elements();
        while (enumeration.hasMoreElements()) {
            Net net;
            Net net2 = net = (Net)enumeration.nextElement();
            synchronized (net2) {
                net.draw(net, image.getGraphics());
            }
        }
    }

    public void repaintGraphGroup() {
        this.paintGraphGroup(this.imageOffscreen);
    }

    public void setGraphCanvasSizeMarginRange(int n) {
        this._iGraphCanvasSizeMarginRange = n;
        this._iGraphCanvasSizeMarginRangeHalf = n >> 1;
    }

    public void setMinimumSize(Dimension dimension) {
        this._dimMinimumSize = dimension;
    }

    public void validate() {
        if (this._zValid) {
            return;
        }
        super.validate();
        this._rectBounds = this.graphGroup.getBounds();
        this._validate(this.graphGroup);
        this._zValid = true;
    }
}

