/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.awt;

import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.awt.GraphCanvas;
import com.ibm.graph.draw.DrawNet;
import com.ibm.research.util.ObservableOutOfMemoryError;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.EmptyStackException;
import java.util.Observer;
import java.util.Stack;

public class GraphCanvasDoubleBuffered
extends GraphCanvas {
    private Dimension _dimMinimumSize = null;
    private static final String _$strClassName = "GraphCanvasDoubleBuffered";
    private Rectangle _rectBounds;
    private boolean _zBoundsChanged = true;
    private boolean _hasListeners = false;
    private boolean _zValid = false;
    private int _iGraphCanvasSizeMarginRange = 100;
    private int _iGraphCanvasSizeMarginRangeHalf = 50;
    private Image imageOffscreen = null;
    private int iWidthOffscreen;
    private int iHeightOffscreen;
    private ObservableOutOfMemoryError observableOutOfMemoryError = new ObservableOutOfMemoryError(this);
    private int _iVerbose = 0;

    public GraphCanvasDoubleBuffered() {
    }

    public GraphCanvasDoubleBuffered(Net net) {
        super(net);
    }

    private boolean _needsNewOffscreenBuffer() {
        return this.imageOffscreen == null || this.getSize().width != this.iWidthOffscreen || this.getSize().height != this.iHeightOffscreen;
    }

    private void _validate(Net net) {
        block11: {
            if (this._iVerbose > 0) {
                System.out.println("[GraphCanvasDoubleBuffered._validate(Net)]{");
            }
            if (this._iVerbose > 0) {
                System.out.println("\tbounds = " + this._rectBounds);
            }
            if (this._iGraphCanvasSizeMarginRange > 0) {
                int n = 0;
                int n2 = 0;
                try {
                    if (this._rectBounds.x < 0 || this._rectBounds.x > this._iGraphCanvasSizeMarginRange) {
                        n = this._iGraphCanvasSizeMarginRangeHalf - this._rectBounds.x;
                    }
                    if (this._rectBounds.y < 0 || this._rectBounds.y > this._iGraphCanvasSizeMarginRange) {
                        n2 = this._iGraphCanvasSizeMarginRangeHalf - this._rectBounds.y;
                    }
                    if (n != 0 || n2 != 0) {
                        DrawNet.translate(net, (int)((double)n), (int)((double)n2));
                        this._rectBounds = net.getBounds();
                        this._zBoundsChanged = true;
                    }
                    if (this._dimMinimumSize != null) {
                        this.setSize(Math.max(this._rectBounds.width + this._iGraphCanvasSizeMarginRange * 2, this._dimMinimumSize.width), Math.max(this._rectBounds.height + this._iGraphCanvasSizeMarginRange * 2, this._dimMinimumSize.height));
                        break block11;
                    }
                    this.setSize(this._rectBounds.width + this._iGraphCanvasSizeMarginRange * 2, this._rectBounds.height + this._iGraphCanvasSizeMarginRange * 2);
                }
                catch (NotDrawableException notDrawableException) {
                    System.out.println("??[GraphCanvasDoubleBuffered] Not drawable exception.");
                }
            } else {
                Dimension dimension = this.getSize();
                this.setSize(Math.max(dimension.width, Math.max(0, this._rectBounds.x) + this._rectBounds.width + 1), Math.max(dimension.height, Math.max(0, this._rectBounds.y) + this._rectBounds.height + 1));
            }
        }
        if (this._iVerbose > 0) {
            System.out.println("[GraphCanvasDoubleBuffered._validate(Net)]}");
        }
    }

    public void addOutOfMemoryErrorObserver(Observer observer) {
        this.observableOutOfMemoryError.addObserver(observer);
    }

    public void deleteOutOfMemoryErrorObserver(Observer observer) {
        this.observableOutOfMemoryError.deleteObserver(observer);
    }

    public int getGraphCanvasSizeMarginRange() {
        return this._iGraphCanvasSizeMarginRange;
    }

    public Dimension getMinimumSize() {
        if (this._dimMinimumSize == null) {
            return super.getMinimumSize();
        }
        return this._dimMinimumSize;
    }

    public Image getOffscreenImage() {
        return this.imageOffscreen;
    }

    public void invalidate() {
        super.invalidate();
        this._zValid = false;
    }

    public void paint(Graphics graphics) {
        block12: {
            if (this._iVerbose > 0) {
                System.out.println("[GraphCanvasDoubleBuffered.paint(Graphics)]{");
                System.out.println("\tthis.getSize() " + this.getSize());
            }
            if (this._needsNewOffscreenBuffer()) {
                this.iWidthOffscreen = this.getSize().width;
                this.iHeightOffscreen = this.getSize().height;
                if (this._iVerbose > 0) {
                    System.out.println("\tiWidthOffscreen  = " + this.iWidthOffscreen);
                    System.out.println("\tiHeightOffscreen = " + this.iHeightOffscreen);
                }
                if (this.iWidthOffscreen != 0 && this.iHeightOffscreen != 0) {
                    try {
                        Image image = this.createImage(this.iWidthOffscreen, this.iHeightOffscreen);
                        if (this._iVerbose > 0) {
                            System.out.println("\tcreated new imageNewOffscreen " + image);
                        }
                        if (image != null) {
                            this.paintGraph(image);
                            this.imageOffscreen = image;
                            break block12;
                        }
                        System.err.println("[GraphCanvasDoubleBuffered.paint(Graphics)] Unable to create an image.");
                        super.paint(graphics);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        System.err.println("[GraphCanvasDoubleBuffered.paint(Graphics)] Out of memory error for image(" + this.iWidthOffscreen + "," + this.iHeightOffscreen + ")");
                        this.observableOutOfMemoryError.setOutOfMemoryError(outOfMemoryError);
                    }
                } else {
                    this.imageOffscreen = null;
                }
            }
        }
        if (this.imageOffscreen != null) {
            if (this._zBoundsChanged) {
                this.paintGraph(this.imageOffscreen);
                this._zBoundsChanged = false;
            }
            graphics.drawImage(this.imageOffscreen, 0, 0, this);
        }
        if (this._iVerbose > 1) {
            System.out.println("[GraphCanvasDoubleBuffered.paint(Graphics)]}");
        }
    }

    private void paintGraph(Image image) {
        if (this._iVerbose > 0) {
            System.out.println("[GraphCanvasDoubleBuffered.paintGraph(Image)]{");
        }
        if (this._iVerbose > 0) {
            System.out.println(image == null ? "\timage is null" : "\timage is not null");
        }
        Graphics graphics = image.getGraphics();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.iWidthOffscreen, this.iHeightOffscreen);
        if (this.getGraph() != null) {
            Net net = this.getGraph();
            synchronized (net) {
                super.paint(image.getGraphics());
            }
        }
        if (this._iVerbose > 0) {
            System.out.println("[GraphCanvasDoubleBuffered.paintGraph(Image)]}");
        }
    }

    public void repaintGraph() {
        this.paintGraph(this.imageOffscreen);
    }

    public void setGraphCanvasSizeMarginRange(int n) {
        this._iGraphCanvasSizeMarginRange = n;
        this._iGraphCanvasSizeMarginRangeHalf = n >> 1;
    }

    public void setMinimumSize(Dimension dimension) {
        this._dimMinimumSize = dimension;
    }

    public void setVerboseStack(Stack stack) {
        Object e;
        if (stack == null || stack.empty()) {
            return;
        }
        try {
            e = stack.pop();
        }
        catch (EmptyStackException emptyStackException) {
            return;
        }
        try {
            this._iVerbose = (Integer)e;
        }
        catch (ClassCastException classCastException) {
            System.out.println("[GraphCanvasDoubleBuffered.setVerboseStack(Stack)] Object (" + e + ") popped from the stack is not an Integer object.");
            return;
        }
    }

    public void validate() {
        block11: {
            if (this._iVerbose > 0) {
                System.out.println("[GraphCanvasDoubleBuffered.validate()]{");
                System.out.println("\tthis.getSize() " + this.getSize());
            }
            if (this._zValid) {
                if (this._iVerbose > 0) {
                    System.out.println("[GraphCanvasDoubleBuffered.validate()]} Valid; nothing to validate.");
                }
                return;
            }
            super.validate();
            try {
                Net net = this.getGraph();
                if (net == null) {
                    if (this._iVerbose > 0) {
                        System.out.println("[GraphCanvasDoubleBuffered.validate()]} Null net; nothing to validate.");
                    }
                    return;
                }
                this._rectBounds = net.getBounds();
                if (this._iVerbose > 0) {
                    System.out.println("\t_rectBounds = " + this._rectBounds);
                }
                this._zBoundsChanged = true;
                this._validate(net);
            }
            catch (NotDrawableException notDrawableException) {
                if (this._dimMinimumSize != null) {
                    this.setSize(this._dimMinimumSize);
                } else {
                    this.setSize(0, 0);
                }
                if (this._iVerbose < 1) break block11;
                System.out.println("??[GraphCanvasDoubleBuffered.validate()] Not drawable exception.");
            }
        }
        this._zValid = true;
        if (this._iVerbose > 0) {
            System.out.println("[GraphCanvasDoubleBuffered.validate()]} this.getSize() = " + this.getSize());
        }
    }
}

