/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.awt;

import com.ibm.graph.Drawable;
import com.ibm.graph.DrawableNet;
import com.ibm.graph.GraphObject;
import com.ibm.graph.Net;
import com.ibm.graph.awt.event.GraphCanvasEvent;
import com.ibm.graph.awt.event.GraphCanvasEventListener;
import com.ibm.graph.draw.DrawNetEdgesThenVertices;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Vector;

public class GraphCanvas
extends Canvas {
    private static final String strClassName = "GraphCanvas";
    private Net _net;
    private MouseAdapter _mouselistener;
    private boolean _zMouseListening = false;
    private boolean _zListenToMouseClicked = false;
    private boolean _zListenToMousePressed = false;
    private boolean _zListenToMouseReleased = false;
    private Vector _vectorGraphCanvasEventMouseClickedListeners;
    private Vector _vectorGraphCanvasEventMousePressedListeners;
    private Vector _vectorGraphCanvasEventMouseReleasedListeners;
    private MouseMotionAdapter _mousemotionlistener;
    private boolean _zMouseMotionListening = false;
    private boolean _zListenToMouseMoved = false;
    private boolean _zListenToMouseDragged = false;
    private boolean _zMouseMoving = false;
    private boolean _zMouseDragging = false;
    private Vector _vectorGraphCanvasEventMouseMovedListeners;
    private Vector _vectorGraphCanvasEventMouseDraggedListeners;
    private int _iVerbose = 0;

    public GraphCanvas() {
        this._net = null;
    }

    public GraphCanvas(Net net) {
        this._net = net;
    }

    private void _addMouseListener() {
        if (this._mouselistener == null) {
            this._createMouseListener();
        }
        this.addMouseListener(this._mouselistener);
        this._zMouseListening = true;
    }

    private void _addMouseMotionListener() {
        if (this._mousemotionlistener == null) {
            this._createMouseMotionListener();
        }
        this.addMouseMotionListener(this._mousemotionlistener);
        this._zMouseMotionListening = true;
    }

    private void _createMouseListener() {
        this._mouselistener = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (GraphCanvas.this._zListenToMouseClicked) {
                    GraphCanvas.this._processMouseEvent(mouseEvent);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                GraphCanvas.this._processMouseEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (GraphCanvas.this._zListenToMousePressed) {
                    GraphCanvas.this._processMouseEvent(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (GraphCanvas.this._zListenToMouseReleased) {
                    GraphCanvas.this._processMouseEvent(mouseEvent);
                }
            }
        };
    }

    private void _createMouseMotionListener() {
        this._mousemotionlistener = new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (GraphCanvas.this._zListenToMouseDragged) {
                    GraphCanvas.this._processMouseEvent(mouseEvent);
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (GraphCanvas.this._zListenToMouseMoved) {
                    GraphCanvas.this._processMouseEvent(mouseEvent);
                }
            }
        };
    }

    private void _dispatchGraphCanvasEventMouseClicked(GraphCanvasEvent graphCanvasEvent) {
        Vector vector = this._vectorGraphCanvasEventMouseClickedListeners;
        synchronized (vector) {
            Enumeration enumeration = this._vectorGraphCanvasEventMouseClickedListeners.elements();
            while (enumeration.hasMoreElements()) {
                GraphCanvasEventListener graphCanvasEventListener = (GraphCanvasEventListener)enumeration.nextElement();
                graphCanvasEventListener.graphobjectSelected(graphCanvasEvent);
            }
        }
    }

    private void _dispatchGraphCanvasEventMouseDragged(GraphCanvasEvent graphCanvasEvent) {
        Vector vector = this._vectorGraphCanvasEventMouseDraggedListeners;
        synchronized (vector) {
            Enumeration enumeration = this._vectorGraphCanvasEventMouseDraggedListeners.elements();
            while (enumeration.hasMoreElements()) {
                GraphCanvasEventListener graphCanvasEventListener = (GraphCanvasEventListener)enumeration.nextElement();
                graphCanvasEventListener.graphobjectSelected(graphCanvasEvent);
            }
        }
    }

    private void _dispatchGraphCanvasEventMouseMoved(GraphCanvasEvent graphCanvasEvent) {
        Vector vector = this._vectorGraphCanvasEventMouseMovedListeners;
        synchronized (vector) {
            Enumeration enumeration = this._vectorGraphCanvasEventMouseMovedListeners.elements();
            while (enumeration.hasMoreElements()) {
                GraphCanvasEventListener graphCanvasEventListener = (GraphCanvasEventListener)enumeration.nextElement();
                graphCanvasEventListener.graphobjectSelected(graphCanvasEvent);
            }
        }
    }

    private void _dispatchGraphCanvasEventMousePressed(GraphCanvasEvent graphCanvasEvent) {
        Vector vector = this._vectorGraphCanvasEventMousePressedListeners;
        synchronized (vector) {
            Enumeration enumeration = this._vectorGraphCanvasEventMousePressedListeners.elements();
            while (enumeration.hasMoreElements()) {
                GraphCanvasEventListener graphCanvasEventListener = (GraphCanvasEventListener)enumeration.nextElement();
                graphCanvasEventListener.graphobjectSelected(graphCanvasEvent);
            }
        }
    }

    private void _dispatchGraphCanvasEventMouseReleased(GraphCanvasEvent graphCanvasEvent) {
        Vector vector = this._vectorGraphCanvasEventMouseReleasedListeners;
        synchronized (vector) {
            Enumeration enumeration = this._vectorGraphCanvasEventMouseReleasedListeners.elements();
            while (enumeration.hasMoreElements()) {
                GraphCanvasEventListener graphCanvasEventListener = (GraphCanvasEventListener)enumeration.nextElement();
                graphCanvasEventListener.graphobjectSelected(graphCanvasEvent);
            }
        }
    }

    private GraphObject _getGraphObject(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        GraphObject graphObject = null;
        if (this._net != null) {
            Drawable drawable = this._net.getDrawable();
            graphObject = drawable instanceof DrawableNet ? ((DrawableNet)drawable).getGraphObject(this._net, n, n2) : DrawNetEdgesThenVertices.findGraphObject(this._net, n, n2);
        }
        return graphObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _processMouseEvent(MouseEvent mouseEvent) {
        GraphObject graphObject = this._getGraphObject(mouseEvent);
        if (graphObject != null) {
            GraphCanvasEvent graphCanvasEvent = new GraphCanvasEvent(this, this._net, graphObject, mouseEvent);
            switch (mouseEvent.getID()) {
                case 500: {
                    this._dispatchGraphCanvasEventMouseClicked(graphCanvasEvent);
                    return;
                }
                case 501: {
                    this._dispatchGraphCanvasEventMousePressed(graphCanvasEvent);
                    return;
                }
                case 502: {
                    this._dispatchGraphCanvasEventMouseReleased(graphCanvasEvent);
                    return;
                }
                case 506: {
                    this._zMouseDragging = true;
                    this._dispatchGraphCanvasEventMouseDragged(graphCanvasEvent);
                    return;
                }
                case 503: {
                    this._zMouseMoving = true;
                    this._dispatchGraphCanvasEventMouseMoved(graphCanvasEvent);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (this._zMouseDragging) {
            switch (mouseEvent.getID()) {
                case 500: 
                case 501: 
                case 502: 
                case 503: {
                    this._zMouseDragging = false;
                    GraphCanvasEvent graphCanvasEvent = new GraphCanvasEvent(this, null, graphObject, mouseEvent);
                    this._dispatchGraphCanvasEventMouseDragged(graphCanvasEvent);
                    return;
                }
                case 506: {
                    GraphCanvasEvent graphCanvasEvent = new GraphCanvasEvent(this, this._net, graphObject, mouseEvent);
                    this._dispatchGraphCanvasEventMouseDragged(graphCanvasEvent);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (this._zMouseMoving) {
            GraphCanvasEvent graphCanvasEvent = new GraphCanvasEvent(this, null, graphObject, mouseEvent);
            switch (mouseEvent.getID()) {
                case 500: 
                case 501: 
                case 502: 
                case 503: 
                case 505: 
                case 506: {
                    this._zMouseMoving = false;
                    this._dispatchGraphCanvasEventMouseMoved(graphCanvasEvent);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        GraphCanvasEvent graphCanvasEvent = new GraphCanvasEvent(this, null, graphObject, mouseEvent);
        switch (mouseEvent.getID()) {
            case 500: {
                this._dispatchGraphCanvasEventMouseClicked(graphCanvasEvent);
                break;
            }
            case 501: {
                this._dispatchGraphCanvasEventMousePressed(graphCanvasEvent);
                break;
            }
            case 502: {
                this._dispatchGraphCanvasEventMouseReleased(graphCanvasEvent);
                break;
            }
            case 506: {
                this._dispatchGraphCanvasEventMouseDragged(graphCanvasEvent);
                break;
            }
            case 503: {
                this._dispatchGraphCanvasEventMouseMoved(graphCanvasEvent);
            }
        }
    }

    private void _removeMouseListener() {
        this.removeMouseListener(this._mouselistener);
        this._zMouseListening = false;
    }

    private void _removeMouseMotionListener() {
        this.removeMouseMotionListener(this._mousemotionlistener);
        this.setListenToMouseMotion(false);
        this._zMouseMotionListening = false;
    }

    public void addGraphCanvasEventMouseClickedListener(GraphCanvasEventListener graphCanvasEventListener) {
        if (this._vectorGraphCanvasEventMouseClickedListeners == null) {
            this._vectorGraphCanvasEventMouseClickedListeners = new Vector(1);
        }
        this._vectorGraphCanvasEventMouseClickedListeners.addElement(graphCanvasEventListener);
        if (!this._zMouseListening) {
            this._addMouseListener();
        }
        this.setListenToMouseClicked(true);
    }

    public void addGraphCanvasEventMouseDraggedListener(GraphCanvasEventListener graphCanvasEventListener) {
        if (this._vectorGraphCanvasEventMouseDraggedListeners == null) {
            this._vectorGraphCanvasEventMouseDraggedListeners = new Vector(1);
        }
        this._vectorGraphCanvasEventMouseDraggedListeners.addElement(graphCanvasEventListener);
        if (!this._zMouseMotionListening) {
            this._addMouseMotionListener();
        }
        this.setListenToMouseDragged(true);
    }

    public void addGraphCanvasEventMouseListener(GraphCanvasEventListener graphCanvasEventListener) {
        if (this._vectorGraphCanvasEventMouseClickedListeners == null) {
            this._vectorGraphCanvasEventMouseClickedListeners = new Vector(1);
        }
        this._vectorGraphCanvasEventMouseClickedListeners.addElement(graphCanvasEventListener);
        if (this._vectorGraphCanvasEventMousePressedListeners == null) {
            this._vectorGraphCanvasEventMousePressedListeners = new Vector(1);
        }
        this._vectorGraphCanvasEventMousePressedListeners.addElement(graphCanvasEventListener);
        if (this._vectorGraphCanvasEventMouseReleasedListeners == null) {
            this._vectorGraphCanvasEventMouseReleasedListeners = new Vector(1);
        }
        this._vectorGraphCanvasEventMouseReleasedListeners.addElement(graphCanvasEventListener);
        if (!this._zMouseListening) {
            this._addMouseListener();
        }
        this.setListenToMouse(true);
    }

    public void addGraphCanvasEventMouseMotionListener(GraphCanvasEventListener graphCanvasEventListener) {
        if (this._vectorGraphCanvasEventMouseDraggedListeners == null) {
            this._vectorGraphCanvasEventMouseDraggedListeners = new Vector(1);
        }
        this._vectorGraphCanvasEventMouseDraggedListeners.addElement(graphCanvasEventListener);
        if (this._vectorGraphCanvasEventMouseMovedListeners == null) {
            this._vectorGraphCanvasEventMouseMovedListeners = new Vector(1);
        }
        this._vectorGraphCanvasEventMouseMovedListeners.addElement(graphCanvasEventListener);
        if (!this._zMouseMotionListening) {
            this._addMouseMotionListener();
        }
        this.setListenToMouseMotion(true);
    }

    public void addGraphCanvasEventMouseMovedListener(GraphCanvasEventListener graphCanvasEventListener) {
        if (this._vectorGraphCanvasEventMouseMovedListeners == null) {
            this._vectorGraphCanvasEventMouseMovedListeners = new Vector(1);
        }
        this._vectorGraphCanvasEventMouseMovedListeners.addElement(graphCanvasEventListener);
        if (!this._zMouseMotionListening) {
            this._addMouseMotionListener();
        }
        this.setListenToMouseMoved(true);
    }

    public void addGraphCanvasEventMousePressedListener(GraphCanvasEventListener graphCanvasEventListener) {
        if (this._vectorGraphCanvasEventMousePressedListeners == null) {
            this._vectorGraphCanvasEventMousePressedListeners = new Vector(1);
        }
        this._vectorGraphCanvasEventMousePressedListeners.addElement(graphCanvasEventListener);
        if (!this._zMouseListening) {
            this._addMouseListener();
        }
        this.setListenToMousePressed(true);
    }

    public void addGraphCanvasEventMouseReleasedListener(GraphCanvasEventListener graphCanvasEventListener) {
        if (this._vectorGraphCanvasEventMouseReleasedListeners == null) {
            this._vectorGraphCanvasEventMouseReleasedListeners = new Vector(1);
        }
        this._vectorGraphCanvasEventMouseReleasedListeners.addElement(graphCanvasEventListener);
        if (!this._zMouseListening) {
            this._addMouseListener();
        }
        this.setListenToMouseReleased(true);
    }

    public Net getGraph() {
        return this._net;
    }

    public boolean getListenToMouseClicked() {
        return this._zListenToMouseClicked;
    }

    public boolean getListenToMouseDragged() {
        return this._zListenToMouseDragged;
    }

    public boolean getListenToMouseMoved() {
        return this._zListenToMouseMoved;
    }

    public boolean getListenToMousePressed() {
        return this._zListenToMousePressed;
    }

    public boolean getListenToMouseReleased() {
        return this._zListenToMouseReleased;
    }

    public int getVerbose() {
        return this._iVerbose;
    }

    public void paint(Graphics graphics) {
        if (this._net != null) {
            this._net.draw(this._net, graphics);
        } else if (this._iVerbose >= 1) {
            System.out.println("[GraphCanvas.paint(Graphics)] Undefined net (net == null).");
        }
    }

    public void removeGraphCanvasEventMouseClickedListener(GraphCanvasEventListener graphCanvasEventListener) {
        if (this._vectorGraphCanvasEventMouseClickedListeners != null) {
            this._vectorGraphCanvasEventMouseClickedListeners.removeElement(graphCanvasEventListener);
        }
        if (this._vectorGraphCanvasEventMouseClickedListeners.size() + this._vectorGraphCanvasEventMousePressedListeners.size() + this._vectorGraphCanvasEventMouseReleasedListeners.size() == 0) {
            this._removeMouseListener();
        }
        if (this._vectorGraphCanvasEventMouseClickedListeners.size() == 0) {
            this.setListenToMouseClicked(false);
        }
    }

    public void removeGraphCanvasEventMouseDraggedListener(GraphCanvasEventListener graphCanvasEventListener) {
        if (this._vectorGraphCanvasEventMouseDraggedListeners != null) {
            this._vectorGraphCanvasEventMouseDraggedListeners.removeElement(graphCanvasEventListener);
        }
        if (this._vectorGraphCanvasEventMouseDraggedListeners.size() + this._vectorGraphCanvasEventMouseMovedListeners.size() == 0) {
            this._removeMouseMotionListener();
        }
        if (this._vectorGraphCanvasEventMouseDraggedListeners.size() == 0) {
            this.setListenToMouseDragged(false);
        }
    }

    public void removeGraphCanvasEventMouseListener(GraphCanvasEventListener graphCanvasEventListener) {
        if (this._vectorGraphCanvasEventMouseClickedListeners != null) {
            this._vectorGraphCanvasEventMouseClickedListeners.removeElement(graphCanvasEventListener);
        }
        if (this._vectorGraphCanvasEventMousePressedListeners != null) {
            this._vectorGraphCanvasEventMousePressedListeners.removeElement(graphCanvasEventListener);
        }
        if (this._vectorGraphCanvasEventMouseReleasedListeners != null) {
            this._vectorGraphCanvasEventMouseReleasedListeners.removeElement(graphCanvasEventListener);
        }
        if (this._vectorGraphCanvasEventMouseClickedListeners.size() + this._vectorGraphCanvasEventMousePressedListeners.size() + this._vectorGraphCanvasEventMouseReleasedListeners.size() == 0) {
            this._removeMouseListener();
        }
        if (this._vectorGraphCanvasEventMouseClickedListeners.size() == 0) {
            this.setListenToMouseClicked(false);
        }
        if (this._vectorGraphCanvasEventMousePressedListeners.size() == 0) {
            this.setListenToMousePressed(false);
        }
        if (this._vectorGraphCanvasEventMouseReleasedListeners.size() == 0) {
            this.setListenToMouseReleased(false);
        }
    }

    public void removeGraphCanvasEventMouseMotionListener(GraphCanvasEventListener graphCanvasEventListener) {
        if (this._vectorGraphCanvasEventMouseDraggedListeners != null) {
            this._vectorGraphCanvasEventMouseDraggedListeners.removeElement(graphCanvasEventListener);
        }
        if (this._vectorGraphCanvasEventMouseMovedListeners != null) {
            this._vectorGraphCanvasEventMouseMovedListeners.removeElement(graphCanvasEventListener);
        }
        if (this._vectorGraphCanvasEventMouseDraggedListeners.size() + this._vectorGraphCanvasEventMouseMovedListeners.size() == 0) {
            this._removeMouseMotionListener();
        }
        if (this._vectorGraphCanvasEventMouseDraggedListeners.size() == 0) {
            this.setListenToMouseDragged(false);
        }
        if (this._vectorGraphCanvasEventMouseMovedListeners.size() == 0) {
            this.setListenToMouseMoved(false);
        }
    }

    public void removeGraphCanvasEventMouseMovedListener(GraphCanvasEventListener graphCanvasEventListener) {
        if (this._vectorGraphCanvasEventMouseMovedListeners != null) {
            this._vectorGraphCanvasEventMouseMovedListeners.removeElement(graphCanvasEventListener);
        }
        if (this._vectorGraphCanvasEventMouseDraggedListeners.size() + this._vectorGraphCanvasEventMouseMovedListeners.size() == 0) {
            this._removeMouseMotionListener();
        }
        if (this._vectorGraphCanvasEventMouseMovedListeners.size() == 0) {
            this.setListenToMouseMoved(false);
        }
    }

    public void removeGraphCanvasEventMousePressedListener(GraphCanvasEventListener graphCanvasEventListener) {
        if (this._vectorGraphCanvasEventMousePressedListeners != null) {
            this._vectorGraphCanvasEventMousePressedListeners.removeElement(graphCanvasEventListener);
        }
        if (this._vectorGraphCanvasEventMouseClickedListeners.size() + this._vectorGraphCanvasEventMousePressedListeners.size() + this._vectorGraphCanvasEventMouseReleasedListeners.size() == 0) {
            this._removeMouseListener();
        }
        if (this._vectorGraphCanvasEventMousePressedListeners.size() == 0) {
            this.setListenToMousePressed(false);
        }
    }

    public void removeGraphCanvasEventMouseReleasedListener(GraphCanvasEventListener graphCanvasEventListener) {
        if (this._vectorGraphCanvasEventMouseReleasedListeners != null) {
            this._vectorGraphCanvasEventMouseReleasedListeners.removeElement(graphCanvasEventListener);
        }
        if (this._vectorGraphCanvasEventMouseClickedListeners.size() + this._vectorGraphCanvasEventMousePressedListeners.size() + this._vectorGraphCanvasEventMouseReleasedListeners.size() == 0) {
            this._removeMouseListener();
        }
        if (this._vectorGraphCanvasEventMouseReleasedListeners.size() == 0) {
            this.setListenToMouseReleased(false);
        }
    }

    public void setGraph(Net net) {
        this._net = net;
    }

    public void setListenToMouse(boolean bl) {
        this._zListenToMouseClicked = bl;
        this._zListenToMousePressed = bl;
        this._zListenToMouseReleased = bl;
    }

    public void setListenToMouseClicked(boolean bl) {
        this._zListenToMouseClicked = bl;
    }

    public void setListenToMouseDragged(boolean bl) {
        this._zListenToMouseDragged = bl;
    }

    public void setListenToMouseMotion(boolean bl) {
        this._zListenToMouseDragged = bl;
        this._zListenToMouseMoved = bl;
    }

    public void setListenToMouseMoved(boolean bl) {
        this._zListenToMouseMoved = bl;
    }

    public void setListenToMousePressed(boolean bl) {
        this._zListenToMousePressed = bl;
    }

    public void setListenToMouseReleased(boolean bl) {
        this._zListenToMouseReleased = bl;
    }

    public void setVerbose(int n) {
        this._iVerbose = n;
    }
}

