/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph;

import com.ibm.graph.Edge;
import com.ibm.graph.GraphLayout;
import com.ibm.graph.GraphObject;
import com.ibm.graph.InvalidEdgeException;
import com.ibm.graph.Vertex;
import com.ibm.research.util.Throw;
import com.ibm.research.util.list.EmptyListException;
import com.ibm.research.util.list.InvalidCurrentNodeException;
import com.ibm.research.util.list.List;
import java.util.Enumeration;
import java.util.Vector;

public class Walk
extends GraphLayout {
    List listVerticesAndEdges = new List();
    private static final String _$strClassName = "Walk";

    public Walk() {
    }

    public Walk(Vertex vertex) {
        this();
        if (vertex != null) {
            this.listVerticesAndEdges.addFirst(vertex);
        }
    }

    private void _clear() {
        this.listVerticesAndEdges.clear();
    }

    private boolean _contains(GraphObject graphObject) {
        try {
            this.listVerticesAndEdges.gotoHead();
        }
        catch (EmptyListException emptyListException) {
            return false;
        }
        try {
            return this.listVerticesAndEdges.find(graphObject);
        }
        catch (InvalidCurrentNodeException invalidCurrentNodeException) {
            Throw.throwError(_$strClassName, this._containsMethod(graphObject), " Unexpected InvalidCurrentNodeException. BUG!?");
            return false;
        }
    }

    private final String _containsMethod(GraphObject graphObject) {
        return "contains(" + graphObject + ")";
    }

    private Enumeration _enumerateEdges() {
        return this._vectorEdges().elements();
    }

    private Enumeration _enumerateVerticesAndEdges() {
        return this._vectorVerticesAndEdges().elements();
    }

    private boolean _insertAfterSingle(Edge edge) throws InvalidCurrentNodeException, EmptyListException {
        this.listVerticesAndEdges.gotoHead();
        Vertex vertex = (Vertex)this.listVerticesAndEdges.getData();
        this.listVerticesAndEdges.gotoTail();
        Vertex vertex2 = (Vertex)this.listVerticesAndEdges.getData();
        Vertex vertex3 = edge.getFromVertex();
        Vertex vertex4 = edge.getToVertex();
        if (vertex2 == vertex3) {
            this.listVerticesAndEdges.addLast(edge);
            this.listVerticesAndEdges.addLast(vertex4);
            return true;
        }
        if (vertex2 == vertex4) {
            this.listVerticesAndEdges.addLast(edge);
            this.listVerticesAndEdges.addLast(vertex3);
            return true;
        }
        if (vertex == vertex3) {
            this.listVerticesAndEdges.gotoHead();
            this.listVerticesAndEdges.setData(vertex2);
            this.listVerticesAndEdges.gotoTail();
            this.listVerticesAndEdges.setData(vertex);
            this.listVerticesAndEdges.addLast(edge);
            this.listVerticesAndEdges.addLast(vertex4);
            return true;
        }
        if (vertex == vertex4) {
            this.listVerticesAndEdges.gotoHead();
            this.listVerticesAndEdges.setData(vertex2);
            this.listVerticesAndEdges.gotoTail();
            this.listVerticesAndEdges.setData(vertex);
            this.listVerticesAndEdges.addLast(edge);
            this.listVerticesAndEdges.addLast(vertex3);
            return true;
        }
        return false;
    }

    private boolean _insertAfterTail(Edge edge) throws InvalidCurrentNodeException, EmptyListException {
        this.listVerticesAndEdges.gotoTail();
        Vertex vertex = (Vertex)this.listVerticesAndEdges.getData();
        Vertex vertex2 = edge.getFromVertex();
        Vertex vertex3 = edge.getToVertex();
        if (vertex == vertex2) {
            this.listVerticesAndEdges.addLast(edge);
            this.listVerticesAndEdges.addLast(vertex3);
            return true;
        }
        if (vertex == vertex3) {
            this.listVerticesAndEdges.addLast(edge);
            this.listVerticesAndEdges.addLast(vertex2);
            return true;
        }
        return false;
    }

    private final String _insertAtTailMethod(Edge edge) {
        return "[Walk.insertAtTail(" + edge + ")]";
    }

    private boolean _insertBeforeHead(Edge edge) throws InvalidCurrentNodeException, EmptyListException {
        this.listVerticesAndEdges.gotoHead();
        Vertex vertex = (Vertex)this.listVerticesAndEdges.getData();
        Vertex vertex2 = edge.getFromVertex();
        Vertex vertex3 = edge.getToVertex();
        if (vertex == vertex3) {
            this.listVerticesAndEdges.addFirst(edge);
            this.listVerticesAndEdges.addFirst(vertex2);
            return true;
        }
        if (vertex == vertex2) {
            this.listVerticesAndEdges.addFirst(edge);
            this.listVerticesAndEdges.addFirst(vertex3);
            return true;
        }
        return false;
    }

    private boolean _insertBeforeSingle(Edge edge) throws InvalidCurrentNodeException, EmptyListException {
        this.listVerticesAndEdges.gotoHead();
        Vertex vertex = (Vertex)this.listVerticesAndEdges.getData();
        this.listVerticesAndEdges.gotoTail();
        Vertex vertex2 = (Vertex)this.listVerticesAndEdges.getData();
        Vertex vertex3 = edge.getFromVertex();
        Vertex vertex4 = edge.getToVertex();
        if (vertex == vertex4) {
            this.listVerticesAndEdges.addFirst(edge);
            this.listVerticesAndEdges.addFirst(vertex3);
            return true;
        }
        if (vertex == vertex3) {
            this.listVerticesAndEdges.addFirst(edge);
            this.listVerticesAndEdges.addFirst(vertex4);
            return true;
        }
        if (vertex2 == vertex4) {
            this.listVerticesAndEdges.gotoHead();
            this.listVerticesAndEdges.setData(vertex2);
            this.listVerticesAndEdges.gotoTail();
            this.listVerticesAndEdges.setData(vertex);
            this.listVerticesAndEdges.addFirst(edge);
            this.listVerticesAndEdges.addFirst(vertex3);
            return true;
        }
        if (vertex2 == vertex3) {
            this.listVerticesAndEdges.gotoHead();
            this.listVerticesAndEdges.setData(vertex2);
            this.listVerticesAndEdges.gotoTail();
            this.listVerticesAndEdges.setData(vertex);
            this.listVerticesAndEdges.addFirst(edge);
            this.listVerticesAndEdges.addFirst(vertex4);
            return true;
        }
        return false;
    }

    private void _insertOnEmpty(Edge edge) {
        this.listVerticesAndEdges.addFirst(edge.getToVertex());
        this.listVerticesAndEdges.addFirst(edge);
        this.listVerticesAndEdges.addFirst(edge.getFromVertex());
    }

    private boolean _isEmpty() {
        return this.listVerticesAndEdges.isEmpty();
    }

    private void _setHead(Vertex vertex) {
        this.listVerticesAndEdges.addFirst(vertex);
    }

    private final String _setHeadMethod(Vertex vertex) {
        return "setHeadMethod(" + vertex + ")";
    }

    private Vector _vectorEdges() {
        Vector vector = new Vector();
        Enumeration enumeration = this.listVerticesAndEdges.enumerateData();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Edge)) continue;
            vector.addElement(e);
        }
        return vector;
    }

    private Vector _vectorVerticesAndEdges() {
        Vector vector = new Vector();
        Enumeration enumeration = this.listVerticesAndEdges.enumerateData();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            vector.addElement(e);
        }
        return vector;
    }

    public void clear() {
        this._clear();
    }

    public void concatenate(Walk walk) throws InvalidEdgeException {
        if (walk == null) {
            return;
        }
        if (walk.isEmpty()) {
            return;
        }
        if (!this.isEmpty() && this.getTail() != walk.getHead()) {
            throw new InvalidEdgeException("[Walk.concatenate(" + walk + ")] Tail of this walk and head of that walk are different.");
        }
        Enumeration enumeration = walk.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            this.insertAtTail(edge);
        }
    }

    public boolean contains(GraphObject graphObject) throws IllegalArgumentException {
        if (graphObject == null) {
            Throw.throwIllegalArgumentException(_$strClassName, this._containsMethod(graphObject), " Null object.");
        }
        if (!(graphObject instanceof Vertex) && !(graphObject instanceof Edge)) {
            Throw.throwIllegalArgumentException(_$strClassName, this._containsMethod(graphObject), " Graph-object is not a vertex or edge.");
        }
        return this._contains(graphObject);
    }

    public void deleteTail() {
        if (this._isEmpty()) {
            return;
        }
        if (this.listVerticesAndEdges.size() == 1L) {
            this.listVerticesAndEdges.clear();
        } else {
            try {
                this.listVerticesAndEdges.deleteFromEnd();
                this.listVerticesAndEdges.deleteFromEnd();
            }
            catch (EmptyListException emptyListException) {}
        }
    }

    public Enumeration enumerateEdges() {
        return this._enumerateEdges();
    }

    public Enumeration enumerateInteriorVertices() {
        Vector vector = new Vector();
        boolean bl = false;
        Enumeration enumeration = this.listVerticesAndEdges.enumerateData();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Vertex)) continue;
            if (bl) {
                vector.addElement(e);
                continue;
            }
            bl = true;
        }
        if (vector.size() > 0) {
            vector.removeElementAt(vector.size() - 1);
        }
        return vector.elements();
    }

    public Enumeration enumerateVertices() {
        Vector vector = new Vector();
        Enumeration enumeration = this.listVerticesAndEdges.enumerateData();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Vertex)) continue;
            vector.addElement(e);
        }
        return vector.elements();
    }

    public Enumeration enumerateVerticesAndEdges() {
        return this._enumerateVerticesAndEdges();
    }

    public Vertex getHead() {
        try {
            this.listVerticesAndEdges.gotoHead();
        }
        catch (EmptyListException emptyListException) {
            return null;
        }
        try {
            return (Vertex)this.listVerticesAndEdges.getData();
        }
        catch (InvalidCurrentNodeException invalidCurrentNodeException) {
            Throw.throwError(_$strClassName, "getHead()", " Unexpected InvalidCurrentNodeException in walk(" + this + ")." + " BUG!?");
            return null;
        }
    }

    public Vertex getTail() {
        try {
            this.listVerticesAndEdges.gotoTail();
        }
        catch (EmptyListException emptyListException) {
            return null;
        }
        try {
            return (Vertex)this.listVerticesAndEdges.getData();
        }
        catch (InvalidCurrentNodeException invalidCurrentNodeException) {
            Throw.throwError(_$strClassName, "getTail()", " Unexpected InvalidCurrentNodeException in walk(" + this + ")." + " BUG!?");
            return null;
        }
    }

    public void insertAtHead(Edge edge) throws InvalidEdgeException {
        if (edge == null) {
            return;
        }
        try {
            boolean bl;
            boolean bl2;
            if (this.isInvalid(edge)) {
                throw new InvalidEdgeException();
            }
            if (this.listVerticesAndEdges.size() == 0L) {
                this._insertOnEmpty(edge);
            } else if (this.listVerticesAndEdges.size() == 1L ? !(bl2 = this._insertBeforeSingle(edge)) : !(bl = this._insertBeforeHead(edge))) {
                throw new InvalidEdgeException();
            }
            this.listVerticesAndEdges.gotoHead();
            this.listVerticesAndEdges.next();
        }
        catch (InvalidCurrentNodeException invalidCurrentNodeException) {
        }
        catch (EmptyListException emptyListException) {}
    }

    public void insertAtTail(Edge edge) throws InvalidEdgeException {
        if (this.$iVerboseMethod >= 1) {
            System.out.println(String.valueOf(this._insertAtTailMethod(edge)) + "{");
        }
        try {
            if (edge == null) {
                return;
            }
            if (this.isInvalid(edge)) {
                throw new InvalidEdgeException(String.valueOf(this._insertAtTailMethod(edge)) + " Invalid edge.");
            }
            if (this.listVerticesAndEdges.size() == 0L) {
                this._insertOnEmpty(edge);
            } else if (this.listVerticesAndEdges.size() == 1L) {
                boolean bl = this._insertAfterSingle(edge);
                if (!bl) {
                    throw new InvalidEdgeException(String.valueOf(this._insertAtTailMethod(edge)) + " Insertion as head failed.");
                }
            } else {
                boolean bl = this._insertAfterTail(edge);
                if (!bl) {
                    throw new InvalidEdgeException(String.valueOf(this._insertAtTailMethod(edge)) + " Tail insertion failed.");
                }
            }
            this.listVerticesAndEdges.gotoTail();
            this.listVerticesAndEdges.previous();
        }
        catch (InvalidCurrentNodeException invalidCurrentNodeException) {
        }
        catch (EmptyListException emptyListException) {}
        if (this.$iVerboseMethod >= 1) {
            System.out.println(String.valueOf(this._insertAtTailMethod(edge)) + "}");
        }
    }

    public boolean isEmpty() {
        return this._isEmpty();
    }

    protected boolean isInvalid(Edge edge) {
        return edge == null;
    }

    public void reverse() {
        Vector vector = this._vectorVerticesAndEdges();
        this.listVerticesAndEdges.clear();
        int n = vector.size() - 1;
        while (n >= 0) {
            this.listVerticesAndEdges.addLast((GraphObject)vector.elementAt(n));
            --n;
        }
    }

    public void setHead(Vertex vertex) throws IllegalArgumentException {
        if (vertex == null) {
            return;
        }
        if (!this._isEmpty()) {
            Throw.throwIllegalArgumentException(_$strClassName, this._setHeadMethod(vertex), " Walk is not empty.");
        }
        this._setHead(vertex);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this._enumerateVerticesAndEdges();
        while (enumeration.hasMoreElements()) {
            GraphObject graphObject = (GraphObject)enumeration.nextElement();
            stringBuffer.append(graphObject.toString());
            stringBuffer.append("\n");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("[empty walk]\n");
        }
        return stringBuffer.toString();
    }
}

