/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph;

import com.ibm.graph.Edge;
import com.ibm.graph.GraphDraw;
import com.ibm.graph.GraphObject;
import com.ibm.graph.Net;
import com.ibm.graph.VertexMissingException;
import com.ibm.research.util.Dict;
import com.ibm.research.util.KeyMissingException;
import com.ibm.research.util.Set;
import com.ibm.research.util.Throw;
import com.ibm.research.util.Util;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Vertex
extends GraphDraw
implements Serializable {
    private static final String _strClassName = "Vertex";
    private static boolean _zShowHashCode = false;
    private Set setNets = new Set();
    private Set setEdges = new Set();
    private transient int _iEnumerationSize = 0;
    private transient boolean zWarnMultipleNets = true;
    private transient String sPathDelimiters = new String("\\/");
    private transient boolean bTracePublicMethods = false;
    private transient boolean bTraceProtectedMethods = false;
    private transient boolean bTracePrivateMethods = false;
    private transient boolean bReportNullParameters = false;
    private transient boolean bReportNullResults = false;

    private final String _addMethod(int n, Edge edge) {
        return "add(" + n + "," + edge + ")";
    }

    private final String _addMethod(Net net, int n, Edge edge) {
        return "add(Net," + n + "," + edge + ")";
    }

    private final Set _allDirectedEdges() {
        Set set = new Set();
        Enumeration enumeration = this.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.isDirected()) continue;
            set.addElement(edge);
        }
        return set;
    }

    private final Set _allDirectedIncomingEdges() {
        Set set = new Set();
        Enumeration enumeration = this.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.isDirected() || edge.getToVertex() != this) continue;
            set.addElement(edge);
        }
        return set;
    }

    private final Set _allDirectedOutgoingEdges() {
        Set set = new Set();
        Enumeration enumeration = this.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.isDirected() || edge.getFromVertex() != this) continue;
            set.addElement(edge);
        }
        return set;
    }

    private int _degreeIncoming() {
        int n = 0;
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.isUndirected() && edge.getToVertex() != this) continue;
            ++n;
        }
        return n;
    }

    private int _degreeIncoming(Net net) {
        int n = 0;
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!net.contains(edge) || !edge.isUndirected() && edge.getToVertex() != this) continue;
            ++n;
        }
        return n;
    }

    private int _degreeOutgoing() {
        int n = 0;
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.isUndirected() && edge.getFromVertex() != this) continue;
            ++n;
        }
        return n;
    }

    private int _degreeOutgoing(Net net) {
        int n = 0;
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!net.contains(edge) || !edge.isUndirected() && edge.getFromVertex() != this) continue;
            ++n;
        }
        return n;
    }

    private Enumeration _enumerateEdges() {
        this._iEnumerationSize = this.setEdges.size();
        return this.setEdges.elements();
    }

    private Enumeration _enumerateEdges(Net net) {
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!net.contains(edge)) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    private Enumeration _enumerateEdgesBySystemKey(Net net, Object object) {
        if (object == null) {
            return GraphObject.EMPTY_ENUMERATION;
        }
        Vector<Edge> vector = new Vector<Edge>(0);
        Enumeration enumeration = this._enumerateEdges(net);
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.systemdict.containsKey(object)) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    private Enumeration _enumerateEdgesBySystemKey(Object object) {
        if (object == null) {
            return GraphObject.EMPTY_ENUMERATION;
        }
        Vector<Edge> vector = new Vector<Edge>(0);
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.systemdict.containsKey(object)) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    private Enumeration _enumerateEdgesBySystemKeySetToValue(Object object, Object object2) {
        if (object == null) {
            return GraphObject.EMPTY_ENUMERATION;
        }
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this._enumerateEdgesBySystemKey(object);
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.systemdict.get(object).equals(object2)) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    private Enumeration _enumerateEdgesByUserKey(Object object) {
        if (object == null) {
            return GraphObject.EMPTY_ENUMERATION;
        }
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.userdict.containsKey(object)) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    private final String _getIndexMethod(Edge edge) {
        return "getIndex(" + edge + ")";
    }

    private final String _moveMethod(Net net, Net net2) {
        return "move(" + net.getName() + "," + net2.getName() + ")";
    }

    boolean add(int n, Edge edge) {
        if (this.$iVerboseMethod >= 3) {
            this.$printMethod(GraphObject.out, _strClassName, this._addMethod(n, edge), "{");
        }
        boolean bl = false;
        if (!this.setEdges.contains(edge) && n >= 0 && this.setEdges.size() >= n) {
            try {
                this.setEdges.insertElementAt(edge, n);
                bl = true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        if (this.$iVerboseMethod >= 3) {
            this.$printMethod(GraphObject.out, _strClassName, this._addMethod(n, edge), "} " + bl);
        }
        return bl;
    }

    boolean add(Edge edge) {
        if (this.setEdges.contains(edge)) {
            return false;
        }
        return this.setEdges.add(edge);
    }

    boolean add(Net net) {
        if (this.setNets.contains(net)) {
            return false;
        }
        this.setNets.addElement(net);
        return true;
    }

    boolean add(Net net, int n, Edge edge) {
        boolean bl;
        block7: {
            bl = false;
            boolean bl2 = false;
            if (n < 0 || this.setEdges.size() < n) break block7;
            int n2 = n;
            int n3 = 0;
            Enumeration enumeration = this.setEdges.elements();
            while (enumeration.hasMoreElements()) {
                Edge edge2 = (Edge)enumeration.nextElement();
                if (edge == edge2) break;
                if (!net.contains(edge2)) {
                    ++n2;
                    continue;
                }
                if (n3 == n) {
                    bl2 = true;
                    break;
                }
                ++n3;
            }
            if (!bl2 && n3 == n) {
                bl2 = true;
            }
            if (bl2) {
                try {
                    this.setEdges.insertElementAt(edge, n2);
                    bl = true;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    Throw.throwError(_strClassName, this._addMethod(net, n, edge), "Unexpected array out-of-bounds. BUG?!");
                }
            }
        }
        return bl;
    }

    protected Set allDirectedEdges() {
        return this._allDirectedEdges();
    }

    protected Set allDirectedIncomingEdges() {
        return this._allDirectedIncomingEdges();
    }

    protected Set allDirectedOutgoingEdges() {
        return this._allDirectedOutgoingEdges();
    }

    protected Set allEdges() {
        return (Set)this.setEdges.clone();
    }

    protected Set allNeighbors() {
        Set set = new Set();
        Enumeration enumeration = this.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            try {
                Vertex vertex = ((Edge)enumeration.nextElement()).getOtherVertex(this);
                if (set.contains(vertex)) continue;
                set.addElement(vertex);
            }
            catch (VertexMissingException vertexMissingException) {}
        }
        return set;
    }

    protected Set allNeighbors(Net net) {
        Set set = new Set();
        Enumeration enumeration = this.enumerateEdges(net);
        while (enumeration.hasMoreElements()) {
            try {
                Vertex vertex = ((Edge)enumeration.nextElement()).getOtherVertex(this);
                if (set.contains(vertex)) continue;
                set.addElement(vertex);
            }
            catch (VertexMissingException vertexMissingException) {}
        }
        return set;
    }

    public boolean contains(Edge edge) {
        if (this.zWarnMultipleNets && this.setNets.size() > 1) {
            System.out.println("[Vertex.contains(" + edge + ")[" + this + "]] More than one net available.  Use method contains(Net,Edge) instead.");
        }
        return this.setEdges.contains(edge);
    }

    public boolean contains(Net net, Edge edge) {
        if (net.contains(edge)) {
            return this.setEdges.contains(edge);
        }
        return false;
    }

    public boolean containsEdge(Edge edge) {
        return this.setEdges.contains(edge);
    }

    public int degree() {
        if (this.zWarnMultipleNets && this.setNets.size() > 1) {
            System.out.println("[Vertex.degree()[" + this + "]] More than one net available.  Use method degree(Net) instead.");
        }
        return this.setEdges.size();
    }

    public int degree(Net net) {
        int n = 0;
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!net.contains(edge)) continue;
            ++n;
        }
        return n;
    }

    public int degreeIncoming() {
        if (this.zWarnMultipleNets && this.setNets.size() > 1) {
            System.out.println("[Vertex.degreeIncoming()[" + this + "]] More than one net available.  Use method degreeIncoming(Net) instead.");
        }
        return this._degreeIncoming();
    }

    public int degreeIncoming(Net net) {
        return this._degreeIncoming(net);
    }

    public int degreeOutgoing() {
        if (this.zWarnMultipleNets && this.setNets.size() > 1) {
            System.out.println("[Vertex.degreeOutgoing()[" + this + "]] More than one net available.  Use method degreeOutgoint(Net) instead.");
        }
        return this._degreeOutgoing();
    }

    public int degreeOutgoing(Net net) {
        return this._degreeOutgoing(net);
    }

    public Enumeration enumerateDirectedEdges() {
        if (this.zWarnMultipleNets && this.setNets.size() > 1) {
            System.out.println("[Vertex.enumerateDirectedEdges()[" + this + "]] More than one net available (" + this.setNets.size() + " nets).  Use method enumerateDirectedEdges(Net) instead.");
        }
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (edge.isUndirected()) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateDirectedEdges(Net net) {
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!net.contains(edge) || edge.isUndirected()) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateDirectedNeighbors() {
        if (this.zWarnMultipleNets && this.setNets.size() > 1) {
            System.out.println("[Vertex.enumerateDirectedEdges()[" + this + "]] More than one net available (" + this.setNets.size() + " nets).  Use method enumerateDirectedEdges(Net) instead.");
        }
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (edge.isUndirected()) continue;
            try {
                vector.addElement(edge.getOtherVertex(this));
            }
            catch (VertexMissingException vertexMissingException) {}
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateDirectedNeighbors(Net net) {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!net.contains(edge) || edge.isUndirected()) continue;
            try {
                vector.addElement(edge.getOtherVertex(this));
            }
            catch (VertexMissingException vertexMissingException) {}
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateEdges() {
        if (this.zWarnMultipleNets && this.setNets.size() > 1) {
            System.out.println("[Vertex.enumerateEdges()[" + this + "]] More than one net available (" + this.setNets.size() + " nets).  Use method enumerateEdges(Net) instead.");
        }
        return this._enumerateEdges();
    }

    public Enumeration enumerateEdges(Net net) {
        if (net == null) {
            return this._enumerateEdges();
        }
        return this._enumerateEdges(net);
    }

    public Enumeration enumerateEdgesByNotSystemKey(Object object) {
        if (object == null) {
            return GraphObject.EMPTY_ENUMERATION;
        }
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (edge.systemdict.containsKey(object)) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateEdgesByNotUserKey(Object object) {
        if (object == null) {
            return GraphObject.EMPTY_ENUMERATION;
        }
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (edge.userdict.containsKey(object)) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateEdgesBySystemKey(Net net, Object object) {
        if (net == null) {
            return this._enumerateEdgesBySystemKey(object);
        }
        return this._enumerateEdgesBySystemKey(net, object);
    }

    public Enumeration enumerateEdgesBySystemKey(Object object) {
        return this._enumerateEdgesBySystemKey(object);
    }

    public Enumeration enumerateEdgesBySystemKeySetToValue(Net net, Object object, Object object2) {
        if (net == null) {
            return this._enumerateEdgesBySystemKeySetToValue(object, object2);
        }
        if (object == null) {
            return GraphObject.EMPTY_ENUMERATION;
        }
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this._enumerateEdgesBySystemKey(net, object);
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.systemdict.get(object).equals(object2)) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateEdgesBySystemKeySetToValue(Object object, Object object2) {
        return this._enumerateEdgesBySystemKeySetToValue(object, object2);
    }

    public Enumeration enumerateEdgesByUserKey(Object object) {
        return this._enumerateEdgesByUserKey(object);
    }

    public Enumeration enumerateEdgesByUserKeySetToValue(Object object, Object object2) {
        if (object == null) {
            return GraphObject.EMPTY_ENUMERATION;
        }
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this._enumerateEdgesByUserKey(object);
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.userdict.get(object).equals(object2)) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateIncomingDirectedEdges() {
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.isDirected() || edge.getToVertex() != this) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateIncomingDirectedEdges(Net net) {
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!net.contains(edge) || !edge.isDirected() || edge.getToVertex() != this) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateIncomingDirectedNeighbors() {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.isDirected() || edge.getToVertex() != this) continue;
            vector.addElement(edge.getFromVertex());
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateIncomingDirectedNeighbors(Net net) {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!net.contains(edge) || !edge.isDirected() || edge.getToVertex() != this) continue;
            vector.addElement(edge.getFromVertex());
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateIncomingEdges() {
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (edge.isDirected() && edge.getToVertex() != this) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateIncomingEdges(Net net) {
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!net.contains(edge) || edge.isDirected() && edge.getToVertex() != this) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateIncomingNeighbors() {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (edge.isDirected() && edge.getToVertex() != this) continue;
            try {
                vector.addElement(edge.getOtherVertex(this));
            }
            catch (VertexMissingException vertexMissingException) {}
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateIncomingNeighbors(Net net) {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!net.contains(edge) || edge.isDirected() && edge.getToVertex() != this) continue;
            try {
                vector.addElement(edge.getOtherVertex(this));
            }
            catch (VertexMissingException vertexMissingException) {}
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateNeighbors() {
        if (this.zWarnMultipleNets && this.setNets.size() > 1) {
            System.out.println("[Vertex.enumerateNeighbors()[" + this + "]] More than one net available.  Use method enumerateNeighbors(Net) instead.");
        }
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            try {
                Vertex vertex = ((Edge)enumeration.nextElement()).getOtherVertex(this);
                if (vector.contains(vertex)) continue;
                vector.addElement(vertex);
            }
            catch (VertexMissingException vertexMissingException) {}
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateNeighbors(Net net) {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this.enumerateEdges(net);
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            try {
                Vertex vertex = edge.getOtherVertex(this);
                if (!net.contains(vertex)) {
                    System.out.println("!BUG![Vertex.enumerateNeighbors()] Found an edge belonging to a net with an end vertex not belonging to the net.");
                    System.out.println("----- net    is:\n" + net);
                    System.out.println("----- this   is:\n" + this);
                    System.out.println("----- vertex is:\n" + vertex);
                    System.out.println("----- edge   is:\n" + edge);
                }
                if (vector.contains(vertex)) continue;
                vector.addElement(vertex);
            }
            catch (VertexMissingException vertexMissingException) {}
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateNets() {
        return this.setNets.elements();
    }

    public Enumeration enumerateOutgoingDirectedEdges() {
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.isDirected() || edge.getFromVertex() != this) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateOutgoingDirectedEdges(Net net) {
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!net.contains(edge) || !edge.isDirected() || edge.getFromVertex() != this) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateOutgoingDirectedNeighbors() {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.isDirected() || edge.getFromVertex() != this) continue;
            vector.addElement(edge.getToVertex());
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateOutgoingDirectedNeighbors(Net net) {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!net.contains(edge) || !edge.isDirected() || edge.getFromVertex() != this) continue;
            vector.addElement(edge.getToVertex());
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateOutgoingEdges() {
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (edge.isDirected() && edge.getFromVertex() != this) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateOutgoingEdges(Net net) {
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!net.contains(edge) || edge.isDirected() && edge.getFromVertex() != this) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateOutgoingNeighbors() {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (edge.isDirected() && edge.getFromVertex() != this) continue;
            try {
                vector.addElement(edge.getOtherVertex(this));
            }
            catch (VertexMissingException vertexMissingException) {}
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateOutgoingNeighbors(Net net) {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!net.contains(edge) || edge.isDirected() && edge.getFromVertex() != this) continue;
            try {
                vector.addElement(edge.getOtherVertex(this));
            }
            catch (VertexMissingException vertexMissingException) {}
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateUndirectedEdges() {
        if (this.zWarnMultipleNets && this.setNets.size() > 1) {
            System.out.println("[Vertex.enumerateUndirectedEdges()[" + this + "]] More than one net available (" + this.setNets.size() + " nets).  Use method enumerateUndirectedEdges(Net) instead.");
        }
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (edge.isDirected()) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateUndirectedEdges(Net net) {
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!net.contains(edge) || edge.isDirected()) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateUndirectedNeighbors() {
        if (this.zWarnMultipleNets && this.setNets.size() > 1) {
            System.out.println("[Vertex.enumerateUndirectedEdges()[" + this + "]] More than one net available (" + this.setNets.size() + " nets).  Use method enumerateUndirectedEdges(Net) instead.");
        }
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (edge.isDirected()) continue;
            try {
                vector.addElement(edge.getOtherVertex(this));
            }
            catch (VertexMissingException vertexMissingException) {}
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateUndirectedNeighbors(Net net) {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this.setEdges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!net.contains(edge) || edge.isDirected()) continue;
            try {
                vector.addElement(edge.getOtherVertex(this));
            }
            catch (VertexMissingException vertexMissingException) {}
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    protected void finalize() {
        this.removeAllEdges();
    }

    Edge getEdge(int n) throws ArrayIndexOutOfBoundsException {
        return (Edge)this.setEdges.elementAt(n);
    }

    public int getEnumerationSize() {
        return this._iEnumerationSize;
    }

    int getIndex(Edge edge) throws IllegalArgumentException {
        if (edge == null) {
            Throw.throwIllegalArgumentException(_strClassName, this._getIndexMethod(edge), " Null edge.");
        }
        if (!this.setEdges.contains(edge)) {
            Throw.throwIllegalArgumentException(_strClassName, this._getIndexMethod(edge), " Edge not incident.");
        }
        int n = 0;
        Enumeration enumeration = this.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge2 = (Edge)enumeration.nextElement();
            if (edge2 == edge) break;
            ++n;
        }
        return n;
    }

    public Net getNet() {
        try {
            return (Net)this.setNets.firstElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            if (this.getWarningLevel() == 1) {
                System.out.println("[Vertex.getNet()] This vertex does not belong to any net.");
                System.out.println("\tfor vertex: " + this);
            }
            return null;
        }
    }

    public Net getNet(int n) {
        try {
            return (Net)this.setNets.get(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.getWarningLevel() == 1) {
                System.out.println("[Vertex.getNet(" + n + ")] Index out of bounds.  Only " + this.setNets.size() + " nets available.");
                System.out.println("\tfor vertex: " + this);
            }
            return null;
        }
    }

    public int getNetCount() {
        return this.setNets.size();
    }

    public Dict getNetDict(Net net, boolean bl) {
        Dict dict = null;
        try {
            dict = (Dict)this.systemdict.get(net);
        }
        catch (NullPointerException nullPointerException) {
            if (net == null) {
                return null;
            }
            if (net.systemdict == null) {
                return null;
            }
        }
        catch (ClassCastException classCastException) {}
        if (dict == null && !bl) {
            dict = this.systemdict;
        }
        return dict;
    }

    public boolean getWarnMultipleNets() {
        return this.zWarnMultipleNets;
    }

    public boolean isALeaf() {
        return this._degreeOutgoing() == 0;
    }

    public boolean isALeaf(Net net) {
        return this._degreeOutgoing(net) == 0;
    }

    public boolean isARoot() {
        return this._degreeIncoming() == 0;
    }

    public boolean isARoot(Net net) {
        return this._degreeIncoming(net) == 0;
    }

    public boolean isAdjacent(Net net, Vertex vertex) {
        Enumeration enumeration = this.enumerateNeighbors(net);
        while (enumeration.hasMoreElements()) {
            Vertex vertex2 = (Vertex)enumeration.nextElement();
            if (vertex2 != vertex) continue;
            return true;
        }
        return false;
    }

    public boolean isAdjacent(Vertex vertex) {
        if (this.zWarnMultipleNets && this.setNets.size() > 1) {
            System.out.println("[Vertex.isAdjacent(" + vertex + ")[" + this + "]] More than one net available.  Use method isAdjacent(Net,Vertex) instead.");
        }
        Enumeration enumeration = this.enumerateNeighbors();
        while (enumeration.hasMoreElements()) {
            Vertex vertex2 = (Vertex)enumeration.nextElement();
            if (vertex2 != vertex) continue;
            return true;
        }
        return false;
    }

    public boolean isRoot() {
        String string = Net.getKeyRootDefault();
        if (this.systemdict.containsKey(string)) {
            try {
                return this.systemdict.getBoolean(string);
            }
            catch (ClassCastException classCastException) {
            }
            catch (KeyMissingException keyMissingException) {
            }
        }
        return false;
    }

    boolean move(Net net, Net net2) {
        if (this.$iVerboseMethod >= 3) {
            this.$printMethod(GraphObject.out, _strClassName, this._moveMethod(net, net2), "{");
        }
        if (!this.add(net2)) {
            if (this.$iVerboseMethod >= 3) {
                this.$printMethod(GraphObject.out, _strClassName, this._moveMethod(net, net2), "} Failed to add to " + net2.getName());
            }
            return false;
        }
        if (!this.remove(net)) {
            if (!this.remove(net2)) {
                Throw.throwError(_strClassName, "move(Net,Net)", "Could not remove a just added net from this vertex' net-set. BUG?!");
            }
            if (this.$iVerboseMethod >= 3) {
                this.$printMethod(GraphObject.out, _strClassName, this._moveMethod(net, net2), "} Failed to remove from " + net.getName());
            }
            return false;
        }
        if (this.$iVerboseMethod >= 3) {
            this.$printMethod(GraphObject.out, _strClassName, this._moveMethod(net, net2), "} Moved.");
        }
        return true;
    }

    public void print(PrintStream printStream, int n) {
        int n2 = n;
        Util.printlnIndented(printStream, n2, "Vertex: " + this.toString());
        Util.printlnIndented(printStream, n2 += 2, "systemdict:");
        this.systemdict.print(printStream, n2 += 2);
        Util.printlnIndented(printStream, n2 -= 2, "userdict");
        this.userdict.print(printStream, n2 += 2);
    }

    protected Set reachable() {
        int n = 0;
        int n2 = 0;
        Set set = new Set();
        set.insertElementAt(this, n++);
        while (n2 < n) {
            Vertex vertex = (Vertex)set.elementAt(n2++);
            Enumeration enumeration = vertex.allNeighbors().elements();
            while (enumeration.hasMoreElements()) {
                Vertex vertex2 = (Vertex)enumeration.nextElement();
                if (set.contains(vertex2)) continue;
                set.insertElementAt(vertex2, n++);
            }
        }
        return set;
    }

    protected Set reachable(Net net) {
        int n = 0;
        int n2 = 0;
        Set set = new Set();
        set.insertElementAt(this, n++);
        while (n2 < n) {
            Vertex vertex = (Vertex)set.elementAt(n2++);
            Enumeration enumeration = vertex.allNeighbors(net).elements();
            while (enumeration.hasMoreElements()) {
                Vertex vertex2 = (Vertex)enumeration.nextElement();
                if (set.contains(vertex2)) continue;
                set.insertElementAt(vertex2, n++);
            }
        }
        return set;
    }

    boolean remove(Edge edge) {
        if (!this.setEdges.contains(edge)) {
            return false;
        }
        this.setEdges.removeElement(edge);
        return true;
    }

    boolean remove(Net net) {
        return this.setNets.removeElement(net);
    }

    void removeAllEdges() {
        this.setEdges.removeAllElements();
    }

    private void setDebugLevel(int n) {
        switch (n) {
            case 0: {
                this.bReportNullResults = false;
                this.bReportNullParameters = false;
                break;
            }
            case 1: {
                this.bReportNullParameters = true;
                this.bReportNullResults = false;
                break;
            }
            case 2: {
                this.bReportNullResults = true;
                this.bReportNullResults = true;
                break;
            }
            default: {
                System.out.println("?![[Vertex.setDebugLevel(" + n + ")] Invalid parameter.]?!");
            }
        }
    }

    private void setTraceLevel(int n) {
        switch (n) {
            case 0: {
                this.bTracePrivateMethods = false;
                this.bTraceProtectedMethods = false;
                this.bTracePublicMethods = false;
                break;
            }
            case 1: {
                this.bTracePublicMethods = true;
                this.bTracePrivateMethods = false;
                this.bTraceProtectedMethods = false;
                break;
            }
            case 2: {
                this.bTraceProtectedMethods = true;
                this.bTracePrivateMethods = false;
                this.bTracePublicMethods = false;
                break;
            }
            case 3: {
                this.bTraceProtectedMethods = true;
                this.bTracePublicMethods = true;
                this.bTracePrivateMethods = false;
                break;
            }
            case 4: {
                this.bTracePrivateMethods = true;
                this.bTraceProtectedMethods = false;
                this.bTracePublicMethods = false;
                break;
            }
            case 5: {
                this.bTracePrivateMethods = true;
                this.bTracePublicMethods = true;
                this.bTraceProtectedMethods = false;
                break;
            }
            case 6: {
                this.bTracePrivateMethods = true;
                this.bTraceProtectedMethods = true;
                this.bTracePublicMethods = false;
                break;
            }
            case 7: {
                this.bTracePrivateMethods = true;
                this.bTraceProtectedMethods = true;
                this.bTracePublicMethods = true;
                break;
            }
            default: {
                System.out.println("?![[Vertex.setTraceLevel(" + n + ")] Invalid parameter.]?!");
            }
        }
    }

    public void setWarnMultipleNets(boolean bl) {
        this.zWarnMultipleNets = bl;
    }

    public static void showHashCodeInToString(boolean bl) {
        _zShowHashCode = bl;
    }

    public String toString() {
        String string;
        try {
            string = _zShowHashCode ? "[Vertex(" + this.hashCode() + ") \"" + this.systemdict.getString(GraphObject.strKeyName) + "\"]" : "[Vertex \"" + this.systemdict.getString(GraphObject.strKeyName) + "\"]";
        }
        catch (KeyMissingException keyMissingException) {
            string = super.toString();
        }
        return string;
    }
}

