/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph;

import com.ibm.graph.Edge;
import com.ibm.graph.Graph;
import com.ibm.graph.InvalidNetException;
import com.ibm.graph.Net;
import com.ibm.graph.TreeRootMissingException;
import com.ibm.graph.Vertex;
import com.ibm.graph.VertexMissingException;
import com.ibm.research.util.Dict;
import com.ibm.research.util.KeyMissingException;
import java.util.Enumeration;
import java.util.Vector;

public class Tree
extends Graph {
    private static final String _strClassName = "Tree";

    public Tree() {
    }

    public Tree(Net net) throws InvalidNetException {
        if (!net.isTree()) {
            throw new InvalidNetException("[com.ibm.graph.Tree(Net)]");
        }
        Enumeration enumeration = net.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            this.add((Vertex)enumeration.nextElement());
        }
        Enumeration enumeration2 = net.enumerateEdges();
        while (enumeration2.hasMoreElements()) {
            this.add((Edge)enumeration2.nextElement());
        }
    }

    private void _execDepthFirstTraversal(Vertex vertex, Vector vector, Vector vector2, String string, int n, boolean bl) {
        Vector<Vertex> vector3 = vector == null ? new Vector<Vertex>() : vector;
        if (string != null) {
            vertex.systemdict.def((Object)string, n);
        }
        vector3.addElement(vertex);
        Enumeration enumeration = vertex.enumerateEdges(this);
        while (enumeration.hasMoreElements()) {
            Vertex vertex2;
            Edge edge = (Edge)enumeration.nextElement();
            try {
                vertex2 = edge.getOtherVertex(vertex);
            }
            catch (VertexMissingException vertexMissingException) {
                continue;
            }
            if (vector3.contains(vertex2)) continue;
            if (bl && vector2 != null) {
                vector2.addElement(edge);
            }
            this._execDepthFirstTraversal(vertex2, vector3, vector2, string, n + 1, bl);
            if (bl || vector2 == null) continue;
            vector2.addElement(edge);
        }
        if (!bl) {
            vector3.removeElement(vertex);
            vector3.addElement(vertex);
        }
    }

    private Vertex _findRoot(Vertex vertex) throws TreeRootMissingException {
        if (vertex == null) {
            return vertex;
        }
        if (this._isRoot(vertex)) {
            return vertex;
        }
        Enumeration enumeration = this.enumerateDepthFirstTraversal(vertex);
        while (enumeration.hasMoreElements()) {
            Vertex vertex2 = (Vertex)enumeration.nextElement();
            if (!this._isRoot(vertex2)) continue;
            return vertex2;
        }
        throw new TreeRootMissingException();
    }

    private boolean _isRoot(Vertex vertex) {
        boolean bl;
        block9: {
            block8: {
                bl = false;
                if (vertex == null) break block9;
                if (vertex.systemdict.containsKey(this)) {
                    try {
                        Dict dict = (Dict)vertex.systemdict.get(this);
                        if (!dict.containsKey(Net._strKeyRootDefault)) break block8;
                        try {
                            bl = dict.getBoolean(Net._strKeyRootDefault);
                            break block9;
                        }
                        catch (KeyMissingException keyMissingException) {
                        }
                    }
                    catch (ClassCastException classCastException) {}
                }
            }
            if (vertex.systemdict.containsKey(Net._strKeyRootDefault)) {
                try {
                    bl = vertex.systemdict.getBoolean(Net._strKeyRootDefault);
                }
                catch (KeyMissingException keyMissingException) {
                    System.out.println("[Tree.isRoot(" + vertex + ")] Key 'root' not found.");
                }
            }
        }
        return bl;
    }

    private void _resetRoot(Vertex vertex) {
        if (vertex.systemdict.containsKey(this)) {
            try {
                Dict dict = (Dict)vertex.systemdict.get(this);
                if (dict.containsKey(Net._strKeyRootDefault)) {
                    dict.def((Object)Net._strKeyRootDefault, false);
                    return;
                }
            }
            catch (ClassCastException classCastException) {}
        }
        if (!vertex.systemdict.containsKey(Net._strKeyRootDefault)) {
            return;
        }
        vertex.systemdict.def((Object)Net._strKeyRootDefault, false);
    }

    public synchronized Enumeration enumerateDepthFirstTraversal(Vertex vertex) {
        return this.enumerateDepthFirstTraversal(true, vertex);
    }

    public synchronized Enumeration enumerateDepthFirstTraversal(Vertex vertex, String string) {
        return this.enumerateDepthFirstTraversal(true, vertex, string);
    }

    public synchronized Enumeration enumerateDepthFirstTraversal(boolean bl, Vertex vertex) {
        Vector vector = new Vector();
        if (vertex != null) {
            this._execDepthFirstTraversal(vertex, vector, null, null, 0, bl);
        }
        return vector.elements();
    }

    public synchronized Enumeration enumerateDepthFirstTraversal(boolean bl, Vertex vertex, String string) {
        Vector vector = new Vector();
        if (vertex != null) {
            this._execDepthFirstTraversal(vertex, vector, null, string, 0, bl);
        }
        return vector.elements();
    }

    public synchronized Enumeration enumerateDepthFirstTraversalEdges(Vertex vertex) {
        return this.enumerateDepthFirstTraversalEdges(true, vertex);
    }

    public synchronized Enumeration enumerateDepthFirstTraversalEdges(boolean bl, Vertex vertex) {
        Vector vector = new Vector();
        if (vertex != null) {
            this._execDepthFirstTraversal(vertex, null, vector, null, 0, bl);
        }
        return vector.elements();
    }

    public Enumeration enumerateRoots() {
        return this.enumerateVerticesBySystemKeySetToValue((Object)Net._strKeyRootDefault, true);
    }

    public Vertex findRoot(Vertex vertex) throws TreeRootMissingException {
        return this._findRoot(vertex);
    }

    public boolean isRoot(Vertex vertex) {
        return this._isRoot(vertex);
    }

    public synchronized void setRoot(Vertex vertex) {
        if (vertex == null) {
            return;
        }
        if (!this.contains(vertex)) {
            return;
        }
        try {
            Vertex vertex2 = this._findRoot(vertex);
            vertex2.systemdict.def((Object)Net._strKeyRootDefault, false);
        }
        catch (TreeRootMissingException treeRootMissingException) {}
        vertex.systemdict.def((Object)Net._strKeyRootDefault, true);
    }

    protected boolean validEdge(Edge edge) {
        if (this.$iVerboseMethod >= 2) {
            System.out.println("[Tree.validEdge(" + edge + ")]");
        }
        boolean bl = true;
        bl = super.validEdge(edge);
        if (bl && !edge.getFromVertex().reachable(this).and(edge.getToVertex().reachable(this)).isEmpty()) {
            bl = false;
        }
        if (this.$iVerboseMethod >= 2) {
            System.out.println("[Tree.validEdge(" + edge + ")] " + bl);
        }
        return bl;
    }
}

