/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph;

import com.ibm.graph.Edge;
import com.ibm.graph.GraphObject;
import com.ibm.graph.InvalidEdgeException;
import com.ibm.graph.Net;
import com.ibm.graph.Path;
import com.ibm.graph.Tree;
import com.ibm.graph.Vertex;
import com.ibm.graph.VertexMissingException;
import com.ibm.research.util.Dict;
import com.ibm.research.util.KeyMissingException;
import com.ibm.research.util.Throw;
import java.util.Enumeration;
import java.util.Vector;

public class SingleTree
extends Tree {
    private String _INDENTATION = "  ";
    private static final String _strClassName = "SingleTree";
    private static String _strKeyParentDefault = "%%Parent";
    private static String X_NULL_TREE = "Null tree.";
    private static String X_NOT_CHILD = "Not child of parent.";
    private static String X_NOT_IN_TREE = "Tree does not contain vertex.";
    private static String X_LEAF_VERTEX = "Vertex is a leaf.";
    private static String X_ROOT_VERTEX = "Vertex is the root.";
    private static String X_SHARED_VERTICES = "Trees share common graph-objects.";
    private static String _strKeyParent = null;

    public SingleTree() {
    }

    public SingleTree(Vertex vertex) {
        this._setRoot(vertex);
    }

    private final String __checkParmIndexForGetMethod(Vertex vertex, int n) {
        return "_checkParmIndexForGet(" + vertex + "," + n + ")";
    }

    private final String __checkParmIndexForInsertMethod(Vertex vertex, int n) {
        return "_checkParmIndexForInsert(" + vertex + "," + n + ")";
    }

    private final String __getParentEdgeIndexMethod(Vertex vertex, String string) {
        return "_getParentEdgeIndexMethod(" + vertex + "," + string + ")";
    }

    private void _addSubTree(Vertex vertex, SingleTree singleTree, SingleTree singleTree2, String string) {
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, this._addSubTreeMethod(vertex, singleTree2, string), "{");
        }
        Vertex vertex2 = null;
        Enumeration enumeration = vertex.enumerateEdges(singleTree);
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            try {
                vertex2 = edge.getOtherVertex(vertex);
            }
            catch (VertexMissingException vertexMissingException) {
                Throw.throwError(_strClassName, string, "Unexpected vertex-missing-exception. BUG?!");
            }
            if (vertex2 == this._getParent(vertex)) continue;
            if (!edge.add(singleTree2) || !singleTree2.add(edge)) {
                Throw.throwError(_strClassName, string, "Could not add tree to edge's net-set. BUG?!");
            }
            this._addSubTree(vertex2, singleTree, singleTree2, string);
        }
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, this._addSubTreeMethod(vertex, singleTree2, string), "}");
        }
    }

    private String _addSubTreeMethod(Vertex vertex, SingleTree singleTree, String string) {
        return "_addSubTreeMethod(" + vertex + "," + singleTree + "," + string + ")";
    }

    private String _checkParmChild(Vertex vertex) {
        if (vertex == null) {
            return Net.X_NULL_VERTEX;
        }
        if (this.contains(vertex)) {
            return "Child already belongs to tree (" + this + ").";
        }
        return null;
    }

    private String _checkParmHasChild(Vertex vertex) {
        if (vertex == null) {
            return Net.X_NULL_VERTEX;
        }
        if (!this.contains(vertex)) {
            return X_NOT_IN_TREE;
        }
        if (vertex == this._getRoot()) {
            return X_ROOT_VERTEX;
        }
        return null;
    }

    private String _checkParmHasVertex(Vertex vertex) {
        if (vertex == null) {
            return Net.X_NULL_VERTEX;
        }
        if (!this.contains(vertex)) {
            return X_NOT_IN_TREE;
        }
        return null;
    }

    private String _checkParmIndexForGet(Vertex vertex, int n) {
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, this.__checkParmIndexForGetMethod(vertex, n), "{ child_count = " + this._getChildCount(vertex));
        }
        String string = null;
        if (n >= this._getChildCount(vertex)) {
            string = "Out of bounds index. Child count is " + this._getChildCount(vertex);
        }
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, this.__checkParmIndexForGetMethod(vertex, n), "} " + string);
        }
        return string;
    }

    private String _checkParmIndexForInsert(Vertex vertex, int n) {
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, this.__checkParmIndexForInsertMethod(vertex, n), "{ child_count = " + this._getChildCount(vertex));
        }
        String string = null;
        if (n > this._getChildCount(vertex)) {
            string = "Out of bounds index. Child count is " + this._getChildCount(vertex);
        }
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, this.__checkParmIndexForInsertMethod(vertex, n), "} " + string);
        }
        return string;
    }

    private String _checkParmParent(Vertex vertex) {
        String string = this._checkParmHasVertex(vertex);
        if (string != null) {
            return string;
        }
        return null;
    }

    private String _checkParmParentChild(Vertex vertex, Vertex vertex2) {
        String string = this._checkParmHasVertex(vertex);
        if (string != null) {
            return string;
        }
        string = this._checkParmChild(vertex2);
        if (string != null) {
            return string;
        }
        return null;
    }

    private String _checkParmParentMissingChild(Vertex vertex, Vertex vertex2) {
        String string = this._checkParmHasVertex(vertex);
        if (string != null) {
            return string;
        }
        string = this._checkParmHasChild(vertex2);
        if (string != null) {
            return string;
        }
        return null;
    }

    private int _correctChildIndex(Vertex vertex, int n) {
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, "_" + this._correctChildIndexMethod(vertex, n), "{");
        }
        int n2 = n;
        if (!this._isRoot(vertex) && n2 >= this._getParentEdgeIndex(vertex, "")) {
            ++n2;
        }
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, "_" + this._correctChildIndexMethod(vertex, n), "} " + n2);
        }
        return n2;
    }

    private final String _correctChildIndexMethod(Vertex vertex, int n) {
        return "_correctChildIndex(" + vertex + "," + n + ")";
    }

    private void _deleteChild(Vertex vertex, int n) {
        if (this.$iVerboseMethod >= 4) {
            System.out.println("[" + this._deleteChildMethod(vertex, n) + "]{");
        }
        int n2 = this._correctChildIndex(vertex, n);
        Edge edge = null;
        try {
            edge = vertex.getEdge(n2);
            if (this.$iVerboseMethod >= 4) {
                System.out.println("\tedge to delete = " + edge);
            }
            if (edge.isUndirected()) {
                System.err.println("[" + this._deleteChildMethod(vertex, n) + "] Warning: edge (" + edge + ") is undirected.  SingleTree objects require (parent-to-child) directed edges.");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Throw.throwError(_strClassName, this._removeChildMethod(vertex, n), "Invalid index escaped detection. BUG?!");
        }
        Vertex vertex2 = null;
        try {
            vertex2 = edge.getOtherVertex(vertex);
            if (this.$iVerboseMethod >= 4) {
                System.out.println("\tchild to delete = " + edge);
            }
        }
        catch (VertexMissingException vertexMissingException) {
            Throw.throwError(_strClassName, this._deleteChildMethod(vertex, n), "Unexpected vertex-missing-exception. BUG?!");
        }
        if (!vertex.remove(edge)) {
            Throw.throwError(_strClassName, this._removeChildMethod(vertex, n), "Could not remove edge probably incident to (parent) vertex. BUG?!");
        }
        if (!vertex2.remove(edge)) {
            Throw.throwError(_strClassName, this._removeChildMethod(vertex, n), "Could not remove edge probably incident to (child) vertex. BUG?!");
        }
        if (!this.remove(edge)) {
            Throw.throwError(_strClassName, this._removeChildMethod(vertex, n), "Could not remove edge probably contained in tree. BUG?!");
        }
        this._deleteSubTree(vertex2, this._deleteChildMethod(vertex, n));
        if (this.$iVerboseMethod >= 4) {
            System.out.println("[" + this._deleteChildMethod(vertex, n) + "]}");
        }
    }

    private final String _deleteChildMethod(Vertex vertex, int n) {
        return "deleteChild(" + vertex + "," + n + ")";
    }

    private final String _deleteFirstChildMethod(Vertex vertex) {
        return "deleteFirstChild(" + vertex + ")";
    }

    private final String _deleteLastChildMethod(Vertex vertex) {
        return "deleteLastChild(" + vertex + ")";
    }

    private void _deleteSubTree(Vertex vertex, String string) {
        if (this.$iVerboseMethod >= 4) {
            System.out.println("[SingleTree._deleteSubTree(" + vertex + ",String)]{");
        }
        if (!this.remove(vertex)) {
            Throw.throwError(_strClassName, string, "Could not remove vertex probably contained in tree. BUG?!");
        }
        Vertex vertex2 = null;
        Enumeration enumeration = vertex.enumerateEdges(this);
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            try {
                vertex2 = edge.getOtherVertex(vertex);
            }
            catch (VertexMissingException vertexMissingException) {
                Throw.throwError(_strClassName, string, "Unexpected vertex-missing-exception. BUG?!");
            }
            if (vertex2 == this._getParent(vertex)) continue;
            this._deleteSubTree(vertex2, string);
        }
        if (this.$iVerboseMethod >= 4) {
            System.out.println("[SingleTree._deleteSubTree(" + vertex + ",String)]}");
        }
    }

    private Enumeration _enumerateChildren(Vertex vertex) {
        return vertex.enumerateOutgoingDirectedNeighbors(this);
    }

    private final String _enumerateChildrenMethod(Vertex vertex) {
        return "enumerateChildren(" + vertex + ")";
    }

    private Vertex _getAncestorAtDepth(Vertex vertex, int n) {
        int n2 = this._getDepth(vertex);
        if (n2 < n) {
            return null;
        }
        if (n2 == n) {
            return vertex;
        }
        Vertex vertex2 = vertex;
        while (n2 > n) {
            vertex2 = this._getParent(vertex2);
            --n2;
        }
        return vertex2;
    }

    private final String _getAncestorAtDepthMethod(Vertex vertex, int n) {
        return "getAncestorAtDepth(" + vertex + "," + n + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Vertex _getChild(Vertex vertex, int n) {
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, "_" + this._getChildMethod(vertex, n), "{");
        }
        int n2 = this._correctChildIndex(vertex, n);
        Vertex vertex2 = null;
        try {
            Vertex vertex3;
            try {
                vertex3 = vertex2 = vertex.getEdge(n2).getOtherVertex(vertex);
                Object var7_6 = null;
                if (this.$iVerboseMethod < 4) return vertex3;
            }
            catch (VertexMissingException vertexMissingException) {
                Throw.throwError(_strClassName, this._getChildMethod(vertex, n), "Unexpected missing vertex exception. BUG?!");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                Throw.throwError(_strClassName, this._getChildMethod(vertex, n), "Invalid index escaped detection. BUG?!");
            }
            this.$printMethod(GraphObject.out, _strClassName, "_" + this._getChildMethod(vertex, n), "} " + vertex2);
            return vertex3;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (this.$iVerboseMethod < 4) throw throwable;
            this.$printMethod(GraphObject.out, _strClassName, "_" + this._getChildMethod(vertex, n), "} " + vertex2);
            throw throwable;
        }
        Object var7_7 = null;
        if (this.$iVerboseMethod < 4) return null;
        this.$printMethod(GraphObject.out, _strClassName, "_" + this._getChildMethod(vertex, n), "} " + vertex2);
        return null;
    }

    private int _getChildCount(Vertex vertex) throws IllegalArgumentException {
        if (vertex == null) {
            Throw.throwIllegalArgumentException(_strClassName, this._getChildCountMethod(vertex), Net.X_NULL_VERTEX);
        }
        if (!this.contains(vertex)) {
            Throw.throwIllegalArgumentException(_strClassName, this._getChildCountMethod(vertex), X_NOT_IN_TREE);
        }
        if (vertex == this._getRoot()) {
            return vertex.degree(this);
        }
        return vertex.degree(this) - 1;
    }

    private final String _getChildCountMethod(Vertex vertex) {
        return "getChildCount(" + vertex + ")";
    }

    private final String _getChildMethod(Vertex vertex, int n) {
        return "getChild(" + vertex + "," + n + ")";
    }

    private Vertex _getCommonAncestor(Vertex vertex, Vertex vertex2) {
        Vertex vertex3;
        Vertex vertex4;
        int n;
        int n2 = this._getDepth(vertex);
        if (n2 < (n = this._getDepth(vertex2))) {
            vertex4 = vertex;
            vertex3 = this._getAncestorAtDepth(vertex2, n2);
        } else if (n2 > n) {
            vertex4 = this._getAncestorAtDepth(vertex, n);
            vertex3 = vertex2;
        } else {
            vertex4 = vertex;
            vertex3 = vertex2;
        }
        while (vertex4 != vertex3) {
            vertex4 = this._getParent(vertex4);
            vertex3 = this._getParent(vertex3);
        }
        return vertex4;
    }

    private final String _getCommonAncestorMethod(Vertex vertex, Vertex vertex2) {
        return "getCommonAncestorMethod(" + vertex + "," + vertex2 + ")";
    }

    private int _getDepth(Vertex vertex) {
        Vertex vertex2 = vertex;
        int n = 0;
        while (!this._isRoot(vertex2)) {
            vertex2 = this._getParent(vertex2);
            ++n;
        }
        return n;
    }

    private final String _getDepthMethod(Vertex vertex) {
        return "getDepth(" + vertex + ")";
    }

    private final String _getFirstChildMethod(Vertex vertex) {
        return "getFirstChild(" + vertex + ")";
    }

    private String _getIndent(int n) {
        StringBuffer stringBuffer = new StringBuffer(n * this._INDENTATION.length());
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this._INDENTATION);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private int _getIndexOfChild(Vertex vertex, Vertex vertex2) {
        int n = 0;
        Enumeration enumeration = vertex.enumerateNeighbors(this);
        while (enumeration.hasMoreElements()) {
            Vertex vertex3 = (Vertex)enumeration.nextElement();
            if (vertex3 == vertex2) break;
            ++n;
        }
        return this._correctChildIndex(vertex, n);
    }

    private String _getIndexOfChildMethod(Vertex vertex, Vertex vertex2) {
        return "getIndexOfChild(" + vertex + "," + vertex2 + ")";
    }

    private final String _getLastChildMethod(Vertex vertex) {
        return "getLastChild(" + vertex + ")";
    }

    private Dict _getNetDict(Vertex vertex) {
        Dict dict = (Dict)vertex.systemdict.get(this);
        if (dict == null) {
            dict = new Dict();
            vertex.systemdict.def((Object)this, dict);
        }
        return dict;
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vertex _getParent(Vertex var1_1) {
        var2_2 = var1_1.enumerateIncomingDirectedEdges(this);
        cfr_temp_0 = -2147483648;
        do {
            switch (cfr_temp_0 == -2147483648 ? var1_1.getEnumerationSize() : cfr_temp_0) {
                case 0: {
                    return null;
                }
                default: {
                    System.out.println("[SingleTree._getParent(" + var1_1 + ")] Error report:");
                    var3_3 = var1_1.enumerateIncomingDirectedEdges(this);
                    ** GOTO lbl23
                }
                while (true) {
                    try {
                        return ((Edge)var2_2.nextElement()).getOtherVertex(var1_1);
                    }
                    catch (VertexMissingException v0) {
                        cfr_temp_0 = 1;
                        Throw.throwError("SingleTree", this._getParentMethod(var1_1), " Unexpected VertexMissingException. BUG?!");
                    }
                    break;
                }
                case 1: {
                    if (var2_2.hasMoreElements()) ** continue;
                    return null;
                }
            }
        } while (true);
        do {
            System.out.println((Edge)var3_3.nextElement());
lbl23:
            // 2 sources

        } while (var3_3.hasMoreElements());
        Throw.throwError("SingleTree", this._getParentMethod(var1_1), " Found a child with more than one parent in a single-tree(" + this + "). BUG?!");
        return null;
    }

    private Edge _getParentEdge(Vertex vertex) {
        Enumeration enumeration = vertex.enumerateIncomingDirectedEdges(this);
        int n = vertex.getEnumerationSize();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return (Edge)enumeration.nextElement();
            }
        }
        Throw.throwError(_strClassName, "", " Found vertex (" + vertex + ") with more than one parent in single-tree (" + this + "). BUG?!");
        return null;
    }

    private int _getParentEdgeIndex(Vertex vertex, String string) {
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, this.__getParentEdgeIndexMethod(vertex, string), "{");
        }
        Vertex vertex2 = this._getParent(vertex);
        int n = 0;
        Enumeration enumeration = vertex.enumerateEdges(this);
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            try {
                if (vertex2 == edge.getOtherVertex(vertex)) {
                    break;
                }
            }
            catch (VertexMissingException vertexMissingException) {
                Throw.throwError(_strClassName, string, "Unexpected vertex-missing-exception. BUG?!");
            }
            ++n;
        }
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, this.__getParentEdgeIndexMethod(vertex, string), "} " + n);
        }
        return n;
    }

    private final String _getParentEdgeMethod(Vertex vertex) {
        return "getParentEdge(" + vertex + ")";
    }

    private final String _getParentMethod(Vertex vertex) {
        return "getParent(" + vertex + ")";
    }

    private Path _getPath(Vertex vertex, Vertex vertex2) {
        Vertex vertex3 = this._getCommonAncestor(vertex, vertex2);
        int n = this._getDepth(vertex3);
        if (vertex == vertex3) {
            Path path = this._getPathToAncestorAtDepth(vertex2, n);
            path.reverse();
            return path;
        }
        if (vertex2 == vertex3) {
            Path path = this._getPathToAncestorAtDepth(vertex, n);
            return path;
        }
        Path path = this._getPathToAncestorAtDepth(vertex, n);
        Path path2 = this._getPathToAncestorAtDepth(vertex2, n);
        path2.reverse();
        try {
            path.concatenate(path2);
        }
        catch (InvalidEdgeException invalidEdgeException) {
            Throw.throwError(_strClassName, this._getPathMethod(vertex, vertex2), " Unexpected InvalidEdgeException thrown when concatenating trail (" + path2 + ") at the end of trail (" + path + "). BUG?!");
        }
        return path;
    }

    private final String _getPathMethod(Vertex vertex, Vertex vertex2) {
        return "getPathMethod(" + vertex + "," + vertex2 + ")";
    }

    private Path _getPathToAncestorAtDepth(Vertex vertex, int n) {
        int n2 = this._getDepth(vertex);
        if (n2 < n) {
            return null;
        }
        Path path = new Path(vertex);
        Vertex vertex2 = vertex;
        while (n2 > n) {
            Edge edge = this._getParentEdge(vertex2);
            try {
                path.insertAtTail(edge);
            }
            catch (InvalidEdgeException invalidEdgeException) {
                Throw.throwError(_strClassName, "", " Unexpected InvalidEdgeException (" + invalidEdgeException + ") thrown when inserting edge (" + edge + ") at the end of trail (" + path + "). BUG?!");
            }
            try {
                vertex2 = edge.getOtherVertex(vertex2);
            }
            catch (VertexMissingException vertexMissingException) {
                Throw.throwError(_strClassName, "", " Unexpected VertexMissingException thrown when inserting edge (" + edge + ") at the end of trail (" + path + "). BUG?!");
            }
            --n2;
        }
        return path;
    }

    private final String _getPathToAncestorAtDepthMethod(Vertex vertex, int n) {
        return "getPathToAncestorAtDepth(" + vertex + "," + n + ")";
    }

    private Vertex _getRoot() {
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, "_" + this._getRootMethod(), "{");
        }
        Vertex vertex = null;
        if (!this.isEmpty()) {
            Enumeration enumeration = this.enumerateVertices();
            while (enumeration.hasMoreElements()) {
                Vertex vertex2 = (Vertex)enumeration.nextElement();
                try {
                    if (!this._getNetDict(vertex2).getBoolean(this.getKeyRoot())) continue;
                    vertex = vertex2;
                    break;
                }
                catch (KeyMissingException keyMissingException) {}
            }
            if (vertex == null) {
                throw new Error("[SingleTree.getRoot()] No root found for the tree (\"" + this.getName() + "\").");
            }
        }
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, "_" + this._getRootMethod(), "}" + vertex);
        }
        return vertex;
    }

    private String _getRootMethod() {
        return "getRoot()";
    }

    private void _insertChild(Vertex vertex, SingleTree singleTree, int n, boolean bl) {
        Vertex vertex2 = singleTree.getRoot();
        if (bl) {
            this._moveSubTree(vertex2, singleTree, this, this._insertChildMethod(vertex, singleTree, n, bl));
        } else {
            this._addSubTree(vertex2, singleTree, this, this._insertChildMethod(vertex, singleTree, n, bl));
        }
        this._insertChild(vertex, vertex2, n);
    }

    private void _insertChild(Vertex vertex, Vertex vertex2, int n) {
        Edge edge;
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, "_" + this._insertChildMethod(vertex, vertex2, n), "{");
        }
        int n2 = this._correctChildIndex(vertex, n);
        if (this.$iVerboseMethod >= 4) {
            GraphObject.out.println("\tiAtIndexCorrected = " + n2);
        }
        if (!vertex.add(this, n2, edge = new Edge(vertex, vertex2, true))) {
            Throw.throwError(_strClassName, this._insertChildMethod(vertex, vertex2, n), "Invalid index escaped detection. BUG?!");
        }
        this.add(edge);
        this._setKeyRoot(vertex2, false);
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, "_" + this._insertChildMethod(vertex, vertex2, n), "}");
        }
    }

    private final String _insertChildMethod(Vertex vertex, SingleTree singleTree, int n, boolean bl) {
        return "insertChild(" + vertex + "," + singleTree + "," + n + "," + bl + ")";
    }

    private final String _insertChildMethod(Vertex vertex, Vertex vertex2, int n) {
        return "insertChild(" + vertex + "," + vertex2 + "," + n + ")";
    }

    private void _insertFirstChild(Vertex vertex, SingleTree singleTree, boolean bl) {
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, "_" + this._insertFirstChildMethod(vertex, singleTree, bl), "{");
        }
        Vertex vertex2 = singleTree.getRoot();
        this._insertFirstChild(vertex, vertex2);
        if (bl) {
            this._moveSubTree(vertex2, singleTree, this, this._insertFirstChildMethod(vertex, singleTree, bl));
        } else {
            this._addSubTree(vertex2, singleTree, this, this._insertFirstChildMethod(vertex, singleTree, bl));
        }
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, "_" + this._insertFirstChildMethod(vertex, singleTree, bl), "}");
        }
    }

    private void _insertFirstChild(Vertex vertex, Vertex vertex2) {
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, "_" + this._insertFirstChildMethod(vertex, vertex2), "{");
        }
        Edge edge = new Edge(vertex, vertex2, true);
        vertex.add(this, 0, edge);
        if (!this.add(edge)) {
            Throw.throwError(_strClassName, this._insertFirstChildMethod(vertex, vertex2), " Failed to add edge to tree. BUG?!");
        }
        this._setKeyRoot(vertex2, false);
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, "_" + this._insertFirstChildMethod(vertex, vertex2), "}");
        }
    }

    private final String _insertFirstChildMethod(Vertex vertex, SingleTree singleTree, boolean bl) {
        return "insertFirstChild(" + vertex + "," + singleTree + "," + bl + ")";
    }

    private final String _insertFirstChildMethod(Vertex vertex, Vertex vertex2) {
        return "insertFirstChild(" + vertex + "," + vertex2 + ")";
    }

    private void _insertLastChild(Vertex vertex, SingleTree singleTree, boolean bl) {
        Vertex vertex2 = singleTree.getRoot();
        if (bl) {
            this._moveSubTree(vertex2, singleTree, this, this._insertLastChildMethod(vertex, singleTree, bl));
        } else {
            this._addSubTree(vertex2, singleTree, this, this._insertLastChildMethod(vertex, singleTree, bl));
        }
        this._insertLastChild(vertex, vertex2);
    }

    private void _insertLastChild(Vertex vertex, Vertex vertex2) {
        Edge edge = new Edge(vertex, vertex2, true);
        vertex.add(edge);
        this.add(edge);
        this._setKeyRoot(vertex2, false);
    }

    private final String _insertLastChildMethod(Vertex vertex, SingleTree singleTree, boolean bl) {
        return "insertLastChild(" + vertex + "," + singleTree + "," + bl + ")";
    }

    private final String _insertLastChildMethod(Vertex vertex, Vertex vertex2) {
        return "insertLastChild(" + vertex + "," + vertex2 + ")";
    }

    private boolean _isLeaf(Vertex vertex) throws IllegalArgumentException {
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, "_" + this._isLeafMethod(vertex), "{");
        }
        if (vertex == null) {
            Throw.throwIllegalArgumentException(_strClassName, this._isLeafMethod(vertex), Net.X_NULL_VERTEX);
        }
        if (!this.contains(vertex)) {
            Throw.throwIllegalArgumentException(_strClassName, this._isLeafMethod(vertex), X_NOT_IN_TREE);
        }
        boolean bl = false;
        if (this._getChildCount(vertex) == 0) {
            bl = true;
        }
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, "_" + this._isLeafMethod(vertex), "} " + bl);
        }
        return bl;
    }

    private final String _isLeafMethod(Vertex vertex) {
        return "isLeaf(" + vertex + ")";
    }

    private boolean _isRoot(Vertex vertex) {
        try {
            return this._getNetDict(vertex).getBoolean(this.getKeyRoot());
        }
        catch (KeyMissingException keyMissingException) {
            return false;
        }
    }

    private final String _isRootMethod(Vertex vertex) {
        return "isRoot(" + vertex + ")";
    }

    private void _moveSubTree(Vertex vertex, SingleTree singleTree, SingleTree singleTree2, String string) {
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, "_" + this._moveSubTreeMethod(vertex, singleTree, singleTree2), "{");
        }
        Vertex vertex2 = null;
        Enumeration enumeration = vertex.enumerateEdges(singleTree);
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            try {
                vertex2 = edge.getOtherVertex(vertex);
            }
            catch (VertexMissingException vertexMissingException) {
                Throw.throwError(_strClassName, string, "Unexpected vertex-missing-exception. BUG?!");
            }
            if (vertex2 == this._getParent(vertex)) continue;
            if (!(edge.move(singleTree, singleTree2) && singleTree.remove(edge) && singleTree2.add(edge))) {
                Throw.throwError(_strClassName, string, "Could not move edge from one tree to another. BUG?!");
            }
            this._moveSubTree(vertex2, singleTree, singleTree2, string);
        }
        if (!singleTree.remove(vertex)) {
            Throw.throwError(_strClassName, string, "Could not remove vertex from tree. BUG?!");
        }
        if (this.$iVerboseMethod >= 4) {
            this.$printMethod(GraphObject.out, _strClassName, "_" + this._moveSubTreeMethod(vertex, singleTree, singleTree2), "}");
        }
    }

    private String _moveSubTreeMethod(Vertex vertex, SingleTree singleTree, SingleTree singleTree2) {
        return "_moveSubTreeMethod(" + vertex + "," + singleTree.getName() + "," + singleTree2.getName() + ")";
    }

    private SingleTree _removeChild(Vertex vertex, int n) {
        int n2 = this._correctChildIndex(vertex, n);
        Edge edge = null;
        try {
            edge = vertex.getEdge(n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Throw.throwError(_strClassName, this._removeChildMethod(vertex, n), "Invalid index escaped detection. BUG?!");
        }
        Vertex vertex2 = null;
        try {
            vertex2 = edge.getOtherVertex(vertex);
        }
        catch (VertexMissingException vertexMissingException) {
            Throw.throwError(_strClassName, this._removeChildMethod(vertex, n), "Unexpected vertex-missing-exception. BUG?!");
        }
        if (!this.remove(edge)) {
            System.out.println("\tedge = " + edge);
            System.out.println("\tedge contained in single-tree? " + this.contains(edge));
            System.out.println(this);
            Throw.throwError(_strClassName, this._removeChildMethod(vertex, n), "Could not remove edge probably contained in tree. BUG?!");
        }
        SingleTree singleTree = new SingleTree(vertex2);
        this._setKeyRoot(vertex2, true);
        this._moveSubTree(vertex2, this, singleTree, this._removeChildMethod(vertex, n));
        return singleTree;
    }

    private final String _removeChildMethod(Vertex vertex, int n) {
        return "removeChild(" + vertex + "," + n + ")";
    }

    private final String _removeFirstChildMethod(Vertex vertex) {
        return "removeFirstChild(" + vertex + ")";
    }

    private final String _removeLastChildMethod(Vertex vertex) {
        return "removeLastChild(" + vertex + ")";
    }

    private void _setKeyRoot(Vertex vertex, boolean bl) {
        this._getNetDict(vertex).def((Object)this._getKeyRoot(), bl);
    }

    private void _setRoot(Vertex vertex) {
        if (this.isEmpty()) {
            this.add(vertex);
            this._getNetDict(vertex).def((Object)this.getKeyRoot(), true);
        } else {
            Vertex vertex2;
            if (!this.contains(vertex)) {
                Throw.throwError(_strClassName, this._setRootMethod(vertex), String.valueOf(X_NOT_IN_TREE) + " BUG!?");
            }
            if (vertex != (vertex2 = this._getRoot())) {
                this._setKeyRoot(vertex2, false);
                this._setKeyRoot(vertex, true);
                this._validateTree(vertex2, vertex);
            }
        }
    }

    private final String _setRootMethod(Vertex vertex) {
        return "setRoot(" + vertex + ")";
    }

    private void _toString(StringBuffer stringBuffer, int n, Vertex vertex) {
        stringBuffer.append(String.valueOf(this._getIndent(n)) + vertex.toString() + "\n");
        Enumeration enumeration = this._enumerateChildren(vertex);
        while (enumeration.hasMoreElements()) {
            Vertex vertex2 = (Vertex)enumeration.nextElement();
            this._toString(stringBuffer, n + 1, vertex2);
        }
    }

    private void _validateTree(Vertex vertex, Vertex vertex2) {
        Path path = this._getPath(vertex, vertex2);
        Enumeration enumeration = path.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            edge.flipDirection();
        }
    }

    public void deleteChild(Vertex vertex, int n) throws IllegalArgumentException {
        String string = this._checkParmParent(vertex);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._deleteChildMethod(vertex, n), string);
        }
        if (this._isLeaf(vertex)) {
            Throw.throwIllegalArgumentException(_strClassName, this._deleteChildMethod(vertex, n), X_LEAF_VERTEX);
        }
        if ((string = this._checkParmIndexForGet(vertex, n)) != null) {
            Throw.throwIndexOutOfBoundsException(_strClassName, this._deleteChildMethod(vertex, n), string);
        }
        this._deleteChild(vertex, n);
    }

    public void deleteFirstChild(Vertex vertex) throws IllegalArgumentException {
        String string;
        if (this.$iVerboseMethod >= 1) {
            System.out.println("[SingleTree.deleteFirstChild(" + vertex + ")]{");
        }
        if ((string = this._checkParmHasVertex(vertex)) != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._deleteFirstChildMethod(vertex), string);
        }
        if (this._isLeaf(vertex)) {
            Throw.throwIllegalArgumentException(_strClassName, this._deleteFirstChildMethod(vertex), X_LEAF_VERTEX);
        }
        this._deleteChild(vertex, 0);
        if (this.$iVerboseMethod >= 1) {
            System.out.println("[SingleTree.deleteFirstChild(" + vertex + ")]}");
        }
    }

    public void deleteLastChild(Vertex vertex) throws IllegalArgumentException {
        String string = this._checkParmHasVertex(vertex);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._deleteLastChildMethod(vertex), string);
        }
        if (this._isLeaf(vertex)) {
            Throw.throwIllegalArgumentException(_strClassName, this._deleteLastChildMethod(vertex), X_LEAF_VERTEX);
        }
        this._deleteChild(vertex, this._getChildCount(vertex) - 1);
    }

    public Enumeration enumerateChildren(Vertex vertex) throws IllegalArgumentException {
        String string = this._checkParmHasVertex(vertex);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._enumerateChildrenMethod(vertex), string);
        }
        return this._enumerateChildren(vertex);
    }

    public Enumeration enumerateRoots() {
        if (this.isEmpty()) {
            return GraphObject.EMPTY_ENUMERATION;
        }
        Vector<Vertex> vector = new Vector<Vertex>();
        vector.addElement(this._getRoot());
        return vector.elements();
    }

    public Vertex getAncestorAtDepth(Vertex vertex, int n) throws IllegalArgumentException {
        String string = this._checkParmHasVertex(vertex);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._getAncestorAtDepthMethod(vertex, n), string);
        }
        if (n < 0) {
            Throw.throwIllegalArgumentException(_strClassName, this._getAncestorAtDepthMethod(vertex, n), " Negative depth (" + n + ").");
        }
        return this._getAncestorAtDepth(vertex, n);
    }

    public Vertex getChild(Vertex vertex, int n) throws IllegalArgumentException {
        if (this.$iVerboseMethod >= 1) {
            this.$printMethod(GraphObject.out, _strClassName, this._getChildMethod(vertex, n), "{");
        }
        Vertex vertex2 = null;
        String string = this._checkParmParent(vertex);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._getChildMethod(vertex, n), string);
        }
        if (!this._isLeaf(vertex)) {
            string = this._checkParmIndexForGet(vertex, n);
            if (string != null) {
                Throw.throwIndexOutOfBoundsException(_strClassName, this._getChildMethod(vertex, n), string);
            }
            vertex2 = this._getChild(vertex, n);
        }
        if (this.$iVerboseMethod >= 1) {
            this.$printMethod(GraphObject.out, _strClassName, this._getChildMethod(vertex, n), "} " + vertex2);
        }
        return vertex2;
    }

    public int getChildCount(Vertex vertex) throws IllegalArgumentException {
        return this._getChildCount(vertex);
    }

    public Vertex getCommonAncestor(Vertex vertex, Vertex vertex2) throws IllegalArgumentException {
        String string = this._checkParmHasVertex(vertex);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._getCommonAncestorMethod(vertex, vertex2), String.valueOf(string) + "(" + vertex + ")");
        }
        if ((string = this._checkParmHasVertex(vertex2)) != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._getCommonAncestorMethod(vertex, vertex2), String.valueOf(string) + "(" + vertex2 + ")");
        }
        return this._getCommonAncestor(vertex, vertex2);
    }

    public int getDepth(Vertex vertex) throws IllegalArgumentException {
        String string = this._checkParmHasVertex(vertex);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._getDepthMethod(vertex), string);
        }
        return this._getDepth(vertex);
    }

    public Vertex getFirstChild(Vertex vertex) throws IllegalArgumentException {
        String string = this._checkParmHasVertex(vertex);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._getFirstChildMethod(vertex), string);
        }
        if (this._isLeaf(vertex)) {
            return null;
        }
        return this._getChild(vertex, 0);
    }

    public int getIndexOfChild(Vertex vertex, Vertex vertex2) throws IllegalArgumentException {
        String string = this._checkParmParentMissingChild(vertex, vertex2);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._getIndexOfChildMethod(vertex, vertex2), string);
        }
        if (vertex != this._getParent(vertex2)) {
            Throw.throwIllegalArgumentException(_strClassName, this._getIndexOfChildMethod(vertex, vertex2), X_NOT_CHILD);
        }
        return this._getIndexOfChild(vertex, vertex2);
    }

    public Vertex getLastChild(Vertex vertex) throws IllegalArgumentException {
        String string = this._checkParmHasVertex(vertex);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._getLastChildMethod(vertex), string);
        }
        if (this._isLeaf(vertex)) {
            return null;
        }
        return this._getChild(vertex, this._getChildCount(vertex) - 1);
    }

    public Vertex getParent(Vertex vertex) throws IllegalArgumentException {
        String string;
        if (this.$iVerboseMethod >= 1) {
            System.out.println("[SingleTree.getParent(" + vertex + ")]{");
        }
        if ((string = this._checkParmHasVertex(vertex)) != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._getParentMethod(vertex), string);
        }
        Vertex vertex2 = this._getParent(vertex);
        if (this.$iVerboseMethod >= 1) {
            System.out.println("[SingleTree.getParent(" + vertex + ")]}" + vertex2);
        }
        return vertex2;
    }

    public Edge getParentEdge(Vertex vertex) throws IllegalArgumentException {
        String string = this._checkParmHasVertex(vertex);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._getParentEdgeMethod(vertex), string);
        }
        return this._getParentEdge(vertex);
    }

    public Path getPath(Vertex vertex, Vertex vertex2) throws IllegalArgumentException {
        String string = this._checkParmHasVertex(vertex);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._getPathMethod(vertex, vertex2), String.valueOf(string) + "(" + vertex + ")");
        }
        if ((string = this._checkParmHasVertex(vertex2)) != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._getPathMethod(vertex, vertex2), String.valueOf(string) + "(" + vertex2 + ")");
        }
        return this._getPath(vertex, vertex2);
    }

    public Path getPathToAncestorAtDepth(Vertex vertex, int n) throws IllegalArgumentException {
        String string = this._checkParmHasVertex(vertex);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._getPathToAncestorAtDepthMethod(vertex, n), string);
        }
        if (n < 0) {
            Throw.throwIllegalArgumentException(_strClassName, this._getPathToAncestorAtDepthMethod(vertex, n), " Negative depth (" + n + ").");
        }
        return this._getPathToAncestorAtDepth(vertex, n);
    }

    public Vertex getRoot() {
        return this._getRoot();
    }

    public void insertChild(Vertex vertex, SingleTree singleTree, int n, boolean bl) throws IllegalArgumentException, IndexOutOfBoundsException {
        String string;
        if (this.$iVerboseMethod >= 1) {
            System.out.println("[SingleTree." + this._insertChildMethod(vertex, singleTree, n, bl) + "]{");
        }
        if ((string = this._checkParmParent(vertex)) != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._insertChildMethod(vertex, singleTree, n, bl), string);
        }
        if (singleTree == null) {
            Throw.throwIllegalArgumentException(_strClassName, this._insertChildMethod(vertex, singleTree, n, bl), X_NULL_TREE);
        }
        if (!singleTree.isEmpty()) {
            if (singleTree.hasSharedVerticesWith(this)) {
                Throw.throwIllegalArgumentException(_strClassName, this._insertChildMethod(vertex, singleTree, n, bl), X_SHARED_VERTICES);
            }
            if ((string = this._checkParmIndexForInsert(vertex, n)) != null) {
                Throw.throwIndexOutOfBoundsException(_strClassName, this._insertChildMethod(vertex, singleTree, n, bl), string);
            }
            this._insertChild(vertex, singleTree, n, bl);
        }
        if (this.$iVerboseMethod >= 1) {
            System.out.println("[SingleTree." + this._insertChildMethod(vertex, singleTree, n, bl) + "]}");
        }
    }

    public void insertChild(Vertex vertex, Vertex vertex2, int n) throws IllegalArgumentException, IndexOutOfBoundsException {
        String string = this._checkParmParentChild(vertex, vertex2);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._insertChildMethod(vertex, vertex2, n), string);
        }
        if ((string = this._checkParmIndexForInsert(vertex, n)) != null) {
            Throw.throwIndexOutOfBoundsException(_strClassName, this._insertChildMethod(vertex, vertex2, n), string);
        }
        this._insertChild(vertex, vertex2, n);
    }

    public void insertFirstChild(Vertex vertex, SingleTree singleTree, boolean bl) throws IllegalArgumentException {
        String string;
        if (this.$iVerboseMethod >= 1) {
            this.$printMethod(GraphObject.out, _strClassName, this._insertFirstChildMethod(vertex, singleTree, bl), "{");
        }
        if ((string = this._checkParmHasVertex(vertex)) != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._insertFirstChildMethod(vertex, singleTree, bl), string);
        }
        if (singleTree == null) {
            Throw.throwIllegalArgumentException(_strClassName, this._insertFirstChildMethod(vertex, singleTree, bl), X_NULL_TREE);
        }
        if (!singleTree.isEmpty()) {
            if (singleTree.hasSharedVerticesWith(this)) {
                Throw.throwIllegalArgumentException(_strClassName, this._insertFirstChildMethod(vertex, singleTree, bl), X_SHARED_VERTICES);
            }
            this._insertFirstChild(vertex, singleTree, bl);
        }
        if (this.$iVerboseMethod >= 1) {
            this.$printMethod(GraphObject.out, _strClassName, this._insertFirstChildMethod(vertex, singleTree, bl), "}");
        }
    }

    public void insertFirstChild(Vertex vertex, Vertex vertex2) throws IllegalArgumentException {
        String string = this._checkParmParentChild(vertex, vertex2);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._insertFirstChildMethod(vertex, vertex2), string);
        }
        this._insertFirstChild(vertex, vertex2);
    }

    public void insertLastChild(Vertex vertex, SingleTree singleTree, boolean bl) throws IllegalArgumentException {
        String string = this._checkParmHasVertex(vertex);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._insertLastChildMethod(vertex, singleTree, bl), string);
        }
        if (singleTree == null) {
            Throw.throwIllegalArgumentException(_strClassName, this._insertLastChildMethod(vertex, singleTree, bl), X_NULL_TREE);
        }
        if (!singleTree.isEmpty()) {
            if (singleTree.hasSharedVerticesWith(this)) {
                Throw.throwIllegalArgumentException(_strClassName, this._insertLastChildMethod(vertex, singleTree, bl), X_SHARED_VERTICES);
            }
            this._insertLastChild(vertex, singleTree, bl);
        }
    }

    public void insertLastChild(Vertex vertex, Vertex vertex2) throws IllegalArgumentException {
        String string = this._checkParmParentChild(vertex, vertex2);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._insertLastChildMethod(vertex, vertex2), string);
        }
        this._insertLastChild(vertex, vertex2);
    }

    public boolean isLeaf(Vertex vertex) throws IllegalArgumentException {
        return this._isLeaf(vertex);
    }

    public boolean isRoot(Vertex vertex) throws IllegalArgumentException {
        String string = this._checkParmHasVertex(vertex);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._isRootMethod(vertex), string);
        }
        return this._isRoot(vertex);
    }

    public SingleTree removeChild(Vertex vertex, int n) throws IllegalArgumentException, IndexOutOfBoundsException {
        String string = this._checkParmParent(vertex);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._removeChildMethod(vertex, n), string);
        }
        if (this._isLeaf(vertex)) {
            Throw.throwIllegalArgumentException(_strClassName, this._removeChildMethod(vertex, n), X_LEAF_VERTEX);
        }
        if ((string = this._checkParmIndexForGet(vertex, n)) != null) {
            Throw.throwIndexOutOfBoundsException(_strClassName, this._removeChildMethod(vertex, n), string);
        }
        SingleTree singleTree = this._removeChild(vertex, n);
        return singleTree;
    }

    public SingleTree removeFirstChild(Vertex vertex) throws IllegalArgumentException {
        String string = this._checkParmHasVertex(vertex);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._removeFirstChildMethod(vertex), string);
        }
        if (this._isLeaf(vertex)) {
            Throw.throwIllegalArgumentException(_strClassName, this._removeFirstChildMethod(vertex), X_LEAF_VERTEX);
        }
        return this._removeChild(vertex, 0);
    }

    public SingleTree removeLastChild(Vertex vertex) throws IllegalArgumentException {
        String string = this._checkParmHasVertex(vertex);
        if (string != null) {
            Throw.throwIllegalArgumentException(_strClassName, this._removeLastChildMethod(vertex), string);
        }
        if (this._isLeaf(vertex)) {
            Throw.throwIllegalArgumentException(_strClassName, this._removeLastChildMethod(vertex), X_LEAF_VERTEX);
        }
        return this._removeChild(vertex, this._getChildCount(vertex) - 1);
    }

    public void setRoot(Vertex vertex) throws IllegalArgumentException {
        if (vertex == null) {
            Throw.throwIllegalArgumentException(_strClassName, this._setRootMethod(vertex), Net.X_NULL_VERTEX);
        }
        if (!this.isEmpty() && !this.contains(vertex)) {
            Throw.throwIllegalArgumentException(_strClassName, this._setRootMethod(vertex), X_NOT_IN_TREE);
        }
        this._setRoot(vertex);
    }

    public String toString() {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isEmpty()) {
            stringBuffer.append("[empty]");
        } else {
            this._toString(stringBuffer, n, this._getRoot());
        }
        return stringBuffer.toString();
    }

    protected boolean validEdge(Edge edge) {
        if (this.$iVerboseMethod >= 2) {
            System.out.println("[SingleTree.validEdge(" + edge + ")]");
        }
        boolean bl = false;
        bl = super.validEdge(edge);
        if (bl && edge.isDirected()) {
            if (!this.isEmpty()) {
                if (this.contains(edge.getFromVertex()) && !this.contains(edge.getToVertex())) {
                    bl = true;
                } else if (!this.contains(edge.getFromVertex()) && this._getRoot() == edge.getToVertex()) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        if (this.$iVerboseMethod >= 2) {
            System.out.println("[SingleTree.validEdge(" + edge + ")] " + bl);
        }
        return bl;
    }
}

