/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph;

import com.ibm.graph.Drawable;
import com.ibm.graph.Edge;
import com.ibm.graph.EdgeExistsException;
import com.ibm.graph.EdgeMissingException;
import com.ibm.graph.GraphLayout;
import com.ibm.graph.GraphObject;
import com.ibm.graph.Tree;
import com.ibm.graph.TreeRootMissingException;
import com.ibm.graph.Vertex;
import com.ibm.graph.VertexExistsException;
import com.ibm.graph.VertexMissingException;
import com.ibm.research.util.Dict;
import com.ibm.research.util.KeyMissingException;
import com.ibm.research.util.Set;
import com.ibm.research.util.Util;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Net
extends GraphLayout
implements Cloneable {
    static String X_NULL_VERTEX = "Null vertex.";
    static String X_VERTEX_NOT_IN_NET = "Vertex not in net.";
    static String _strKeyRootDefault = "!!vRoot";
    private static final String _strClassName = "Net";
    private Set setVertices;
    private Set setEdges;
    private int _iEnumerationSize = 0;
    private String _strKeyRoot = null;

    public Net() {
        this.setVertices = new Set();
        this.setEdges = new Set();
    }

    public Net(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.add(new Vertex());
            ++n2;
        }
    }

    private boolean _add(Edge edge) {
        if (this.setEdges.contains(edge)) {
            System.out.println("\tSet contains edge.");
            return false;
        }
        if (!this.validEdge(edge)) {
            return false;
        }
        this.setEdges.add(edge);
        this._addEdge(edge);
        this._add(edge.getFromVertex());
        this._add(edge.getToVertex());
        return true;
    }

    private boolean _add(Vertex vertex) {
        if (this.setVertices.contains(vertex)) {
            return false;
        }
        this.setVertices.addElement(vertex);
        vertex.add(this);
        return true;
    }

    private void _addEdge(Edge edge) {
        edge.add(this);
        try {
            edge.getFromVertex().add(edge);
            edge.getToVertex().add(edge);
        }
        catch (NullPointerException nullPointerException) {
            if (edge.getFromVertex() == null) {
                System.err.println("[Net._addEdge(Edge)] Null \"from\" vertex.");
            }
            if (edge.getToVertex() == null) {
                System.err.println("[Net._addEdge(Edge)] Null \"to\" vertex.");
            }
            throw (NullPointerException)((Throwable)nullPointerException).fillInStackTrace();
        }
    }

    private Enumeration _elementsReversed(final Vector vector) {
        return new Enumeration(){
            int i;
            {
                this.i = vector2.size();
            }

            public boolean hasMoreElements() {
                return this.i > 0;
            }

            public Object nextElement() {
                return vector.elementAt(--this.i);
            }
        };
    }

    private Enumeration _enumerateConnectedComponents() {
        Vector<Net> vector = new Vector<Net>();
        Set set = this.allVertices();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        while (set.size() >= 1) {
            Net net;
            vector2.removeAllElements();
            vector3.removeAllElements();
            this._execBreadthFirstTraversal((Vertex)set.firstElement(), vector2, vector3, null, true);
            try {
                net = (Net)this.getClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
                net = new Net();
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("[Net.enumerateConnectedComponents()] Class or initializer is not accessible for " + this.getClass());
                net = new Net();
            }
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                Vertex vertex = (Vertex)enumeration.nextElement();
                net.add(vertex);
                if (set.removeElement(vertex)) continue;
                System.out.println("[Net.enumerateConnectedComponents()] ?BUG? Could not remove vertex (" + vertex + ") from net (" + this + ").");
            }
            Enumeration enumeration2 = vector3.elements();
            while (enumeration2.hasMoreElements()) {
                Edge edge = (Edge)enumeration2.nextElement();
                net.add(edge);
            }
            vector.addElement(net);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    private Enumeration _enumerateEdges() {
        this._iEnumerationSize = this.setEdges.size();
        return this.setEdges.elements();
    }

    private Enumeration _enumerateEdgesBySystemKey(Object object) {
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.systemdict.containsKey(object)) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    private Enumeration _enumerateEdgesBySystemKeySetToValue(Object object, Object object2) {
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this.enumerateEdgesBySystemKey(object);
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.systemdict.get(object).equals(object2)) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    private Enumeration _enumerateEdgesByUserKey(Object object) {
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.userdict.containsKey(object)) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    private Enumeration _enumerateEdgesByUserKeySetToValue(Object object, Object object2) {
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this.enumerateEdgesByUserKey(object);
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.userdict.get(object).equals(object2)) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    private Enumeration _enumerateVertices() {
        this._iEnumerationSize = this.setVertices.size();
        return this.setVertices.elements();
    }

    private Enumeration _enumerateVerticesBySystemKeySetToValue(Object object, Object object2) {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this.enumerateVerticesBySystemKey(object);
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (!vertex.systemdict.get(object).equals(object2)) continue;
            vector.addElement(vertex);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    private Enumeration _enumerateVerticesByUserKeySetToValue(Object object, Object object2) {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this.enumerateVerticesByUserKey(object);
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (!vertex.userdict.get(object).equals(object2)) continue;
            vector.addElement(vertex);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    private void _execBreadthFirstTraversal(Vertex vertex, Vector vector, Vector vector2, String string, boolean bl) {
        int n = 0;
        Vector<Vertex> vector3 = vector == null ? new Vector<Vertex>() : vector;
        vector3.addElement(vertex);
        if (string != null) {
            vertex.systemdict.def((Object)string, n);
        }
        int n2 = 0;
        while (n2 < vector3.size()) {
            Vertex vertex2 = (Vertex)vector3.elementAt(n2);
            if (string != null) {
                try {
                    n = vertex2.systemdict.getInteger(string);
                }
                catch (KeyMissingException keyMissingException) {}
            }
            Enumeration enumeration = vertex2.enumerateEdges(this);
            while (enumeration.hasMoreElements()) {
                Vertex vertex3;
                Edge edge = (Edge)enumeration.nextElement();
                if (!bl && edge.isDirected() && edge.getFromVertex() != vertex2) continue;
                try {
                    vertex3 = edge.getOtherVertex(vertex2);
                }
                catch (VertexMissingException vertexMissingException) {
                    continue;
                }
                if (vector3.contains(vertex3)) continue;
                vector3.addElement(vertex3);
                if (string != null) {
                    vertex3.systemdict.def((Object)string, n + 1);
                }
                if (vector2 == null) continue;
                vector2.addElement(edge);
            }
            ++n2;
        }
    }

    private void _execDepthFirstTraversal(Vertex vertex, Vector vector, Vector vector2, String string, int n, boolean bl) {
        Vector<Vertex> vector3 = vector == null ? new Vector<Vertex>() : vector;
        if (string != null) {
            vertex.systemdict.def((Object)string, n);
        }
        vector3.addElement(vertex);
        Enumeration enumeration = vertex.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Vertex vertex2;
            Edge edge = (Edge)enumeration.nextElement();
            if (edge.isDirected() && edge.getFromVertex() != vertex) continue;
            try {
                vertex2 = edge.getOtherVertex(vertex);
            }
            catch (VertexMissingException vertexMissingException) {
                continue;
            }
            if (vector3.contains(vertex2)) continue;
            if (bl && vector2 != null) {
                vector2.addElement(edge);
            }
            this._execDepthFirstTraversal(vertex2, vector3, vector2, string, n + 1, bl);
            if (bl || vector2 == null) continue;
            vector2.addElement(edge);
        }
        if (!bl) {
            vector3.removeElement(vertex);
            vector3.addElement(vertex);
        }
    }

    private boolean _existsDirectedEdge(Vertex vertex, Vertex vertex2) {
        boolean bl = false;
        Enumeration enumeration = vertex.enumerateDirectedEdges(this);
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            try {
                if (vertex2 != edge.getOtherVertex(vertex)) continue;
                bl = true;
                break;
            }
            catch (VertexMissingException vertexMissingException) {}
        }
        return bl;
    }

    private boolean _existsDirectedEdgeFromTo(Vertex vertex, Vertex vertex2) {
        boolean bl = false;
        Enumeration enumeration = vertex.enumerateOutgoingEdges(this);
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            try {
                if (vertex2 != edge.getOtherVertex(vertex)) continue;
                bl = true;
                break;
            }
            catch (VertexMissingException vertexMissingException) {}
        }
        return bl;
    }

    private final String _existsDirectedEdgeFromToMethod(Vertex vertex, Vertex vertex2) {
        return "existsDirectedEdgeFromTo(" + vertex + "," + vertex2 + ")";
    }

    private final String _existsDirectedEdgeMethod(Vertex vertex, Vertex vertex2) {
        return "existsDirectedEdge(" + vertex + "," + vertex2 + ")";
    }

    private boolean _existsEdge(Vertex vertex, Vertex vertex2) {
        boolean bl = false;
        Enumeration enumeration = vertex.enumerateEdges(this);
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            try {
                if (vertex2 != edge.getOtherVertex(vertex)) continue;
                bl = true;
                break;
            }
            catch (VertexMissingException vertexMissingException) {}
        }
        return bl;
    }

    private final String _existsEdgeMethod(Vertex vertex, Vertex vertex2) {
        return "existsEdge(" + vertex + "," + vertex2 + ")";
    }

    private boolean _existsUndirectedEdge(Vertex vertex, Vertex vertex2) {
        boolean bl = false;
        Enumeration enumeration = vertex.enumerateUndirectedEdges(this);
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            try {
                if (vertex2 != edge.getOtherVertex(vertex)) continue;
                bl = true;
                break;
            }
            catch (VertexMissingException vertexMissingException) {}
        }
        return bl;
    }

    private final String _existsUndirectedEdgeMethod(Vertex vertex, Vertex vertex2) {
        return "existsUndirectedEdge(" + vertex + "," + vertex2 + ")";
    }

    private Net _findConnectedComponent(Edge edge) {
        Enumeration enumeration = this._enumerateConnectedComponents();
        while (enumeration.hasMoreElements()) {
            Net net = (Net)enumeration.nextElement();
            if (net.contains(edge)) {
                return net;
            }
            net.delete();
        }
        return null;
    }

    private Net _findConnectedComponent(Vertex vertex) {
        Enumeration enumeration = this._enumerateConnectedComponents();
        while (enumeration.hasMoreElements()) {
            Net net = (Net)enumeration.nextElement();
            if (net.contains(vertex)) {
                return net;
            }
            net.delete();
        }
        return null;
    }

    private Vertex _findRoot(Vertex vertex) throws TreeRootMissingException {
        if (vertex == null) {
            return vertex;
        }
        if (this._isRoot(vertex)) {
            return vertex;
        }
        Enumeration enumeration = this.enumerateDepthFirstTraversal(vertex);
        while (enumeration.hasMoreElements()) {
            Vertex vertex2 = (Vertex)enumeration.nextElement();
            if (!this._isRoot(vertex2)) continue;
            return vertex2;
        }
        throw new TreeRootMissingException();
    }

    private StringBuffer _getBaseKey(String string) {
        if (string == null) {
            return new StringBuffer("!!");
        }
        return new StringBuffer(string);
    }

    String _getKeyRoot() {
        if (this._strKeyRoot == null) {
            return _strKeyRootDefault;
        }
        return this._strKeyRoot;
    }

    private String _getName() {
        String string = this.getName();
        if (string == null) {
            string = this.getClass().getName();
        }
        return string;
    }

    private Vector _getRoots() {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (!vertex.isARoot()) continue;
            vector.addElement(vertex);
        }
        return vector;
    }

    private Vector _getVerticesBySystemKey(Object object) {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (!vertex.systemdict.containsKey(object)) continue;
            vector.addElement(vertex);
        }
        this._iEnumerationSize = vector.size();
        return vector;
    }

    private Vector _getVerticesByUserKey(Object object) {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (!vertex.userdict.containsKey(object)) continue;
            vector.addElement(vertex);
        }
        this._iEnumerationSize = vector.size();
        return vector;
    }

    private boolean _isRoot(Vertex vertex) {
        boolean bl = false;
        if (vertex == null) {
            return false;
        }
        if (vertex.systemdict.contains(this)) {
            try {
                Dict dict = (Dict)vertex.systemdict.get(this);
                if (dict.contains(_strKeyRootDefault)) {
                    try {
                        return dict.getBoolean(_strKeyRootDefault);
                    }
                    catch (KeyMissingException keyMissingException) {}
                }
            }
            catch (ClassCastException classCastException) {}
        }
        if (!vertex.systemdict.contains(_strKeyRootDefault)) {
            return false;
        }
        try {
            bl = vertex.systemdict.getBoolean(_strKeyRootDefault);
        }
        catch (KeyMissingException keyMissingException) {
            System.out.println("[Tree.isRoot(" + vertex + ")] Key 'root' not found.");
        }
        return bl;
    }

    private boolean _isTreeBranch(Vertex vertex, String string) {
        boolean bl = true;
        vertex.systemdict.def((Object)string, true);
        Enumeration enumeration = vertex.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Vertex vertex2;
            Edge edge = (Edge)enumeration.nextElement();
            try {
                if (edge.systemdict.getBoolean(string)) {
                    continue;
                }
            }
            catch (KeyMissingException keyMissingException) {}
            edge.systemdict.def((Object)string, true);
            try {
                vertex2 = edge.getOtherVertex(vertex);
            }
            catch (VertexMissingException vertexMissingException) {
                continue;
            }
            if (this._isTreeBranch(vertex2, string)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean _remove(Vector vector) {
        boolean bl = true;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (!this.contains(vertex)) {
                bl = false;
                continue;
            }
            if (this.remove(vertex)) continue;
            bl = false;
        }
        return bl;
    }

    private void _resetRoot(Vertex vertex) {
        if (vertex.systemdict.contains(_strKeyRootDefault)) {
            vertex.systemdict.def((Object)_strKeyRootDefault, false);
        }
    }

    private void _setRoot(Vertex vertex, boolean bl) {
        vertex.systemdict.def((Object)_strKeyRootDefault, bl);
    }

    private void _setUniqueRoot(Vertex vertex) {
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex2 = (Vertex)enumeration.nextElement();
            if (vertex2 == vertex) {
                this._setRoot(vertex2, true);
                continue;
            }
            this._resetRoot(vertex2);
        }
    }

    public synchronized boolean add(Edge edge) {
        if (this.$iVerboseMethod >= 1) {
            System.out.println("[Net.add(" + edge + ")]");
        }
        boolean bl = edge == null ? false : this._add(edge);
        if (this.$iVerboseMethod >= 1) {
            System.out.println("[Net.add(" + edge + ")] " + bl);
        }
        return bl;
    }

    public synchronized boolean add(Vertex vertex) {
        if (vertex == null) {
            return false;
        }
        return this._add(vertex);
    }

    public boolean add(Edge[] edgeArray) {
        if (edgeArray == null) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        while (n < edgeArray.length) {
            bl &= this.add(edgeArray[n]);
            ++n;
        }
        return bl;
    }

    public boolean add(Vertex[] vertexArray) {
        if (vertexArray == null) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        while (n < vertexArray.length) {
            bl &= this.add(vertexArray[n]);
            ++n;
        }
        return bl;
    }

    public void addVertices(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.add(new Vertex());
            ++n2;
        }
    }

    protected synchronized Set allEdges() {
        return (Set)this.setEdges.clone();
    }

    protected synchronized Set allVertices() {
        return (Set)this.setVertices.clone();
    }

    public synchronized void clear() {
        Enumeration enumeration = this.enumerateVerticesReversed();
        while (enumeration.hasMoreElements()) {
            this.remove((Vertex)enumeration.nextElement());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Object object;
        Net net;
        try {
            net = (Net)this.getClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new CloneNotSupportedException("[Net.clone()] Instantiation exception.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CloneNotSupportedException("[Net.clone()] Illegal access exception.");
        }
        net.systemdict = (Dict)this.systemdict.clone();
        net.userdict = (Dict)this.userdict.clone();
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            object = (Vertex)enumeration.nextElement();
            net.add((Vertex)object);
        }
        object = this._enumerateEdges();
        while (object.hasMoreElements()) {
            Edge edge = (Edge)object.nextElement();
            net.add(edge);
        }
        return net;
    }

    public boolean contains(Edge edge) {
        return this.setEdges.contains(edge);
    }

    public boolean contains(Vertex vertex) {
        return this.setVertices.contains(vertex);
    }

    public boolean containsEdgeSystemKey(Object object) {
        boolean bl = false;
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.systemdict.containsKey(object)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean containsEdgeUserKey(Object object) {
        boolean bl = false;
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.userdict.containsKey(object)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean containsSystemKey(Object object) {
        if (this.systemdict.contains(object)) {
            return true;
        }
        if (this.containsVertexSystemKey(object)) {
            return true;
        }
        return this.containsEdgeSystemKey(object);
    }

    public boolean containsUserKey(Object object) {
        if (this.userdict.contains(object)) {
            return true;
        }
        if (this.containsVertexUserKey(object)) {
            return true;
        }
        return this.containsEdgeUserKey(object);
    }

    public boolean containsVertexSystemKey(Object object) {
        boolean bl = false;
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (!vertex.systemdict.containsKey(object)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean containsVertexUserKey(Object object) {
        boolean bl = false;
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (!vertex.userdict.containsKey(object)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void debugPrint() {
        Object object;
        Enumeration enumeration = this.setVertices.elements();
        while (enumeration.hasMoreElements()) {
            object = (Vertex)enumeration.nextElement();
            try {
                System.out.println("Vertex " + this.whereVertex((Vertex)object));
            }
            catch (VertexMissingException vertexMissingException) {}
        }
        object = this.setEdges.elements();
        while (object.hasMoreElements()) {
            Edge edge = (Edge)object.nextElement();
            try {
                System.out.println("Edge " + this.whereVertex(edge.getFromVertex()) + "-" + this.whereVertex(edge.getToVertex()));
            }
            catch (VertexMissingException vertexMissingException) {}
        }
    }

    public void defEdgeSystemKey(Object object, float f) {
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            edge.systemdict.def(object, f);
        }
    }

    public void defEdgeSystemKey(Object object, int n) {
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            edge.systemdict.def(object, n);
        }
    }

    public void defEdgeSystemKey(Object object, Object object2) {
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            edge.systemdict.def(object, object2);
        }
    }

    public void defEdgeSystemKey(Object object, boolean bl) {
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            edge.systemdict.def(object, bl);
        }
    }

    public String defEdgeUniqueSystemKey(String string) {
        StringBuffer stringBuffer = this._getBaseKey(string);
        while (this.containsEdgeSystemKey(stringBuffer)) {
            System.out.println("[Net.defEdgeUniqueSystemKey()] key " + stringBuffer + " already used.");
            stringBuffer.append(Math.round(10.0 * Math.random()));
        }
        String string2 = stringBuffer.toString();
        this.systemdict.def((Object)string2, new Object());
        return string2;
    }

    public void defEdgeUserKey(Object object, float f) {
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            edge.userdict.def(object, f);
        }
    }

    public void defEdgeUserKey(Object object, int n) {
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            edge.userdict.def(object, n);
        }
    }

    public void defEdgeUserKey(Object object, Object object2) {
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            edge.userdict.def(object, object2);
        }
    }

    public void defEdgeUserKey(Object object, boolean bl) {
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            edge.userdict.def(object, bl);
        }
    }

    public void defSystemKey(Object object, float f) {
        this.defVertexSystemKey(object, f);
        this.defEdgeSystemKey(object, f);
    }

    public void defSystemKey(Object object, int n) {
        this.defVertexSystemKey(object, n);
        this.defEdgeSystemKey(object, n);
    }

    public void defSystemKey(Object object, Object object2) {
        this.defVertexSystemKey(object, object2);
        this.defEdgeSystemKey(object, object2);
    }

    public void defSystemKey(Object object, boolean bl) {
        this.defVertexSystemKey(object, bl);
        this.defEdgeSystemKey(object, bl);
    }

    public String defUniqueSystemKey(String string) {
        StringBuffer stringBuffer = string == null ? new StringBuffer("!!") : new StringBuffer(string);
        while (this.containsSystemKey(stringBuffer)) {
            System.out.println("[Net.defUniqueSystemKey()] key " + stringBuffer + " already used.");
            stringBuffer.append(Math.round(10.0 * Math.random()));
        }
        String string2 = stringBuffer.toString();
        this.systemdict.def((Object)string2, new Object());
        return string2;
    }

    public String defUniqueSystemKey(String string, float f) {
        String string2 = this.defUniqueSystemKey(string);
        this.defSystemKey((Object)string2, f);
        return string2;
    }

    public String defUniqueSystemKey(String string, int n) {
        String string2 = this.defUniqueSystemKey(string);
        this.defSystemKey((Object)string2, n);
        return string2;
    }

    public String defUniqueSystemKey(String string, Object object) {
        String string2 = this.defUniqueSystemKey(string);
        this.defSystemKey((Object)string2, object);
        return string2;
    }

    public String defUniqueSystemKey(String string, boolean bl) {
        String string2 = this.defUniqueSystemKey(string);
        this.defSystemKey((Object)string2, bl);
        return string2;
    }

    public String defUniqueUserKey(String string) {
        StringBuffer stringBuffer = this._getBaseKey(string);
        while (this.containsUserKey(stringBuffer)) {
            System.out.println("[Net.defUniqueUserKey()] key " + stringBuffer + " already used.");
            stringBuffer.append(Math.round(10.0 * Math.random()));
        }
        String string2 = stringBuffer.toString();
        this.userdict.def((Object)string2, new Object());
        return string2;
    }

    public String defUniqueUserKey(String string, float f) {
        String string2 = this.defUniqueUserKey(string);
        this.defUserKey((Object)string2, f);
        return string2;
    }

    public String defUniqueUserKey(String string, int n) {
        String string2 = this.defUniqueUserKey(string);
        this.defUserKey((Object)string2, n);
        return string2;
    }

    public String defUniqueUserKey(String string, Object object) {
        String string2 = this.defUniqueUserKey(string);
        this.defUserKey((Object)string2, object);
        return string2;
    }

    public String defUniqueUserKey(String string, boolean bl) {
        String string2 = this.defUniqueUserKey(string);
        this.defUserKey((Object)string2, bl);
        return string2;
    }

    public void defUserKey(Object object, float f) {
        this.defVertexUserKey(object, f);
        this.defEdgeUserKey(object, f);
    }

    public void defUserKey(Object object, int n) {
        this.defVertexUserKey(object, n);
        this.defEdgeUserKey(object, n);
    }

    public void defUserKey(Object object, Object object2) {
        this.defVertexUserKey(object, object2);
        this.defEdgeUserKey(object, object2);
    }

    public void defUserKey(Object object, boolean bl) {
        this.defVertexUserKey(object, bl);
        this.defEdgeUserKey(object, bl);
    }

    public void defVertexSystemKey(Object object, float f) {
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            vertex.systemdict.def(object, f);
        }
    }

    public void defVertexSystemKey(Object object, int n) {
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            vertex.systemdict.def(object, n);
        }
    }

    public void defVertexSystemKey(Object object, Object object2) {
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            vertex.systemdict.def(object, object2);
        }
    }

    public void defVertexSystemKey(Object object, boolean bl) {
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            vertex.systemdict.def(object, bl);
        }
    }

    public String defVertexUniqueSystemKey(String string) {
        StringBuffer stringBuffer = this._getBaseKey(string);
        while (this.containsVertexSystemKey(stringBuffer)) {
            System.out.println("[Net.defVertexUniqueSystemKey()] key " + stringBuffer + " already used.");
            stringBuffer.append(Math.round(10.0 * Math.random()));
        }
        String string2 = stringBuffer.toString();
        this.systemdict.def((Object)string2, new Object());
        return string2;
    }

    public void defVertexUserKey(Object object, float f) {
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            vertex.userdict.def(object, f);
        }
    }

    public void defVertexUserKey(Object object, int n) {
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            vertex.userdict.def(object, n);
        }
    }

    public void defVertexUserKey(Object object, Object object2) {
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            vertex.userdict.def(object, object2);
        }
    }

    public void defVertexUserKey(Object object, boolean bl) {
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            vertex.userdict.def(object, bl);
        }
    }

    public void delete() {
        try {
            while (true) {
                this.remove(this.lastEdge());
            }
        }
        catch (EdgeMissingException edgeMissingException) {
            try {
                while (true) {
                    this.remove(this.lastVertex());
                }
            }
            catch (VertexMissingException vertexMissingException) {
                this.setEdges = null;
                this.setVertices = null;
                return;
            }
        }
    }

    public Edge edgeAt(int n) throws ArrayIndexOutOfBoundsException {
        return (Edge)this.setEdges.elementAt(n);
    }

    public synchronized Enumeration enumerateBreadthFirstTraversal(Vertex vertex) {
        return this.enumerateBreadthFirstTraversal(vertex, null);
    }

    public synchronized Enumeration enumerateBreadthFirstTraversal(Vertex vertex, String string) {
        return this.enumerateBreadthFirstTraversal(vertex, string, false);
    }

    public Enumeration enumerateBreadthFirstTraversal(Vertex vertex, String string, boolean bl) {
        Vector vector = new Vector();
        if (vertex != null) {
            this._execBreadthFirstTraversal(vertex, vector, null, string, bl);
        }
        return vector.elements();
    }

    public Enumeration enumerateConnectedComponents() {
        return this._enumerateConnectedComponents();
    }

    public synchronized Enumeration enumerateDepthFirstTraversal(Vertex vertex) {
        return this.enumerateDepthFirstTraversal(true, vertex);
    }

    public synchronized Enumeration enumerateDepthFirstTraversal(Vertex vertex, String string) {
        return this.enumerateDepthFirstTraversal(true, vertex, string);
    }

    public synchronized Enumeration enumerateDepthFirstTraversal(boolean bl, Vertex vertex) {
        Vector vector = new Vector();
        if (vertex != null) {
            this._execDepthFirstTraversal(vertex, vector, null, null, 0, bl);
        }
        return vector.elements();
    }

    public synchronized Enumeration enumerateDepthFirstTraversal(boolean bl, Vertex vertex, String string) {
        Vector vector = new Vector();
        if (vertex != null) {
            this._execDepthFirstTraversal(vertex, vector, null, string, 0, bl);
        }
        return vector.elements();
    }

    public synchronized Enumeration enumerateDepthFirstTraversalEdges(Vertex vertex) {
        return this.enumerateDepthFirstTraversalEdges(true, vertex);
    }

    public synchronized Enumeration enumerateDepthFirstTraversalEdges(boolean bl, Vertex vertex) {
        Vector vector = new Vector();
        if (vertex != null) {
            this._execDepthFirstTraversal(vertex, null, vector, null, 0, bl);
        }
        return vector.elements();
    }

    public Enumeration enumerateEdges() {
        return this._enumerateEdges();
    }

    public Enumeration enumerateEdges(Vertex vertex) throws VertexMissingException {
        if (!this.setVertices.contains(vertex)) {
            throw new VertexMissingException("[Net.enumerateEdges()] Missing vertex.");
        }
        Set set = vertex.allEdges().and(this.setEdges);
        this._iEnumerationSize = set.size();
        return set.elements();
    }

    /*
     * Unable to fully structure code
     */
    public Enumeration enumerateEdges(Vertex var1_1, Vertex var2_2) {
        var3_3 = new Vector<Edge>();
        try {
            try {
                var5_4 = var1_1.enumerateEdges(this);
                if (true) ** GOTO lbl14
            }
            catch (NullPointerException var6_5) {
                if (var1_1 == null) {
                    this._iEnumerationSize = 0;
                    return GraphObject.EMPTY_ENUMERATION;
                }
                throw (NullPointerException)var6_5.fillInStackTrace();
            }
            do {
                if ((var4_6 = (Edge)var5_4.nextElement()).getOtherVertex(var1_1) != var2_2) continue;
                var3_3.addElement(var4_6);
lbl14:
                // 3 sources

            } while (var5_4.hasMoreElements());
        }
        catch (VertexMissingException v0) {}
        this._iEnumerationSize = var3_3.size();
        return var3_3.elements();
    }

    public Enumeration enumerateEdgesBySystemKey(Object object) {
        if (object == null) {
            return GraphObject.EMPTY_ENUMERATION;
        }
        return this._enumerateEdgesBySystemKey(object);
    }

    public Enumeration enumerateEdgesBySystemKeySetToValue(Object object, char c) {
        return this.enumerateEdgesBySystemKeySetToValue(object, new Character(c));
    }

    public Enumeration enumerateEdgesBySystemKeySetToValue(Object object, double d) {
        return this.enumerateEdgesBySystemKeySetToValue(object, new Double(d));
    }

    public Enumeration enumerateEdgesBySystemKeySetToValue(Object object, int n) {
        return this.enumerateEdgesBySystemKeySetToValue(object, new Integer(n));
    }

    public Enumeration enumerateEdgesBySystemKeySetToValue(Object object, Object object2) {
        if (object == null) {
            return GraphObject.EMPTY_ENUMERATION;
        }
        return this._enumerateEdgesBySystemKeySetToValue(object, object2);
    }

    public Enumeration enumerateEdgesBySystemKeySetToValue(Object object, boolean bl) {
        return this.enumerateEdgesBySystemKeySetToValue(object, new Boolean(bl));
    }

    public Enumeration enumerateEdgesByUserKey(Object object) {
        if (object == null) {
            return GraphObject.EMPTY_ENUMERATION;
        }
        return this._enumerateEdgesByUserKey(object);
    }

    public Enumeration enumerateEdgesByUserKeySetToValue(Object object, char c) {
        return this.enumerateEdgesByUserKeySetToValue(object, new Character(c));
    }

    public Enumeration enumerateEdgesByUserKeySetToValue(Object object, double d) {
        return this.enumerateEdgesByUserKeySetToValue(object, new Double(d));
    }

    public Enumeration enumerateEdgesByUserKeySetToValue(Object object, int n) {
        return this.enumerateEdgesByUserKeySetToValue(object, new Integer(n));
    }

    public Enumeration enumerateEdgesByUserKeySetToValue(Object object, Object object2) {
        if (object == null) {
            return GraphObject.EMPTY_ENUMERATION;
        }
        return this._enumerateEdgesByUserKeySetToValue(object, object2);
    }

    public Enumeration enumerateEdgesByUserKeySetToValue(Object object, boolean bl) {
        return this.enumerateEdgesByUserKeySetToValue(object, new Boolean(bl));
    }

    public Enumeration enumerateEdgesReversed() {
        this._iEnumerationSize = this.setEdges.size();
        return this._elementsReversed(this.setEdges);
    }

    public Enumeration enumerateLinks() {
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.isLink()) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateLoops() {
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.isLoop()) continue;
            vector.addElement(edge);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateRoots() {
        Vector vector = this._getRoots();
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateVertices() {
        return this._enumerateVertices();
    }

    public Enumeration enumerateVerticesByDegree(int n) {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (vertex.degree() != n) continue;
            vector.addElement(vertex);
        }
        this._iEnumerationSize = vector.size();
        return vector.elements();
    }

    public Enumeration enumerateVerticesBySystemKey(Object object) {
        if (object == null) {
            return GraphObject.EMPTY_ENUMERATION;
        }
        return this._getVerticesBySystemKey(object).elements();
    }

    public Enumeration enumerateVerticesBySystemKeySetToValue(Object object, char c) {
        return this.enumerateVerticesBySystemKeySetToValue(object, new Character(c));
    }

    public Enumeration enumerateVerticesBySystemKeySetToValue(Object object, double d) {
        return this.enumerateVerticesBySystemKeySetToValue(object, new Double(d));
    }

    public Enumeration enumerateVerticesBySystemKeySetToValue(Object object, int n) {
        return this.enumerateVerticesBySystemKeySetToValue(object, new Integer(n));
    }

    public Enumeration enumerateVerticesBySystemKeySetToValue(Object object, Object object2) {
        if (object == null) {
            return GraphObject.EMPTY_ENUMERATION;
        }
        return this._enumerateVerticesBySystemKeySetToValue(object, object2);
    }

    public Enumeration enumerateVerticesBySystemKeySetToValue(Object object, boolean bl) {
        return this.enumerateVerticesBySystemKeySetToValue(object, new Boolean(bl));
    }

    public Enumeration enumerateVerticesByUserKey(Object object) {
        if (object == null) {
            return GraphObject.EMPTY_ENUMERATION;
        }
        return this._getVerticesByUserKey(object).elements();
    }

    public Enumeration enumerateVerticesByUserKeySetToValue(Object object, char c) {
        return this.enumerateVerticesByUserKeySetToValue(object, new Character(c));
    }

    public Enumeration enumerateVerticesByUserKeySetToValue(Object object, double d) {
        return this.enumerateVerticesByUserKeySetToValue(object, new Double(d));
    }

    public Enumeration enumerateVerticesByUserKeySetToValue(Object object, int n) {
        return this.enumerateVerticesByUserKeySetToValue(object, new Integer(n));
    }

    public Enumeration enumerateVerticesByUserKeySetToValue(Object object, Object object2) {
        if (object == null) {
            return GraphObject.EMPTY_ENUMERATION;
        }
        return this._enumerateVerticesByUserKeySetToValue(object, object2);
    }

    public Enumeration enumerateVerticesByUserKeySetToValue(Object object, boolean bl) {
        return this.enumerateVerticesByUserKeySetToValue(object, new Boolean(bl));
    }

    public Enumeration enumerateVerticesReversed() {
        this._iEnumerationSize = this.setVertices.size();
        return this._elementsReversed(this.setVertices);
    }

    public boolean existsDirectedEdge(Vertex vertex, Vertex vertex2) {
        if (vertex == null || vertex2 == null) {
            return false;
        }
        if (!this.contains(vertex) || !this.contains(vertex2)) {
            return false;
        }
        return this._existsDirectedEdge(vertex, vertex2);
    }

    public boolean existsDirectedEdgeFromTo(Vertex vertex, Vertex vertex2) {
        if (vertex == null || vertex2 == null) {
            return false;
        }
        if (!this.contains(vertex) || !this.contains(vertex2)) {
            return false;
        }
        return this._existsDirectedEdgeFromTo(vertex, vertex2);
    }

    public boolean existsEdge(Vertex vertex, Vertex vertex2) {
        if (vertex == null || vertex2 == null) {
            return false;
        }
        if (!this.contains(vertex) || !this.contains(vertex2)) {
            return false;
        }
        return this._existsEdge(vertex, vertex2);
    }

    public boolean existsPath(Vertex vertex, Vertex vertex2) {
        boolean bl;
        block1: {
            block2: {
                block0: {
                    bl = true;
                    if (vertex != null && vertex2 != null) break block0;
                    bl = false;
                    break block1;
                }
                if (this.contains(vertex) && this.contains(vertex2)) break block2;
                bl = false;
                break block1;
            }
            if (!vertex.reachable().and(vertex2.reachable()).isEmpty()) break block1;
            bl = false;
        }
        return bl;
    }

    public boolean existsUndirectedEdge(Vertex vertex, Vertex vertex2) {
        if (vertex == null || vertex2 == null) {
            return false;
        }
        if (!this.contains(vertex) || !this.contains(vertex2)) {
            return false;
        }
        return this._existsUndirectedEdge(vertex, vertex2);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.delete();
    }

    public Net findConnectedComponent(Edge edge) {
        if (edge == null) {
            return null;
        }
        return this._findConnectedComponent(edge);
    }

    public Net findConnectedComponent(Vertex vertex) {
        if (vertex == null) {
            return null;
        }
        return this._findConnectedComponent(vertex);
    }

    public Edge firstEdge() throws EdgeMissingException {
        try {
            return (Edge)this.setEdges.firstElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new EdgeMissingException("[Net.firstEdge()]");
        }
    }

    public Vertex firstVertex() throws VertexMissingException {
        try {
            return (Vertex)this.setVertices.firstElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new VertexMissingException("[Net.firstVertex()]");
        }
    }

    public Vector getChildren(Vector vector) {
        Vector<Vertex> vector2 = new Vector<Vertex>();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Vertex vertex = (Vertex)enumeration.nextElement();
                Enumeration enumeration2 = vertex.enumerateOutgoingNeighbors(this);
                while (enumeration2.hasMoreElements()) {
                    Vertex vertex2 = (Vertex)enumeration2.nextElement();
                    if (vector2.contains(vertex2)) continue;
                    vector2.addElement(vertex2);
                }
            }
        }
        return vector2;
    }

    public int getEnumerationSize() {
        return this._iEnumerationSize;
    }

    public String getKeyRoot() {
        return this._getKeyRoot();
    }

    public static String getKeyRootDefault() {
        return _strKeyRootDefault;
    }

    public Vector getOuterChildren(Vector vector) {
        Vector<Vertex> vector2 = new Vector<Vertex>();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Vertex vertex = (Vertex)enumeration.nextElement();
                Enumeration enumeration2 = vertex.enumerateOutgoingNeighbors(this);
                while (enumeration2.hasMoreElements()) {
                    Vertex vertex2 = (Vertex)enumeration2.nextElement();
                    if (vector2.contains(vertex2) || vector.contains(vertex2)) continue;
                    vector2.addElement(vertex2);
                }
            }
        }
        return vector2;
    }

    public Vector getOuterParents(Vector vector) {
        Vector<Vertex> vector2 = new Vector<Vertex>();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Vertex vertex = (Vertex)enumeration.nextElement();
                Enumeration enumeration2 = vertex.enumerateIncomingNeighbors(this);
                while (enumeration2.hasMoreElements()) {
                    Vertex vertex2 = (Vertex)enumeration2.nextElement();
                    if (vector2.contains(vertex2) || vector.contains(vertex2)) continue;
                    vector2.addElement(vertex2);
                }
            }
        }
        return vector2;
    }

    public Vector getParents(Vector vector) {
        Vector<Vertex> vector2 = new Vector<Vertex>();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Vertex vertex = (Vertex)enumeration.nextElement();
                Enumeration enumeration2 = vertex.enumerateIncomingNeighbors(this);
                while (enumeration2.hasMoreElements()) {
                    Vertex vertex2 = (Vertex)enumeration2.nextElement();
                    if (vector2.contains(vertex2)) continue;
                    vector2.addElement(vertex2);
                }
            }
        }
        return vector2;
    }

    public Vector getRoots() {
        return this._getRoots();
    }

    public Vector getVerticesByKey(boolean bl, Object object) {
        if (object == null) {
            return new Vector();
        }
        return bl ? this.getVerticesBySystemKey(object) : this.getVerticesByUserKey(object);
    }

    public Vector getVerticesBySystemKey(Object object) {
        if (object == null) {
            return new Vector();
        }
        return this._getVerticesBySystemKey(object);
    }

    public Vector getVerticesByUserKey(Object object) {
        if (object == null) {
            return new Vector();
        }
        return this._getVerticesByUserKey(object);
    }

    public boolean hasSharedEdges() {
        Enumeration enumeration = this.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (edge.getNetCount() <= 1) continue;
            return true;
        }
        return false;
    }

    public boolean hasSharedEdgesWith(Net net) {
        Enumeration enumeration = this.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!net.contains(edge)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSharedEdgesWith(Net[] netArray) {
        Enumeration enumeration = this.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            int n = 0;
            while (n < netArray.length) {
                if (netArray[n].contains(edge)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean hasSharedVertices() {
        Enumeration enumeration = this.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (vertex.getNetCount() <= 1) continue;
            return true;
        }
        return false;
    }

    public boolean hasSharedVerticesWith(Net net) {
        Enumeration enumeration = this.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (!net.contains(vertex)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSharedVerticesWith(Net[] netArray) {
        Enumeration enumeration = this.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            int n = 0;
            while (n < netArray.length) {
                if (netArray[n].contains(vertex)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public Edge indexEdge(int n) throws EdgeMissingException {
        try {
            return (Edge)this.setEdges.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("[[ArrayIndexOutOfBoundsException for indexEdge(" + n + ")]]");
            throw new EdgeMissingException("[[indexEdge()]]");
        }
    }

    public Vertex indexVertex(int n) throws VertexMissingException {
        try {
            return (Vertex)this.setVertices.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("[[ArrayIndexOutOfBoundsException for indexVertex(" + n + ")]]");
            throw new VertexMissingException("[[indexVertex()]]");
        }
    }

    public void insertEdgeAt(Edge edge, int n) throws ArrayIndexOutOfBoundsException, EdgeExistsException {
        if (this.setEdges.contains(edge)) {
            throw new EdgeExistsException("[insertEdgeAt()]");
        }
        this.setEdges.insertElementAt(edge, n);
        this._addEdge(edge);
    }

    public void insertVertexAt(Vertex vertex, int n) throws ArrayIndexOutOfBoundsException, VertexExistsException {
        if (this.setVertices.contains(vertex)) {
            throw new VertexExistsException("[insertVertexAt()]");
        }
        this.setVertices.insertElementAt(vertex, n);
        vertex.add(this);
    }

    public boolean isConnected() {
        int n = 0;
        try {
            Enumeration enumeration = this.enumerateBreadthFirstTraversal(this.firstVertex(), null, true);
            while (enumeration.hasMoreElements()) {
                ++n;
                enumeration.nextElement();
            }
        }
        catch (VertexMissingException vertexMissingException) {
            return true;
        }
        return n == this.sizeVertices();
    }

    public boolean isDirected() {
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            if (!((Edge)enumeration.nextElement()).isUndirected()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.setVertices.isEmpty();
    }

    public boolean isGraph() {
        return false;
    }

    public boolean isKRegular(int n) {
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            if (((Vertex)enumeration.nextElement()).degree() == n) continue;
            return false;
        }
        return true;
    }

    public boolean isLink() {
        boolean bl;
        block3: {
            bl = false;
            if (this.setVertices.size() != 2 || this.setEdges.size() != 1) break block3;
            try {
                Vertex vertex = this.firstVertex();
                Vertex vertex2 = this.lastVertex();
                Edge edge = this.firstEdge();
                Vertex vertex3 = edge.getFromVertex();
                Vertex vertex4 = edge.getToVertex();
                bl = vertex == vertex3 && vertex2 == vertex4 || vertex2 == vertex3 && vertex == vertex4;
            }
            catch (VertexMissingException vertexMissingException) {
            }
            catch (EdgeMissingException edgeMissingException) {}
        }
        return bl;
    }

    public boolean isLoop() {
        boolean bl;
        block3: {
            bl = false;
            if (this.setVertices.size() != 1 || this.setEdges.size() != 1) break block3;
            try {
                Vertex vertex = this.firstVertex();
                Edge edge = this.firstEdge();
                Vertex vertex2 = edge.getFromVertex();
                Vertex vertex3 = edge.getToVertex();
                bl = vertex == vertex2 && vertex == vertex3;
            }
            catch (VertexMissingException vertexMissingException) {
            }
            catch (EdgeMissingException edgeMissingException) {}
        }
        return bl;
    }

    public boolean isPath() {
        return false;
    }

    public boolean isRegular() {
        int n;
        block0: {
            n = 0;
            Enumeration enumeration = this._enumerateVertices();
            if (!enumeration.hasMoreElements()) break block0;
            n = ((Vertex)enumeration.nextElement()).degree();
        }
        return this.isKRegular(n);
    }

    public boolean isRelation() {
        return false;
    }

    public boolean isTree() {
        boolean bl = true;
        if (this instanceof Tree) {
            return true;
        }
        String string = this.defUniqueSystemKey((String)null, false);
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            try {
                if (vertex.systemdict.getBoolean(string)) {
                }
            }
            catch (KeyMissingException keyMissingException) {}
            continue;
            if (this._isTreeBranch(vertex, string)) continue;
            bl = false;
            break;
        }
        this.undefSystemKey(string);
        return bl;
    }

    public boolean isUndirected() {
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            if (!((Edge)enumeration.nextElement()).isDirected()) continue;
            return false;
        }
        return true;
    }

    public Edge lastEdge() throws EdgeMissingException {
        try {
            return (Edge)this.setEdges.lastElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new EdgeMissingException("[Net.lastEdge()]");
        }
    }

    public Vertex lastVertex() throws VertexMissingException {
        try {
            return (Vertex)this.setVertices.lastElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new VertexMissingException("[Net.lastVertex()]");
        }
    }

    public void print(PrintStream printStream, int n) {
        int n2 = n;
        Util.printlnIndented(printStream, n2, "Net:");
        Util.printlnIndented(printStream, n2 += 2, "systemdict:");
        this.systemdict.print(printStream, n2 += 2);
        Util.printlnIndented(printStream, n2 -= 2, "userdict");
        this.userdict.print(printStream, n2 += 2);
        Util.printlnIndented(printStream, n2 -= 2, "Vertices");
        n2 += 2;
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            vertex.print(printStream, n2);
        }
        Util.printlnIndented(printStream, n2 -= 2, "Edges");
        n2 += 2;
        Enumeration enumeration2 = this._enumerateEdges();
        while (enumeration2.hasMoreElements()) {
            Edge edge = (Edge)enumeration2.nextElement();
            edge.print(printStream, n2);
        }
    }

    public synchronized boolean remove(Edge edge) {
        if (edge == null) {
            return false;
        }
        if (this.setEdges.contains(edge)) {
            if (edge.getNetCount() == 1) {
                edge.getFromVertex().remove(edge);
                edge.getToVertex().remove(edge);
            }
            edge.remove(this);
            this.removeEdge(edge);
            return true;
        }
        return false;
    }

    public synchronized boolean remove(Vertex vertex) {
        if (vertex == null) {
            return false;
        }
        if (this.setVertices.contains(vertex)) {
            Enumeration enumeration = vertex.enumerateEdges(this);
            while (enumeration.hasMoreElements()) {
                Edge edge = (Edge)enumeration.nextElement();
                this.remove(edge);
            }
            vertex.remove(this);
            this.setVertices.removeElement(vertex);
            return true;
        }
        return false;
    }

    public boolean remove(Vector vector) {
        boolean bl = false;
        if (vector != null) {
            bl = this._remove(vector);
        }
        return bl;
    }

    synchronized boolean removeEdge(Edge edge) {
        return this.setEdges.removeElement(edge);
    }

    public void removeEdgeAt(int n) throws ArrayIndexOutOfBoundsException {
        Edge edge = this.edgeAt(n);
        this.remove(edge);
    }

    public void removeVertexAt(int n) throws ArrayIndexOutOfBoundsException {
        Vertex vertex = this.vertexAt(n);
        this.remove(vertex);
    }

    public void setDrawableEdges(Drawable drawable) {
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            edge.setDrawable(drawable);
        }
    }

    public void setDrawableVertices(Drawable drawable) {
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            vertex.setDrawable(drawable);
        }
    }

    public void setEdgeAt(Edge edge, int n) throws ArrayIndexOutOfBoundsException, EdgeExistsException {
        if (edge == null) {
            return;
        }
        if (this.contains(edge)) {
            throw new EdgeExistsException("[Net.setEdgeAt()]");
        }
        Edge edge2 = this.edgeAt(n);
        this.remove(edge2);
        this.insertEdgeAt(edge, n);
    }

    public void setKeyRoot(String string) {
        this._strKeyRoot = string;
    }

    public static void setKeyRootDefault(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        _strKeyRootDefault = string;
    }

    public void setRoot(Vertex vertex, boolean bl) {
        if (vertex == null) {
            return;
        }
        if (!this.contains(vertex)) {
            System.out.println("[Net.setRoot(" + vertex + "," + bl + ")] Cannot set the root for a vertex that does not belong to this graph.  Use add(Vertex) to add the vertex to the graph before trying to set the vertex as root.");
            return;
        }
        this._setRoot(vertex, bl);
    }

    public void setUniqueRoot(Vertex vertex) {
        if (vertex == null) {
            return;
        }
        if (!this.setVertices.contains(vertex)) {
            return;
        }
        this._setUniqueRoot(vertex);
    }

    public void setUniqueRootInComponent(Vertex vertex) {
        if (vertex == null) {
            return;
        }
        Net net = this._findConnectedComponent(vertex);
        if (net == null) {
            return;
        }
        net.setUniqueRoot(vertex);
        net.delete();
    }

    public void setVertexAt(Vertex vertex, int n) throws ArrayIndexOutOfBoundsException, VertexExistsException {
        if (vertex == null) {
            return;
        }
        if (this.contains(vertex)) {
            throw new VertexExistsException("[Net.setVertexAt()");
        }
        Vertex vertex2 = this.vertexAt(n);
        this.remove(vertex2);
        this.insertVertexAt(vertex, n);
    }

    public int sizeEdges() {
        return this.setEdges.size();
    }

    public int sizeVertices() {
        return this.setVertices.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Vertices: \n{\n");
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            stringBuffer.append("  " + vertex.toString() + " \n");
        }
        stringBuffer.append("}\n Edges: \n{\n");
        Enumeration enumeration2 = this._enumerateEdges();
        while (enumeration2.hasMoreElements()) {
            Edge edge = (Edge)enumeration2.nextElement();
            stringBuffer.append("  " + edge.toString() + " \n");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void undefEdgeSystemKey(Object object) {
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            edge.systemdict.undef(object);
        }
    }

    public void undefEdgeUserKey(Object object) {
        Enumeration enumeration = this._enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            edge.userdict.undef(object);
        }
    }

    public void undefSystemKey(Object object) {
        this.undefVertexSystemKey(object);
        this.undefEdgeSystemKey(object);
        this.systemdict.undef(object);
    }

    public void undefUserKey(Object object) {
        this.undefVertexUserKey(object);
        this.undefEdgeUserKey(object);
        this.userdict.undef(object);
    }

    public void undefVertexSystemKey(Object object) {
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            vertex.systemdict.undef(object);
        }
    }

    public void undefVertexUserKey(Object object) {
        Enumeration enumeration = this._enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            vertex.userdict.undef(object);
        }
    }

    protected boolean validEdge(Edge edge) {
        boolean bl = !this.setEdges.contains(edge);
        return bl;
    }

    public Vertex vertexAt(int n) throws ArrayIndexOutOfBoundsException {
        return (Vertex)this.setVertices.elementAt(n);
    }

    public int whereEdge(Edge edge) throws EdgeMissingException {
        int n = this.setEdges.indexOf(edge);
        if (n == -1) {
            throw new EdgeMissingException("[whereEdge()]");
        }
        return n;
    }

    public int whereVertex(Vertex vertex) throws VertexMissingException {
        int n = this.setVertices.indexOf(vertex);
        if (n == -1) {
            throw new VertexMissingException("[whereVertex()]");
        }
        return n;
    }
}

