/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph;

import com.ibm.research.util.Dict;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public abstract class GraphObject
implements Cloneable,
Serializable {
    public static final int WARNING_DEFAULT = -1;
    public static final int WARNING_OFF = 0;
    public static final int WARNING_ON = 1;
    public static final Enumeration EMPTY_ENUMERATION = new Vector(0).elements();
    public Dict userdict = new Dict();
    public Dict systemdict = new Dict();
    public static String strKeyName = "name";
    static final String LANGUAGELEVEL = "JDK1.1";
    static final String VERSION = "1.1.3";
    static final PrintStream out = System.out;
    static final PrintStream err = System.err;
    static int $iLockWaitTimeout = 2000;
    int iFrameworkLevel;
    final transient int $VERBOSE_QUIET_METHOD = 0;
    final transient int $VERBOSE_PUBLIC_METHOD = 1;
    final transient int $VERBOSE_PROTECTED_METHOD = 2;
    final transient int $VERBOSE_PACKAGE_METHOD = 3;
    final transient int $VERBOSE_PRIVATE_METHOD = 4;
    transient int $iVerboseMethod = 0;
    private transient boolean zLocked = false;
    private static final String _$strClassName = "GraphObject";
    private static final String author = "Christian Lenz Cesar";
    private static int _iDefaultWarningLevel = 1;
    private transient int _iWarningLevel = -1;

    void $printMethod(PrintStream printStream, String string, String string2, String string3) {
        printStream.println("[" + string + "." + string2 + "]" + string3);
    }

    private void _cloneFields(GraphObject graphObject) {
        graphObject.setDefaultWarningLevel(this.getDefaultWarningLevel());
        graphObject.setWarningLevel(this.getWarningLevel());
        graphObject.setName(this.getName());
    }

    boolean acquireLock() {
        if (this.zLocked) {
            return false;
        }
        GraphObject graphObject = this;
        synchronized (graphObject) {
            this.zLocked = true;
        }
        return true;
    }

    boolean acquireLock(boolean bl) {
        if (bl) {
            return true;
        }
        return this.acquireLock();
    }

    public Object clone() throws CloneNotSupportedException {
        GraphObject graphObject;
        try {
            graphObject = (GraphObject)this.getClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new CloneNotSupportedException("[GraphObject.clone()] Instantiation exception (" + instantiationException + ").");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CloneNotSupportedException("[GraphObject.clone()] Illegal access exception (" + illegalAccessException + ").");
        }
        graphObject.systemdict = (Dict)this.systemdict.clone();
        graphObject.userdict = (Dict)this.userdict.clone();
        this._cloneFields(graphObject);
        return graphObject;
    }

    public int getDefaultWarningLevel() {
        return _iDefaultWarningLevel;
    }

    public int getFrameworkLevel() {
        return this.iFrameworkLevel;
    }

    public String getName() {
        Object v = this.systemdict.get(strKeyName);
        if (v != null && v.getClass().getName() instanceof String) {
            return (String)v;
        }
        return this.getClass().getName();
    }

    public int getWarningLevel() {
        if (this._iWarningLevel == -1) {
            return _iDefaultWarningLevel;
        }
        return this._iWarningLevel;
    }

    public static String languagelevel() {
        return LANGUAGELEVEL;
    }

    void releaseLock() {
        this.zLocked = false;
        GraphObject graphObject = this;
        synchronized (graphObject) {
            this.notify();
        }
    }

    public void setDefaultWarningLevel(int n) {
        if (n == -1) {
            return;
        }
        _iDefaultWarningLevel = n;
    }

    public void setFrameworkLevel(int n) {
        this.iFrameworkLevel = n;
    }

    public void setName(String string) {
        this.systemdict.def((Object)strKeyName, string);
    }

    public void setWarningLevel(int n) {
        this._iWarningLevel = n;
    }

    public static String version() {
        return VERSION;
    }
}

