/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph;

import com.ibm.graph.Edge;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class GraphGroup {
    private Vector graphs = new Vector();

    public void add(Edge edge) {
        Enumeration enumeration = this.graphs.elements();
        while (enumeration.hasMoreElements()) {
            Net net = (Net)enumeration.nextElement();
            net.add(edge);
        }
    }

    public void add(Net net) {
        if (net == null) {
            return;
        }
        if (this.graphs.contains(net)) {
            return;
        }
        this.graphs.addElement(net);
    }

    public void add(Vertex vertex) {
        Enumeration enumeration = this.graphs.elements();
        while (enumeration.hasMoreElements()) {
            Net net = (Net)enumeration.nextElement();
            net.add(vertex);
        }
    }

    public Enumeration elements() {
        return this.graphs.elements();
    }

    public Enumeration elementsReversed() {
        return new Enumeration(){
            int i;
            {
                this.i = GraphGroup.this.graphs.size();
            }

            public boolean hasMoreElements() {
                return this.i > 0;
            }

            public Object nextElement() {
                return GraphGroup.this.graphs.elementAt(--this.i);
            }
        };
    }

    public Rectangle getBounds() {
        Rectangle rectangle = null;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Net net = (Net)enumeration.nextElement();
            try {
                if (rectangle == null) {
                    rectangle = new Rectangle(net.getBounds());
                    continue;
                }
                rectangle.add(net.getBounds());
            }
            catch (NotDrawableException notDrawableException) {}
        }
        return rectangle;
    }

    public void remove(Edge edge) {
        Enumeration enumeration = this.graphs.elements();
        while (enumeration.hasMoreElements()) {
            Net net = (Net)enumeration.nextElement();
            net.remove(edge);
        }
    }

    public void remove(Net net) {
        if (net == null) {
            return;
        }
        if (!this.graphs.contains(net)) {
            return;
        }
        this.graphs.removeElement(net);
    }

    public void remove(Vertex vertex) {
        Enumeration enumeration = this.graphs.elements();
        while (enumeration.hasMoreElements()) {
            Net net = (Net)enumeration.nextElement();
            net.remove(vertex);
        }
    }
}

