/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph;

import com.ibm.graph.Drawable;
import com.ibm.graph.Drawable2;
import com.ibm.graph.Drawable2Edge;
import com.ibm.graph.Drawable3;
import com.ibm.graph.DrawableEdge;
import com.ibm.graph.Edge;
import com.ibm.graph.GraphObject;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw2EdgeLine;
import com.ibm.graph.draw.Draw3VertexRectangle;
import com.ibm.graph.draw.DrawNetEdgesThenVertices;
import com.ibm.research.util.Dict;
import com.ibm.research.util.KeyMissingException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;

public abstract class GraphDraw
extends GraphObject {
    public static String strKeyX = "x";
    public static String strKeyY = "y";
    public static String strKeyFromX = "fromX";
    public static String strKeyFromY = "fromY";
    public static String strKeyToX = "toX";
    public static String strKeyToY = "toY";
    public static String strKeyWidth = "width";
    public static String strKeyHeight = "height";
    public static String strKeyDraw = "draw";
    public static String strKeyAWT = "awt";
    protected static int iVerboseClass = 0;
    protected int iVerbose = 0;
    private static final String strClassName = "GraphDraw";
    private Point _ptXYCache = new Point(0, 0);
    private boolean _zUseLocationCached = false;
    private boolean _zUseLocationCachedForNet = false;
    private boolean _zUseLocationCachedForDict = false;

    private static Drawable _getDrawable(Dict dict) {
        if (dict != null) {
            try {
                return (Drawable)dict.get(strKeyDraw);
            }
            catch (ClassCastException classCastException) {
                System.out.println("[GraphDraw,getDrawable(Dict)] Value of key \"" + strKeyDraw + "\" in dict (" + dict + ") is not an instance of class Drawable.");
                return null;
            }
        }
        return null;
    }

    private Drawable _getDrawablePlugIn() {
        Drawable drawable;
        try {
            drawable = (Drawable)this.systemdict.load(strKeyDraw);
        }
        catch (KeyMissingException keyMissingException) {
            drawable = this._initPlugIn();
        }
        return drawable;
    }

    private Drawable _getDrawablePlugIn(Net net) {
        Dict dict;
        Object object;
        try {
            object = this.systemdict.load(net);
        }
        catch (NullPointerException nullPointerException) {
            if (net == null) {
                System.out.println("??[GraphDraw._getDrawablePlugIn(Net)] Null net.");
            } else {
                System.out.println("??[GraphDraw._getDrawablePlugIn(Net)]" + nullPointerException);
            }
            return null;
        }
        catch (KeyMissingException keyMissingException) {
            return this._getDrawablePlugIn();
        }
        try {
            dict = (Dict)object;
        }
        catch (ClassCastException classCastException) {
            System.out.println("??[GraphDraw._getDrawablePlugIn(Net)] Net-key dictionary (" + object + ") is not a Dict.");
            return null;
        }
        Drawable drawable = null;
        try {
            drawable = this._getDrawablePlugIn(dict);
        }
        catch (KeyMissingException keyMissingException) {
            return this._getDrawablePlugIn();
        }
        return drawable;
    }

    private Drawable _getDrawablePlugIn(Dict dict) throws KeyMissingException {
        Drawable drawable = null;
        try {
            try {
                drawable = (Drawable)dict.load(strKeyDraw);
            }
            catch (ClassCastException classCastException) {
                System.out.println("??[GraphDraw._getDrawablePlugIn(Dict)] Plug-in (" + dict.load(strKeyDraw) + ") does not implement Drawable.");
            }
        }
        catch (NullPointerException nullPointerException) {
            if (dict == null) {
                System.out.println("??[GraphDraw._getDrawablePlugIn(Dict)] Null dict.");
            }
            System.out.println("??[GraphDraw._getDrawablePlugIn(Dict)]" + nullPointerException);
        }
        return drawable;
    }

    private Point _getLocation() throws NotDrawableException {
        return this._getLocation(this.systemdict);
    }

    private Point _getLocation(Net net) throws NotDrawableException {
        Dict dict;
        Object v = this.systemdict.get(net);
        try {
            dict = (Dict)v;
        }
        catch (ClassCastException classCastException) {
            return this._getLocation(this.systemdict);
        }
        try {
            return this._getLocation(dict);
        }
        catch (NullPointerException nullPointerException) {
            return this._getLocation(this.systemdict);
        }
        catch (NotDrawableException notDrawableException) {
            return this._getLocation(this.systemdict);
        }
    }

    private Point _getLocation(Dict dict) throws NotDrawableException {
        int n;
        int n2;
        try {
            n2 = dict.getInteger(strKeyX);
            n = dict.getInteger(strKeyY);
        }
        catch (KeyMissingException keyMissingException) {
            throw new NotDrawableException("[GraphDraw]");
        }
        return new Point(n2, n);
    }

    private Drawable _initDrawEdge() {
        Draw2EdgeLine draw2EdgeLine = new Draw2EdgeLine();
        this.systemdict.store(strKeyDraw, draw2EdgeLine);
        return draw2EdgeLine;
    }

    private Drawable _initDrawNet() {
        DrawNetEdgesThenVertices drawNetEdgesThenVertices = new DrawNetEdgesThenVertices();
        this.systemdict.store(strKeyDraw, drawNetEdgesThenVertices);
        return drawNetEdgesThenVertices;
    }

    private Drawable _initDrawVertex() {
        Draw3VertexRectangle draw3VertexRectangle;
        String string = null;
        try {
            string = (String)this.systemdict.load("shape");
        }
        catch (KeyMissingException keyMissingException) {
            string = "Rectangle";
        }
        if ("Rectangle".equals(string)) {
            draw3VertexRectangle = new Draw3VertexRectangle();
        } else if ("RoundRectangle".equals(string)) {
            draw3VertexRectangle = new Draw3VertexRectangle();
        } else {
            System.out.println("[GraphDraw.initDrawVertex()] Invalid shape name = " + string);
            draw3VertexRectangle = null;
        }
        this.systemdict.store(strKeyDraw, draw3VertexRectangle);
        return draw3VertexRectangle;
    }

    private Drawable _initPlugIn() {
        if (this instanceof Edge) {
            return this._initDrawEdge();
        }
        if (this instanceof Vertex) {
            return this._initDrawVertex();
        }
        if (this instanceof Net) {
            return this._initDrawNet();
        }
        System.out.println("[GraphDraw] Invalid type " + this.getClass().getName());
        return null;
    }

    private boolean _isAWT() {
        boolean bl = false;
        if (this.systemdict.containsKey(strKeyAWT) && this.systemdict.get(strKeyAWT) instanceof Component) {
            bl = true;
        }
        return bl;
    }

    private boolean _isAWT(Net net) {
        boolean bl = false;
        Object v = this.systemdict.get(net);
        if (v != null && v instanceof Dict && ((Dict)v).containsKey(strKeyAWT) && ((Dict)v).get(strKeyAWT) instanceof Component) {
            bl = true;
        }
        return bl;
    }

    private boolean _isAWT(Dict dict) {
        return dict != null && dict.containsKey(strKeyAWT) && dict.get(strKeyAWT) instanceof Component;
    }

    private static void _setDrawable(Dict dict, Drawable drawable) {
        if (dict != null) {
            if (drawable != null) {
                dict.def((Object)strKeyDraw, drawable);
            } else {
                dict.undef(strKeyDraw);
            }
        }
    }

    private void _setLocation(int n, int n2) {
        this._setLocation(this.systemdict, n, n2);
    }

    private void _setLocation(Net net, int n, int n2) {
        Object object = this.systemdict.get(net);
        if (object != null && object instanceof Dict) {
            this._setLocation((Dict)object, n, n2);
        } else {
            object = new Dict();
            this.systemdict.def((Object)net, object);
            this._setLocation((Dict)object, n, n2);
        }
    }

    private void _setLocation(Net net, Point point) {
        Object object = this.systemdict.get(net);
        if (object != null && object instanceof Dict) {
            this._setLocation((Dict)object, point.x, point.y);
        } else {
            object = new Dict();
            this.systemdict.def((Object)net, object);
            this._setLocation((Dict)object, point.x, point.y);
        }
    }

    private void _setLocation(Dict dict, int n, int n2) {
        this._setX(dict, n);
        this._setY(dict, n2);
    }

    private void _setLocation(Dict dict, Point point) {
        if (dict != null) {
            this._setLocation(dict, point.x, point.y);
        } else {
            System.out.println("[GraphDraw.setLocation(Dict," + point + ")] Null dict.");
        }
    }

    private void _setLocation(Point point) {
        this._setLocation(this.systemdict, point.x, point.y);
    }

    private void _setLocationX(int n) {
        this._setX(this.systemdict, n);
    }

    private void _setLocationY(int n) {
        this._setY(this.systemdict, n);
    }

    private void _setSize(Dict dict, int n, int n2) {
        dict.def((Object)strKeyWidth, n);
        dict.def((Object)strKeyHeight, n2);
    }

    private void _setX(Dict dict, int n) {
        dict.def((Object)strKeyX, n);
    }

    private void _setY(Dict dict, int n) {
        dict.def((Object)strKeyY, n);
    }

    private void _undefLocation(Dict dict) {
        dict.undef(strKeyX);
        dict.undef(strKeyY);
    }

    public boolean contains(int n, int n2) {
        if (this._isAWT()) {
            return ((Component)this.systemdict.get(strKeyAWT)).contains(n, n2);
        }
        return this._getDrawablePlugIn().contains(this, n, n2);
    }

    public boolean contains(Net net, int n, int n2) {
        if (net == null) {
            return this.contains(n, n2);
        }
        if (this._isAWT(net)) {
            return ((Component)((Dict)this.systemdict.get(net)).get(strKeyAWT)).contains(n, n2);
        }
        if (this._isAWT()) {
            return ((Component)this.systemdict.get(strKeyAWT)).contains(n, n2);
        }
        Drawable drawable = this._getDrawablePlugIn(net);
        if (drawable instanceof Drawable2) {
            return ((Drawable2)drawable).contains(net, this, n, n2);
        }
        return drawable.contains(this, n, n2);
    }

    public boolean contains(Dict dict, int n, int n2) {
        Drawable drawable;
        block6: {
            if (this._isAWT(dict)) {
                return ((Component)dict.get(strKeyAWT)).contains(n, n2);
            }
            if (this._isAWT()) {
                return ((Component)dict.get(strKeyAWT)).contains(n, n2);
            }
            try {
                drawable = this._getDrawablePlugIn(dict);
                if (this.iVerbose >= 2) {
                    System.out.println("\tDrawable found in dict: " + drawable);
                }
            }
            catch (KeyMissingException keyMissingException) {
                drawable = this._getDrawablePlugIn();
                if (this.iVerbose < 2) break block6;
                System.out.println("\tDrawable found in systemdict: " + drawable);
            }
        }
        if (drawable instanceof Drawable3) {
            return ((Drawable3)drawable).contains(dict, (GraphObject)this, n, n2);
        }
        return drawable.contains(this, n, n2);
    }

    public void draw(Net net, Graphics graphics) {
        if (this.iVerbose >= 1) {
            System.out.println("[GraphDraw.draw(Net,Graphics)[" + this + "]]");
        }
        if (net == null) {
            this.draw(graphics);
        }
        if (this._isAWT(net) || this._isAWT()) {
            return;
        }
        Drawable drawable = this._getDrawablePlugIn(net);
        if (this.iVerbose >= 2) {
            System.out.println("\tdrawable = " + drawable);
        }
        if (drawable instanceof Drawable2) {
            ((Drawable2)drawable).draw(net, this, graphics);
        } else {
            Point point = null;
            try {
                point = this.getLocation();
            }
            catch (NotDrawableException notDrawableException) {}
            try {
                this.setLocation(this.getLocation(net));
            }
            catch (NotDrawableException notDrawableException) {}
            drawable.draw(this, graphics);
            if (point != null) {
                this.setLocation(point);
            } else {
                this.undefLocation();
            }
        }
    }

    public void draw(Dict dict, Graphics graphics) {
        Drawable drawable;
        block13: {
            if (this.iVerbose >= 1) {
                System.out.println("[GraphDraw.draw(" + dict + ",Graphics)[" + this + "]]");
            }
            if (this._isAWT(dict) || this._isAWT()) {
                return;
            }
            try {
                drawable = this._getDrawablePlugIn(dict);
                if (this.iVerbose >= 2) {
                    System.out.println("\tDrawable found in dict: " + drawable);
                }
            }
            catch (KeyMissingException keyMissingException) {
                drawable = this._getDrawablePlugIn();
                if (this.iVerbose < 2) break block13;
                System.out.println("\tDrawable found in systemdict: " + drawable);
            }
        }
        if (drawable instanceof Drawable3) {
            ((Drawable3)drawable).draw(dict, (GraphObject)this, graphics);
        } else {
            Point point = null;
            try {
                point = this.getLocation();
            }
            catch (NotDrawableException notDrawableException) {}
            try {
                this.setLocation(this.getLocation(dict));
            }
            catch (NotDrawableException notDrawableException) {}
            drawable.draw(this, graphics);
            if (point != null) {
                this.setLocation(point);
            } else {
                this.undefLocation();
            }
        }
    }

    public void draw(Graphics graphics) {
        if (this._isAWT()) {
            return;
        }
        this._getDrawablePlugIn().draw(this, graphics);
    }

    public Rectangle getBounds() throws NotDrawableException {
        if (this._isAWT()) {
            return ((Component)this.systemdict.get(strKeyAWT)).getBounds();
        }
        return this._getDrawablePlugIn().getBounds(this);
    }

    public Rectangle getBounds(Net net) throws NotDrawableException {
        if (this.iVerbose >= 1) {
            System.out.println("[GraphDraw.getBounds(Net)] For " + this);
        }
        if (net == null) {
            return this.getBounds();
        }
        if (this._isAWT(net)) {
            return ((Component)((Dict)this.systemdict.get(net)).get(strKeyAWT)).getBounds();
        }
        if (this._isAWT()) {
            return ((Component)this.systemdict.get(strKeyAWT)).getBounds();
        }
        Drawable drawable = this._getDrawablePlugIn(net);
        if (this.iVerbose >= 2) {
            System.out.println("\tdrawable = " + drawable);
        }
        if (drawable instanceof Drawable2) {
            return ((Drawable2)drawable).getBounds(net, this);
        }
        return drawable.getBounds(this);
    }

    public Rectangle getBounds(Dict dict) throws NotDrawableException {
        Drawable drawable;
        block8: {
            if (this.iVerbose >= 1) {
                System.out.println("[GraphDraw.getBounds(Dict)] For " + this);
            }
            if (this._isAWT(dict)) {
                return ((Component)dict.get(strKeyAWT)).getBounds();
            }
            if (this._isAWT()) {
                return ((Component)dict.get(strKeyAWT)).getBounds();
            }
            try {
                drawable = this._getDrawablePlugIn(dict);
                if (this.iVerbose >= 2) {
                    System.out.println("\tDrawable found in dict: " + drawable);
                }
            }
            catch (KeyMissingException keyMissingException) {
                drawable = this._getDrawablePlugIn();
                if (this.iVerbose < 2) break block8;
                System.out.println("\tDrawable found in systemdict: " + drawable);
            }
        }
        if (this.iVerbose >= 2) {
            System.out.println("\tdrawable = " + drawable);
        }
        if (drawable instanceof Drawable3) {
            return ((Drawable3)drawable).getBounds(dict, (GraphObject)this);
        }
        return drawable.getBounds(this);
    }

    public Drawable getDrawable() {
        return GraphDraw._getDrawable(this.systemdict);
    }

    public Drawable getDrawable(Net net) {
        Object v;
        Drawable drawable = null;
        try {
            v = this.systemdict.get(net);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("[GraphDraw.getDrawable(Net)] Net is null.");
            return drawable;
        }
        if (v != null) {
            try {
                Dict dict = (Dict)v;
                drawable = GraphDraw._getDrawable(dict);
            }
            catch (ClassCastException classCastException) {}
            if (drawable == null) {
                drawable = GraphDraw._getDrawable(this.systemdict);
            }
        } else {
            drawable = GraphDraw._getDrawable(this.systemdict);
        }
        return drawable;
    }

    public static Drawable getDrawable(Dict dict) {
        return GraphDraw._getDrawable(dict);
    }

    public Rectangle getLabelBounds() throws NotDrawableException {
        if (!(this instanceof Edge)) {
            throw new NotDrawableException("[[" + this + "]GraphDraw.getLabelBounds()] Not Edge.");
        }
        if (this._isAWT()) {
            return ((Component)this.systemdict.get(strKeyAWT)).getBounds();
        }
        Drawable drawable = this._getDrawablePlugIn();
        if (drawable instanceof DrawableEdge) {
            return ((DrawableEdge)drawable).getLabelBounds((Edge)this);
        }
        throw new NotDrawableException("[[" + this + "]GraphDraw.getLabelBounds()] Not DrawableEdge.");
    }

    public Rectangle getLabelBounds(Net net) throws NotDrawableException {
        if (!(this instanceof Edge)) {
            throw new NotDrawableException("[[" + this + "]GraphDraw.getLabelBounds(" + net.getName() + ")] Not Edge.");
        }
        if (net == null) {
            return this.getLabelBounds();
        }
        if (this._isAWT(net)) {
            return ((Component)((Dict)this.systemdict.get(net)).get(strKeyAWT)).getBounds();
        }
        if (this._isAWT()) {
            return ((Component)this.systemdict.get(strKeyAWT)).getBounds();
        }
        Drawable drawable = this._getDrawablePlugIn(net);
        if (drawable instanceof Drawable2Edge) {
            return ((Drawable2Edge)drawable).getLabelBounds(net, (Edge)this);
        }
        throw new NotDrawableException("[[" + this + "]GraphDraw.getLabelBounds(" + net.getName() + ")] Not Drawable2Edge.");
    }

    public Dimension getLabelSize() throws NotDrawableException {
        if (!(this instanceof Edge)) {
            throw new NotDrawableException("[[" + this + "]GraphDraw.getLabelSize()] Not Edge.");
        }
        if (this._isAWT()) {
            return ((Component)this.systemdict.get(strKeyAWT)).getSize();
        }
        Drawable drawable = this._getDrawablePlugIn();
        if (drawable instanceof DrawableEdge) {
            return ((DrawableEdge)drawable).getLabelSize((Edge)this);
        }
        throw new NotDrawableException("[[" + this + "]GraphDraw.getLabelSize()] Not DrawableEdge.");
    }

    public Dimension getLabelSize(Net net) throws NotDrawableException {
        if (!(this instanceof Edge)) {
            throw new NotDrawableException("[[" + this + "]GraphDraw.getLabelBounds(" + net.getName() + ")] Not Edge.");
        }
        if (net == null) {
            return this.getLabelSize();
        }
        if (this._isAWT(net)) {
            return ((Component)((Dict)this.systemdict.get(net)).get(strKeyAWT)).getSize();
        }
        if (this._isAWT()) {
            return ((Component)this.systemdict.get(strKeyAWT)).getSize();
        }
        Drawable drawable = this._getDrawablePlugIn(net);
        if (drawable instanceof Drawable2Edge) {
            return ((Drawable2Edge)drawable).getLabelSize(net, (Edge)this);
        }
        throw new NotDrawableException("[[" + this + "]GraphDraw.getLabelSize(" + net.getName() + ")] Not Drawable2Edge.");
    }

    public Point getLocation() throws NotDrawableException {
        if (this._zUseLocationCached) {
            return this.getLocationCached();
        }
        return this._getLocation();
    }

    public Point getLocation(Net net) throws NotDrawableException {
        if (this._zUseLocationCachedForNet) {
            return this.getLocationCached();
        }
        return this._getLocation(net);
    }

    public Point getLocation(Dict dict) throws NotDrawableException {
        if (this.iVerbose >= 1) {
            System.out.println("[GraphDraw.getLocation(" + dict + ")]");
        }
        if (this._zUseLocationCachedForNet) {
            return this.getLocationCached();
        }
        if (dict != null) {
            if (this.iVerbose >= 2) {
                System.out.println("\treturn from dict: " + this._getLocation(dict));
            }
            return this._getLocation(dict);
        }
        if (this.iVerbose >= 2) {
            System.out.println("\treturn from systemdict: " + this._getLocation(dict));
        }
        return this._getLocation(this.systemdict);
    }

    public Point getLocationCached() {
        return this._ptXYCache;
    }

    public Dimension getSize() throws NotDrawableException {
        if (this._isAWT()) {
            return ((Component)this.systemdict.get(strKeyAWT)).getSize();
        }
        return this._getDrawablePlugIn().getSize(this);
    }

    public Dimension getSize(Net net) throws NotDrawableException {
        if (net == null) {
            return this.getSize();
        }
        if (this._isAWT(net)) {
            return ((Component)((Dict)this.systemdict.get(net)).get(strKeyAWT)).getSize();
        }
        if (this._isAWT()) {
            return ((Component)this.systemdict.get(strKeyAWT)).getSize();
        }
        Drawable drawable = this._getDrawablePlugIn(net);
        if (drawable instanceof Drawable2) {
            return ((Drawable2)drawable).getSize(net, this);
        }
        return drawable.getSize(this);
    }

    public Dimension getSize(Dict dict) throws NotDrawableException {
        Drawable drawable;
        block6: {
            if (this._isAWT(dict)) {
                return ((Component)dict.get(strKeyAWT)).getSize();
            }
            if (this._isAWT()) {
                return ((Component)dict.get(strKeyAWT)).getSize();
            }
            try {
                drawable = this._getDrawablePlugIn(dict);
                if (this.iVerbose >= 2) {
                    System.out.println("\tDrawable found in dict: " + drawable);
                }
            }
            catch (KeyMissingException keyMissingException) {
                drawable = this._getDrawablePlugIn();
                if (this.iVerbose < 2) break block6;
                System.out.println("\tDrawable found in systemdict: " + drawable);
            }
        }
        if (drawable instanceof Drawable3) {
            return ((Drawable3)drawable).getSize(dict, (GraphObject)this);
        }
        return drawable.getSize(this);
    }

    public boolean getUseLocationCached() {
        return this._zUseLocationCached;
    }

    public boolean getUseLocationCachedForDict() {
        return this._zUseLocationCachedForDict;
    }

    public boolean getUseLocationCachedForNet() {
        return this._zUseLocationCachedForNet;
    }

    public int getVerbose() {
        return this.iVerbose;
    }

    public int getVerboseClass() {
        return iVerboseClass;
    }

    public void loadLocationCached() throws NotDrawableException {
        this._ptXYCache = this._getLocation();
    }

    public void loadLocationCached(Net net) throws NotDrawableException {
        this._ptXYCache = this._getLocation(net);
    }

    public void loadLocationCached(Dict dict) throws NotDrawableException {
        this._ptXYCache = this._getLocation(dict);
    }

    public void setDrawable(Drawable drawable) {
        this.systemdict.def((Object)strKeyDraw, drawable);
    }

    public void setDrawable(Net net, Drawable drawable) {
        Object object = this.systemdict.get(net);
        if (object != null && object instanceof Dict) {
            ((Dict)object).def((Object)strKeyDraw, drawable);
        } else {
            object = new Dict();
            this.systemdict.def((Object)net, object);
            ((Dict)object).def((Object)strKeyDraw, drawable);
        }
    }

    public static void setDrawable(Dict dict, Drawable drawable) {
        GraphDraw._setDrawable(dict, drawable);
    }

    public static void setDrawableEdges(Net net, Drawable drawable) {
        Enumeration enumeration = net.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            edge.setDrawable(drawable);
        }
    }

    public static void setDrawableVertices(Net net, Drawable drawable) {
        Enumeration enumeration = net.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            vertex.setDrawable(drawable);
        }
    }

    public void setLocation(int n, int n2) {
        if (this._zUseLocationCached) {
            this.setLocationCached(n, n2);
        } else {
            this._setLocation(n, n2);
        }
    }

    public void setLocation(Net net, int n, int n2) {
        if (this._zUseLocationCachedForNet) {
            this.setLocationCached(n, n2);
        } else {
            this._setLocation(net, n, n2);
        }
    }

    public void setLocation(Net net, Point point) {
        if (this._zUseLocationCachedForNet) {
            this.setLocationCached(point);
        } else {
            this._setLocation(net, point);
        }
    }

    public void setLocation(Dict dict, int n, int n2) {
        if (this._zUseLocationCachedForDict) {
            this.setLocationCached(n, n2);
        } else if (dict != null) {
            this._setLocation(dict, n, n2);
        } else {
            System.out.println("[GraphDraw.setLocation(Dict," + n + "," + n2 + ")] Null dict.");
        }
    }

    public void setLocation(Dict dict, Point point) {
        if (this._zUseLocationCachedForDict) {
            this.setLocationCached(point);
        } else {
            this._setLocation(dict, point);
        }
    }

    public void setLocation(Point point) {
        if (this._zUseLocationCached) {
            this.setLocationCached(point);
        } else {
            this._setLocation(point);
        }
    }

    public void setLocationCached(int n, int n2) {
        this._ptXYCache.x = n;
        this._ptXYCache.y = n2;
    }

    public void setLocationCached(Point point) {
        this._ptXYCache.x = point.x;
        this._ptXYCache.y = point.y;
    }

    public void setLocationCachedX(int n) {
        this._ptXYCache.x = n;
    }

    public void setLocationCachedY(int n) {
        this._ptXYCache.y = n;
    }

    public void setLocationX(int n) {
        if (this._zUseLocationCached) {
            this.setLocationCachedX(n);
        } else {
            this._setLocationX(n);
        }
    }

    public void setLocationY(int n) {
        if (this._zUseLocationCached) {
            this.setLocationCachedY(n);
        } else {
            this._setLocationY(n);
        }
    }

    public void setSize(int n, int n2) {
        this._setSize(this.systemdict, n, n2);
    }

    public void setSize(Net net, int n, int n2) {
        Object object = this.systemdict.get(net);
        if (object != null && object instanceof Dict) {
            this._setSize((Dict)object, n, n2);
        } else {
            object = new Dict();
            this.systemdict.def((Object)net, object);
            this._setSize((Dict)object, n, n2);
        }
    }

    public void setSize(Net net, Dimension dimension) {
        Object object = this.systemdict.get(net);
        if (object != null && object instanceof Dict) {
            this._setSize((Dict)object, dimension.width, dimension.height);
        } else {
            object = new Dict();
            this.systemdict.def((Object)net, object);
            this._setSize((Dict)object, dimension.width, dimension.height);
        }
    }

    public void setSize(Dimension dimension) {
        this._setSize(this.systemdict, dimension.width, dimension.height);
    }

    public void setUseLocationCached(boolean bl) {
        this._zUseLocationCached = bl;
    }

    public void setUseLocationCachedForDict(boolean bl) {
        this._zUseLocationCachedForDict = bl;
    }

    public void setUseLocationCachedForNet(boolean bl) {
        this._zUseLocationCachedForNet = bl;
    }

    public void setVerbose(int n) {
        this.iVerbose = n;
    }

    public void setVerboseClass(int n) {
        iVerboseClass = n;
    }

    public void storeLocationCached() {
        this._setLocation(this._ptXYCache);
    }

    public void storeLocationCached(Net net) {
        this._setLocation(net, this._ptXYCache);
    }

    public void storeLocationCached(Dict dict) {
        this._setLocation(dict, this._ptXYCache);
    }

    public void undefLocation() {
        this._undefLocation(this.systemdict);
    }

    public void undefLocation(Net net) {
        Object v = this.systemdict.get(net);
        if (v != null && v instanceof Dict) {
            this._undefLocation((Dict)v);
        }
    }

    public void undefLocation(Dict dict) {
    }
}

