/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph;

import com.ibm.graph.EdgeSharedException;
import com.ibm.graph.GraphDraw;
import com.ibm.graph.GraphObject;
import com.ibm.graph.Net;
import com.ibm.graph.Vertex;
import com.ibm.graph.VertexMissingException;
import com.ibm.research.util.Dict;
import com.ibm.research.util.KeyMissingException;
import com.ibm.research.util.Set;
import com.ibm.research.util.Throw;
import com.ibm.research.util.Util;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Edge
extends GraphDraw
implements Serializable {
    private static final String _strClassName = "Edge";
    private Vertex _vertexFrom;
    private Vertex _vertexTo;
    private boolean zIsDirected;
    private Set setNets = new Set();

    public Edge(Vertex vertex, Vertex vertex2) {
        this._vertexFrom = vertex;
        this._vertexTo = vertex2;
        this.zIsDirected = false;
    }

    public Edge(Vertex vertex, Vertex vertex2, boolean bl) {
        this(vertex, vertex2);
        this.zIsDirected = bl;
    }

    private Enumeration _enumerateNets() {
        return this.setNets.elements();
    }

    private String _setFromVertexMethod(Vertex vertex) {
        return "setFromVertex(" + vertex + ")";
    }

    private String _setToVertexMethod(Vertex vertex) {
        return "setToVertex(" + vertex + ")";
    }

    boolean add(Net net) {
        if (net == null) {
            return false;
        }
        if (this.setNets.contains(net)) {
            return false;
        }
        this.setNets.addElement(net);
        return true;
    }

    public boolean contains(Vertex vertex) {
        return vertex == this._vertexFrom || vertex == this._vertexTo;
    }

    public boolean delete() {
        GraphDraw graphDraw;
        boolean bl;
        boolean bl2 = true;
        Vertex vertex = this.getFromVertex();
        Vertex vertex2 = this.getToVertex();
        while (true) {
            bl = this.acquireLock();
            boolean bl3 = vertex.acquireLock();
            boolean bl4 = vertex2.acquireLock();
            if (bl && bl3 && bl4) {
                graphDraw = this;
                synchronized (graphDraw) {
                    Vertex vertex3 = vertex;
                    synchronized (vertex3) {
                        Vertex vertex4 = vertex2;
                        synchronized (vertex4) {
                            vertex.remove(this);
                            vertex2.remove(this);
                            this._vertexFrom = null;
                            this._vertexTo = null;
                        }
                    }
                }
            }
            if (bl3) {
                vertex.releaseLock();
            }
            if (bl4) {
                vertex2.releaseLock();
            }
            if (bl) {
                this.releaseLock();
            }
            try {
                if (bl3) {
                    vertex.wait(GraphObject.$iLockWaitTimeout);
                    continue;
                }
                if (bl4) {
                    vertex2.wait(GraphObject.$iLockWaitTimeout);
                    continue;
                }
                if (!bl) continue;
                this.wait(GraphObject.$iLockWaitTimeout);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("[Edge.delete()] Lock wait timed out (" + GraphObject.$iLockWaitTimeout + ").");
            }
        }
        vertex.releaseLock();
        vertex2.releaseLock();
        Enumeration enumeration = this._enumerateNets();
        block17: while (enumeration.hasMoreElements()) {
            graphDraw = (Net)enumeration.nextElement();
            while (true) {
                bl = this.acquireLock(bl);
                boolean bl5 = graphDraw.acquireLock();
                if (bl5 && bl) {
                    GraphDraw graphDraw2 = graphDraw;
                    synchronized (graphDraw2) {
                        bl2 &= ((Net)graphDraw).removeEdge(this);
                    }
                    graphDraw.releaseLock();
                    continue block17;
                }
                if (bl5) {
                    graphDraw.releaseLock();
                }
                if (bl) {
                    this.releaseLock();
                }
                try {
                    if (bl5) {
                        graphDraw.wait(GraphObject.$iLockWaitTimeout);
                    } else if (bl) {
                        this.wait(GraphObject.$iLockWaitTimeout);
                    }
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("[Edge.delete()] Lock wait timed out (" + GraphObject.$iLockWaitTimeout + ").");
                }
                bl = false;
            }
        }
        this.setNets = null;
        this.releaseLock();
        return bl2;
    }

    public void directed() {
        this.zIsDirected = true;
    }

    public Enumeration enumerateNets() {
        return this._enumerateNets();
    }

    protected void finalize() {
    }

    public void flipDirection() {
        Vertex vertex = new Vertex();
        vertex = this._vertexFrom;
        this._vertexFrom = this._vertexTo;
        this._vertexTo = vertex;
    }

    public Vertex getFromVertex() {
        return this._vertexFrom;
    }

    public Net getNet() {
        try {
            return (Net)this.setNets.firstElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            if (this.getWarningLevel() == 1) {
                System.out.println("[Edge.getNet()] This edge does not belong to any net.");
                System.out.println("\tfor edge: " + this);
            }
            return null;
        }
    }

    public Net getNet(int n) {
        try {
            return (Net)this.setNets.get(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.getWarningLevel() == 1) {
                System.out.println("[Edge.getNet(" + n + ")] Index out of bounds.  Only " + this.setNets.size() + " nets available.");
                System.out.println("\tfor edge: " + this);
            }
            return null;
        }
    }

    public int getNetCount() {
        return this.setNets.size();
    }

    public Dict getNetDict(Net net) {
        if (net != null && this.systemdict.containsKey(net)) {
            try {
                return (Dict)this.systemdict.get(net);
            }
            catch (ClassCastException classCastException) {
            }
        }
        return this.systemdict;
    }

    public Dict getNetDict(Net net, boolean bl) {
        Dict dict = null;
        try {
            dict = (Dict)this.systemdict.get(net);
        }
        catch (NullPointerException nullPointerException) {
            if (net == null) {
                return null;
            }
            if (net.systemdict == null) {
                return null;
            }
        }
        catch (ClassCastException classCastException) {}
        if (dict == null && !bl) {
            dict = this.systemdict;
        }
        return dict;
    }

    public Vertex getOtherVertex(Vertex vertex) throws VertexMissingException {
        if (vertex == this._vertexFrom) {
            return this._vertexTo;
        }
        if (vertex == this._vertexTo) {
            return this._vertexFrom;
        }
        throw new VertexMissingException("?![[" + this + "]Edge.otherVertex(" + vertex + ")]");
    }

    public Vertex getToVertex() {
        return this._vertexTo;
    }

    public boolean isBridge(Net net) {
        try {
            if (!this.setNets.contains(net)) {
                return false;
            }
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        net.remove(this);
        boolean bl = net.isConnected();
        net.add(this);
        return bl;
    }

    public boolean isDirected() {
        return this.zIsDirected;
    }

    public boolean isLink() {
        return this.getFromVertex() != this.getToVertex();
    }

    public boolean isLoop() {
        return this.getFromVertex() == this.getToVertex();
    }

    public boolean isUndirected() {
        return this.zIsDirected ^ true;
    }

    boolean move(Net net, Net net2) {
        if (!this.add(net2)) {
            return false;
        }
        if (!this.remove(net)) {
            if (!this.remove(net2)) {
                Throw.throwError(_strClassName, "move(Net,Net)", "Could not remove a just added net from this edge's net-set. BUG?!");
            }
            return false;
        }
        return true;
    }

    public void print(PrintStream printStream, int n) {
        int n2 = n;
        Util.printlnIndented(printStream, n2, "Edge: " + this.toString());
        Util.printlnIndented(printStream, n2 += 2, "systemdict:");
        this.systemdict.print(printStream, n2 += 2);
        Util.printlnIndented(printStream, n2 -= 2, "userdict");
        this.userdict.print(printStream, n2 += 2);
    }

    boolean remove(Net net) {
        if (net == null) {
            return false;
        }
        return this.setNets.removeElement(net);
    }

    boolean removeNet(Net net) {
        if (net == null) {
            return false;
        }
        return this.setNets.removeElement(net);
    }

    public void setFromVertex(Vertex vertex) throws EdgeSharedException {
        if (vertex == null) {
            return;
        }
        if (this.setNets.size() > 1) {
            throw new EdgeSharedException("[Edge." + this._setFromVertexMethod(vertex) + "] This edge is shared by " + this.setNets.size() + " nets.");
        }
        if (this._vertexFrom != this._vertexTo && !this._vertexFrom.remove(this)) {
            Throw.throwError(_strClassName, this._setFromVertexMethod(vertex), " Could not remove the \"from\" vertex of the edge (" + this + "). BUG!?");
        }
        if (vertex != this._vertexTo && !vertex.add(this)) {
            Throw.throwError(_strClassName, this._setFromVertexMethod(vertex), " Could not add the vertex as the \"from\" vertex of the edge (" + this + "). BUG!?");
        }
        this._vertexFrom = vertex;
    }

    public void setToVertex(Vertex vertex) throws EdgeSharedException {
        if (vertex == null) {
            return;
        }
        if (this.setNets.size() > 1) {
            throw new EdgeSharedException("[Edge." + this._setToVertexMethod(vertex) + "] This edge is shared by " + this.setNets.size() + " nets.");
        }
        if (this._vertexTo != this._vertexFrom && !this._vertexTo.remove(this)) {
            Throw.throwError(_strClassName, this._setToVertexMethod(vertex), " Could not remove the \"to\" vertex of the edge (" + this + "). BUG!?");
        }
        if (vertex != this._vertexFrom && !vertex.add(this)) {
            Throw.throwError(_strClassName, this._setToVertexMethod(vertex), " Could not add the vertex as the \"to\" vertex of the edge (" + this + "). BUG!?");
        }
        this._vertexTo = vertex;
    }

    public String toString() {
        String string;
        String string2;
        try {
            string2 = this.systemdict.getString(GraphObject.strKeyName);
        }
        catch (KeyMissingException keyMissingException) {
            string2 = "";
        }
        try {
            string = this.isDirected() ? "[Edge \"" + string2 + "\" from " + this._vertexFrom.toString() + " to " + this._vertexTo.toString() + "]" : "[Edge \"" + string2 + "\" " + this._vertexFrom.toString() + " and " + this._vertexTo.toString() + "]";
        }
        catch (NullPointerException nullPointerException) {
            if (this._vertexFrom == null) {
                System.err.println("[Edge.toString()] Vertex \"from\" is null. BUG!?");
            }
            if (this._vertexTo == null) {
                System.err.println("[Edge.toString()] Vertex \"to\" is null. BUG!?");
            }
            return "";
        }
        return string;
    }

    public void undirected() {
        this.zIsDirected = false;
    }
}

