/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph;

import com.ibm.graph.DirectedGraph;
import com.ibm.graph.Edge;
import com.ibm.graph.Net;
import com.ibm.graph.Vertex;
import com.ibm.research.util.KeyMissingException;
import com.ibm.research.util.Throw;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class DirectedAcyclicGraph
extends DirectedGraph {
    private static final String _$strClassName = "DirectedAcyclicGraph";
    private static final String _X_VERTEX_NOT_IN_DAG = "Vertex does not belong to this directed-acyclic-graph.";
    private static String _$strKeyLevelDefault = "%level%";
    private String _strKeyLevel = _$strKeyLevelDefault;
    private int _iVerbose = 0;

    private Vertex _addChild(Vertex vertex) {
        Vertex vertex2 = new Vertex();
        if (!this.add(vertex2)) {
            System.out.println("[DirectedAcyclicGraph._addChild(" + vertex + ")] Could not add a new parent to this directed-acyclic-graph. BUG?");
            return null;
        }
        if (!this.add(new Edge(vertex, vertex2, true))) {
            System.out.println("[DirectedAcyclicGraph._addChild(" + vertex + ")] Could not add an edge between a new parent and the specified child. BUG?");
            return null;
        }
        return vertex2;
    }

    private boolean _addChild(Vertex vertex, Vertex vertex2) {
        boolean bl = false;
        bl = this.add(new Edge(vertex, vertex2, true));
        return bl;
    }

    private String _addChildMethod(Vertex vertex) {
        return "addChildMethod(" + vertex + ")";
    }

    private String _addChildMethod(Vertex vertex, Vertex vertex2) {
        return "addChildMethod(" + vertex + "," + vertex2 + ")";
    }

    private boolean _addEdges(Vector vector, Vector vector2) {
        boolean bl = true;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (!this.contains(vertex)) {
                bl = false;
                continue;
            }
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                Vertex vertex2 = (Vertex)enumeration2.nextElement();
                if (!this.contains(vertex2)) {
                    bl = false;
                    continue;
                }
                if (this.existsDirectedEdgeFromTo(vertex, vertex2) || this.add(new Edge(vertex, vertex2, true))) continue;
                bl = false;
            }
        }
        return bl;
    }

    private Vertex _addParent(Vertex vertex) {
        Vertex vertex2 = new Vertex();
        if (!this.add(vertex2)) {
            System.out.println("[DirectedAcyclicGraph._addParent(" + vertex + ")] Could not add a new parent to this directed-acyclic-graph. BUG?");
            return null;
        }
        if (!this.add(new Edge(vertex2, vertex, true))) {
            System.out.println("[DirectedAcyclicGraph._addParent(" + vertex + ")] Could not add an edge between a new parent and the specified child. BUG?");
            return null;
        }
        return vertex2;
    }

    private String _addParentMethod(Vertex vertex) {
        return "addParentMethod(" + vertex + ")";
    }

    private int _applyLevel(Vertex vertex, int n) {
        if (this._iVerbose >= 1) {
            System.out.println("[DirectedAcyclicGraph._applyLevel(" + vertex + "," + n + ")]{");
        }
        int n2 = n;
        vertex.systemdict.def((Object)this._strKeyLevel, n);
        Enumeration enumeration = vertex.enumerateOutgoingNeighbors();
        while (enumeration.hasMoreElements()) {
            int n3;
            Vertex vertex2 = (Vertex)enumeration.nextElement();
            try {
                n3 = vertex2.systemdict.getInteger(this._strKeyLevel);
            }
            catch (KeyMissingException keyMissingException) {
                n3 = -1;
            }
            if (n3 != -1 && n3 > n) continue;
            n2 = Math.max(this._applyLevel(vertex2, n + 1), n2);
        }
        if (this._iVerbose >= 1) {
            System.out.println("[DirectedAcyclicGraph._applyLevel(" + vertex + "," + n + ")]}" + n2);
        }
        return n2;
    }

    private Enumeration _enumerateRoots() {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (vertex.degreeIncoming(this) != 0) continue;
            vector.addElement(vertex);
        }
        return vector.elements();
    }

    private Vector _getDescendants(Vertex vertex) {
        return this._getDescendants(vertex, new Vector());
    }

    private Vector _getDescendants(Vertex vertex, Vector vector) {
        Enumeration enumeration = this.enumerateChildren(vertex);
        while (enumeration.hasMoreElements()) {
            Vertex vertex2 = (Vertex)enumeration.nextElement();
            if (vector.contains(vertex2)) continue;
            vector.addElement(vertex2);
            this._getDescendants(vertex2, vector);
        }
        return vector;
    }

    private boolean _hasAllParentsMarked(Vertex vertex, boolean bl, Object object) {
        boolean bl2 = true;
        Enumeration enumeration = this.getParents(vertex).elements();
        while (enumeration.hasMoreElements()) {
            Vertex vertex2 = (Vertex)enumeration.nextElement();
            if (this._isMarked(vertex2, bl, object)) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    private final String _hasAllParentsMarkedMethod(Vertex vertex, boolean bl, Object object) {
        return "hasAllParentsMarked( " + vertex + " , " + bl + " , " + object + " )";
    }

    private boolean _isMarked(Vertex vertex, boolean bl, Object object) {
        return (bl ? vertex.systemdict : vertex.userdict).containsKey(object);
    }

    private final String _isMarkedMethod(Vertex vertex, boolean bl, Object object) {
        return "isMarked( " + vertex + " , " + bl + " , " + object + " )";
    }

    private boolean _isParent(Vertex vertex, Vertex vertex2) {
        boolean bl = false;
        Enumeration enumeration = vertex.enumerateOutgoingNeighbors(this);
        while (enumeration.hasMoreElements()) {
            Vertex vertex3 = (Vertex)enumeration.nextElement();
            if (vertex3 != vertex2) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean _isRoot(Vertex vertex) {
        return vertex.degreeIncoming(this) == 0;
    }

    private final String _isRootMethod(Vertex vertex) {
        return "_isRootMethod(" + vertex + ")";
    }

    private void _mark(Vertex vertex, boolean bl, Object object) {
        (bl ? vertex.systemdict : vertex.userdict).def(object, true);
    }

    private final String _markMethod(Vertex vertex, boolean bl, Object object) {
        return "mark( " + vertex + " , " + bl + " , " + object + " )";
    }

    private int _markUnsharedChildrenRecursive(Vertex vertex, boolean bl, Object object, int n) {
        int n2 = n;
        Enumeration enumeration = this.getChildren(vertex).elements();
        while (enumeration.hasMoreElements()) {
            Vertex vertex2 = (Vertex)enumeration.nextElement();
            if (this._isMarked(vertex2, bl, object) || !this._hasAllParentsMarked(vertex2, bl, object)) continue;
            this._mark(vertex2, bl, object);
            ++n2;
            n2 = this._markUnsharedChildrenRecursive(vertex2, bl, object, n2);
        }
        return n2;
    }

    private int _markUnsharedDescendants(Vertex vertex, boolean bl, Object object) {
        this._mark(vertex, bl, object);
        return this._markUnsharedChildrenRecursive(vertex, bl, object, 0);
    }

    private final String _markUnsharedDescendantsMethod(Vertex vertex, boolean bl, Object object) {
        return "markUnsharedDescendants( " + vertex + " , " + bl + " , " + object + " )";
    }

    private boolean _removeEdge(Vertex vertex, Vertex vertex2) {
        boolean bl = false;
        Enumeration enumeration = this.enumerateEdges(vertex, vertex2);
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!this.remove(edge)) {
                System.err.println("[DirectedAcyclicGraph." + this._removeEdgeMethod(vertex, vertex2) + "] Could not remove edge(" + edge + ") from this directed-acyclic-graph. BUG!?");
                continue;
            }
            bl = true;
        }
        return bl;
    }

    private final String _removeEdgeMethod(Vertex vertex, Vertex vertex2) {
        return "removeEdge(" + vertex + "," + vertex2 + ")";
    }

    private void _removeUnsharedChildrenTreeWithTransitiveClosure(Vertex vertex) {
        Vector vector = this.getParents(vertex);
        String string = this.defVertexUniqueSystemKey("%DAG-UCT%");
        this._markUnsharedDescendants(vertex, true, string);
        Vector vector2 = this.getVerticesBySystemKey(string);
        Vector vector3 = this.getOuterChildren(vector2);
        if (!this.remove(vector2)) {
            System.err.println("[DirectedAcyclicGraph." + this._removeUnsharedChildrenTreeWithTransitiveClosureMethod(vertex) + "] Unable to remove some of the vertices in " + vector2 + " from the directed-acyclic-graph.");
        }
        if (!this.addEdges(vector, vector3)) {
            System.err.println("[DirectedAcyclicGraph." + this._removeUnsharedChildrenTreeWithTransitiveClosureMethod(vertex) + "] Unable to add some edges between " + vector + " and " + vector3 + ".");
        }
    }

    private final String _removeUnsharedChildrenTreeWithTransitiveClosureMethod(Vertex vertex) {
        return "removeUnsharedChildrenTreeWithTransitiveClosure( " + vertex + " )";
    }

    private void _removeVertexWithTransitiveClosure(Vertex vertex) {
        Vector vector = this.getParents(vertex);
        Vector vector2 = this.getChildren(vertex);
        if (!this.remove(vertex)) {
            System.err.println("[DirectedAcyclicGraph." + this._removeVertexWithTransitiveClosureMethod(vertex) + "] Could not remove vertex from this directed-acyclic graph.");
            return;
        }
        if (!this.addEdges(vector, vector2)) {
            System.err.println("[DirectedAcyclicGraph." + this._removeVertexWithTransitiveClosureMethod(vertex) + "] Part or all of transitive-closure failed for addEdges(" + vector + "," + vector2 + ").");
            return;
        }
    }

    private final String _removeVertexWithTransitiveClosureMethod(Vertex vertex) {
        return "removeVertexWithTransitiveClosure(" + vertex + ")";
    }

    public Vertex addChild(Vertex vertex) {
        if (vertex == null) {
            return null;
        }
        if (!this.contains(vertex)) {
            Throw.throwIllegalArgumentException(_$strClassName, this._addChildMethod(vertex), _X_VERTEX_NOT_IN_DAG);
        }
        return this._addChild(vertex);
    }

    public boolean addChild(Vertex vertex, Vertex vertex2) {
        boolean bl = false;
        if (vertex != null && vertex2 != null && this.contains(vertex)) {
            bl = this._addChild(vertex, vertex2);
        }
        return bl;
    }

    public boolean addEdges(Vector vector, Vector vector2) {
        if (vector == null || vector2 == null) {
            return false;
        }
        return this._addEdges(vector, vector2);
    }

    public Vertex addParent(Vertex vertex) {
        if (vertex == null) {
            return null;
        }
        if (!this.contains(vertex)) {
            Throw.throwIllegalArgumentException(_$strClassName, this._addParentMethod(vertex), _X_VERTEX_NOT_IN_DAG);
        }
        return this._addParent(vertex);
    }

    public int doLeveling() {
        if (this._iVerbose >= 1) {
            System.out.println("[DirectedAcyclicGraph.doLeveling()]{");
        }
        int n = -1;
        this.defVertexSystemKey((Object)this._strKeyLevel, -1);
        Enumeration enumeration = this._enumerateRoots();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (this._iVerbose >= 1) {
                System.out.println("\troot = " + vertex);
            }
            n = this._applyLevel(vertex, 0);
        }
        if (this._iVerbose >= 1) {
            System.out.println("[DirectedAcyclicGraph.doLeveling()]}" + n);
        }
        return n;
    }

    public Enumeration enumerateRoots() {
        return this._enumerateRoots();
    }

    public Vector getDescendants(Vertex vertex) {
        Vector vector = new Vector();
        if (vertex != null && this.contains(vertex)) {
            vector = this._getDescendants(vertex, vector);
        }
        return vector;
    }

    public String getKeyNameLevel() {
        return this._strKeyLevel;
    }

    public static String getKeyNameLevelDefault() {
        return _$strKeyLevelDefault;
    }

    public Vector getSiblings(int n) {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = this.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            try {
                int n2 = vertex.systemdict.getInteger(this._strKeyLevel);
                if (n2 != n) continue;
                vector.addElement(vertex);
            }
            catch (KeyMissingException keyMissingException) {}
        }
        return vector;
    }

    public int getVertexLevel(Vertex vertex) {
        try {
            return vertex.systemdict.getInteger(this._strKeyLevel);
        }
        catch (KeyMissingException keyMissingException) {
            this.doLeveling();
            try {
                return vertex.systemdict.getInteger(this._strKeyLevel);
            }
            catch (KeyMissingException keyMissingException2) {
                System.err.println("[DirectedAcyclicGraph.getVertexLabel(" + vertex + ")] Could not establish level of vertex. Bug!?");
                return -1;
            }
        }
    }

    public boolean hasAllParentsMarked(Vertex vertex, boolean bl, Object object) {
        boolean bl2 = true;
        if (vertex != null && object != null) {
            if (!this.contains(vertex)) {
                Throw.throwIllegalArgumentException(_$strClassName, this._hasAllParentsMarkedMethod(vertex, bl, object), _X_VERTEX_NOT_IN_DAG);
            }
            bl2 = this._hasAllParentsMarked(vertex, bl, object);
        }
        return bl2;
    }

    public boolean isMarked(Vertex vertex, boolean bl, Object object) {
        boolean bl2 = false;
        if (vertex != null && object != null) {
            if (!this.contains(vertex)) {
                Throw.throwIllegalArgumentException(_$strClassName, this._isMarkedMethod(vertex, bl, object), _X_VERTEX_NOT_IN_DAG);
            }
            bl2 = this._isMarked(vertex, bl, object);
        }
        return bl2;
    }

    public boolean isParent(Vertex vertex, Vertex vertex2) {
        boolean bl = false;
        if (vertex != null && vertex2 != null && this.contains(vertex) && this.contains(vertex2)) {
            bl = this._isParent(vertex, vertex2);
        }
        return bl;
    }

    public boolean isRoot(Vertex vertex) {
        if (vertex == null) {
            Throw.throwIllegalArgumentException(_$strClassName, this._isRootMethod(vertex), Net.X_NULL_VERTEX);
        }
        if (!this.contains(vertex)) {
            Throw.throwIllegalArgumentException(_$strClassName, this._isRootMethod(vertex), _X_VERTEX_NOT_IN_DAG);
        }
        return this._isRoot(vertex);
    }

    public void mark(Vertex vertex, boolean bl, Object object) {
        if (vertex != null && object != null) {
            if (!this.contains(vertex)) {
                Throw.throwIllegalArgumentException(_$strClassName, this._markMethod(vertex, bl, object), _X_VERTEX_NOT_IN_DAG);
            }
            this._mark(vertex, bl, object);
        }
    }

    public int markUnsharedDescendants(Vertex vertex, boolean bl, Object object) {
        int n = 0;
        if (vertex != null && object != null) {
            if (!this.contains(vertex)) {
                Throw.throwIllegalArgumentException(_$strClassName, this._markUnsharedDescendantsMethod(vertex, bl, object), _X_VERTEX_NOT_IN_DAG);
            }
            n = this._markUnsharedDescendants(vertex, bl, object);
        }
        return n;
    }

    public boolean removeEdge(Vertex vertex, Vertex vertex2) {
        boolean bl = false;
        if (vertex != null && vertex2 != null && this.contains(vertex) && this.contains(vertex2)) {
            bl = this._removeEdge(vertex, vertex2);
        }
        return bl;
    }

    public void removeUnsharedChildrenTreeWithTransitiveClosure(Vertex vertex) {
        if (vertex == null) {
            return;
        }
        if (!this.contains(vertex)) {
            Throw.throwIllegalArgumentException(_$strClassName, this._removeUnsharedChildrenTreeWithTransitiveClosureMethod(vertex), _X_VERTEX_NOT_IN_DAG);
        }
        this._removeUnsharedChildrenTreeWithTransitiveClosure(vertex);
    }

    public void removeVertexWithTransitiveClosure(Vertex vertex) {
        if (vertex == null) {
            return;
        }
        if (!this.contains(vertex)) {
            Throw.throwIllegalArgumentException(_$strClassName, this._removeVertexWithTransitiveClosureMethod(vertex), _X_VERTEX_NOT_IN_DAG);
        }
        this._removeVertexWithTransitiveClosure(vertex);
    }

    public void setKeyNameLevel(String string) {
        this._strKeyLevel = string;
    }

    public static void setKeyNameLevelDefault(String string) {
        _$strKeyLevelDefault = string;
    }

    public void setVerboseStack(Stack stack) {
        Object e;
        if (stack == null || stack.empty()) {
            return;
        }
        try {
            e = stack.pop();
        }
        catch (EmptyStackException emptyStackException) {
            return;
        }
        try {
            this._iVerbose = (Integer)e;
        }
        catch (ClassCastException classCastException) {
            System.out.println("[DirectedAcyclicGraph.setVerboseStack(Stack)] Object (" + e + ") popped from the stack is not an Integer object.");
            return;
        }
    }

    protected boolean validEdge(Edge edge) {
        boolean bl = super.validEdge(edge);
        if (bl) {
            bl = this.isDescendant(edge.getToVertex(), edge.getFromVertex()) ^ true;
        }
        return bl;
    }
}

