/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleLogger;
import com.ibm.able.data.AbleArrayLiteral;
import com.ibm.able.data.AbleArrayVariable;
import com.ibm.able.data.AbleContinuousVariable;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleFuzzySetBeta;
import com.ibm.able.data.AbleFuzzySetGaussian;
import com.ibm.able.data.AbleFuzzySetLinear;
import com.ibm.able.data.AbleFuzzySetPi;
import com.ibm.able.data.AbleFuzzySetSegments;
import com.ibm.able.data.AbleFuzzySetShoulder;
import com.ibm.able.data.AbleFuzzySetSigmoid;
import com.ibm.able.data.AbleFuzzySetTrapezoid;
import com.ibm.able.data.AbleFuzzySetTriangle;
import com.ibm.able.data.AbleFuzzyVariable;
import com.ibm.able.data.AbleGenericLiteral;
import com.ibm.able.data.AbleGenericVariable;
import com.ibm.able.data.AbleLhs;
import com.ibm.able.data.AblePredicate;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleTypedVariableField;
import com.ibm.able.data.AbleTypedVariableMethodLiteral;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleAntecedentClause;
import com.ibm.able.rules.AbleAssertionClause;
import com.ibm.able.rules.AbleAssertionRule;
import com.ibm.able.rules.AbleConditionalRule;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleDoUntilRule;
import com.ibm.able.rules.AbleDoWhileRule;
import com.ibm.able.rules.AbleForLoopRule;
import com.ibm.able.rules.AbleHierarchicalPlanningRule;
import com.ibm.able.rules.AbleIfThenElseRule;
import com.ibm.able.rules.AbleParException;
import com.ibm.able.rules.AblePatternMatchRule;
import com.ibm.able.rules.AblePlanningRule;
import com.ibm.able.rules.AblePolicyRule;
import com.ibm.able.rules.AblePredicateFact;
import com.ibm.able.rules.AblePredicateRule;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleSet;
import com.ibm.able.rules.AbleSelector;
import com.ibm.able.rules.AbleWhileDoRule;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

class AbleXmlParser
extends DefaultHandler {
    protected Locator myLocator = null;
    protected AbleRuleSet myRuleSet = null;
    protected AbleLogger myTracer = null;
    protected boolean myStopOnParException = false;
    protected String myRuleSetName = "";
    protected String myComment;
    protected boolean myTemplateFlag;
    protected double myAlphaCut;
    protected String myEngineType;
    protected String myImportLibName;
    protected String myUserTypeName;
    protected String myUserTypeClass;
    protected String myVariableName;
    protected AbleVariable myDclVariable;
    protected boolean myVarInitializerFlag = false;
    protected AbleRd myVarInitializer;
    protected Vector myVarInitializerArgs;
    protected boolean myNewObjectFlag = false;
    protected Vector myVariableCatValue;
    protected double myVariableContinuousLo;
    protected double myVariableContinuousHi;
    protected Vector myVariableDiscreteValue;
    protected Vector myVariableListValue;
    protected int myVariableLength;
    protected Class[] myArrayTypes;
    protected String myVariableStringValue;
    protected boolean myVariableStaticFlag;
    protected String myVariableType;
    protected String myVariableClassName;
    protected String myUserDefinedFunctionName;
    protected AbleFuzzyVariable myFuzzyVariable = null;
    protected String mySetName;
    protected String mySetNameComplement;
    protected double mySetPtLeft;
    protected double mySetPtLeftCore;
    protected double mySetPtCenter;
    protected double mySetPtFlex;
    protected double mySetPtRightCore;
    protected double mySetPtRight;
    protected double mySetWeight;
    protected double mySetWidth;
    protected int mySetDirection;
    protected int myNumberOfSegments;
    protected double[] myScalarVector;
    protected double[] myTruthVector;
    protected String myRuleBlockName;
    protected AbleRuleBlock myRuleBlock = null;
    protected String myRuleBlockReturnType;
    protected double myRuleAntWeight;
    protected String myRuleHedges;
    protected String myRuleLabel;
    protected AbleRule myRule;
    protected Object[] myRulePreConditions;
    protected boolean myRuleReplacementMode;
    protected Stack myRuleCallStack = new Stack();
    protected int myRuleOp;
    protected String myRuleToken;
    protected int myRuleTokenType;
    protected Vector myRuleParms = new Vector();
    protected String myRuleFieldOrMethod;
    protected AbleRd myRuleArrayIndexExpression;
    protected AbleRd myRuleFuzzyVar;
    protected String myRuleVarLhs;
    protected AbleAntecedentClause myAntClause;
    protected Vector myAntClauses = new Vector();
    protected Vector myAntExpressionList = new Vector();
    protected AbleExpression myAntExpression = null;
    protected AbleRd myRulePriority;
    protected boolean myRuleIsConditional;
    protected AbleRd myExpression = null;
    protected boolean myExpressionInProgress = false;
    protected Stack myExpressionStack = new Stack();
    protected AbleRd myRuleCns = null;
    Vector myRuleCompoundLiterals = new Vector();
    boolean myCompoundLitFlag = false;
    protected AbleAssertionClause myAstClause = null;
    protected AbleConsequentClause myCnsClause = null;
    protected Vector myThenList = new Vector();
    protected Vector myElseList = new Vector();
    protected Vector myPlanEffectsList;
    protected Vector myPlanExpansionList;
    protected Vector myWdWhenList = new Vector();
    protected Vector myWdDoList = new Vector();
    protected String myWdSelVarName;
    protected String myWdSelVarType;
    protected boolean myWdSelPosFlag;
    protected AbleVariable myWdSelVariable;
    protected String myPredName = "";
    protected boolean myPredPosFlag = true;
    protected Stack myPredStack = new Stack();
    protected AblePredicate myPredLhs = null;
    protected Vector myPredClauses = new Vector();
    protected Vector myDoList = new Vector();
    protected String myDoType;
    protected Vector myForInitExprList;
    protected AbleExpression myForTestExpr;
    protected Vector myForIterExprList;
    protected Stack myArgListStack = new Stack();
    protected Vector myArgList;
    protected AbleRd myArg;
    AbleExpression myPlanPrecondition;
    Vector myFormalParameterList;
    protected boolean mySetComp = false;
    protected boolean lookingForArgs = false;
    protected boolean inTagPredicateRuleFact = false;
    protected boolean inTagPredicateRuleHead = false;
    protected boolean inTagPredicateRuleBody = false;
    protected boolean inThenSection = false;
    protected boolean inElseSection = false;

    public void setDocumentLocator(Locator locator) {
        this.myLocator = locator;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            if (string3.equalsIgnoreCase("AbleRuleSet")) {
                this.hndlRuleSetName(attributes);
            } else if (string3.equalsIgnoreCase("inference")) {
                this.hndlInferenceMethod(attributes);
            } else if (string3.equalsIgnoreCase("library")) {
                this.hndlLibrary(attributes);
            } else if (string3.equalsIgnoreCase("import")) {
                this.hndlImport(attributes);
            } else if (string3.equalsIgnoreCase("predicates")) {
                this.validateOkForPredicates();
            } else if (string3.equalsIgnoreCase("predicate")) {
                this.xferDclPredicate(attributes);
            } else if (string3.equalsIgnoreCase("declareClass")) {
                this.hndlDclInnerClass(attributes);
            } else if (string3.equalsIgnoreCase("declareVar")) {
                this.hndlDclVar(attributes);
            } else if (string3.equalsIgnoreCase("varInitializer")) {
                this.saveVarInitializer(attributes);
            } else if (string3.equalsIgnoreCase("preConditions")) {
                this.saveRulePreConditions(attributes);
            } else if (string3.equalsIgnoreCase("expression")) {
                this.saveExpression(attributes);
            } else if (string3.equalsIgnoreCase("arrayExprValue")) {
                this.saveArrayExprValue(attributes);
            } else if (string3.equalsIgnoreCase("booleanElement")) {
                this.hndlDclBooElem(attributes);
            } else if (string3.equalsIgnoreCase("numericElement")) {
                this.hndlDclNumElem(attributes);
            } else if (string3.equalsIgnoreCase("stringElement")) {
                this.hndlDclStrElem(attributes);
            } else if (string3.equalsIgnoreCase("variableElement")) {
                this.hndlDclVarElem(attributes);
            } else if (string3.equalsIgnoreCase("betaSet")) {
                this.saveDclBeta(attributes);
            } else if (string3.equalsIgnoreCase("complementSet")) {
                this.saveDclComplement(attributes);
            } else if (string3.equalsIgnoreCase("gaussianSet")) {
                this.saveDclGaussian(attributes);
            } else if (string3.equalsIgnoreCase("linearSet")) {
                this.saveDclLinear(attributes);
            } else if (string3.equalsIgnoreCase("piSet")) {
                this.saveDclPi(attributes);
            } else if (string3.equalsIgnoreCase("segmentsSet")) {
                this.saveDclSegments(attributes);
            } else if (string3.equalsIgnoreCase("membership")) {
                this.hndlDclSegmentsItem(attributes);
            } else if (string3.equalsIgnoreCase("shoulderSet")) {
                this.saveDclShoulder(attributes);
            } else if (string3.equalsIgnoreCase("sigmoidSet")) {
                this.saveDclSigmoid(attributes);
            } else if (string3.equalsIgnoreCase("trapezoidSet")) {
                this.saveDclTrapezoid(attributes);
            } else if (string3.equalsIgnoreCase("triangleSet")) {
                this.saveDclTriangle(attributes);
            } else if (string3.equalsIgnoreCase("inputs")) {
                this.hndlIOVariableNames(attributes, true);
            } else if (string3.equalsIgnoreCase("outputs")) {
                this.hndlIOVariableNames(attributes, false);
            } else if (string3.equalsIgnoreCase("function")) {
                this.hndlDclFunction(attributes);
            } else if (string3.equalsIgnoreCase("ruleBlock")) {
                this.hndlRuleBlock(attributes);
            } else if (string3.equalsIgnoreCase("rule")) {
                this.saveRule(attributes);
            } else if (string3.equalsIgnoreCase("priority")) {
                this.saveRulePriority(attributes);
            } else if (string3.equalsIgnoreCase("assert")) {
                this.saveRulAssert(attributes);
            } else if (string3.equalsIgnoreCase("variableReference")) {
                this.saveLhsVarRef(attributes);
            } else if (string3.equalsIgnoreCase("fuzzyVar")) {
                this.saveLhsVarRef(attributes);
            } else if (string3.equalsIgnoreCase("fieldValue")) {
                this.saveFieldValue(attributes);
            } else if (string3.equalsIgnoreCase("equals")) {
                this.saveRuleOperator(1);
            } else if (string3.equalsIgnoreCase("is")) {
                this.saveRuleOperator(2);
            } else if (string3.equalsIgnoreCase("isEqualTo")) {
                this.saveRuleOperator(3);
            } else if (string3.equalsIgnoreCase("isGreaterThan")) {
                this.saveRuleOperator(4);
            } else if (string3.equalsIgnoreCase("isGreaterThanOrEqualTo")) {
                this.saveRuleOperator(5);
            } else if (string3.equalsIgnoreCase("isLessThan")) {
                this.saveRuleOperator(7);
            } else if (string3.equalsIgnoreCase("isLessThanOrEqualTo")) {
                this.saveRuleOperator(8);
            } else if (string3.equalsIgnoreCase("isNotEqualTo")) {
                this.saveRuleOperator(9);
            } else if (string3.equalsIgnoreCase("logicalNOT")) {
                this.saveRuleOperator(18);
            } else if (string3.equalsIgnoreCase("logicalAND")) {
                this.saveRuleOperator(16);
            } else if (string3.equalsIgnoreCase("logicalOR")) {
                this.saveRuleOperator(17);
            } else if (string3.equalsIgnoreCase("plus")) {
                this.saveRuleOperator(11);
            } else if (string3.equalsIgnoreCase("minus")) {
                this.saveRuleOperator(12);
            } else if (string3.equalsIgnoreCase("multiply")) {
                this.saveRuleOperator(13);
            } else if (string3.equalsIgnoreCase("divide")) {
                this.saveRuleOperator(14);
            } else if (string3.equalsIgnoreCase("modulo")) {
                this.saveRuleOperator(15);
            } else if (string3.equalsIgnoreCase("unaryMinus")) {
                this.saveRuleOperator(20);
            } else if (string3.equalsIgnoreCase("unaryPlus")) {
                this.saveRuleOperator(19);
            } else if (string3.equalsIgnoreCase("noOperation")) {
                this.saveRuleOperator(10);
            } else if (string3.equalsIgnoreCase("null")) {
                this.saveNullExpressionArg();
            } else if (string3.equalsIgnoreCase("bitwiseNOT")) {
                this.saveRuleOperator(24);
            } else if (string3.equalsIgnoreCase("bitwiseAND")) {
                this.saveRuleOperator(21);
            } else if (string3.equalsIgnoreCase("bitwiseOR")) {
                this.saveRuleOperator(22);
            } else if (string3.equalsIgnoreCase("bitwiseXOR")) {
                this.saveRuleOperator(23);
            } else if (string3.equalsIgnoreCase("bitShiftLeft")) {
                this.saveRuleOperator(25);
            } else if (string3.equalsIgnoreCase("bitShiftRight")) {
                this.saveRuleOperator(26);
            } else if (string3.equalsIgnoreCase("bitShiftRightZeroFill")) {
                this.saveRuleOperator(27);
            } else if (string3.equalsIgnoreCase("booleanLiteral")) {
                this.saveBooleanLit(attributes);
            } else if (string3.equalsIgnoreCase("byteLiteral")) {
                this.saveByteLit(attributes);
            } else if (string3.equalsIgnoreCase("characterLiteral")) {
                this.saveCharacterLit(attributes);
            } else if (string3.equalsIgnoreCase("numericLiteral")) {
                this.saveNumericLit(attributes);
            } else if (string3.equalsIgnoreCase("doubleLiteral")) {
                this.saveDoubleLit(attributes);
            } else if (string3.equalsIgnoreCase("floatLiteral")) {
                this.saveFloatLit(attributes);
            } else if (string3.equalsIgnoreCase("integerLiteral")) {
                this.saveIntegerLit(attributes);
            } else if (string3.equalsIgnoreCase("longLiteral")) {
                this.saveLongLit(attributes);
            } else if (string3.equalsIgnoreCase("shortLiteral")) {
                this.saveShortLit(attributes);
            } else if (string3.equalsIgnoreCase("timeStampLiteral")) {
                this.saveTimeStampLit(attributes);
            } else if (string3.equalsIgnoreCase("newObjectLiteral")) {
                this.saveNewObjectLit(attributes);
            } else if (string3.equalsIgnoreCase("compoundLiteral")) {
                this.saveCompoundLit(attributes);
            } else if (string3.equalsIgnoreCase("stringLiteral")) {
                this.saveStringLit(attributes);
            } else if (string3.equalsIgnoreCase("variableValue")) {
                this.saveVariableValue(attributes);
            } else if (string3.equalsIgnoreCase("hedge")) {
                this.saveHedge(attributes);
            } else if (string3.equalsIgnoreCase("fuzzyValue")) {
                this.saveFuzzyValue(attributes);
            } else if (string3.equalsIgnoreCase("functionValue")) {
                this.saveFunctionValue(attributes);
            } else if (string3.equalsIgnoreCase("methodValue")) {
                this.saveMethodValue(attributes);
            } else if (string3.equalsIgnoreCase("if")) {
                this.saveRulCond(attributes);
            } else if (string3.equalsIgnoreCase("antecedent")) {
                this.saveRulAnt();
            } else if (string3.equalsIgnoreCase("antecedentExpr")) {
                this.saveRulAntExpr();
            } else if (string3.equalsIgnoreCase("weight")) {
                this.saveRuleAntecedentWeight(attributes);
            } else if (string3.equalsIgnoreCase("then")) {
                this.saveRulThen();
            } else if (string3.equalsIgnoreCase("else")) {
                this.saveRulElse(attributes);
            } else if (string3.equalsIgnoreCase("consequent")) {
                this.saveRulCns();
            } else if (string3.equalsIgnoreCase("argList")) {
                this.saveArgList();
            } else if (string3.equalsIgnoreCase("arg")) {
                this.saveArg();
            } else if (string3.equalsIgnoreCase("when")) {
                this.saveRulWhen(attributes);
            } else if (string3.equalsIgnoreCase("selector")) {
                this.saveRulSelector(attributes);
            } else if (string3.equalsIgnoreCase("constraint")) {
                this.saveRulConstraint();
            } else if (string3.equalsIgnoreCase("whileDo")) {
                this.saveRulWhileDo(attributes);
            } else if (string3.equalsIgnoreCase("doWhile")) {
                this.saveRulDoWhile(attributes);
            } else if (string3.equalsIgnoreCase("doUntil")) {
                this.saveRulDoUntil(attributes);
            } else if (string3.equalsIgnoreCase("do")) {
                this.saveRulDo(attributes);
            } else if (string3.equalsIgnoreCase("action")) {
                this.saveRulAction();
            } else if (string3.equalsIgnoreCase("do_")) {
                this.saveRulDo_(attributes);
            } else if (string3.equalsIgnoreCase("action_")) {
                this.saveRulAction_();
            } else if (string3.equalsIgnoreCase("for")) {
                this.saveRulForLoop(attributes);
            } else if (string3.equalsIgnoreCase("plan")) {
                this.saveRulPlan(attributes);
            } else if (string3.equalsIgnoreCase("parameters")) {
                this.saveRulParameters();
            } else if (string3.equalsIgnoreCase("formalParameter")) {
                this.saveFormalParameter(attributes);
            } else if (string3.equalsIgnoreCase("effect")) {
                this.saveRulPlanEffects();
            } else if (string3.equalsIgnoreCase("expansion")) {
                this.saveRulPlanExpansion();
            } else if (string3.equalsIgnoreCase("policy")) {
                this.saveRulPolicy(attributes);
            } else if (string3.equalsIgnoreCase("predicateRule")) {
                this.saveRulPred(attributes);
            } else if (string3.equalsIgnoreCase("predicateRuleFact")) {
                this.inTagPredicateRuleFact = true;
            } else if (string3.equalsIgnoreCase("predicateRuleHead")) {
                this.inTagPredicateRuleHead = true;
            } else if (string3.equalsIgnoreCase("predicateRuleBody")) {
                this.inTagPredicateRuleBody = true;
            } else if (string3.equalsIgnoreCase("predicateDef")) {
                this.savePredDef(attributes);
            } else if (string3.equalsIgnoreCase("predicateBooleanArg")) {
                this.savePredArgBoolean(attributes);
            } else if (string3.equalsIgnoreCase("predicateListArg")) {
                this.savePredArgList();
            } else if (string3.equalsIgnoreCase("predicateListArgTail")) {
                this.savePredBarFlag(true);
            } else if (string3.equalsIgnoreCase("predicateNumericArg")) {
                this.savePredArgNumber(attributes);
            } else if (string3.equalsIgnoreCase("predicateStringArg")) {
                this.savePredArgString(attributes);
            } else if (string3.equalsIgnoreCase("predicateCharacterArg")) {
                this.savePredArgCharacter(attributes);
            } else if (string3.equalsIgnoreCase("predicateSymbol")) {
                this.savePredArgSymbol(attributes);
            } else if (string3.equalsIgnoreCase("predicateVariableArg")) {
                this.savePredArgVariable(attributes);
            } else if (string3.equalsIgnoreCase("predicateDontCareSymbol")) {
                this.savePredArgDontCare();
            }
        }
        catch (AbleParException ableParException) {
            throw new SAXParseException(null, this.myLocator, (Exception)((Object)ableParException));
        }
        catch (RemoteException remoteException) {
            throw new SAXParseException(null, this.myLocator, remoteException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (string3.equalsIgnoreCase("declareVar")) {
                this.xferDclVar();
            } else if (string3.equalsIgnoreCase("varInitializer")) {
                this.xferVarInitializer();
            } else if (string3.equalsIgnoreCase("preConditions")) {
                this.xferRulePreConditions();
            } else if (string3.equalsIgnoreCase("rule")) {
                this.xferRule();
            } else if (string3.equalsIgnoreCase("priority")) {
                this.xferRulePriority();
            } else if (string3.equalsIgnoreCase("arrayElement")) {
                this.xferArrayElement();
            } else if (string3.equalsIgnoreCase("arrayLiteral")) {
                this.xferArrayLiteral();
            } else if (string3.equalsIgnoreCase("functionValue")) {
                this.xferFunctionValue();
            } else if (string3.equalsIgnoreCase("methodValue")) {
                this.xferMethodValue();
            } else if (string3.equalsIgnoreCase("newObjectLiteral")) {
                this.xferNewObjectLit();
            } else if (string3.equalsIgnoreCase("compoundLiteral")) {
                this.xferCompoundLit();
            } else if (string3.equalsIgnoreCase("compoundLiteralArg")) {
                this.xferCompoundLitArg();
            } else if (string3.equalsIgnoreCase("betaSet")) {
                this.xferDclBeta();
            } else if (string3.equalsIgnoreCase("gaussianSet")) {
                this.xferDclGaussian();
            } else if (string3.equalsIgnoreCase("linearSet")) {
                this.xferDclLinear();
            } else if (string3.equalsIgnoreCase("piSet")) {
                this.xferDclPi();
            } else if (string3.equalsIgnoreCase("segmentsSet")) {
                this.xferDclSegments();
            } else if (string3.equalsIgnoreCase("shoulderSet")) {
                this.xferDclShoulder();
            } else if (string3.equalsIgnoreCase("sigmoidSet")) {
                this.xferDclSigmoid();
            } else if (string3.equalsIgnoreCase("trapezoidSet")) {
                this.xferDclTrapezoid();
            } else if (string3.equalsIgnoreCase("triangleSet")) {
                this.xferDclTriangle();
            } else if (string3.equalsIgnoreCase("assert")) {
                this.xferRulAssert();
            } else if (string3.equalsIgnoreCase("antecedent")) {
                this.xferRulAnt();
            } else if (string3.equalsIgnoreCase("antecedentExpr")) {
                this.xferRulAntExpr();
            } else if (string3.equalsIgnoreCase("else")) {
                this.xferRulCond();
            } else if (string3.equalsIgnoreCase("consequent")) {
                this.xferRulCns();
            } else if (string3.equalsIgnoreCase("argList")) {
                this.xferArgList();
            } else if (string3.equalsIgnoreCase("arg")) {
                this.xferArg();
            } else if (string3.equalsIgnoreCase("expression")) {
                this.xferExpression();
            } else if (string3.equalsIgnoreCase("selector")) {
                this.xferWdSelector();
            } else if (string3.equalsIgnoreCase("constraint")) {
                this.xferRulConstraint();
            } else if (string3.equalsIgnoreCase("action")) {
                this.xferRulAction();
            } else if (string3.equalsIgnoreCase("action_")) {
                this.xferRulAction_();
            } else if (string3.equalsIgnoreCase("when")) {
                this.xferRulWhenDo();
            } else if (string3.equalsIgnoreCase("plan")) {
                this.xferRulPlan();
            } else if (string3.equalsIgnoreCase("precondition")) {
                this.xferRulPlanPrecondition();
            } else if (string3.equalsIgnoreCase("effect")) {
                this.xferRulPlanEffects();
            } else if (string3.equalsIgnoreCase("expansion")) {
                this.xferRulPlanExpansion();
            } else if (string3.equalsIgnoreCase("policy")) {
                this.xferRulPolicy();
            } else if (string3.equalsIgnoreCase("policyPrecondition")) {
                this.xferRulPolicyPrecondition();
            } else if (string3.equalsIgnoreCase("whileDo")) {
                this.xferRulWhileDo();
            } else if (string3.equalsIgnoreCase("doWhile")) {
                this.xferRulDoWhile();
            } else if (string3.equalsIgnoreCase("doUntil")) {
                this.xferRulDoUntil();
            } else if (string3.equalsIgnoreCase("for")) {
                this.xferRulForLoop();
            } else if (string3.equalsIgnoreCase("forInit")) {
                this.xferRulForInit();
            } else if (string3.equalsIgnoreCase("forTest")) {
                this.xferRulForTest();
            } else if (string3.equalsIgnoreCase("forIter")) {
                this.xferRulForIter();
            } else if (string3.equalsIgnoreCase("predicateRule")) {
                this.xferRulPred();
            } else if (string3.equalsIgnoreCase("predicateRuleFact")) {
                this.inTagPredicateRuleFact = false;
            } else if (string3.equalsIgnoreCase("predicateRuleHead")) {
                this.inTagPredicateRuleHead = false;
            } else if (string3.equalsIgnoreCase("predicateRuleBody")) {
                this.inTagPredicateRuleBody = false;
            } else if (string3.equalsIgnoreCase("predicateDef")) {
                this.xferPredDef();
            } else if (string3.equalsIgnoreCase("predicateListArg")) {
                this.xferPredDef();
            }
        }
        catch (AbleParException ableParException) {
            throw new SAXParseException(null, this.myLocator, (Exception)((Object)ableParException));
        }
    }

    public void error(SAXParseException sAXParseException) {
        Able.MessageLog.text(4L, (Object)this, this.getLocationString(sAXParseException), sAXParseException.getLocalizedMessage());
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(262144L, "AbleXmlParser: [Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        Able.MessageLog.text(4L, (Object)this, this.getLocationString(sAXParseException), sAXParseException.getLocalizedMessage());
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(262144L, "AbleXmlParser: [Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) {
        Able.MessageLog.text(2L, (Object)this, this.getLocationString(sAXParseException), sAXParseException.getLocalizedMessage());
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(524288L, "AbleXmlParser: [Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    private String formatSAXParseException(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Able.NlsMsg((String)"Inf_RsSAXParseExceptionTitle"));
        stringBuffer.append(Able.NlsMsg((String)"Inf_RsSAXParseExceptionLine", (Object[])new Object[]{Integer.toString(sAXParseException.getLineNumber())}));
        stringBuffer.append(Able.NlsMsg((String)"Inf_RsSAXParseExceptionColumn", (Object[])new Object[]{Integer.toString(sAXParseException.getColumnNumber())}));
        stringBuffer.append(Able.NlsMsg((String)"Inf_RsSAXParseExceptionPublicId", (Object[])new Object[]{sAXParseException.getPublicId()}));
        stringBuffer.append(Able.NlsMsg((String)"Inf_RsSAXParseExceptionSystemId", (Object[])new Object[]{sAXParseException.getSystemId()}));
        stringBuffer.append(Able.NlsMsg((String)"Inf_RsSAXParseExceptionMessage", (Object[])new Object[]{sAXParseException.getMessage()}));
        stringBuffer.append(Able.NlsMsg((String)"Inf_RsSAXParseExceptionException", (Object[])new Object[]{sAXParseException.getException()}));
        return stringBuffer.toString();
    }

    public void instantiateFrom(String string, AbleRuleSet ableRuleSet, AbleLogger ableLogger, boolean bl) throws AbleParException, ClassNotFoundException, IllegalAccessException, InstantiationException, IOException {
        this.myRuleSet = ableRuleSet;
        this.myTracer = ableLogger;
        this.myStopOnParException = bl;
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.parse(string);
        }
        catch (SAXParseException sAXParseException) {
            throw new AbleParException(this.formatSAXParseException(sAXParseException), sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new AbleParException(sAXException.getLocalizedMessage(), sAXException);
        }
    }

    public void instantiateFrom(Reader reader, AbleRuleSet ableRuleSet, AbleLogger ableLogger, boolean bl) throws AbleParException, ClassNotFoundException, IllegalAccessException, InstantiationException, IOException {
        this.myRuleSet = ableRuleSet;
        this.myTracer = ableLogger;
        this.myStopOnParException = bl;
        InputSource inputSource = new InputSource(reader);
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            throw new AbleParException(this.formatSAXParseException(sAXParseException), sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new AbleParException(sAXException.getLocalizedMessage(), sAXException);
        }
    }

    public void instantiateFrom(InputSource inputSource, AbleRuleSet ableRuleSet, AbleLogger ableLogger, boolean bl) throws AbleParException, ClassNotFoundException, IllegalAccessException, InstantiationException, IOException {
        this.myRuleSet = ableRuleSet;
        this.myTracer = ableLogger;
        this.myStopOnParException = bl;
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            throw new AbleParException(this.formatSAXParseException(sAXParseException), sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new AbleParException(sAXException.getLocalizedMessage(), sAXException);
        }
    }

    public void instantiateFrom(InputStream inputStream, AbleRuleSet ableRuleSet, AbleLogger ableLogger, boolean bl) throws AbleParException, ClassNotFoundException, IllegalAccessException, InstantiationException, IOException {
        this.myRuleSet = ableRuleSet;
        this.myTracer = ableLogger;
        this.myStopOnParException = bl;
        InputSource inputSource = new InputSource(inputStream);
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            throw new AbleParException(this.formatSAXParseException(sAXParseException), sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new AbleParException(sAXException.getLocalizedMessage(), sAXException);
        }
    }

    public AbleRuleBlock instantiateRuleBlockFrom(AbleRuleSet ableRuleSet, String string) throws AbleParException {
        this.myRuleSet = ableRuleSet;
        this.myRuleBlock = null;
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        try {
            this.instantiateFrom(inputSource, this.myRuleSet, this.myRuleSet.getLogger(), true);
        }
        catch (AbleParException ableParException) {
            throw ableParException;
        }
        catch (RemoteException remoteException) {
            throw new AbleParException(remoteException.getLocalizedMessage(), remoteException);
        }
        catch (InstantiationException instantiationException) {
            throw new AbleParException(instantiationException.getLocalizedMessage(), instantiationException);
        }
        catch (IOException iOException) {
            throw new AbleParException(iOException.getLocalizedMessage(), iOException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AbleParException(illegalAccessException.getLocalizedMessage(), illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AbleParException(classNotFoundException.getLocalizedMessage(), classNotFoundException);
        }
        this.myRuleBlock = this.myRuleSet.getRuleBlock(this.myRuleBlockName);
        return this.myRuleBlock;
    }

    public AbleRule instantiateRuleFrom(AbleRuleSet ableRuleSet, String string, String string2, boolean bl) throws AbleParException {
        this.myRuleSet = ableRuleSet;
        this.myRuleSet.setCurrentRuleBlock(string2);
        this.myRuleBlock = this.myRuleSet.getRuleBlock(string2);
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        try {
            this.myRuleReplacementMode = bl;
            this.instantiateFrom(inputSource, this.myRuleSet, this.myRuleSet.getLogger(), true);
            this.myRuleReplacementMode = false;
        }
        catch (AbleParException ableParException) {
            throw ableParException;
        }
        catch (RemoteException remoteException) {
            throw new AbleParException(remoteException.getLocalizedMessage(), remoteException);
        }
        catch (InstantiationException instantiationException) {
            throw new AbleParException(instantiationException.getLocalizedMessage(), instantiationException);
        }
        catch (IOException iOException) {
            throw new AbleParException(iOException.getLocalizedMessage(), iOException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AbleParException(illegalAccessException.getLocalizedMessage(), illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AbleParException(classNotFoundException.getLocalizedMessage(), classNotFoundException);
        }
        return this.myRule;
    }

    public AbleRd instantiateExpressionFrom(AbleRuleSet ableRuleSet, String string) throws AbleParException {
        this.myRuleSet = ableRuleSet;
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        try {
            this.instantiateFrom(inputSource, this.myRuleSet, this.myRuleSet.getLogger(), true);
        }
        catch (AbleParException ableParException) {
            throw ableParException;
        }
        catch (RemoteException remoteException) {
            throw new AbleParException(remoteException.getLocalizedMessage(), remoteException);
        }
        catch (InstantiationException instantiationException) {
            throw new AbleParException(instantiationException.getLocalizedMessage(), instantiationException);
        }
        catch (IOException iOException) {
            throw new AbleParException(iOException.getLocalizedMessage(), iOException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AbleParException(illegalAccessException.getLocalizedMessage(), illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AbleParException(classNotFoundException.getLocalizedMessage(), classNotFoundException);
        }
        return this.myExpression;
    }

    public void setTraceActive(boolean bl) {
        if (this.myTracer != null) {
            this.myTracer.setLogging(bl);
        }
    }

    public boolean isTraceActive() {
        if (this.myTracer == null) {
            return false;
        }
        return this.myTracer.isLogging();
    }

    private void logParseTrace(long l, String string) {
        this.myTracer.text(l, string);
    }

    public void setStopOnParException(boolean bl) {
        this.myStopOnParException = bl;
    }

    public boolean isStopOnParException() {
        return this.myStopOnParException;
    }

    private void hndlRuleSetName(Attributes attributes) throws RemoteException {
        if (attributes != null) {
            String string = attributes.getValue("name");
            if (string != null) {
                this.myRuleSetName = string.trim();
                this.myRuleSet.setName(this.myRuleSetName);
            }
            if ((string = attributes.getValue("comment")) != null) {
                this.myRuleSet.setComment(string.trim());
            }
            this.saveTemplateFlag(attributes.getValue("template"));
            this.myRuleSet.setTemplate(this.myTemplateFlag);
        }
        this.resetOptInfo();
    }

    private void hndlInferenceMethod(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("method")) != null) {
            string = string.trim();
            this.myRuleSet.setInferenceEngine(string);
        }
    }

    private void hndlLibrary(Attributes attributes) throws AbleParException {
        String string;
        this.myImportLibName = "";
        if (attributes != null && (string = attributes.getValue("class")) != null) {
            this.myImportLibName = string.trim();
            this.myRuleSet.declareUserDefinedFunctionLib(this.myImportLibName);
        }
    }

    private void hndlImport(Attributes attributes) throws AbleParException {
        this.myUserTypeName = "";
        this.myUserTypeClass = "";
        if (attributes != null) {
            int n;
            String string = attributes.getValue("class");
            if (string != null) {
                this.myUserTypeClass = string.trim();
            }
            this.myUserTypeName = (n = this.myUserTypeClass.lastIndexOf(46)) < 0 ? new String(this.myUserTypeClass) : this.myUserTypeClass.substring(n + 1);
            this.myRuleSet.declareUserDataType(this.myUserTypeName, this.myUserTypeClass);
        }
    }

    private void validateOkForPredicates() throws AbleParException {
    }

    private void xferDclPredicate(Attributes attributes) throws AbleParException {
        String string;
        String string2 = "";
        if (attributes != null && (string = attributes.getValue("name")) != null) {
            string2 = string.trim();
            this.myRuleSet.declarePredicate(string2);
        }
    }

    private void saveTemplateFlag(String string) {
        if (string != null) {
            String string2 = string.trim();
            if (string2.equalsIgnoreCase("true")) {
                this.myTemplateFlag = true;
            } else if (string2.equalsIgnoreCase("false")) {
                this.myTemplateFlag = false;
            }
        }
    }

    private void saveVariableName(String string) {
        if (string != null) {
            this.myVariableName = string.trim();
        }
    }

    private void saveVariableStaticFlag(String string) {
        if (string != null) {
            String string2 = string.trim();
            if (string2.equalsIgnoreCase("true")) {
                this.myVariableStaticFlag = true;
            } else if (string2.equalsIgnoreCase("false")) {
                this.myVariableStaticFlag = false;
            }
        }
    }

    private void saveDclList(Attributes attributes) throws AbleParException {
        this.resetVarInfo();
        if (attributes != null) {
            this.saveVariableName(attributes.getValue("varName"));
            this.saveVariableStaticFlag(attributes.getValue("static"));
        }
    }

    private void hndlDclBooElem(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            Boolean bl = new Boolean(string.trim());
            this.myVariableListValue.addElement(bl);
        }
    }

    private void hndlDclNumElem(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            Double d = Double.valueOf(string);
            this.myVariableListValue.addElement(d);
        }
    }

    private void hndlDclStrElem(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            this.myVariableListValue.addElement(string);
        }
    }

    private void hndlDclVarElem(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("varRef")) != null) {
            AbleVariable ableVariable = this.myRuleSet.getVariable(string = string.trim());
            if (ableVariable != null) {
                this.myVariableListValue.addElement(ableVariable);
            } else {
                throw new AbleParException(Able.NlsMsg((String)"Ex_RsXMLUndeclaredVariable", (Object[])new Object[]{string}));
            }
        }
    }

    private void hndlDclInnerClass(Attributes attributes) throws AbleParException {
        String string = null;
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        if (attributes != null) {
            this.saveComment(attributes.getValue("comment"));
            if (attributes != null) {
                String string3 = attributes.getValue("className");
                if (string3 != null) {
                    string = string3.trim();
                }
                if ((string3 = attributes.getValue("superClass")) != null) {
                    string2 = string3.trim();
                }
                if ((string3 = attributes.getValue("fieldInfo")) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string3);
                    while (stringTokenizer.hasMoreTokens()) {
                        vector2.add(stringTokenizer.nextToken());
                        vector.add(stringTokenizer.nextToken());
                    }
                }
            }
            this.myRuleSet.declareInnerClass(string, string2, this.myComment, vector, vector2);
        }
        if (this.myComment != null) {
            this.myComment = null;
        }
    }

    private void hndlDclVar(Attributes attributes) throws AbleParException {
        this.resetVarInfo();
        if (attributes != null) {
            this.saveComment(attributes.getValue("comment"));
            this.saveVariableType(attributes.getValue("dataType"));
            this.saveVariableName(attributes.getValue("varName"));
            this.saveVariableStaticFlag(attributes.getValue("static"));
            this.saveTemplateFlag(attributes.getValue("template"));
            this.saveVariableLength(attributes.getValue("length"));
            if (this.myVariableType.equals("Fuzzy")) {
                String string = attributes.getValue("from");
                if (string != null) {
                    string = string.trim();
                    this.myVariableContinuousLo = Double.valueOf(string);
                }
                if ((string = attributes.getValue("to")) != null) {
                    string = string.trim();
                    this.myVariableContinuousHi = Double.valueOf(string);
                }
                if (!(this.myVariableContinuousLo < this.myVariableContinuousHi)) {
                    throw new AbleParException(Able.NlsMsg((String)"Ex_RsXMLLow.gt.HighContinuous", (Object[])new Object[]{this.myVariableName, Double.toString(this.myVariableContinuousLo), Double.toString(this.myVariableContinuousHi)}));
                }
            }
            if (this.myVariableType.equals("Continuous")) {
                this.myDclVariable = new AbleContinuousVariable(this.myVariableName, this.myVariableStaticFlag, true, this.myVariableContinuousLo, this.myVariableContinuousHi);
                this.myRuleSet.addVariable(this.myDclVariable);
            } else if (this.myVariableType.equals("Fuzzy")) {
                this.myFuzzyVariable = new AbleFuzzyVariable(this.myVariableName, this.myVariableStaticFlag, true, this.myVariableContinuousLo, this.myVariableContinuousHi, this.myAlphaCut);
                this.myDclVariable = this.myFuzzyVariable;
                this.myRuleSet.addVariable((AbleVariable)this.myFuzzyVariable);
            } else if (this.myVariableLength != -1) {
                this.myDclVariable = new AbleArrayVariable(this.myVariableName, this.myVariableStaticFlag, true, this.myVariableType, this.myVariableLength);
                this.myRuleSet.addVariable(this.myDclVariable);
            } else {
                this.myDclVariable = this.myRuleSet.declareGlobalVariable(this.myVariableName, this.myVariableStaticFlag, this.myVariableType);
            }
        }
        if (this.myComment != null) {
            this.myDclVariable.setComment(this.myComment);
            this.myComment = null;
        }
        this.myDclVariable.setTemplate(this.myTemplateFlag);
    }

    private void xferDclVar() {
    }

    private void saveVarInitializer(Attributes attributes) throws AbleParException {
        this.myVarInitializerFlag = true;
        this.myVarInitializer = null;
        this.myVarInitializerArgs = new Vector();
    }

    private void xferVarInitializer() throws AbleParException {
        this.myVarInitializerFlag = false;
        if (this.myExpressionInProgress && this.myExpression != null) {
            this.myVarInitializer = this.myExpression;
            this.myExpression = null;
            this.myExpressionStack.clear();
            this.myExpressionInProgress = false;
        }
        if (this.myVarInitializer != null) {
            try {
                this.myDclVariable.setInitialValue(this.myVarInitializer);
                this.myVarInitializer = null;
            }
            catch (AbleDataException ableDataException) {
                throw new AbleParException(ableDataException.getLocalizedMessage());
            }
        }
    }

    private void xferArrayElement() throws AbleParException {
        if (this.myExpression != null) {
            this.myVarInitializerArgs.add(this.myExpression);
            this.myExpression = null;
            this.myExpressionStack.clear();
            this.myExpressionInProgress = false;
        }
        if (this.myVarInitializer != null) {
            this.myVarInitializerArgs.add(this.myVarInitializer);
            this.myVarInitializer = null;
        }
    }

    private void xferArrayLiteral() throws AbleParException {
        if (this.myVarInitializerFlag || this.myNewObjectFlag) {
            this.myVarInitializer = new AbleArrayLiteral((Object)this.myVarInitializerArgs.toArray());
        }
    }

    private void saveVariableLength(String string) {
        this.myVariableLength = -1;
        if (string != null) {
            this.myVariableLength = Integer.parseInt(string.trim());
        }
    }

    private void saveComment(String string) {
        if (string != null) {
            this.myComment = string.trim();
        }
    }

    private void saveVariableType(String string) {
        if (string != null) {
            this.myVariableType = string.trim();
        }
    }

    private void saveRulePreConditions(Attributes attributes) throws AbleParException {
        this.myVarInitializerFlag = true;
        this.myVarInitializer = null;
        this.myVarInitializerArgs = new Vector();
    }

    private void xferRulePreConditions() throws AbleParException {
        this.myVarInitializerFlag = false;
        if (this.myExpression != null) {
            this.myVarInitializer = this.myExpression;
            this.myExpressionStack.clear();
            this.myExpressionInProgress = false;
        }
        if (this.myVarInitializer != null) {
            this.myRulePreConditions = this.myVarInitializerArgs.toArray();
        }
    }

    private void saveDclBeta(Attributes attributes) throws AbleParException {
        this.resetSetInfo();
        if (attributes != null) {
            this.saveSetName(attributes.getValue("setName"));
            this.saveSetPtCenter(attributes.getValue("centerPoint"));
            this.saveSetPtFlex(attributes.getValue("width"));
            this.saveSetWeight(attributes.getValue("weight"));
        }
    }

    private void xferDclBeta() throws AbleParException {
        try {
            AbleFuzzySetBeta ableFuzzySetBeta = new AbleFuzzySetBeta(this.myFuzzyVariable, this.mySetName, this.myAlphaCut, this.mySetPtCenter, this.mySetPtFlex, this.mySetWeight);
            this.myFuzzyVariable.addSet(ableFuzzySetBeta);
            if (this.mySetComp) {
                this.xferSetComplement();
            }
        }
        catch (AbleDataException ableDataException) {
            throw new AbleParException(ableDataException.getLocalizedMessage(), ableDataException);
        }
    }

    private void saveDclComplement(Attributes attributes) throws AbleParException {
        if (attributes != null) {
            this.saveSetNameComplement(attributes.getValue("setName"));
        }
    }

    private void xferSetComplement() throws AbleParException {
        try {
            this.myFuzzyVariable.addSetComplement(this.mySetName, this.mySetNameComplement);
        }
        catch (AbleDataException ableDataException) {
            throw new AbleParException(ableDataException.getLocalizedMessage(), ableDataException);
        }
    }

    private void saveDclGaussian(Attributes attributes) throws AbleParException {
        this.resetSetInfo();
        if (attributes != null) {
            this.saveSetName(attributes.getValue("setName"));
            this.saveSetPtCenter(attributes.getValue("centerPoint"));
            this.saveSetWidth(attributes.getValue("widthFactor"));
        }
    }

    private void xferDclGaussian() throws AbleParException {
        try {
            AbleFuzzySetGaussian ableFuzzySetGaussian = new AbleFuzzySetGaussian(this.myFuzzyVariable, this.mySetName, this.myAlphaCut, this.mySetPtCenter, this.mySetWidth);
            this.myFuzzyVariable.addSet(ableFuzzySetGaussian);
            if (this.mySetComp) {
                this.xferSetComplement();
            }
        }
        catch (AbleDataException ableDataException) {
            throw new AbleParException(ableDataException.getLocalizedMessage(), ableDataException);
        }
    }

    private void saveDclLinear(Attributes attributes) throws AbleParException {
        this.resetSetInfo();
        if (attributes != null) {
            this.saveSetName(attributes.getValue("setName"));
            this.saveSetPtLeft(attributes.getValue("beginPoint"));
            this.saveSetPtRight(attributes.getValue("endPoint"));
            this.saveSetDirection(attributes.getValue("direction"));
        }
    }

    private void xferDclLinear() throws AbleParException {
        try {
            AbleFuzzySetLinear ableFuzzySetLinear = new AbleFuzzySetLinear(this.myFuzzyVariable, this.mySetName, this.myAlphaCut, this.mySetPtLeft, this.mySetPtRight, this.mySetDirection);
            this.myFuzzyVariable.addSet(ableFuzzySetLinear);
            if (this.mySetComp) {
                this.xferSetComplement();
            }
        }
        catch (AbleDataException ableDataException) {
            throw new AbleParException(ableDataException.getLocalizedMessage(), ableDataException);
        }
    }

    private void saveDclPi(Attributes attributes) throws AbleParException {
        this.resetSetInfo();
        if (attributes != null) {
            this.saveSetName(attributes.getValue("setName"));
            this.saveSetPtCenter(attributes.getValue("centerPoint"));
            this.saveSetWidth(attributes.getValue("width"));
        }
    }

    private void xferDclPi() throws AbleParException {
        try {
            AbleFuzzySetPi ableFuzzySetPi = new AbleFuzzySetPi(this.myFuzzyVariable, this.mySetName, this.myAlphaCut, this.mySetPtCenter, this.mySetWidth);
            this.myFuzzyVariable.addSet(ableFuzzySetPi);
            if (this.mySetComp) {
                this.xferSetComplement();
            }
        }
        catch (AbleDataException ableDataException) {
            throw new AbleParException(ableDataException.getLocalizedMessage(), ableDataException);
        }
    }

    private void saveDclSegments(Attributes attributes) throws AbleParException {
        this.resetSetInfo();
        this.resetVecInfo();
        if (attributes != null) {
            this.saveSetName(attributes.getValue("setName"));
        }
    }

    private void hndlDclSegmentsItem(Attributes attributes) throws AbleParException {
        if (attributes != null) {
            this.saveSetScalar(attributes.getValue("point"));
            this.saveSetTruthValue(attributes.getValue("truthValue"));
            ++this.myNumberOfSegments;
        }
    }

    private void xferDclSegments() throws AbleParException {
        try {
            AbleFuzzySetSegments ableFuzzySetSegments = new AbleFuzzySetSegments(this.myFuzzyVariable, this.mySetName, this.myAlphaCut, this.myNumberOfSegments, this.myScalarVector, this.myTruthVector);
            this.myFuzzyVariable.addSet(ableFuzzySetSegments);
            if (this.mySetComp) {
                this.xferSetComplement();
            }
        }
        catch (AbleDataException ableDataException) {
            throw new AbleParException(ableDataException.getLocalizedMessage(), ableDataException);
        }
    }

    private void saveDclShoulder(Attributes attributes) throws AbleParException {
        this.resetSetInfo();
        if (attributes != null) {
            this.saveSetName(attributes.getValue("setName"));
            this.saveSetPtLeft(attributes.getValue("beginPoint"));
            this.saveSetPtRight(attributes.getValue("endPoint"));
            this.saveSetDirection(attributes.getValue("direction"));
        }
    }

    private void xferDclShoulder() throws AbleParException {
        try {
            AbleFuzzySetShoulder ableFuzzySetShoulder = new AbleFuzzySetShoulder(this.myFuzzyVariable, this.mySetName, this.myAlphaCut, this.mySetPtLeft, this.mySetPtRight, this.mySetDirection);
            this.myFuzzyVariable.addSet(ableFuzzySetShoulder);
            if (this.mySetComp) {
                this.xferSetComplement();
            }
        }
        catch (AbleDataException ableDataException) {
            throw new AbleParException(ableDataException.getLocalizedMessage(), ableDataException);
        }
    }

    private void saveDclSigmoid(Attributes attributes) throws AbleParException {
        this.resetSetInfo();
        if (attributes != null) {
            this.saveSetName(attributes.getValue("setName"));
            this.saveSetPtLeft(attributes.getValue("leftPoint"));
            this.saveSetPtRight(attributes.getValue("rightPoint"));
            this.saveSetPtFlex(attributes.getValue("flexPoint"));
            this.saveSetDirection(attributes.getValue("direction"));
        }
    }

    private void xferDclSigmoid() throws AbleParException {
        try {
            AbleFuzzySetSigmoid ableFuzzySetSigmoid = new AbleFuzzySetSigmoid(this.myFuzzyVariable, this.mySetName, this.myAlphaCut, this.mySetPtLeft, this.mySetPtRight, this.mySetPtFlex, this.mySetDirection);
            this.myFuzzyVariable.addSet(ableFuzzySetSigmoid);
            if (this.mySetComp) {
                this.xferSetComplement();
            }
        }
        catch (AbleDataException ableDataException) {
            throw new AbleParException(ableDataException.getLocalizedMessage(), ableDataException);
        }
    }

    private void saveDclTrapezoid(Attributes attributes) throws AbleParException {
        this.resetSetInfo();
        if (attributes != null) {
            this.saveSetName(attributes.getValue("setName"));
            this.saveSetPtLeft(attributes.getValue("leftPoint"));
            this.saveSetPtLeftCore(attributes.getValue("leftCorePoint"));
            this.saveSetPtRightCore(attributes.getValue("rightCorePoint"));
            this.saveSetPtRight(attributes.getValue("rightPoint"));
        }
    }

    private void xferDclTrapezoid() throws AbleParException {
        try {
            AbleFuzzySetTrapezoid ableFuzzySetTrapezoid = new AbleFuzzySetTrapezoid(this.myFuzzyVariable, this.mySetName, this.myAlphaCut, this.mySetPtLeft, this.mySetPtLeftCore, this.mySetPtRightCore, this.mySetPtRight);
            this.myFuzzyVariable.addSet(ableFuzzySetTrapezoid);
            if (this.mySetComp) {
                this.xferSetComplement();
            }
        }
        catch (AbleDataException ableDataException) {
            throw new AbleParException(ableDataException.getLocalizedMessage(), ableDataException);
        }
    }

    private void saveDclTriangle(Attributes attributes) throws AbleParException {
        this.resetSetInfo();
        if (attributes != null) {
            this.saveSetName(attributes.getValue("setName"));
            this.saveSetPtLeft(attributes.getValue("leftPoint"));
            this.saveSetPtCenter(attributes.getValue("centerPoint"));
            this.saveSetPtRight(attributes.getValue("rightPoint"));
        }
    }

    private void xferDclTriangle() throws AbleParException {
        try {
            AbleFuzzySetTriangle ableFuzzySetTriangle = new AbleFuzzySetTriangle(this.myFuzzyVariable, this.mySetName, this.myAlphaCut, this.mySetPtLeft, this.mySetPtCenter, this.mySetPtRight);
            this.myFuzzyVariable.addSet(ableFuzzySetTriangle);
            if (this.mySetComp) {
                this.xferSetComplement();
            }
        }
        catch (AbleDataException ableDataException) {
            throw new AbleParException(ableDataException.getLocalizedMessage(), ableDataException);
        }
    }

    private void saveSetDirection(String string) {
        if (string != null) {
            if ((string = string.trim()).equalsIgnoreCase("up")) {
                this.mySetDirection = 1;
            } else if (string.equalsIgnoreCase("down")) {
                this.mySetDirection = 2;
            } else if (string.equalsIgnoreCase("left")) {
                this.mySetDirection = 3;
            } else if (string.equalsIgnoreCase("right")) {
                this.mySetDirection = 4;
            }
        }
    }

    private void saveSetName(String string) {
        if (string != null) {
            this.mySetName = string.trim();
        }
    }

    private void saveSetNameComplement(String string) {
        if (string != null) {
            this.mySetNameComplement = string.trim();
            this.mySetComp = true;
        }
    }

    private void saveSetPtCenter(String string) {
        if (string != null) {
            this.mySetPtCenter = Double.valueOf(string.trim());
        }
    }

    private void saveSetPtFlex(String string) {
        if (string != null) {
            this.mySetPtFlex = Double.valueOf(string.trim());
        }
    }

    private void saveSetPtLeft(String string) {
        if (string != null) {
            this.mySetPtLeft = Double.valueOf(string.trim());
        }
    }

    private void saveSetPtLeftCore(String string) {
        if (string != null) {
            this.mySetPtLeftCore = Double.valueOf(string.trim());
        }
    }

    private void saveSetPtRight(String string) {
        if (string != null) {
            this.mySetPtRight = Double.valueOf(string.trim());
        }
    }

    private void saveSetPtRightCore(String string) {
        if (string != null) {
            this.mySetPtRightCore = Double.valueOf(string.trim());
        }
    }

    private void saveSetScalar(String string) {
        if (string != null) {
            this.myScalarVector[this.myNumberOfSegments] = Double.valueOf(string.trim());
        }
    }

    private void saveSetTruthValue(String string) {
        if (string != null) {
            this.myTruthVector[this.myNumberOfSegments] = Double.valueOf(string.trim());
        }
    }

    private void saveSetWeight(String string) {
        if (string != null) {
            this.mySetWeight = Double.valueOf(string.trim());
        }
    }

    private void saveSetWidth(String string) {
        if (string != null) {
            this.mySetWidth = Double.valueOf(string.trim());
        }
    }

    private void hndlIOVariableNames(Attributes attributes, boolean bl) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("varRefs")) != null) {
            string = string.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                this.myVariableName = stringTokenizer.nextToken();
                if (bl) {
                    this.myRuleSet.addVariableToInputSequence(this.myVariableName);
                    continue;
                }
                this.myRuleSet.addVariableToOutputSequence(this.myVariableName);
            }
        }
    }

    private void hndlDclFunction(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("name")) != null) {
            this.myUserDefinedFunctionName = string.trim();
            this.myRuleSet.declareUserDefinedFunction(this.myUserDefinedFunctionName);
        }
    }

    private void hndlRuleBlock(Attributes attributes) throws AbleParException {
        this.resetRuleBlockInfo();
        if (attributes != null) {
            String string = attributes.getValue("block");
            if (string != null) {
                this.myRuleBlockName = string.trim();
            }
            if ((string = attributes.getValue("dataType")) != null) {
                this.myRuleBlockReturnType = string.trim();
                this.myRuleSet.addRuleBlock(this.myRuleBlockName, this.myRuleBlockReturnType);
            }
            if ((string = attributes.getValue("comment")) != null) {
                this.myRuleBlock = this.myRuleSet.getRuleBlock(this.myRuleBlockName);
                this.myRuleBlock.setComment(string.trim());
            }
        }
    }

    private void saveRule(Attributes attributes) throws AbleParException {
        this.resetRulInfo();
        if (attributes != null) {
            this.saveRuleLabel(attributes.getValue("label"));
            this.saveComment(attributes.getValue("comment"));
            this.saveTemplateFlag(attributes.getValue("template"));
        }
    }

    private void xferRule() throws AbleParException {
        if (this.myRulePreConditions != null) {
            try {
                this.myRule.setPreConditions(this.myRulePreConditions);
            }
            catch (AbleDataException ableDataException) {
                throw new AbleParException(ableDataException.getLocalizedMessage(), ableDataException);
            }
        }
        if (this.myComment != null) {
            this.myRule.setComment(this.myComment);
            this.myComment = null;
        }
    }

    private void saveHedge(Attributes attributes) throws RemoteException {
        String string;
        if (attributes != null && (string = attributes.getValue("type")) != null) {
            if ((string = string.trim()).equalsIgnoreCase("about")) {
                this.saveRuleHedge('A');
            } else if (string.equalsIgnoreCase("above")) {
                this.saveRuleHedge('O');
            } else if (string.equalsIgnoreCase("below")) {
                this.saveRuleHedge('B');
            } else if (string.equalsIgnoreCase("closeTo")) {
                this.saveRuleHedge('C');
            } else if (string.equalsIgnoreCase("extremely")) {
                this.saveRuleHedge('E');
            } else if (string.equalsIgnoreCase("generally")) {
                this.saveRuleHedge('G');
            } else if (string.equalsIgnoreCase("inVicinityOf")) {
                this.saveRuleHedge('I');
            } else if (string.equalsIgnoreCase("not")) {
                this.saveRuleHedge('N');
            } else if (string.equalsIgnoreCase("positively")) {
                this.saveRuleHedge('P');
            } else if (string.equalsIgnoreCase("slightly")) {
                this.saveRuleHedge('S');
            } else if (string.equalsIgnoreCase("somewhat")) {
                this.saveRuleHedge('M');
            } else if (string.equalsIgnoreCase("very")) {
                this.saveRuleHedge('V');
            }
        }
    }

    private void saveRuleHedge(char c) {
        this.myRuleHedges = this.myRuleHedges + c;
    }

    private void saveFuzzyValue(Attributes attributes) throws RemoteException {
        String string;
        if (attributes != null && (string = attributes.getValue("setRef")) != null) {
            string = string.trim();
            if (this.myExpressionInProgress) {
                this.myRuleToken = string;
                this.myRuleTokenType = 4;
                AbleRd ableRd = this.xferRdObject();
                this.myExpressionStack.push(ableRd);
            } else {
                this.saveRuleToken(4, string);
            }
        }
    }

    private void saveRuleLabel(String string) {
        if (string != null) {
            this.myRuleLabel = string.trim();
        }
    }

    private void saveRulePriority(Attributes attributes) {
        this.myArgListStack.push(new Vector());
    }

    private void xferRulePriority() {
        this.myArgListStack.pop();
        this.myRulePriority = this.myArg;
        this.lookingForArgs = false;
    }

    private void saveRuleVarLhs(String string) {
        if (string != null) {
            this.myRuleVarLhs = string.trim();
            this.myRuleTokenType = 2;
        }
    }

    private void xferRuleCall() throws AbleParException {
        this.restoreRuleCallParms();
    }

    private void saveRuleArgList(Vector vector) {
        Object[] objectArray = (Object[])this.myRuleCallStack.peek();
        objectArray[2] = vector;
    }

    private void saveRuleFieldRef(String string) {
        this.saveRuleToken(2, string);
    }

    private void saveRuleMethodRef(String string) {
        this.saveRuleToken(2, string);
    }

    private void saveRuleFieldName(String string) {
        this.saveRuleField(string);
    }

    private void saveRuleMethodName(String string) throws AbleParException {
        this.saveRuleMethod(string);
    }

    private void saveRuleField(String string) {
        this.myRuleTokenType = 7;
        this.myRuleFieldOrMethod = string;
    }

    private void saveRuleMethod(String string) throws AbleParException {
        this.myRuleTokenType = 8;
        this.myRuleFieldOrMethod = string;
        this.saveRuleCallToStack();
    }

    private void saveRuleCall(String string) throws AbleParException {
        this.myRuleTokenType = 5;
        this.myRuleToken = string;
        this.saveRuleCallToStack();
    }

    private void restoreRuleCallParms() throws AbleParException {
        Object[] objectArray = (Object[])this.myRuleCallStack.pop();
        this.myRuleToken = (String)objectArray[0];
        this.myRuleTokenType = (Integer)objectArray[1];
        this.myRuleParms = (Vector)objectArray[2];
        this.myRuleFieldOrMethod = (String)objectArray[3];
        this.myExpressionInProgress = (Boolean)objectArray[4];
    }

    private void saveRuleOperator(int n) {
        if (this.myExpressionInProgress) {
            Integer n2 = new Integer(n);
            this.myExpressionStack.push(n2);
        } else {
            this.myRuleOp = n;
        }
    }

    private void saveRuleToken(int n, String string) {
        this.myRuleToken = string;
        this.myRuleTokenType = n;
    }

    private void saveRuleCallToStack() throws AbleParException {
        Object[] objectArray = new Object[]{new String(this.myRuleToken), new Integer(this.myRuleTokenType), new Vector(), new String(this.myRuleFieldOrMethod), new Boolean(this.myExpressionInProgress)};
        this.myRuleCallStack.push(objectArray);
        this.myExpressionInProgress = false;
    }

    private void saveRuleArrayIndex(String string, int n, String string2) throws AbleParException {
        AbleRd ableRd = this.myRuleSet.createRdObject(n, string2, null, null, this.myRuleHedges, null, null);
        if (ableRd == null) {
            throw new AbleParException(Able.NlsMsg((String)"Ex_RsXMLNonIntegerArrayIndex", (Object[])new Object[]{string2}));
        }
        this.myRuleArrayIndexExpression = ableRd;
        this.myRuleToken = string;
        this.myRuleTokenType = 9;
    }

    private void saveRuleParm(int n, String string) {
        Object[] objectArray = (Object[])this.myRuleCallStack.peek();
        Vector vector = (Vector)objectArray[2];
        this.myRuleToken = string;
        Vector<Object> vector2 = new Vector<Object>();
        vector2.addElement(new Integer(n));
        vector2.addElement(string);
        vector.addElement(vector2);
    }

    private void saveRuleAntecedentWeight(Attributes attributes) {
        String string;
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            string = string.trim();
            this.myRuleAntWeight = Double.valueOf(string);
        }
    }

    private void saveRulAssert(Attributes attributes) throws AbleParException {
        this.resetRhsParmList();
    }

    private void xferRulAssert() throws AbleParException {
        AbleExpression ableExpression;
        this.myRuleCns = (AbleRd)this.myExpressionStack.pop();
        this.myExpressionInProgress = false;
        if (this.myRuleCns instanceof AbleExpression) {
            ableExpression = (AbleExpression)this.myRuleCns;
            AbleRd ableRd = ableExpression.getLhs();
            int n = ableExpression.getOp();
            AbleRd ableRd2 = ableExpression.getRhs();
            this.myAstClause = n == 1 ? this.myRuleSet.findOrCreateAssertion((AbleLhs)ableRd, n, ableRd2) : (n == 6 ? this.myRuleSet.findOrCreateAssertion((AbleLhs)ableRd, 2, ableRd2) : this.myRuleSet.findOrCreateAssertion(null, 10, ableRd2));
        } else {
            ableExpression = null;
            int n = 10;
            AbleRd ableRd = this.myRuleCns;
            this.myAstClause = this.myRuleSet.findOrCreateAssertion((AbleLhs)ableExpression, n, ableRd);
        }
        this.myRule = new AbleAssertionRule(this.myRuleLabel, this.myRulePriority, this.myAstClause);
        if (this.myRulePreConditions != null) {
            try {
                this.myRule.setPreConditions(this.myRulePreConditions);
            }
            catch (AbleDataException ableDataException) {
                throw new AbleParException(ableDataException.getLocalizedMessage(), ableDataException);
            }
        }
        if (this.myRuleReplacementMode) {
            this.myRuleSet.replaceRule(this.myRule);
        } else {
            this.myRuleSet.addRule(this.myRuleBlock, this.myRule);
        }
        if (this.myComment != null) {
            this.myRule.setComment(this.myComment);
            this.myComment = null;
        }
        this.myRule.setTemplate(this.myTemplateFlag);
        this.myRuleSet.clearLocalVarList();
    }

    private void saveRulAnt() throws AbleParException {
        this.resetAntInfo();
    }

    private void xferRulAnt() throws AbleParException {
        if (this.myExpression != null) {
            this.myAntExpression = (AbleExpression)this.myExpression;
            this.myAntExpressionList.add(this.myAntExpression);
            if (this.myRuleAntWeight != 1.0) {
                this.myAntExpression.setWeight(this.myRuleAntWeight);
                this.myRuleAntWeight = 1.0;
            }
            this.myAntClause = this.makeRulAnt((AbleRd)this.myAntExpression);
            this.myExpression = null;
            this.myExpressionStack.clear();
            this.myExpressionInProgress = false;
        }
        if (this.inTagPredicateRuleBody) {
            this.myPredClauses.addElement(this.myAntClause);
        } else if (this.myAntClause != null) {
            this.myAntClauses.addElement(this.myAntClause);
        }
    }

    private void saveRulThen() throws AbleParException {
        this.inThenSection = true;
        this.inElseSection = false;
        this.myThenList.removeAllElements();
    }

    private void saveRulElse(Attributes attributes) throws AbleParException {
        String string;
        this.inThenSection = false;
        this.inElseSection = true;
        this.myElseList.removeAllElements();
        this.myRuleIsConditional = false;
        if (attributes != null && (string = attributes.getValue("conditionalRule")) != null && string.equals("true")) {
            this.myRuleIsConditional = true;
        }
    }

    private void saveRulCns() throws AbleParException {
        this.resetRhsClauseInfo();
        this.resetRhsParmList();
    }

    private void xferRulCns() throws AbleParException {
        this.myCnsClause = this.makeRulCns();
        if (this.inThenSection) {
            this.myThenList.addElement(this.myCnsClause);
        } else if (this.inElseSection) {
            this.myElseList.addElement(this.myCnsClause);
        }
    }

    private void saveRulCond(Attributes attributes) throws AbleParException {
        this.resetThenInfo();
        this.resetElseInfo();
        this.resetRhsParmList();
    }

    private void xferRulCond() throws AbleParException {
        if (this.myRuleIsConditional) {
            if (this.myAntClauses.size() == 0) {
                this.myAntClauses = AbleRuleSet.convertToConjunctiveNormalForm(this.myAntExpression, this.myRuleSet);
            }
            this.myRule = new AbleConditionalRule(this.myRuleLabel, this.myRulePriority, this.myAntExpressionList, this.myAntClauses, this.myThenList);
            if (this.myRuleReplacementMode) {
                this.myRuleSet.replaceRule(this.myRule);
            } else {
                this.myRuleSet.addRule(this.myRuleBlock, this.myRule);
            }
        } else {
            this.myRule = new AbleIfThenElseRule(this.myRuleLabel, this.myRulePriority, this.myAntExpression, this.myThenList, this.myElseList);
            if (this.myRuleReplacementMode) {
                this.myRuleSet.replaceRule(this.myRule);
            } else {
                this.myRuleSet.addRule(this.myRuleBlock, this.myRule);
            }
        }
        if (this.myComment != null) {
            this.myRule.setComment(this.myComment);
            this.myComment = null;
        }
        this.myRule.setTemplate(this.myTemplateFlag);
    }

    private AbleRd xferRdObject() throws AbleParException {
        AbleRd ableRd = null;
        ableRd = this.myRuleSet.createRdObject(this.myRuleTokenType, this.myRuleToken, this.myRuleParms, this.myRuleFuzzyVar, this.myRuleHedges, this.myRuleFieldOrMethod, this.myRuleArrayIndexExpression);
        if (ableRd == null) {
            throw new AbleParException(Able.NlsMsg((String)"Ex_RsXMLRdObjectCreation", (Object[])new Object[]{this.myRuleToken}));
        }
        this.myRuleHedges = "";
        return ableRd;
    }

    private void saveExpression(Attributes attributes) {
        String string;
        this.myExpressionInProgress = true;
        if (attributes != null && (string = attributes.getValue("weight")) != null) {
            string = string.trim();
            this.myRuleAntWeight = Double.valueOf(string);
        }
    }

    private void xferExpression() {
        if (this.myExpressionStack.isEmpty()) {
            Able.MessageLog.message(4L, (Object)this, "xferExpression", "Ex_RsXferExpressionEmptyStack");
        } else if (this.myExpressionStack.size() != 1) {
            AbleRd ableRd = (AbleRd)this.myExpressionStack.pop();
            Integer n = (Integer)this.myExpressionStack.pop();
            AbleRd ableRd2 = (AbleRd)this.myExpressionStack.pop();
            this.myExpression = new AbleExpression(ableRd2, n.intValue(), ableRd);
            this.myExpressionStack.push(this.myExpression);
        }
    }

    private void saveNullExpressionArg() {
        this.myExpressionStack.push(null);
    }

    private void saveRulPlan(Attributes attributes) throws AbleParException {
        this.myPlanEffectsList = null;
        this.myPlanExpansionList = null;
        this.resetWdWhenInfo();
        this.resetWdDoInfo();
        this.resetRhsParmList();
    }

    private void saveRulPlanEffects() {
        this.resetWdDoInfo();
    }

    private void xferRulPlanEffects() {
        this.myPlanEffectsList = (Vector)this.myWdDoList.clone();
    }

    private void saveRulPlanExpansion() {
        if (this.myPlanExpansionList == null) {
            this.myPlanExpansionList = new Vector();
        }
        this.resetWdDoInfo();
    }

    private void xferRulPlanExpansion() {
        this.myPlanExpansionList.add((Vector)this.myWdDoList.clone());
    }

    private void saveRulPolicy(Attributes attributes) throws AbleParException {
        this.resetThenInfo();
        this.resetRhsParmList();
        this.inThenSection = true;
        this.inElseSection = false;
        this.myThenList.removeAllElements();
    }

    private void saveRulWhen(Attributes attributes) throws AbleParException {
        this.resetWdWhenInfo();
        this.resetRhsParmList();
    }

    private void saveRulSelector(Attributes attributes) throws AbleParException {
        this.resetWdSelectorInfo();
        if (attributes != null) {
            this.saveWdSelVarName(attributes.getValue("varName"));
            this.saveWdSelVarType(attributes.getValue("varType"));
            this.saveWdSelPosFlag(attributes.getValue("pos"));
        }
    }

    private void saveWdSelVarName(String string) {
        if (string != null) {
            this.myWdSelVarName = string;
        }
    }

    private void saveWdSelVarType(String string) throws AbleParException {
        if (string != null) {
            this.myWdSelVarType = string;
        }
        this.myWdSelVariable = this.myRuleSet.addLocalVariable(this.myWdSelVarName, this.myWdSelVarType);
    }

    private void saveWdSelPosFlag(String string) {
        if (string != null) {
            String string2 = string.trim();
            this.myWdSelPosFlag = !string2.equalsIgnoreCase("false");
        }
    }

    private void xferWdSelector() {
        AbleSelector ableSelector = new AbleSelector(this.myWdSelVariable, this.myAntExpression, this.myWdSelPosFlag);
        this.myWdWhenList.addElement(ableSelector);
    }

    private void saveRulConstraint() throws AbleParException {
        this.saveRulAnt();
    }

    private void xferRulConstraint() throws AbleParException {
        this.xferRulAnt();
    }

    private void saveRulAction() throws AbleParException {
        this.saveRulCns();
    }

    private void xferRulAction() throws AbleParException {
        AbleConsequentClause ableConsequentClause = this.makeRulCns();
        if (this.inTagPredicateRuleBody) {
            this.myPredClauses.addElement(ableConsequentClause);
        } else {
            this.myWdDoList.addElement(ableConsequentClause);
        }
    }

    private AbleAntecedentClause makeRulAnt(AbleRd ableRd) throws AbleParException {
        AbleAntecedentClause ableAntecedentClause;
        if (ableRd instanceof AbleExpression) {
            if (((AbleExpression)ableRd).getOp() == 16) {
                return null;
            }
            try {
                ableAntecedentClause = new AbleAntecedentClause((AbleExpression)ableRd);
            }
            catch (AbleDataException ableDataException) {
                throw new AbleParException(ableDataException.getLocalizedMessage(), ableDataException);
            }
            ableAntecedentClause = this.myRuleSet.findOrCreateAntecedent(ableAntecedentClause);
        } else {
            AbleRd ableRd2 = ableRd;
            ableAntecedentClause = this.myRuleSet.findOrCreateAntecedent(null, 10, ableRd2, this.myRuleAntWeight);
        }
        return ableAntecedentClause;
    }

    private AbleConsequentClause makeRulCns() throws AbleParException {
        AbleConsequentClause ableConsequentClause;
        this.myRuleCns = (AbleRd)this.myExpressionStack.pop();
        this.myExpressionInProgress = false;
        if (this.myRuleCns instanceof AbleExpression) {
            AbleExpression ableExpression = (AbleExpression)this.myRuleCns;
            AbleRd ableRd = ableExpression.getLhs();
            int n = ableExpression.getOp();
            AbleRd ableRd2 = ableExpression.getRhs();
            ableConsequentClause = n == 1 ? this.myRuleSet.findOrCreateConsequent((AbleLhs)ableRd, n, ableRd2) : (n == 6 ? this.myRuleSet.findOrCreateConsequent((AbleLhs)ableRd, 2, ableRd2) : (n == 2 ? this.myRuleSet.findOrCreateConsequent((AbleLhs)ableRd, 2, ableRd2) : this.myRuleSet.findOrCreateConsequent(null, 10, ableRd2)));
        } else {
            AbleLhs ableLhs = null;
            int n = 10;
            AbleRd ableRd = this.myRuleCns;
            ableConsequentClause = this.myRuleSet.findOrCreateConsequent(ableLhs, n, ableRd);
        }
        return ableConsequentClause;
    }

    private void saveRulAntExpr() throws AbleParException {
        this.resetAntInfo();
    }

    private void xferRulAntExpr() {
        if (this.myExpressionStack.size() == 1) {
            this.myAntExpression = (AbleExpression)this.myExpressionStack.pop();
        }
        this.myExpressionInProgress = false;
    }

    private void saveRulDo(Attributes attributes) {
        this.resetWdDoInfo();
    }

    private void xferRulWhenDo() throws AbleParException {
        this.myRule = new AblePatternMatchRule(this.myRuleLabel, this.myRulePriority, this.myWdWhenList, this.myWdDoList, this.myRuleSet, this.myRuleBlock);
        if (this.myRuleReplacementMode) {
            this.myRuleSet.replaceRule(this.myRule);
        } else {
            this.myRuleSet.addRule(this.myRuleBlock, this.myRule);
        }
        if (this.myComment != null) {
            this.myRule.setComment(this.myComment);
            this.myComment = null;
        }
        this.myRule.setTemplate(this.myTemplateFlag);
        this.myRuleSet.clearLocalVarList();
    }

    private void saveRulParameters() throws AbleParException {
        this.myFormalParameterList = new Vector();
    }

    private void saveFormalParameter(Attributes attributes) throws AbleParException {
        if (attributes != null) {
            String string = attributes.getValue("type");
            String string2 = attributes.getValue("name");
            String string3 = attributes.getValue("isArray");
            AbleVariable ableVariable = null;
            ableVariable = string3.equals("true") ? this.myRuleSet.addLocalVariable(string2, string + "[]") : this.myRuleSet.addLocalVariable(string2, string);
            this.myFormalParameterList.add(ableVariable);
        }
    }

    private void xferRulPlanPrecondition() throws AbleParException {
        this.myPlanPrecondition = (AbleExpression)this.myExpression;
    }

    private void xferRulPlan() throws AbleParException {
        this.myRule = this.myPlanExpansionList == null ? new AblePlanningRule(this.myRuleLabel, this.myRulePriority, this.myFormalParameterList, this.myPlanPrecondition, this.myPlanEffectsList, this.myRuleSet) : new AbleHierarchicalPlanningRule(this.myRuleLabel, this.myRulePriority, this.myFormalParameterList, this.myPlanPrecondition, this.myPlanEffectsList, this.myPlanExpansionList, this.myRuleSet);
        if (this.myRuleReplacementMode) {
            this.myRuleSet.replaceRule(this.myRule);
        } else {
            this.myRuleSet.addRule(this.myRuleBlock, this.myRule);
        }
        if (this.myComment != null) {
            this.myRule.setComment(this.myComment);
            this.myComment = null;
        }
        this.myRule.setTemplate(this.myTemplateFlag);
        this.myRuleSet.clearLocalVarList();
    }

    private void xferRulPolicyPrecondition() throws AbleParException {
        this.myPlanPrecondition = (AbleExpression)this.myExpression;
    }

    private void xferRulPolicy() throws AbleParException {
        this.myRule = new AblePolicyRule(this.myRuleLabel, this.myRulePriority, this.myPlanPrecondition, this.myThenList);
        if (this.myRuleReplacementMode) {
            this.myRuleSet.replaceRule(this.myRule);
        } else {
            this.myRuleSet.addRule(this.myRuleBlock, this.myRule);
        }
        if (this.myComment != null) {
            this.myRule.setComment(this.myComment);
            this.myComment = null;
        }
        this.myRule.setTemplate(this.myTemplateFlag);
        this.myRuleSet.clearLocalVarList();
    }

    private void saveRulPred(Attributes attributes) throws AbleParException {
        this.resetPredRule();
        this.resetRhsParmList();
    }

    private void xferRulPred() throws AbleParException {
        AblePredicateRule ablePredicateRule = null;
        ablePredicateRule = this.myPredClauses.isEmpty() ? new AblePredicateFact(this.myRuleLabel, this.myRulePriority, this.myPredLhs, this.myRuleSet) : new AblePredicateRule(this.myRuleLabel, this.myRulePriority, this.myPredClauses, this.myPredLhs, this.myRuleSet);
        this.myRule = ablePredicateRule;
        if (this.myRuleReplacementMode) {
            this.myRuleSet.replaceRule(this.myRule);
        } else {
            this.myRuleSet.addRule(this.myRuleBlock, this.myRule);
        }
        if (this.myComment != null) {
            ablePredicateRule.setComment(this.myComment);
            this.myComment = null;
        }
        this.myRule.setTemplate(this.myTemplateFlag);
        this.myRuleSet.clearLocalVarList();
    }

    private void savePredDef(Attributes attributes) throws AbleParException {
        this.resetPredInfo();
        if (attributes != null) {
            this.savePredName(attributes.getValue("name"));
            this.savePredPosFlag(attributes.getValue("pos"));
            this.savePredToStack();
        }
    }

    private void xferPredDef() throws AbleParException {
        Object[] objectArray = (Object[])this.myPredStack.pop();
        String string = (String)objectArray[1];
        Vector vector = (Vector)objectArray[2];
        Boolean bl = (Boolean)objectArray[3];
        if (string.equals(".") && vector.size() != 0 && !bl.booleanValue()) {
            vector.addElement(AblePredicate.EmptyListPredicate);
        }
        AblePredicate ablePredicate = new AblePredicate(string, vector);
        if (this.myPredStack.isEmpty()) {
            if (this.inTagPredicateRuleBody) {
                this.savePredClausePred(ablePredicate);
            } else if (this.inTagPredicateRuleHead) {
                this.savePredLhs(ablePredicate);
            } else if (this.inTagPredicateRuleFact) {
                this.savePredLhs(ablePredicate);
            } else if (this.myExpressionInProgress) {
                this.myExpressionStack.push(new AbleGenericLiteral((Object)ablePredicate));
            } else if (this.lookingForArgs) {
                this.myArg = new AbleGenericLiteral((Object)ablePredicate);
            }
        } else {
            this.savePredArgPredicate(ablePredicate);
        }
    }

    private void savePredLhs(AblePredicate ablePredicate) {
        this.myPredLhs = ablePredicate;
    }

    private void savePredClausePred(AblePredicate ablePredicate) {
        this.myPredClauses.addElement(ablePredicate);
    }

    private void savePredToStack() throws AbleParException {
        if (!this.myRuleSet.isDeclaredPredicateName(this.myPredName)) {
            throw new AbleParException(Able.NlsMsg((String)"Ex_RsXMLPredicateNotDeclared", (Object[])new Object[]{this.myPredName}));
        }
        Object[] objectArray = new Object[]{new Boolean(this.myPredPosFlag), new String(this.myPredName), new Vector(), Boolean.FALSE};
        this.myPredStack.push(objectArray);
    }

    private void savePredBarFlag(boolean bl) {
        Object[] objectArray = (Object[])this.myPredStack.peek();
        Boolean bl2 = (Boolean)objectArray[0];
        String string = (String)objectArray[1];
        String string2 = bl2 != false ? "" : "~";
        objectArray[3] = new Boolean(bl);
    }

    private void savePredName(String string) {
        if (string != null) {
            this.myPredName = string;
        }
    }

    private void savePredPosFlag(String string) {
        if (string != null) {
            String string2 = string.trim();
            this.myPredPosFlag = !string2.equalsIgnoreCase("false");
        }
    }

    private void savePredArg(Object object) {
        Object[] objectArray = (Object[])this.myPredStack.peek();
        Boolean bl = (Boolean)objectArray[0];
        String string = (String)objectArray[1];
        Vector vector = (Vector)objectArray[2];
        String string2 = bl != false ? "" : "~";
        vector.addElement(object);
    }

    private void savePredArgBoolean(Attributes attributes) throws AbleParException {
        String string;
        boolean bl = false;
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            if ((string = string.trim()).equalsIgnoreCase("true")) {
                bl = true;
            } else if (string.equalsIgnoreCase("false")) {
                bl = false;
            }
            this.savePredArg(bl ? AbleData.True : AbleData.False);
        }
    }

    private void savePredArgList() throws AbleParException {
        this.resetPredInfo();
        this.savePredName(".");
        this.savePredToStack();
    }

    private void savePredArgNumber(Attributes attributes) throws AbleParException {
        String string = "*BUG*";
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            string = string.trim();
            this.savePredArg(this.myRuleSet.findOrCreateDoubleLit(string));
        }
    }

    private void savePredArgString(Attributes attributes) {
        String string = "*BUG*";
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            this.savePredArg(this.myRuleSet.findOrCreateStringLiteral(string));
        }
    }

    private void savePredArgCharacter(Attributes attributes) throws AbleParException {
        String string = "*BUG*";
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            this.savePredArg(this.myRuleSet.createLiteral(15, string));
        }
    }

    private void savePredArgSymbol(Attributes attributes) throws AbleParException {
        String string = "*BUG*";
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            if (Character.isLowerCase((string = string.trim()).charAt(0))) {
                this.savePredArg(this.myRuleSet.findOrCreatePredicateSymbol(string));
            } else {
                throw new AbleParException(Able.NlsMsg((String)"Ex_RsXMLInvalidStartPredicateString", (Object[])new Object[]{string}));
            }
        }
    }

    private void savePredArgVariable(Attributes attributes) throws AbleParException {
        String string = "*BUG*";
        if (attributes != null && (string = attributes.getValue("varRef")) != null) {
            if (Character.isUpperCase((string = string.trim()).charAt(0))) {
                this.savePredArg(this.myRuleSet.findOrCreateLocalPredicateVariable(string));
            } else {
                throw new AbleParException(Able.NlsMsg((String)"Ex_RsXMLInvalidStartSymbolicString", (Object[])new Object[]{string}));
            }
        }
    }

    private void savePredArgDontCare() {
        this.savePredArg(new AbleGenericVariable("_", false, false));
    }

    private void savePredArgPredicate(AblePredicate ablePredicate) {
        this.savePredArg(ablePredicate);
    }

    private void saveRulDo_(Attributes attributes) {
    }

    private void saveRulAction_() throws AbleParException {
        this.saveRulCns();
    }

    private void xferRulAction_() throws AbleParException {
        this.myDoList.addElement(this.makeRulCns());
    }

    private void saveRulWhileDo(Attributes attributes) throws AbleParException {
        this.resetRhsParmList();
    }

    private void xferRulWhileDo() throws AbleParException {
        this.myRule = new AbleWhileDoRule(this.myRuleLabel, this.myRulePriority, this.myAntExpression, this.myDoList);
        if (this.myRuleReplacementMode) {
            this.myRuleSet.replaceRule(this.myRule);
        } else {
            this.myRuleSet.addRule(this.myRuleBlock, this.myRule);
        }
        if (this.myComment != null) {
            this.myRule.setComment(this.myComment);
            this.myComment = null;
        }
        this.myRule.setTemplate(this.myTemplateFlag);
        this.myRuleSet.clearLocalVarList();
    }

    private void saveRulDoWhile(Attributes attributes) throws AbleParException {
        this.resetRhsParmList();
    }

    private void xferRulDoWhile() throws AbleParException {
        this.myRule = new AbleDoWhileRule(this.myRuleLabel, this.myRulePriority, this.myAntExpression, this.myDoList);
        if (this.myRuleReplacementMode) {
            this.myRuleSet.replaceRule(this.myRule);
        } else {
            this.myRuleSet.addRule(this.myRuleBlock, this.myRule);
        }
        if (this.myComment != null) {
            this.myRule.setComment(this.myComment);
            this.myComment = null;
        }
        this.myRule.setTemplate(this.myTemplateFlag);
        this.myRuleSet.clearLocalVarList();
    }

    private void saveRulDoUntil(Attributes attributes) throws AbleParException {
        this.resetRhsParmList();
    }

    private void xferRulDoUntil() throws AbleParException {
        this.myRule = new AbleDoUntilRule(this.myRuleLabel, this.myRulePriority, this.myAntExpression, this.myDoList);
        if (this.myRuleReplacementMode) {
            this.myRuleSet.replaceRule(this.myRule);
        } else {
            this.myRuleSet.addRule(this.myRuleBlock, this.myRule);
        }
        if (this.myComment != null) {
            this.myRule.setComment(this.myComment);
            this.myComment = null;
        }
        this.myRule.setTemplate(this.myTemplateFlag);
        this.myRuleSet.clearLocalVarList();
    }

    private void saveRulForLoop(Attributes attributes) throws AbleParException {
        this.resetRhsParmList();
        this.myForInitExprList = new Vector();
        this.myForTestExpr = null;
        this.myForIterExprList = new Vector();
    }

    private void saveRulForInit() throws AbleParException {
    }

    private void xferRulForInit() throws AbleParException {
        while (this.myExpressionStack.size() > 0) {
            this.myForInitExprList.add(this.myExpressionStack.pop());
        }
        this.myExpressionInProgress = false;
    }

    private void saveRulForTest() throws AbleParException {
    }

    private void xferRulForTest() throws AbleParException {
        if (this.myExpressionStack.size() == 1) {
            this.myForTestExpr = (AbleExpression)this.myExpressionStack.pop();
        }
        this.myExpressionInProgress = false;
    }

    private void saveRulForIter() throws AbleParException {
    }

    private void xferRulForIter() throws AbleParException {
        while (this.myExpressionStack.size() > 0) {
            this.myForIterExprList.add(this.myExpressionStack.pop());
        }
        this.myExpressionInProgress = false;
    }

    private void xferRulForLoop() throws AbleParException {
        this.myRule = new AbleForLoopRule(this.myRuleLabel, this.myRulePriority, this.myForInitExprList, this.myForTestExpr, this.myForIterExprList, this.myDoList);
        if (this.myRuleReplacementMode) {
            this.myRuleSet.replaceRule(this.myRule);
        } else {
            this.myRuleSet.addRule(this.myRuleBlock, this.myRule);
        }
        if (this.myComment != null) {
            this.myRule.setComment(this.myComment);
            this.myComment = null;
        }
        this.myRule.setTemplate(this.myTemplateFlag);
        this.myRuleSet.clearLocalVarList();
    }

    private void saveLhsVarRef(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("varRef")) != null) {
            string = string.trim();
            if (this.myExpressionInProgress) {
                this.myRuleToken = string;
                this.myRuleTokenType = 2;
                this.myRuleFuzzyVar = this.xferRdObject();
                this.myExpressionStack.push(this.myRuleFuzzyVar);
            }
            this.saveRuleVarLhs(string);
        }
    }

    private void saveBooleanLit(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            string = string.trim();
            if (this.myExpressionInProgress) {
                this.myRuleToken = string;
                this.myRuleTokenType = 1;
                AbleRd ableRd = this.xferRdObject();
                this.myExpressionStack.push(ableRd);
            } else if (this.lookingForArgs) {
                this.myRuleToken = string;
                this.myRuleTokenType = 1;
                this.myArg = this.xferRdObject();
            } else if (this.myVarInitializerFlag || this.myNewObjectFlag) {
                this.myRuleToken = string;
                this.myRuleTokenType = 1;
                this.myVarInitializer = this.xferRdObject();
            } else if (string.equalsIgnoreCase("true")) {
                this.saveRuleToken(1, "True");
            } else if (string.equalsIgnoreCase("false")) {
                this.saveRuleToken(1, "False");
            }
        }
    }

    private void saveByteLit(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            string = string.trim();
            if (this.myExpressionInProgress) {
                this.myRuleToken = string;
                this.myRuleTokenType = 10;
                AbleRd ableRd = this.xferRdObject();
                this.myExpressionStack.push(ableRd);
            } else if (this.lookingForArgs) {
                this.myRuleToken = string;
                this.myRuleTokenType = 10;
                this.myArg = this.xferRdObject();
            } else if (this.myVarInitializerFlag || this.myNewObjectFlag) {
                this.myRuleToken = string;
                this.myRuleTokenType = 10;
                this.myVarInitializer = this.xferRdObject();
            } else {
                this.saveRuleToken(10, string);
            }
        }
    }

    private void saveCharacterLit(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            string = string.trim();
            int n = Integer.parseInt(string);
            char c = (char)n;
            char[] cArray = new char[]{c};
            string = new String(cArray);
            if (this.myExpressionInProgress) {
                this.myRuleToken = string;
                this.myRuleTokenType = 15;
                AbleRd ableRd = this.xferRdObject();
                this.myExpressionStack.push(ableRd);
            } else if (this.lookingForArgs) {
                this.myRuleToken = string;
                this.myRuleTokenType = 15;
                this.myArg = this.xferRdObject();
            } else if (this.myVarInitializerFlag || this.myNewObjectFlag) {
                this.myRuleToken = string;
                this.myRuleTokenType = 15;
                this.myVarInitializer = this.xferRdObject();
            } else {
                this.saveRuleToken(15, string);
            }
        }
    }

    private void saveNumericLit(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            string = string.trim();
            if (this.lookingForArgs) {
                this.myRuleToken = string;
                this.myRuleTokenType = 3;
                this.myArg = this.xferRdObject();
            } else if (this.myExpressionInProgress) {
                this.myRuleToken = string;
                this.myRuleTokenType = 3;
                AbleRd ableRd = this.xferRdObject();
                this.myExpressionStack.push(ableRd);
            } else {
                this.saveRuleToken(3, string);
            }
        }
    }

    private void saveDoubleLit(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            string = string.trim();
            if (this.myExpressionInProgress) {
                this.myRuleToken = string;
                this.myRuleTokenType = 3;
                AbleRd ableRd = this.xferRdObject();
                this.myExpressionStack.push(ableRd);
            } else if (this.lookingForArgs) {
                this.myRuleToken = string;
                this.myRuleTokenType = 3;
                this.myArg = this.xferRdObject();
            } else if (this.myVarInitializerFlag || this.myNewObjectFlag) {
                this.myRuleToken = string;
                this.myRuleTokenType = 3;
                this.myVarInitializer = this.xferRdObject();
            } else {
                this.saveRuleToken(3, string);
            }
        }
    }

    private void saveFloatLit(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            string = string.trim();
            if (this.myExpressionInProgress) {
                this.myRuleToken = string;
                this.myRuleTokenType = 12;
                AbleRd ableRd = this.xferRdObject();
                this.myExpressionStack.push(ableRd);
            } else if (this.lookingForArgs) {
                this.myRuleToken = string;
                this.myRuleTokenType = 12;
                this.myArg = this.xferRdObject();
            } else if (this.myVarInitializerFlag || this.myNewObjectFlag) {
                this.myRuleToken = string;
                this.myRuleTokenType = 12;
                this.myVarInitializer = this.xferRdObject();
            } else {
                this.saveRuleToken(12, string);
            }
        }
    }

    private void saveIntegerLit(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            string = string.trim();
            if (this.myExpressionInProgress) {
                this.myRuleToken = string;
                this.myRuleTokenType = 10;
                AbleRd ableRd = this.xferRdObject();
                this.myExpressionStack.push(ableRd);
            } else if (this.lookingForArgs) {
                this.myRuleToken = string;
                this.myRuleTokenType = 10;
                this.myArg = this.xferRdObject();
            } else if (this.myVarInitializerFlag || this.myNewObjectFlag) {
                this.myRuleToken = string;
                this.myRuleTokenType = 10;
                this.myVarInitializer = this.xferRdObject();
            } else {
                this.saveRuleToken(10, string);
            }
        }
    }

    private void saveLongLit(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            string = string.trim();
            if (this.myExpressionInProgress) {
                this.myRuleToken = string;
                this.myRuleTokenType = 13;
                AbleRd ableRd = this.xferRdObject();
                this.myExpressionStack.push(ableRd);
            } else if (this.lookingForArgs) {
                this.myRuleToken = string;
                this.myRuleTokenType = 13;
                this.myArg = this.xferRdObject();
            } else if (this.myVarInitializerFlag || this.myNewObjectFlag) {
                this.myRuleToken = string;
                this.myRuleTokenType = 13;
                this.myVarInitializer = this.xferRdObject();
            } else {
                this.saveRuleToken(13, string);
            }
        }
    }

    private void saveShortLit(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            string = string.trim();
            if (this.myExpressionInProgress) {
                this.myRuleToken = string;
                this.myRuleTokenType = 10;
                AbleRd ableRd = this.xferRdObject();
                this.myExpressionStack.push(ableRd);
            } else if (this.lookingForArgs) {
                this.myRuleToken = string;
                this.myRuleTokenType = 10;
                this.myArg = this.xferRdObject();
            } else if (this.myVarInitializerFlag || this.myNewObjectFlag) {
                this.myRuleToken = string;
                this.myRuleTokenType = 10;
                this.myVarInitializer = this.xferRdObject();
            } else {
                this.saveRuleToken(10, string);
            }
        }
    }

    private void saveTimeStampLit(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            string = string.trim();
            if (this.myExpressionInProgress) {
                this.myRuleToken = string;
                this.myRuleTokenType = 16;
                AbleRd ableRd = this.xferRdObject();
                this.myExpressionStack.push(ableRd);
            } else if (this.lookingForArgs) {
                this.saveRuleParm(16, string);
            } else if (this.myVarInitializerFlag || this.myNewObjectFlag) {
                this.myRuleToken = string;
                this.myRuleTokenType = 16;
                this.myVarInitializer = this.xferRdObject();
            } else {
                this.saveRuleToken(16, string);
            }
        }
    }

    private void saveStringLit(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("value")) != null) {
            if (this.myExpressionInProgress) {
                this.myRuleToken = string;
                this.myRuleTokenType = 6;
                AbleRd ableRd = this.xferRdObject();
                this.myExpressionStack.push(ableRd);
            } else if (this.lookingForArgs) {
                this.myRuleToken = string;
                this.myRuleTokenType = 6;
                this.myArg = this.xferRdObject();
            } else if (this.myVarInitializerFlag || this.myNewObjectFlag) {
                this.myRuleToken = string;
                this.myRuleTokenType = 6;
                this.myVarInitializer = this.xferRdObject();
            } else {
                this.saveRuleToken(6, string);
            }
        }
    }

    private void saveNewObjectLit(Attributes attributes) throws AbleParException {
        if (attributes != null) {
            String string = attributes.getValue("dataType");
            if (string != null) {
                this.myRuleToken = string = string.trim();
            }
            if ((string = attributes.getValue("className")) != null) {
                this.myRuleFieldOrMethod = this.myVariableClassName = (string = string.trim());
            }
            this.myRuleTokenType = 14;
            this.saveRuleCallToStack();
            this.myNewObjectFlag = true;
        }
    }

    private void xferNewObjectLit() throws AbleParException {
        this.xferRuleCall();
        if (this.myVariableClassName.equals("com.ibm.able.data.AbleArrayLiteral")) {
            if (this.myArgList == null || this.myArgList.size() == 0) {
                if (this.myVarInitializer != null) {
                    this.myRuleArrayIndexExpression = this.myVarInitializer;
                    this.myVarInitializer = null;
                } else if (this.myExpression != null) {
                    this.myRuleArrayIndexExpression = this.myExpression;
                    this.myExpressionStack.pop();
                    if (!this.myExpressionStack.isEmpty()) {
                        this.myExpression = (AbleRd)this.myExpressionStack.peek();
                    } else {
                        this.myExpression = null;
                        this.myExpressionInProgress = false;
                    }
                }
            } else {
                this.myRuleParms = this.myArgList;
            }
        }
        if (this.myRuleCallStack.isEmpty()) {
            this.lookingForArgs = false;
        }
        if (this.myExpressionInProgress) {
            AbleRd ableRd = this.xferRdObject();
            this.myExpressionStack.push(ableRd);
        } else if (this.lookingForArgs) {
            this.myArg = this.xferRdObject();
        } else if (this.myVarInitializerFlag || this.myNewObjectFlag) {
            this.myVarInitializer = this.xferRdObject();
        }
        this.myNewObjectFlag = false;
    }

    private void saveCompoundLit(Attributes attributes) throws AbleParException {
        if (attributes != null) {
            String string = attributes.getValue("varRef");
            if (string != null) {
                this.myRuleToken = string = string.trim();
            }
            this.myRuleTokenType = 2;
            this.myRuleCompoundLiterals.clear();
            this.myCompoundLitFlag = true;
        }
    }

    private void xferCompoundLit() throws AbleParException {
        this.myRuleParms = this.myRuleCompoundLiterals;
        this.myRuleTokenType = 17;
        if (this.myExpressionInProgress) {
            AbleRd ableRd = this.xferRdObject();
            this.myExpressionStack.push(ableRd);
        } else if (this.lookingForArgs) {
            this.myArg = this.xferRdObject();
        } else if (this.myVarInitializerFlag || this.myNewObjectFlag) {
            this.myVarInitializer = this.xferRdObject();
        }
    }

    private void xferCompoundLitArg() throws AbleParException {
        AbleRd ableRd = (AbleRd)this.myExpressionStack.pop();
        this.myRuleCompoundLiterals.add(ableRd);
        Object e = this.myRuleCompoundLiterals.lastElement();
        int n = this.myRuleCompoundLiterals.size();
        this.myRuleToken = "X_" + n;
        String string = null;
        if (e instanceof AbleTypedVariableField) {
            string = ((AbleTypedVariableField)e).getDataTypeClassName();
            string = string.substring(string.lastIndexOf(".") + 1);
        } else if (e instanceof AbleTypedVariableMethodLiteral) {
            string = ((AbleTypedVariableMethodLiteral)e).getDataTypeClassName();
            string = string.substring(string.lastIndexOf(".") + 1);
        }
        this.myRuleSet.addLocalVariable(this.myRuleToken, string);
    }

    private void saveFunctionValue(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("functionRef")) != null) {
            string = string.trim();
            this.saveRuleCall(string);
        }
    }

    private void xferFunctionValue() throws AbleParException {
        this.xferRuleCall();
        if (this.myRuleCallStack.isEmpty()) {
            this.lookingForArgs = false;
        }
        if (this.myExpressionInProgress) {
            AbleRd ableRd = this.xferRdObject();
            this.myExpressionStack.push(ableRd);
        } else if (this.lookingForArgs) {
            this.myArg = this.xferRdObject();
        } else if (this.myVarInitializerFlag || this.myNewObjectFlag) {
            this.myVarInitializer = this.xferRdObject();
        }
    }

    private void saveMethodValue(Attributes attributes) throws AbleParException {
        if (attributes != null) {
            String string = attributes.getValue("varRef");
            String string2 = attributes.getValue("methodName");
            if (string != null && string2 != null) {
                string = string.trim();
                string2 = string2.trim();
                this.saveRuleMethodRef(string);
                this.saveRuleMethodName(string2);
            }
        }
    }

    private void xferMethodValue() throws AbleParException {
        this.xferRuleCall();
        if (this.myRuleCallStack.isEmpty()) {
            this.lookingForArgs = false;
        }
        if (this.myExpressionInProgress) {
            AbleRd ableRd = this.xferRdObject();
            this.myExpressionStack.push(ableRd);
        } else if (this.lookingForArgs) {
            this.myArg = this.xferRdObject();
        } else if (this.myVarInitializerFlag || this.myNewObjectFlag) {
            this.myVarInitializer = this.xferRdObject();
        }
    }

    private void saveArgList() throws AbleParException {
        this.myArgListStack.push(new Vector());
    }

    private void xferArgList() throws AbleParException {
        this.myArgList = (Vector)this.myArgListStack.pop();
        this.saveRuleArgList(this.myArgList);
        this.myArg = null;
    }

    private void saveArg() throws AbleParException {
        this.lookingForArgs = true;
        this.myArg = null;
    }

    private void xferArg() throws AbleParException {
        Vector vector = (Vector)this.myArgListStack.peek();
        if (this.myArg == null && this.myExpressionInProgress) {
            this.myArg = (AbleRd)this.myExpressionStack.pop();
        }
        vector.add(this.myArg);
    }

    private void saveArrayExprValue(Attributes attributes) throws AbleParException {
        if (attributes != null) {
            String string = attributes.getValue("varRef");
            String string2 = attributes.getValue("index");
            if (string != null && string2 != null) {
                string = string.trim();
                char c = (string2 = string2.trim()).charAt(0);
                int n = Character.isLetter(c) ? 2 : 10;
                if (this.myExpressionInProgress) {
                    this.saveRuleArrayIndex(string, n, string2);
                    AbleRd ableRd = this.xferRdObject();
                    this.myExpressionStack.push(ableRd);
                } else if (this.lookingForArgs) {
                    this.saveRuleArrayIndex(string, n, string2);
                    this.myArg = this.xferRdObject();
                } else {
                    this.saveRuleArrayIndex(string, n, string2);
                }
            }
        }
    }

    private void saveVariableValue(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("varRef")) != null) {
            string = string.trim();
            if (this.myExpressionInProgress) {
                this.myRuleToken = string;
                this.myRuleTokenType = 2;
                AbleRd ableRd = this.xferRdObject();
                this.myExpressionStack.push(ableRd);
            } else if (this.lookingForArgs) {
                this.myRuleToken = string;
                this.myRuleTokenType = 2;
                this.myArg = this.xferRdObject();
            } else if (this.inTagPredicateRuleBody) {
                this.myRuleToken = string;
                this.myRuleTokenType = 2;
                this.myPredClauses.add(this.xferRdObject());
            } else {
                this.saveRuleToken(2, string);
                if (this.myVarInitializerFlag || this.myNewObjectFlag) {
                    this.myVarInitializer = this.xferRdObject();
                }
            }
        }
    }

    private void saveFieldValue(Attributes attributes) throws AbleParException {
        if (attributes != null) {
            String string = attributes.getValue("varRef");
            String string2 = attributes.getValue("fieldName");
            if (string != null && string2 != null) {
                string = string.trim();
                string2 = string2.trim();
                if (this.myExpressionInProgress) {
                    this.myRuleToken = string;
                    this.myRuleFieldOrMethod = string2;
                    this.myRuleTokenType = 7;
                    AbleRd ableRd = this.xferRdObject();
                    this.myExpressionStack.push(ableRd);
                } else if (this.lookingForArgs) {
                    this.myRuleToken = string;
                    this.myRuleFieldOrMethod = string2;
                    this.myRuleTokenType = 7;
                    this.myArg = this.xferRdObject();
                } else {
                    this.saveRuleFieldRef(string);
                    this.saveRuleFieldName(string2);
                }
            }
        }
    }

    private void resetOptInfo() {
        this.myAlphaCut = 0.1;
        this.myEngineType = "Script";
        this.myTemplateFlag = false;
        this.myRuleReplacementMode = false;
    }

    private void resetVarInfo() {
        this.myVariableName = "";
        this.myVariableCatValue = new Vector();
        this.myVariableContinuousLo = 0.0;
        this.myVariableContinuousHi = 0.0;
        this.myVariableDiscreteValue = new Vector();
        this.myVariableListValue = new Vector();
        this.myVariableStringValue = "";
        this.myVariableStaticFlag = false;
        this.myVariableType = "";
        this.myFuzzyVariable = null;
        this.myRuleParms.removeAllElements();
        this.myRuleArrayIndexExpression = null;
        this.myTemplateFlag = false;
    }

    private void resetSetInfo() {
        this.mySetComp = false;
        this.mySetName = "";
        this.mySetNameComplement = "";
        this.mySetPtLeft = 0.0;
        this.mySetPtLeftCore = 0.0;
        this.mySetPtCenter = 0.0;
        this.mySetPtFlex = 0.0;
        this.mySetPtRightCore = 0.0;
        this.mySetPtRight = 0.0;
        this.mySetWeight = 1.0;
        this.mySetWidth = 0.0;
        this.mySetDirection = 1;
    }

    private void resetVecInfo() {
        this.myNumberOfSegments = 0;
        this.myScalarVector = new double[256];
        this.myTruthVector = new double[256];
    }

    private void resetHedgeInfo() {
        this.myRuleHedges = "";
    }

    private void resetRuleBlockInfo() {
        this.myRuleBlockName = "";
    }

    private void resetRulInfo() {
        this.myRule = null;
        this.myRulePreConditions = null;
        this.myRuleAntWeight = 1.0;
        this.myRuleHedges = "";
        this.myRuleLabel = "";
        this.myRulePriority = AbleRule.PriorityDefault;
        this.myRuleOp = 0;
        this.myRuleToken = "";
        this.myRuleTokenType = 0;
        this.myRuleFieldOrMethod = "";
        this.myRuleVarLhs = "";
        this.myAntClauses.removeAllElements();
        this.myAntExpressionList.removeAllElements();
        this.myDoList.removeAllElements();
        this.myExpression = null;
        this.myExpressionInProgress = false;
        this.myExpressionStack.clear();
        this.myRuleArrayIndexExpression = null;
        this.myTemplateFlag = false;
    }

    private void resetAntInfo() {
        this.myRuleAntWeight = 1.0;
        this.myRuleHedges = "";
        this.myRuleOp = 0;
        this.myRuleToken = "";
        this.myRuleTokenType = 0;
        this.myRuleFieldOrMethod = "";
        this.myRuleVarLhs = "";
        this.myRuleParms.removeAllElements();
        this.myExpression = null;
        this.myAntExpression = null;
        this.myExpressionInProgress = false;
    }

    private void resetRhsClauseInfo() {
        this.myRuleToken = "";
        this.myRuleTokenType = 0;
        this.myRuleFieldOrMethod = "";
    }

    private void resetRhsParmList() {
        this.myRuleParms.removeAllElements();
    }

    private void resetThenInfo() {
        this.myThenList.removeAllElements();
        this.inThenSection = false;
    }

    private void resetElseInfo() {
        this.myElseList.removeAllElements();
        this.inElseSection = false;
    }

    private void resetWdWhenInfo() {
        this.myWdWhenList.removeAllElements();
    }

    private void resetWdDoInfo() {
        this.myWdDoList.removeAllElements();
    }

    private void resetWdSelectorInfo() {
        this.myWdSelVarName = "";
        this.myWdSelVarType = "";
        this.myWdSelPosFlag = true;
        this.myWdSelVariable = null;
        this.myAntClauses.removeAllElements();
        this.myAntExpressionList.removeAllElements();
    }

    private void resetPredRule() {
        this.myPredLhs = null;
        this.myPredStack.removeAllElements();
        this.myPredClauses.removeAllElements();
    }

    private void resetPredInfo() {
        this.myPredName = "";
        this.myPredPosFlag = true;
    }
}

