/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataContext;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleDoubleLiteral;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleLhs;
import com.ibm.able.data.AbleRd;
import com.ibm.able.rules.AbleAntecedentClause;
import com.ibm.able.rules.AbleConditionalRule;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleIfThenElseRule;
import com.ibm.able.rules.AbleIfThenElseStatement;
import com.ibm.able.rules.AbleParException;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleSet;
import com.ibm.able.rules.AbleTree;
import com.ibm.able.rules.AbleTreeAction;
import com.ibm.able.rules.AbleTreeActionNode;
import com.ibm.able.rules.AbleTreeConditionNode;
import com.ibm.able.rules.AbleTreeEdge;
import com.ibm.able.rules.AbleTreeNode;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Vector;

public class AbleTreeRule
extends AbleRule
implements Serializable {
    static final long serialVersionUID = 2004060100000000001L;
    static String clsNm = "AbleTreeRule";
    protected AbleTree myDecisionTree;
    protected Vector myRuleList;
    protected Vector myExpressionList;
    protected Vector myActionList;

    public AbleTreeRule(String string, AbleRd ableRd, AbleTree ableTree, AbleRuleSet ableRuleSet, AbleRuleBlock ableRuleBlock) {
        super(0, string, ableRd, ableRuleSet);
        this.myDecisionTree = ableTree;
        this.myRuleBlock = ableRuleBlock;
        this.myExpressionList = new Vector();
        this.myActionList = new Vector();
        this.myRuleList = new Vector();
        this.makeExecutable(this.myDecisionTree.getRootNode());
    }

    public final AbleTree getDecisionTree() {
        return this.myDecisionTree;
    }

    public final Vector getExpressionList() {
        return this.myExpressionList;
    }

    public final Vector getRuleList() {
        return this.myRuleList;
    }

    public void reset() {
        this.myFiredFlag = false;
    }

    private void makeExecutable(AbleTreeNode ableTreeNode) {
        if (ableTreeNode instanceof AbleTreeConditionNode) {
            String string = ((AbleTreeConditionNode)ableTreeNode).getTerm().toString();
            Vector vector = ((AbleTreeConditionNode)ableTreeNode).getEdges();
            for (int i = 0; i < vector.size(); ++i) {
                AbleTreeEdge ableTreeEdge = (AbleTreeEdge)vector.get(i);
                if (!(ableTreeEdge instanceof AbleTreeEdge)) continue;
                AbleTreeEdge ableTreeEdge2 = ableTreeEdge;
                try {
                    AbleExpression ableExpression = new AbleExpression((AbleDataContext)this.myRuleSet, string + ableTreeEdge2.getValue().toString());
                    ableTreeEdge2.setAbleExpression(ableExpression);
                }
                catch (Exception exception) {
                    System.out.println("Error- convertToAbleRules() " + exception.toString());
                }
                this.makeExecutable(ableTreeEdge.getChildNode());
            }
        } else if (ableTreeNode instanceof AbleTreeActionNode) {
            Vector vector = this.convertToConsClauses(((AbleTreeActionNode)ableTreeNode).getActions());
            ((AbleTreeActionNode)ableTreeNode).setAbleActions(vector);
        }
    }

    public Vector convertToAbleRules() {
        this.convertToAbleRules(this.myDecisionTree.getRootNode(), this.myExpressionList, this.myRuleList);
        return this.myRuleList;
    }

    private void convertToAbleRules(AbleTreeNode ableTreeNode, Vector vector, Vector vector2) {
        Vector vector3 = (Vector)vector.clone();
        if (ableTreeNode instanceof AbleTreeConditionNode) {
            String string = ((AbleTreeConditionNode)ableTreeNode).getTerm().toString();
            Vector vector4 = ((AbleTreeConditionNode)ableTreeNode).getEdges();
            for (int i = 0; i < vector4.size(); ++i) {
                AbleTreeEdge ableTreeEdge = (AbleTreeEdge)vector4.get(i);
                if (ableTreeEdge instanceof AbleTreeEdge) {
                    AbleTreeEdge ableTreeEdge2 = ableTreeEdge;
                    try {
                        AbleExpression ableExpression = new AbleExpression((AbleDataContext)this.myRuleSet, string + ableTreeEdge2.getValue().toString());
                        vector3.add(ableExpression);
                        ableTreeEdge2.setAbleExpression(ableExpression);
                    }
                    catch (Exception exception) {
                        System.out.println("Error- convertToAbleRules() " + exception.toString());
                    }
                    this.convertToAbleRules(ableTreeEdge.getChildNode(), vector3, vector2);
                }
                vector3.remove(vector3.size() - 1);
            }
        } else if (ableTreeNode instanceof AbleTreeActionNode) {
            Object object;
            AbleRd ableRd;
            Object object2;
            Vector<AbleAntecedentClause> vector5 = new Vector<AbleAntecedentClause>();
            for (int i = 0; i < vector.size(); ++i) {
                AbleAntecedentClause ableAntecedentClause;
                object2 = (AbleExpression)vector.get(i);
                ableRd = object2.getLhs();
                object = object2.getRhs();
                int n = object2.getOp();
                double d = object2.getWeight();
                if (n == 2) {
                    ableAntecedentClause = this.myRuleSet.findOrCreateAntecedent(ableRd, 6, (AbleRd)object, d);
                    vector5.add(ableAntecedentClause);
                    continue;
                }
                ableAntecedentClause = this.myRuleSet.findOrCreateAntecedent(ableRd, n, (AbleRd)object, d);
                vector5.add(ableAntecedentClause);
            }
            Vector vector6 = this.convertToConsClauses(((AbleTreeActionNode)ableTreeNode).getActions());
            ((AbleTreeActionNode)ableTreeNode).setAbleActions(vector6);
            object2 = new Vector();
            ableRd = this.createAbleExpression(vector);
            ((Vector)object2).add(ableRd);
            object = new AbleConditionalRule("rule" + vector2.size(), (AbleRd)new AbleDoubleLiteral(1.0), (Vector)object2, vector5, vector6);
            this.myRuleList.add(object);
        }
    }

    private Vector convertToConsClauses(Vector vector) {
        Vector<AbleConsequentClause> vector2 = new Vector<AbleConsequentClause>();
        for (int i = 0; i < vector.size(); ++i) {
            AbleTreeAction ableTreeAction = (AbleTreeAction)vector.get(i);
            try {
                AbleExpression ableExpression = new AbleExpression((AbleDataContext)this.myRuleSet, ableTreeAction.getExpressionString());
                vector2.add(this.makeRulCns(ableExpression));
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error- convertToAbleRules() " + exception.toString());
            }
        }
        return vector2;
    }

    private AbleConsequentClause makeRulCns(AbleExpression ableExpression) throws AbleParException {
        AbleExpression ableExpression2 = ableExpression;
        AbleRd ableRd = ableExpression2.getLhs();
        int n = ableExpression2.getOp();
        AbleRd ableRd2 = ableExpression2.getRhs();
        AbleConsequentClause ableConsequentClause = n == 1 ? this.myRuleSet.findOrCreateConsequent((AbleLhs)ableRd, n, ableRd2) : (n == 6 ? this.myRuleSet.findOrCreateConsequent((AbleLhs)ableRd, 2, ableRd2) : (n == 28 ? this.myRuleSet.findOrCreateConsequent((AbleLhs)ableRd, n, ableRd2) : this.myRuleSet.findOrCreateConsequent(null, 10, ableRd2)));
        return ableConsequentClause;
    }

    public AbleExpression createAbleExpression(Vector vector) {
        int n = vector.size();
        AbleExpression ableExpression = (AbleExpression)vector.get(0);
        for (int i = 1; i < n; ++i) {
            AbleExpression ableExpression2 = (AbleExpression)vector.get(i);
            ableExpression = this.myRuleSet.findOrCreateExpression((AbleRd)ableExpression, 16, (AbleRd)ableExpression2);
        }
        return ableExpression;
    }

    private AbleIfThenElseRule convertToAbleRule(AbleTreeNode ableTreeNode, AbleIfThenElseRule ableIfThenElseRule, AbleIfThenElseStatement ableIfThenElseStatement) {
        AbleIfThenElseRule ableIfThenElseRule2 = ableIfThenElseRule;
        AbleIfThenElseStatement ableIfThenElseStatement2 = ableIfThenElseStatement;
        if (ableTreeNode instanceof AbleTreeConditionNode) {
            String string = ((AbleTreeConditionNode)ableTreeNode).getTerm().toString();
            Vector vector = ((AbleTreeConditionNode)ableTreeNode).getEdges();
            for (int i = 0; i < vector.size(); ++i) {
                AbleIfThenElseStatement ableIfThenElseStatement3 = null;
                AbleTreeEdge ableTreeEdge = (AbleTreeEdge)vector.get(i);
                if (!(ableTreeEdge instanceof AbleTreeEdge)) continue;
                AbleTreeEdge ableTreeEdge2 = ableTreeEdge;
                try {
                    AbleExpression ableExpression = new AbleExpression((AbleDataContext)this.myRuleSet, string + ableTreeEdge2.getValue().toString());
                    if (ableIfThenElseRule2 == null) {
                        ableIfThenElseRule2 = new AbleIfThenElseRule("baseRule", (AbleRd)new AbleDoubleLiteral(1.0), ableExpression, new Vector(), new Vector());
                    } else {
                        ableIfThenElseStatement3 = new AbleIfThenElseStatement(this.myRuleSet, this.myRuleBlock, ableExpression);
                        AbleConsequentClause ableConsequentClause = this.myRuleSet.findOrCreateConsequent(null, 10, (AbleRd)ableIfThenElseStatement3);
                        if (ableIfThenElseStatement2 == null) {
                            ableIfThenElseStatement2 = ableIfThenElseStatement3;
                            if (i == 0) {
                                ableIfThenElseRule2.addThenAction(ableConsequentClause);
                            } else if (i == 1) {
                                ableIfThenElseRule2.addElseAction(ableConsequentClause);
                            }
                        } else if (i == 0) {
                            ableIfThenElseStatement2.addThenAction(ableConsequentClause);
                        } else {
                            ableIfThenElseStatement2.addElseAction(ableConsequentClause);
                        }
                    }
                }
                catch (Exception exception) {
                    System.out.println("Error- convertToAbleRule() " + exception.toString());
                }
                this.convertToAbleRule(ableTreeEdge.getChildNode(), ableIfThenElseRule2, ableIfThenElseStatement3);
            }
        } else if (ableTreeNode instanceof AbleTreeActionNode) {
            Vector vector = this.convertToConsClauses(((AbleTreeActionNode)ableTreeNode).getActions());
            if (ableIfThenElseStatement != null) {
                ableIfThenElseStatement.setThenActions(vector);
            } else {
                ableIfThenElseRule.setThenActions(vector);
            }
        }
        return ableIfThenElseRule2;
    }

    public boolean eval(AbleTreeNode ableTreeNode) throws AbleDataException {
        boolean bl = false;
        if (ableTreeNode instanceof AbleTreeConditionNode) {
            String string = ((AbleTreeConditionNode)ableTreeNode).getTerm().toString();
            Vector vector = ((AbleTreeConditionNode)ableTreeNode).getEdges();
            for (int i = 0; i < vector.size(); ++i) {
                AbleTreeEdge ableTreeEdge = (AbleTreeEdge)vector.get(i);
                AbleExpression ableExpression = ableTreeEdge.getAbleExpression();
                if (ableExpression.getBooleanValue()) {
                    bl = this.eval(ableTreeEdge.getChildNode());
                }
                if (!bl) {
                    continue;
                }
                break;
            }
        } else if (ableTreeNode instanceof AbleTreeActionNode) {
            Vector vector = ((AbleTreeActionNode)ableTreeNode).getAbleActions();
            bl = true;
        }
        return bl;
    }

    public String arlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        AbleIfThenElseRule ableIfThenElseRule = this.convertToAbleRule(this.myDecisionTree.getRootNode(), null, null);
        stringBuffer.append(ableIfThenElseRule.arlString());
        System.out.println(ableIfThenElseRule.arlString());
        return stringBuffer.toString();
    }

    public String xmlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = this.myExpressionList.size();
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        stringBuffer.append("    <rule" + string + string2 + string3 + ">" + Able.LS);
        stringBuffer.append(this.xmlPreConditionsString());
        stringBuffer.append(this.xmlPriorityString());
        stringBuffer.append("      <if>" + Able.LS);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("      <antecedent>" + Able.LS);
            stringBuffer.append(((AbleExpression)this.myExpressionList.get(i)).xmlCRdString());
            stringBuffer.append("      </antecedent>" + Able.LS);
        }
        stringBuffer.append("    </if>" + Able.LS);
        stringBuffer.append("    </rule>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = this.myExpressionList.size();
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        String string4 = this.myFinalFlag ? " final=\"true\"" : "";
        stringBuffer.append("    <DecisionTreeRule" + string + string2 + string3 + string4 + ">" + Able.LS);
        stringBuffer.append(this.armlPreConditionsString());
        stringBuffer.append(this.armlPriorityString());
        stringBuffer.append("    <if>" + Able.LS);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(((AbleExpression)this.myExpressionList.get(i)).armlCRdString());
        }
        stringBuffer.append("    </if>" + Able.LS);
        stringBuffer.append("    </DecisionTreeRule>" + Able.LS);
        return stringBuffer.toString();
    }

    public Vector getTemplateVars(AbleRuleSet ableRuleSet) throws AbleDataException {
        Serializable serializable;
        BitSet bitSet = this.myRdRefs;
        if (!this.myActionList.isEmpty()) {
            for (int i = 0; i < this.myActionList.size(); ++i) {
                serializable = (AbleConsequentClause)this.myActionList.elementAt(i);
                this.addRdReferences(serializable.getReferents());
            }
        }
        BitSet bitSet2 = new BitSet();
        bitSet2.or(this.myRdRefs);
        bitSet2.or(this.myWrRefs);
        serializable = new Vector();
        this.myRdRefs = bitSet;
        return serializable;
    }

    public String getTemplateString(Vector vector) throws AbleDataException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTemplateHeaderString(vector));
        return stringBuffer.toString();
    }

    public String toString() {
        return this.arlString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlString();
            }
            case 4: {
                return this.arlString();
            }
            case 5: {
                return this.xmlString();
            }
        }
        return this.arlString();
    }

    private String trcString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "    " + this.myLabel;
        int n3 = this.myLabel.length();
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer2.append(" ");
        }
        if (this.myPriority == PriorityDefault) {
            stringBuffer3.append(": ");
        } else {
            stringBuffer3.append("[" + this.myPriority.traceString(n) + "]: ");
        }
        for (n2 = 0; n2 < stringBuffer3.length(); ++n2) {
            stringBuffer2.append(" ");
        }
        stringBuffer.append(string + stringBuffer3.toString() + "if\n");
        stringBuffer.append(stringBuffer2.toString() + "  then\n");
        for (n2 = 0; n2 < this.myActionList.size(); ++n2) {
            stringBuffer.append(stringBuffer2.toString() + "    " + ((AbleConsequentClause)this.myActionList.elementAt(n2)).traceString(n) + Able.LS);
        }
        return stringBuffer.toString();
    }
}

