/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.rules.AbleTreeCondition;
import com.ibm.able.rules.AbleTreeNode;
import com.ibm.able.rules.AbleTreePartialExpression;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class AbleTree
implements Serializable {
    static final long serialVersionUID = 2004060100000000001L;
    protected static final boolean SYMMETRIC_EDEFAULT = false;
    protected boolean symmetric = false;
    protected Vector sharedConditions = new Vector();
    protected Hashtable sharedConditionsTable = new Hashtable();
    protected Vector sharedActionTerms = new Vector();
    protected Hashtable sharedActionTermsTable = new Hashtable();
    protected AbleTreeNode rootNode = null;

    public AbleTree() {
    }

    public AbleTree(AbleTreeNode ableTreeNode, Vector vector, Vector vector2) {
        this.rootNode = ableTreeNode;
        this.sharedConditions = vector;
        this.sharedActionTerms = vector2;
    }

    public boolean isSymmetric() {
        return this.symmetric;
    }

    public void setSymmetric(boolean bl) {
        this.symmetric = bl;
    }

    public Vector getSharedConditions() {
        return this.sharedConditions;
    }

    public void setSharedConditions(Vector vector) {
        this.sharedConditions = vector;
    }

    public void addSharedConditions(Vector vector) {
        this.sharedConditions.addAll(vector);
    }

    public void addSharedCondition(AbleTreeCondition ableTreeCondition) {
        this.sharedConditions.add(ableTreeCondition);
        this.sharedConditionsTable.put(ableTreeCondition.getTerm().getUid(), ableTreeCondition.getTerm());
        Vector vector = ableTreeCondition.getValues();
        for (int i = 0; i < vector.size(); ++i) {
            AbleTreePartialExpression ableTreePartialExpression = (AbleTreePartialExpression)vector.get(i);
            this.sharedConditionsTable.put(ableTreePartialExpression.getUid(), ableTreePartialExpression);
        }
    }

    public AbleTreePartialExpression resolveSharedConditionRef(String string) {
        return (AbleTreePartialExpression)this.sharedConditionsTable.get(string);
    }

    public AbleTreePartialExpression resolveSharedActionTermRef(String string) {
        return (AbleTreePartialExpression)this.sharedActionTermsTable.get(string);
    }

    public Vector getSharedActionTerms() {
        return this.sharedActionTerms;
    }

    public void setSharedActionTerms(Vector vector) {
        this.sharedActionTerms = vector;
    }

    public void addSharedActionTerms(Vector vector) {
        this.sharedActionTerms.addAll(vector);
    }

    public void addSharedActionTerm(AbleTreePartialExpression ableTreePartialExpression) {
        this.sharedActionTerms.add(ableTreePartialExpression);
        this.sharedActionTermsTable.put(ableTreePartialExpression.getUid(), ableTreePartialExpression);
    }

    public AbleTreeNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(AbleTreeNode ableTreeNode) {
        this.rootNode = ableTreeNode;
    }

    public boolean isEmpty() {
        return this.rootNode == null;
    }

    public void convertToRules() {
    }

    public String arlString() {
        return "";
    }

    public String armlString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<DecisionTree>" + Able.LS);
        stringBuffer.append("</DecisionTree>" + Able.LS);
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.rootNode.toString());
        return stringBuffer.toString();
    }
}

