/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.BitSet;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class AbleTimePeriod
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static String clsNm = "AbleTimePeriod";
    private Calendar myStartValue = null;
    private Calendar myEndValue = null;
    public static final int NO_MASK = -1;
    private int myMonthMask = -1;
    private int myDayOfWeekMask = -1;
    private long myDayOfMonthMask = -1L;
    private Calendar myTimeOfDayStartMask = null;
    private Calendar myTimeOfDayEndMask = null;
    private boolean localTimeFlag = true;

    public AbleTimePeriod(String string, int n, long l, int n2, String string2) {
        this.localTimeFlag = true;
        this.setTimePeriod(string);
        this.myMonthMask = n;
        this.myDayOfMonthMask = l;
        this.myDayOfWeekMask = n2;
        this.setTimeOfDayMask(string2);
    }

    public AbleTimePeriod(String string, int n, long l, int n2, String string2, boolean bl) {
        this.localTimeFlag = bl;
        this.setTimePeriod(string);
        this.myMonthMask = n;
        this.myDayOfMonthMask = l;
        this.myDayOfWeekMask = n2;
        this.setTimeOfDayMask(string2);
    }

    public AbleTimePeriod(Calendar calendar, Calendar calendar2) {
        this.myStartValue = calendar;
        this.myEndValue = calendar2;
        if (this.myStartValue.after(this.myEndValue)) {
            throw new IllegalArgumentException(Able.NlsMsg((String)"Ex_TimePeriodEndBeforeStart", (Object[])new Object[]{this.myStartValue, this.myEndValue}));
        }
    }

    public AbleTimePeriod(Calendar calendar, String string) {
        this.myStartValue = calendar;
        this.myEndValue = this.parseCalendar(string);
        if (this.myStartValue.after(this.myEndValue)) {
            throw new IllegalArgumentException(Able.NlsMsg((String)"Ex_TimePeriodEndBeforeStart", (Object[])new Object[]{this.myStartValue, this.myEndValue}));
        }
    }

    public AbleTimePeriod(String string, String string2) {
        this.myStartValue = this.parseCalendar(string);
        this.myEndValue = this.parseCalendar(string2);
        if (this.myStartValue.after(this.myEndValue)) {
            throw new IllegalArgumentException(Able.NlsMsg((String)"Ex_TimePeriodEndBeforeStart", (Object[])new Object[]{this.myStartValue, this.myEndValue}));
        }
    }

    public AbleTimePeriod(String string, Calendar calendar) {
        this.myStartValue = this.parseCalendar(string);
        this.myEndValue = calendar;
        if (this.myStartValue.after(this.myEndValue)) {
            throw new IllegalArgumentException(Able.NlsMsg((String)"Ex_TimePeriodEndBeforeStart", (Object[])new Object[]{this.myStartValue, this.myEndValue}));
        }
    }

    public AbleTimePeriod(Calendar calendar, Calendar calendar2, int n) {
        this(calendar, calendar2);
        this.myMonthMask = n;
    }

    public AbleTimePeriod(String string, String string2, int n) {
        this(string, string2);
        this.myMonthMask = n;
    }

    public AbleTimePeriod(Calendar calendar, Calendar calendar2, int n, long l) {
        this(calendar, calendar2);
        this.myMonthMask = n;
        this.myDayOfMonthMask = l;
    }

    public AbleTimePeriod(String string, String string2, int n, long l) {
        this(string, string2);
        this.myMonthMask = n;
        this.myDayOfMonthMask = l;
    }

    public AbleTimePeriod(Calendar calendar, Calendar calendar2, int n, int n2) {
        this(calendar, calendar2);
        this.myMonthMask = n;
        this.myDayOfWeekMask = n2;
    }

    public AbleTimePeriod(String string, String string2, int n, int n2) {
        this(string, string2);
        this.myMonthMask = n;
        this.myDayOfWeekMask = n2;
    }

    public AbleTimePeriod(Calendar calendar, Calendar calendar2, int n, int n2, String string) {
        this(calendar, calendar2);
        this.myMonthMask = n;
        this.myDayOfWeekMask = n2;
        this.setTimeOfDayMask(string);
    }

    public AbleTimePeriod(String string, String string2, int n, int n2, String string3) {
        this(string, string2);
        this.myMonthMask = n;
        this.myDayOfWeekMask = n2;
        this.setTimeOfDayMask(string3);
    }

    public AbleTimePeriod(Calendar calendar, Calendar calendar2, int n, long l, int n2, Calendar calendar3, Calendar calendar4) {
        this(calendar, calendar2);
        this.myMonthMask = n;
        this.myDayOfMonthMask = l;
        this.myDayOfWeekMask = n2;
        this.setTimeOfDayMask(calendar3, calendar4);
    }

    public AbleTimePeriod(String string, String string2, int n, long l, int n2, Calendar calendar, Calendar calendar2) {
        this(string, string2);
        this.myMonthMask = n;
        this.myDayOfMonthMask = l;
        this.myDayOfWeekMask = n2;
        this.setTimeOfDayMask(calendar, calendar2);
    }

    public AbleTimePeriod(String string, String string2, int n, long l, int n2, String string3) {
        this(string, string2);
        this.myMonthMask = n;
        this.myDayOfMonthMask = l;
        this.myDayOfWeekMask = n2;
        this.setTimeOfDayMask(string3);
    }

    public AbleTimePeriod(String string, String string2, int n, String string3) {
        this(string, string2);
        this.myDayOfWeekMask = n;
        this.setTimeOfDayMask(string3);
    }

    public AbleTimePeriod(Calendar calendar, Calendar calendar2, int n, Calendar calendar3, Calendar calendar4) {
        this(calendar, calendar2);
        this.myDayOfWeekMask = n;
        this.setTimeOfDayMask(calendar3, calendar4);
    }

    public AbleTimePeriod(Calendar calendar, Calendar calendar2, Calendar calendar3, Calendar calendar4) {
        this(calendar, calendar2);
        this.setTimeOfDayMask(calendar3, calendar4);
    }

    public AbleTimePeriod(Calendar calendar, Calendar calendar2, String string) {
        this(calendar, calendar2);
        this.setTimeOfDayMask(string);
    }

    public AbleTimePeriod(String string, String string2, String string3) {
        this(string, string2);
        this.setTimeOfDayMask(string3);
    }

    public BitSet setMonthMask(int n) {
        int n2 = 1;
        BitSet bitSet = new BitSet(12);
        for (int i = 0; i < 12; ++i) {
            if ((n & n2) > 0) {
                bitSet.set(i);
            }
            n2 <<= 1;
        }
        return bitSet;
    }

    public int getMonthMask() {
        return this.myMonthMask;
    }

    public boolean isLocalTime() {
        return this.localTimeFlag;
    }

    public BitSet setDayOfMonthMask(int n) {
        int n2 = 1;
        BitSet bitSet = new BitSet(31);
        for (int i = 0; i < 31; ++i) {
            if ((n & n2) > 0) {
                bitSet.set(i);
            }
            n2 <<= 1;
        }
        return bitSet;
    }

    public long getDayOfMonthMask() {
        return this.myDayOfMonthMask;
    }

    public BitSet setDayOfWeekMask(int n) {
        int n2 = 1;
        BitSet bitSet = new BitSet(7);
        for (int i = 0; i < 7; ++i) {
            if ((n & n2) > 0) {
                bitSet.set(i);
            }
            n2 <<= 1;
        }
        return bitSet;
    }

    public int getDayOfWeekMask() {
        return this.myDayOfWeekMask;
    }

    public void setTimeOfDayStartMask(Calendar calendar) {
        this.myTimeOfDayStartMask = calendar;
    }

    public Calendar getTimeOfDayStartMask() {
        return this.myTimeOfDayStartMask;
    }

    public void setTimeOfDayEndMask(Calendar calendar) {
        this.myTimeOfDayEndMask = calendar;
    }

    public Calendar getTimeOfDayEndMask() {
        return this.myTimeOfDayEndMask;
    }

    public void setTimeOfDayMask(Calendar calendar, Calendar calendar2) {
        this.myTimeOfDayStartMask = calendar;
        this.myTimeOfDayEndMask = calendar2;
    }

    public void setTimeOfDayMask(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "//");
            if (string.startsWith("T")) {
                String string2 = stringTokenizer.nextToken();
                int n = Integer.parseInt(string2.substring(1, 3));
                int n2 = Integer.parseInt(string2.substring(3, 5));
                int n3 = Integer.parseInt(string2.substring(5, 7));
                this.myTimeOfDayStartMask = Calendar.getInstance();
                this.myTimeOfDayStartMask.set(11, n);
                this.myTimeOfDayStartMask.set(12, n2);
                this.myTimeOfDayStartMask.set(13, n3);
                String string3 = stringTokenizer.nextToken();
                n = Integer.parseInt(string3.substring(1, 3));
                n2 = Integer.parseInt(string3.substring(3, 5));
                n3 = Integer.parseInt(string3.substring(5, 7));
                this.myTimeOfDayEndMask = Calendar.getInstance();
                this.myTimeOfDayEndMask.set(11, n);
                this.myTimeOfDayEndMask.set(12, n2);
                this.myTimeOfDayEndMask.set(13, n3);
            } else {
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                DateFormat dateFormat = DateFormat.getTimeInstance();
                this.myTimeOfDayStartMask = Calendar.getInstance();
                this.myTimeOfDayStartMask.setTime(dateFormat.parse(string4));
                this.myTimeOfDayEndMask = Calendar.getInstance();
                this.myTimeOfDayEndMask.setTime(dateFormat.parse(string5));
            }
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(Able.NlsMsg((String)"Ex_TimePeriodParseError", (Object[])new Object[]{string, "Thhmmss/Thhmmss"}));
        }
    }

    public void setTimePeriod(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        Calendar calendar = this.getCalendar();
        Calendar calendar2 = this.getCalendar();
        String string2 = stringTokenizer.nextToken();
        if (string2.equals("THISANDPRIOR")) {
            calendar.set(0, 0, 0, 0, 0, 0);
        } else {
            if (string2.length() != 15) {
                throw new IllegalArgumentException(Able.NlsMsg((String)"Ex_TimePeriodParseError", (Object[])new Object[]{string, "yyyymmddThhmmss/yyyymmddThhmmss"}));
            }
            int n6 = Integer.parseInt(string2.substring(0, 4));
            n5 = Integer.parseInt(string2.substring(4, 6));
            n4 = Integer.parseInt(string2.substring(6, 8));
            if (string2.charAt(8) != 'T') {
                throw new IllegalArgumentException(Able.NlsMsg((String)"Ex_TimePeriodParseError", (Object[])new Object[]{string, "yyyymmddThhmmss/yyyymmddThhmmss"}));
            }
            n3 = Integer.parseInt(string2.substring(9, 11));
            n2 = Integer.parseInt(string2.substring(11, 13));
            n = Integer.parseInt(string2.substring(13, 15));
            calendar.set(n6, n5, n4, n3, n2, n);
        }
        String string3 = stringTokenizer.nextToken();
        if (string3.equals("THISANDFUTURE") && !string2.equals("THISANDPRIOR")) {
            calendar2.set(9999, 11, 30, 23, 59, 59);
        } else {
            if (string3.length() != 15) {
                throw new IllegalArgumentException(Able.NlsMsg((String)"Ex_TimePeriodParseError", (Object[])new Object[]{string, "yyyymmddThhmmss/yyyymmddThhmmss"}));
            }
            n5 = Integer.parseInt(string3.substring(0, 4));
            n4 = Integer.parseInt(string3.substring(4, 6));
            n3 = Integer.parseInt(string3.substring(6, 8));
            if (string3.charAt(8) != 'T') {
                throw new IllegalArgumentException(Able.NlsMsg((String)"Ex_TimePeriodParseError", (Object[])new Object[]{string, "yyyymmddThhmmss/yyyymmddThhmmss"}));
            }
            n2 = Integer.parseInt(string3.substring(9, 11));
            n = Integer.parseInt(string3.substring(11, 13));
            int n7 = Integer.parseInt(string3.substring(13, 15));
            calendar2.set(n5, n4, n3, n2, n, n7);
        }
        this.myEndValue = calendar2;
        this.myStartValue = calendar;
    }

    private Calendar getCalendar() {
        Calendar calendar = this.localTimeFlag ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        return calendar;
    }

    public boolean isInTimePeriod(Calendar calendar) {
        return calendar.after(this.myStartValue) && calendar.before(this.myEndValue);
    }

    public boolean isInMonth(Calendar calendar) {
        return calendar.after(this.myStartValue) && calendar.before(this.myEndValue);
    }

    public boolean isInDayOfWeek(Calendar calendar) {
        return calendar.after(this.myStartValue) && calendar.before(this.myEndValue);
    }

    public boolean isInDayOfMonth(Calendar calendar) {
        return calendar.after(this.myStartValue) && calendar.before(this.myEndValue);
    }

    public boolean contains(Calendar calendar) {
        if (calendar.after(this.myStartValue) && calendar.before(this.myEndValue)) {
            int n;
            if (this.myMonthMask != -1 && (this.getMonthBitMask(n = calendar.get(2)) & this.myMonthMask) == 0) {
                return false;
            }
            if (this.myDayOfWeekMask != -1 && (this.getDayOfWeekBitMask(n = calendar.get(7)) & this.myDayOfWeekMask) == 0) {
                return false;
            }
            if (this.myDayOfMonthMask != -1L && (this.getDayOfMonthBitMask(n = calendar.get(5)) + this.getDayOfMonthBitMaskFromLast(calendar) & this.myDayOfMonthMask) == 0L) {
                return false;
            }
            if (this.myTimeOfDayStartMask != null) {
                n = calendar.get(11) * 3600 + (calendar.get(12) * 60 + calendar.get(13));
                int n2 = this.myTimeOfDayStartMask.get(11) * 3600 + (this.myTimeOfDayStartMask.get(12) * 60 + this.myTimeOfDayStartMask.get(13));
                int n3 = this.myTimeOfDayEndMask.get(11) * 3600 + (this.myTimeOfDayEndMask.get(12) * 60 + this.myTimeOfDayEndMask.get(13));
                if (n < n2) {
                    return false;
                }
                if (n > n3) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected int getMonthBitMask(int n) {
        switch (n) {
            case 0: {
                return 32768;
            }
            case 1: {
                return 16384;
            }
            case 2: {
                return 8192;
            }
            case 3: {
                return 4096;
            }
            case 4: {
                return 2048;
            }
            case 5: {
                return 1024;
            }
            case 6: {
                return 512;
            }
            case 7: {
                return 256;
            }
            case 8: {
                return 128;
            }
            case 9: {
                return 64;
            }
            case 10: {
                return 32;
            }
            case 11: {
                return 16;
            }
        }
        return 0;
    }

    protected int getDayOfWeekBitMask(int n) {
        switch (n) {
            case 1: {
                return 128;
            }
            case 2: {
                return 64;
            }
            case 3: {
                return 32;
            }
            case 4: {
                return 16;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 2;
            }
        }
        return 0;
    }

    protected long getDayOfMonthBitMask(int n) {
        switch (n) {
            case 1: {
                return Long.MIN_VALUE;
            }
            case 2: {
                return 0x4000000000000000L;
            }
            case 3: {
                return 0x2000000000000000L;
            }
            case 4: {
                return 0x1000000000000000L;
            }
            case 5: {
                return 0x800000000000000L;
            }
            case 6: {
                return 0x400000000000000L;
            }
            case 7: {
                return 0x200000000000000L;
            }
            case 8: {
                return 0x100000000000000L;
            }
            case 9: {
                return 0x80000000000000L;
            }
            case 10: {
                return 0x40000000000000L;
            }
            case 11: {
                return 0x20000000000000L;
            }
            case 12: {
                return 0x10000000000000L;
            }
            case 13: {
                return 0x8000000000000L;
            }
            case 14: {
                return 0x4000000000000L;
            }
            case 15: {
                return 0x2000000000000L;
            }
            case 16: {
                return 0x1000000000000L;
            }
            case 17: {
                return 0x800000000000L;
            }
            case 18: {
                return 0x400000000000L;
            }
            case 19: {
                return 0x200000000000L;
            }
            case 20: {
                return 0x100000000000L;
            }
            case 21: {
                return 0x80000000000L;
            }
            case 22: {
                return 0x40000000000L;
            }
            case 23: {
                return 0x20000000000L;
            }
            case 24: {
                return 0x10000000000L;
            }
            case 25: {
                return 0x8000000000L;
            }
            case 26: {
                return 0x4000000000L;
            }
            case 27: {
                return 0x2000000000L;
            }
            case 28: {
                return 0x1000000000L;
            }
            case 29: {
                return 0x800000000L;
            }
            case 30: {
                return 0x400000000L;
            }
            case 31: {
                return 0x200000000L;
            }
        }
        return 0L;
    }

    protected long getDayOfMonthBitMaskFromLast(Calendar calendar) {
        switch (this.getDayOfMonthFromLast(calendar)) {
            case 1: {
                return 0x100000000L;
            }
            case 2: {
                return 0x80000000L;
            }
            case 3: {
                return 0x40000000L;
            }
            case 4: {
                return 0x20000000L;
            }
            case 5: {
                return 0x10000000L;
            }
            case 6: {
                return 0x8000000L;
            }
            case 7: {
                return 0x4000000L;
            }
            case 8: {
                return 0x2000000L;
            }
            case 9: {
                return 0x1000000L;
            }
            case 10: {
                return 0x800000L;
            }
            case 11: {
                return 0x400000L;
            }
            case 12: {
                return 0x200000L;
            }
            case 13: {
                return 0x100000L;
            }
            case 14: {
                return 524288L;
            }
            case 15: {
                return 262144L;
            }
            case 16: {
                return 131072L;
            }
            case 17: {
                return 65536L;
            }
            case 18: {
                return 32768L;
            }
            case 19: {
                return 16384L;
            }
            case 20: {
                return 8192L;
            }
            case 21: {
                return 4096L;
            }
            case 22: {
                return 2048L;
            }
            case 23: {
                return 1024L;
            }
            case 24: {
                return 512L;
            }
            case 25: {
                return 256L;
            }
            case 26: {
                return 128L;
            }
            case 27: {
                return 64L;
            }
            case 28: {
                return 32L;
            }
            case 29: {
                return 16L;
            }
            case 30: {
                return 8L;
            }
            case 31: {
                return 4L;
            }
        }
        return 0L;
    }

    protected int getDayOfMonthFromLast(Calendar calendar) {
        int n = calendar.get(5) - 1;
        switch (calendar.get(2)) {
            case 0: {
                return 31 - n;
            }
            case 1: {
                int n2 = calendar.get(1);
                return (((GregorianCalendar)calendar).isLeapYear(n2) ? 29 : 28) - n;
            }
            case 2: {
                return 31 - n;
            }
            case 3: {
                return 30 - n;
            }
            case 4: {
                return 31 - n;
            }
            case 5: {
                return 30 - n;
            }
            case 6: {
                return 31 - n;
            }
            case 7: {
                return 31 - n;
            }
            case 8: {
                return 30 - n;
            }
            case 9: {
                return 31 - n;
            }
            case 10: {
                return 30 - n;
            }
            case 11: {
                return 31 - n;
            }
        }
        return 0;
    }

    private Calendar parseCalendar(String string) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(dateFormat.parse(string));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(Able.NlsMsg((String)"Ex_TimePeriodParseError", (Object[])new Object[]{string, Calendar.getInstance().toString()}));
        }
        return calendar;
    }
}

