/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.data.AbleBooleanLiteral;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleLhs;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleRd;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleParException;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class AbleSwitchStatement
extends AbleLiteral
implements Serializable {
    static final long serialVersionUID = 2004041600000000001L;
    static String clsNm = "AbleSwitchStatement";
    private AbleExpression myIntExpresssion;
    private List myCodeBody = new Vector();
    private List myDefaultCode = new Vector();
    private List myCaseLabels = new Vector();
    private List myCaseList = new Vector();
    private AbleRuleSet myRuleSet;
    private AbleRuleBlock myRuleBlock;
    static /* synthetic */ Class class$java$lang$Object;

    public AbleSwitchStatement(AbleRuleSet ableRuleSet, AbleRuleBlock ableRuleBlock, AbleExpression ableExpression) {
        this.myRuleSet = ableRuleSet;
        this.myRuleBlock = ableRuleBlock;
        this.myIntExpresssion = ableExpression;
    }

    public void addCaseLabel(AbleRd ableRd) throws AbleParException {
        double d = -1.0;
        try {
            d = ableRd.getNumericValue();
        }
        catch (AbleDataException ableDataException) {
            String string = "Error: Case label <" + ableRd + "> does not resolve to an integer value";
            throw new AbleParException(string, ableDataException);
        }
        Integer n = new Integer((int)d);
        this.myCaseLabels.add(n);
        this.myCaseList.add(new CaseListElement_(n, ableRd, this.myCodeBody.size()));
    }

    public void addCaseCode(Collection collection) {
        this.myCodeBody.addAll(collection);
    }

    public void addCaseCode(AbleConsequentClause ableConsequentClause) {
        this.myCodeBody.add(ableConsequentClause);
    }

    public void addDefaultCode(Collection collection) {
        this.myDefaultCode.addAll(collection);
    }

    public void addDefaultCode(AbleConsequentClause ableConsequentClause) {
        this.myDefaultCode.add(ableConsequentClause);
    }

    public AbleLiteral getValue() throws AbleDataException {
        this.evaluate();
        return AbleBooleanLiteral.TRUE;
    }

    public void evaluate() throws AbleDataException {
        Double d = new Double(this.myIntExpresssion.getNumericValue());
        Integer n = new Integer(d.intValue());
        int n2 = this.myCaseLabels.indexOf(n);
        boolean bl = true;
        if (n2 != -1) {
            CaseListElement_ caseListElement_ = (CaseListElement_)this.myCaseList.get(n2);
            int n3 = caseListElement_.getCodeOffset();
            ListIterator listIterator = this.myCodeBody.listIterator(n3);
            while (listIterator.hasNext()) {
                AbleConsequentClause ableConsequentClause = (AbleConsequentClause)listIterator.next();
                if (ableConsequentClause.getOp() != 28) {
                    this.evalConsequentClause(ableConsequentClause);
                    continue;
                }
                bl = false;
                break;
            }
            if (bl && !this.myDefaultCode.isEmpty()) {
                this.evaluateDefaultBlock();
            }
        } else if (!this.myDefaultCode.isEmpty()) {
            this.evaluateDefaultBlock();
        }
    }

    private void evaluateDefaultBlock() throws AbleDataException {
        AbleConsequentClause ableConsequentClause;
        Iterator iterator = this.myDefaultCode.iterator();
        while (iterator.hasNext() && (ableConsequentClause = (AbleConsequentClause)iterator.next()).getOp() != 28) {
            this.evalConsequentClause(ableConsequentClause);
        }
    }

    protected void evalConsequentClause(AbleConsequentClause ableConsequentClause) throws AbleDataException {
        this.myRuleSet.myInferenceContext.clause = ableConsequentClause;
        AbleLhs ableLhs = null;
        int n = ableConsequentClause.getOp();
        AbleRd ableRd = ableConsequentClause.getRhs();
        if (ableRd instanceof AbleExpression) {
            ableRd = ableRd.getValue();
        }
        if (n != 10) {
            ableLhs = (AbleLhs)ableConsequentClause.getLhs();
        }
        switch (n) {
            case 1: {
                ableLhs.asgnEq(ableRd);
                break;
            }
            case 2: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsFuzzyIsInBoolean", (Object[])new Object[]{AbleData.OperatorRl((int)n), this.myRuleBlock.getEngineType()}));
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsComparisonInConsequent", (Object[])new Object[]{AbleData.OperatorRl((int)n), this.myRuleBlock.getEngineType()}));
            }
            case 10: {
                ableRd.getValue();
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsMathOperatorInConsequent", (Object[])new Object[]{AbleData.OperatorRl((int)n), this.myRuleBlock.getEngineType()}));
            }
            case 16: 
            case 17: 
            case 18: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsBooleanOperatorInConsequent", (Object[])new Object[]{AbleData.OperatorRl((int)n), this.myRuleBlock.getEngineType()}));
            }
            default: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnrecognizedOperator", (Object[])new Object[]{Integer.toString(n), this.myRuleBlock.getEngineType()}));
            }
        }
    }

    public String arlString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "        ";
        stringBuffer.append("switch ( ");
        stringBuffer.append(this.myIntExpresssion.arlCRdString());
        stringBuffer.append(" ) {");
        stringBuffer.append(Able.LS);
        int n2 = 0;
        for (n = 0; n < this.myCaseList.size(); ++n) {
            CaseListElement_ caseListElement_ = (CaseListElement_)this.myCaseList.get(n);
            AbleRd ableRd = caseListElement_.getCaseLabel();
            int n3 = caseListElement_.getCodeOffset();
            if (n3 != n2) {
                for (int i = n2; i < n3; ++i) {
                    stringBuffer.append(string);
                    stringBuffer.append("    ");
                    stringBuffer.append(((AbleConsequentClause)this.myCodeBody.get(i)).arlString());
                    stringBuffer.append(";");
                    stringBuffer.append(Able.LS);
                }
                n2 = n3;
            }
            stringBuffer.append(string);
            stringBuffer.append("  case ");
            stringBuffer.append(ableRd.arlCRdString());
            stringBuffer.append(":");
            stringBuffer.append(Able.LS);
        }
        for (n = n2; n < this.myCodeBody.size(); ++n) {
            stringBuffer.append(string);
            stringBuffer.append("    ");
            stringBuffer.append(((AbleConsequentClause)this.myCodeBody.get(n)).arlString());
            stringBuffer.append(";");
            stringBuffer.append(Able.LS);
        }
        if (!this.myDefaultCode.isEmpty()) {
            stringBuffer.append(string);
            stringBuffer.append("  default:");
            stringBuffer.append(Able.LS);
            for (n = 0; n < this.myDefaultCode.size(); ++n) {
                stringBuffer.append(string);
                stringBuffer.append("    ");
                stringBuffer.append(((AbleConsequentClause)this.myDefaultCode.get(n)).arlString());
                stringBuffer.append(";");
                stringBuffer.append(Able.LS);
            }
        }
        stringBuffer.append(string);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String armlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "            ";
        stringBuffer.append("<switch>");
        stringBuffer.append(Able.LS);
        stringBuffer.append(string);
        stringBuffer.append(this.arlCRdString());
        stringBuffer.append(Able.LS);
        stringBuffer.append(string);
        stringBuffer.append("</switch>");
        stringBuffer.append(Able.LS);
        return stringBuffer.toString();
    }

    public String xmlString() {
        return this.armlString();
    }

    public String getTemplateString(Vector vector) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string = "        ";
        stringBuffer.append("switch ( ");
        stringBuffer.append(this.myIntExpresssion.getTemplateString(vector));
        stringBuffer.append(" ) '{'");
        stringBuffer.append(Able.LS);
        int n2 = 0;
        for (n = 0; n < this.myCaseList.size(); ++n) {
            CaseListElement_ caseListElement_ = (CaseListElement_)this.myCaseList.get(n);
            AbleRd ableRd = caseListElement_.getCaseLabel();
            int n3 = caseListElement_.getCodeOffset();
            if (n3 != n2) {
                for (int i = n2; i < n3; ++i) {
                    stringBuffer.append(string);
                    stringBuffer.append("    ");
                    stringBuffer.append(((AbleConsequentClause)this.myCodeBody.get(i)).getTemplateString(vector));
                    stringBuffer.append(";");
                    stringBuffer.append(Able.LS);
                }
                n2 = n3;
            }
            stringBuffer.append(string);
            stringBuffer.append("  case ");
            stringBuffer.append(ableRd.getTemplateString(vector));
            stringBuffer.append(":");
            stringBuffer.append(Able.LS);
        }
        for (n = n2; n < this.myCodeBody.size(); ++n) {
            stringBuffer.append(string);
            stringBuffer.append("    ");
            stringBuffer.append(((AbleConsequentClause)this.myCodeBody.get(n)).getTemplateString(vector));
            stringBuffer.append(";");
            stringBuffer.append(Able.LS);
        }
        if (!this.myDefaultCode.isEmpty()) {
            stringBuffer.append(string);
            stringBuffer.append("  default:");
            stringBuffer.append(Able.LS);
            for (n = 0; n < this.myDefaultCode.size(); ++n) {
                stringBuffer.append(string);
                stringBuffer.append("    ");
                stringBuffer.append(((AbleConsequentClause)this.myDefaultCode.get(n)).getTemplateString(vector));
                stringBuffer.append(";");
                stringBuffer.append(Able.LS);
            }
        }
        stringBuffer.append(string);
        stringBuffer.append("'}'");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.arlString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlString();
            }
            case 4: {
                return this.arlString();
            }
            case 5: {
                return this.xmlString();
            }
        }
        return this.arlString();
    }

    private String trcString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "        ";
        stringBuffer.append("switch ( ");
        stringBuffer.append(this.myIntExpresssion.traceString(n));
        stringBuffer.append(" ) {");
        stringBuffer.append(Able.LS);
        int n3 = 0;
        for (n2 = 0; n2 < this.myCaseList.size(); ++n2) {
            CaseListElement_ caseListElement_ = (CaseListElement_)this.myCaseList.get(n2);
            AbleRd ableRd = caseListElement_.getCaseLabel();
            int n4 = caseListElement_.getCodeOffset();
            if (n4 != n3) {
                for (int i = n3; i < n4; ++i) {
                    stringBuffer.append(string);
                    stringBuffer.append("    ");
                    stringBuffer.append(((AbleConsequentClause)this.myCodeBody.get(i)).traceString(n));
                    stringBuffer.append(";");
                    stringBuffer.append(Able.LS);
                }
                n3 = n4;
            }
            stringBuffer.append(string);
            stringBuffer.append("  case ");
            stringBuffer.append(ableRd.traceString(n));
            stringBuffer.append(":");
            stringBuffer.append(Able.LS);
        }
        for (n2 = n3; n2 < this.myCodeBody.size(); ++n2) {
            stringBuffer.append(string);
            stringBuffer.append("    ");
            stringBuffer.append(((AbleConsequentClause)this.myCodeBody.get(n2)).traceString(n));
            stringBuffer.append(";");
            stringBuffer.append(Able.LS);
        }
        if (!this.myDefaultCode.isEmpty()) {
            stringBuffer.append(string);
            stringBuffer.append("  default:");
            stringBuffer.append(Able.LS);
            for (n2 = 0; n2 < this.myDefaultCode.size(); ++n2) {
                stringBuffer.append(string);
                stringBuffer.append("    ");
                stringBuffer.append(((AbleConsequentClause)this.myDefaultCode.get(n2)).traceString(n));
                stringBuffer.append(";");
                stringBuffer.append(Able.LS);
            }
        }
        stringBuffer.append(string);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public int getDataType() {
        return 33;
    }

    public Class getDataTypeClass() {
        return class$java$lang$Object == null ? (class$java$lang$Object = AbleSwitchStatement.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public String getDataTypeClassName() {
        return (class$java$lang$Object == null ? (class$java$lang$Object = AbleSwitchStatement.class$("java.lang.Object")) : class$java$lang$Object).getName();
    }

    public String arlCRdString() {
        return this.arlString();
    }

    public String xmlCRdString() {
        return this.xmlString();
    }

    public boolean getBooleanValue() throws AbleDataException {
        return false;
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg((String)"Ex_CannotConvertLitTypeXToFuzzy", (Object[])new Object[]{clsNm}));
    }

    public Object getGenericValue() throws AbleDataException {
        return null;
    }

    public double getNumericValue() throws AbleDataException {
        return 0.0;
    }

    public String getStringValue() throws AbleDataException {
        return "";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class CaseListElement_
    implements Serializable {
        static final long serialVersionUID = 2004041900000000001L;
        private Integer myCaseLabelKey = null;
        private AbleRd myCaseLabel = null;
        private int myCodeOffset = -1;

        public CaseListElement_(Integer n, AbleRd ableRd, int n2) {
            this.myCaseLabelKey = n;
            this.myCaseLabel = ableRd;
            this.myCodeOffset = n2;
        }

        public CaseListElement_(CaseListElement_ caseListElement_) {
            this.myCaseLabelKey = caseListElement_.getCaseLabelKey();
            this.myCaseLabel = caseListElement_.getCaseLabel();
            this.myCodeOffset = caseListElement_.getCodeOffset();
        }

        public Integer getCaseLabelKey() {
            return this.myCaseLabelKey;
        }

        public AbleRd getCaseLabel() {
            return this.myCaseLabel;
        }

        public int getCodeOffset() {
            return this.myCodeOffset;
        }

        public String prettyPrint() {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append("\n\tKey...........\t");
            stringBuffer.append(this.myCaseLabelKey);
            stringBuffer.append("\n\tCase Label....\t");
            stringBuffer.append(this.myCaseLabelKey);
            stringBuffer.append("\n\tCode Offset...\t");
            stringBuffer.append(this.myCodeOffset);
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }
}

