/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AblePredicate;
import com.ibm.able.data.AbleTypedVariable;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleAntecedentClause;
import com.ibm.able.rules.AbleInferenceEngine;
import com.ibm.able.rules.AbleOclBag;
import com.ibm.able.rules.AbleOclCollection;
import com.ibm.able.rules.AbleOclOrderedSet;
import com.ibm.able.rules.AbleOclSequence;
import com.ibm.able.rules.AbleOclSet;
import com.ibm.able.rules.AbleParException;
import com.ibm.able.rules.AblePredicateFact;
import com.ibm.able.rules.AbleRuleSet;
import com.ibm.able.rules.AbleWorkingMemory;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class AbleSelector
implements Serializable {
    static final long serialVersionUID = 2001022300000000001L;
    static String clsNm = "AbleSelector";
    protected Vector constraints;
    protected AbleVariable selectorVariable;
    protected boolean positive = true;
    protected AbleExpression constraintExpr;
    protected AbleRuleSet myRuleSet;
    static /* synthetic */ Class class$com$ibm$able$data$AbleExpression;

    public AbleSelector() {
    }

    public AbleSelector(AbleVariable ableVariable, Vector vector) {
        this.selectorVariable = ableVariable;
        this.constraints = vector;
    }

    public AbleSelector(AbleRuleSet ableRuleSet, AbleVariable ableVariable, Vector vector, boolean bl) {
        this.myRuleSet = ableRuleSet;
        this.selectorVariable = ableVariable;
        this.constraints = vector;
        this.positive = bl;
    }

    public AbleSelector(AbleVariable ableVariable, AbleExpression ableExpression, boolean bl) {
        this.selectorVariable = ableVariable;
        this.constraintExpr = ableExpression;
        this.positive = bl;
    }

    public AbleSelector(AbleVariable ableVariable, Object object, boolean bl) throws AbleParException {
        this.selectorVariable = ableVariable;
        if (!(object instanceof AbleExpression)) {
            throw new AbleParException(Able.NlsMsg((String)"Ex_RsSelectorFromExpression", (Object[])new Object[]{object.getClass().getName(), class$com$ibm$able$data$AbleExpression == null ? (class$com$ibm$able$data$AbleExpression = AbleSelector.class$("com.ibm.able.data.AbleExpression")) : class$com$ibm$able$data$AbleExpression}));
        }
        this.constraintExpr = (AbleExpression)object;
        this.positive = bl;
    }

    public AbleSelector(AbleRuleSet ableRuleSet, String string, AbleExpression ableExpression) {
        this.myRuleSet = ableRuleSet;
        this.selectorVariable = ableRuleSet.getVariable(string);
        this.constraintExpr = ableExpression;
    }

    public void addConstraint(Object object) {
        this.constraints.add(object);
    }

    public boolean isPositive() {
        return this.positive;
    }

    public boolean isNegative() {
        return !this.positive;
    }

    public Vector match(AbleWorkingMemory ableWorkingMemory) throws AbleDataException {
        Vector vector = new Vector();
        Class clazz = this.selectorVariable.getDataTypeClass();
        AbstractCollection abstractCollection = ableWorkingMemory.findAllInstances(clazz.getName());
        Iterator iterator = abstractCollection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.selectorVariable.setGenericValue(e);
            if (this.constraints == null) {
                if (!this.checkConstraintExpr(e, ableWorkingMemory)) continue;
                vector.addElement(e);
                continue;
            }
            Boolean bl = this.checkConstraints(e, ableWorkingMemory);
            if (!bl.booleanValue()) continue;
            vector.addElement(e);
        }
        return vector;
    }

    public boolean exists(AbleOclCollection ableOclCollection) throws AbleDataException {
        return this.existsForAll(ableOclCollection, true);
    }

    public boolean forAll(AbleOclCollection ableOclCollection) throws AbleDataException {
        return this.existsForAll(ableOclCollection, false);
    }

    private boolean existsForAll(AbleOclCollection ableOclCollection, boolean bl) throws AbleDataException {
        boolean bl2 = !bl;
        Class clazz = this.selectorVariable.getDataTypeClass();
        Iterator iterator = ableOclCollection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz2 = e.getClass();
            if (clazz2 != clazz) continue;
            this.selectorVariable.setGenericValue(e);
            if (this.constraintExpr.getBooleanValue()) {
                if (!bl) continue;
                bl2 = true;
                break;
            }
            if (bl) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    public boolean isUnique(AbleOclCollection ableOclCollection) throws AbleDataException {
        Class clazz = this.selectorVariable.getDataTypeClass();
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = ableOclCollection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz2 = e.getClass();
            if (clazz2 != clazz) continue;
            this.selectorVariable.setGenericValue(e);
            Object object = this.constraintExpr.getGenericValue();
            if (hashSet.contains(object)) {
                return false;
            }
            hashSet.add(object);
        }
        return true;
    }

    public Object any(AbleOclCollection ableOclCollection) throws AbleDataException {
        Object var2_2 = null;
        Class clazz = this.selectorVariable.getDataTypeClass();
        Iterator iterator = ableOclCollection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz2 = e.getClass();
            if (clazz2 != clazz) continue;
            this.selectorVariable.setGenericValue(e);
            if (!this.constraintExpr.getBooleanValue()) continue;
            var2_2 = e;
            break;
        }
        return var2_2;
    }

    public boolean one(AbleOclCollection ableOclCollection) throws AbleDataException {
        boolean bl = false;
        Class clazz = this.selectorVariable.getDataTypeClass();
        Iterator iterator = ableOclCollection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz2 = e.getClass();
            if (clazz2 != clazz) continue;
            this.selectorVariable.setGenericValue(e);
            if (!this.constraintExpr.getBooleanValue()) continue;
            if (bl) {
                bl = false;
                break;
            }
            bl = true;
        }
        return bl;
    }

    public AbleOclCollection collect(AbleOclCollection ableOclCollection) throws AbleDataException {
        AbleOclCollection ableOclCollection2;
        Class clazz = this.selectorVariable.getDataTypeClass();
        if (ableOclCollection instanceof AbleOclBag) {
            ableOclCollection2 = new AbleOclBag();
        } else if (ableOclCollection instanceof AbleOclOrderedSet) {
            ableOclCollection2 = new AbleOclSequence();
        } else if (ableOclCollection instanceof AbleOclSequence) {
            ableOclCollection2 = new AbleOclSequence();
        } else if (ableOclCollection instanceof AbleOclSet) {
            ableOclCollection2 = new AbleOclBag();
        } else {
            throw new AbleDataException("Unsupported OCL Collection type.");
        }
        Iterator iterator = ableOclCollection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz2 = e.getClass();
            if (clazz2 != clazz) continue;
            this.selectorVariable.setGenericValue(e);
            Object object = this.constraintExpr.getGenericValue();
            ableOclCollection2.add(object);
        }
        return ableOclCollection2;
    }

    public AbleOclCollection select(AbleOclCollection ableOclCollection) throws AbleDataException {
        return this.selectReject(ableOclCollection, true);
    }

    public AbleOclCollection reject(AbleOclCollection ableOclCollection) throws AbleDataException {
        return this.selectReject(ableOclCollection, false);
    }

    private AbleOclCollection selectReject(AbleOclCollection ableOclCollection, boolean bl) throws AbleDataException {
        AbleOclCollection ableOclCollection2;
        if (ableOclCollection instanceof AbleOclBag) {
            ableOclCollection2 = new AbleOclBag();
        } else if (ableOclCollection instanceof AbleOclOrderedSet) {
            ableOclCollection2 = new AbleOclOrderedSet();
        } else if (ableOclCollection instanceof AbleOclSequence) {
            ableOclCollection2 = new AbleOclSequence();
        } else if (ableOclCollection instanceof AbleOclSet) {
            ableOclCollection2 = new AbleOclSet();
        } else {
            throw new AbleDataException("Unsupported OCL Collection type.");
        }
        Class clazz = this.selectorVariable.getDataTypeClass();
        Iterator iterator = ableOclCollection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz2 = e.getClass();
            if (clazz2 != clazz) continue;
            this.selectorVariable.setGenericValue(e);
            if (this.constraintExpr.getBooleanValue()) {
                if (!bl) continue;
                ableOclCollection2.add(e);
                continue;
            }
            if (bl) continue;
            ableOclCollection2.add(e);
        }
        return ableOclCollection2;
    }

    private Boolean checkConstraints(Object object, AbleWorkingMemory ableWorkingMemory) throws AbleDataException {
        Vector vector = this.constraints;
        Boolean bl = null;
        for (int i = 0; i < vector.size(); ++i) {
            AbleAntecedentClause ableAntecedentClause;
            Object e = vector.get(i);
            if (e instanceof AbleAntecedentClause) {
                ableAntecedentClause = (AbleAntecedentClause)e;
                bl = AbleInferenceEngine.evalAntecedentClause(ableAntecedentClause);
                if (bl == null) {
                    return bl;
                }
                if (bl.booleanValue()) continue;
                return bl;
            }
            if (!(e instanceof AblePredicate)) continue;
            ableAntecedentClause = (AblePredicate)e;
            boolean bl2 = ableWorkingMemory.exists(new AblePredicateFact("query", (AblePredicate)ableAntecedentClause, this.myRuleSet));
            if (bl2) {
                bl = Boolean.TRUE;
                continue;
            }
            bl = Boolean.FALSE;
            return bl;
        }
        if (bl == null) {
            bl = Boolean.TRUE;
        }
        return bl;
    }

    private boolean checkConstraintExpr(Object object, AbleWorkingMemory ableWorkingMemory) throws AbleDataException {
        boolean bl = true;
        if (this.constraintExpr != null) {
            bl = this.constraintExpr.getBooleanValue();
        }
        return bl;
    }

    public AbleVariable getSelectorVariable() {
        return this.selectorVariable;
    }

    public Object getSelectorValue() throws AbleDataException {
        return this.selectorVariable.getGenericValue();
    }

    public Vector getConstraints() {
        return this.constraints;
    }

    public AbleExpression getConstraintExpression() {
        return this.constraintExpr;
    }

    public void convertExpressionToClauses(AbleRuleSet ableRuleSet) {
        if (this.constraints == null && this.constraintExpr != null) {
            this.constraints = AbleRuleSet.convertToConjunctiveNormalForm(this.constraintExpr, ableRuleSet);
        }
    }

    public String arlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.selectorVariable instanceof AbleTypedVariable) {
            stringBuffer.append(((AbleTypedVariable)this.selectorVariable).getDataTypeName() + " ");
            stringBuffer.append(this.selectorVariable.getName() + " ");
        } else {
            String string = AbleData.DataType((int)this.selectorVariable.getDataType());
            if (string.equalsIgnoreCase("generic")) {
                string = "Object";
            }
            char[] cArray = string.toCharArray();
            if (Character.isLowerCase(string.charAt(0))) {
                cArray[0] = Character.toUpperCase(cArray[0]);
            }
            stringBuffer.append(String.valueOf(cArray) + " ");
            stringBuffer.append(this.selectorVariable.getName() + " ");
        }
        if (this.positive) {
            stringBuffer.append("  ( ");
        } else {
            stringBuffer.append("! ( ");
        }
        stringBuffer.append(this.constraintExpr.arlCRdString());
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    public String xmlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = " varName=\"" + this.selectorVariable.getName() + "\"";
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer(this.positive ? "" : " pos=\"false\"");
        if (this.selectorVariable instanceof AbleTypedVariable) {
            stringBuffer2.append(" varType=\"" + ((AbleTypedVariable)this.selectorVariable).getDataTypeName() + "\"");
        } else {
            String string2 = AbleData.DataType((int)this.selectorVariable.getDataType());
            if (string2.equalsIgnoreCase("generic")) {
                string2 = "object";
            }
            stringBuffer2.append(" varType=\"" + string2 + "\"");
        }
        stringBuffer.append("      <selector" + string + stringBuffer2.toString() + stringBuffer3.toString() + ">" + Able.LS);
        stringBuffer.append("        <constraint>" + Able.LS);
        stringBuffer.append(this.constraintExpr.xmlCRdString());
        stringBuffer.append("        </constraint>" + Able.LS);
        stringBuffer.append("      </selector>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = " varName=\"" + this.selectorVariable.getName() + "\"";
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer(this.positive ? "" : " pos=\"false\"");
        if (this.selectorVariable instanceof AbleTypedVariable) {
            stringBuffer2.append(" varType=\"" + ((AbleTypedVariable)this.selectorVariable).getDataTypeName() + "\"");
        } else {
            String string2 = AbleData.DataType((int)this.selectorVariable.getDataType());
            if (string2.equalsIgnoreCase("generic")) {
                string2 = "object";
            }
            stringBuffer2.append(" varType=\"" + string2 + "\"");
        }
        stringBuffer.append("      <Pattern" + string + stringBuffer2.toString() + stringBuffer3.toString() + ">" + Able.LS);
        stringBuffer.append("        <constraint>" + Able.LS);
        stringBuffer.append(this.constraintExpr.armlCRdString());
        stringBuffer.append("        </constraint>" + Able.LS);
        stringBuffer.append("      </Pattern>" + Able.LS);
        return stringBuffer.toString();
    }

    public String getTemplateString(Vector vector) throws AbleDataException {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.selectorVariable instanceof AbleTypedVariable) {
            stringBuffer.append(((AbleTypedVariable)this.selectorVariable).getDataTypeName() + " ");
            stringBuffer.append(this.selectorVariable.getName() + " ");
        } else {
            String string = AbleData.DataType((int)this.selectorVariable.getDataType());
            if (string.equalsIgnoreCase("generic")) {
                string = "Object";
            }
            char[] cArray = string.toCharArray();
            if (Character.isLowerCase(string.charAt(0))) {
                cArray[0] = Character.toUpperCase(cArray[0]);
            }
            stringBuffer.append(String.valueOf(cArray) + " ");
            stringBuffer.append(this.selectorVariable.getName() + " ");
        }
        if (this.positive) {
            stringBuffer.append("  ( ");
        } else {
            stringBuffer.append("! ( ");
        }
        stringBuffer.append(this.constraintExpr.getTemplateString(vector));
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlString();
            }
            case 4: {
                return this.arlString();
            }
            case 5: {
                return this.xmlString();
            }
        }
        return this.arlString();
    }

    private String trcString(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(this.selectorVariable.getName() + " ");
        if (this.selectorVariable instanceof AbleTypedVariable) {
            stringBuffer.append(((AbleTypedVariable)this.selectorVariable).getDataTypeName() + " ");
        } else {
            String string = AbleData.DataType((int)this.selectorVariable.getDataType());
            if (string.equalsIgnoreCase("generic")) {
                string = "Object";
            }
            char[] cArray = string.toCharArray();
            if (Character.isLowerCase(string.charAt(0))) {
                cArray[0] = Character.toUpperCase(cArray[0]);
            }
            stringBuffer.append(String.valueOf(cArray) + " ");
        }
        if (this.positive) {
            stringBuffer.append("  ( ");
        } else {
            stringBuffer.append("! ( ");
        }
        if (this.constraints != null) {
            for (int i = 0; i < this.constraints.size(); ++i) {
                stringBuffer.append(((AbleAntecedentClause)this.constraints.elementAt(i)).traceString(n));
                if (i >= this.constraints.size() - 1) continue;
                stringBuffer.append(", ");
            }
        } else {
            stringBuffer.append(this.constraintExpr.traceString(n));
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

