/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.AbleLogger;
import com.ibm.able.data.AbleArrayVariable;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataContext;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleReferences;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleAssertionRule;
import com.ibm.able.rules.AbleClauseReferences;
import com.ibm.able.rules.AbleConditionalRule;
import com.ibm.able.rules.AbleCorrelationRule;
import com.ibm.able.rules.AbleIfThenElseRule;
import com.ibm.able.rules.AbleInferenceEngine;
import com.ibm.able.rules.AbleIterationRule;
import com.ibm.able.rules.AbleParException;
import com.ibm.able.rules.AblePatternMatchRule;
import com.ibm.able.rules.AblePlanningRule;
import com.ibm.able.rules.AblePolicyRule;
import com.ibm.able.rules.AblePredicateRule;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleSet;
import com.ibm.able.rules.AbleRuleTemplate;
import com.ibm.able.rules.AbleSwitchRule;
import com.ibm.able.rules.AbleTreeRule;
import com.ibm.able.rules.AbleWorkingMemory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class AbleRuleBlock
implements Serializable {
    static final long serialVersionUID = 2001021300000000001L;
    static String clsNm = "AbleRuleBlock";
    public static final String RuleBlockInit = "init()";
    public static final String RuleBlockProcess = "process()";
    public static final String RuleBlockPreProcess = "preProcess()";
    public static final String RuleBlockPostProcess = "postProcess()";
    public static final String RuleBlockCatch = "catch()";
    public static final String RuleBlockQuitAll = "quitAll()";
    public static final String RuleBlockProcessTimerEvent = "processTimerEvent()";
    public static final String RuleBlockProcessAbleEvent = "processAbleEvent()";
    protected String myName;
    protected AbleInferenceEngine myInferenceEngine = null;
    protected Vector myRuleList = new Vector();
    protected Vector myAstRuleList = new Vector();
    protected Vector myCndRuleList = new Vector();
    protected Vector myIfThenElseRuleList = new Vector();
    protected Vector myPolicyRuleList = new Vector();
    protected Vector myPatternMatchRuleList = new Vector();
    protected Vector myPredicateRuleList = new Vector();
    protected Vector myIterationRuleList = new Vector();
    protected Vector myCorrelationRuleList = new Vector();
    protected Vector myPlanningRuleList = new Vector();
    protected Vector myTreeRuleList = new Vector();
    protected boolean myProcessedFlag = false;
    protected String myEngineType = "Script";
    protected AbleRuleSet myRuleSet = null;
    protected AbleLogger myTrace = null;
    protected Hashtable myControlParameterList = new Hashtable();
    protected Vector myControlParameters = new Vector();
    protected String myReturnType;
    protected Object myReturnValue = null;
    protected String myComment = "";
    protected Hashtable myVariableList = new Hashtable();
    protected Vector myVariableOrder = new Vector();
    protected Vector myFormalParameters;
    protected String myFormalSignature = "";
    protected String myRuleBlockKey;
    protected Map myProperties = new Hashtable();
    static /* synthetic */ Class class$com$ibm$able$rules$AbleInferenceEngine;
    static /* synthetic */ Class class$com$ibm$able$rules$AbleRuleSet;
    static /* synthetic */ Class class$com$ibm$able$AbleLogger;
    static /* synthetic */ Class class$com$ibm$able$rules$AbleRuleBlock;

    public static final boolean reservedRuleBlock(String string) {
        String string2 = string + "()";
        return string2.equalsIgnoreCase(RuleBlockCatch) || string2.equalsIgnoreCase(RuleBlockInit) || string2.equalsIgnoreCase(RuleBlockPostProcess) || string2.equalsIgnoreCase(RuleBlockPreProcess) || string2.equalsIgnoreCase(RuleBlockProcess) || string2.equalsIgnoreCase(RuleBlockProcessAbleEvent) || string2.equalsIgnoreCase(RuleBlockProcessTimerEvent) || string2.equalsIgnoreCase(RuleBlockQuitAll);
    }

    public AbleRuleBlock(String string, AbleRuleSet ableRuleSet, AbleLogger ableLogger, String string2) {
        this.myName = string;
        this.myRuleSet = ableRuleSet;
        this.myTrace = ableLogger;
        this.myReturnType = string2;
    }

    public AbleRuleBlock(String string, AbleRuleSet ableRuleSet, AbleLogger ableLogger, String string2, String string3, Vector vector, String string4, String string5, Map map) {
        this.myName = string;
        this.myRuleSet = ableRuleSet;
        this.myTrace = ableLogger;
        this.myReturnType = string2;
        this.myFormalSignature = string3;
        this.setFormalParameters(vector);
        this.myEngineType = string4;
        this.myComment = string5;
        this.myProperties = map;
        this.myRuleBlockKey = string + string3;
    }

    public void init() throws AbleException, AbleParException, AbleDataException {
        Object object;
        Object object2;
        Class<?> clazz = null;
        String string = this.myRuleSet.getInferenceEngineClassName(this.myEngineType);
        if (string == null) {
            AbleParException ableParException = new AbleParException(Able.NlsMsg((String)"Ex_IeUnknownInferenceEngineType", (Object[])new Object[]{this.myEngineType}));
            if (this.myRuleSet.isBaseTraceLow()) {
                this.myTrace.text(262144L, (Object)this, RuleBlockInit, ableParException.getLocalizedMessage());
            }
            throw ableParException;
        }
        try {
            clazz = this.myRuleSet.getClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            AbleParException ableParException = new AbleParException(Able.NlsMsg((String)"Ex_IeCannotFindEngineClass", (Object[])new Object[]{string, this.myEngineType}));
            if (this.myRuleSet.isBaseTraceLow()) {
                this.myTrace.text(262144L, (Object)this, RuleBlockInit, ableParException.getLocalizedMessage());
            }
            throw ableParException;
        }
        if ((class$com$ibm$able$rules$AbleInferenceEngine == null ? (class$com$ibm$able$rules$AbleInferenceEngine = AbleRuleBlock.class$("com.ibm.able.rules.AbleInferenceEngine")) : class$com$ibm$able$rules$AbleInferenceEngine).isAssignableFrom(clazz)) {
            object2 = null;
            object = new Class[]{class$com$ibm$able$rules$AbleRuleSet == null ? (class$com$ibm$able$rules$AbleRuleSet = AbleRuleBlock.class$("com.ibm.able.rules.AbleRuleSet")) : class$com$ibm$able$rules$AbleRuleSet, class$com$ibm$able$AbleLogger == null ? (class$com$ibm$able$AbleLogger = AbleRuleBlock.class$("com.ibm.able.AbleLogger")) : class$com$ibm$able$AbleLogger, class$com$ibm$able$rules$AbleRuleBlock == null ? (class$com$ibm$able$rules$AbleRuleBlock = AbleRuleBlock.class$("com.ibm.able.rules.AbleRuleBlock")) : class$com$ibm$able$rules$AbleRuleBlock};
            try {
                object2 = clazz.getConstructor((Class<?>)object);
            }
            catch (Exception exception) {
                AbleParException ableParException = new AbleParException(Able.NlsMsg((String)"Ex_IeCannotFindCtorForEngine", (Object[])new Object[]{this.myEngineType}));
                if (this.myRuleSet.isBaseTraceLow()) {
                    this.myTrace.text(262144L, (Object)this, RuleBlockInit, ableParException.getLocalizedMessage());
                }
                throw ableParException;
            }
            Object[] objectArray = new Object[]{this.myRuleSet, this.myTrace, this};
            try {
                this.myInferenceEngine = (AbleInferenceEngine)((Constructor)object2).newInstance(objectArray);
            }
            catch (Exception exception) {
                AbleParException ableParException = new AbleParException(Able.NlsMsg((String)"Ex_IeCannotCreateEngineInstance", (Object[])new Object[]{this.myEngineType, exception.getLocalizedMessage()}));
                if (this.myRuleSet.isBaseTraceLow()) {
                    this.myTrace.text(262144L, (Object)this, RuleBlockInit, ableParException.getLocalizedMessage());
                }
                throw ableParException;
            }
        }
        if (!this.myInferenceEngine.isRuleBlockValid(this)) {
            object2 = Able.NlsMsg((String)"Ex_IeRuleBlockIsInvalid", (Object[])new Object[]{this.myName, this.myEngineType});
            object2 = (String)object2 + Able.LS + this.myRuleSet.getIsExReason();
            object = new AbleParException((String)object2);
            if (this.myRuleSet.isBaseTraceLow()) {
                this.myTrace.text(262144L, (Object)this, RuleBlockInit, object.getLocalizedMessage());
            }
            throw object;
        }
        this.myInferenceEngine.setDebugLevel(this.myRuleSet.getDebugLevel());
        this.myInferenceEngine.init();
    }

    public void process() throws AbleDataException {
        int n;
        for (int i = n = this.myFormalParameters.size(); i < this.myVariableOrder.size(); ++i) {
            AbleVariable ableVariable = (AbleVariable)this.myVariableOrder.get(i);
            ableVariable.reset();
        }
        this.myInferenceEngine.infer(this);
    }

    public final void checkTimePeriodPreConditions(Calendar calendar) throws AbleDataException {
        Vector vector = this.myRuleList;
        AbleRule ableRule = null;
        try {
            for (int i = 0; i < vector.size(); ++i) {
                ableRule = (AbleRule)vector.get(i);
                ableRule.checkTimePeriodPreConditions(calendar);
            }
        }
        catch (AbleDataException ableDataException) {
            throw new AbleDataException(this.myName + " { " + ableRule.getId() + "(" + ableRule.getLabel() + ") }" + ableRule.arlString());
        }
    }

    public final void setDebugLevel(int n) {
        this.myInferenceEngine.setDebugLevel(n);
    }

    public Hashtable getControlParameters() {
        return this.myControlParameterList;
    }

    public void setControlParameters(Hashtable hashtable) throws AbleDataException {
        this.myControlParameterList = hashtable;
        this.myInferenceEngine.setControlParameters(hashtable);
    }

    public void setControlParameter(String string, Object object) throws AbleDataException {
        this.myInferenceEngine.setControlParameter(string, object);
    }

    public Object getControlParameter(String string) throws AbleDataException {
        return this.myInferenceEngine.getControlParameter(string);
    }

    public void setReturnValue(Object object) {
        this.myReturnValue = object;
    }

    public Object getReturnValue() {
        return this.myReturnValue;
    }

    public String getReturnType() {
        return this.myReturnType;
    }

    public String getName() {
        return this.myName;
    }

    public String getRuleBlockKey() {
        return this.myRuleBlockKey;
    }

    public void setComment(String string) {
        this.myComment = string;
    }

    public String getComment() {
        return this.myComment;
    }

    public String getArlComment() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myComment == null || this.myComment.length() == 0) {
            if (this.myProperties.isEmpty()) {
                return "";
            }
            stringBuffer.append("/**");
            stringBuffer.append(Able.LS);
            stringBuffer.append(this.arlProps());
            stringBuffer.append("*/");
        } else {
            stringBuffer.append("/**");
            stringBuffer.append(Able.LS);
            stringBuffer.append(this.myComment);
            if (!this.myProperties.isEmpty()) {
                stringBuffer.append(this.arlProps());
            }
            stringBuffer.append("   */");
        }
        return stringBuffer.toString();
    }

    private String arlProps() {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = new Vector(this.myProperties.keySet());
        Collections.sort(vector);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.myProperties.get(string);
            stringBuffer.append("   * @prop ");
            stringBuffer.append(string);
            stringBuffer.append(" = \"");
            stringBuffer.append(string2);
            stringBuffer.append("\"");
            stringBuffer.append(Able.LS);
        }
        return stringBuffer.toString();
    }

    public AbleInferenceEngine getInferenceEngine() {
        return this.myInferenceEngine;
    }

    public AbleWorkingMemory getWorkingMemory() {
        return this.myInferenceEngine.getWorkingMemory();
    }

    public void setEngineType(String string) {
        this.myEngineType = string;
    }

    public final String getEngineType() {
        return this.myEngineType;
    }

    protected void addAssertion(AbleAssertionRule ableAssertionRule) {
        this.myRuleList.addElement(ableAssertionRule);
        this.myAstRuleList.addElement(ableAssertionRule);
    }

    protected void addConditionalRule(AbleConditionalRule ableConditionalRule) {
        this.myRuleList.addElement(ableConditionalRule);
        this.myCndRuleList.addElement(ableConditionalRule);
    }

    protected void addIfThenElseRule(AbleIfThenElseRule ableIfThenElseRule) {
        this.myRuleList.addElement(ableIfThenElseRule);
        this.myIfThenElseRuleList.addElement(ableIfThenElseRule);
    }

    protected void addPolicyRule(AblePolicyRule ablePolicyRule) {
        this.myRuleList.addElement(ablePolicyRule);
        this.myPolicyRuleList.addElement(ablePolicyRule);
    }

    protected void addPatternMatchRule(AblePatternMatchRule ablePatternMatchRule) {
        this.myRuleList.addElement(ablePatternMatchRule);
        this.myPatternMatchRuleList.addElement(ablePatternMatchRule);
    }

    protected void addPredicateRule(AblePredicateRule ablePredicateRule) {
        this.myRuleList.addElement(ablePredicateRule);
        this.myPredicateRuleList.addElement(ablePredicateRule);
    }

    protected void addIterationRule(AbleIterationRule ableIterationRule) {
        this.myRuleList.addElement(ableIterationRule);
        this.myIterationRuleList.addElement(ableIterationRule);
    }

    protected void addCorrelationRule(AbleCorrelationRule ableCorrelationRule) {
        this.myRuleList.addElement(ableCorrelationRule);
        this.myCorrelationRuleList.addElement(ableCorrelationRule);
    }

    protected void addPlanningRule(AblePlanningRule ablePlanningRule) {
        this.myRuleList.addElement(ablePlanningRule);
        this.myPlanningRuleList.addElement(ablePlanningRule);
    }

    protected void addTreeRule(AbleTreeRule ableTreeRule) {
        this.myRuleList.addElement(ableTreeRule);
        this.myTreeRuleList.addElement(ableTreeRule);
    }

    protected void addSwitchRule(AbleSwitchRule ableSwitchRule) {
        this.myRuleList.addElement(ableSwitchRule);
    }

    protected void addRule(AbleRule ableRule) {
        this.myRuleList.addElement(ableRule);
        if (ableRule instanceof AbleAssertionRule) {
            this.myAstRuleList.addElement(ableRule);
        } else if (ableRule instanceof AbleConditionalRule) {
            this.myCndRuleList.addElement(ableRule);
        } else if (ableRule instanceof AbleIfThenElseRule) {
            this.myIfThenElseRuleList.addElement(ableRule);
        } else if (ableRule instanceof AblePolicyRule) {
            this.myPolicyRuleList.addElement(ableRule);
        } else if (ableRule instanceof AblePatternMatchRule) {
            this.myPatternMatchRuleList.addElement(ableRule);
        } else if (ableRule instanceof AblePredicateRule) {
            this.myPredicateRuleList.addElement(ableRule);
        } else if (ableRule instanceof AbleIterationRule) {
            this.myIterationRuleList.addElement(ableRule);
        } else if (ableRule instanceof AbleCorrelationRule) {
            this.myCorrelationRuleList.addElement(ableRule);
        } else if (ableRule instanceof AblePlanningRule) {
            this.myPlanningRuleList.addElement(ableRule);
        } else if (ableRule instanceof AbleTreeRule) {
            this.myTreeRuleList.addElement(ableRule);
        }
    }

    protected void insertRuleAt(int n, AbleRule ableRule) {
        this.myRuleList.add(n, ableRule);
        int n2 = 0;
        if (ableRule instanceof AbleAssertionRule) {
            AbleRule ableRule2;
            for (int i = 0; i < n && (ableRule2 = (AbleRule)this.myRuleList.get(i)) != ableRule; ++i) {
                if (!(ableRule2 instanceof AbleAssertionRule)) continue;
                ++n2;
            }
            this.myAstRuleList.insertElementAt(ableRule, n2);
        } else if (ableRule instanceof AbleConditionalRule) {
            AbleRule ableRule3;
            for (int i = 0; i < n && (ableRule3 = (AbleRule)this.myRuleList.get(i)) != ableRule; ++i) {
                if (!(ableRule3 instanceof AbleConditionalRule)) continue;
                ++n2;
            }
            this.myCndRuleList.insertElementAt(ableRule, n2);
        } else if (ableRule instanceof AbleIfThenElseRule) {
            AbleRule ableRule4;
            for (int i = 0; i < n && (ableRule4 = (AbleRule)this.myRuleList.get(i)) != ableRule; ++i) {
                if (!(ableRule4 instanceof AbleIfThenElseRule)) continue;
                ++n2;
            }
            this.myIfThenElseRuleList.insertElementAt(ableRule, n2);
        } else if (ableRule instanceof AblePolicyRule) {
            AbleRule ableRule5;
            for (int i = 0; i < n && (ableRule5 = (AbleRule)this.myRuleList.get(i)) != ableRule; ++i) {
                if (!(ableRule5 instanceof AblePolicyRule)) continue;
                ++n2;
            }
            this.myPolicyRuleList.insertElementAt(ableRule, n2);
        } else if (ableRule instanceof AblePatternMatchRule) {
            AbleRule ableRule6;
            for (int i = 0; i < n && (ableRule6 = (AbleRule)this.myRuleList.get(i)) != ableRule; ++i) {
                if (!(ableRule6 instanceof AblePatternMatchRule)) continue;
                ++n2;
            }
            this.myPatternMatchRuleList.insertElementAt(ableRule, n2);
        } else if (ableRule instanceof AblePredicateRule) {
            AbleRule ableRule7;
            for (int i = 0; i < n && (ableRule7 = (AbleRule)this.myRuleList.get(i)) != ableRule; ++i) {
                if (!(ableRule7 instanceof AblePredicateRule)) continue;
                ++n2;
            }
            this.myPredicateRuleList.insertElementAt(ableRule, n2);
        } else if (ableRule instanceof AbleIterationRule) {
            AbleRule ableRule8;
            for (int i = 0; i < n && (ableRule8 = (AbleRule)this.myRuleList.get(i)) != ableRule; ++i) {
                if (!(ableRule8 instanceof AbleIterationRule)) continue;
                ++n2;
            }
            this.myIterationRuleList.insertElementAt(ableRule, n2);
        } else if (ableRule instanceof AbleCorrelationRule) {
            AbleRule ableRule9;
            for (int i = 0; i < n && (ableRule9 = (AbleRule)this.myRuleList.get(i)) != ableRule; ++i) {
                if (!(ableRule9 instanceof AbleCorrelationRule)) continue;
                ++n2;
            }
            this.myCorrelationRuleList.insertElementAt(ableRule, n2);
        } else if (ableRule instanceof AblePlanningRule) {
            AbleRule ableRule10;
            for (int i = 0; i < n && (ableRule10 = (AbleRule)this.myRuleList.get(i)) != ableRule; ++i) {
                if (!(ableRule10 instanceof AblePlanningRule)) continue;
                ++n2;
            }
            this.myPlanningRuleList.insertElementAt(ableRule, n2);
        } else if (ableRule instanceof AbleTreeRule) {
            AbleRule ableRule11;
            for (int i = 0; i < n && (ableRule11 = (AbleRule)this.myRuleList.get(i)) != ableRule; ++i) {
                if (!(ableRule11 instanceof AbleTreeRule)) continue;
                ++n2;
            }
            this.myTreeRuleList.insertElementAt(ableRule, n2);
        }
    }

    protected void removeRule(AbleRule ableRule) {
        this.myRuleList.removeElement(ableRule);
        if (ableRule instanceof AbleAssertionRule) {
            this.myAstRuleList.removeElement(ableRule);
        } else if (ableRule instanceof AbleConditionalRule) {
            this.myCndRuleList.removeElement(ableRule);
        } else if (ableRule instanceof AbleIfThenElseRule) {
            this.myIfThenElseRuleList.removeElement(ableRule);
        } else if (ableRule instanceof AblePolicyRule) {
            this.myPolicyRuleList.removeElement(ableRule);
        } else if (ableRule instanceof AblePatternMatchRule) {
            this.myPatternMatchRuleList.removeElement(ableRule);
        } else if (ableRule instanceof AblePredicateRule) {
            this.myPredicateRuleList.removeElement(ableRule);
        } else if (ableRule instanceof AbleIterationRule) {
            this.myIterationRuleList.removeElement(ableRule);
        } else if (ableRule instanceof AbleCorrelationRule) {
            this.myCorrelationRuleList.removeElement(ableRule);
        } else if (ableRule instanceof AblePlanningRule) {
            this.myPlanningRuleList.removeElement(ableRule);
        } else if (ableRule instanceof AbleTreeRule) {
            this.myTreeRuleList.removeElement(ableRule);
        }
    }

    protected void replaceRule(AbleRule ableRule, AbleRule ableRule2) {
        int n = this.myRuleList.indexOf(ableRule);
        this.removeRule(ableRule);
        this.insertRuleAt(n, ableRule2);
    }

    protected void replaceLabeledRule(String string, AbleRule ableRule) {
        AbleRule ableRule2 = this.getRule(string);
        if (ableRule2 != null) {
            this.replaceRule(ableRule2, ableRule);
        }
    }

    public final AbleRule getRule(String string) {
        Enumeration enumeration = this.myRuleList.elements();
        while (enumeration.hasMoreElements()) {
            AbleRule ableRule = (AbleRule)enumeration.nextElement();
            if (!string.equals(ableRule.getLabel())) continue;
            return ableRule;
        }
        return null;
    }

    public Vector getRules() {
        return this.myRuleList;
    }

    public Vector getEnabledRules() {
        Vector<AbleRule> vector = new Vector<AbleRule>();
        for (int i = 0; i < this.myRuleList.size(); ++i) {
            AbleRule ableRule = (AbleRule)this.myRuleList.get(i);
            if (!ableRule.isEnabled() || ableRule.isTemplate()) continue;
            vector.add(ableRule);
        }
        return vector;
    }

    public Vector getAssertions() {
        return this.myAstRuleList;
    }

    public Vector getEnabledAssertions() {
        Vector<AbleRule> vector = new Vector<AbleRule>();
        for (int i = 0; i < this.myAstRuleList.size(); ++i) {
            AbleRule ableRule = (AbleRule)this.myAstRuleList.get(i);
            if (!ableRule.isEnabled() || ableRule.isTemplate()) continue;
            vector.add(ableRule);
        }
        return vector;
    }

    public Vector getConditionalRules() {
        return this.myCndRuleList;
    }

    public Vector getEnabledConditionalRules() {
        Vector<AbleRule> vector = new Vector<AbleRule>();
        for (int i = 0; i < this.myCndRuleList.size(); ++i) {
            AbleRule ableRule = (AbleRule)this.myCndRuleList.get(i);
            if (!ableRule.isEnabled() || ableRule.isTemplate()) continue;
            vector.add(ableRule);
        }
        return vector;
    }

    public Vector getIfThenElseRules() {
        return this.myIfThenElseRuleList;
    }

    public Vector getEnabledIfThenElseRules() {
        Vector<AbleRule> vector = new Vector<AbleRule>();
        for (int i = 0; i < this.myIfThenElseRuleList.size(); ++i) {
            AbleRule ableRule = (AbleRule)this.myIfThenElseRuleList.get(i);
            if (!ableRule.isEnabled() || ableRule.isTemplate()) continue;
            vector.add(ableRule);
        }
        return vector;
    }

    public Vector getPolicyRules() {
        return this.myPolicyRuleList;
    }

    public Vector getEnabledPolicyRules() {
        Vector<AbleRule> vector = new Vector<AbleRule>();
        for (int i = 0; i < this.myPolicyRuleList.size(); ++i) {
            AbleRule ableRule = (AbleRule)this.myPolicyRuleList.get(i);
            if (!ableRule.isEnabled() || ableRule.isTemplate()) continue;
            vector.add(ableRule);
        }
        return vector;
    }

    public Vector getPatternMatchRules() {
        return this.myPatternMatchRuleList;
    }

    public Vector getEnabledPatternMatchRules() {
        Vector<AbleRule> vector = new Vector<AbleRule>();
        for (int i = 0; i < this.myPatternMatchRuleList.size(); ++i) {
            AbleRule ableRule = (AbleRule)this.myPatternMatchRuleList.get(i);
            if (!ableRule.isEnabled() || ableRule.isTemplate()) continue;
            vector.add(ableRule);
        }
        return vector;
    }

    public Vector getPredicateRules() {
        return this.myPredicateRuleList;
    }

    public Vector getEnabledPredicateRules() {
        Vector<AbleRule> vector = new Vector<AbleRule>();
        for (int i = 0; i < this.myPredicateRuleList.size(); ++i) {
            AbleRule ableRule = (AbleRule)this.myPredicateRuleList.get(i);
            if (!ableRule.isEnabled() || ableRule.isTemplate()) continue;
            vector.add(ableRule);
        }
        return vector;
    }

    public Vector getIterationRules() {
        return this.myIterationRuleList;
    }

    public Vector getEnabledIterationRules() {
        Vector<AbleRule> vector = new Vector<AbleRule>();
        for (int i = 0; i < this.myIterationRuleList.size(); ++i) {
            AbleRule ableRule = (AbleRule)this.myIterationRuleList.get(i);
            if (!ableRule.isEnabled() || ableRule.isTemplate()) continue;
            vector.add(ableRule);
        }
        return vector;
    }

    public Vector getCorrelationRules() {
        return this.myCorrelationRuleList;
    }

    public Vector getEnabledCorrelationRules() {
        Vector<AbleRule> vector = new Vector<AbleRule>();
        for (int i = 0; i < this.myCorrelationRuleList.size(); ++i) {
            AbleRule ableRule = (AbleRule)this.myCorrelationRuleList.get(i);
            if (!ableRule.isEnabled() || ableRule.isTemplate()) continue;
            vector.add(ableRule);
        }
        return vector;
    }

    public Vector getPlanningRules() {
        return this.myPlanningRuleList;
    }

    public Vector getEnabledPlanningRules() {
        Vector<AbleRule> vector = new Vector<AbleRule>();
        for (int i = 0; i < this.myPlanningRuleList.size(); ++i) {
            AbleRule ableRule = (AbleRule)this.myPlanningRuleList.get(i);
            if (!ableRule.isEnabled() || ableRule.isTemplate()) continue;
            vector.add(ableRule);
        }
        return vector;
    }

    public Vector getTreeRules() {
        return this.myPlanningRuleList;
    }

    public Vector getEnabledTreeRules() {
        Vector<AbleRule> vector = new Vector<AbleRule>();
        for (int i = 0; i < this.myTreeRuleList.size(); ++i) {
            AbleRule ableRule = (AbleRule)this.myTreeRuleList.get(i);
            if (!ableRule.isEnabled() || ableRule.isTemplate()) continue;
            vector.add(ableRule);
        }
        return vector;
    }

    public String arlString() {
        AbleVariable ableVariable;
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("  ");
        stringBuffer.append(this.getArlComment());
        stringBuffer.append(Able.LS);
        stringBuffer.append("  ");
        stringBuffer.append(this.myReturnType);
        stringBuffer.append(" ");
        stringBuffer.append(this.myName);
        stringBuffer.append("(");
        for (n = 0; n < this.myFormalParameters.size(); ++n) {
            ableVariable = (AbleVariable)this.myFormalParameters.get(n);
            stringBuffer.append(ableVariable.getDataTypeName());
            stringBuffer.append(" ");
            stringBuffer.append(ableVariable.getName());
            if (n == this.myFormalParameters.size() - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(") using ");
        stringBuffer.append(this.myEngineType);
        stringBuffer.append(" {");
        stringBuffer.append(Able.LS);
        if (this.myVariableOrder.size() > this.myFormalParameters.size()) {
            stringBuffer.append("    variables {");
            stringBuffer.append(Able.LS);
            for (n = 0; n < this.myVariableOrder.size(); ++n) {
                ableVariable = (AbleVariable)this.myVariableOrder.elementAt(n);
                if (this.myFormalParameters.contains(ableVariable)) continue;
                stringBuffer.append(ableVariable.arlDclString());
            }
            stringBuffer.append("    } ");
            stringBuffer.append(Able.LS);
            stringBuffer.append(Able.LS);
        }
        for (n = 0; n < this.myRuleList.size(); ++n) {
            stringBuffer.append(((AbleRule)this.myRuleList.elementAt(n)).arlString());
            stringBuffer.append(Able.LS);
        }
        stringBuffer.append("  }");
        return stringBuffer.toString();
    }

    public String xmlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("  <ruleBlock block=\"" + this.myName + "\" dataType=\"" + this.myReturnType + "\" comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\">" + Able.LS);
        stringBuffer.append("    <inference   method=\"" + this.myEngineType + "\"/>" + Able.LS);
        for (int i = 0; i < this.myRuleList.size(); ++i) {
            stringBuffer.append(((AbleRule)this.myRuleList.elementAt(i)).xmlString());
            if (i >= this.myRuleList.size() - 1) continue;
            stringBuffer.append(Able.LS);
        }
        stringBuffer.append("  </ruleBlock>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlString() {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.myFormalParameters.size();
        stringBuffer.append("  <ruleBlock name=\"" + this.myName + "\" returnType=\"" + this.myReturnType + "\" engine=\"" + this.myEngineType + "\" comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\">" + Able.LS);
        stringBuffer.append("    <parameters>" + Able.LS);
        for (n = 0; n < n2; ++n) {
            object = (AbleVariable)this.myFormalParameters.get(n);
            stringBuffer.append("      <formalParameter ");
            stringBuffer.append(" type=\"" + object.getDataTypeName() + "\"" + " name=\"" + object.getName() + "\"" + " isArray=\"" + (object instanceof AbleArrayVariable ? "true" : "false") + "\"");
            stringBuffer.append("/>" + Able.LS);
        }
        stringBuffer.append("    </parameters>" + Able.LS);
        if (this.myVariableOrder.size() - n2 > 0) {
            stringBuffer.append("  <variables>" + Able.LS);
            for (n = n2; n < this.myVariableOrder.size(); ++n) {
                object = (AbleVariable)this.myVariableOrder.elementAt(n);
                stringBuffer.append(object.armlDclString());
                if (n >= this.myVariableOrder.size() - 1) continue;
                stringBuffer.append(Able.LS);
            }
            stringBuffer.append("  </variables>" + Able.LS + Able.LS);
        }
        Iterator iterator = this.myProperties.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            String string = (String)this.myProperties.get(object);
            stringBuffer.append("    <properties name=\"" + (String)object + "\" value=\"" + string + "\"/>" + Able.LS);
        }
        for (int i = 0; i < this.myRuleList.size(); ++i) {
            stringBuffer.append(((AbleRule)this.myRuleList.elementAt(i)).armlString());
            if (i >= this.myRuleList.size() - 1) continue;
            stringBuffer.append(Able.LS);
        }
        stringBuffer.append("  </ruleBlock>" + Able.LS);
        return stringBuffer.toString();
    }

    public void reset() {
        this.myInferenceEngine.reset();
    }

    public void setProcessed(boolean bl) {
        this.myProcessedFlag = bl;
    }

    public boolean isProcessed() {
        return this.myProcessedFlag;
    }

    public Vector getRuleTemplates() throws AbleDataException {
        Vector<AbleRuleTemplate> vector = new Vector<AbleRuleTemplate>();
        for (int i = 0; i < this.myRuleList.size(); ++i) {
            AbleRule ableRule = (AbleRule)this.myRuleList.get(i);
            if (!ableRule.isTemplate()) continue;
            vector.add(new AbleRuleTemplate(this.myRuleSet, this, ableRule));
        }
        return vector;
    }

    public String getTemplateString(Vector vector) throws AbleDataException {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("  " + this.getArlComment() + Able.LS);
        stringBuffer.append(this.myReturnType + "  " + this.myName + "() using " + this.myEngineType + " '{'" + Able.LS);
        for (int i = 0; i < this.myRuleList.size(); ++i) {
            AbleRule ableRule = (AbleRule)this.myRuleList.get(i);
            if (!ableRule.isTemplate()) {
                stringBuffer.append(ableRule.getTemplateString(vector));
            } else {
                stringBuffer.append(AbleRuleSet.wrapBraces(ableRule.arlString()));
            }
            stringBuffer.append(Able.LS);
        }
        stringBuffer.append("  '}'");
        return stringBuffer.toString();
    }

    public Vector getTemplateVars(AbleRuleSet ableRuleSet) throws AbleDataException {
        Vector<AbleVariable> vector = new Vector<AbleVariable>();
        for (int i = 0; i < this.myRuleList.size(); ++i) {
            Vector vector2 = ((AbleRule)this.myRuleList.elementAt(i)).getTemplateVars(this.myRuleSet);
            for (int j = 0; j < vector2.size(); ++j) {
                AbleVariable ableVariable = (AbleVariable)vector2.get(j);
                if (vector.contains(ableVariable)) continue;
                vector.add(ableVariable);
            }
        }
        return vector;
    }

    public int getRulesFiredCount() {
        if (this.myInferenceEngine != null) {
            return this.myInferenceEngine.getRulesFiredCount();
        }
        return 0;
    }

    public void setFormalParameters(Vector vector) {
        this.myFormalParameters = (Vector)vector.clone();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            AbleVariable ableVariable = (AbleVariable)vector.get(i);
            this.myVariableList.put(ableVariable.getName(), ableVariable);
            this.myVariableOrder.add(ableVariable);
            if (i == 0) {
                stringBuffer.append("(" + ableVariable.getDataTypeName());
                continue;
            }
            stringBuffer.append("," + ableVariable.getDataTypeName());
        }
        stringBuffer.append(")");
        this.myFormalSignature = stringBuffer.toString();
    }

    public void processInputs(Object[] objectArray) throws AbleDataException {
        for (int i = 0; i < this.myFormalParameters.size(); ++i) {
            AbleVariable ableVariable = (AbleVariable)this.myFormalParameters.get(i);
            try {
                ableVariable.setGenericValue(((AbleRd)objectArray[i]).getGenericValue());
                continue;
            }
            catch (AbleDataException ableDataException) {
                throw new AbleDataException("Error processing input parameters on ruleblock " + this.myName);
            }
        }
    }

    public AbleVariable addRuleBlockVariable(String string, String string2) throws AbleParException {
        AbleVariable ableVariable = null;
        if (this.myVariableList.containsKey(string)) {
            throw new AbleParException(Able.NlsMsg((String)"Ex_RsNamedVarExists", (Object[])new Object[]{string}));
        }
        ableVariable = this.myRuleSet.addLocalVariable(string, string2);
        this.myVariableList.put(string, ableVariable);
        this.myVariableOrder.add(ableVariable);
        return ableVariable;
    }

    public boolean isRuleBlockVariable(String string) {
        return this.myVariableList.containsKey(string);
    }

    public void addVariable(AbleVariable ableVariable) throws AbleParException {
        String string = ableVariable.getName();
        int n = ableVariable.getDataType();
        if (this.myVariableList.containsKey(string)) {
            throw new AbleParException(Able.NlsMsg((String)"Ex_RsNamedVarExists", (Object[])new Object[]{string}));
        }
        this.myVariableList.put(string, ableVariable);
        this.myVariableOrder.addElement(ableVariable);
        ableVariable.setContext((AbleDataContext)this.myRuleSet);
        ableVariable.setReferences((AbleReferences)new AbleClauseReferences(this.myRuleSet));
    }

    public AbleVariable getVariable(String string) {
        return (AbleVariable)this.myVariableList.get(string);
    }

    public void setProperty(String string, String string2) {
        this.myProperties.put(string, string2);
    }

    public String getProperty(String string) {
        return (String)this.myProperties.get(string);
    }

    public String removeProperty(String string) {
        return (String)this.myProperties.remove(string);
    }

    public void setProperties(Map map) {
        if (map != null) {
            this.myProperties = map;
        }
    }

    public Map getProperties() {
        return this.myProperties;
    }

    public String toString() {
        return this.arlString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlString();
            }
            case 4: {
                return this.arlString();
            }
            case 5: {
                return this.xmlString();
            }
        }
        return this.arlString();
    }

    private String trcString(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(this.myReturnType + "  " + this.myName + " using " + this.myEngineType + " {" + Able.LS);
        for (int i = 0; i < this.myRuleList.size(); ++i) {
            stringBuffer.append(((AbleRule)this.myRuleList.elementAt(i)).traceString(n));
        }
        stringBuffer.append("  }");
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.myProperties == null) {
            this.myProperties = new Hashtable();
        }
        if (this.myFormalParameters == null) {
            this.myFormalParameters = new Vector();
        }
        if (this.myVariableOrder == null) {
            this.myVariableOrder = new Vector();
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

