/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.data.AbleArrayLiteral;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleDoubleLiteral;
import com.ibm.able.data.AbleGenericLiteral;
import com.ibm.able.data.AbleNewObjectLiteral;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleIfThenElseStatement;
import com.ibm.able.rules.AbleLocation;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleBreakpoint;
import com.ibm.able.rules.AbleRuleSet;
import com.ibm.able.rules.AbleTimePeriod;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class AbleRule
implements Serializable {
    static final long serialVersionUID = 2000083100000000001L;
    static String clsNm = "AbleRule";
    public static final AbleRd PriorityDefault = new AbleDoubleLiteral(1.0);
    public static final int RuleIdInitial = 1;
    protected int myId;
    protected String myLabel;
    protected AbleRd myPriority;
    protected AbleRuleSet myRuleSet;
    protected AbleRuleBlock myRuleBlock;
    protected BitSet myRdRefs;
    protected BitSet myWrRefs;
    protected boolean myFiredFlag;
    protected int myFiredCount;
    protected Boolean myBooleanTruth = null;
    protected boolean myEnabled = true;
    protected Object[] myPreConditions;
    protected String myComment = "";
    protected String myPrompt = null;
    protected boolean myTemplateFlag = false;
    protected String myTemplateName;
    protected boolean myFinalFlag = false;
    protected Object[] myTemplateValues;
    protected AbleLocation myLocation;
    protected AbleRuleBreakpoint myBreakpoint;
    protected Map myProperties = new Hashtable();

    public AbleRule(int n, String string, AbleRd ableRd, AbleRuleSet ableRuleSet) {
        this.myId = n;
        this.myLabel = string;
        this.myPriority = ableRd != null ? ableRd : PriorityDefault;
        this.myRuleSet = ableRuleSet;
        this.myRdRefs = new BitSet();
        this.myWrRefs = new BitSet();
        this.myFiredFlag = false;
    }

    public final void setId(int n) {
        this.myId = n;
    }

    public final int getId() {
        return this.myId;
    }

    public final String getLabel() {
        return this.myLabel;
    }

    public String getIdLabelString() {
        return "" + this.myId + "(" + this.myLabel + ")";
    }

    public void setComment(String string) {
        this.myComment = string;
    }

    public String getComment() {
        return this.myComment;
    }

    public String getArlComment() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myComment == null || this.myComment.length() == 0) {
            if (this.myProperties.isEmpty()) {
                return "";
            }
            stringBuffer.append("/**");
            stringBuffer.append(Able.LS);
            stringBuffer.append(this.arlProps());
            stringBuffer.append("     */");
        } else {
            stringBuffer.append("/**");
            stringBuffer.append(Able.LS);
            stringBuffer.append(this.myComment);
            if (!this.myProperties.isEmpty()) {
                stringBuffer.append(this.arlProps());
            }
            stringBuffer.append("     */");
        }
        return stringBuffer.toString();
    }

    private String arlProps() {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = new Vector(this.myProperties.keySet());
        Collections.sort(vector);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.myProperties.get(string);
            stringBuffer.append("     * @prop ");
            stringBuffer.append(string);
            stringBuffer.append(" = \"");
            stringBuffer.append(string2);
            stringBuffer.append("\"");
            stringBuffer.append(Able.LS);
        }
        return stringBuffer.toString();
    }

    protected void addRdReference(int n) {
        this.myRdRefs.set(n);
    }

    protected void addRdReferences(BitSet bitSet) {
        this.myRdRefs.or(bitSet);
    }

    public BitSet getRdReferences() {
        return (BitSet)this.myRdRefs.clone();
    }

    protected void addWrReference(int n) {
        this.myWrRefs.set(n);
    }

    protected void addWrReferences(BitSet bitSet) {
        this.myWrRefs.or(bitSet);
    }

    public BitSet getWrReferences() {
        return (BitSet)this.myWrRefs.clone();
    }

    public BitSet addHeaderRdReferences() {
        BitSet bitSet = new BitSet();
        if (this.myPreConditions != null) {
            for (int i = 0; i < this.myPreConditions.length; ++i) {
                bitSet.or(((AbleRd)this.myPreConditions[i]).getReferents());
            }
        }
        if (this.myPriority != PriorityDefault) {
            bitSet.or(this.myPriority.getReferents());
        }
        this.myRdRefs.or(bitSet);
        return bitSet;
    }

    public final void setFired(boolean bl) {
        this.myFiredFlag = bl;
        ++this.myFiredCount;
    }

    public final boolean isFired() {
        return this.myFiredFlag;
    }

    public void reset() {
        this.myFiredFlag = false;
    }

    public final void setBooleanTruth(Boolean bl) {
        this.myBooleanTruth = bl;
    }

    public final Boolean getBooleanTruth() {
        return this.myBooleanTruth;
    }

    public final void setPriority(AbleRd ableRd) {
        this.myPriority = ableRd;
    }

    public final double getPriority() throws AbleDataException {
        return this.myPriority.getNumericValue();
    }

    public void setEnabled(boolean bl) {
        this.myEnabled = bl;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setPreConditions(Object[] objectArray) throws AbleDataException {
        this.myPreConditions = objectArray;
        this.addHeaderRdReferences();
    }

    public Object[] getPreConditions() throws AbleDataException {
        return this.myPreConditions;
    }

    public void setMetaData(Object[] objectArray) throws AbleDataException {
        this.myPreConditions = objectArray;
        this.addHeaderRdReferences();
    }

    public Object[] getMetaData() throws AbleDataException {
        return this.myPreConditions;
    }

    public final void checkTimePeriodPreConditions(Calendar calendar) throws AbleDataException {
        if (this.myPreConditions != null) {
            for (int i = 0; i < this.myPreConditions.length; ++i) {
                AbleTimePeriod ableTimePeriod;
                Object object;
                Object object2 = this.myPreConditions[i];
                if (object2 instanceof AbleVariable) {
                    object = ((AbleVariable)object2).getGenericValue();
                    if (!(object instanceof AbleTimePeriod)) continue;
                    ableTimePeriod = (AbleTimePeriod)object;
                    if (ableTimePeriod.contains(calendar)) {
                        this.setEnabled(true);
                        break;
                    }
                    this.setEnabled(false);
                    continue;
                }
                if (!(object2 instanceof AbleNewObjectLiteral)) continue;
                object = ((AbleNewObjectLiteral)object2).getValue();
                if (object instanceof AbleGenericLiteral) {
                    object = ((AbleGenericLiteral)object).getGenericValue();
                }
                if (!(object instanceof AbleTimePeriod)) continue;
                ableTimePeriod = (AbleTimePeriod)object;
                if (ableTimePeriod.contains(calendar)) {
                    this.setEnabled(true);
                    break;
                }
                this.setEnabled(false);
            }
        }
    }

    public void setTemplate(boolean bl) {
        this.myTemplateFlag = bl;
    }

    public boolean isTemplate() {
        return this.myTemplateFlag;
    }

    public void setFinal(boolean bl) {
        this.myFinalFlag = bl;
    }

    public boolean isFinal() {
        return this.myFinalFlag;
    }

    public abstract String arlString();

    public static String arlActionBlockString(String string, Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            AbleConsequentClause ableConsequentClause = (AbleConsequentClause)vector.get(i);
            if (ableConsequentClause.getRhs() instanceof AbleIfThenElseStatement) {
                stringBuffer.append(string + ableConsequentClause.arlString());
                continue;
            }
            stringBuffer.append(string + ableConsequentClause.arlString() + ";" + Able.LS);
        }
        return stringBuffer.toString();
    }

    protected String arlPreConditionsString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myPreConditions != null) {
            stringBuffer.append(" {");
            for (int i = 0; i < this.myPreConditions.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(((AbleRd)this.myPreConditions[i]).arlCRdString());
            }
            stringBuffer.append("} ");
        }
        return stringBuffer.toString();
    }

    public abstract String xmlString();

    public abstract String armlString();

    public String xmlPriorityString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.myPriority != PriorityDefault) {
            stringBuffer.append("      <priority>" + Able.LS);
            stringBuffer.append("       <arg>" + Able.LS);
            stringBuffer.append(this.myPriority.xmlCRdString());
            stringBuffer.append("       </arg>" + Able.LS);
            stringBuffer.append("      </priority>" + Able.LS);
        }
        return stringBuffer.toString();
    }

    public String armlPriorityString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.myPriority != PriorityDefault) {
            stringBuffer.append("      <priority>" + this.myPriority.arlCRdString() + "</priority>" + Able.LS);
        }
        return stringBuffer.toString();
    }

    public String armlPropertiesString() {
        StringBuffer stringBuffer = new StringBuffer("");
        Iterator iterator = this.myProperties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.myProperties.get(string);
            stringBuffer.append("    <properties name=\"" + string + "\" value=\"" + string2 + "\"/>" + Able.LS);
        }
        return stringBuffer.toString();
    }

    protected String xmlPreConditionsString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myPreConditions != null) {
            AbleArrayLiteral ableArrayLiteral = new AbleArrayLiteral((Object)this.myPreConditions);
            stringBuffer.append("      <preConditions>" + Able.LS);
            stringBuffer.append(ableArrayLiteral.xmlCRdString());
            stringBuffer.append("      </preConditions>" + Able.LS);
        }
        return stringBuffer.toString();
    }

    protected String armlPreConditionsString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myPreConditions != null) {
            AbleArrayLiteral ableArrayLiteral = new AbleArrayLiteral((Object)this.myPreConditions);
            stringBuffer.append("      <metaData>" + Able.LS);
            stringBuffer.append(ableArrayLiteral.arlCRdString());
            stringBuffer.append("      </metaData>" + Able.LS);
        }
        return stringBuffer.toString();
    }

    public abstract String traceString(int var1);

    protected void logTrace(String string) {
        if (this.myRuleSet.isInferenceTraceLow()) {
            this.myRuleSet.getTraceLogger().text(262144L, "AbleRule: " + this.myId + "(" + this.myLabel + "): " + string);
        }
    }

    public abstract String getTemplateString(Vector var1) throws AbleDataException;

    public String getTemplateHeaderString(Vector vector) throws AbleDataException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (((AbleVariable)vector.get(0)).getName().equals("_RuleComment")) {
            stringBuffer.append("/**{0}*/ ");
        } else if (this.myComment.length() > 0) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        if (((AbleVariable)vector.get(1)).getName().equals("_RuleLabel")) {
            stringBuffer.append("{1} ");
        } else {
            if (this.isTemplate()) {
                stringBuffer.append("template ");
            }
            stringBuffer.append(this.myLabel);
        }
        if (this.myPreConditions != null) {
            stringBuffer.append(" '{'");
            for (int i = 0; i < this.myPreConditions.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(((AbleRd)this.myPreConditions[i]).getTemplateString(vector));
            }
            stringBuffer.append("'}' ");
        }
        if (this.myPriority == PriorityDefault) {
            stringBuffer2.append(": ");
        } else {
            stringBuffer2.append(" [" + this.myPriority.getTemplateString(vector) + "]: ");
        }
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    public Vector getTemplateVars(AbleRuleSet ableRuleSet) throws AbleDataException {
        BitSet bitSet = new BitSet();
        bitSet.or(this.myRdRefs);
        bitSet.or(this.myWrRefs);
        Vector vector = ableRuleSet.getTemplateVariables(bitSet);
        return vector;
    }

    public static String getTemplateActionBlockString(Vector vector, String string, Vector vector2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            AbleConsequentClause ableConsequentClause = (AbleConsequentClause)vector2.get(i);
            if (ableConsequentClause.getRhs() instanceof AbleIfThenElseStatement) {
                stringBuffer.append(string + ableConsequentClause.getTemplateString(vector));
                continue;
            }
            stringBuffer.append(string + ableConsequentClause.getTemplateString(vector) + ";" + Able.LS);
        }
        return stringBuffer.toString();
    }

    public boolean isGeneratedFromTemplate() {
        return this.myTemplateName != null && this.myTemplateValues != null;
    }

    public void setTemplateName(String string) {
        this.myTemplateName = string;
    }

    public String getTemplateName() {
        return this.myTemplateName;
    }

    public void setTemplateValues(Object[] objectArray) {
        this.myTemplateValues = objectArray;
    }

    public Object[] getTemplateValues() {
        return this.myTemplateValues;
    }

    public void setPrompt(String string) {
        this.myPrompt = string;
    }

    public String getPrompt() {
        return this.myPrompt;
    }

    public String getPromptString(AbleRuleSet ableRuleSet) {
        String string = null;
        ResourceBundle resourceBundle = ableRuleSet.getResourceBundle();
        string = resourceBundle == null ? (this.myPrompt == null || this.myPrompt.length() == 0 ? "A rule template for " + this.myLabel : this.myPrompt) : (this.myPrompt == null || this.myPrompt.length() == 0 ? resourceBundle.getString(this.myLabel) : resourceBundle.getString(this.myPrompt));
        return string;
    }

    public void setLocation(AbleLocation ableLocation) {
        this.myLocation = ableLocation;
    }

    public AbleLocation getLocation() {
        return this.myLocation;
    }

    public void setBreakpoint(AbleRuleBreakpoint ableRuleBreakpoint) {
        this.myBreakpoint = ableRuleBreakpoint;
    }

    public AbleRuleBreakpoint getBreakpoint() {
        return this.myBreakpoint;
    }

    public void clearBreakpoint() {
        this.myBreakpoint = null;
    }

    public boolean isDefaultPriority() {
        try {
            return this.myPriority.getNumericValue() == 1.0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setProperty(String string, String string2) {
        this.myProperties.put(string, string2);
    }

    public String getProperty(String string) {
        return (String)this.myProperties.get(string);
    }

    public String removeProperty(String string) {
        return (String)this.myProperties.remove(string);
    }

    public void setProperties(Map map) {
        if (map != null) {
            this.myProperties = map;
        }
    }

    public Map getProperties() {
        return this.myProperties;
    }

    public String toString() {
        return this.arlString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.myProperties == null) {
            this.myProperties = new Hashtable();
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

