/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleGenericVariable;
import com.ibm.able.data.AblePredicate;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleAntecedentClause;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleSet;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class AblePredicateRule
extends AbleRule
implements Serializable {
    static final long serialVersionUID = 2001041300000000001L;
    static String clsNm = "AblePredicateRule";
    protected static int copyId = 0;
    protected Vector myAntecedents;
    protected AblePredicate myConsequent;
    protected Vector myVariables = new Vector();
    protected Vector myCuts = null;

    public AblePredicateRule(String string, Vector vector, AblePredicate ablePredicate, AbleRuleSet ableRuleSet) {
        this(0, string, PriorityDefault, vector, ablePredicate, ableRuleSet);
    }

    public AblePredicateRule(String string, AbleRd ableRd, Vector vector, AblePredicate ablePredicate, AbleRuleSet ableRuleSet) {
        this(0, string, ableRd, vector, ablePredicate, ableRuleSet);
    }

    public AblePredicateRule(int n, String string, Vector vector, AblePredicate ablePredicate, AbleRuleSet ableRuleSet) {
        this(n, string, PriorityDefault, vector, ablePredicate, ableRuleSet);
    }

    public AblePredicateRule(int n, String string, AbleRd ableRd, Vector vector, AblePredicate ablePredicate, AbleRuleSet ableRuleSet) {
        super(n, string, ableRd, ableRuleSet);
        this.myAntecedents = (Vector)vector.clone();
        this.myConsequent = ablePredicate;
        this.findAllVariables();
        this.ctorHelperSaveReferences();
    }

    public AblePredicateRule(int n, String string, AbleRd ableRd, AbleRuleSet ableRuleSet) {
        super(n, string, ableRd, ableRuleSet);
        this.findAllVariables();
        this.ctorHelperSaveReferences();
    }

    private void ctorHelperSaveReferences() {
        this.addHeaderRdReferences();
        if (this.myAntecedents != null && !this.myAntecedents.isEmpty()) {
            for (int i = 0; i < this.myAntecedents.size(); ++i) {
                if (!(this.myAntecedents.get(i) instanceof AbleAntecedentClause)) continue;
                AbleAntecedentClause ableAntecedentClause = (AbleAntecedentClause)this.myAntecedents.get(i);
                ableAntecedentClause.addRuleRef(this);
                this.addRdReferences(ableAntecedentClause.getReferents());
            }
        }
    }

    public AblePredicateRule createMatchRule() {
        Object object;
        Hashtable<AbleVariable, AbleGenericVariable> hashtable = new Hashtable<AbleVariable, AbleGenericVariable>();
        for (int i = 0; i < this.myVariables.size(); ++i) {
            AbleVariable ableVariable = (AbleVariable)this.myVariables.get(i);
            if (!(ableVariable instanceof AbleGenericVariable)) continue;
            hashtable.put(ableVariable, new AbleGenericVariable(ableVariable.getName() + "_" + copyId, null));
        }
        ++copyId;
        Vector<Object> vector = new Vector<Object>();
        if (this.myAntecedents != null) {
            for (int i = 0; i < this.myAntecedents.size(); ++i) {
                object = this.myAntecedents.get(i);
                if (object instanceof AblePredicate) {
                    vector.add(((AblePredicate)object).createMatchPredicate(hashtable));
                    continue;
                }
                if (object instanceof AbleVariable) {
                    AbleVariable ableVariable = null;
                    if (((AbleVariable)object).isGlobal()) {
                        ableVariable = (AbleVariable)object;
                    } else if (hashtable.containsKey((AbleVariable)object)) {
                        ableVariable = (AbleVariable)hashtable.get((AbleVariable)object);
                    }
                    vector.add(ableVariable);
                    continue;
                }
                if (object instanceof AbleAntecedentClause) {
                    vector.add(((AbleAntecedentClause)object).createMatchClause(hashtable));
                    continue;
                }
                if (!(object instanceof AbleConsequentClause)) continue;
                vector.add(((AbleConsequentClause)object).createMatchClause(hashtable));
            }
        }
        AblePredicate ablePredicate = null;
        if (this.myConsequent != null) {
            ablePredicate = this.myConsequent.createMatchPredicate(hashtable);
        }
        object = new AblePredicateRule(this.myId, this.myLabel + "'", this.myPriority, vector, ablePredicate, this.myRuleSet);
        ((AbleRule)object).setLocation(this.myLocation);
        return object;
    }

    protected void findAllVariables() {
        Object object;
        Vector vector;
        if (this.myConsequent != null && (vector = this.myConsequent.getArguments()) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                object = vector.get(i);
                if (object instanceof AbleVariable && !this.myVariables.contains(object)) {
                    this.myVariables.add(object);
                    continue;
                }
                if (!(object instanceof AblePredicate)) continue;
                Vector vector2 = ((AblePredicate)object).getArguments();
                for (int j = 0; j < vector2.size(); ++j) {
                    Object e = vector2.get(j);
                    if (!(e instanceof AbleVariable) || this.myVariables.contains(e)) continue;
                    this.myVariables.add(e);
                }
            }
        }
        if (this.myAntecedents != null) {
            for (int i = 0; i < this.myAntecedents.size(); ++i) {
                Object e = this.myAntecedents.get(i);
                if (e instanceof AblePredicate) {
                    if (((AblePredicate)e).isCut()) {
                        if (this.myCuts == null) {
                            this.myCuts = new Vector();
                        }
                        this.myCuts.add(e);
                    }
                    object = ((AblePredicate)e).getArguments();
                    for (int j = 0; j < ((Vector)object).size(); ++j) {
                        Object e2 = ((Vector)object).get(j);
                        if (!(e2 instanceof AbleVariable) || this.myVariables.contains(e2)) continue;
                        this.myVariables.add(e2);
                    }
                    continue;
                }
                if (!(e instanceof AbleAntecedentClause) && !(e instanceof AbleConsequentClause)) continue;
            }
        }
    }

    public Vector getAntecedents() {
        return this.myAntecedents;
    }

    public long numberOfAntecedents() {
        long l = 0L;
        if (this.myAntecedents != null) {
            l = this.myAntecedents.size();
        }
        return l;
    }

    public AblePredicate getConsequent() {
        return this.myConsequent;
    }

    public String getSignature() {
        return this.myConsequent.getSignature();
    }

    public void reset() {
        this.resetAllVariables();
        this.myFiredFlag = false;
    }

    public Vector getCuts() {
        return this.myCuts;
    }

    public void resetAllVariables() {
        for (int i = 0; i < this.myVariables.size(); ++i) {
            AbleVariable ableVariable = (AbleVariable)this.myVariables.get(i);
            try {
                ableVariable.setGenericValue(null);
                continue;
            }
            catch (AbleDataException ableDataException) {
                if (this.myRuleSet.isInferenceTraceHigh()) {
                    this.myRuleSet.getTraceLogger().text(0x40000000000L, (Object)this, "resetAllVariables", ableDataException.getLocalizedMessage());
                }
                Able.MessageLog.message(4L, (Object)this, "resetAllVariables", ableDataException.getLocalizedMessage());
            }
        }
    }

    public String arlString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.myAntecedents.size();
        String string = "    " + this.myLabel;
        int n3 = this.myLabel.length();
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        for (n = 0; n < n3; ++n) {
            stringBuffer2.append(" ");
        }
        if (this.myPriority == PriorityDefault) {
            stringBuffer3.append(": ");
        } else {
            stringBuffer3.append("[" + this.myPriority.arlCRdString() + "]: ");
        }
        for (n = 0; n < stringBuffer3.length(); ++n) {
            stringBuffer2.append(" ");
        }
        if (this.myComment.length() > 0 || !this.myProperties.isEmpty()) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        if (this.isTemplate()) {
            stringBuffer.append("template ");
        }
        stringBuffer.append(string);
        stringBuffer.append(this.arlPreConditionsString());
        stringBuffer.append(stringBuffer3.toString() + this.myConsequent.arlString() + " :-" + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "        " + this.arlString(this.myAntecedents.elementAt(0)));
        for (n = 1; n < n2; ++n) {
            stringBuffer.append("," + Able.LS);
            stringBuffer.append(stringBuffer2.toString() + "        " + this.arlString(this.myAntecedents.elementAt(n)));
        }
        stringBuffer.append("." + Able.LS);
        return stringBuffer.toString();
    }

    private String arlString(Object object) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (object instanceof AblePredicate) {
            stringBuffer.append(((AblePredicate)object).arlString());
        } else if (object instanceof AbleVariable) {
            stringBuffer.append(((AbleVariable)object).arlCRdString());
        } else if (object instanceof AbleAntecedentClause) {
            stringBuffer.append("(" + ((AbleAntecedentClause)object).arlString() + ")");
        } else if (object instanceof AbleConsequentClause) {
            stringBuffer.append(((AbleConsequentClause)object).arlString());
        }
        return stringBuffer.toString();
    }

    public String xmlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = this.myAntecedents.size();
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        stringBuffer.append("    <rule" + string + string2 + string3 + ">" + Able.LS);
        stringBuffer.append(this.xmlPreConditionsString());
        stringBuffer.append(this.xmlPriorityString());
        stringBuffer.append("       <predicateRule>" + Able.LS);
        stringBuffer.append("      <predicateRuleHead>" + Able.LS);
        stringBuffer.append(this.myConsequent.xmlString());
        stringBuffer.append("      </predicateRuleHead>" + Able.LS);
        stringBuffer.append("      <predicateRuleBody>" + Able.LS);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.xmlString2(this.myAntecedents.elementAt(i)));
        }
        stringBuffer.append("      </predicateRuleBody>" + Able.LS);
        stringBuffer.append("    </predicateRule>" + Able.LS);
        stringBuffer.append("     </rule>" + Able.LS);
        return stringBuffer.toString();
    }

    private String xmlString2(Object object) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (object instanceof AblePredicate) {
            stringBuffer.append(((AblePredicate)object).xmlString());
        } else if (object instanceof AbleVariable) {
            stringBuffer.append(((AbleVariable)object).xmlCRdString());
        } else if (object instanceof AbleAntecedentClause) {
            stringBuffer.append("        <constraint>" + Able.LS);
            stringBuffer.append(((AbleAntecedentClause)object).xmlString());
            stringBuffer.append("        </constraint>" + Able.LS);
        } else if (object instanceof AbleConsequentClause) {
            stringBuffer.append("        <action>" + Able.LS);
            stringBuffer.append(((AbleConsequentClause)object).xmlString());
            stringBuffer.append("        </action>" + Able.LS);
        } else {
            stringBuffer.append("<!-- AblePredicateRule.xmlString2(): Unknown type: " + object + "-->");
        }
        return stringBuffer.toString();
    }

    public String armlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = this.myAntecedents.size();
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        String string4 = this.myFinalFlag ? " final=\"true\"" : "";
        stringBuffer.append("    <PredicateRule" + string + string2 + string3 + string4 + ">" + Able.LS);
        stringBuffer.append(this.armlPreConditionsString());
        stringBuffer.append(this.armlPriorityString());
        stringBuffer.append(this.armlPropertiesString());
        stringBuffer.append("      <head>" + this.myConsequent.arlString() + "</head>" + Able.LS);
        stringBuffer.append("      <body>" + Able.LS);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.armlString2(this.myAntecedents.elementAt(i)));
        }
        stringBuffer.append("      </body>" + Able.LS);
        stringBuffer.append("     </PredicateRule>" + Able.LS);
        return stringBuffer.toString();
    }

    private String armlString2(Object object) {
        StringBuffer stringBuffer = new StringBuffer("       ");
        if (object instanceof AblePredicate) {
            stringBuffer.append(((AblePredicate)object).armlString());
        } else if (object instanceof AbleVariable) {
            stringBuffer.append(((AbleVariable)object).armlCRdString());
        } else if (object instanceof AbleAntecedentClause) {
            stringBuffer.append("<expression>" + ((AbleAntecedentClause)object).arlString() + "</expression>" + Able.LS);
        } else if (object instanceof AbleConsequentClause) {
            stringBuffer.append(((AbleConsequentClause)object).armlString() + Able.LS);
        } else {
            stringBuffer.append("<!-- AblePredicateRule.armlString2(): Unknown type: " + object + "-->");
        }
        return stringBuffer.toString();
    }

    public void setBindings(Vector vector) throws AbleDataException {
        this.applyBindings(vector);
    }

    public Vector getBindings() throws AbleDataException {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this.myVariables.size(); ++i) {
            AbleVariable ableVariable = (AbleVariable)this.myVariables.get(i);
            vector.add(ableVariable);
            vector.add(ableVariable.getGenericValue());
        }
        return vector;
    }

    public void applyBindings(Vector vector) throws AbleDataException {
        int n = 0;
        for (int i = 0; i < vector.size() / 2; ++i) {
            AbleVariable ableVariable = (AbleVariable)vector.get(n++);
            Object e = vector.get(n++);
            ableVariable.setGenericValue(e);
        }
    }

    public void displayBindings(Vector vector) throws AbleDataException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < vector.size() / 2; ++i) {
            AbleVariable ableVariable = (AbleVariable)vector.get(n++);
            Object e = vector.get(n++);
            if (i > 0) {
                stringBuffer.append(Able.LS);
            }
            stringBuffer.append(ableVariable.getName() + "<" + ableVariable.getStringValue() + ">=" + e);
        }
        if (this.myRuleSet.isInferenceTraceHigh()) {
            this.myRuleSet.getTraceLogger().message(0x40000000000L, (Object)this, "displayBindings()", "Tr_RsPredicateDisplayBindings", new Object[]{this.getIdLabelString(), stringBuffer.toString()});
        }
    }

    public String getTemplateString(Vector vector) throws AbleDataException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.myAntecedents.size();
        StringBuffer stringBuffer2 = new StringBuffer("");
        stringBuffer.append(this.getTemplateHeaderString(vector));
        stringBuffer.append(this.myConsequent.getTemplateString(vector) + " :-" + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "        " + this.getTemplateString(vector, this.myAntecedents.elementAt(0)));
        for (int i = 1; i < n; ++i) {
            stringBuffer.append("," + Able.LS);
            stringBuffer.append(stringBuffer2.toString() + "        " + this.getTemplateString(vector, this.myAntecedents.elementAt(i)));
        }
        stringBuffer.append("." + Able.LS);
        return stringBuffer.toString();
    }

    private String getTemplateString(Vector vector, Object object) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (object instanceof AblePredicate) {
            stringBuffer.append(((AblePredicate)object).getTemplateString(vector));
        } else if (object instanceof AbleVariable) {
            stringBuffer.append(((AbleVariable)object).getTemplateString(vector));
        } else if (object instanceof AbleAntecedentClause) {
            stringBuffer.append("(" + ((AbleAntecedentClause)object).getTemplateString(vector) + ")");
        } else if (object instanceof AbleConsequentClause) {
            stringBuffer.append(((AbleConsequentClause)object).getTemplateString(vector));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.traceString(2);
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlString();
            }
            case 4: {
                return this.arlString();
            }
            case 5: {
                return this.xmlString();
            }
        }
        return this.arlString();
    }

    protected String trcString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("");
        int n3 = this.myAntecedents.size();
        String string = "    " + this.myLabel;
        int n4 = this.myLabel.length();
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        for (n2 = 0; n2 < n4; ++n2) {
            stringBuffer2.append(" ");
        }
        if (this.myPriority == PriorityDefault) {
            stringBuffer3.append(": ");
        } else {
            stringBuffer3.append("[" + this.myPriority.traceString(n) + "]: ");
        }
        for (n2 = 0; n2 < stringBuffer3.length(); ++n2) {
            stringBuffer2.append(" ");
        }
        stringBuffer.append(string + stringBuffer3.toString() + this.myConsequent.traceString(n) + " <- ");
        stringBuffer.append(this.trcString2(n, this.myAntecedents.elementAt(0)));
        for (n2 = 1; n2 < n3; ++n2) {
            stringBuffer.append(", ");
            stringBuffer.append(this.trcString2(n, this.myAntecedents.elementAt(n2)));
        }
        return stringBuffer.toString();
    }

    private String trcString2(int n, Object object) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (object instanceof AblePredicate) {
            stringBuffer.append(((AblePredicate)object).traceString(n));
        } else if (object instanceof AbleVariable) {
            stringBuffer.append(((AbleVariable)object).traceString(n));
        } else if (object instanceof AbleAntecedentClause) {
            stringBuffer.append(((AbleAntecedentClause)object).traceString(n));
        } else if (object instanceof AbleConsequentClause) {
            stringBuffer.append(((AbleConsequentClause)object).traceString(n));
        }
        return stringBuffer.toString();
    }
}

