/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleDoubleLiteral;
import com.ibm.able.data.AblePredicate;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleInferenceEngine;
import com.ibm.able.rules.AblePredicateEngine;
import com.ibm.able.rules.AbleRuleSet;
import com.ibm.able.rules.AbleWorkingMemory;
import java.io.Serializable;
import java.util.Vector;

public class AblePredicateLib
implements Serializable {
    static final long serialVersionUID = 2000083100000000001L;
    protected AbleWorkingMemory myWm = null;

    public AbleDoubleLiteral plus(Object object, Object object2) throws AbleDataException {
        double[] dArray = this.verifyPredParms(object, object2, "plus");
        return new AbleDoubleLiteral(dArray[0] + dArray[1]);
    }

    public AbleDoubleLiteral minus(Object object, Object object2) throws AbleDataException {
        double[] dArray = this.verifyPredParms(object, object2, "minus");
        return new AbleDoubleLiteral(dArray[0] - dArray[1]);
    }

    public AbleDoubleLiteral times(Object object, Object object2) throws AbleDataException {
        double[] dArray = this.verifyPredParms(object, object2, "times");
        if (object instanceof Double && object2 instanceof Double) {
            return new AbleDoubleLiteral(dArray[0] + dArray[1]);
        }
        if (object instanceof AbleDoubleLiteral && object2 instanceof AbleDoubleLiteral) {
            return new AbleDoubleLiteral(dArray[0] * dArray[1]);
        }
        return null;
    }

    public AbleDoubleLiteral divideBy(Object object, Object object2) throws AbleDataException {
        double[] dArray = this.verifyPredParms(object, object2, "divideBy");
        if (object instanceof Double && object2 instanceof Double) {
            if (dArray[1] == 0.0) {
                return new AbleDoubleLiteral(Double.NaN);
            }
            return new AbleDoubleLiteral(dArray[0] + dArray[1]);
        }
        if (object instanceof AbleDoubleLiteral && object2 instanceof AbleDoubleLiteral) {
            if (dArray[1] == 0.0) {
                return new AbleDoubleLiteral(Double.NaN);
            }
            return new AbleDoubleLiteral(dArray[0] / dArray[1]);
        }
        return null;
    }

    private double[] verifyPredParms(Object object, Object object2, String string) throws AbleDataException {
        Object object3;
        double[] dArray = new double[2];
        if (object instanceof AbleVariable && (object3 = (AbleVariable)object).isBound()) {
            object = object3.getGenericValue();
        }
        if (object2 instanceof AbleVariable && (object3 = (AbleVariable)object2).isBound()) {
            object2 = object3.getGenericValue();
        }
        if (object instanceof Double) {
            dArray[0] = (Double)object;
        } else if (object instanceof AbleDoubleLiteral) {
            dArray[0] = ((AbleDoubleLiteral)object).getNumericValue();
        } else {
            object3 = Able.NlsMsg((String)"Ex_PredicateLibMathParms", (Object[])new Object[]{object.getClass().getName(), "1", string});
            Able.MessageLog.text(4L, (Object)this, "divideBy()", (String)object3);
            throw new AbleDataException((String)object3);
        }
        if (object2 instanceof Double) {
            dArray[1] = (Double)object2;
        } else if (object2 instanceof AbleDoubleLiteral) {
            dArray[1] = ((AbleDoubleLiteral)object2).getNumericValue();
        } else {
            object3 = Able.NlsMsg((String)"Ex_PredicateLibMathParms", (Object[])new Object[]{object.getClass().getName(), "2", string});
            Able.MessageLog.text(4L, (Object)this, "divideBy()", (String)object3);
            throw new AbleDataException((String)object3);
        }
        return dArray;
    }

    public static Vector getSolutionList(AbleRuleSet ableRuleSet, String string) throws AbleException {
        AbleInferenceEngine ableInferenceEngine;
        String string2 = string;
        if (!string2.trim().endsWith(")")) {
            string2 = string2 + "()";
        }
        if (!((ableInferenceEngine = ableRuleSet.getInferenceEngine(string2)) instanceof AblePredicateEngine)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(ableRuleSet.getClass().getName());
            throw new AbleException(illegalArgumentException.toString());
        }
        Vector vector = ((AblePredicateEngine)ableInferenceEngine).getSolutionList();
        return vector;
    }

    public static Vector getSolution(AbleRuleSet ableRuleSet, String string, int n) throws AbleException {
        AbleInferenceEngine ableInferenceEngine;
        String string2 = string;
        if (!string2.trim().endsWith(")")) {
            string2 = string2 + "()";
        }
        if (!((ableInferenceEngine = ableRuleSet.getInferenceEngine(string2)) instanceof AblePredicateEngine)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(ableRuleSet.getClass().getName());
            throw new AbleException(illegalArgumentException.toString());
        }
        Vector vector = ((AblePredicateEngine)ableInferenceEngine).getSolutionList();
        vector = (Vector)vector.get(n);
        return vector;
    }

    public static Vector getGroundSolution(AbleRuleSet ableRuleSet, String string, int n) throws AbleException {
        Vector vector;
        AbleInferenceEngine ableInferenceEngine;
        String string2 = string;
        if (!string2.trim().endsWith(")")) {
            string2 = string2 + "()";
        }
        if ((ableInferenceEngine = ableRuleSet.getInferenceEngine(string2)) instanceof AblePredicateEngine) {
            vector = ((AblePredicateEngine)ableInferenceEngine).getSolutionList();
            vector = (Vector)vector.get(n);
            for (int i = 0; i < vector.size(); ++i) {
                AblePredicate ablePredicate = (AblePredicate)vector.get(i);
                vector.set(i, ablePredicate.makeGround());
            }
        } else {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(ableRuleSet.getClass().getName());
            throw new AbleException(illegalArgumentException.toString());
        }
        return vector;
    }

    public static boolean getAnswer(AbleRuleSet ableRuleSet) throws AbleException {
        AbleInferenceEngine ableInferenceEngine = ableRuleSet.getInferenceEngine();
        boolean bl = false;
        if (ableInferenceEngine instanceof AblePredicateEngine) {
            Vector vector = ((AblePredicateEngine)ableInferenceEngine).getSolutionList();
            if (vector != null && vector.size() > 0) {
                bl = true;
            }
        } else {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(ableRuleSet.getClass().getName());
            throw new AbleException(illegalArgumentException.toString());
        }
        return bl;
    }

    public void setPredicateWorkingMemory(AbleWorkingMemory ableWorkingMemory) {
        this.myWm = ableWorkingMemory;
    }

    public boolean assertFact(Object object) {
        this.myWm.assertFact(object);
        return true;
    }

    public boolean retractFact(Object object) {
        this.myWm.retract(object);
        return true;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

