/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.AbleLogger;
import com.ibm.able.data.AbleCharacterLiteral;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleDoubleLiteral;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AblePredicate;
import com.ibm.able.data.AbleStringLiteral;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleAntecedentClause;
import com.ibm.able.rules.AbleClause;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleInferenceEngine;
import com.ibm.able.rules.AbleParException;
import com.ibm.able.rules.AblePredicateFact;
import com.ibm.able.rules.AblePredicateQuery;
import com.ibm.able.rules.AblePredicateRule;
import com.ibm.able.rules.AblePredicateWorkingMemory;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleBreakpoint;
import com.ibm.able.rules.AbleRuleSet;
import com.ibm.able.rules.AbleWorkingMemory;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class AblePredicateEngine
extends AbleInferenceEngine
implements Serializable {
    static final long serialVersionUID = 2001041300000000001L;
    static String clsNm = "AblePredicateEngine";
    protected AblePredicateQuery myGoal;
    protected Vector solutionList = new Vector();
    protected boolean findAllSolutions = true;
    protected Vector myGoalList = new Vector();
    protected Vector globalClauseLists = new Vector();
    protected Hashtable cutTable = new Hashtable();

    public AblePredicateEngine(AbleRuleSet ableRuleSet, AbleLogger ableLogger, AbleRuleBlock ableRuleBlock) {
        super(ableRuleSet, ableLogger);
        this.myRuleBlock = ableRuleBlock;
    }

    public boolean isRuleBlockValid(AbleRuleBlock ableRuleBlock) {
        boolean bl = true;
        String string = null;
        Iterator iterator = null;
        AbleRule ableRule = null;
        AbleRuleBlock ableRuleBlock2 = ableRuleBlock;
        String string2 = ableRuleBlock2.getName();
        iterator = ableRuleBlock2.getIterationRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoIterationRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getConditionalRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoConditionalRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getIfThenElseRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoIfThenElseRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getPatternMatchRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoPatternMatchRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        return bl;
    }

    public void init() throws AbleException {
        Vector vector = this.myRuleBlock.getEnabledPredicateRules();
        this.myWorkingMemory = this.allocateWorkingMemory();
        for (int i = 0; i < vector.size(); ++i) {
            AblePredicateRule ablePredicateRule = (AblePredicateRule)vector.get(i);
            this.myWorkingMemory.assertFact(ablePredicateRule);
        }
    }

    public void infer(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        AbleRuleBlock ableRuleBlock2 = ableRuleBlock;
        this.myRulesFiredCount = 0;
        if (ableRuleBlock2 != null) {
            this.processAssertions(ableRuleBlock2);
        }
        this.myGoalList.clear();
        this.solutionList.clear();
        this.globalClauseLists.clear();
        this.cutTable.clear();
        if (this.myGoal == null) {
            String string = Able.NlsMsg((String)"Ex_IeNoGoalPredicateVariable", (Object[])new Object[]{this.getClass().getName()});
            Able.MessageLog.text(4L, string);
            if (this.myRuleSet.isInferenceTraceLow()) {
                this.myTracer.text(0x10000000000L, (Object)this, "infer", string);
            }
            throw new AbleDataException(string);
        }
        if (ableRuleBlock2 != null) {
            this.myRuleSet.myInferenceContext.setRuleBlock(ableRuleBlock2);
            this.myGoalList.addAll(this.myGoal.getPredicates());
            if (this.myRuleSet.isInferenceTraceMedium()) {
                this.myTracer.message(0x20000000000L, (Object)clsNm, "infer()", "Tr_Rs_RuleBlockInferStarts", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType});
            }
            if (this.myDebugLevel == 3) {
                this.fireEngineBreakpoint();
            }
            this.backwardChain(this.myGoalList, new Vector(), 0);
            if (this.myRuleSet.isInferenceTraceLow()) {
                this.myTracer.message(0x10000000000L, (Object)this, "infer()", "Tr_RsPredicateSolution", new Object[]{this.myGoalList, "" + (this.solutionList.size() > 0), Integer.toString(this.solutionList.size()), this.formatSolutions(this.solutionList)});
                this.myTracer.message(0x20000000000L, (Object)clsNm, "infer()", "Tr_Rs_RuleBlockInferEnds", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType});
            }
        }
    }

    protected boolean matchLists(AblePredicate ablePredicate, AblePredicate ablePredicate2, Vector vector, Vector vector2) throws AbleDataException {
        if (this.myRuleSet.isInferenceTraceHigh()) {
            this.myTracer.message(0x40000000000L, (Object)this, "matchLists", "Tr_RsPredicateMatchLists", new Object[]{ablePredicate, ablePredicate2});
        }
        if (ablePredicate.isEmptyList() && ablePredicate2.isEmptyList()) {
            return true;
        }
        if (ablePredicate.isEmptyList() || ablePredicate2.isEmptyList()) {
            return false;
        }
        Object object = null;
        Object object2 = null;
        AblePredicate ablePredicate3 = ablePredicate;
        AblePredicate ablePredicate4 = ablePredicate2;
        do {
            if (!this.match(object = ablePredicate3.getHead(), object2 = ablePredicate4.getHead(), vector, vector2)) {
                return false;
            }
            Object object3 = ablePredicate3.getTail();
            Object object4 = ablePredicate4.getTail();
            ablePredicate3 = null;
            ablePredicate4 = null;
            if (object3 instanceof AblePredicate) {
                ablePredicate3 = (AblePredicate)object3;
            }
            if (object4 instanceof AblePredicate) {
                ablePredicate4 = (AblePredicate)object4;
            }
            if (ablePredicate3 != null && ablePredicate4 != null) continue;
            return this.match(object3, object4, vector, vector2);
        } while (!ablePredicate3.isEmptyList() && !ablePredicate4.isEmptyList());
        return ablePredicate3.isEmptyList() && ablePredicate4.isEmptyList();
    }

    protected boolean match(Object object, Object object2, Vector vector, Vector vector2) throws AbleDataException {
        if (this.myRuleSet.isInferenceTraceHigh()) {
            this.myTracer.message(0x40000000000L, (Object)this, "match", "Tr_RsPredicateMatchTerms", new Object[]{object.toString(), object2.toString()});
        }
        if (object instanceof String) {
            if (object2 instanceof String) {
                return object.equals(object2);
            }
            if (object2 instanceof AbleLiteral) {
                String string = ((AbleLiteral)object2).getStringValue();
                return object.equals(string);
            }
            if (object2 instanceof AblePredicate) {
                return false;
            }
            if (object2 instanceof AbleVariable) {
                AbleVariable ableVariable = (AbleVariable)object2;
                if (ableVariable.isBound()) {
                    String string = ableVariable.getStringValue();
                    if (object.equals(string)) {
                        return true;
                    }
                } else {
                    vector.add(ableVariable);
                    vector.add(object);
                    ableVariable.setGenericValue(object);
                    return true;
                }
            }
            if (this.myRuleSet.isInferenceTraceHigh()) {
                this.myTracer.message(0x40000000000L, (Object)this, "match(Object,Object,Vector,Vector)", "Tr_RsPredicateMatchTermsFailed", new Object[]{object.getClass().getName(), object2.getClass().getName()});
            }
            return false;
        }
        if (object instanceof AbleLiteral) {
            String string = ((AbleLiteral)object).getStringValue();
            if (object2 instanceof String) {
                return string.equals(object2);
            }
            if (object2 instanceof AbleLiteral) {
                String string2 = ((AbleLiteral)object2).getStringValue();
                return string.equals(string2);
            }
            if (object2 instanceof AblePredicate) {
                return false;
            }
            if (object2 instanceof AbleVariable) {
                AbleVariable ableVariable = (AbleVariable)object2;
                if (ableVariable.isBound()) {
                    String string3 = ableVariable.getStringValue();
                    return string.equals(string3);
                }
                vector.add(ableVariable);
                vector.add(object);
                ableVariable.setGenericValue(object);
                return true;
            }
            if (this.myRuleSet.isInferenceTraceHigh()) {
                this.myTracer.message(0x40000000000L, (Object)this, "match(Object,Object,Vector,Vector)", "Tr_RsPredicateMatchTermsFailed", new Object[]{object.getClass().getName(), object2.getClass().getName()});
            }
            return false;
        }
        if (object instanceof AblePredicate) {
            if (object2 instanceof AblePredicate) {
                AblePredicate ablePredicate = (AblePredicate)object;
                AblePredicate ablePredicate2 = (AblePredicate)object2;
                if (ablePredicate.isList()) {
                    if (!ablePredicate2.isList()) {
                        return false;
                    }
                    if (ablePredicate.isEmptyList()) {
                        return ablePredicate2.isEmptyList();
                    }
                    return this.matchLists(ablePredicate, ablePredicate2, vector, vector2);
                }
                if (!ablePredicate.getSignature().equals(ablePredicate2.getSignature())) {
                    return false;
                }
                Vector vector3 = ablePredicate.getArguments();
                Vector vector4 = ablePredicate2.getArguments();
                for (int i = 0; i < vector3.size(); ++i) {
                    if (this.match(vector3.get(i), vector4.get(i), vector, vector2)) continue;
                    return false;
                }
                return true;
            }
            if (object2 instanceof AbleVariable) {
                AbleVariable ableVariable = (AbleVariable)object2;
                if (ableVariable.isBound()) {
                    Object object3 = ableVariable.getGenericValue();
                    if (object3 instanceof AblePredicate) {
                        return this.match(object, object3, vector, vector2);
                    }
                    return false;
                }
                vector.add(ableVariable);
                vector.add(object);
                ableVariable.setGenericValue(object);
                return true;
            }
            if (this.myRuleSet.isInferenceTraceHigh()) {
                this.myTracer.message(0x40000000000L, (Object)this, "match(Object,Object,Vector,Vector)", "Tr_RsPredicateMatchTermsFailed", new Object[]{object.getClass().getName(), object2.getClass().getName()});
            }
            return false;
        }
        if (object instanceof AbleVariable) {
            AbleVariable ableVariable = (AbleVariable)object;
            if (ableVariable.isBound()) {
                Object object4 = ((AbleVariable)object).getGenericValue();
                if (object2 instanceof String) {
                    if (object4 instanceof String) {
                        return object4.equals(object2);
                    }
                    if (object4 instanceof AbleLiteral) {
                        return ((AbleLiteral)object4).getStringValue().equals(object2);
                    }
                    return false;
                }
                if (object2 instanceof AbleLiteral) {
                    String string = ((AbleLiteral)object2).getStringValue();
                    if (object4 instanceof String) {
                        return object4.equals(string);
                    }
                    if (object4 instanceof AbleLiteral) {
                        return ((AbleLiteral)object4).getStringValue().equals(string);
                    }
                    return false;
                }
                if (object2 instanceof AblePredicate) {
                    if (object4 instanceof AblePredicate) {
                        return this.match(object4, object2, vector, vector2);
                    }
                    return false;
                }
                if (object2 instanceof AbleVariable) {
                    return this.match(object4, object2, vector, vector2);
                }
            } else {
                if (object2 instanceof AbleVariable) {
                    AbleVariable ableVariable2 = (AbleVariable)object2;
                    if (ableVariable2.isBound()) {
                        vector.add(ableVariable);
                        vector.add(ableVariable2.getGenericValue());
                        ableVariable.setGenericValue(ableVariable2.getGenericValue());
                    } else {
                        vector2.add(ableVariable);
                        vector2.add(ableVariable2);
                    }
                } else {
                    vector.add(ableVariable);
                    vector.add(object2);
                    ableVariable.setGenericValue(object2);
                }
                return true;
            }
            if (this.myRuleSet.isInferenceTraceHigh()) {
                this.myTracer.message(0x40000000000L, (Object)this, "match(Object,Object,Vector,Vector)", "Tr_RsPredicateMatchTermsFailed", new Object[]{object.getClass().getName(), object2.getClass().getName()});
            }
            return false;
        }
        if (this.myRuleSet.isInferenceTraceHigh()) {
            this.myTracer.message(0x40000000000L, (Object)this, "match(Object,Object,Vector,Vector)", "Tr_RsPredicateMatchTermsFailed", new Object[]{object.getClass().getName(), object2.getClass().getName()});
        }
        return false;
    }

    protected boolean backwardChain(Vector vector, Vector vector2, int n) throws AbleDataException {
        String string;
        if (this.myRuleSet.isInferenceTraceHigh()) {
            this.myTracer.message(0x40000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcEntry", new Object[]{Integer.toString(n), vector});
        }
        if (vector2.size() > 0) {
            this.applyGoalBindings(vector2);
        }
        if (vector.size() == 0) {
            Vector vector3 = this.myGoal.getPredicates();
            this.solutionList.add(this.formatSolution(vector3));
            if (this.myRuleSet.isInferenceTraceMedium()) {
                this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcSolution", new Object[]{Integer.toString(n), this.formatSolution(vector3)});
            }
            return true;
        }
        if (this.myDebugLevel >= 2) {
            this.fireEngineBreakpoint();
        }
        Vector vector4 = (Vector)vector.clone();
        Object e = vector4.remove(0);
        boolean bl = false;
        Vector vector5 = new Vector();
        Vector vector6 = null;
        AblePredicate ablePredicate = null;
        if (e instanceof AblePredicate) {
            ablePredicate = (AblePredicate)e;
            string = ablePredicate.getSignature();
            this.myRuleSet.myInferenceContext.setPredicate(ablePredicate);
            if (this.myDebugLevel >= 5) {
                this.fireEngineBreakpoint();
            }
            if (ablePredicate.isFail()) {
                if (this.myRuleSet.isInferenceTraceMedium()) {
                    this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "fail"});
                    this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcExit", new Object[]{Integer.toString(n), e.toString(), bl + ""});
                }
                return false;
            }
            if (ablePredicate.isCut()) {
                Vector vector7;
                int n2;
                if (this.myRuleSet.isInferenceTraceMedium()) {
                    this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "cut"});
                }
                Vector vector8 = (Vector)this.cutTable.get(ablePredicate);
                for (int i = n2 = this.globalClauseLists.size() - 1; i >= 0; --i) {
                    vector7 = (Vector)this.globalClauseLists.get(i);
                    vector7.clear();
                    if (vector7 == vector8) break;
                }
                Vector vector9 = (Vector)vector4.clone();
                vector7 = (Vector)vector2.clone();
                bl = this.backwardChain(vector9, vector7, n + 1);
                return bl;
            }
            if (string.equals("isList/1")) {
                return this.isList_1(ablePredicate, vector4, vector2, n);
            }
            if (string.equals("call/1")) {
                return this.call_1(ablePredicate, vector4, vector2, n);
            }
            if (string.equals("atom_chars/2")) {
                return this.atom_chars_2(ablePredicate, vector4, vector2, n);
            }
            if (string.equals("atom_concat/3")) {
                return this.atom_concat_3(ablePredicate, vector4, vector2, n);
            }
            if (string.equals("sub_atom/5")) {
                return this.sub_atom_5(ablePredicate, vector4, vector2, n);
            }
            if (string.equals("atom_number/2")) {
                return this.atom_number_2(ablePredicate, vector4, vector2, n);
            }
            if (string.equals("atom_length/2")) {
                return this.atom_length_2(ablePredicate, vector4, vector2, n);
            }
            if (string.equals("functor/3")) {
                return this.functor_3(ablePredicate, vector4, vector2, n);
            }
            if (string.equals("unify/2")) {
                return this.unify_2(ablePredicate, vector4, vector2, n);
            }
            if (string.equals("consult/1")) {
                return this.consult_1(ablePredicate, vector4, vector2, n);
            }
            if (string.equals("assert/1")) {
                return this.assert_1(ablePredicate, vector4, vector2, n);
            }
            if (string.equals("asserta/1")) {
                return this.asserta_1(ablePredicate, vector4, vector2, n);
            }
            if (string.equals("assertz/1")) {
                return this.assertz_1(ablePredicate, vector4, vector2, n);
            }
            if (string.equals("retract/1")) {
                return this.retract_1(ablePredicate, vector4, vector2, n);
            }
            if (string.equals("retractall/1")) {
                return this.retractall_1(ablePredicate, vector4, vector2, n);
            }
            if (string.equals("member/2")) {
                return this.member_2(ablePredicate, vector4, vector2, n);
            }
            if (string.equals("var/1")) {
                return this.var_1(ablePredicate, vector4, vector2, n);
            }
            if (string.equals("nonvar/1")) {
                return this.nonvar_1(ablePredicate, vector4, vector2, n);
            }
            if (string.equals("univ/2")) {
                return this.univ_2(ablePredicate, vector4, vector2, n);
            }
            vector6 = ablePredicate.getUnboundVariables();
            vector5 = new Vector(this.myWorkingMemory.findAllInstances(ablePredicate.getSignature()));
        } else {
            vector5.add(e);
        }
        this.globalClauseLists.add(vector5);
        string = null;
        while (!bl && vector5.size() > 0) {
            Vector vector10;
            Serializable serializable;
            Serializable serializable2;
            Vector vector11 = null;
            Vector vector12 = new Vector();
            AblePredicateRule ablePredicateRule = null;
            AblePredicate ablePredicate2 = null;
            string = vector5.remove(0);
            if (string instanceof AblePredicateRule) {
                boolean bl2;
                AbleRuleBreakpoint ableRuleBreakpoint;
                ablePredicateRule = (AblePredicateRule)((Object)string);
                if (string instanceof AblePredicateFact) {
                    if (this.myRuleSet.isInferenceTraceMedium()) {
                        this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessFact", new Object[]{Integer.toString(n), ((AblePredicateFact)((Object)string)).traceString(2)});
                    }
                    ablePredicateRule = ((AblePredicateFact)ablePredicateRule).createMatchFact();
                    ablePredicate2 = ((AblePredicateFact)ablePredicateRule).getAssertion();
                } else {
                    if (this.myRuleSet.isInferenceTraceMedium()) {
                        this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessRule", new Object[]{Integer.toString(n), ablePredicateRule.traceString(2)});
                    }
                    ablePredicateRule = ablePredicateRule.createMatchRule();
                    ablePredicate2 = ablePredicateRule.getConsequent();
                }
                vector11 = ablePredicateRule.getAntecedents();
                serializable2 = ablePredicateRule.getCuts();
                if (serializable2 != null) {
                    for (int i = 0; i < ((Vector)serializable2).size(); ++i) {
                        this.cutTable.put(((Vector)serializable2).get(i), vector5);
                    }
                }
                this.myRuleSet.myInferenceContext.setRule(ablePredicateRule);
                if (this.myDebugLevel >= 4) {
                    this.fireEngineBreakpoint();
                }
                if (this.myDebugLevel == 1 && (ableRuleBreakpoint = ablePredicateRule.getBreakpoint()) != null && ableRuleBreakpoint.isEnabled()) {
                    this.fireEngineBreakpoint();
                }
                if (bl2 = this.match(e, ablePredicate2, (Vector)(serializable = new Vector()), vector12)) {
                    vector10 = (Vector)vector4.clone();
                    if (vector11 != null) {
                        vector10.addAll(0, vector11);
                    }
                    Vector vector13 = (Vector)vector2.clone();
                    if (vector12.size() > 0) {
                        vector13.addAll(0, vector12);
                    }
                    bl = this.backwardChain(vector10, vector13, n + 1);
                }
            } else if (string instanceof AbleAntecedentClause) {
                if (this.myRuleSet.isInferenceTraceMedium()) {
                    this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessAntClause", new Object[]{Integer.toString(n), ((AbleAntecedentClause)((Object)string)).traceString(2)});
                }
                serializable2 = (AbleAntecedentClause)((Object)string);
                this.myRuleSet.myInferenceContext.setClause((AbleClause)serializable2);
                serializable = AblePredicateEngine.evalAntecedentClause((AbleAntecedentClause)serializable2);
                bl = (Boolean)serializable;
                if (this.myRuleSet.isInferenceTraceMedium()) {
                    if (bl) {
                        this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcAntecedentClauseTrue", new Object[]{((AbleAntecedentClause)((Object)string)).traceString(2)});
                    } else {
                        this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcAntecedentClauseFalse", new Object[]{((AbleAntecedentClause)((Object)string)).traceString(2)});
                    }
                }
                if (bl) {
                    Vector vector14 = (Vector)vector4.clone();
                    vector10 = (Vector)vector2.clone();
                    bl = this.backwardChain(vector14, vector10, n + 1);
                }
            } else if (string instanceof AbleConsequentClause) {
                if (this.myRuleSet.isInferenceTraceMedium()) {
                    this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessConClause", new Object[]{Integer.toString(n), ((AbleConsequentClause)((Object)string)).traceString(2)});
                }
                this.myRuleSet.myInferenceContext.setClause((AbleConsequentClause)((Object)string));
                this.evalConsequentClause((AbleConsequentClause)((Object)string));
                serializable2 = (Vector)vector4.clone();
                serializable = (Vector)vector2.clone();
                bl = this.backwardChain((Vector)serializable2, (Vector)serializable, n + 1);
            } else if (string instanceof AbleVariable) {
                if (this.myRuleSet.isInferenceTraceMedium()) {
                    this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessVariable", new Object[]{Integer.toString(n), ((AbleVariable)string).traceString(2)});
                }
                serializable2 = (AblePredicate)((AbleVariable)string).getGenericValue();
                serializable = (Vector)vector4.clone();
                ((Vector)serializable).add(0, serializable2);
                Vector vector15 = (Vector)vector2.clone();
                bl = this.backwardChain((Vector)serializable, vector15, n + 1);
            }
            if (this.findAllSolutions && vector5.size() > 0) {
                bl = false;
            }
            if (!bl && ablePredicate != null && vector6 != null) {
                ablePredicate.clearBindings(vector6);
            }
            if (bl || vector5.size() <= 0) continue;
            if (this.myRuleSet.isInferenceTraceMedium()) {
                this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcContinueGoal", new Object[]{Integer.toString(n), e.toString()});
            }
            if (!this.myRuleSet.isInferenceTraceHigh()) continue;
            this.myTracer.message(0x40000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcContinueClause", new Object[]{Integer.toString(n), vector5});
        }
        if (ablePredicate != null && vector6 != null) {
            ablePredicate.clearBindings(vector6);
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcExitGoal", new Object[]{Integer.toString(n), e.toString()});
        }
        if (this.myRuleSet.isInferenceTraceHigh()) {
            this.myTracer.message(0x40000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcExitClause", new Object[]{Integer.toString(n), vector5});
        }
        return bl;
    }

    protected void applyGoalBindings(Vector vector) throws AbleDataException {
        int n;
        int n2 = 0;
        int n3 = vector.size() / 2;
        int[] nArray = new int[vector.size()];
        int n4 = 0;
        if (this.myRuleSet.isInferenceTraceHigh()) {
            this.myTracer.message(0x40000000000L, (Object)this, "applyGoalBindings()", "Tr_RsPredicateApplyGoalBindings");
        }
        for (n = 0; n < n3; ++n) {
            AbleVariable ableVariable = (AbleVariable)vector.get(n2++);
            AbleVariable ableVariable2 = (AbleVariable)vector.get(n2++);
            Object object = ableVariable2.getGenericValue();
            if (this.myRuleSet.isInferenceTraceHigh()) {
                this.myTracer.message(0x40000000000L, (Object)this, "applyGoalBindings()", "Tr_RsPredicateApplyGoalVarBindings", new Object[]{ableVariable.getName(), ableVariable.getStringValue(), ableVariable2.getName(), ableVariable2.getStringValue()});
            }
            ableVariable.setGenericValue(object);
            if (ableVariable2 == null || object == null) continue;
            nArray[n4 * 2] = n2 - 2;
            nArray[n4 * 2 + 1] = n2 - 1;
            ++n4;
        }
        for (n = n4 * 2 - 1; n >= 0; --n) {
            vector.remove(nArray[n]);
        }
    }

    public final Vector getSolutionList() {
        return this.solutionList;
    }

    private Vector formatSolution(Vector vector) {
        Vector<AblePredicate> vector2 = new Vector<AblePredicate>();
        for (int i = 0; i < vector.size(); ++i) {
            AblePredicate ablePredicate = (AblePredicate)vector.get(i);
            ablePredicate = new AblePredicate(ablePredicate);
            vector2.add(ablePredicate);
        }
        return vector2;
    }

    private String formatSolutionOld(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            AblePredicate ablePredicate = (AblePredicate)vector.get(i);
            ablePredicate = ablePredicate.makeGround();
            stringBuffer.append(ablePredicate.traceString(1));
        }
        return stringBuffer.toString();
    }

    private String formatSolutions(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append(" " + i + ": ");
            Vector vector2 = (Vector)vector.get(i);
            for (int j = 0; j < vector2.size(); ++j) {
                if (j > 0) {
                    stringBuffer.append(", ");
                }
                AblePredicate ablePredicate = (AblePredicate)vector2.get(j);
                stringBuffer.append(ablePredicate.traceString(1));
            }
            stringBuffer.append(Able.LS);
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setControlParameter(String string, Object object) throws AbleDataException {
        if (string.equalsIgnoreCase("Goal")) {
            if (object instanceof AblePredicate) {
                this.myGoal = new AblePredicateQuery((AblePredicate)object);
                return;
            } else {
                if (!(object instanceof Vector)) throw new AbleDataException(Able.NlsMsg((String)"Ex_RsSetControlParameter", (Object[])new Object[]{string, object, object.getClass().getName(), this.myRuleBlock.getEngineType()}));
                this.myGoal = new AblePredicateQuery((Vector)object);
            }
            return;
        } else {
            if (!string.equalsIgnoreCase("FindAllSolutions")) throw new AbleDataException(Able.NlsMsg((String)"Ex_RsSetControlParameter", (Object[])new Object[]{string, object, object.getClass().getName(), this.myRuleBlock.getEngineType()}));
            if (object instanceof String) {
                if (((String)object).equalsIgnoreCase("true")) {
                    this.findAllSolutions = true;
                    return;
                } else {
                    if (!((String)object).equalsIgnoreCase("false")) throw new AbleDataException(Able.NlsMsg((String)"Ex_RsSetControlParameter", (Object[])new Object[]{string, object, object.getClass().getName(), this.myRuleBlock.getEngineType()}));
                    this.findAllSolutions = false;
                }
                return;
            } else {
                if (!(object instanceof Boolean)) return;
                this.findAllSolutions = (Boolean)object;
            }
        }
    }

    public Object getControlParameter(String string) throws AbleDataException {
        if (string.equalsIgnoreCase("Goal")) {
            return this.myGoal;
        }
        if (string.equalsIgnoreCase("FindAllSolutions")) {
            if (this.findAllSolutions) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        throw new AbleDataException(Able.NlsMsg((String)"Ex_RsGetControlParameter", (Object[])new Object[]{string, this.myRuleBlock.getEngineType()}));
    }

    public AblePredicateQuery getPredicateQuery() {
        return this.myGoal;
    }

    protected boolean isList_1(AblePredicate ablePredicate, Vector vector, Vector vector2, int n) throws AbleDataException {
        Object e;
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "isList/1"});
        }
        if ((e = ablePredicate.getArguments().get(0)) instanceof AblePredicate && ((AblePredicate)e).isList()) {
            Vector vector3 = (Vector)vector.clone();
            Vector vector4 = (Vector)vector2.clone();
            return this.backwardChain(vector3, vector4, n + 1);
        }
        return false;
    }

    protected boolean call_1(AblePredicate ablePredicate, Vector vector, Vector vector2, int n) throws AbleDataException {
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "call/1"});
        }
        Object object = ablePredicate.getArgument(0);
        AblePredicate ablePredicate2 = null;
        if (object instanceof AblePredicate) {
            ablePredicate2 = (AblePredicate)object;
        } else if (object instanceof AbleVariable) {
            ablePredicate2 = (AblePredicate)((AbleVariable)object).getGenericValue();
        }
        Vector vector3 = (Vector)vector.clone();
        vector3.add(0, ablePredicate2);
        Vector vector4 = (Vector)vector2.clone();
        return this.backwardChain(vector3, vector4, n + 1);
    }

    protected boolean atom_chars_2(AblePredicate ablePredicate, Vector vector, Vector vector2, int n) throws AbleDataException {
        Object object;
        Object object2;
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "atom_chars/2"});
        }
        boolean bl = true;
        Object object3 = ablePredicate.getArgument(0);
        Object object4 = ablePredicate.getArgument(1);
        if (object3 instanceof AbleVariable) {
            object2 = (AbleVariable)object3;
            if (object2.isBound()) {
                if (object4 instanceof AbleVariable) {
                    if (!((AbleVariable)object4).isBound()) {
                        object = (AbleVariable)object4;
                        String string = object2.getStringValue();
                        Vector<Object> vector3 = new Vector<Object>();
                        for (int i = 0; i < string.length(); ++i) {
                            vector3.add(new AbleCharacterLiteral(string.charAt(i)));
                        }
                        vector3.add(AblePredicate.EmptyListPredicate);
                        object.setGenericValue((Object)new AblePredicate(".", vector3));
                    } else {
                        object = object2.getStringValue();
                        if (object4 instanceof AbleVariable) {
                            AbleVariable ableVariable = (AbleVariable)object4;
                            if (ableVariable.isBound()) {
                                AblePredicate ablePredicate2 = (AblePredicate)ableVariable.getGenericValue();
                                Vector vector4 = ablePredicate2.getListArguments();
                                for (int i = 0; i < vector4.size(); ++i) {
                                    if (((String)object).charAt(i) == ((Character)((AbleCharacterLiteral)vector4.get(i)).getGenericValue()).charValue()) continue;
                                    bl = false;
                                    break;
                                }
                            }
                        } else {
                            AblePredicate ablePredicate3 = (AblePredicate)object4;
                            Vector vector5 = ablePredicate3.getListArguments();
                            for (int i = 0; i < vector5.size() && ((String)object).charAt(i) == ((Character)((AbleCharacterLiteral)vector5.get(i)).getGenericValue()).charValue(); ++i) {
                            }
                        }
                    }
                }
            } else {
                object = (AblePredicate)object4;
                Vector vector6 = object.getListArguments();
                char[] cArray = new char[vector6.size()];
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = ((Character)((AbleCharacterLiteral)vector6.get(i)).getGenericValue()).charValue();
                }
                object2.setGenericValue((Object)this.myRuleSet.findOrCreateStringLiteral(new String(cArray)));
            }
        } else {
            object2 = null;
            if (object3 instanceof String) {
                object2 = (String)object3;
            } else if (object3 instanceof AbleStringLiteral) {
                object2 = ((AbleStringLiteral)object3).getStringValue();
            }
            if (object4 instanceof AbleVariable) {
                object = (AbleVariable)object4;
                if (object.isBound()) {
                    AblePredicate ablePredicate4 = (AblePredicate)object.getGenericValue();
                    Vector vector7 = ablePredicate4.getListArguments();
                    for (int i = 0; i < vector7.size(); ++i) {
                        if (((String)object2).charAt(i) == ((Character)((AbleCharacterLiteral)vector7.get(i)).getGenericValue()).charValue()) continue;
                        bl = false;
                        break;
                    }
                } else {
                    Vector<Object> vector8 = new Vector<Object>();
                    for (int i = 0; i < ((String)object2).length(); ++i) {
                        vector8.add(new AbleCharacterLiteral(((String)object2).charAt(i)));
                    }
                    vector8.add(AblePredicate.EmptyListPredicate);
                    object.setGenericValue((Object)new AblePredicate(".", vector8));
                }
            }
        }
        if (bl) {
            object2 = (Vector)vector.clone();
            object = (Vector)vector2.clone();
            return this.backwardChain((Vector)object2, (Vector)object, n + 1);
        }
        return false;
    }

    protected boolean atom_concat_3(AblePredicate ablePredicate, Vector vector, Vector vector2, int n) throws AbleDataException {
        Object object;
        Object object2;
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "atom_concat/3"});
        }
        boolean bl = true;
        boolean bl2 = true;
        Object object3 = ablePredicate.getArgument(0);
        Object object4 = ablePredicate.getArgument(1);
        Object object5 = ablePredicate.getArgument(2);
        if (object3 instanceof AbleVariable && (object2 = (AbleVariable)object3).isBound()) {
            object3 = object2.getGenericValue();
        }
        if (object4 instanceof AbleVariable && (object2 = (AbleVariable)object4).isBound()) {
            object4 = object2.getGenericValue();
        }
        if (object5 instanceof AbleVariable && (object2 = (AbleVariable)object5).isBound()) {
            object5 = object2.getGenericValue();
        }
        if (object3 instanceof AbleVariable && object4 instanceof AbleVariable && (object5 instanceof AbleStringLiteral || object5 instanceof String)) {
            object2 = null;
            if (object5 instanceof String) {
                object2 = (String)object5;
            } else if (object5 instanceof AbleStringLiteral) {
                object2 = ((AbleStringLiteral)object5).getStringValue();
            }
            AbleVariable ableVariable = (AbleVariable)object3;
            AbleVariable ableVariable2 = (AbleVariable)object4;
            int n2 = ((String)object2).length() + 1;
            for (int i = 0; i < n2; ++i) {
                String string = ((String)object2).substring(0, i);
                String string2 = ((String)object2).substring(i, ((String)object2).length());
                ableVariable.setGenericValue((Object)this.myRuleSet.findOrCreateStringLiteral(string));
                ableVariable2.setGenericValue((Object)this.myRuleSet.findOrCreateStringLiteral(string2));
                Vector vector3 = (Vector)vector.clone();
                Vector vector4 = (Vector)vector2.clone();
                bl = this.backwardChain(vector3, vector4, n + 1);
            }
            return bl;
        }
        if (object3 instanceof AbleVariable && (object4 instanceof AbleStringLiteral || object4 instanceof String) && object5 instanceof AbleVariable) {
            object2 = null;
            if (object4 instanceof String) {
                object2 = (String)object4;
            } else if (object4 instanceof AbleStringLiteral) {
                object2 = ((AbleStringLiteral)object4).getStringValue();
            }
            AbleVariable ableVariable = (AbleVariable)object3;
            AbleVariable ableVariable3 = (AbleVariable)object5;
            if (!ableVariable.isBound()) {
                return false;
            }
            object2 = ableVariable.getStringValue() + (String)object2;
            if (ableVariable3.isBound()) {
                if (((String)object2).equals(ableVariable3.getStringValue())) {
                    Vector vector5 = (Vector)vector.clone();
                    Vector vector6 = (Vector)vector2.clone();
                    return this.backwardChain(vector5, vector6, n + 1);
                }
                return false;
            }
            ableVariable3.setGenericValue((Object)this.myRuleSet.findOrCreateStringLiteral((String)object2));
            Vector vector7 = (Vector)vector.clone();
            Vector vector8 = (Vector)vector2.clone();
            return this.backwardChain(vector7, vector8, n + 1);
        }
        if (object3 instanceof AbleVariable && (object4 instanceof AbleStringLiteral || object4 instanceof String) && (object5 instanceof AbleStringLiteral || object5 instanceof String)) {
            object2 = null;
            String string = null;
            if (object4 instanceof String) {
                object2 = (String)object4;
            } else if (object4 instanceof AbleStringLiteral) {
                object2 = ((AbleStringLiteral)object4).getStringValue();
            }
            if (object5 instanceof String) {
                string = (String)object5;
            } else if (object4 instanceof AbleStringLiteral) {
                string = ((AbleStringLiteral)object5).getStringValue();
            }
            AbleVariable ableVariable = (AbleVariable)object3;
            if (string.endsWith((String)object2)) {
                String string3 = string.substring(0, string.length() - ((String)object2).length());
                ableVariable.setGenericValue((Object)this.myRuleSet.findOrCreateStringLiteral(string3));
                Vector vector9 = (Vector)vector.clone();
                Vector vector10 = (Vector)vector2.clone();
                return this.backwardChain(vector9, vector10, n + 1);
            }
            return false;
        }
        if ((object3 instanceof AbleStringLiteral || object3 instanceof String) && object4 instanceof AbleVariable && object5 instanceof AbleVariable) {
            object2 = null;
            if (object3 instanceof String) {
                object2 = (String)object3;
            } else if (object3 instanceof AbleStringLiteral) {
                object2 = ((AbleStringLiteral)object3).getStringValue();
            }
            AbleVariable ableVariable = (AbleVariable)object4;
            AbleVariable ableVariable4 = (AbleVariable)object5;
            if (!ableVariable.isBound()) {
                return false;
            }
            object2 = (String)object2 + ableVariable.getStringValue();
            if (ableVariable4.isBound()) {
                if (((String)object2).equals(ableVariable4.getStringValue())) {
                    Vector vector11 = (Vector)vector.clone();
                    Vector vector12 = (Vector)vector2.clone();
                    return this.backwardChain(vector11, vector12, n + 1);
                }
                return false;
            }
            ableVariable4.setGenericValue((Object)this.myRuleSet.findOrCreateStringLiteral((String)object2));
            Vector vector13 = (Vector)vector.clone();
            Vector vector14 = (Vector)vector2.clone();
            return this.backwardChain(vector13, vector14, n + 1);
        }
        if (object3 instanceof AbleVariable && object4 instanceof AbleVariable && object5 instanceof AbleVariable) {
            object2 = null;
            AbleVariable ableVariable = (AbleVariable)object3;
            AbleVariable ableVariable5 = (AbleVariable)object4;
            AbleVariable ableVariable6 = (AbleVariable)object5;
            if (!ableVariable.isBound()) {
                return false;
            }
            object2 = ableVariable.getStringValue();
            if (!ableVariable5.isBound()) {
                return false;
            }
            object2 = (String)object2 + ableVariable5.getStringValue();
            if (ableVariable6.isBound()) {
                if (((String)object2).equals(ableVariable6.getStringValue())) {
                    Vector vector15 = (Vector)vector.clone();
                    Vector vector16 = (Vector)vector2.clone();
                    return this.backwardChain(vector15, vector16, n + 1);
                }
                return false;
            }
            ableVariable6.setGenericValue((Object)this.myRuleSet.findOrCreateStringLiteral((String)object2));
            Vector vector17 = (Vector)vector.clone();
            Vector vector18 = (Vector)vector2.clone();
            return this.backwardChain(vector17, vector18, n + 1);
        }
        if ((object3 instanceof String || object3 instanceof AbleStringLiteral) && (object4 instanceof String || object4 instanceof AbleStringLiteral) && (object5 instanceof String || object5 instanceof AbleStringLiteral)) {
            object2 = null;
            if (object3 instanceof String) {
                object2 = (String)object3;
            }
            if (object3 instanceof AbleStringLiteral) {
                object2 = ((AbleStringLiteral)object3).getStringValue();
            }
            object = null;
            if (object4 instanceof String) {
                object = (String)object4;
            }
            if (object4 instanceof AbleStringLiteral) {
                object = ((AbleStringLiteral)object4).getStringValue();
            }
            String string = null;
            if (object5 instanceof String) {
                string = (String)object5;
            }
            if (object5 instanceof AbleStringLiteral) {
                string = ((AbleStringLiteral)object5).getStringValue();
            }
            if (!((String)object2 + (String)object).equals(string)) {
                bl2 = false;
            }
        } else if ((object3 instanceof String || object3 instanceof AbleStringLiteral) && (object4 instanceof String || object4 instanceof AbleStringLiteral) && object5 instanceof AbleVariable && !((AbleVariable)object5).isBound()) {
            object2 = null;
            if (object3 instanceof String) {
                object2 = (String)object3;
            }
            if (object3 instanceof AbleStringLiteral) {
                object2 = ((AbleStringLiteral)object3).getStringValue();
            }
            String string = null;
            if (object4 instanceof String) {
                string = (String)object4;
            }
            if (object4 instanceof AbleStringLiteral) {
                string = ((AbleStringLiteral)object4).getStringValue();
            }
            AbleVariable ableVariable = (AbleVariable)object5;
            ableVariable.setGenericValue((Object)this.myRuleSet.findOrCreateStringLiteral((String)object2 + string));
            Vector vector19 = (Vector)vector.clone();
            Vector vector20 = (Vector)vector2.clone();
            bl = this.backwardChain(vector19, vector20, n + 1);
            return bl;
        }
        if (bl2) {
            object2 = (Vector)vector.clone();
            object = (Vector)vector2.clone();
            bl = this.backwardChain((Vector)object2, (Vector)object, n + 1);
            return bl;
        }
        return false;
    }

    protected boolean sub_atom_5(AblePredicate ablePredicate, Vector vector, Vector vector2, int n) throws AbleDataException {
        Object object;
        boolean bl = true;
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "sub_atom/5"});
        }
        Object object2 = ablePredicate.getArgument(0);
        Object object3 = ablePredicate.getArgument(1);
        Object object4 = ablePredicate.getArgument(2);
        Object object5 = ablePredicate.getArgument(3);
        Object object6 = ablePredicate.getArgument(4);
        if (object2 instanceof AbleVariable && !((AbleVariable)object2).isBound()) {
            return false;
        }
        if (object2 instanceof AbleVariable && (object = (AbleVariable)object2).isBound()) {
            object2 = object.getGenericValue();
        }
        if (object3 instanceof AbleVariable && (object = (AbleVariable)object3).isBound()) {
            object3 = object.getGenericValue();
        }
        if (object4 instanceof AbleVariable && (object = (AbleVariable)object4).isBound()) {
            object4 = object.getGenericValue();
        }
        if (object5 instanceof AbleVariable && (object = (AbleVariable)object5).isBound()) {
            object5 = object.getGenericValue();
        }
        if (object6 instanceof AbleVariable && (object = (AbleVariable)object6).isBound()) {
            object6 = object.getGenericValue();
        }
        object = null;
        if (object2 instanceof String) {
            object = (String)object2;
        }
        if (object2 instanceof AbleStringLiteral) {
            object = ((AbleStringLiteral)object2).getStringValue();
        }
        String string = null;
        if (object6 instanceof String) {
            string = (String)object6;
        }
        if (object6 instanceof AbleStringLiteral) {
            string = ((AbleStringLiteral)object6).getStringValue();
        }
        if (object3 instanceof AbleLiteral && object4 instanceof AbleLiteral && object5 instanceof AbleLiteral && object6 instanceof AbleVariable) {
            int n2 = (int)((AbleLiteral)object3).getNumericValue();
            int n3 = (int)((AbleLiteral)object4).getNumericValue();
            int n4 = (int)((AbleLiteral)object5).getNumericValue();
            AbleVariable ableVariable = (AbleVariable)object6;
            if (ableVariable.isBound()) {
                if (n2 < 0 || n3 < 0 || n4 < 0 || n2 + n3 > ((String)object).length()) {
                    return false;
                }
                if (n2 + n3 + n4 != ((String)object).length()) {
                    return false;
                }
                String string2 = ((String)object).substring(n2, n2 + n3);
                if (string2.equals(object)) {
                    Vector vector3 = (Vector)vector.clone();
                    Vector vector4 = (Vector)vector2.clone();
                    bl = this.backwardChain(vector3, vector4, n + 1);
                    return bl;
                }
                return false;
            }
            if (n2 < 0 || n3 < 0 || n4 < 0 || n2 + n3 > ((String)object).length()) {
                return false;
            }
            if (n2 + n3 + n4 != ((String)object).length()) {
                return false;
            }
            String string3 = ((String)object).substring(n2, n2 + n3);
            ableVariable.setGenericValue((Object)this.myRuleSet.findOrCreateStringLiteral(string3));
            Vector vector5 = (Vector)vector.clone();
            Vector vector6 = (Vector)vector2.clone();
            bl = this.backwardChain(vector5, vector6, n + 1);
            return bl;
        }
        if (object3 instanceof AbleLiteral && object4 instanceof AbleLiteral && object5 instanceof AbleLiteral && object6 instanceof AbleLiteral) {
            int n5 = (int)((AbleLiteral)object3).getNumericValue();
            int n6 = (int)((AbleLiteral)object4).getNumericValue();
            int n7 = (int)((AbleLiteral)object5).getNumericValue();
            if (n5 < 0 || n6 < 0 || n7 < 0 || n5 + n6 > ((String)object).length()) {
                return false;
            }
            if (n5 + n6 + n7 != ((String)object).length()) {
                return false;
            }
            String string4 = ((String)object).substring(n5, n5 + n6);
            if (string4.equals(string)) {
                Vector vector7 = (Vector)vector.clone();
                Vector vector8 = (Vector)vector2.clone();
                return this.backwardChain(vector7, vector8, n + 1);
            }
            return false;
        }
        if (object3 instanceof AbleLiteral && object4 instanceof AbleLiteral && object5 instanceof AbleVariable && object6 instanceof AbleLiteral) {
            int n8 = (int)((AbleLiteral)object3).getNumericValue();
            int n9 = (int)((AbleLiteral)object4).getNumericValue();
            if (n9 < 0) {
                return false;
            }
            AbleVariable ableVariable = (AbleVariable)object5;
            int n10 = n8 + n9;
            ableVariable.setGenericValue((Object)new AbleDoubleLiteral(n10));
            if (n8 < 0 || n8 > n10 || n10 > ((String)object).length()) {
                return false;
            }
            String string5 = ((String)object).substring(n8, n10);
            if (string5.equals(string)) {
                Vector vector9 = (Vector)vector.clone();
                Vector vector10 = (Vector)vector2.clone();
                return this.backwardChain(vector9, vector10, n + 1);
            }
            return false;
        }
        if (object3 instanceof AbleVariable && object4 instanceof AbleLiteral && object5 instanceof AbleVariable && object6 instanceof AbleVariable) {
            int n11 = (int)((AbleLiteral)object4).getNumericValue();
            AbleVariable ableVariable = (AbleVariable)object3;
            AbleVariable ableVariable2 = (AbleVariable)object5;
            AbleVariable ableVariable3 = (AbleVariable)object6;
            if (ableVariable3.isBound()) {
                int n12 = ((String)object).length();
                int n13 = 0;
                int n14 = 0;
                int n15 = n12 - n11 + 1;
                for (int i = 0; i < n15; ++i) {
                    n13 = i;
                    n14 = n12 - (n11 + i);
                    if (n13 < 0 || n13 > n13 + n11 || n13 + n11 > ((String)object).length()) {
                        return false;
                    }
                    String string6 = ((String)object).substring(n13, n13 + n11);
                    ableVariable.setGenericValue((Object)new AbleDoubleLiteral(n13));
                    ableVariable2.setGenericValue((Object)new AbleDoubleLiteral(n14));
                    if (((String)object).equals(string6)) {
                        Vector vector11 = (Vector)vector.clone();
                        Vector vector12 = (Vector)vector2.clone();
                        bl = this.backwardChain(vector11, vector12, n + 1);
                        continue;
                    }
                    bl = false;
                }
                return bl;
            }
            int n16 = ((String)object).length();
            int n17 = 0;
            int n18 = 0;
            int n19 = n16 - n11 + 1;
            for (int i = 0; i < n19; ++i) {
                n17 = i;
                n18 = n16 - (n11 + i);
                String string7 = ((String)object).substring(n17, n17 + n11);
                ableVariable3.setGenericValue((Object)this.myRuleSet.findOrCreateStringLiteral(string7));
                ableVariable.setGenericValue((Object)new AbleDoubleLiteral(n17));
                ableVariable2.setGenericValue((Object)new AbleDoubleLiteral(n18));
                Vector vector13 = (Vector)vector.clone();
                Vector vector14 = (Vector)vector2.clone();
                bl = this.backwardChain(vector13, vector14, n + 1);
            }
            return bl;
        }
        if (object3 instanceof AbleVariable && object4 instanceof AbleVariable && object5 instanceof AbleVariable && (object6 instanceof String || object6 instanceof AbleLiteral)) {
            AbleVariable ableVariable = (AbleVariable)object3;
            AbleVariable ableVariable4 = (AbleVariable)object4;
            AbleVariable ableVariable5 = (AbleVariable)object5;
            String string8 = null;
            if (object6 instanceof String) {
                string8 = (String)object6;
            }
            if (object6 instanceof AbleStringLiteral) {
                string8 = ((AbleStringLiteral)object6).getStringValue();
            }
            int n20 = ((String)object).length();
            int n21 = 0;
            int n22 = 0;
            int n23 = string8.length();
            int n24 = n20 - n23 + 1;
            for (int i = 0; i < n24; ++i) {
                n21 = i;
                n22 = n20 - (n23 + i);
                String string9 = ((String)object).substring(n21, n21 + n23);
                ableVariable.setGenericValue((Object)new AbleDoubleLiteral(n21));
                ableVariable5.setGenericValue((Object)new AbleDoubleLiteral(n22));
                ableVariable4.setGenericValue((Object)new AbleDoubleLiteral(n23));
                if (string8.equals(string9)) {
                    Vector vector15 = (Vector)vector.clone();
                    Vector vector16 = (Vector)vector2.clone();
                    bl = this.backwardChain(vector15, vector16, n + 1);
                    continue;
                }
                bl = false;
            }
            return bl;
        }
        if (object3 instanceof AbleVariable && object4 instanceof AbleLiteral && object5 instanceof AbleVariable && (object6 instanceof String || object6 instanceof AbleLiteral)) {
            AbleVariable ableVariable = (AbleVariable)object3;
            int n25 = (int)((AbleLiteral)object4).getNumericValue();
            AbleVariable ableVariable6 = (AbleVariable)object5;
            String string10 = null;
            if (object6 instanceof String) {
                string10 = (String)object6;
            }
            if (object6 instanceof AbleStringLiteral) {
                string10 = ((AbleStringLiteral)object6).getStringValue();
            }
            int n26 = ((String)object).length();
            int n27 = 0;
            int n28 = 0;
            if (n25 != string10.length()) {
                return false;
            }
            int n29 = n26 - n25 + 1;
            for (int i = 0; i < n29; ++i) {
                n27 = i;
                n28 = n26 - (n25 + i);
                String string11 = ((String)object).substring(n27, n27 + n25);
                ableVariable.setGenericValue((Object)new AbleDoubleLiteral(n27));
                ableVariable6.setGenericValue((Object)new AbleDoubleLiteral(n28));
                if (string10.equals(string11)) {
                    Vector vector17 = (Vector)vector.clone();
                    Vector vector18 = (Vector)vector2.clone();
                    bl = this.backwardChain(vector17, vector18, n + 1);
                    continue;
                }
                bl = false;
            }
            return bl;
        }
        if (object3 instanceof AbleLiteral && object4 instanceof AbleLiteral && object5 instanceof AbleVariable && object6 instanceof AbleVariable) {
            double d = ((AbleLiteral)object3).getNumericValue();
            double d2 = ((AbleLiteral)object4).getNumericValue();
            AbleVariable ableVariable = (AbleVariable)object5;
            AbleVariable ableVariable7 = (AbleVariable)object6;
            int n30 = ((String)object).length();
            double d3 = (double)n30 - d2;
            if (d < 0.0 || d2 < 0.0 || d + d2 > (double)((String)object).length()) {
                return false;
            }
            String string12 = ((String)object).substring((int)d, (int)(d + d2));
            ableVariable.setGenericValue((Object)new AbleDoubleLiteral(d3));
            ableVariable7.setGenericValue((Object)this.myRuleSet.findOrCreateStringLiteral(string12));
            Vector vector19 = (Vector)vector.clone();
            Vector vector20 = (Vector)vector2.clone();
            return this.backwardChain(vector19, vector20, n + 1);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean atom_number_2(AblePredicate ablePredicate, Vector vector, Vector vector2, int n) throws AbleDataException {
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "atom_number/2"});
        }
        Object object = ablePredicate.getArgument(0);
        Object object2 = ablePredicate.getArgument(1);
        double d = 0.0;
        if (object instanceof AbleVariable) {
            AbleVariable ableVariable = (AbleVariable)object;
            if (ableVariable.isBound()) {
                d = Double.valueOf(ableVariable.getStringValue());
                if (!(object2 instanceof AbleVariable)) return false;
                AbleVariable ableVariable2 = (AbleVariable)object2;
                if (ableVariable2.isBound()) {
                    if (d != Double.valueOf(ableVariable2.getStringValue())) return false;
                    Vector vector3 = (Vector)vector.clone();
                    Vector vector4 = (Vector)vector2.clone();
                    return this.backwardChain(vector3, vector4, n + 1);
                }
                ableVariable2.setGenericValue((Object)new AbleDoubleLiteral(d));
                Vector vector5 = (Vector)vector.clone();
                Vector vector6 = (Vector)vector2.clone();
                return this.backwardChain(vector5, vector6, n + 1);
            }
            if (object2 instanceof AbleVariable) {
                AbleVariable ableVariable3 = (AbleVariable)object2;
                if (!ableVariable3.isBound()) return false;
                ableVariable.setGenericValue(ableVariable3.getGenericValue());
                return false;
            }
            ableVariable.setGenericValue((Object)this.myRuleSet.findOrCreateStringLiteral(((AbleLiteral)object2).getStringValue()));
            Vector vector7 = (Vector)vector.clone();
            Vector vector8 = (Vector)vector2.clone();
            return this.backwardChain(vector7, vector8, n + 1);
        }
        if (!(object instanceof String) && !(object instanceof AbleStringLiteral)) return false;
        try {
            if (object instanceof String) {
                d = Double.valueOf((String)object);
            }
            if (object instanceof AbleStringLiteral) {
                d = Double.valueOf(((AbleStringLiteral)object).getStringValue());
            }
        }
        catch (Exception exception) {
            return false;
        }
        if (object2 instanceof AbleVariable) {
            AbleVariable ableVariable = (AbleVariable)object2;
            if (ableVariable.isBound()) {
                if (d != Double.valueOf(ableVariable.getStringValue())) return false;
                Vector vector9 = (Vector)vector.clone();
                Vector vector10 = (Vector)vector2.clone();
                return this.backwardChain(vector9, vector10, n + 1);
            }
            ableVariable.setGenericValue((Object)new AbleDoubleLiteral(d));
            Vector vector11 = (Vector)vector.clone();
            Vector vector12 = (Vector)vector2.clone();
            return this.backwardChain(vector11, vector12, n + 1);
        }
        if (d != Double.valueOf(((AbleLiteral)object2).getStringValue())) return false;
        Vector vector13 = (Vector)vector.clone();
        Vector vector14 = (Vector)vector2.clone();
        return this.backwardChain(vector13, vector14, n + 1);
    }

    protected boolean atom_length_2(AblePredicate ablePredicate, Vector vector, Vector vector2, int n) throws AbleDataException {
        Object object;
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "atom_length/2"});
        }
        Object object2 = ablePredicate.getArgument(0);
        Object object3 = ablePredicate.getArgument(1);
        if (object2 instanceof AbleVariable && (object = (AbleVariable)object2).isBound()) {
            object2 = object.getGenericValue();
        }
        if (object3 instanceof AbleVariable && (object = (AbleVariable)object3).isBound()) {
            object3 = object.getGenericValue();
        }
        if (object2 instanceof String || object2 instanceof AbleStringLiteral) {
            object = null;
            if (object2 instanceof String) {
                object = (String)object2;
            }
            if (object2 instanceof AbleStringLiteral) {
                object = ((AbleStringLiteral)object2).getStringValue();
            }
            if (object3 instanceof AbleVariable) {
                AbleVariable ableVariable = (AbleVariable)object3;
                ableVariable.setGenericValue((Object)new AbleDoubleLiteral(((String)object).length()));
                Vector vector3 = (Vector)vector.clone();
                Vector vector4 = (Vector)vector2.clone();
                return this.backwardChain(vector3, vector4, n + 1);
            }
            if (object3 instanceof AbleLiteral) {
                int n2 = (int)((AbleLiteral)object3).getNumericValue();
                if (n2 == ((String)object).length()) {
                    Vector vector5 = (Vector)vector.clone();
                    Vector vector6 = (Vector)vector2.clone();
                    return this.backwardChain(vector5, vector6, n + 1);
                }
                return false;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean functor_3(AblePredicate ablePredicate, Vector vector, Vector vector2, int n) throws AbleDataException {
        AbleVariable ableVariable;
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "functor/3"});
        }
        Object object = ablePredicate.getArgument(0);
        Object object2 = ablePredicate.getArgument(1);
        Object object3 = ablePredicate.getArgument(2);
        if (object instanceof AbleVariable && (ableVariable = (AbleVariable)object).isBound()) {
            object = ableVariable.getGenericValue();
        }
        if (object instanceof AblePredicate) {
            ableVariable = (AblePredicate)object;
            String string = ableVariable.getFunctor();
            int n2 = ableVariable.getArity();
            if (object2 instanceof String || object2 instanceof AbleStringLiteral) {
                String string2 = null;
                if (object2 instanceof String) {
                    string2 = (String)object2;
                }
                if (object2 instanceof AbleStringLiteral) {
                    string2 = ((AbleStringLiteral)object2).getStringValue();
                }
                if (!string.equals(string2)) return false;
                if (object3 instanceof AbleLiteral) {
                    int n3 = (int)((AbleLiteral)object3).getNumericValue();
                    if (n2 != n3) return false;
                    Vector vector3 = (Vector)vector.clone();
                    Vector vector4 = (Vector)vector2.clone();
                    return this.backwardChain(vector3, vector4, n + 1);
                }
                if (!(object3 instanceof AbleVariable)) return false;
                AbleVariable ableVariable2 = (AbleVariable)object3;
                if (ableVariable2.isBound()) {
                    if (n2 != (int)ableVariable2.getNumericValue()) return false;
                    Vector vector5 = (Vector)vector.clone();
                    Vector vector6 = (Vector)vector2.clone();
                    return this.backwardChain(vector5, vector6, n + 1);
                }
                ableVariable2.setGenericValue((Object)new AbleDoubleLiteral(n2));
                Vector vector7 = (Vector)vector.clone();
                Vector vector8 = (Vector)vector2.clone();
                return this.backwardChain(vector7, vector8, n + 1);
            }
            if (!(object2 instanceof AbleVariable)) return false;
            AbleVariable ableVariable3 = (AbleVariable)object2;
            if (ableVariable3.isBound()) {
                if (!string.equals(ableVariable3.getStringValue())) {
                    return false;
                }
                if (object3 instanceof AbleLiteral) {
                    int n4 = (int)((AbleLiteral)object3).getNumericValue();
                    if (n2 != n4) return false;
                    Vector vector9 = (Vector)vector.clone();
                    Vector vector10 = (Vector)vector2.clone();
                    return this.backwardChain(vector9, vector10, n + 1);
                }
                if (!(object3 instanceof AbleVariable)) return false;
                AbleVariable ableVariable4 = (AbleVariable)object3;
                if (ableVariable4.isBound()) {
                    if (n2 != (int)ableVariable4.getNumericValue()) return false;
                    Vector vector11 = (Vector)vector.clone();
                    Vector vector12 = (Vector)vector2.clone();
                    return this.backwardChain(vector11, vector12, n + 1);
                }
                ableVariable4.setGenericValue((Object)new AbleDoubleLiteral(n2));
                Vector vector13 = (Vector)vector.clone();
                Vector vector14 = (Vector)vector2.clone();
                return this.backwardChain(vector13, vector14, n + 1);
            }
            ableVariable3.setGenericValue((Object)this.myRuleSet.findOrCreateStringLiteral(string));
            if (object3 instanceof AbleLiteral) {
                int n5 = (int)((AbleLiteral)object3).getNumericValue();
                if (n2 != n5) return false;
                Vector vector15 = (Vector)vector.clone();
                Vector vector16 = (Vector)vector2.clone();
                return this.backwardChain(vector15, vector16, n + 1);
            }
            if (!(object3 instanceof AbleVariable)) return false;
            AbleVariable ableVariable5 = (AbleVariable)object3;
            if (ableVariable5.isBound()) {
                if (n2 != (int)ableVariable5.getNumericValue()) return false;
                Vector vector17 = (Vector)vector.clone();
                Vector vector18 = (Vector)vector2.clone();
                return this.backwardChain(vector17, vector18, n + 1);
            }
            ableVariable5.setGenericValue((Object)new AbleDoubleLiteral(n2));
            Vector vector19 = (Vector)vector.clone();
            Vector vector20 = (Vector)vector2.clone();
            return this.backwardChain(vector19, vector20, n + 1);
        }
        if (!(object instanceof AbleVariable)) return false;
        return false;
    }

    protected boolean unify_2(AblePredicate ablePredicate, Vector vector, Vector vector2, int n) throws AbleDataException {
        Vector vector3;
        Vector vector4;
        Object object;
        Object object2;
        boolean bl;
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "unify/2"});
        }
        if (bl = this.match(object2 = ablePredicate.getArgument(0), object = ablePredicate.getArgument(1), vector4 = new Vector(), vector3 = new Vector())) {
            Vector vector5 = (Vector)vector.clone();
            Vector vector6 = (Vector)vector2.clone();
            if (vector3.size() > 0) {
                vector6.addAll(0, vector3);
            }
            return this.backwardChain(vector5, vector6, n + 1);
        }
        return false;
    }

    protected boolean consult_1(AblePredicate ablePredicate, Vector vector, Vector vector2, int n) throws AbleDataException {
        Object object;
        Object object2;
        Object object3;
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "consult/1"});
        }
        Object object4 = ablePredicate.getArgument(0);
        String string = null;
        if (object4 instanceof AbleStringLiteral) {
            string = ((AbleStringLiteral)object4).getStringValue();
        } else if (object4 instanceof AbleVariable) {
            object3 = (AbleVariable)object4;
            if (object3.isBound()) {
                string = object3.getStringValue();
            } else {
                return false;
            }
        }
        object3 = new StringBuffer();
        AbleRuleBlock ableRuleBlock = null;
        try {
            object2 = new FileReader(string);
            object = new BufferedReader((Reader)object2);
            do {
                String string2 = ((BufferedReader)object).readLine();
                ((StringBuffer)object3).append(string2 + Able.LS);
            } while (((BufferedReader)object).ready());
        }
        catch (IOException iOException) {
            throw new AbleDataException(iOException.getLocalizedMessage(), (Throwable)iOException);
        }
        object2 = ((StringBuffer)object3).toString();
        try {
            ableRuleBlock = this.myRuleSet.parseConsultRuleBlockFromARL((String)object2);
            object = (Vector)ableRuleBlock.getRules().clone();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                AbleRule ableRule = (AbleRule)((Vector)object).get(i);
                this.myRuleSet.removeRule(ableRule);
                this.myRuleSet.addRule(this.myRuleBlock, ableRule);
                this.myWorkingMemory.assertz(ableRule);
            }
            this.myRuleSet.removeRuleBlock(ableRuleBlock.getRuleBlockKey());
        }
        catch (AbleParException ableParException) {
            throw new AbleDataException(ableParException.getMessage(), (Throwable)((Object)ableParException));
        }
        object = (Vector)vector.clone();
        Vector vector3 = (Vector)vector2.clone();
        return this.backwardChain((Vector)object, vector3, n + 1);
    }

    protected boolean assert_1(AblePredicate ablePredicate, Vector vector, Vector vector2, int n) throws AbleDataException {
        Object object;
        Object object2;
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "assert/1"});
        }
        if ((object2 = ablePredicate.getArgument(0)) instanceof AbleVariable && ((AbleVariable)object2).isBound()) {
            object2 = ((AbleVariable)object2).getGenericValue();
        }
        if (object2 instanceof AblePredicate) {
            object = (AblePredicate)object2;
            if (object.isBound()) {
                object2 = object.makeGround();
            }
            object2 = new AblePredicateFact("", (AblePredicate)object2, this.myRuleSet);
        }
        this.myWorkingMemory.assertFact(object2);
        object = (Vector)vector.clone();
        Vector vector3 = (Vector)vector2.clone();
        return this.backwardChain((Vector)object, vector3, n + 1);
    }

    protected boolean asserta_1(AblePredicate ablePredicate, Vector vector, Vector vector2, int n) throws AbleDataException {
        Object object;
        Object object2;
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "asserta/1"});
        }
        if ((object2 = ablePredicate.getArgument(0)) instanceof AbleVariable && ((AbleVariable)object2).isBound()) {
            object2 = ((AbleVariable)object2).getGenericValue();
        }
        if (object2 instanceof AblePredicate) {
            object = (AblePredicate)object2;
            if (object.isBound()) {
                object2 = object.makeGround();
            }
            object2 = new AblePredicateFact("", (AblePredicate)object2, this.myRuleSet);
        }
        this.myWorkingMemory.asserta(object2);
        object = (Vector)vector.clone();
        Vector vector3 = (Vector)vector2.clone();
        return this.backwardChain((Vector)object, vector3, n + 1);
    }

    protected boolean assertz_1(AblePredicate ablePredicate, Vector vector, Vector vector2, int n) throws AbleDataException {
        Object object;
        Object object2;
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "assertz/1"});
        }
        if ((object2 = ablePredicate.getArgument(0)) instanceof AbleVariable && ((AbleVariable)object2).isBound()) {
            object2 = ((AbleVariable)object2).getGenericValue();
        }
        if (object2 instanceof AblePredicate) {
            object = (AblePredicate)object2;
            if (object.isBound()) {
                object2 = object.makeGround();
            }
            object2 = new AblePredicateFact("", (AblePredicate)object2, this.myRuleSet);
        }
        this.myWorkingMemory.assertz(object2);
        object = (Vector)vector.clone();
        Vector vector3 = (Vector)vector2.clone();
        return this.backwardChain((Vector)object, vector3, n + 1);
    }

    protected boolean retract_1(AblePredicate ablePredicate, Vector vector, Vector vector2, int n) throws AbleDataException {
        Object object;
        Object object2;
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "retract/1"});
        }
        if ((object2 = ablePredicate.getArgument(0)) instanceof AbleVariable && ((AbleVariable)object2).isBound()) {
            object2 = ((AbleVariable)object2).getGenericValue();
        }
        if (object2 instanceof AblePredicate) {
            object = (AblePredicate)object2;
            if (object.isBound()) {
                object2 = object.makeGround();
            }
            object2 = new AblePredicateFact("", (AblePredicate)object2, this.myRuleSet);
        }
        this.myWorkingMemory.retract(object2);
        object = (Vector)vector.clone();
        Vector vector3 = (Vector)vector2.clone();
        return this.backwardChain((Vector)object, vector3, n + 1);
    }

    protected boolean retractall_1(AblePredicate ablePredicate, Vector vector, Vector vector2, int n) throws AbleDataException {
        Object object;
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "retractall/1"});
        }
        if ((object = ablePredicate.getArgument(0)) instanceof AbleVariable && ((AbleVariable)object).isBound()) {
            object = ((AbleVariable)object).getGenericValue();
        }
        if (object instanceof AblePredicate) {
            AblePredicate ablePredicate2 = (AblePredicate)object;
            if (ablePredicate2.isBound()) {
                object = ablePredicate2.makeGround();
            }
            object = new AblePredicateFact("", (AblePredicate)object, this.myRuleSet);
            while (this.myWorkingMemory.exists(object)) {
                this.myWorkingMemory.retract(object);
            }
            Vector vector3 = (Vector)vector.clone();
            Vector vector4 = (Vector)vector2.clone();
            return this.backwardChain(vector3, vector4, n + 1);
        }
        return false;
    }

    protected boolean member_2(AblePredicate ablePredicate, Vector vector, Vector vector2, int n) throws AbleDataException {
        Object object;
        boolean bl = true;
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "member/2"});
        }
        Object object2 = ablePredicate.getArgument(0);
        Object object3 = ablePredicate.getArgument(1);
        if (object2 instanceof AbleVariable && (object = (AbleVariable)object2).isBound()) {
            object2 = object.getGenericValue();
        }
        if (object3 instanceof AbleVariable && (object = (AbleVariable)object3).isBound()) {
            object3 = object.getGenericValue();
        }
        if (object2 instanceof AbleVariable) {
            Object object4;
            object = (AbleVariable)object2;
            if (!(object3 instanceof AblePredicate)) {
                return false;
            }
            AblePredicate ablePredicate2 = (AblePredicate)object3;
            if (ablePredicate2.isEmptyList()) {
                return false;
            }
            Object object5 = null;
            Object object6 = ablePredicate2;
            do {
                object5 = object6.getHead();
                object.setGenericValue(object5);
                Vector vector3 = (Vector)vector.clone();
                Vector vector4 = (Vector)vector2.clone();
                bl = this.backwardChain(vector3, vector4, n + 1);
            } while ((object6 = (object4 = object6.getTail()) instanceof AblePredicate ? (AblePredicate)object4 : null) != null && !object6.isEmptyList());
            return bl;
        }
        if (object3 instanceof AblePredicate && ((AblePredicate)object3).isList()) {
            if (((AblePredicate)object3).isMember(object2)) {
                object = (Vector)vector.clone();
                Vector vector5 = (Vector)vector2.clone();
                return this.backwardChain((Vector)object, vector5, n + 1);
            }
            return false;
        }
        return false;
    }

    protected boolean var_1(AblePredicate ablePredicate, Vector vector, Vector vector2, int n) throws AbleDataException {
        Object object;
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "var/1"});
        }
        if ((object = ablePredicate.getArgument(0)) instanceof AbleVariable) {
            Vector vector3 = (Vector)vector.clone();
            Vector vector4 = (Vector)vector2.clone();
            return this.backwardChain(vector3, vector4, n + 1);
        }
        return false;
    }

    protected boolean nonvar_1(AblePredicate ablePredicate, Vector vector, Vector vector2, int n) throws AbleDataException {
        Object object;
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "nonvar/1"});
        }
        if (!((object = ablePredicate.getArgument(0)) instanceof AbleVariable)) {
            Vector vector3 = (Vector)vector.clone();
            Vector vector4 = (Vector)vector2.clone();
            return this.backwardChain(vector3, vector4, n + 1);
        }
        return false;
    }

    protected boolean univ_2(AblePredicate ablePredicate, Vector vector, Vector vector2, int n) throws AbleDataException {
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain()", "Tr_RsPredicateBcProcessed", new Object[]{Integer.toString(n), "univ/2"});
        }
        Object object = ablePredicate.getArgument(0);
        Object object2 = ablePredicate.getArgument(1);
        if (object instanceof AbleVariable && ((AbleVariable)object).isBound()) {
            object = ((AbleVariable)object).getGenericValue();
        }
        if (object2 instanceof AbleVariable && ((AbleVariable)object2).isBound()) {
            object2 = ((AbleVariable)object2).getGenericValue();
        }
        if (object instanceof AbleVariable && object2 instanceof AblePredicate && ((AblePredicate)object2).isList()) {
            Object object3;
            Object object4;
            AblePredicate ablePredicate2 = (AblePredicate)object2;
            Vector vector3 = ablePredicate2.getListArguments();
            String string = null;
            Object e = vector3.get(0);
            if (e instanceof String) {
                string = (String)e;
            } else if (e instanceof AbleStringLiteral) {
                string = ((AbleStringLiteral)e).getStringValue();
            } else if (e instanceof AbleVariable && (string = ((AbleVariable)e).getStringValue()).startsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
            vector3.removeElementAt(0);
            if (vector3.size() == 1 && (object4 = vector3.get(0)) instanceof AbleVariable && (object3 = ((AbleVariable)object4).getGenericValue()) instanceof AblePredicate && ((AblePredicate)object3).isList()) {
                vector3 = ((AblePredicate)object3).getListArguments();
            }
            object4 = new AblePredicate(string, vector3);
            ((AbleVariable)object).setGenericValue(object4);
            object3 = (Vector)vector.clone();
            Vector vector4 = (Vector)vector2.clone();
            return this.backwardChain((Vector)object3, vector4, n + 1);
        }
        if (object instanceof AblePredicate && object2 instanceof AbleVariable) {
            AblePredicate ablePredicate3 = (AblePredicate)object;
            AbleVariable ableVariable = (AbleVariable)object2;
            Vector vector5 = ablePredicate3.getArguments();
            String string = ablePredicate3.getFunctor();
            vector5.add(0, this.myRuleSet.findOrCreateStringLiteral(string));
            vector5.add(AblePredicate.EmptyListPredicate);
            AblePredicate ablePredicate4 = new AblePredicate(".", vector5);
            if (ableVariable.isBound()) {
                Vector vector6 = new Vector();
                if (this.match(ablePredicate4, ableVariable.getGenericValue(), vector6, vector2)) {
                    Vector vector7 = (Vector)vector.clone();
                    Vector vector8 = (Vector)vector2.clone();
                    return this.backwardChain(vector7, vector8, n + 1);
                }
                return false;
            }
            ableVariable.setGenericValue((Object)ablePredicate4);
            Vector vector9 = (Vector)vector.clone();
            Vector vector10 = (Vector)vector2.clone();
            return this.backwardChain(vector9, vector10, n + 1);
        }
        if (object instanceof AblePredicate && object2 instanceof AblePredicate) {
            AblePredicate ablePredicate5 = (AblePredicate)object;
            AblePredicate ablePredicate6 = (AblePredicate)object2;
            Vector vector11 = ablePredicate5.getArguments();
            String string = ablePredicate5.getFunctor();
            vector11.add(AblePredicate.EmptyListPredicate);
            AblePredicate ablePredicate7 = new AblePredicate(".", vector11);
            if (ablePredicate6.isList()) {
                AbleVariable ableVariable;
                Object object5 = ablePredicate6.getHead();
                Object object6 = ablePredicate6.getTail();
                if (object5 instanceof AbleVariable) {
                    ableVariable = (AbleVariable)object5;
                    if (ableVariable.isBound()) {
                        if (!string.equals(ableVariable.getStringValue())) {
                            return false;
                        }
                    } else {
                        ableVariable.setGenericValue((Object)string);
                    }
                }
                if (object6 instanceof AbleVariable) {
                    ableVariable = (AbleVariable)object6;
                    if (ableVariable.isBound()) {
                        Vector vector12 = new Vector();
                        if (this.match(ablePredicate7, ableVariable.getGenericValue(), vector12, vector2)) {
                            Vector vector13 = (Vector)vector.clone();
                            Vector vector14 = (Vector)vector2.clone();
                            return this.backwardChain(vector13, vector14, n + 1);
                        }
                        return false;
                    }
                    ableVariable.setGenericValue((Object)ablePredicate7);
                    Vector vector15 = (Vector)vector.clone();
                    Vector vector16 = (Vector)vector2.clone();
                    return this.backwardChain(vector15, vector16, n + 1);
                }
            } else {
                return false;
            }
        }
        return false;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    public AbleWorkingMemory allocateWorkingMemory() {
        if (this.myWorkingMemory == null) {
            this.myWorkingMemory = new AblePredicateWorkingMemory(this.myRuleSet);
        }
        return this.myWorkingMemory;
    }
}

