/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleRd;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleRule;
import java.io.Serializable;
import java.util.Vector;

public class AblePolicyRule
extends AbleRule
implements Serializable {
    static final long serialVersionUID = 2003111200000000001L;
    protected AbleExpression myPolicyPreconditions = null;
    protected Vector myPolicyDecisions = new Vector();

    public AblePolicyRule(String string, AbleRd ableRd, AbleExpression ableExpression, Vector vector) {
        super(0, string, ableRd, null);
        this.myPolicyPreconditions = ableExpression;
        this.myPolicyDecisions = (Vector)vector.clone();
        this.ctorHelperSaveReferences();
    }

    private void ctorHelperSaveReferences() {
        if (this.myPolicyPreconditions != null) {
            this.addRdReferences(this.myPolicyPreconditions.getReferents());
        }
        if (!this.myPolicyDecisions.isEmpty()) {
            for (int i = 0; i < this.myPolicyDecisions.size(); ++i) {
                AbleConsequentClause ableConsequentClause = (AbleConsequentClause)this.myPolicyDecisions.elementAt(i);
                ableConsequentClause.addRuleRef(this);
                this.addRdReferences(ableConsequentClause.getReferents());
                this.addWrReference(ableConsequentClause.getLhsReferent());
            }
        }
        this.addHeaderRdReferences();
    }

    public final AbleExpression getPolicyPreconditions() {
        return this.myPolicyPreconditions;
    }

    public long numberOfPolicyPreconditions() {
        long l = 1L;
        if (this.myPolicyPreconditions == null) {
            l = 0L;
        }
        return l;
    }

    public final Vector getPolicyDecisions() {
        return this.myPolicyDecisions;
    }

    public long numberOfPolicyDecisions() {
        long l = 0L;
        if (this.myPolicyDecisions != null) {
            l = this.myPolicyDecisions.size();
        }
        return l;
    }

    public void reset() {
        this.myFiredFlag = false;
    }

    public String arlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "    " + this.myLabel;
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        if (this.myPriority == PriorityDefault) {
            stringBuffer3.append(": ");
        } else {
            stringBuffer3.append("[" + this.myPriority.arlCRdString() + "]: ");
        }
        stringBuffer2.append("      ");
        if (this.myComment.length() > 0 || !this.myProperties.isEmpty()) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        if (this.isTemplate()) {
            stringBuffer.append("template ");
        }
        stringBuffer.append(string);
        stringBuffer.append(this.arlPreConditionsString());
        stringBuffer.append(stringBuffer3.toString() + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "preconditions (" + Able.LS);
        if (this.myPolicyPreconditions != null) {
            stringBuffer.append(stringBuffer2.toString() + "  " + this.myPolicyPreconditions.arlCRdString() + Able.LS);
        }
        stringBuffer.append(stringBuffer2.toString() + ")" + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "decisions { " + Able.LS);
        stringBuffer.append(AblePolicyRule.arlActionBlockString(stringBuffer2.toString() + "  ", this.myPolicyDecisions));
        stringBuffer.append(stringBuffer2.toString() + "}");
        return stringBuffer.toString();
    }

    public String xmlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        stringBuffer.append("    <rule" + string + string2 + string3 + ">" + Able.LS);
        stringBuffer.append(this.xmlPreConditionsString());
        stringBuffer.append(this.xmlPriorityString());
        stringBuffer.append("      <policy>" + Able.LS);
        stringBuffer.append("      <policyPrecondition>" + Able.LS);
        if (this.myPolicyPreconditions != null) {
            stringBuffer.append(this.myPolicyPreconditions.xmlCRdString());
        }
        stringBuffer.append("      </policyPrecondition>" + Able.LS);
        stringBuffer.append("      <policyDecisions>" + Able.LS);
        for (int i = 0; i < this.myPolicyDecisions.size(); ++i) {
            stringBuffer.append("        <consequent>" + Able.LS);
            stringBuffer.append(((AbleConsequentClause)this.myPolicyDecisions.elementAt(i)).xmlString());
            stringBuffer.append("        </consequent>" + Able.LS);
        }
        stringBuffer.append("      </policyDecisions>" + Able.LS);
        stringBuffer.append("      </policy>" + Able.LS);
        stringBuffer.append("    </rule>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        String string4 = this.myFinalFlag ? " final=\"true\"" : "";
        stringBuffer.append("    <rule" + string + string2 + string3 + string4 + ">" + Able.LS);
        stringBuffer.append(this.armlPreConditionsString());
        stringBuffer.append(this.armlPriorityString());
        stringBuffer.append(this.armlPropertiesString());
        stringBuffer.append("      <policy>" + Able.LS);
        stringBuffer.append("      <policyPrecondition>" + Able.LS);
        if (this.myPolicyPreconditions != null) {
            stringBuffer.append(this.myPolicyPreconditions.xmlCRdString());
        }
        stringBuffer.append("      </policyPrecondition>" + Able.LS);
        stringBuffer.append("      <policyDecisions>" + Able.LS);
        for (int i = 0; i < this.myPolicyDecisions.size(); ++i) {
            stringBuffer.append("        <consequent>" + Able.LS);
            stringBuffer.append(((AbleConsequentClause)this.myPolicyDecisions.elementAt(i)).xmlString());
            stringBuffer.append("        </consequent>" + Able.LS);
        }
        stringBuffer.append("      </policyDecisions>" + Able.LS);
        stringBuffer.append("      </policy>" + Able.LS);
        stringBuffer.append("    </rule>" + Able.LS);
        return stringBuffer.toString();
    }

    public String getTemplateString(Vector vector) throws AbleDataException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTemplateHeaderString(vector));
        stringBuffer.append("preconditions (");
        if (this.myPolicyPreconditions != null) {
            stringBuffer.append(this.myPolicyPreconditions.getTemplateString(vector));
        }
        stringBuffer.append(")" + Able.LS);
        stringBuffer.append("decisions '{' " + Able.LS);
        stringBuffer.append(AblePolicyRule.getTemplateActionBlockString(vector, "        ", this.myPolicyDecisions));
        stringBuffer.append("}");
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.arlString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlString();
            }
            case 4: {
                return this.arlString();
            }
            case 5: {
                return this.xmlString();
            }
        }
        return this.arlString();
    }

    private String trcString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "    " + this.myLabel;
        int n3 = string.length();
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer2.append(" ");
        }
        if (this.myPriority == PriorityDefault) {
            stringBuffer3.append(": ");
        } else {
            stringBuffer3.append("[" + this.myPriority.traceString(n) + "]: ");
        }
        for (n2 = 0; n2 < stringBuffer3.length(); ++n2) {
            stringBuffer2.append(" ");
        }
        stringBuffer.append(string + stringBuffer3.toString() + "preconditions (" + Able.LS);
        if (this.myPolicyPreconditions != null) {
            stringBuffer.append(stringBuffer2.toString() + "  " + this.myPolicyPreconditions.traceString(n) + Able.LS);
        }
        stringBuffer.append(stringBuffer2.toString() + ")" + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "decisions {" + Able.LS);
        for (n2 = 0; n2 < this.myPolicyDecisions.size(); ++n2) {
            stringBuffer.append(stringBuffer2.toString() + "  " + ((AbleConsequentClause)this.myPolicyDecisions.elementAt(n2)).traceString(n) + Able.LS);
        }
        stringBuffer.append(stringBuffer2.toString() + "}");
        return stringBuffer.toString();
    }
}

