/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleLogger;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.rules.AbleInferenceEngine;
import com.ibm.able.rules.AblePolicyRule;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleBreakpoint;
import com.ibm.able.rules.AbleRuleSet;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class AblePolicyEngine
extends AbleInferenceEngine
implements Serializable {
    static final long serialVersionUID = 2003111200000000001L;
    static String clsNm = "AblePolicyEngine";
    private BitSet myFactBase = new BitSet();

    public AblePolicyEngine(AbleRuleSet ableRuleSet, AbleLogger ableLogger) {
        super(ableRuleSet, ableLogger);
    }

    public AblePolicyEngine(AbleRuleSet ableRuleSet, AbleLogger ableLogger, AbleRuleBlock ableRuleBlock) {
        super(ableRuleSet, ableLogger, ableRuleBlock);
    }

    public void setControlParameter(String string, Object object) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnsupportedControlParameter", (Object[])new Object[]{this.myRuleBlock.getEngineType(), string}));
    }

    public Object getControlParameter(String string) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnsupportedControlParameter", (Object[])new Object[]{this.myRuleBlock.getEngineType(), string}));
    }

    public boolean isRuleBlockValid(AbleRuleBlock ableRuleBlock) {
        boolean bl = true;
        String string = null;
        Iterator iterator = null;
        AbleRule ableRule = null;
        AbleRuleBlock ableRuleBlock2 = ableRuleBlock;
        String string2 = ableRuleBlock2.getName();
        String string3 = ableRuleBlock2.getEngineType();
        iterator = ableRuleBlock2.getPatternMatchRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoPatternMatchRulesAllowed", (Object[])new Object[]{string3, string2, ableRule.getIdLabelString()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getPredicateRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoPredicateRulesAllowed", (Object[])new Object[]{string3, string2, ableRule.getIdLabelString()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getIterationRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoIterationRulesAllowed", (Object[])new Object[]{string3, string2, ableRule.getIdLabelString()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getIfThenElseRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoIfThenElseRulesAllowed", (Object[])new Object[]{string3, string2, ableRule.getIdLabelString()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        return bl;
    }

    public void infer(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        AbleRuleBlock ableRuleBlock2 = ableRuleBlock;
        ableRuleBlock2.reset();
        this.myRulesFiredCount = 0;
        if (ableRuleBlock2 != null) {
            this.processAssertions(ableRuleBlock2);
        }
        if (ableRuleBlock2 != null) {
            this.fireFirstEligibleRule(ableRuleBlock2);
        }
    }

    private void fireFirstEligibleRule(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        String string = "fireFirstEligibleRule()";
        AblePolicyRule ablePolicyRule = null;
        Vector vector = new Vector();
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, string, "Tr_Rs_RuleBlockInferStarts", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType});
        }
        this.setInferenceContext(ableRuleBlock);
        if (this.myDebugLevel == 3) {
            this.fireEngineBreakpoint();
        }
        if (!(vector = this.selectAndRankEligibleRules(ableRuleBlock)).isEmpty()) {
            AbleRuleBreakpoint ableRuleBreakpoint;
            ablePolicyRule = this.selectBestRule(vector);
            this.setInferenceContext(ablePolicyRule);
            if (this.myDebugLevel == 1 && (ableRuleBreakpoint = ablePolicyRule.getBreakpoint()) != null && ableRuleBreakpoint.isEnabled()) {
                this.fireEngineBreakpoint();
            }
            this.processConsequent(ablePolicyRule);
            ++this.myRulesFiredCount;
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, string, "Tr_Rs_RuleBlockInferEnds", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType});
        }
    }

    private Vector selectAndRankEligibleRules(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        Vector vector = new Vector();
        Boolean bl = null;
        Enumeration enumeration = ableRuleBlock.getEnabledPolicyRules().elements();
        while (enumeration.hasMoreElements()) {
            AblePolicyRule ablePolicyRule = (AblePolicyRule)enumeration.nextElement();
            bl = this.checkPolicyPreconditions(ablePolicyRule);
            if (bl == null || !bl.booleanValue()) continue;
            this.addRuleToEligibleRuleList(vector, ablePolicyRule);
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.logEligibleRuleList(vector);
        }
        return vector;
    }

    private AblePolicyRule selectBestRule(Vector vector) {
        String string = "selectBestRule()";
        EligibleRuleListEntry_ eligibleRuleListEntry_ = null;
        AblePolicyRule ablePolicyRule = null;
        eligibleRuleListEntry_ = (EligibleRuleListEntry_)vector.elementAt(0);
        ablePolicyRule = (AblePolicyRule)eligibleRuleListEntry_.getRule();
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, string, "Tr_Rs_SelectRuleToFire", new Object[]{ablePolicyRule.getIdLabelString()});
        }
        return ablePolicyRule;
    }

    private Boolean checkPolicyPreconditions(AblePolicyRule ablePolicyRule) throws AbleDataException {
        String string = "checkPolicyPreconditions()";
        Boolean bl = null;
        AbleExpression ableExpression = ablePolicyRule.getPolicyPreconditions();
        this.setInferenceContext(ablePolicyRule);
        if (ableExpression == null) {
            bl = Boolean.TRUE;
            ablePolicyRule.setBooleanTruth(bl);
            return bl;
        }
        bl = AblePolicyEngine.evalAntecedentExpression(ableExpression);
        if (this.myRuleSet.isInferenceTraceMedium()) {
            if (bl == null) {
                this.myTracer.message(0x20000000000L, (Object)this, string, "Tr_Rs_AntecedentNull", new Object[]{ablePolicyRule.getIdLabelString()});
            } else if (!bl.booleanValue()) {
                this.myTracer.message(0x20000000000L, (Object)this, string, "Tr_Rs_AntecedentFalse", new Object[]{ablePolicyRule.getIdLabelString()});
            } else {
                this.myTracer.message(0x20000000000L, (Object)this, string, "Tr_Rs_AntecedentTrue", new Object[]{ablePolicyRule.getIdLabelString()});
            }
        }
        ablePolicyRule.setBooleanTruth(bl);
        return bl;
    }

    private void addRuleToEligibleRuleList(Vector vector, AbleRule ableRule) throws AbleDataException {
        double d = ableRule.getPriority();
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            EligibleRuleListEntry_ eligibleRuleListEntry_ = (EligibleRuleListEntry_)vector.elementAt(i);
            double d2 = eligibleRuleListEntry_.getBusinessValue();
            if (!(d > d2)) continue;
            vector.insertElementAt(new EligibleRuleListEntry_(ableRule, d), i);
            bl = true;
            break;
        }
        if (!bl) {
            vector.addElement(new EligibleRuleListEntry_(ableRule, d));
        }
    }

    protected void logEligibleRuleList(Vector vector) {
        String string = "logEligibleRuleList()";
        EligibleRuleListEntry_ eligibleRuleListEntry_ = null;
        AbleRule ableRule = null;
        double d = 0.0;
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < vector.size(); ++i) {
            eligibleRuleListEntry_ = (EligibleRuleListEntry_)vector.elementAt(i);
            ableRule = eligibleRuleListEntry_.getRule();
            d = eligibleRuleListEntry_.getBusinessValue();
            if (i == 0) {
                stringBuffer.append(ableRule.getIdLabelString());
                stringBuffer.append("/BV=" + d);
                continue;
            }
            stringBuffer.append(Able.LS + ableRule.getIdLabelString());
            stringBuffer.append("/BV=" + d);
        }
        System.out.println(stringBuffer.toString());
        this.myTracer.message(0x20000000000L, (Object)this, string, "Tr_Rs_ConflictSetContents", new Object[]{Integer.toString(vector.size()), stringBuffer.toString()});
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    public final class EligibleRuleListEntry_
    implements Serializable {
        static final long serialVersionUID = 2003112000000000001L;
        private AbleRule myRule = null;
        private double myBusinessValue = 0.0;

        public EligibleRuleListEntry_(AbleRule ableRule, double d) {
            this.myRule = ableRule;
            this.myBusinessValue = d;
        }

        public EligibleRuleListEntry_(EligibleRuleListEntry_ eligibleRuleListEntry_) {
            this.myRule = eligibleRuleListEntry_.getRule();
            this.myBusinessValue = eligibleRuleListEntry_.getBusinessValue();
        }

        public AbleRule getRule() {
            return this.myRule;
        }

        public double getBusinessValue() {
            return this.myBusinessValue;
        }

        public String prettyPrint() {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append("\n\tRule.............\t");
            stringBuffer.append(this.myRule);
            stringBuffer.append("\n\tBusiness value...\t");
            stringBuffer.append(this.myBusinessValue);
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }
}

