/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.data.AbleArrayVariable;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class AblePlanningRule
extends AbleRule
implements Serializable {
    static final long serialVersionUID = 2001011800000000001L;
    static String clsNm = "AblePlanningRule";
    protected AbleExpression myPrecondition;
    protected HashSet myBindings;
    protected Vector myEffects;
    protected Vector myParameters;

    public AblePlanningRule(String string, AbleRd ableRd, Vector vector, AbleExpression ableExpression, Vector vector2, AbleRuleSet ableRuleSet) {
        super(0, string, ableRd, ableRuleSet);
        this.myParameters = (Vector)vector.clone();
        this.myPrecondition = ableExpression;
        this.myEffects = (Vector)vector2.clone();
        this.myBindings = new HashSet();
        this.ctorHelperSaveReferences();
    }

    private void ctorHelperSaveReferences() {
        this.addHeaderRdReferences();
        if (this.myPrecondition != null) {
            this.addRdReferences(this.myPrecondition.getReferents());
        }
        for (int i = 0; i < this.myEffects.size(); ++i) {
            AbleConsequentClause ableConsequentClause = (AbleConsequentClause)this.myEffects.elementAt(i);
            if (ableConsequentClause == null) continue;
            ableConsequentClause.addRuleRef(this);
            this.addRdReferences(ableConsequentClause.getReferents());
            this.addWrReference(ableConsequentClause.getLhsReferent());
        }
    }

    public final AbleExpression getPrecondition() {
        return this.myPrecondition;
    }

    public final Vector getEffects() {
        return this.myEffects;
    }

    public final Collection getBindings() {
        return this.myBindings;
    }

    public final Vector getRuleBindings() {
        if (!this.myBindings.isEmpty()) {
            Iterator iterator = this.myBindings.iterator();
            Vector vector = (Vector)iterator.next();
            iterator.remove();
            this.setBindings(this.myBindings);
            return vector;
        }
        return null;
    }

    public void setBindings(HashSet hashSet) {
        this.myBindings = hashSet;
        int n = this.myBindings.size();
        this.myBooleanTruth = n == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public void setBindings(Collection collection) {
        if (collection instanceof HashSet) {
            this.setBindings((HashSet)collection);
        } else {
            this.setBindings(new HashSet(collection));
        }
    }

    public void removeBindings(Vector vector) {
    }

    public Vector getParameters() {
        return this.myParameters;
    }

    public Vector getVariables() {
        return this.myParameters;
    }

    public boolean isTriggered() {
        return this.myBooleanTruth;
    }

    public void reset() {
        this.myFiredFlag = false;
        this.myBooleanTruth = Boolean.FALSE;
        this.myBindings.clear();
    }

    public String arlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = this.myEffects.size();
        int n2 = this.myParameters.size();
        String string = "    " + this.myLabel;
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        if (this.myPriority == PriorityDefault) {
            stringBuffer3.append(": ");
        } else {
            stringBuffer3.append("[" + this.myPriority.arlCRdString() + "]: ");
        }
        stringBuffer2.append("      ");
        if (this.myComment.length() > 0 || !this.myProperties.isEmpty()) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        if (this.isTemplate()) {
            stringBuffer.append("template ");
        }
        stringBuffer.append(string);
        stringBuffer.append(this.arlPreConditionsString());
        stringBuffer.append(stringBuffer3.toString() + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "parameters( ");
        AbleVariable ableVariable = null;
        if (n2 > 0) {
            ableVariable = (AbleVariable)this.myParameters.get(0);
            stringBuffer.append(ableVariable.getDataTypeName() + " " + ableVariable.getName());
        }
        for (int i = 1; i < n2; ++i) {
            ableVariable = (AbleVariable)this.myParameters.get(i);
            stringBuffer.append(", " + ableVariable.getDataTypeName() + " " + ableVariable.getName());
        }
        stringBuffer.append(" )" + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "precondition ( ");
        stringBuffer.append(this.myPrecondition.arlCRdString());
        stringBuffer.append(Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "    )" + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "effect { ");
        stringBuffer.append(AblePlanningRule.arlActionBlockString(stringBuffer2.toString() + "      ", this.myEffects));
        stringBuffer.append(stringBuffer2.toString() + "    }" + Able.LS);
        return stringBuffer.toString();
    }

    public String xmlString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.myEffects.size();
        int n3 = this.myParameters.size();
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        stringBuffer.append("    <rule" + string + string2 + string3 + ">" + Able.LS);
        stringBuffer.append(this.xmlPreConditionsString());
        stringBuffer.append(this.xmlPriorityString());
        stringBuffer.append("      <plan>" + Able.LS);
        stringBuffer.append("    <parameters>" + Able.LS);
        for (n = 0; n < n3; ++n) {
            AbleVariable ableVariable = (AbleVariable)this.myParameters.get(n);
            stringBuffer.append("      <formalParameter ");
            stringBuffer.append(" type=\"" + ableVariable.getDataTypeName() + "\"" + " name=\"" + ableVariable.getName() + "\"" + " isArray=\"" + (ableVariable instanceof AbleArrayVariable ? "true" : "false") + "\"");
            stringBuffer.append("/>" + Able.LS);
        }
        stringBuffer.append("    </parameters>" + Able.LS);
        stringBuffer.append("    <precondition>" + Able.LS);
        stringBuffer.append(this.myPrecondition.xmlCRdString());
        stringBuffer.append("    </precondition>" + Able.LS);
        stringBuffer.append("    <effect>" + Able.LS);
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("      <action>" + Able.LS);
            stringBuffer.append(((AbleConsequentClause)this.myEffects.elementAt(n)).xmlString() + Able.LS);
            stringBuffer.append("      </action>" + Able.LS);
        }
        stringBuffer.append("    </effect>" + Able.LS);
        stringBuffer.append("    </plan>" + Able.LS);
        stringBuffer.append("     </rule>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.myEffects.size();
        int n3 = this.myParameters.size();
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        String string4 = this.myFinalFlag ? " final=\"true\"" : "";
        stringBuffer.append("    <PlanRule" + string + string2 + string3 + string4 + ">" + Able.LS);
        stringBuffer.append(this.armlPreConditionsString());
        stringBuffer.append(this.armlPriorityString());
        stringBuffer.append(this.armlPropertiesString());
        stringBuffer.append("    <parameters>" + Able.LS);
        for (n = 0; n < n3; ++n) {
            AbleVariable ableVariable = (AbleVariable)this.myParameters.get(n);
            stringBuffer.append("      <formalParameter ");
            stringBuffer.append(" type=\"" + ableVariable.getDataTypeName() + "\"" + " name=\"" + ableVariable.getName() + "\"" + " isArray=\"" + (ableVariable instanceof AbleArrayVariable ? "true" : "false") + "\"");
            stringBuffer.append("/>" + Able.LS);
        }
        stringBuffer.append("    </parameters>" + Able.LS);
        stringBuffer.append("    <precondition>" + Able.LS);
        stringBuffer.append(this.myPrecondition.armlCRdString());
        stringBuffer.append("    </precondition>" + Able.LS);
        stringBuffer.append("    <effects>" + Able.LS);
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(((AbleConsequentClause)this.myEffects.elementAt(n)).armlString() + Able.LS);
        }
        stringBuffer.append("    </effects>" + Able.LS);
        stringBuffer.append("     </PlanRule>" + Able.LS);
        return stringBuffer.toString();
    }

    public String getTemplateString(Vector vector) throws AbleDataException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.myEffects.size();
        int n2 = this.myParameters.size();
        StringBuffer stringBuffer2 = new StringBuffer("");
        stringBuffer.append(this.getTemplateHeaderString(vector));
        stringBuffer2.append("      ");
        stringBuffer.append(stringBuffer2.toString() + "parameters( ");
        AbleVariable ableVariable = null;
        if (n2 > 0) {
            ableVariable = (AbleVariable)this.myParameters.get(0);
            stringBuffer.append(ableVariable.getDataTypeName() + " " + ableVariable.getName());
        }
        for (int i = 1; i < n2; ++i) {
            ableVariable = (AbleVariable)this.myParameters.get(i);
            stringBuffer.append(", " + ableVariable.getDataTypeName() + " " + ableVariable.getName());
        }
        stringBuffer.append(" )" + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "precondition ( ");
        stringBuffer.append(this.myPrecondition.getTemplateString(vector));
        stringBuffer.append(Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "    )" + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "effect  '{' ");
        stringBuffer.append(AblePlanningRule.getTemplateActionBlockString(vector, stringBuffer2.toString() + "  ", this.myEffects));
        stringBuffer.append(stringBuffer2.toString() + "    '}'" + Able.LS);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.arlString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlString();
            }
            case 4: {
                return this.arlString();
            }
            case 5: {
                return this.xmlString();
            }
        }
        return this.arlString();
    }

    private String trcString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("");
        int n3 = this.myEffects.size();
        int n4 = this.myParameters.size();
        String string = "    " + this.myLabel;
        int n5 = this.myLabel.length();
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        for (n2 = 0; n2 < n5; ++n2) {
            stringBuffer2.append(" ");
        }
        if (this.myPriority == PriorityDefault) {
            stringBuffer3.append(": ");
        } else {
            stringBuffer3.append("[" + this.myPriority.traceString(n) + "]: ");
        }
        for (n2 = 0; n2 < stringBuffer3.length(); ++n2) {
            stringBuffer2.append(" ");
        }
        stringBuffer.append(stringBuffer2.toString() + "parameters( ");
        if (n4 > 0) {
            stringBuffer.append(((AbleVariable)this.myParameters.get(0)).arlCRdString());
        }
        for (n2 = 1; n2 < n4; ++n2) {
            stringBuffer.append(", " + ((AbleVariable)this.myParameters.get(n2)).arlCRdString());
        }
        stringBuffer.append(" );");
        stringBuffer.append(string + stringBuffer3.toString() + "precondition (");
        stringBuffer.append(this.myPrecondition.traceString(n));
        stringBuffer.append(Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "         )" + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "      effect {");
        stringBuffer.append(((AbleConsequentClause)this.myEffects.elementAt(0)).traceString(n));
        for (n2 = 1; n2 < n3; ++n2) {
            stringBuffer.append(Able.LS);
            stringBuffer.append(stringBuffer2.toString() + "          " + ((AbleConsequentClause)this.myEffects.elementAt(n2)).traceString(n));
        }
        stringBuffer.append(Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "         }" + Able.LS);
        return stringBuffer.toString();
    }
}

