/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleLogger;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleGenericLiteral;
import com.ibm.able.data.AblePredicate;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleStringLiteral;
import com.ibm.able.data.AbleTypedVariable;
import com.ibm.able.data.AbleTypedVariableMethodLiteral;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.planner4J.planners.IDomain;
import com.ibm.able.planner4J.planners.IPlanSolution;
import com.ibm.able.planner4J.planners.IPlanner;
import com.ibm.able.planner4J.planners.IProblem;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.ActionImpl;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.ClassicalPlanner;
import com.ibm.able.planner4J.planners.classicalPlannerImpl.PredicateImpl;
import com.ibm.able.planner4J.planners.htnPlannerImpl.HTNPlanner;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleInferenceEngine;
import com.ibm.able.rules.AblePlanningClassicalProblemBuilder;
import com.ibm.able.rules.AblePlanningHTNProblemBuilder;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class AblePlanningEngine
extends AbleInferenceEngine
implements Serializable {
    static String clsNm = "AblePlanningEngine";
    static final long serialVersionUID = 8496173375932306933L;
    protected IDomain myDomainObj;
    protected IProblem myProblemObj;
    protected IPlanner myPlanner;
    protected IPlanSolution myResult;
    protected boolean myDebugFlag = false;
    protected boolean myHTNProblemFlag = false;
    protected boolean myProblemInitObjectsExplicitFlag = true;
    protected AbleExpression[] myProblemInitObjects;
    protected AbleExpression[] myInitialState;
    protected AbleExpression myGoalState;
    protected String myDomain;
    protected String myDomainFile;
    protected String myProblemFile;
    protected Object[] myRequirements;
    protected HashMap myParams;
    protected Class myDomainActionsClass = null;
    protected ArrayList myExecutablePlan = new ArrayList();

    public AblePlanningEngine(AbleRuleSet ableRuleSet, AbleLogger ableLogger, AbleRuleBlock ableRuleBlock) {
        super(ableRuleSet, ableLogger, ableRuleBlock);
        System.out.println("AblePlanningEngine instance created!");
    }

    public boolean isRuleBlockValid(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        boolean bl = true;
        String string = null;
        Iterator iterator = null;
        AbleRule ableRule = null;
        AbleRuleBlock ableRuleBlock2 = ableRuleBlock;
        String string2 = ableRuleBlock2.getName();
        iterator = ableRuleBlock2.getIterationRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoIterationRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getPredicateRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoPredicateRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getConditionalRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoConditionalRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getIfThenElseRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoIfThenElseRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getPatternMatchRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoPatternMatchRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        return bl;
    }

    public void infer(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        String string;
        Object object;
        AbleRuleBlock ableRuleBlock2 = ableRuleBlock;
        this.myWorkingMemory = this.myRuleSet.getWorkingMemory();
        if (ableRuleBlock2 != null) {
            this.processAssertions(ableRuleBlock2);
        }
        if (this.myProblemInitObjects == null) {
            this.myProblemInitObjectsExplicitFlag = false;
        }
        String string2 = "";
        for (int i = 0; i < this.myRequirements.length; ++i) {
            string2 = (String)this.myRequirements[i];
            if (!string2.equalsIgnoreCase(":htn")) continue;
            this.myHTNProblemFlag = true;
        }
        if (!this.myHTNProblemFlag) {
            object = new AblePlanningClassicalProblemBuilder(this, this.myRuleSet, this.myTracer, this.myRuleBlock);
            if (object != null) {
                ((AblePlanningClassicalProblemBuilder)object).buildPlanningDomain();
                ((AblePlanningClassicalProblemBuilder)object).buildPlanningProblem();
                this.myDomainObj = ((AblePlanningClassicalProblemBuilder)object).getDomainObj();
                this.myProblemObj = ((AblePlanningClassicalProblemBuilder)object).getProblemObj();
                this.myPlanner = new ClassicalPlanner().createPlanner();
            }
        } else {
            object = new AblePlanningHTNProblemBuilder(this, this.myRuleSet, this.myTracer, this.myRuleBlock);
            if (object != null) {
                ((AblePlanningHTNProblemBuilder)object).buildPlanningDomain();
                ((AblePlanningHTNProblemBuilder)object).buildPlanningProblem();
                this.myDomainObj = ((AblePlanningHTNProblemBuilder)object).getDomainObj();
                this.myProblemObj = ((AblePlanningHTNProblemBuilder)object).getProblemObj();
                this.myPlanner = new HTNPlanner().createPlanner();
            }
        }
        if (this.myParams == null) {
            object = new HashMap();
            string = "debug";
            String string3 = "false";
            ((HashMap)object).put(string, string3);
            string = "searchLimit";
            string3 = "100000";
            ((HashMap)object).put(string, string3);
            string = "heuristicWeight";
            string3 = "5";
            ((HashMap)object).put(string, string3);
            this.myParams = object;
        }
        if (ableRuleBlock2 != null) {
            if (this.myRuleSet.isInferenceTraceMedium()) {
                this.myTracer.message(0x20000000000L, (Object)clsNm, "infer()", "Tr_Rs_RuleBlockInferStarts", new Object[]{ableRuleBlock2.getName(), ableRuleBlock2.myEngineType});
            }
            this.myRuleSet.myInferenceContext.setRuleBlock(ableRuleBlock2);
            if (this.myDebugLevel == 3) {
                this.fireEngineBreakpoint();
            }
            if (this.myDomainFile != null && this.myProblemFile != null) {
                object = this.myDomainFile;
                string = this.myProblemFile;
                this.myPlanner = null;
                this.myResult = null;
                this.myExecutablePlan.clear();
                this.myPlanner = new ClassicalPlanner().createPlanner((String)object, string, this.myParams);
                this.myResult = this.myPlanner.generatePlan();
            } else if (this.myDomainObj == null || this.myProblemObj == null) {
                System.out.println("Error -- no domain or problem object could be created !!");
            } else {
                this.myResult = null;
                this.myExecutablePlan.clear();
                this.myPlanner.setDomain(this.myDomainObj);
                this.myPlanner.setProblem(this.myProblemObj);
                this.myPlanner.setParameterMap(this.myParams);
                this.myResult = this.myPlanner.generatePlan();
            }
            System.out.println("Invocation result = " + this.myResult);
            if (this.myResult != null && this.myResult.isSolved()) {
                if (this.myDomainActionsClass != null) {
                    this.convertPlanToExecutableForm();
                } else {
                    this.convertPlanToStringForm();
                }
            } else {
                this.myExecutablePlan.clear();
            }
            System.out.println("** planner call completed!");
            if (this.myRuleSet.isInferenceTraceMedium()) {
                this.myTracer.message(0x20000000000L, (Object)clsNm, "infer()", "Tr_Rs_RuleBlockInferEnds", new Object[]{ableRuleBlock2.getName(), ableRuleBlock2.myEngineType});
            }
        }
    }

    public void convertPlanToExecutableForm() throws AbleDataException {
        ArrayList arrayList = this.myResult.getSequentialPlanActions();
        int n = arrayList.size();
        String string = this.myDomainActionsClass.getName();
        Package package_ = this.myDomainActionsClass.getPackage();
        String string2 = "";
        if (package_ != null) {
            string2 = package_.getName();
        }
        int n2 = string2.length();
        String string3 = string.substring(n2 + 1);
        AbleVariable ableVariable = this.myRuleSet.getVariable(string3);
        AbleTypedVariable ableTypedVariable = (AbleTypedVariable)ableVariable;
        this.myExecutablePlan.clear();
        for (int i = 0; i < n; ++i) {
            ActionImpl actionImpl = (ActionImpl)arrayList.get(i);
            String string4 = actionImpl.getActionName();
            int n3 = actionImpl.getNumParam();
            Vector<AbleStringLiteral> vector = new Vector<AbleStringLiteral>();
            for (int j = 0; j < n3; ++j) {
                vector.addElement(this.myRuleSet.findOrCreateStringLiteral(actionImpl.getParam(j)));
            }
            this.myTracer.message(0x20000000000L, (Object)clsNm, "convertPlanToExecutableForm()", "Creating methodLit with: var<" + ableTypedVariable.traceString(1) + ">; method<" + string4 + ">; args<" + vector + ">.");
            AbleTypedVariableMethodLiteral ableTypedVariableMethodLiteral = new AbleTypedVariableMethodLiteral(ableTypedVariable, string4, vector);
            this.myTracer.message(0x20000000000L, (Object)clsNm, "convertPlanToExecutableForm()", "methodLit is " + ableTypedVariableMethodLiteral);
            AbleConsequentClause ableConsequentClause = new AbleConsequentClause(null, 10, (AbleRd)ableTypedVariableMethodLiteral);
            this.myExecutablePlan.add(ableConsequentClause);
        }
    }

    public void convertPlanToStringForm() throws AbleDataException {
        String string = "convertPlanToStringForm";
        ArrayList arrayList = this.myResult.getSequentialPlanActions();
        int n = arrayList.size();
        this.myExecutablePlan.clear();
        for (int i = 0; i < n; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            ActionImpl actionImpl = (ActionImpl)arrayList.get(i);
            String string2 = actionImpl.getActionName();
            int n2 = actionImpl.getNumParam();
            stringBuffer.append(string2);
            stringBuffer.append("(");
            for (int j = 0; j < n2; ++j) {
                stringBuffer.append(actionImpl.getParam(j));
                if (j >= n2 - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(");");
            this.myExecutablePlan.add(stringBuffer.toString());
        }
    }

    public Vector convertExprToPredicateList(AbleExpression ableExpression) throws AbleDataException {
        Vector<Object> vector = new Vector<Object>();
        AbleExpression ableExpression2 = ableExpression;
        AbleRd ableRd = ableExpression2.getLhs();
        AbleRd ableRd2 = ableExpression2.getRhs();
        if (ableRd instanceof AbleGenericLiteral) {
            vector.add(((AbleGenericLiteral)ableRd).getGenericValue());
        } else if (ableRd instanceof AbleExpression) {
            vector.addAll(this.convertExprToPredicateList((AbleExpression)ableRd));
        }
        if (ableRd2 instanceof AbleGenericLiteral) {
            vector.add(((AbleGenericLiteral)ableRd2).getGenericValue());
        } else if (ableRd2 instanceof AbleExpression) {
            vector.addAll(this.convertExprToPredicateList((AbleExpression)ableRd2));
        }
        return vector;
    }

    public PredicateImpl convertAblePredicateToGroundP4JPredicate(AblePredicate ablePredicate) throws AbleDataException {
        if (ablePredicate == null) {
            return null;
        }
        PredicateImpl predicateImpl = new PredicateImpl(false);
        if (predicateImpl == null) {
            return null;
        }
        predicateImpl.setName(ablePredicate.getFunctor());
        Vector vector = ablePredicate.getArguments();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.get(i);
                if (e instanceof AbleVariable) {
                    AbleVariable ableVariable = (AbleVariable)e;
                    String string = ableVariable.getName();
                    predicateImpl.addObj((Object)string);
                    continue;
                }
                if (e instanceof String) {
                    predicateImpl.addObj(e);
                    continue;
                }
                if (!(e instanceof AbleStringLiteral)) continue;
                predicateImpl.addObj((Object)((AbleStringLiteral)e).getStringValue());
            }
        }
        predicateImpl.setFullName();
        return predicateImpl;
    }

    public void setControlParameter(String string, Object object) throws AbleDataException {
        if (string.equalsIgnoreCase("InitialState")) {
            if (object instanceof AblePredicate) {
                AbleExpression ableExpression = new AbleExpression(null, 10, (AbleRd)new AbleGenericLiteral(object));
                this.setInitialState(new AbleExpression[]{ableExpression});
            } else if (object instanceof AbleExpression) {
                AbleExpression ableExpression = (AbleExpression)object;
                this.setInitialState(new AbleExpression[]{ableExpression});
            } else if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                AbleExpression[] ableExpressionArray = new AbleExpression[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    AbleExpression ableExpression;
                    if (objectArray[i] instanceof AbleExpression) {
                        ableExpressionArray[i] = (AbleExpression)objectArray[i];
                        continue;
                    }
                    if (!(objectArray[i] instanceof AblePredicate)) continue;
                    ableExpressionArray[i] = ableExpression = new AbleExpression(null, 10, (AbleRd)new AbleGenericLiteral(objectArray[i]));
                }
                this.setInitialState(ableExpressionArray);
            } else if (object instanceof AbleExpression[]) {
                this.setInitialState((AbleExpression[])object);
            }
        } else if (string.equalsIgnoreCase("Objects")) {
            if (object instanceof AblePredicate) {
                AbleExpression ableExpression = new AbleExpression(null, 10, (AbleRd)new AbleGenericLiteral(object));
                this.setProblemObjects(new AbleExpression[]{ableExpression});
            } else if (object instanceof AbleExpression) {
                AbleExpression ableExpression = (AbleExpression)object;
                this.setProblemObjects(new AbleExpression[]{ableExpression});
            } else if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                AbleExpression[] ableExpressionArray = new AbleExpression[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    AbleExpression ableExpression;
                    if (objectArray[i] instanceof AbleExpression) {
                        ableExpressionArray[i] = (AbleExpression)objectArray[i];
                        continue;
                    }
                    if (!(objectArray[i] instanceof AblePredicate)) continue;
                    ableExpressionArray[i] = ableExpression = new AbleExpression(null, 10, (AbleRd)new AbleGenericLiteral(objectArray[i]));
                }
                this.setProblemObjects(ableExpressionArray);
            } else if (object instanceof AbleExpression[]) {
                this.setProblemObjects((AbleExpression[])object);
            }
        } else if (string.equalsIgnoreCase("GoalState")) {
            if (object instanceof AblePredicate) {
                AbleExpression ableExpression = new AbleExpression(null, 10, (AbleRd)new AbleGenericLiteral(object));
                this.setGoalState(ableExpression);
            } else if (object instanceof AbleExpression) {
                AbleExpression ableExpression = (AbleExpression)object;
                this.setGoalState(ableExpression);
            }
        } else if (string.equalsIgnoreCase("Domain")) {
            String string2 = (String)object;
            this.setDomain(string2);
        } else if (string.equalsIgnoreCase("DomainFile")) {
            String string3 = (String)object;
            this.setDomainFile(string3);
        } else if (string.equalsIgnoreCase("ProblemFile")) {
            String string4 = (String)object;
            this.setProblemFile(string4);
        } else if (string.equalsIgnoreCase("Requirements")) {
            Object[] objectArray = (Object[])object;
            this.setRequirements(objectArray);
        } else if (string.equalsIgnoreCase("Params")) {
            if (object instanceof HashMap) {
                this.myParams = (HashMap)object;
            } else {
                System.out.println("Params must be a HashMap instance!");
            }
        } else if (string.equalsIgnoreCase("DomainActionsClass")) {
            Class clazz = (Class)object;
            this.setDomainActionsClass(clazz);
        } else if (!string.equalsIgnoreCase("Objects")) {
            throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnsupportedControlParameter", (Object[])new Object[]{clsNm, string}));
        }
    }

    public Object getControlParameter(String string) throws AbleDataException {
        if (string.equalsIgnoreCase("InitialState")) {
            return this.myInitialState;
        }
        if (string.equalsIgnoreCase("Objects")) {
            return this.myProblemInitObjects;
        }
        if (string.equalsIgnoreCase("GoalState")) {
            return this.myGoalState;
        }
        if (string.equalsIgnoreCase("Domain")) {
            return this.myDomain;
        }
        if (string.equalsIgnoreCase("DomainFile")) {
            return this.myDomainFile;
        }
        if (string.equalsIgnoreCase("ProblemFile")) {
            return this.myProblemFile;
        }
        if (string.equalsIgnoreCase("Requirements")) {
            return this.myRequirements;
        }
        if (string.equalsIgnoreCase("Params")) {
            return this.myParams;
        }
        if (string.equalsIgnoreCase("DomainActionsClass")) {
            return this.myDomainActionsClass;
        }
        if (string.equalsIgnoreCase("Plan")) {
            return this.myExecutablePlan;
        }
        throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnsupportedControlParameter", (Object[])new Object[]{clsNm, string}));
    }

    public void setProblemObjects(AbleExpression[] ableExpressionArray) {
        this.myProblemInitObjects = ableExpressionArray;
    }

    public AbleExpression[] getProblemObjects() {
        return this.myProblemInitObjects;
    }

    public void setInitialState(AbleExpression[] ableExpressionArray) {
        this.myInitialState = ableExpressionArray;
    }

    public AbleExpression[] getInitialState() {
        return this.myInitialState;
    }

    public void setGoalState(AbleExpression ableExpression) {
        this.myGoalState = ableExpression;
    }

    public AbleExpression getGoalState() {
        return this.myGoalState;
    }

    public void setDomain(String string) {
        this.myDomain = string;
    }

    public String getDomain() {
        return this.myDomain;
    }

    public void setDomainFile(String string) {
        this.myDomainFile = string;
    }

    public String getDomainFile() {
        return this.myDomainFile;
    }

    public void setProblemFile(String string) {
        this.myProblemFile = string;
    }

    public String getProblemFile() {
        return this.myProblemFile;
    }

    public void setRequirements(Object[] objectArray) {
        this.myRequirements = objectArray;
    }

    public Object[] getRequirements() {
        return this.myRequirements;
    }

    public void setParams(HashMap hashMap) {
        this.myParams = hashMap;
    }

    public HashMap getParams() {
        return this.myParams;
    }

    public void setDomainActionsClass(Class clazz) {
        this.myDomainActionsClass = clazz;
    }

    public Class getDomainActionsClass() {
        return this.myDomainActionsClass;
    }

    public String getDomainActionsClassName() {
        return this.myDomainActionsClass.getName();
    }

    public ArrayList getPlan() {
        return this.myExecutablePlan;
    }
}

