/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleInferenceEngine;
import com.ibm.able.rules.AblePatternMatchNode;
import com.ibm.able.rules.AbleRuleSet;
import java.io.Serializable;
import java.util.Vector;

class AblePatternMatchTestNode
extends AblePatternMatchNode
implements Serializable {
    static final long serialVersionUID = 2347558703283953839L;
    protected AbleExpression expression;

    public AblePatternMatchTestNode(int n, AbleRuleSet ableRuleSet, AbleExpression ableExpression, AbleVariable ableVariable) {
        super(n, ableRuleSet, ableVariable);
        this.expression = ableExpression;
    }

    public void processAddToken(AblePatternMatchNode ablePatternMatchNode, Object object, Vector vector) throws AbleDataException {
        this.selectorVar.setGenericValue(object);
        Boolean bl = AbleInferenceEngine.evalAntecedentExpression(this.expression);
        if (bl != null && bl.booleanValue()) {
            this.processAddLinks(ablePatternMatchNode, object, vector);
        }
    }

    public void processRemoveToken(AblePatternMatchNode ablePatternMatchNode, Object object, Vector vector) throws AbleDataException {
        this.processRemoveLinks(this, object, vector);
    }

    public boolean equals(AblePatternMatchNode ablePatternMatchNode) {
        if (ablePatternMatchNode instanceof AblePatternMatchTestNode) {
            return this.expression.equals(((AblePatternMatchTestNode)ablePatternMatchNode).getExpression());
        }
        return false;
    }

    public int hashCode() {
        if (this.expression != null) {
            return this.expression.hashCode();
        }
        return 0;
    }

    protected boolean closeEnough(AbleExpression ableExpression) {
        return this.expression.getLhs().equals(ableExpression.getLhs()) && this.expression.getOp() == ableExpression.getOp() && this.expression.getRhs().equals(ableExpression.getRhs());
    }

    public AbleExpression getExpression() {
        return this.expression;
    }

    public String toString() {
        return Able.NlsMsg((String)"Inf_RsReteTestNodeToString", (Object[])new Object[]{Integer.toString(this.id), this.expression.traceString(2)});
    }
}

