/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.rules.AblePatternMatchNode;
import com.ibm.able.rules.AblePatternMatchRule;
import com.ibm.able.rules.AblePatternMatchTerminalNode;
import com.ibm.able.rules.AbleRuleSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

class AblePatternMatchRuleTerminalNode
extends AblePatternMatchTerminalNode
implements Serializable {
    static final long serialVersionUID = 5001318426939040590L;
    protected HashSet activationList = new HashSet();
    protected AblePatternMatchRule rule = null;
    protected Hashtable factToBindingsMap = new Hashtable();
    protected HashSet usedBindingsList = new HashSet();

    public AblePatternMatchRuleTerminalNode(int n, AbleRuleSet ableRuleSet, AblePatternMatchRule ablePatternMatchRule) {
        super(n, ableRuleSet, null);
        this.rule = ablePatternMatchRule;
    }

    public void processAddToken(AblePatternMatchNode ablePatternMatchNode, Object object, Vector vector) throws AbleDataException {
        if (!this.activationList.add(vector)) {
            return;
        }
        this.updateFactToBindingsMap(vector);
        this.rule.setBindings(this.activationList);
    }

    public void processRemoveToken(AblePatternMatchNode ablePatternMatchNode, Object object, Vector vector) throws AbleDataException {
        HashSet hashSet = (HashSet)this.factToBindingsMap.remove(object);
        if (hashSet == null) {
            return;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.activationList.remove(e);
        }
        this.rule.setBindings(this.activationList);
    }

    public Collection removeBindings(Vector vector) {
        this.activationList.remove(vector);
        this.usedBindingsList.add(vector);
        return this.activationList;
    }

    public AblePatternMatchRule getRule() {
        return this.rule;
    }

    public boolean equals(AblePatternMatchNode ablePatternMatchNode) {
        if (ablePatternMatchNode instanceof AblePatternMatchRuleTerminalNode) {
            return this.rule == ((AblePatternMatchRuleTerminalNode)ablePatternMatchNode).getRule();
        }
        return false;
    }

    public int hashCode() {
        if (this.rule != null) {
            return this.rule.hashCode();
        }
        return 0;
    }

    public void clear() {
        this.activationList.clear();
        this.factToBindingsMap.clear();
        this.usedBindingsList.clear();
    }

    public String toString() {
        return Able.NlsMsg((String)"Inf_RsReteRuleTermNodeToString", (Object[])new Object[]{Integer.toString(this.id), this.activationList.toString()});
    }

    protected void updateFactToBindingsMap(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.get(i);
            if (e == null) continue;
            HashSet hashSet = (HashSet)this.factToBindingsMap.get(e);
            if (hashSet == null) {
                HashSet<Vector> hashSet2 = new HashSet<Vector>();
                hashSet2.add(vector);
                this.factToBindingsMap.put(e, hashSet2);
                continue;
            }
            hashSet.add(vector);
        }
    }
}

