/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AblePredicate;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleAntecedentClause;
import com.ibm.able.rules.AbleClause;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleInferenceEngine;
import com.ibm.able.rules.AbleParException;
import com.ibm.able.rules.AblePatternMatchClause;
import com.ibm.able.rules.AblePatternMatchEngine;
import com.ibm.able.rules.AblePatternMatchRuleTerminalNode;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleSet;
import com.ibm.able.rules.AbleSelector;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class AblePatternMatchRule
extends AbleRule
implements Serializable {
    static final long serialVersionUID = 2001011800000000001L;
    static String clsNm = "AblePatternMatchRule";
    protected Vector mySelectors;
    protected Vector myNetworkSelectors;
    protected AblePatternMatchClause myPatternMatchClause;
    protected HashSet myBindings;
    protected Vector myConsequents;
    protected AblePatternMatchRuleTerminalNode myTerminalNode;
    protected boolean checkForPatternMatchEngine = false;
    protected AblePatternMatchEngine myPatternMatchEngine = null;
    protected static int RuleNumber = 0;
    protected int myRuleNumber = 0;

    public AblePatternMatchRule(String string, AbleRd ableRd, Vector vector, Vector vector2, AbleRuleSet ableRuleSet, AbleRuleBlock ableRuleBlock) {
        super(0, string, ableRd, ableRuleSet);
        this.mySelectors = (Vector)vector.clone();
        this.myPatternMatchClause = new AblePatternMatchClause(this.mySelectors);
        this.myConsequents = (Vector)vector2.clone();
        this.myBindings = new HashSet();
        this.ctorHelperSaveReferences();
        this.myRuleBlock = ableRuleBlock;
        this.myRuleNumber = RuleNumber++;
    }

    private void ctorHelperSaveReferences() {
        Serializable serializable;
        int n;
        this.addHeaderRdReferences();
        if (!this.mySelectors.isEmpty()) {
            for (n = 0; n < this.mySelectors.size(); ++n) {
                serializable = (AbleSelector)this.mySelectors.elementAt(n);
                AbleExpression ableExpression = ((AbleSelector)serializable).getConstraintExpression();
                this.addRdReferences(ableExpression.getReferents());
            }
        }
        for (n = 0; n < this.myConsequents.size(); ++n) {
            serializable = (AbleConsequentClause)this.myConsequents.elementAt(n);
            if (serializable == null) continue;
            ((AbleClause)serializable).addRuleRef(this);
            this.addRdReferences(((AbleClause)serializable).getReferents());
            this.addWrReference(((AbleClause)serializable).getLhsReferent());
        }
    }

    public void createNetworkSelectors(AbleRuleSet ableRuleSet) throws AbleParException {
        Hashtable<AbleVariable, AbleVariable> hashtable = new Hashtable<AbleVariable, AbleVariable>();
        this.myNetworkSelectors = new Vector();
        if (this.mySelectors != null) {
            for (int i = 0; i < this.mySelectors.size(); ++i) {
                AbleSelector ableSelector = (AbleSelector)this.mySelectors.get(i);
                AbleVariable ableVariable = null;
                AbleVariable ableVariable2 = ableSelector.getSelectorVariable();
                if (ableVariable2.isLocal()) {
                    ableVariable = ableRuleSet.addLocalVariable(ableVariable2.getName() + "_", ableVariable2.getDataTypeName());
                    hashtable.put(ableVariable2, ableVariable);
                }
                AbleExpression ableExpression = ableSelector.getConstraintExpression();
                AbleExpression ableExpression2 = ableExpression.createMatchExpression(hashtable);
                AbleSelector ableSelector2 = new AbleSelector(ableVariable, ableExpression2, ableSelector.isPositive());
                this.myNetworkSelectors.add(ableSelector2);
            }
        }
    }

    public void createNetworkSelectors2(AbleRuleSet ableRuleSet) throws AbleParException {
        Hashtable<AbleVariable, AbleVariable> hashtable = new Hashtable<AbleVariable, AbleVariable>();
        this.myNetworkSelectors = new Vector();
        if (this.mySelectors != null) {
            Vector<Object> vector = null;
            for (int i = 0; i < this.mySelectors.size(); ++i) {
                vector = new Vector<Object>();
                AbleSelector ableSelector = (AbleSelector)this.mySelectors.get(i);
                AbleVariable ableVariable = null;
                AbleVariable ableVariable2 = ableSelector.getSelectorVariable();
                if (ableVariable2.isLocal()) {
                    ableVariable = ableRuleSet.addLocalVariable(ableVariable2.getName() + "_", ableVariable2.getDataTypeName());
                    hashtable.put(ableVariable2, ableVariable);
                }
                ableSelector.convertExpressionToClauses(ableRuleSet);
                Vector vector2 = ableSelector.getConstraints();
                for (int j = 0; j < vector2.size(); ++j) {
                    Object e = vector2.get(j);
                    if (e instanceof AblePredicate) {
                        vector.add(((AblePredicate)e).createMatchPredicate(hashtable));
                        continue;
                    }
                    if (e instanceof AbleVariable) {
                        AbleVariable ableVariable3 = null;
                        if (((AbleVariable)e).isGlobal()) {
                            ableVariable3 = (AbleVariable)e;
                        } else if (hashtable.containsKey((AbleVariable)e)) {
                            ableVariable3 = (AbleVariable)hashtable.get((AbleVariable)e);
                        }
                        vector.add(ableVariable3);
                        continue;
                    }
                    if (e instanceof AbleAntecedentClause) {
                        vector.add(((AbleAntecedentClause)e).createMatchClause(hashtable));
                        continue;
                    }
                    if (!(e instanceof AbleConsequentClause)) continue;
                    vector.add(((AbleConsequentClause)e).createMatchClause(hashtable));
                }
                AbleSelector ableSelector2 = new AbleSelector(ableVariable, vector, ableSelector.isPositive());
                this.myNetworkSelectors.add(ableSelector2);
            }
        }
    }

    public Vector getNetworkSelectors() {
        return this.myNetworkSelectors;
    }

    public Vector getNetworkSelectorVariables() {
        Vector<AbleVariable> vector = new Vector<AbleVariable>();
        for (int i = 0; i < this.myNetworkSelectors.size(); ++i) {
            AbleSelector ableSelector = (AbleSelector)this.myNetworkSelectors.elementAt(i);
            vector.add(ableSelector.getSelectorVariable());
        }
        return vector;
    }

    public final Vector getSelectors() {
        return this.mySelectors;
    }

    public final Vector getDoActions() {
        return this.myConsequents;
    }

    public long numberOfSelectors() {
        long l = 0L;
        if (this.mySelectors != null) {
            l = this.mySelectors.size();
        }
        return l;
    }

    public final AblePatternMatchClause getPatternMatchClause() {
        return this.myPatternMatchClause;
    }

    public final Collection getBindings() {
        return this.myBindings;
    }

    public final Vector getRuleBindings() {
        if (!this.myBindings.isEmpty()) {
            Iterator iterator = this.myBindings.iterator();
            Vector vector = (Vector)iterator.next();
            iterator.remove();
            this.setBindings(this.myBindings);
            return vector;
        }
        return null;
    }

    public void setBindings(HashSet hashSet) {
        this.myBindings = hashSet;
        int n = this.myBindings.size();
        if (n == 0) {
            this.removeFromConflictSet();
            this.myBooleanTruth = Boolean.FALSE;
        } else {
            this.addToConflictSet();
            this.myBooleanTruth = Boolean.TRUE;
        }
    }

    public void setBindings(Collection collection) {
        if (collection instanceof HashSet) {
            this.setBindings((HashSet)collection);
        } else {
            this.setBindings(new HashSet(collection));
        }
    }

    protected boolean removeFromConflictSet() {
        if (!this.checkForPatternMatchEngine) {
            Object object;
            if (this.myRuleBlock == null) {
                object = this.myRuleSet.getRuleBlocks().elements();
                while (object.hasMoreElements()) {
                    AbleRuleBlock ableRuleBlock = (AbleRuleBlock)object.nextElement();
                    if (!ableRuleBlock.getRules().contains(this)) continue;
                    this.myRuleBlock = ableRuleBlock;
                    break;
                }
            }
            this.checkForPatternMatchEngine = true;
            object = this.myRuleBlock.getInferenceEngine();
            if (object instanceof AblePatternMatchEngine) {
                this.myPatternMatchEngine = (AblePatternMatchEngine)this.myRuleBlock.getInferenceEngine();
            }
        }
        if (this.myPatternMatchEngine != null) {
            return this.myPatternMatchEngine.removeRuleFromConflictSet(this);
        }
        return false;
    }

    protected boolean addToConflictSet() {
        if (!this.checkForPatternMatchEngine) {
            this.checkForPatternMatchEngine = true;
            AbleInferenceEngine ableInferenceEngine = this.myRuleBlock.getInferenceEngine();
            if (ableInferenceEngine instanceof AblePatternMatchEngine) {
                this.myPatternMatchEngine = (AblePatternMatchEngine)this.myRuleBlock.getInferenceEngine();
            }
        }
        if (this.myPatternMatchEngine != null) {
            return this.myPatternMatchEngine.addRuleToConflictSet(this);
        }
        return false;
    }

    public void removeBindings(Vector vector) {
        if (this.myTerminalNode != null) {
            Collection collection = this.myTerminalNode.removeBindings(vector);
            this.setBindings(collection);
        }
    }

    public void setTerminalNode(AblePatternMatchRuleTerminalNode ablePatternMatchRuleTerminalNode) {
        this.myTerminalNode = ablePatternMatchRuleTerminalNode;
    }

    public Vector getSelectorVariables() {
        Vector<AbleVariable> vector = new Vector<AbleVariable>();
        for (int i = 0; i < this.mySelectors.size(); ++i) {
            AbleSelector ableSelector = (AbleSelector)this.mySelectors.elementAt(i);
            vector.add(ableSelector.getSelectorVariable());
        }
        return vector;
    }

    public boolean isTriggered() {
        return this.myBooleanTruth;
    }

    public void reset() {
        this.myFiredFlag = false;
        this.myBooleanTruth = Boolean.FALSE;
        this.myBindings.clear();
        this.removeFromConflictSet();
    }

    public String arlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = this.mySelectors.size();
        int n2 = this.myConsequents.size();
        String string = "    " + this.myLabel;
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        if (this.myPriority == PriorityDefault) {
            stringBuffer3.append(": ");
        } else {
            stringBuffer3.append("[" + this.myPriority.arlCRdString() + "]: ");
        }
        stringBuffer2.append("      ");
        if (this.myComment.length() > 0 || !this.myProperties.isEmpty()) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        if (this.isTemplate()) {
            stringBuffer.append("template ");
        }
        stringBuffer.append(string);
        stringBuffer.append(this.arlPreConditionsString());
        stringBuffer.append(stringBuffer3.toString() + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "when( ");
        stringBuffer.append(((AbleSelector)this.mySelectors.elementAt(0)).arlString());
        for (int i = 1; i < n; ++i) {
            stringBuffer.append("  &" + Able.LS);
            stringBuffer.append(stringBuffer2.toString() + "      " + ((AbleSelector)this.mySelectors.elementAt(i)).arlString());
        }
        stringBuffer.append(Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "    )" + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "do  { ");
        stringBuffer.append(AblePatternMatchRule.arlActionBlockString(stringBuffer2.toString() + "  ", this.myConsequents));
        stringBuffer.append(stringBuffer2.toString() + "    }" + Able.LS);
        return stringBuffer.toString();
    }

    public String xmlString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.mySelectors.size();
        int n3 = this.myConsequents.size();
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        stringBuffer.append("    <rule" + string + string2 + string3 + ">" + Able.LS);
        stringBuffer.append(this.xmlPreConditionsString());
        stringBuffer.append(this.xmlPriorityString());
        stringBuffer.append("      <when>" + Able.LS);
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(((AbleSelector)this.mySelectors.elementAt(n)).xmlString());
        }
        stringBuffer.append("    <do>" + Able.LS);
        for (n = 0; n < n3; ++n) {
            stringBuffer.append("      <action>" + Able.LS);
            stringBuffer.append(((AbleConsequentClause)this.myConsequents.elementAt(n)).xmlString() + Able.LS);
            stringBuffer.append("      </action>" + Able.LS);
        }
        stringBuffer.append("    </do>" + Able.LS);
        stringBuffer.append("    </when>" + Able.LS);
        stringBuffer.append("     </rule>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.mySelectors.size();
        int n3 = this.myConsequents.size();
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        String string4 = this.myFinalFlag ? " final=\"true\"" : "";
        stringBuffer.append("    <WhenDoRule" + string + string2 + string3 + string4 + ">" + Able.LS);
        stringBuffer.append(this.armlPreConditionsString());
        stringBuffer.append(this.armlPriorityString());
        stringBuffer.append(this.armlPropertiesString());
        stringBuffer.append("    <when>" + Able.LS);
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(((AbleSelector)this.mySelectors.elementAt(n)).armlString());
        }
        stringBuffer.append("    </when>" + Able.LS);
        stringBuffer.append("    <do>" + Able.LS);
        for (n = 0; n < n3; ++n) {
            stringBuffer.append(((AbleConsequentClause)this.myConsequents.elementAt(n)).armlString());
        }
        stringBuffer.append("    </do>" + Able.LS);
        stringBuffer.append("   </WhenDoRule>" + Able.LS);
        return stringBuffer.toString();
    }

    public String getTemplateString(Vector vector) throws AbleDataException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.mySelectors.size();
        int n2 = this.myConsequents.size();
        StringBuffer stringBuffer2 = new StringBuffer("");
        stringBuffer.append(this.getTemplateHeaderString(vector));
        stringBuffer2.append("      ");
        stringBuffer.append(stringBuffer2.toString() + "when( ");
        stringBuffer.append(((AbleSelector)this.mySelectors.elementAt(0)).getTemplateString(vector));
        for (int i = 1; i < n; ++i) {
            stringBuffer.append("  &" + Able.LS);
            stringBuffer.append(stringBuffer2.toString() + "      " + ((AbleSelector)this.mySelectors.elementAt(i)).getTemplateString(vector));
        }
        stringBuffer.append(Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "    )" + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "do  '{' ");
        stringBuffer.append(AblePatternMatchRule.getTemplateActionBlockString(vector, stringBuffer2.toString() + "  ", this.myConsequents));
        stringBuffer.append(stringBuffer2.toString() + "    '}'" + Able.LS);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.arlString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlString();
            }
            case 4: {
                return this.arlString();
            }
            case 5: {
                return this.xmlString();
            }
        }
        return this.arlString();
    }

    private String trcString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("");
        int n3 = this.mySelectors.size();
        int n4 = this.myConsequents.size();
        String string = "    " + this.myLabel;
        int n5 = this.myLabel.length();
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        for (n2 = 0; n2 < n5; ++n2) {
            stringBuffer2.append(" ");
        }
        if (this.myPriority == PriorityDefault) {
            stringBuffer3.append(": ");
        } else {
            stringBuffer3.append("[" + this.myPriority.traceString(n) + "]: ");
        }
        for (n2 = 0; n2 < stringBuffer3.length(); ++n2) {
            stringBuffer2.append(" ");
        }
        stringBuffer.append(string + stringBuffer3.toString() + "when (");
        stringBuffer.append(((AbleSelector)this.mySelectors.elementAt(0)).traceString(n));
        for (n2 = 1; n2 < n3; ++n2) {
            stringBuffer.append("  &" + Able.LS);
            stringBuffer.append(stringBuffer2.toString() + "          " + ((AbleSelector)this.mySelectors.elementAt(n2)).traceString(n));
        }
        stringBuffer.append(Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "         )" + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "      do (");
        stringBuffer.append(((AbleConsequentClause)this.myConsequents.elementAt(0)).traceString(n));
        for (n2 = 1; n2 < n4; ++n2) {
            stringBuffer.append(Able.LS);
            stringBuffer.append(stringBuffer2.toString() + "          " + ((AbleConsequentClause)this.myConsequents.elementAt(n2)).traceString(n));
        }
        stringBuffer.append(Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "         )" + Able.LS);
        return stringBuffer.toString();
    }
}

