/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.AbleLogger;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleRuleSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;

abstract class AblePatternMatchNode
implements Serializable {
    static final long serialVersionUID = -5158492547390450665L;
    protected int id;
    protected Vector links = new Vector();
    protected AbleVariable selectorVar = null;
    protected Vector selectorVars;
    protected AbleLogger myTracer = null;
    protected AbleRuleSet myRuleSet = null;

    public AblePatternMatchNode(int n, AbleRuleSet ableRuleSet) {
        this.id = n;
        this.myRuleSet = ableRuleSet;
        this.myTracer = this.myRuleSet.getInferTraceLogger();
    }

    public AblePatternMatchNode(int n, AbleRuleSet ableRuleSet, AbleVariable ableVariable) {
        this.id = n;
        this.selectorVar = ableVariable;
        this.myRuleSet = ableRuleSet;
        this.myTracer = this.myRuleSet.getInferTraceLogger();
    }

    public abstract void processAddToken(AblePatternMatchNode var1, Object var2, Vector var3) throws AbleDataException;

    public abstract void processRemoveToken(AblePatternMatchNode var1, Object var2, Vector var3) throws AbleDataException;

    public void addLink(AblePatternMatchNode ablePatternMatchNode) {
        this.links.add(ablePatternMatchNode);
    }

    public AblePatternMatchNode addLinkWithNoDuplicates(AblePatternMatchNode ablePatternMatchNode) {
        AblePatternMatchNode ablePatternMatchNode2 = this.findDuplicateLink(ablePatternMatchNode);
        if (ablePatternMatchNode2 == null) {
            this.addLink(ablePatternMatchNode);
            return ablePatternMatchNode;
        }
        return ablePatternMatchNode2;
    }

    public void removeLink(AblePatternMatchNode ablePatternMatchNode) {
        this.links.remove(ablePatternMatchNode);
    }

    public Vector getLinks() {
        return this.links;
    }

    public AblePatternMatchNode findDuplicateLink(AblePatternMatchNode ablePatternMatchNode) {
        AblePatternMatchNode ablePatternMatchNode2 = null;
        for (int i = 0; i < this.links.size(); ++i) {
            AblePatternMatchNode ablePatternMatchNode3 = (AblePatternMatchNode)this.links.elementAt(i);
            if (!ablePatternMatchNode3.equals(ablePatternMatchNode)) continue;
            ablePatternMatchNode2 = ablePatternMatchNode3;
            break;
        }
        return ablePatternMatchNode2;
    }

    public void processAddLinks(AblePatternMatchNode ablePatternMatchNode, Object object, Vector vector) throws AbleDataException {
        for (int i = 0; i < this.links.size(); ++i) {
            AblePatternMatchNode ablePatternMatchNode2 = (AblePatternMatchNode)this.links.get(i);
            ablePatternMatchNode2.processAddToken(ablePatternMatchNode, object, vector);
        }
    }

    public void processRemoveLinks(AblePatternMatchNode ablePatternMatchNode, Object object, Vector vector) throws AbleDataException {
        for (int i = 0; i < this.links.size(); ++i) {
            AblePatternMatchNode ablePatternMatchNode2 = (AblePatternMatchNode)this.links.get(i);
            ablePatternMatchNode2.processRemoveToken(ablePatternMatchNode, object, vector);
        }
    }

    public Collection getPatternMatchList() {
        return null;
    }

    public Collection getFactBindings(Object object) {
        return null;
    }

    public void setSelectorValue(Object object) throws AbleDataException {
    }

    public void setSelectorVariables(Vector vector) {
        this.selectorVars = vector;
    }

    public int getId() {
        return this.id;
    }

    public Vector getSelectorVariables() {
        return this.selectorVars;
    }

    public AbleVariable getSelectorVariable() {
        return this.selectorVar;
    }

    public boolean equals(AblePatternMatchNode ablePatternMatchNode) {
        return this.selectorVar == ablePatternMatchNode.selectorVar;
    }

    public int hashCode() {
        if (this.selectorVar != null) {
            return this.selectorVar.hashCode();
        }
        return 0;
    }

    public void clear() {
    }

    protected boolean antecedentExpressionIsOK(AbleExpression ableExpression) {
        AbleRd ableRd = ableExpression.getLhs();
        AbleRd ableRd2 = ableExpression.getRhs();
        try {
            return ableRd.getGenericValue() != null && ableRd2.getGenericValue() != null;
        }
        catch (AbleException ableException) {
            return false;
        }
    }

    protected void setRuleSet(AbleRuleSet ableRuleSet) {
        this.myRuleSet = ableRuleSet;
        this.myTracer = this.myRuleSet.getInferTraceLogger();
    }

    public String toString() {
        return Able.NlsMsg((String)"Inf_RsReteNodeToString", (Object[])new Object[]{Integer.toString(this.id)});
    }
}

