/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleClearable;
import com.ibm.able.AbleException;
import com.ibm.able.AbleLogger;
import com.ibm.able.data.AbleBooleanLiteral;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AblePatternMatchAndJoinNode;
import com.ibm.able.rules.AblePatternMatchDummyJoinNode;
import com.ibm.able.rules.AblePatternMatchJoinNode;
import com.ibm.able.rules.AblePatternMatchNegJoinNode;
import com.ibm.able.rules.AblePatternMatchNode;
import com.ibm.able.rules.AblePatternMatchRootNode;
import com.ibm.able.rules.AblePatternMatchRule;
import com.ibm.able.rules.AblePatternMatchRuleTerminalNode;
import com.ibm.able.rules.AblePatternMatchTerminalNode;
import com.ibm.able.rules.AblePatternMatchTestNode;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleSet;
import com.ibm.able.rules.AbleSelector;
import com.ibm.able.rules.AbleWorkingMemory;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class AblePatternMatchNetwork
implements AbleWorkingMemory,
AbleClearable,
Serializable {
    static final long serialVersionUID = 9211522727174405683L;
    protected Hashtable rootNodeHash = new Hashtable();
    protected AbleWorkingMemory workingMemory = null;
    protected int index = 0;
    protected Hashtable selectorVarHash = new Hashtable();
    protected boolean noDuplicates = true;
    protected Hashtable terminalNodes = new Hashtable();
    protected HashSet allTerminalNodes = new HashSet();
    protected Hashtable joinNodes = new Hashtable();
    protected AbleLogger myTracer = null;
    protected AbleRuleSet myRuleSet;
    protected static final AbleExpression myTrueExpression = new AbleExpression(null, 10, (AbleRd)AbleBooleanLiteral.TRUE);

    public AblePatternMatchNetwork(AbleRuleSet ableRuleSet, AbleRuleBlock ableRuleBlock, AbleLogger ableLogger, AbleWorkingMemory ableWorkingMemory) throws AbleException {
        this.myRuleSet = ableRuleSet;
        this.workingMemory = ableWorkingMemory;
        this.myTracer = ableLogger;
        this.compileNetwork(ableRuleBlock);
    }

    protected void compileNetwork(AbleRuleBlock ableRuleBlock) throws AbleException {
        this.index = 0;
        this.selectorVarHash.clear();
        Enumeration enumeration = ableRuleBlock.getPatternMatchRules().elements();
        while (enumeration.hasMoreElements()) {
            AblePatternMatchRule ablePatternMatchRule = (AblePatternMatchRule)enumeration.nextElement();
            this.generateRuleNodes(ablePatternMatchRule);
        }
        this.myRuleSet.clearLocalVarList();
    }

    protected void generateRuleNodes(AblePatternMatchRule ablePatternMatchRule) throws AbleException {
        AblePatternMatchNode ablePatternMatchNode = null;
        Vector vector = ablePatternMatchRule.getSelectors();
        Vector vector2 = ablePatternMatchRule.getSelectorVariables();
        AbleSelector ableSelector = null;
        if (this.myRuleSet.isInferenceTraceHigh()) {
            this.myTracer.text(0x40000000000L, (Object)this, "generateRuleNodes()", Able.LS + ablePatternMatchRule.getLabel() + "= ");
        }
        for (int i = 0; i < vector.size(); ++i) {
            AblePatternMatchRootNode ablePatternMatchRootNode;
            AbleSelector ableSelector2 = (AbleSelector)vector.elementAt(i);
            AbleVariable ableVariable = ableSelector2.getSelectorVariable();
            Class clazz = ableVariable.getDataTypeClass();
            if (this.rootNodeHash.containsKey(clazz)) {
                ablePatternMatchRootNode = (AblePatternMatchRootNode)this.rootNodeHash.get(clazz);
                ablePatternMatchNode = (AblePatternMatchTerminalNode)this.terminalNodes.get(clazz);
            } else {
                AbleVariable ableVariable2 = null;
                ableVariable2 = this.myRuleSet.addLocalVariable(ableVariable.getName() + "_", ableVariable.getDataTypeName());
                ablePatternMatchRootNode = new AblePatternMatchRootNode(this.index++, this.myRuleSet, ableVariable2);
                if (this.myRuleSet.isInferenceTraceHigh()) {
                    this.myTracer.message(0x40000000000L, (Object)this, "generateNodes()", "Tr_RsReteNetWorkRootNode", new Object[]{Integer.toString(ablePatternMatchRootNode.getId()), ableVariable.getDataTypeClassName()});
                }
                this.rootNodeHash.put(clazz, ablePatternMatchRootNode);
                ablePatternMatchNode = ablePatternMatchRootNode;
                this.terminalNodes.put(clazz, ablePatternMatchNode);
                this.allTerminalNodes.add(ablePatternMatchRootNode);
            }
            ablePatternMatchNode = ableSelector2.isPositive() ? this.generatePositiveSelectorNodes(ablePatternMatchRootNode, ablePatternMatchNode, ableSelector, ableSelector2, vector2) : this.generateNegativeSelectorNodes(ablePatternMatchRootNode, ablePatternMatchNode, ableSelector, ableSelector2, vector2);
            ableSelector = ableSelector2;
        }
        ablePatternMatchNode = this.generateRuleTerminalNode(ablePatternMatchNode, ablePatternMatchRule);
        this.terminalNodes.put(ablePatternMatchRule, ablePatternMatchNode);
    }

    protected AblePatternMatchNode generatePositiveSelectorNodes(AblePatternMatchRootNode ablePatternMatchRootNode, AblePatternMatchNode ablePatternMatchNode, AbleSelector ableSelector, AbleSelector ableSelector2, Vector vector) throws AbleDataException {
        AbleExpression ableExpression;
        int n;
        AbleExpression ableExpression2;
        AblePatternMatchRootNode ablePatternMatchRootNode2 = ablePatternMatchRootNode;
        AblePatternMatchNode ablePatternMatchNode2 = ablePatternMatchNode;
        AblePatternMatchNode ablePatternMatchNode3 = null;
        AblePatternMatchNode ablePatternMatchNode4 = null;
        AbleVariable ableVariable = ableSelector2.getSelectorVariable();
        AbleVariable ableVariable2 = ablePatternMatchRootNode2.getSelectorVariable();
        AbleExpression ableExpression3 = ableSelector2.getConstraintExpression();
        Vector vector2 = ableExpression3.convertToConjunctiveNormalForm();
        Hashtable<AbleVariable, AbleVariable> hashtable = new Hashtable<AbleVariable, AbleVariable>();
        hashtable.put(ableVariable, ableVariable2);
        for (int i = 0; i < vector2.size(); ++i) {
            ableExpression2 = (AbleExpression)vector2.get(i);
            n = this.getNumInputs(ableExpression2, vector);
            if (n == 0) {
                ableExpression = ableExpression2.createMatchExpression(hashtable);
                ablePatternMatchNode2 = this.generateTestNode(ablePatternMatchNode2, ableExpression, ableVariable2);
                continue;
            }
            if (n != 1) continue;
            ableExpression = ableExpression2.createMatchExpression(hashtable);
            ablePatternMatchNode2 = this.generateTestNode(ablePatternMatchNode2, ableExpression, ableVariable2);
        }
        if (ablePatternMatchNode2 instanceof AblePatternMatchTestNode) {
            ablePatternMatchNode2 = this.generateTerminalNode(ablePatternMatchNode2, ableVariable2);
        }
        Vector vector3 = new Vector();
        hashtable.clear();
        this.setReplacementVars(vector, hashtable, vector3);
        ableExpression2 = (AbleVariable)hashtable.get(ableVariable);
        n = 1;
        ableExpression = null;
        for (int i = 0; i < vector2.size(); ++i) {
            AbleExpression ableExpression4 = (AbleExpression)vector2.get(i);
            int n2 = this.getNumInputs(ableExpression4, vector);
            if (n2 != 2) continue;
            AbleExpression ableExpression5 = ableExpression4.createMatchExpression(hashtable);
            ableExpression = ableExpression == null ? ableExpression5 : new AbleExpression((AbleRd)ableExpression, 16, (AbleRd)ableExpression5);
        }
        if (ableExpression != null) {
            ablePatternMatchNode3 = (AblePatternMatchNode)this.terminalNodes.get(ableSelector);
            ablePatternMatchNode4 = this.generateJoinNode(ablePatternMatchNode3, ablePatternMatchNode2, ableExpression, (AbleVariable)ableExpression2, vector3);
            ablePatternMatchNode3 = ablePatternMatchNode2;
            n = 0;
        }
        if (ableSelector != null && n != 0) {
            ablePatternMatchNode3 = (AblePatternMatchNode)this.terminalNodes.get(ableSelector);
            ablePatternMatchNode4 = this.generateAndJoinNode(ablePatternMatchNode3, ablePatternMatchNode2, myTrueExpression, (AbleVariable)ableExpression2, vector3);
            ablePatternMatchNode3 = ablePatternMatchNode2;
        }
        if (ablePatternMatchNode4 != null) {
            ablePatternMatchNode2 = ablePatternMatchNode4;
        }
        this.terminalNodes.put(ableSelector2, ablePatternMatchNode2);
        return ablePatternMatchNode2;
    }

    protected int getNumInputs(AbleExpression ableExpression, Vector vector) {
        int n = 0;
        HashSet hashSet = ableExpression.getVariableReferences();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            if (!vector.contains(iterator.next())) continue;
            ++n;
        }
        if (n > 2) {
            n = 2;
        }
        return n;
    }

    protected void setReplacementVars(Vector vector, Hashtable hashtable, Vector vector2) {
        Enumeration enumeration = this.rootNodeHash.elements();
        while (enumeration.hasMoreElements()) {
            AblePatternMatchRootNode ablePatternMatchRootNode = (AblePatternMatchRootNode)enumeration.nextElement();
            ablePatternMatchRootNode.resetReplacementVars();
        }
        for (int i = 0; i < vector.size(); ++i) {
            AbleVariable ableVariable = (AbleVariable)vector.get(i);
            AbleVariable ableVariable2 = null;
            Class clazz = ableVariable.getDataTypeClass();
            if (!this.rootNodeHash.containsKey(clazz)) continue;
            AblePatternMatchRootNode ablePatternMatchRootNode = (AblePatternMatchRootNode)this.rootNodeHash.get(clazz);
            ableVariable2 = ablePatternMatchRootNode.getNextReplacementVar();
            vector2.add(ableVariable2);
            hashtable.put(ableVariable, ableVariable2);
        }
    }

    protected AblePatternMatchNode generateNegativeSelectorNodes(AblePatternMatchRootNode ablePatternMatchRootNode, AblePatternMatchNode ablePatternMatchNode, AbleSelector ableSelector, AbleSelector ableSelector2, Vector vector) throws AbleDataException {
        AblePatternMatchNode ablePatternMatchNode2 = ablePatternMatchNode;
        AblePatternMatchNode ablePatternMatchNode3 = null;
        AblePatternMatchNode ablePatternMatchNode4 = null;
        AbleVariable ableVariable = ableSelector2.getSelectorVariable();
        AbleExpression ableExpression = ableSelector2.getConstraintExpression();
        Hashtable hashtable = new Hashtable();
        Vector vector2 = new Vector();
        hashtable.clear();
        this.setReplacementVars(vector, hashtable, vector2);
        AbleVariable ableVariable2 = (AbleVariable)hashtable.get(ableVariable);
        AbleExpression ableExpression2 = ableExpression.createMatchExpression(hashtable);
        ablePatternMatchNode3 = (AblePatternMatchNode)this.terminalNodes.get(ableSelector);
        ablePatternMatchNode4 = this.generateNegJoinNode(ablePatternMatchNode3, ablePatternMatchNode2, ableExpression2, ableVariable2, vector2);
        ablePatternMatchNode3 = ablePatternMatchNode2;
        if (ablePatternMatchNode4 != null) {
            ablePatternMatchNode2 = ablePatternMatchNode4;
        }
        this.terminalNodes.put(ableSelector2, ablePatternMatchNode2);
        return ablePatternMatchNode2;
    }

    protected AblePatternMatchNode generateTestNodes(AblePatternMatchNode ablePatternMatchNode, AbleExpression ableExpression, AbleVariable ableVariable) {
        AblePatternMatchNode ablePatternMatchNode2 = ablePatternMatchNode;
        Vector vector = ableExpression.convertToConjunctiveNormalForm();
        for (int i = 0; i < vector.size(); ++i) {
            ablePatternMatchNode2 = this.generateTestNode(ablePatternMatchNode2, (AbleExpression)vector.get(i), ableVariable);
        }
        return ablePatternMatchNode2;
    }

    protected AblePatternMatchNode generateTestNode(AblePatternMatchNode ablePatternMatchNode, AbleExpression ableExpression, AbleVariable ableVariable) {
        AblePatternMatchNode ablePatternMatchNode2 = null;
        AblePatternMatchNode ablePatternMatchNode3 = new AblePatternMatchTestNode(this.index, this.myRuleSet, ableExpression, ableVariable);
        if (this.noDuplicates) {
            ablePatternMatchNode2 = ablePatternMatchNode.addLinkWithNoDuplicates(ablePatternMatchNode3);
            if (ablePatternMatchNode2 == ablePatternMatchNode3) {
                if (this.myRuleSet.isInferenceTraceHigh()) {
                    this.myTracer.text(0x40000000000L, (Object)this, "generateTestNode()", "+1 " + Able.NlsMsg((String)"Tr_RsReteNetWorkTestNode", (Object[])new Object[]{Integer.toString(ablePatternMatchNode3.getId()), Integer.toString(ablePatternMatchNode.getId())}));
                }
                ++this.index;
            } else {
                ablePatternMatchNode3 = ablePatternMatchNode2;
                if (this.myRuleSet.isInferenceTraceHigh()) {
                    this.myTracer.text(0x40000000000L, (Object)this, "generateTestNode()", "=1");
                }
            }
        } else {
            ablePatternMatchNode.addLink(ablePatternMatchNode3);
            if (this.myRuleSet.isInferenceTraceHigh()) {
                this.myTracer.text(0x40000000000L, (Object)this, "generateTestNode()", "+1 " + Able.NlsMsg((String)"Tr_RsReteNetWorkTestNode", (Object[])new Object[]{Integer.toString(ablePatternMatchNode3.getId()), Integer.toString(ablePatternMatchNode.getId())}));
            }
            ++this.index;
        }
        return ablePatternMatchNode3;
    }

    protected AblePatternMatchNode generateDummyJoinNode(AblePatternMatchNode ablePatternMatchNode, AbleExpression ableExpression, AbleVariable ableVariable, Vector vector) {
        AblePatternMatchDummyJoinNode ablePatternMatchDummyJoinNode = new AblePatternMatchDummyJoinNode(this.index, this.myRuleSet, ablePatternMatchNode, ableExpression, ableVariable);
        ablePatternMatchDummyJoinNode.setSelectorVariables(vector);
        if (this.myRuleSet.isInferenceTraceHigh()) {
            this.myTracer.text(0x40000000000L, (Object)this, "generateJoinNode()", "+2 " + Able.NlsMsg((String)"Tr_RsReteNetWorkJoinNode", (Object[])new Object[]{Integer.toString(ablePatternMatchDummyJoinNode.getId()), Integer.toString(-1), Integer.toString(ablePatternMatchNode.getId())}));
        }
        ablePatternMatchNode.addLink(ablePatternMatchDummyJoinNode);
        ++this.index;
        return ablePatternMatchDummyJoinNode;
    }

    protected AblePatternMatchNode generateAndJoinNode(AblePatternMatchNode ablePatternMatchNode, AblePatternMatchNode ablePatternMatchNode2, AbleExpression ableExpression, AbleVariable ableVariable, Vector vector) {
        AblePatternMatchNode ablePatternMatchNode3 = null;
        AblePatternMatchNode ablePatternMatchNode4 = new AblePatternMatchAndJoinNode(this.index, this.myRuleSet, ablePatternMatchNode, ablePatternMatchNode2, ableExpression, ableVariable);
        ablePatternMatchNode4.setSelectorVariables(vector);
        if (this.noDuplicates) {
            ablePatternMatchNode3 = ablePatternMatchNode.addLinkWithNoDuplicates(ablePatternMatchNode4);
            ablePatternMatchNode3 = ablePatternMatchNode2.addLinkWithNoDuplicates(ablePatternMatchNode4);
            if (ablePatternMatchNode3 == ablePatternMatchNode4) {
                if (this.myRuleSet.isInferenceTraceHigh()) {
                    this.myTracer.text(0x40000000000L, (Object)this, "generateAndJoinNode()", "+2 " + Able.NlsMsg((String)"Tr_RsReteNetWorkJoinNode", (Object[])new Object[]{Integer.toString(ablePatternMatchNode4.getId()), Integer.toString(ablePatternMatchNode.getId()), Integer.toString(ablePatternMatchNode2.getId())}));
                }
                ++this.index;
            } else {
                ablePatternMatchNode4 = ablePatternMatchNode3;
                if (this.myRuleSet.isInferenceTraceHigh()) {
                    this.myTracer.text(0x40000000000L, (Object)this, "generateAndJoinNode()", "=2");
                }
            }
        } else {
            if (this.myRuleSet.isInferenceTraceHigh()) {
                this.myTracer.text(0x40000000000L, (Object)this, "generateAndJoinNode()", "+2 " + Able.NlsMsg((String)"Tr_RsReteNetWorkJoinNode", (Object[])new Object[]{Integer.toString(ablePatternMatchNode4.getId()), Integer.toString(ablePatternMatchNode.getId()), Integer.toString(ablePatternMatchNode2.getId())}));
            }
            ablePatternMatchNode.addLink(ablePatternMatchNode4);
            ablePatternMatchNode2.addLink(ablePatternMatchNode4);
            ++this.index;
        }
        this.joinNodes.put(ablePatternMatchNode4, ablePatternMatchNode4);
        return ablePatternMatchNode4;
    }

    protected AblePatternMatchNode generateJoinNode(AblePatternMatchNode ablePatternMatchNode, AblePatternMatchNode ablePatternMatchNode2, AbleExpression ableExpression, AbleVariable ableVariable, Vector vector) {
        AblePatternMatchNode ablePatternMatchNode3 = null;
        AblePatternMatchNode ablePatternMatchNode4 = new AblePatternMatchJoinNode(this.index, this.myRuleSet, ablePatternMatchNode, ablePatternMatchNode2, ableExpression, ableVariable);
        ablePatternMatchNode4.setSelectorVariables(vector);
        if (this.noDuplicates) {
            ablePatternMatchNode3 = ablePatternMatchNode.addLinkWithNoDuplicates(ablePatternMatchNode4);
            ablePatternMatchNode3 = ablePatternMatchNode2.addLinkWithNoDuplicates(ablePatternMatchNode4);
            if (ablePatternMatchNode3 == ablePatternMatchNode4) {
                if (this.myRuleSet.isInferenceTraceHigh()) {
                    this.myTracer.text(0x40000000000L, (Object)this, "generateJoinNode()", "+2 " + Able.NlsMsg((String)"Tr_RsReteNetWorkJoinNode", (Object[])new Object[]{Integer.toString(ablePatternMatchNode4.getId()), Integer.toString(ablePatternMatchNode.getId()), Integer.toString(ablePatternMatchNode2.getId())}));
                }
                ++this.index;
            } else {
                ablePatternMatchNode4 = ablePatternMatchNode3;
                if (this.myRuleSet.isInferenceTraceHigh()) {
                    this.myTracer.text(0x40000000000L, (Object)this, "generateJoinNode()", "=2");
                }
            }
        } else {
            if (this.myRuleSet.isInferenceTraceHigh()) {
                this.myTracer.text(0x40000000000L, (Object)this, "generateJoinNode()", "+2 " + Able.NlsMsg((String)"Tr_RsReteNetWorkJoinNode", (Object[])new Object[]{Integer.toString(ablePatternMatchNode4.getId()), Integer.toString(ablePatternMatchNode.getId()), Integer.toString(ablePatternMatchNode2.getId())}));
            }
            ablePatternMatchNode.addLink(ablePatternMatchNode4);
            ablePatternMatchNode2.addLink(ablePatternMatchNode4);
            ++this.index;
        }
        this.joinNodes.put(ablePatternMatchNode4, ablePatternMatchNode4);
        return ablePatternMatchNode4;
    }

    protected AblePatternMatchNode generateNegJoinNode(AblePatternMatchNode ablePatternMatchNode, AblePatternMatchNode ablePatternMatchNode2, AbleExpression ableExpression, AbleVariable ableVariable, Vector vector) {
        AblePatternMatchNode ablePatternMatchNode3 = null;
        AblePatternMatchNode ablePatternMatchNode4 = new AblePatternMatchNegJoinNode(this.index, this.myRuleSet, ablePatternMatchNode, ablePatternMatchNode2, ableExpression, ableVariable);
        ablePatternMatchNode4.setSelectorVariables(vector);
        if (this.noDuplicates) {
            ablePatternMatchNode3 = ablePatternMatchNode.addLinkWithNoDuplicates(ablePatternMatchNode4);
            ablePatternMatchNode3 = ablePatternMatchNode2.addLinkWithNoDuplicates(ablePatternMatchNode4);
            if (ablePatternMatchNode3 == ablePatternMatchNode4) {
                if (this.myRuleSet.isInferenceTraceHigh()) {
                    this.myTracer.text(0x40000000000L, (Object)this, "generateNegJoinNode()", "+2 " + Able.NlsMsg((String)"Tr_RsReteNetWorkNegJoinNode", (Object[])new Object[]{Integer.toString(ablePatternMatchNode4.getId()), Integer.toString(ablePatternMatchNode.getId()), Integer.toString(ablePatternMatchNode2.getId())}));
                }
                ++this.index;
            } else {
                ablePatternMatchNode4 = ablePatternMatchNode3;
                if (this.myRuleSet.isInferenceTraceHigh()) {
                    this.myTracer.text(0x40000000000L, (Object)this, "generateNegJoinNode()", "=2");
                }
            }
        } else {
            if (this.myRuleSet.isInferenceTraceHigh()) {
                this.myTracer.text(0x40000000000L, (Object)this, "generateNegJoinNode()", "+2 " + Able.NlsMsg((String)"Tr_RsReteNetWorkNegJoinNode", (Object[])new Object[]{Integer.toString(ablePatternMatchNode4.getId()), Integer.toString(ablePatternMatchNode.getId()), Integer.toString(ablePatternMatchNode2.getId())}));
            }
            ablePatternMatchNode.addLink(ablePatternMatchNode4);
            ablePatternMatchNode2.addLink(ablePatternMatchNode4);
            ++this.index;
        }
        this.joinNodes.put(ablePatternMatchNode4, ablePatternMatchNode4);
        return ablePatternMatchNode4;
    }

    protected AblePatternMatchNode generateTerminalNode(AblePatternMatchNode ablePatternMatchNode, AbleVariable ableVariable) {
        AblePatternMatchNode ablePatternMatchNode2 = null;
        AblePatternMatchTerminalNode ablePatternMatchTerminalNode = new AblePatternMatchTerminalNode(this.index, this.myRuleSet, ableVariable);
        if (this.noDuplicates) {
            ablePatternMatchNode2 = ablePatternMatchNode.addLinkWithNoDuplicates(ablePatternMatchTerminalNode);
            if (ablePatternMatchNode2 == ablePatternMatchTerminalNode) {
                if (this.myRuleSet.isInferenceTraceHigh()) {
                    this.myTracer.text(0x40000000000L, (Object)this, "generateTerminalNode()", "+t " + Able.NlsMsg((String)"Tr_RsReteNetWorkTermNode", (Object[])new Object[]{Integer.toString(ablePatternMatchTerminalNode.getId()), Integer.toString(ablePatternMatchNode.getId())}));
                }
                ++this.index;
            } else {
                ablePatternMatchTerminalNode = (AblePatternMatchTerminalNode)ablePatternMatchNode2;
                if (this.myRuleSet.isInferenceTraceHigh()) {
                    this.myTracer.text(0x40000000000L, (Object)this, "generateTerminalNode()", "=t");
                }
            }
        } else {
            ablePatternMatchNode.addLink(ablePatternMatchTerminalNode);
            if (this.myRuleSet.isInferenceTraceHigh()) {
                this.myTracer.text(0x40000000000L, (Object)this, "generateTerminalNode()", "+t " + Able.NlsMsg((String)"Tr_RsReteNetWorkTermNode", (Object[])new Object[]{Integer.toString(ablePatternMatchTerminalNode.getId()), Integer.toString(ablePatternMatchNode.getId())}));
            }
            ++this.index;
        }
        this.allTerminalNodes.add(ablePatternMatchTerminalNode);
        return ablePatternMatchTerminalNode;
    }

    protected AblePatternMatchNode generateRuleTerminalNode(AblePatternMatchNode ablePatternMatchNode, AblePatternMatchRule ablePatternMatchRule) {
        AblePatternMatchRuleTerminalNode ablePatternMatchRuleTerminalNode = new AblePatternMatchRuleTerminalNode(this.index++, this.myRuleSet, ablePatternMatchRule);
        ablePatternMatchRule.setTerminalNode(ablePatternMatchRuleTerminalNode);
        if (this.myRuleSet.isInferenceTraceHigh()) {
            this.myTracer.text(0x40000000000L, (Object)this, "generateTerminalNode()", "+r " + Able.NlsMsg((String)"Tr_RsReteNetWorkTermNode", (Object[])new Object[]{Integer.toString(ablePatternMatchRuleTerminalNode.getId()), Integer.toString(ablePatternMatchNode.getId())}));
        }
        ablePatternMatchNode.addLink(ablePatternMatchRuleTerminalNode);
        this.allTerminalNodes.add(ablePatternMatchRuleTerminalNode);
        return ablePatternMatchRuleTerminalNode;
    }

    public boolean assertFact(Object object) {
        if (!this.workingMemory.assertFact(object)) {
            return false;
        }
        try {
            this.processAddToken(object);
        }
        catch (AbleDataException ableDataException) {
            Able.MessageLog.text(4L, (Object)this, "assert()", ableDataException.getLocalizedMessage());
        }
        return true;
    }

    public boolean asserta(Object object) {
        return this.assertFact(object);
    }

    public boolean assertz(Object object) {
        return this.assertFact(object);
    }

    public void assertAll(List list) {
        for (int i = 0; i < list.size(); ++i) {
            this.assertFact(list.get(i));
        }
    }

    public void retractFact(Object object) {
        this.retract(object);
    }

    public void retract(Object object) {
        this.workingMemory.retract(object);
        try {
            this.processRemoveToken(object);
        }
        catch (AbleDataException ableDataException) {
            Able.MessageLog.text(4L, (Object)this, "retract()", ableDataException.getLocalizedMessage());
        }
    }

    public void retractAll(List list) {
        for (int i = 0; i < list.size(); ++i) {
            this.retract(list.get(i));
        }
    }

    public void modifyFact(Object object) {
        this.modify(object);
    }

    public void modify(Object object) {
        this.workingMemory.modify(object);
        try {
            this.processRemoveToken(object);
            this.processAddToken(object);
        }
        catch (AbleDataException ableDataException) {
            Able.MessageLog.message(4L, (Object)this, "modify()", ableDataException.getLocalizedMessage());
        }
    }

    public boolean exists(Object object) {
        return this.workingMemory.exists(object);
    }

    public Object find(AbleSelector ableSelector) throws AbleDataException {
        return this.workingMemory.find(ableSelector);
    }

    public AbstractCollection findAll(AbleSelector ableSelector) throws AbleDataException {
        return this.workingMemory.findAll(ableSelector);
    }

    public AbstractCollection findAllInstances(String string) {
        return this.workingMemory.findAllInstances(string);
    }

    public Enumeration getClasses() {
        return this.workingMemory.getClasses();
    }

    public void clear() {
        Object object;
        this.workingMemory.clear();
        Iterator iterator = this.allTerminalNodes.iterator();
        while (iterator.hasNext()) {
            object = (AblePatternMatchTerminalNode)iterator.next();
            ((AblePatternMatchTerminalNode)object).clear();
        }
        object = this.joinNodes.elements();
        while (object.hasMoreElements()) {
            Object e = object.nextElement();
            if (e instanceof AbleClearable) {
                ((AbleClearable)e).clear();
                continue;
            }
            this.myTracer.text(4L, (Object)this, "clear", "joinNodes hashtable contains unexpected object of type" + e.getClass().getName());
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.text(0x20000000000L, (Object)this, "clear()", "Cleared all memories in nodes");
        }
    }

    public boolean isEmpty() {
        return this.workingMemory.isEmpty();
    }

    private void processAddToken(Object object) throws AbleDataException {
        Class<?> clazz = object.getClass();
        AblePatternMatchRootNode ablePatternMatchRootNode = (AblePatternMatchRootNode)this.rootNodeHash.get(clazz);
        if (ablePatternMatchRootNode == null) {
            Able.MessageLog.message(4L, (Object)this, "processToken()", "Ex_RsReteProcessToken", new Object[]{object, clazz});
        } else {
            Vector<Object> vector = new Vector<Object>();
            vector.add(object);
            ablePatternMatchRootNode.processAddToken(ablePatternMatchRootNode, object, vector);
        }
    }

    private void processRemoveToken(Object object) throws AbleDataException {
        Class<?> clazz = object.getClass();
        AblePatternMatchRootNode ablePatternMatchRootNode = (AblePatternMatchRootNode)this.rootNodeHash.get(clazz);
        if (ablePatternMatchRootNode == null) {
            Able.MessageLog.message(4L, (Object)this, "processToken()", "Ex_RsReteProcessToken", new Object[]{object, clazz});
        } else {
            Vector<Object> vector = new Vector<Object>();
            vector.add(object);
            ablePatternMatchRootNode.processRemoveToken(ablePatternMatchRootNode, object, vector);
        }
    }

    public void dumpNetwork() {
        this.myTracer.message(0x40000000000L, (Object)this, "dumpNetwork()", "Tr_RsReteNetWorkDumpTitle");
        Enumeration enumeration = this.rootNodeHash.elements();
        while (enumeration.hasMoreElements()) {
            AblePatternMatchNode ablePatternMatchNode = (AblePatternMatchNode)enumeration.nextElement();
            this.dumpNode(ablePatternMatchNode);
        }
    }

    protected void dumpNode(AblePatternMatchNode ablePatternMatchNode) {
        this.myTracer.text(0x40000000000L, (Object)this, "dumpNode()", ablePatternMatchNode.toString());
        Vector vector = ablePatternMatchNode.getLinks();
        for (int i = 0; i < vector.size(); ++i) {
            AblePatternMatchNode ablePatternMatchNode2 = (AblePatternMatchNode)vector.elementAt(i);
            this.dumpNode(ablePatternMatchNode2);
        }
    }

    public String toString() {
        return this.workingMemory.toString();
    }

    public Object[] toArray() throws AbleDataException {
        return this.workingMemory.toArray();
    }
}

