/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleClearable;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleInferenceEngine;
import com.ibm.able.rules.AblePatternMatchNode;
import com.ibm.able.rules.AblePatternMatchTerminalNode;
import com.ibm.able.rules.AblePatternMatchTestNode;
import com.ibm.able.rules.AbleRuleSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

class AblePatternMatchNegJoinNode
extends AblePatternMatchTestNode
implements Serializable,
AbleClearable {
    static final long serialVersionUID = -5386619420740988181L;
    protected AblePatternMatchNode leftPartialMatchNode = null;
    protected AblePatternMatchNode rightPartialMatchNode = null;
    protected HashSet partialMatchList = new HashSet();
    protected Hashtable factToBindingsMap = new Hashtable();

    public AblePatternMatchNegJoinNode(int n, AbleRuleSet ableRuleSet, AblePatternMatchNode ablePatternMatchNode, AblePatternMatchNode ablePatternMatchNode2, AbleExpression ableExpression, AbleVariable ableVariable) {
        super(n, ableRuleSet, ableExpression, ableVariable);
        this.leftPartialMatchNode = ablePatternMatchNode;
        this.rightPartialMatchNode = ablePatternMatchNode2;
    }

    public void processAddToken(AblePatternMatchNode ablePatternMatchNode, Object object, Vector vector) throws AbleDataException {
        if (ablePatternMatchNode == this.leftPartialMatchNode) {
            if (this.leftPartialMatchNode instanceof AblePatternMatchTerminalNode) {
                this.processLeftTermToken(object, vector);
                if (this.leftPartialMatchNode == this.rightPartialMatchNode) {
                    this.processRightTermToken(object, vector);
                }
            } else {
                this.processLeftJoinToken(object, vector);
            }
        } else {
            this.processRightTermToken(object, vector);
        }
    }

    public void processRemoveToken(AblePatternMatchNode ablePatternMatchNode, Object object, Vector vector) throws AbleDataException {
        HashSet hashSet;
        if (this.partialMatchList.size() > 0 && (hashSet = (HashSet)this.factToBindingsMap.remove(object)) != null) {
            this.partialMatchList.removeAll(hashSet);
        }
        this.processRemoveLinks(this, object, vector);
    }

    public void processLeftTermToken(Object object, Vector vector) throws AbleDataException {
        Object object2;
        Collection collection;
        AbleVariable ableVariable;
        if (this.partialMatchList.size() > 0) {
            ableVariable = this.partialMatchList.iterator();
            while (ableVariable.hasNext()) {
                collection = (Vector)ableVariable.next();
                this.processRemoveLinks(this, ((Vector)collection).get(0), (Vector)collection);
            }
        }
        this.partialMatchList.clear();
        this.factToBindingsMap.clear();
        ableVariable = (AbleVariable)this.selectorVars.get(0);
        ableVariable.setGenericValue(object);
        collection = this.rightPartialMatchNode.getPatternMatchList();
        boolean bl = false;
        if (!collection.isEmpty()) {
            object2 = collection.iterator();
            while (object2.hasNext()) {
                Vector vector2 = (Vector)object2.next();
                Object e = vector2.get(0);
                if (object == e) continue;
                this.selectorVar.setGenericValue(e);
                Boolean bl2 = AbleInferenceEngine.evalAntecedentExpression(this.expression);
                if (bl2 == null || !bl2.booleanValue()) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            object2 = (Vector)vector.clone();
            if (this.leftPartialMatchNode.getSelectorVariable() != this.selectorVar) {
                ((Vector)object2).add(null);
            }
            this.partialMatchList.add(object2);
            this.updateFactToBindingsMap((Vector)object2);
            this.processAddLinks(this, object, (Vector)object2);
        }
    }

    public void processRightTermToken(Object object, Vector vector) throws AbleDataException {
        Object object2;
        Object object3;
        if (this.partialMatchList.size() > 0) {
            object3 = this.partialMatchList.iterator();
            while (object3.hasNext()) {
                object2 = (Vector)object3.next();
                this.processRemoveLinks(this, ((Vector)object2).get(0), (Vector)object2);
            }
        }
        this.partialMatchList.clear();
        this.factToBindingsMap.clear();
        object3 = this.leftPartialMatchNode.getPatternMatchList();
        if (object3 != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                Vector vector2 = (Vector)object2.next();
                this.processLeftJoinToken(object, vector2);
            }
        }
    }

    public void processLeftJoinToken(Object object, Vector vector) throws AbleDataException {
        Object object2;
        for (int i = 0; i < vector.size(); ++i) {
            AbleVariable ableVariable = (AbleVariable)this.selectorVars.elementAt(i);
            ableVariable.setGenericValue(vector.get(i));
        }
        Collection collection = this.rightPartialMatchNode.getPatternMatchList();
        boolean bl = false;
        if (!collection.isEmpty()) {
            object2 = collection.iterator();
            while (object2.hasNext()) {
                Vector vector2 = (Vector)object2.next();
                Object e = vector2.get(0);
                if (vector.contains(e)) continue;
                this.selectorVar.setGenericValue(e);
                Boolean bl2 = AbleInferenceEngine.evalAntecedentExpression(this.expression);
                if (bl2 == null || !bl2.booleanValue()) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            object2 = (Vector)vector.clone();
            this.selectorVar.reset();
            ((Vector)object2).add(this.selectorVar.getGenericValue());
            this.partialMatchList.add(object2);
            this.updateFactToBindingsMap((Vector)object2);
            this.processAddLinks(this, object, (Vector)object2);
        }
    }

    protected void updateFactToBindingsMap(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.get(i);
            if (e == null) continue;
            HashSet hashSet = (HashSet)this.factToBindingsMap.get(e);
            if (hashSet == null) {
                HashSet<Vector> hashSet2 = new HashSet<Vector>();
                hashSet2.add(vector);
                this.factToBindingsMap.put(e, hashSet2);
                continue;
            }
            hashSet.add(vector);
        }
    }

    public AblePatternMatchNode getLeftPartialMatchNode() {
        return this.leftPartialMatchNode;
    }

    public AblePatternMatchNode getRightPartialMatchNode() {
        return this.rightPartialMatchNode;
    }

    public Collection getPatternMatchList() {
        return this.partialMatchList;
    }

    public Collection getFactBindings(Object object) {
        return (Collection)this.factToBindingsMap.get(object);
    }

    public void setSelectorValue(Object object) throws AbleDataException {
        this.selectorVar.setGenericValue(object);
    }

    public boolean equals(AblePatternMatchNode ablePatternMatchNode) {
        if (ablePatternMatchNode instanceof AblePatternMatchNegJoinNode) {
            return this.leftPartialMatchNode == ((AblePatternMatchNegJoinNode)ablePatternMatchNode).getLeftPartialMatchNode() && this.rightPartialMatchNode == ((AblePatternMatchNegJoinNode)ablePatternMatchNode).getRightPartialMatchNode();
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        if (this.leftPartialMatchNode != null) {
            n ^= this.leftPartialMatchNode.hashCode();
        }
        if (this.rightPartialMatchNode != null) {
            n ^= this.rightPartialMatchNode.hashCode();
        }
        return n;
    }

    public void clear() {
        this.partialMatchList.clear();
        this.factToBindingsMap.clear();
    }

    public String toString() {
        return Able.NlsMsg((String)"Inf_RsReteNegJoinNodeToString", (Object[])new Object[]{Integer.toString(this.id), this.expression.traceString(2), this.partialMatchList});
    }
}

