/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleLogger;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleInferenceEngine;
import com.ibm.able.rules.AblePatternMatchClause;
import com.ibm.able.rules.AblePatternMatchRule;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleBreakpoint;
import com.ibm.able.rules.AbleRuleSet;
import com.ibm.able.rules.AbleWorkingMemory;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class AblePatternMatchLiteEngine
extends AbleInferenceEngine
implements Serializable {
    static final long serialVersionUID = 2000083100000000001L;
    static String clsNm = "AblePatternMatchLiteEngine";
    protected Hashtable firedRuleBindingPairs = new Hashtable();

    public AblePatternMatchLiteEngine(AbleRuleSet ableRuleSet, AbleLogger ableLogger, AbleRuleBlock ableRuleBlock) {
        super(ableRuleSet, ableLogger, ableRuleBlock);
    }

    public boolean isRuleBlockValid(AbleRuleBlock ableRuleBlock) {
        boolean bl = true;
        String string = null;
        Iterator iterator = null;
        AbleRule ableRule = null;
        AbleRuleBlock ableRuleBlock2 = ableRuleBlock;
        String string2 = ableRuleBlock2.getName();
        iterator = ableRuleBlock2.getIterationRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoIterationRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getPredicateRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoPredicateRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getConditionalRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoConditionalRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getIfThenElseRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoIfThenElseRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        return bl;
    }

    public void infer(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        AbleRuleBlock ableRuleBlock2 = ableRuleBlock;
        this.myRulesFiredCount = 0;
        this.firedRuleBindingPairs.clear();
        if (ableRuleBlock2 != null) {
            this.processAssertions(ableRuleBlock2);
        }
        if (ableRuleBlock2 != null) {
            this.forwardChain(ableRuleBlock2);
        }
    }

    private void forwardChain(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        Vector vector = new Vector();
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "forwardChain()", "Tr_Rs_RuleBlockInferStarts", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType});
        }
        if (this.myDebugLevel == 3) {
            this.fireEngineBreakpoint();
        }
        vector = this.match(ableRuleBlock);
        while (vector.size() > 0) {
            AblePatternMatchRule ablePatternMatchRule = this.selectRule(vector);
            this.processConsequent(ablePatternMatchRule);
            ++this.myRulesFiredCount;
            vector = this.match(ableRuleBlock);
            if (!this.myRuleSet.isInferenceTraceHigh()) continue;
            this.logWorkingMemory();
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "forwardChain()", "Tr_Rs_RuleBlockInferEnds", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType});
        }
    }

    private Vector match(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        Vector vector = new Vector();
        Enumeration enumeration = ableRuleBlock.getEnabledPatternMatchRules().elements();
        this.myRuleSet.myInferenceContext.setRuleBlock(ableRuleBlock);
        while (enumeration.hasMoreElements()) {
            AblePatternMatchRule ablePatternMatchRule = (AblePatternMatchRule)enumeration.nextElement();
            this.setPatternMatchRuleBindings(ablePatternMatchRule);
            if (!ablePatternMatchRule.isTriggered()) continue;
            this.addRuleToConflictSet(vector, ablePatternMatchRule);
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.logConflictSet(vector);
        }
        return vector;
    }

    private AblePatternMatchRule selectRule(Vector vector) {
        AblePatternMatchRule ablePatternMatchRule = null;
        ablePatternMatchRule = (AblePatternMatchRule)vector.elementAt(0);
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "selectRule", "Tr_Rs_SelectRuleToFire", new Object[]{ablePatternMatchRule.getIdLabelString()});
        }
        return ablePatternMatchRule;
    }

    protected void setPatternMatchRuleBindings(AblePatternMatchRule ablePatternMatchRule) throws AbleDataException {
        AblePatternMatchClause ablePatternMatchClause = ablePatternMatchRule.getPatternMatchClause();
        this.myRuleSet.myInferenceContext.setRule(ablePatternMatchRule);
        AbleWorkingMemory ableWorkingMemory = this.myRuleSet.getWorkingMemory();
        ablePatternMatchRule.setBindings(ablePatternMatchClause.match(ableWorkingMemory));
    }

    protected void logWorkingMemory() {
        AbleWorkingMemory ableWorkingMemory = this.myRuleSet.getWorkingMemory();
        HashSet hashSet = null;
        Enumeration enumeration = ableWorkingMemory.getClasses();
        this.myTracer.message(0x40000000000L, (Object)this, "logWorkingMemory", "Tr_Rs_WmLogTitle", new Object[]{this.myRuleBlock.myName});
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashSet = (HashSet)ableWorkingMemory.findAllInstances(string);
            this.myTracer.message(0x40000000000L, (Object)this, "logWorkingMemory", "Tr_Rs_WmLogClass", new Object[]{string, Integer.toString(hashSet.size())});
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.myTracer.message(0x40000000000L, (Object)this, "logWorkingMemory", "Tr_Rs_WmLogItem", new Object[]{iterator.next().toString()});
            }
        }
    }

    protected void logConflictSet(Vector vector) {
        AblePatternMatchRule ablePatternMatchRule = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            ablePatternMatchRule = (AblePatternMatchRule)vector.elementAt(i);
            if (i == 0) {
                stringBuffer.append(ablePatternMatchRule.getIdLabelString());
                continue;
            }
            stringBuffer.append(", " + ablePatternMatchRule.getIdLabelString());
        }
        this.myTracer.message(0x20000000000L, (Object)this, "logConflictSet", "Tr_Rs_WmLogConflictSet", new Object[]{this.myRuleBlock.myName, Integer.toString(vector.size()), stringBuffer.toString()});
    }

    private void processConsequent(AblePatternMatchRule ablePatternMatchRule) throws AbleDataException {
        Object object;
        int n;
        Serializable serializable;
        this.myRuleSet.myInferenceContext.setRule(ablePatternMatchRule);
        if (this.myDebugLevel == 4) {
            this.fireEngineBreakpoint();
        }
        if (this.myDebugLevel == 1 && (serializable = ablePatternMatchRule.getBreakpoint()) != null && ((AbleRuleBreakpoint)serializable).isEnabled()) {
            this.fireEngineBreakpoint();
        }
        serializable = ablePatternMatchRule.getDoActions();
        Vector vector = ablePatternMatchRule.getRuleBindings();
        Vector vector2 = ablePatternMatchRule.getSelectorVariables();
        this.recordRuleFiring(ablePatternMatchRule, vector);
        for (n = 0; n < vector2.size(); ++n) {
            object = (AbleVariable)vector2.elementAt(n);
            object.setGenericValue(vector.elementAt(n));
        }
        if (this.myRuleSet.isInferenceTraceHigh()) {
            this.myTracer.message(0x40000000000L, (Object)this, "processConsequent()", "Tr_Rs_ProcessRule", new Object[]{ablePatternMatchRule.traceString(2)});
        }
        for (n = 0; n < ((Vector)serializable).size(); ++n) {
            object = (AbleConsequentClause)((Vector)serializable).elementAt(n);
            this.evalConsequentClause((AbleConsequentClause)object);
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "processConsequent()", "Tr_Rs_FireRuleShowCountBinding", new Object[]{Integer.toString(this.myRulesFiredCount), ablePatternMatchRule.getIdLabelString(), vector});
        }
        ablePatternMatchRule.setFired(true);
    }

    protected void addRuleToConflictSet(Vector vector, AblePatternMatchRule ablePatternMatchRule) throws AbleDataException {
        double d = ablePatternMatchRule.getPriority();
        long l = ablePatternMatchRule.numberOfSelectors();
        boolean bl = false;
        Collection collection = ablePatternMatchRule.getBindings();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Vector vector2 = (Vector)iterator.next();
            if (!this.isDuplicateFiring(ablePatternMatchRule, vector2)) continue;
            iterator.remove();
        }
        if (collection.size() == 0) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            AblePatternMatchRule ablePatternMatchRule2 = (AblePatternMatchRule)vector.elementAt(i);
            if (d > ablePatternMatchRule2.getPriority()) {
                vector.insertElementAt(ablePatternMatchRule, i);
                bl = true;
                break;
            }
            if (d != ablePatternMatchRule2.getPriority() || l <= ablePatternMatchRule2.numberOfSelectors()) continue;
            vector.insertElementAt(ablePatternMatchRule, i);
            bl = true;
            break;
        }
        if (!bl) {
            vector.addElement(ablePatternMatchRule);
        }
    }

    public void setControlParameter(String string, Object object) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnsupportedControlParameter", (Object[])new Object[]{this.myRuleBlock.getEngineType(), string}));
    }

    public Object getControlParameter(String string) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnsupportedControlParameter", (Object[])new Object[]{this.myRuleBlock.getEngineType(), string}));
    }

    protected void recordRuleFiring(AbleRule ableRule, Vector vector) {
        HashSet<Vector> hashSet = (HashSet<Vector>)this.firedRuleBindingPairs.get(ableRule);
        if (hashSet == null) {
            hashSet = new HashSet<Vector>();
            this.firedRuleBindingPairs.put(ableRule, hashSet);
        }
        hashSet.add(vector);
    }

    protected boolean isDuplicateFiring(AbleRule ableRule, Vector vector) {
        HashSet hashSet = (HashSet)this.firedRuleBindingPairs.get(ableRule);
        return hashSet != null && hashSet.contains(vector);
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

