/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleClearable;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleInferenceEngine;
import com.ibm.able.rules.AblePatternMatchNode;
import com.ibm.able.rules.AblePatternMatchTerminalNode;
import com.ibm.able.rules.AblePatternMatchTestNode;
import com.ibm.able.rules.AbleRuleSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

class AblePatternMatchJoinNode
extends AblePatternMatchTestNode
implements Serializable,
AbleClearable {
    static final long serialVersionUID = -8925248566395166853L;
    protected AblePatternMatchNode leftPartialMatchNode = null;
    protected AblePatternMatchNode rightPartialMatchNode = null;
    protected HashSet partialMatchList = new HashSet();
    protected Hashtable factToBindingsMap = new Hashtable();

    public AblePatternMatchJoinNode(int n, AbleRuleSet ableRuleSet, AblePatternMatchNode ablePatternMatchNode, AblePatternMatchNode ablePatternMatchNode2, AbleExpression ableExpression, AbleVariable ableVariable) {
        super(n, ableRuleSet, ableExpression, ableVariable);
        this.leftPartialMatchNode = ablePatternMatchNode;
        this.rightPartialMatchNode = ablePatternMatchNode2;
    }

    public void processAddToken(AblePatternMatchNode ablePatternMatchNode, Object object, Vector vector) throws AbleDataException {
        if (ablePatternMatchNode == this.leftPartialMatchNode) {
            if (this.leftPartialMatchNode instanceof AblePatternMatchTerminalNode) {
                this.processLeftTermToken(object, vector);
                if (this.leftPartialMatchNode == this.rightPartialMatchNode) {
                    this.processRightTermToken(object, vector);
                }
            } else {
                this.processLeftJoinToken(object, vector);
            }
        } else {
            this.processRightTermToken(object, vector);
        }
    }

    public void processRemoveToken(AblePatternMatchNode ablePatternMatchNode, Object object, Vector vector) throws AbleDataException {
        HashSet hashSet;
        if (this.partialMatchList.size() > 0 && (hashSet = (HashSet)this.factToBindingsMap.remove(object)) != null) {
            this.partialMatchList.removeAll(hashSet);
        }
        this.processRemoveLinks(this, object, vector);
    }

    public void processLeftTermToken(Object object, Vector vector) throws AbleDataException {
        AbleVariable ableVariable = (AbleVariable)this.selectorVars.get(0);
        ableVariable.setGenericValue(object);
        Collection collection = this.rightPartialMatchNode.getPatternMatchList();
        if (!collection.isEmpty()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Vector vector2 = (Vector)iterator.next();
                Object e = vector2.get(0);
                if (object == e) continue;
                this.selectorVar.setGenericValue(e);
                Boolean bl = AbleInferenceEngine.evalAntecedentExpression(this.expression);
                if (bl == null || !bl.booleanValue()) continue;
                Vector vector3 = (Vector)vector.clone();
                if (this.leftPartialMatchNode.getSelectorVariable() != this.selectorVar) {
                    vector3.add(e);
                }
                this.partialMatchList.add(vector3);
                this.updateFactToBindingsMap(vector3);
                this.processAddLinks(this, object, vector3);
            }
        }
    }

    public void processRightTermToken(Object object, Vector vector) throws AbleDataException {
        this.selectorVar.setGenericValue(object);
        Collection collection = this.leftPartialMatchNode.getPatternMatchList();
        Collection collection2 = this.leftPartialMatchNode.getFactBindings(object);
        if (!collection.isEmpty()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object object2;
                Vector vector2 = (Vector)iterator.next();
                if (collection2 != null && collection2.contains(vector2)) continue;
                for (int i = 0; i < vector2.size(); ++i) {
                    object2 = (AbleVariable)this.selectorVars.elementAt(i);
                    object2.setGenericValue(vector2.elementAt(i));
                }
                Boolean bl = AbleInferenceEngine.evalAntecedentExpression(this.expression);
                if (bl == null || !bl.booleanValue()) continue;
                object2 = (Vector)vector2.clone();
                if (this.leftPartialMatchNode.getSelectorVariable() != this.selectorVar) {
                    ((Vector)object2).add(object);
                }
                this.partialMatchList.add(object2);
                this.updateFactToBindingsMap((Vector)object2);
                this.processAddLinks(this, object, (Vector)object2);
            }
        }
    }

    public void processLeftJoinToken(Object object, Vector vector) throws AbleDataException {
        Object object2;
        for (int i = 0; i < vector.size(); ++i) {
            object2 = (AbleVariable)this.selectorVars.elementAt(i);
            object2.setGenericValue(vector.elementAt(i));
        }
        if (this.selectorVar == this.leftPartialMatchNode.getSelectorVariable()) {
            Boolean bl = AbleInferenceEngine.evalAntecedentExpression(this.expression);
            if (bl != null && bl.booleanValue()) {
                object2 = (Vector)vector.clone();
                this.partialMatchList.add(object2);
                this.updateFactToBindingsMap((Vector)object2);
                this.processAddLinks(this, object, (Vector)object2);
            }
        } else {
            Collection collection = this.rightPartialMatchNode.getPatternMatchList();
            if (!collection.isEmpty()) {
                object2 = collection.iterator();
                while (object2.hasNext()) {
                    Vector vector2 = (Vector)object2.next();
                    Object e = vector2.get(0);
                    Collection collection2 = this.leftPartialMatchNode.getFactBindings(e);
                    if (collection2 != null && collection2.contains(vector)) continue;
                    this.selectorVar.setGenericValue(e);
                    Boolean bl = AbleInferenceEngine.evalAntecedentExpression(this.expression);
                    if (bl == null || !bl.booleanValue()) continue;
                    Vector vector3 = (Vector)vector.clone();
                    vector3.add(e);
                    this.partialMatchList.add(vector3);
                    this.updateFactToBindingsMap(vector3);
                    this.processAddLinks(this, object, vector3);
                }
            }
        }
    }

    protected void updateFactToBindingsMap(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.get(i);
            if (e == null) continue;
            HashSet hashSet = (HashSet)this.factToBindingsMap.get(e);
            if (hashSet == null) {
                HashSet<Vector> hashSet2 = new HashSet<Vector>();
                hashSet2.add(vector);
                this.factToBindingsMap.put(e, hashSet2);
                continue;
            }
            hashSet.add(vector);
        }
    }

    public AblePatternMatchNode getLeftPartialMatchNode() {
        return this.leftPartialMatchNode;
    }

    public AblePatternMatchNode getRightPartialMatchNode() {
        return this.rightPartialMatchNode;
    }

    public Collection getPatternMatchList() {
        return this.partialMatchList;
    }

    public Collection getFactBindings(Object object) {
        return (Collection)this.factToBindingsMap.get(object);
    }

    public void setSelectorValue(Object object) throws AbleDataException {
        this.selectorVar.setGenericValue(object);
    }

    public boolean equals(AblePatternMatchNode ablePatternMatchNode) {
        if (ablePatternMatchNode instanceof AblePatternMatchJoinNode) {
            return this.leftPartialMatchNode == ((AblePatternMatchJoinNode)ablePatternMatchNode).getLeftPartialMatchNode() && this.rightPartialMatchNode == ((AblePatternMatchJoinNode)ablePatternMatchNode).getRightPartialMatchNode() && this.expression.equals(((AblePatternMatchJoinNode)ablePatternMatchNode).expression);
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        if (this.leftPartialMatchNode != null) {
            n ^= this.leftPartialMatchNode.hashCode();
        }
        if (this.rightPartialMatchNode != null) {
            n ^= this.rightPartialMatchNode.hashCode();
        }
        if (this.expression != null) {
            n ^= this.expression.hashCode();
        }
        return n;
    }

    public void clear() {
        this.partialMatchList.clear();
        this.factToBindingsMap.clear();
    }

    public String toString() {
        return Able.NlsMsg((String)"Inf_RsReteJoinNodeToString", (Object[])new Object[]{Integer.toString(this.id), this.expression.traceString(2), this.partialMatchList});
    }
}

