/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.AbleLogger;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleInferenceEngine;
import com.ibm.able.rules.AblePatternMatchClause;
import com.ibm.able.rules.AblePatternMatchNetwork;
import com.ibm.able.rules.AblePatternMatchRule;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleBreakpoint;
import com.ibm.able.rules.AbleRuleSet;
import com.ibm.able.rules.AbleWorkingMemory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class AblePatternMatchEngine
extends AbleInferenceEngine
implements Serializable {
    static final long serialVersionUID = 2000083100000000001L;
    static final String clsNm = "AblePatternMatchEngine";
    protected AblePatternMatchNetwork myPatternMatchNet = null;
    protected transient Hashtable firedRuleBindingPairs = new Hashtable();
    protected transient TreeSet conflictSet = new TreeSet(new patternMatchRuleComparator());

    public AblePatternMatchEngine(AbleRuleSet ableRuleSet, AbleLogger ableLogger, AbleRuleBlock ableRuleBlock) {
        super(ableRuleSet, ableLogger, ableRuleBlock);
        this.allocateWorkingMemory();
    }

    public boolean isRuleBlockValid(AbleRuleBlock ableRuleBlock) {
        boolean bl = true;
        String string = null;
        Iterator iterator = null;
        AbleRule ableRule = null;
        AbleRuleBlock ableRuleBlock2 = ableRuleBlock;
        String string2 = ableRuleBlock2.getName();
        iterator = ableRuleBlock2.getIterationRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoIterationRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getPredicateRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoPredicateRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getConditionalRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoConditionalRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getIfThenElseRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoIfThenElseRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        return bl;
    }

    public void infer(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        AbleRuleBlock ableRuleBlock2 = ableRuleBlock;
        this.myRulesFiredCount = 0;
        this.firedRuleBindingPairs.clear();
        if (ableRuleBlock2 != null) {
            this.processAssertions(ableRuleBlock2);
        }
        if (ableRuleBlock2 != null) {
            this.forwardChain(ableRuleBlock2);
        }
    }

    private void forwardChain(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        this.myRuleSet.myInferenceContext.setRuleBlock(ableRuleBlock);
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "forwardChain()", "Tr_Rs_RuleBlockInferStarts", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType});
            this.logWorkingMemory();
        }
        if (this.myDebugLevel == 3) {
            this.fireEngineBreakpoint();
        }
        this.match(ableRuleBlock);
        while (this.conflictSet.size() > 0) {
            AblePatternMatchRule ablePatternMatchRule = this.selectRule();
            this.processConsequent(ablePatternMatchRule);
            ++this.myRulesFiredCount;
            this.match(ableRuleBlock);
            if (!this.myRuleSet.isInferenceTraceHigh()) continue;
            this.logWorkingMemory();
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "forwardChain()", "Tr_Rs_RuleBlockInferEnds", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType});
        }
    }

    private SortedSet match(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.logConflictSet(this.conflictSet);
        }
        return this.conflictSet;
    }

    private AblePatternMatchRule selectRule() {
        AblePatternMatchRule ablePatternMatchRule = (AblePatternMatchRule)this.conflictSet.last();
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "selectRule", "Tr_Rs_SelectRuleToFire", new Object[]{ablePatternMatchRule.getIdLabelString()});
        }
        this.myRuleSet.myInferenceContext.setRule(ablePatternMatchRule);
        return ablePatternMatchRule;
    }

    protected void evalPatternMatchRule(AblePatternMatchRule ablePatternMatchRule) throws AbleDataException {
        this.myRuleSet.myInferenceContext.setRule(ablePatternMatchRule);
        AblePatternMatchClause ablePatternMatchClause = ablePatternMatchRule.getPatternMatchClause();
        AbleWorkingMemory ableWorkingMemory = this.myRuleSet.getWorkingMemory();
        ablePatternMatchRule.setBindings(ablePatternMatchClause.match(ableWorkingMemory));
    }

    protected void logWorkingMemory() {
        AbleWorkingMemory ableWorkingMemory = this.myRuleSet.getWorkingMemory();
        HashSet hashSet = null;
        Enumeration enumeration = ableWorkingMemory.getClasses();
        this.myTracer.message(0x40000000000L, (Object)this, "logWorkingMemory", "Tr_Rs_WmLogTitle", new Object[]{this.myRuleBlock.myName});
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashSet = (HashSet)ableWorkingMemory.findAllInstances(string);
            this.myTracer.message(0x40000000000L, (Object)this, "logWorkingMemory", "Tr_Rs_WmLogClass", new Object[]{string, Integer.toString(hashSet.size())});
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.myTracer.message(0x40000000000L, (Object)this, "logWorkingMemory", "Tr_Rs_WmLogItem", new Object[]{iterator.next().toString()});
            }
        }
    }

    protected void logConflictSet(SortedSet sortedSet) {
        AblePatternMatchRule ablePatternMatchRule = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            ablePatternMatchRule = (AblePatternMatchRule)iterator.next();
            if (n == 0) {
                stringBuffer.append(ablePatternMatchRule.getIdLabelString() + "[" + ablePatternMatchRule.getBindings().size() + "]");
            } else {
                stringBuffer.append(", " + ablePatternMatchRule.getIdLabelString() + "[" + ablePatternMatchRule.getBindings().size() + "]");
            }
            ++n;
        }
        this.myTracer.message(0x20000000000L, (Object)this, "logConflictSet", "Tr_Rs_WmLogConflictSet", new Object[]{this.myRuleBlock.myName, Integer.toString(sortedSet.size()), stringBuffer.toString()});
    }

    private void processConsequent(AblePatternMatchRule ablePatternMatchRule) throws AbleDataException {
        Object object;
        int n;
        Serializable serializable;
        this.myRuleSet.myInferenceContext.setRule(ablePatternMatchRule);
        if (this.myDebugLevel == 4) {
            this.fireEngineBreakpoint();
        }
        if (this.myDebugLevel == 1 && (serializable = ablePatternMatchRule.getBreakpoint()) != null && ((AbleRuleBreakpoint)serializable).isEnabled()) {
            this.fireEngineBreakpoint();
        }
        serializable = ablePatternMatchRule.getDoActions();
        Vector vector = ablePatternMatchRule.getRuleBindings();
        Vector vector2 = ablePatternMatchRule.getSelectorVariables();
        for (n = 0; n < vector2.size(); ++n) {
            object = (AbleVariable)vector2.get(n);
            object.setGenericValue(vector.get(n));
        }
        if (this.myRuleSet.isInferenceTraceHigh()) {
            this.myTracer.message(0x40000000000L, (Object)this, "processConsequent()", "Tr_Rs_ProcessRule", new Object[]{ablePatternMatchRule.traceString(2)});
        }
        for (n = 0; n < ((Vector)serializable).size(); ++n) {
            object = (AbleConsequentClause)((Vector)serializable).elementAt(n);
            this.evalConsequentClause((AbleConsequentClause)object);
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "processConsequent()", "Tr_Rs_FireRuleShowCountBinding", new Object[]{Integer.toString(this.myRulesFiredCount), ablePatternMatchRule.getIdLabelString(), vector});
        }
        ablePatternMatchRule.removeBindings(vector);
        ablePatternMatchRule.setFired(true);
    }

    public boolean addRuleToConflictSet(AblePatternMatchRule ablePatternMatchRule) {
        return this.conflictSet.add(ablePatternMatchRule);
    }

    public boolean removeRuleFromConflictSet(AblePatternMatchRule ablePatternMatchRule) {
        return this.conflictSet.remove(ablePatternMatchRule);
    }

    public void setControlParameter(String string, Object object) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnsupportedControlParameter", (Object[])new Object[]{this.myRuleBlock.getEngineType(), string}));
    }

    public Object getControlParameter(String string) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnsupportedControlParameter", (Object[])new Object[]{this.myRuleBlock.getEngineType(), string}));
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    public AbleWorkingMemory allocateWorkingMemory() {
        if (this.myWorkingMemory == null) {
            try {
                this.myPatternMatchNet = new AblePatternMatchNetwork(this.myRuleSet, this.myRuleBlock, this.myTracer, super.allocateWorkingMemory());
            }
            catch (AbleException ableException) {
                String string = Able.NlsMsg((String)"Ex_RsReteCompileError", (Object[])new Object[]{ableException.getLocalizedMessage()});
                if (this.myRuleSet.isInferenceTraceMedium()) {
                    this.myTracer.text(0x10000000000L, (Object)this, clsNm, string);
                }
                Able.MessageLog.text(4L, (Object)this, clsNm, string);
            }
            this.myWorkingMemory = this.myPatternMatchNet;
        }
        return this.myWorkingMemory;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.firedRuleBindingPairs = new Hashtable();
        this.conflictSet = new TreeSet(new patternMatchRuleComparator());
    }

    protected static class patternMatchRuleComparator
    implements Comparator,
    Serializable {
        static final long serialVersionUID = 2000083100000000001L;

        protected patternMatchRuleComparator() {
        }

        public int compare(Object object, Object object2) {
            try {
                AblePatternMatchRule ablePatternMatchRule;
                double d;
                if (object == object2) {
                    return 0;
                }
                AblePatternMatchRule ablePatternMatchRule2 = (AblePatternMatchRule)object;
                double d2 = ablePatternMatchRule2.getPriority();
                if (d2 > (d = (ablePatternMatchRule = (AblePatternMatchRule)object2).getPriority())) {
                    return 1;
                }
                if (d2 < d) {
                    return -1;
                }
                if (ablePatternMatchRule2.myRuleNumber > ablePatternMatchRule.myRuleNumber) {
                    return 1;
                }
                if (ablePatternMatchRule2.myRuleNumber < ablePatternMatchRule.myRuleNumber) {
                    return -1;
                }
                return 0;
            }
            catch (AbleDataException ableDataException) {
                return 0;
            }
        }
    }
}

