/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleLogger;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleRuleSet;
import com.ibm.able.rules.AbleSelector;
import com.ibm.able.rules.AbleWorkingMemory;
import java.io.Serializable;
import java.util.Vector;

public class AblePatternMatchClause
implements Serializable {
    static final long serialVersionUID = 2001022300000000001L;
    protected Vector selectors;
    protected Vector resultSet;
    protected AbleVariable[] selectorVars;
    protected int numSelectors = 0;
    protected AbleWorkingMemory workingMemory;
    protected AbleLogger myTracer = null;
    protected AbleRuleSet myRuleSet = null;

    public AblePatternMatchClause(Vector vector) {
        this.selectors = vector;
        this.selectorVars = new AbleVariable[this.selectors.size()];
        this.numSelectors = this.selectorVars.length;
        for (int i = 0; i < this.numSelectors; ++i) {
            AbleSelector ableSelector = (AbleSelector)this.selectors.get(i);
            this.selectorVars[i] = ableSelector.getSelectorVariable();
        }
        AbleVariable ableVariable = this.selectorVars[0];
        this.myRuleSet = (AbleRuleSet)ableVariable.getContext();
        this.myTracer = this.myRuleSet.getInferTraceLogger();
    }

    public Vector match(AbleWorkingMemory ableWorkingMemory) throws AbleDataException {
        this.workingMemory = ableWorkingMemory;
        this.resultSet = new Vector();
        this.matchRest(this.resultSet, 0);
        return this.resultSet;
    }

    private void matchRest(Vector vector, int n) {
        AbleSelector ableSelector = (AbleSelector)this.selectors.get(n);
        AbleVariable ableVariable = ableSelector.getSelectorVariable();
        try {
            Vector vector2 = ableSelector.match(this.workingMemory);
            if (ableSelector.isNegative() && vector2.size() > 0) {
                return;
            }
            if (n == this.numSelectors - 1) {
                if (ableSelector.isNegative() && vector2.size() == 0) {
                    ableVariable.reset();
                    vector2.add(ableVariable.getGenericValue());
                }
                for (int i = 0; i < vector2.size(); ++i) {
                    Object e = vector2.elementAt(i);
                    ableVariable.setGenericValue(e);
                    Vector<Object> vector3 = new Vector<Object>();
                    for (int j = 0; j < this.numSelectors; ++j) {
                        vector3.add(((AbleSelector)this.selectors.get(j)).getSelectorValue());
                    }
                    vector.add(vector3);
                }
            } else if (ableSelector.isNegative() && vector2.size() == 0) {
                this.matchRest(vector, n + 1);
            } else {
                for (int i = 0; i < vector2.size(); ++i) {
                    Object e = vector2.elementAt(i);
                    ableVariable.setGenericValue(e);
                    this.matchRest(vector, n + 1);
                }
            }
        }
        catch (AbleDataException ableDataException) {
            if (this.myRuleSet.isInferenceTraceLow()) {
                this.myTracer.text(0x10000000000L, (Object)this, "matchRest", ableDataException.getLocalizedMessage());
            }
            Able.MessageLog.text(4L, (Object)this, "matchRest", ableDataException.getLocalizedMessage());
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

