/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleClearable;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AblePatternMatchNode;
import com.ibm.able.rules.AblePatternMatchTerminalNode;
import com.ibm.able.rules.AblePatternMatchTestNode;
import com.ibm.able.rules.AbleRuleSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

class AblePatternMatchAndJoinNode
extends AblePatternMatchTestNode
implements Serializable,
AbleClearable {
    static final long serialVersionUID = -4141369808987139935L;
    protected AblePatternMatchNode leftPartialMatchNode = null;
    protected AblePatternMatchNode rightPartialMatchNode = null;
    protected HashSet partialMatchList = new HashSet();
    protected Hashtable factToBindingsMap = new Hashtable();

    public AblePatternMatchAndJoinNode(int n, AbleRuleSet ableRuleSet, AblePatternMatchNode ablePatternMatchNode, AblePatternMatchNode ablePatternMatchNode2, AbleExpression ableExpression, AbleVariable ableVariable) {
        super(n, ableRuleSet, ableExpression, ableVariable);
        this.leftPartialMatchNode = ablePatternMatchNode;
        this.rightPartialMatchNode = ablePatternMatchNode2;
    }

    public void processAddToken(AblePatternMatchNode ablePatternMatchNode, Object object, Vector vector) throws AbleDataException {
        if (ablePatternMatchNode == this.leftPartialMatchNode) {
            if (this.leftPartialMatchNode instanceof AblePatternMatchTerminalNode) {
                this.processLeftTermToken(object, vector);
            } else {
                this.processLeftJoinToken(object, vector);
            }
        } else {
            this.processRightTermToken(object, vector);
        }
    }

    public void processRemoveToken(AblePatternMatchNode ablePatternMatchNode, Object object, Vector vector) throws AbleDataException {
        HashSet hashSet;
        if (this.partialMatchList.size() > 0 && (hashSet = (HashSet)this.factToBindingsMap.remove(object)) != null) {
            this.partialMatchList.removeAll(hashSet);
        }
        this.processRemoveLinks(this, object, vector);
    }

    public void processLeftTermToken(Object object, Vector vector) throws AbleDataException {
        AbleVariable ableVariable = (AbleVariable)this.selectorVars.get(0);
        ableVariable.setGenericValue(object);
        Collection collection = this.rightPartialMatchNode.getPatternMatchList();
        if (!collection.isEmpty()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Vector vector2 = (Vector)iterator.next();
                Object e = vector2.get(0);
                if (object == e) continue;
                this.selectorVar.setGenericValue(e);
                Vector vector3 = (Vector)vector.clone();
                if (this.leftPartialMatchNode.getSelectorVariable() != this.selectorVar) {
                    vector3.add(e);
                }
                this.partialMatchList.add(vector3);
                this.updateFactToBindingsMap(vector3);
                this.processAddLinks(this, object, vector3);
            }
        }
    }

    public void processRightTermToken(Object object, Vector vector) throws AbleDataException {
        this.selectorVar.setGenericValue(object);
        Collection collection = this.leftPartialMatchNode.getPatternMatchList();
        Collection collection2 = this.leftPartialMatchNode.getFactBindings(object);
        if (!collection.isEmpty()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Vector vector2 = (Vector)iterator.next();
                if (collection2 != null && collection2.contains(vector2)) continue;
                for (int i = 0; i < vector2.size(); ++i) {
                    AbleVariable ableVariable = (AbleVariable)this.selectorVars.elementAt(i);
                    ableVariable.setGenericValue(vector2.elementAt(i));
                }
                Vector vector3 = (Vector)vector2.clone();
                if (this.leftPartialMatchNode.getSelectorVariable() != this.selectorVar) {
                    vector3.add(object);
                }
                this.partialMatchList.add(vector3);
                this.updateFactToBindingsMap(vector3);
                this.processAddLinks(this, object, vector3);
            }
        }
    }

    public void processLeftJoinToken(Object object, Vector vector) throws AbleDataException {
        Object object2;
        for (int i = 0; i < vector.size(); ++i) {
            object2 = (AbleVariable)this.selectorVars.elementAt(i);
            object2.setGenericValue(vector.elementAt(i));
        }
        if (this.selectorVar == this.leftPartialMatchNode.getSelectorVariable()) {
            Vector vector2 = (Vector)vector.clone();
            this.partialMatchList.add(vector2);
            this.updateFactToBindingsMap(vector2);
            this.processAddLinks(this, object, vector2);
        } else {
            Collection collection = this.rightPartialMatchNode.getPatternMatchList();
            if (!collection.isEmpty()) {
                object2 = collection.iterator();
                while (object2.hasNext()) {
                    Vector vector3 = (Vector)object2.next();
                    Object e = vector3.get(0);
                    Collection collection2 = this.leftPartialMatchNode.getFactBindings(e);
                    if (collection2 != null && collection2.contains(vector)) continue;
                    this.selectorVar.setGenericValue(e);
                    Vector vector4 = (Vector)vector.clone();
                    vector4.add(e);
                    this.partialMatchList.add(vector4);
                    this.updateFactToBindingsMap(vector4);
                    this.processAddLinks(this, object, vector4);
                }
            }
        }
    }

    protected void updateFactToBindingsMap(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.get(i);
            if (e == null) continue;
            HashSet hashSet = (HashSet)this.factToBindingsMap.get(e);
            if (hashSet == null) {
                HashSet<Vector> hashSet2 = new HashSet<Vector>();
                hashSet2.add(vector);
                this.factToBindingsMap.put(e, hashSet2);
                continue;
            }
            hashSet.add(vector);
        }
    }

    public AblePatternMatchNode getLeftPartialMatchNode() {
        return this.leftPartialMatchNode;
    }

    public AblePatternMatchNode getRightPartialMatchNode() {
        return this.rightPartialMatchNode;
    }

    public Collection getPatternMatchList() {
        return this.partialMatchList;
    }

    public void setSelectorValue(Object object) throws AbleDataException {
        this.selectorVar.setGenericValue(object);
    }

    public boolean equals(AblePatternMatchNode ablePatternMatchNode) {
        if (ablePatternMatchNode instanceof AblePatternMatchAndJoinNode) {
            return this.leftPartialMatchNode == ((AblePatternMatchAndJoinNode)ablePatternMatchNode).getLeftPartialMatchNode() && this.rightPartialMatchNode == ((AblePatternMatchAndJoinNode)ablePatternMatchNode).getRightPartialMatchNode();
        }
        return false;
    }

    public void clear() {
        this.partialMatchList.clear();
        this.factToBindingsMap.clear();
    }

    public String toString() {
        return Able.NlsMsg((String)"Inf_RsReteJoinNodeToString", (Object[])new Object[]{Integer.toString(this.id), this.expression.traceString(2), this.partialMatchList});
    }
}

