/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleEvent;
import com.ibm.able.AbleException;
import com.ibm.able.AbleLogger;
import com.ibm.able.data.AbleBooleanLiteral;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleLhs;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleAntecedentClause;
import com.ibm.able.rules.AbleAssertionClause;
import com.ibm.able.rules.AbleAssertionRule;
import com.ibm.able.rules.AbleClause;
import com.ibm.able.rules.AbleConditionalRule;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleDoUntilRule;
import com.ibm.able.rules.AbleDoWhileRule;
import com.ibm.able.rules.AbleForLoopRule;
import com.ibm.able.rules.AbleIfThenElseRule;
import com.ibm.able.rules.AbleIterationRule;
import com.ibm.able.rules.AbleObjectWorkingMemory;
import com.ibm.able.rules.AblePatternMatchClause;
import com.ibm.able.rules.AblePatternMatchRule;
import com.ibm.able.rules.AblePolicyRule;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleBreakpoint;
import com.ibm.able.rules.AbleRuleSet;
import com.ibm.able.rules.AbleSwitchRule;
import com.ibm.able.rules.AbleWhileDoRule;
import com.ibm.able.rules.AbleWorkingMemory;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public abstract class AbleInferenceEngine
implements Serializable {
    static final long serialVersionUID = 2000083100000000001L;
    static String clsNm = "AbleInferenceEngine";
    protected AbleRuleSet myRuleSet = null;
    protected AbleLogger myTracer = null;
    protected AbleRuleBlock myRuleBlock;
    protected int myDebugLevel = 0;
    protected AbleWorkingMemory myWorkingMemory = null;
    protected int myRulesFiredCount = 0;

    public AbleInferenceEngine(AbleRuleSet ableRuleSet, AbleLogger ableLogger, AbleRuleBlock ableRuleBlock) {
        this.myRuleSet = ableRuleSet;
        this.myTracer = ableLogger;
        this.myRuleBlock = ableRuleBlock;
    }

    public AbleInferenceEngine(AbleRuleSet ableRuleSet, AbleLogger ableLogger) {
        this.myRuleSet = ableRuleSet;
        this.myTracer = ableLogger;
    }

    public AbleInferenceEngine(AbleLogger ableLogger) {
        this(null, ableLogger);
    }

    public AbleInferenceEngine() {
        this(null, null);
    }

    public final void setRuleSet(AbleRuleSet ableRuleSet) {
        this.myRuleSet = ableRuleSet;
    }

    public final AbleRuleSet getRuleSet() {
        return this.myRuleSet;
    }

    public void resetRuleSet() throws AbleException {
        if (this.myRuleSet != null) {
            this.myRuleSet.reset();
        }
    }

    public void setControlParameters(Hashtable hashtable) throws AbleDataException {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setControlParameter(string, hashtable.get(string));
        }
    }

    public abstract void setControlParameter(String var1, Object var2) throws AbleDataException;

    public abstract Object getControlParameter(String var1) throws AbleDataException;

    public abstract boolean isRuleBlockValid(AbleRuleBlock var1) throws AbleDataException;

    protected static boolean conditionalRulesValid(AbleRuleSet ableRuleSet, AbleRuleBlock ableRuleBlock) {
        boolean bl = true;
        Enumeration enumeration = ableRuleBlock.getConditionalRules().elements();
        while (enumeration.hasMoreElements()) {
            String string;
            AbleRule ableRule = (AbleRule)enumeration.nextElement();
            if (!(ableRule instanceof AbleConditionalRule)) continue;
            AbleConditionalRule ableConditionalRule = (AbleConditionalRule)ableRule;
            if ((double)ableConditionalRule.numberOfAntecedents() == 0.0) {
                string = Able.NlsMsg((String)"Ex_RsNotExAnt", (Object[])new Object[]{ableConditionalRule.getIdLabelString()});
                Able.MessageLog.text(4L, string);
                ableRuleSet.addIsExReason(string);
                bl = false;
            }
            if ((double)ableConditionalRule.numberOfThenClauses() != 0.0) continue;
            string = Able.NlsMsg((String)"Ex_RsNotExCns", (Object[])new Object[]{ableConditionalRule.getIdLabelString()});
            Able.MessageLog.text(4L, string);
            ableRuleSet.addIsExReason(string);
            bl = false;
        }
        return bl;
    }

    public void init() throws AbleException {
    }

    public void reset() {
        Vector vector = this.myRuleBlock.getRules();
        for (int i = 0; i < vector.size(); ++i) {
            AbleRule ableRule = (AbleRule)vector.get(i);
            ableRule.reset();
        }
    }

    public abstract void infer(AbleRuleBlock var1) throws AbleDataException;

    public void processRuleBlock(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "processRuleBlock()", "Tr_Rs_RuleBlockInferStarts", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType});
        }
        this.myRuleSet.myInferenceContext.setRuleBlock(ableRuleBlock);
        if (this.myDebugLevel >= 3) {
            this.fireEngineBreakpoint();
        }
        Vector vector = ableRuleBlock.getEnabledRules();
        for (int i = 0; i < vector.size(); ++i) {
            AbleRuleBreakpoint ableRuleBreakpoint;
            AbleRule ableRule = (AbleRule)vector.elementAt(i);
            this.myRuleSet.myInferenceContext.setRule(ableRule);
            if (this.myDebugLevel == 1 && (ableRuleBreakpoint = ableRule.getBreakpoint()) != null && ableRuleBreakpoint.isEnabled()) {
                this.fireEngineBreakpoint();
            }
            if (ableRule instanceof AbleAssertionRule) {
                this.evalAssertionRule((AbleAssertionRule)ableRule);
                continue;
            }
            if (ableRule instanceof AbleConditionalRule) {
                this.evalConditionalRule((AbleConditionalRule)ableRule);
                continue;
            }
            if (ableRule instanceof AbleIfThenElseRule) {
                this.evalIfThenElseRule((AbleIfThenElseRule)ableRule);
                continue;
            }
            if (ableRule instanceof AblePatternMatchRule) {
                this.evalPatternMatchRule((AblePatternMatchRule)ableRule);
                continue;
            }
            if (ableRule instanceof AbleWhileDoRule) {
                this.evalWhileDoRule((AbleWhileDoRule)ableRule);
                continue;
            }
            if (ableRule instanceof AbleDoUntilRule) {
                this.evalDoUntilRule((AbleDoUntilRule)ableRule);
                continue;
            }
            if (ableRule instanceof AbleDoWhileRule) {
                this.evalDoWhileRule((AbleDoWhileRule)ableRule);
                continue;
            }
            if (ableRule instanceof AbleForLoopRule) {
                this.evalForLoopRule((AbleForLoopRule)ableRule);
                continue;
            }
            if (ableRule instanceof AbleSwitchRule) {
                this.evalSwitchRule((AbleSwitchRule)ableRule);
                continue;
            }
            throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnexpectedRuleType", (Object[])new Object[]{ableRule.getIdLabelString(), this.myRuleBlock.getEngineType()}));
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "processRuleBlock()", "Tr_Rs_RuleBlockInferEnds", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType});
        }
    }

    protected void processAssertions(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        Vector vector = ableRuleBlock.getEnabledAssertions();
        this.myRuleSet.myInferenceContext.setRuleBlock(ableRuleBlock);
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "processAssertions()", "Tr_Rs_RuleBlockAssertionsStarts", new Object[]{ableRuleBlock.getName()});
        }
        for (int i = 0; i < vector.size(); ++i) {
            AbleAssertionRule ableAssertionRule = (AbleAssertionRule)vector.elementAt(i);
            this.evalAssertionRule(ableAssertionRule);
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "processAssertions()", "Tr_Rs_RuleBlockAssertionsEnds", new Object[]{ableRuleBlock.getName()});
        }
    }

    protected void evalAssertionRule(AbleAssertionRule ableAssertionRule) throws AbleDataException {
        Object object;
        if (this.myRuleSet.isInferenceTraceMedium()) {
            object = ableAssertionRule.traceString(2);
            this.myTracer.text(0x20000000000L, (Object)this, "evalAssertionRule()", Able.NlsMsg((String)"Tr_Rs_ProcessAssertionStart", (Object[])new Object[]{object}));
        }
        this.myRuleSet.myInferenceContext.setRule(ableAssertionRule);
        if (this.myDebugLevel >= 4) {
            this.fireEngineBreakpoint();
        }
        if ((object = ableAssertionRule.getAssertion()) != null) {
            this.evalAssertionClause((AbleAssertionClause)object);
            ableAssertionRule.setFired(true);
        }
        if (this.myRuleSet.isInferenceTraceHigh()) {
            String string = ableAssertionRule.traceString(2);
            this.myTracer.text(0x40000000000L, (Object)this, "evalAssertionRule()", Able.NlsMsg((String)"Tr_Rs_ProcessRuleEnd", (Object[])new Object[]{string}));
        }
    }

    protected void evalConditionalRule(AbleConditionalRule ableConditionalRule) throws AbleDataException {
        Vector vector = ableConditionalRule.getAntecedents();
        Boolean bl = null;
        boolean bl2 = false;
        this.myRuleSet.myInferenceContext.setRule(ableConditionalRule);
        if (this.myDebugLevel >= 4) {
            this.fireEngineBreakpoint();
        }
        for (int i = 0; i < vector.size(); ++i) {
            AbleAntecedentClause ableAntecedentClause = (AbleAntecedentClause)vector.elementAt(i);
            bl = AbleInferenceEngine.evalAntecedentClause(ableAntecedentClause);
            if (this.myRuleSet.isInferenceTraceMedium()) {
                this.myTracer.text(0x20000000000L, (Object)this, "evalConditionalRule()", Able.NlsMsg((String)"Tr_Rule_EvaluatedAntClause", (Object[])new Object[]{Integer.toString(i), bl}));
            }
            ableConditionalRule.setFired(true);
            if (bl != null && bl.booleanValue()) continue;
            bl2 = true;
            if (!this.myRuleSet.isInferenceTraceMedium()) break;
            this.myTracer.text(0x20000000000L, (Object)this, "evalConditionalRule()", Able.NlsMsg((String)"Tr_Rs_AntecedentFalse", (Object[])new Object[]{ableConditionalRule.getIdLabelString()}));
            break;
        }
        Vector vector2 = ableConditionalRule.getThenClauses();
        if (!bl2) {
            if (this.myRuleSet.isInferenceTraceLow()) {
                this.myTracer.text(0x10000000000L, Able.NlsMsg((String)"Tr_Rs_EvaluatingConsequents"));
            }
            for (int i = 0; i < vector2.size(); ++i) {
                AbleConsequentClause ableConsequentClause = (AbleConsequentClause)vector2.get(i);
                if (ableConsequentClause == null) continue;
                this.evalConsequentClause(ableConsequentClause);
            }
        }
    }

    protected void evalIfThenElseRule(AbleIfThenElseRule ableIfThenElseRule) throws AbleDataException {
        AbleExpression ableExpression = ableIfThenElseRule.getAntecedent();
        boolean bl = false;
        boolean bl2 = false;
        this.myRuleSet.myInferenceContext.setRule(ableIfThenElseRule);
        if (this.myDebugLevel >= 4) {
            this.fireEngineBreakpoint();
        }
        AbleLiteral ableLiteral = ableExpression.getValue();
        bl = ableLiteral.getBooleanValue();
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.text(0x20000000000L, Able.NlsMsg((String)"Tr_Rule_EvaluatedAntClause", (Object[])new Object[]{ableExpression, bl + ""}));
        }
        ableIfThenElseRule.setFired(true);
        if (!bl) {
            bl2 = true;
            if (this.myRuleSet.isInferenceTraceMedium()) {
                this.myTracer.message(0x20000000000L, (Object)this, "evalIfThenElseRule", "Tr_Rs_AntecedentFalse", new Object[]{ableIfThenElseRule.getIdLabelString()});
            }
        } else if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "evalIfThenElseRule", "Tr_Rs_AntecedentTrue", new Object[]{ableIfThenElseRule.getIdLabelString()});
        }
        Vector vector = ableIfThenElseRule.getThenClauses();
        if (!bl2) {
            if (this.myRuleSet.isInferenceTraceHigh()) {
                this.myTracer.message(0x40000000000L, (Object)this, "evalIfThenElseRule()", "Tr_Rs_EvaluatingConsequents");
            }
        } else {
            vector = ableIfThenElseRule.getElseClauses();
            if (this.myRuleSet.isInferenceTraceHigh()) {
                this.myTracer.message(0x40000000000L, (Object)this, "evalIfThenElseRule()", "Tr_Rs_EvaluatingElseClauses");
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            AbleConsequentClause ableConsequentClause = (AbleConsequentClause)vector.get(i);
            if (ableConsequentClause == null) continue;
            this.evalConsequentClause(ableConsequentClause);
        }
    }

    protected void evalPatternMatchRule(AblePatternMatchRule ablePatternMatchRule) throws AbleDataException {
        AblePatternMatchClause ablePatternMatchClause = ablePatternMatchRule.getPatternMatchClause();
        AbleWorkingMemory ableWorkingMemory = this.myRuleSet.getWorkingMemory();
        ablePatternMatchRule.setBindings(ablePatternMatchClause.match(ableWorkingMemory));
        this.myRuleSet.myInferenceContext.setRule(ablePatternMatchRule);
        if (this.myDebugLevel >= 4) {
            this.fireEngineBreakpoint();
        }
        if (ablePatternMatchRule.isTriggered()) {
            Collection collection = ablePatternMatchRule.getBindings();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.processConsequent(ablePatternMatchRule, (Vector)iterator.next());
            }
        }
    }

    protected void evalWhileDoRule(AbleWhileDoRule ableWhileDoRule) throws AbleDataException {
        this.myRuleSet.myInferenceContext.setRule(ableWhileDoRule);
        if (this.myDebugLevel >= 4) {
            this.fireEngineBreakpoint();
        }
        AbleExpression ableExpression = ableWhileDoRule.getTestExpression();
        while (ableExpression.getBooleanValue()) {
            this.evaluateDoActions(ableWhileDoRule);
        }
    }

    protected void evalDoWhileRule(AbleDoWhileRule ableDoWhileRule) throws AbleDataException {
        this.myRuleSet.myInferenceContext.setRule(ableDoWhileRule);
        if (this.myDebugLevel >= 4) {
            this.fireEngineBreakpoint();
        }
        AbleExpression ableExpression = ableDoWhileRule.getTestExpression();
        do {
            this.evaluateDoActions(ableDoWhileRule);
        } while (ableExpression.getBooleanValue());
    }

    protected void evalDoUntilRule(AbleDoUntilRule ableDoUntilRule) throws AbleDataException {
        this.myRuleSet.myInferenceContext.setRule(ableDoUntilRule);
        if (this.myDebugLevel >= 4) {
            this.fireEngineBreakpoint();
        }
        AbleExpression ableExpression = ableDoUntilRule.getTestExpression();
        do {
            this.evaluateDoActions(ableDoUntilRule);
        } while (!ableExpression.getBooleanValue());
    }

    protected void evalForLoopRule(AbleForLoopRule ableForLoopRule) throws AbleDataException {
        AbleExpression ableExpression;
        this.myRuleSet.myInferenceContext.setRule(ableForLoopRule);
        if (this.myDebugLevel >= 4) {
            this.fireEngineBreakpoint();
        }
        Vector vector = ableForLoopRule.getInitialExpressionList();
        for (int i = 0; i < vector.size(); ++i) {
            ableExpression = (AbleExpression)vector.get(i);
            ableExpression.getValue();
        }
        Vector vector2 = ableForLoopRule.getIteratorExpressionList();
        ableExpression = ableForLoopRule.getTestExpression();
        while (ableExpression.getBooleanValue()) {
            this.evaluateDoActions(ableForLoopRule);
            for (int i = 0; i < vector2.size(); ++i) {
                AbleExpression ableExpression2 = (AbleExpression)vector2.get(i);
                ableExpression2.getValue();
            }
        }
    }

    protected void evaluateDoActions(AbleRule ableRule) throws AbleDataException {
        Vector vector = ((AbleIterationRule)((Object)ableRule)).getDoActions();
        for (int i = 0; i < vector.size(); ++i) {
            AbleConsequentClause ableConsequentClause = (AbleConsequentClause)vector.elementAt(i);
            if (ableConsequentClause == null) continue;
            this.evalConsequentClause(ableConsequentClause);
        }
    }

    protected void evalSwitchRule(AbleSwitchRule ableSwitchRule) throws AbleDataException {
        this.myRuleSet.myInferenceContext.setRule(ableSwitchRule);
        if (this.myDebugLevel >= 4) {
            this.fireEngineBreakpoint();
        }
        ableSwitchRule.getSwitchStatement().evaluate();
    }

    protected void evalAssertionClause(AbleAssertionClause ableAssertionClause) throws AbleDataException {
        this.myRuleSet.myInferenceContext.clause = ableAssertionClause;
        AbleLhs ableLhs = null;
        int n = ableAssertionClause.getOp();
        AbleRd ableRd = ableAssertionClause.getRhs();
        if (n != 10) {
            ableLhs = (AbleLhs)ableAssertionClause.getLhs();
        }
        if (ableRd instanceof AbleExpression) {
            ableRd = ableRd.getValue();
        }
        switch (n) {
            case 1: {
                ableLhs.asgnEq(ableRd);
                break;
            }
            case 10: {
                ableRd.getValue();
                break;
            }
            case 2: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsFuzzyIsInBoolean", (Object[])new Object[]{AbleData.OperatorRl((int)n), this.myRuleBlock.getEngineType()}));
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsComparisonInAssertion", (Object[])new Object[]{AbleData.OperatorRl((int)n), this.myRuleBlock.getEngineType()}));
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsMathOperatorInAssertion", (Object[])new Object[]{AbleData.OperatorRl((int)n), this.myRuleBlock.getEngineType()}));
            }
            case 16: 
            case 17: 
            case 18: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsBooleanOperatorInAssertion", (Object[])new Object[]{AbleData.OperatorRl((int)n), this.myRuleBlock.getEngineType()}));
            }
            default: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnrecognizedOperator", (Object[])new Object[]{Integer.toString(n), this.myRuleBlock.getEngineType()}));
            }
        }
    }

    public static Boolean evalAntecedentClause(AbleAntecedentClause ableAntecedentClause) throws AbleDataException {
        Boolean bl = null;
        AbleRd ableRd = ableAntecedentClause.getLhs();
        int n = ableAntecedentClause.getOp();
        AbleRd ableRd2 = ableAntecedentClause.getRhs();
        while (ableRd instanceof AbleExpression) {
            if (!((ableRd = ableRd.getValue()) instanceof AbleBooleanLiteral)) continue;
            if (n == 16) {
                if (((AbleBooleanLiteral)ableRd).getBooleanValue()) continue;
                return Boolean.FALSE;
            }
            if (n != 17 || !((AbleBooleanLiteral)ableRd).getBooleanValue()) continue;
            return Boolean.TRUE;
        }
        while (ableRd2 instanceof AbleExpression) {
            ableRd2 = ableRd2.getValue();
        }
        switch (n) {
            case 3: {
                if (ableRd.cmpEq(ableRd2)) {
                    bl = Boolean.TRUE;
                    break;
                }
                bl = Boolean.FALSE;
                break;
            }
            case 4: {
                if (ableRd.cmpGt(ableRd2)) {
                    bl = Boolean.TRUE;
                    break;
                }
                bl = Boolean.FALSE;
                break;
            }
            case 5: {
                if (ableRd.cmpGtEq(ableRd2)) {
                    bl = Boolean.TRUE;
                    break;
                }
                bl = Boolean.FALSE;
                break;
            }
            case 7: {
                if (ableRd.cmpLt(ableRd2)) {
                    bl = Boolean.TRUE;
                    break;
                }
                bl = Boolean.FALSE;
                break;
            }
            case 8: {
                if (ableRd.cmpLtEq(ableRd2)) {
                    bl = Boolean.TRUE;
                    break;
                }
                bl = Boolean.FALSE;
                break;
            }
            case 9: {
                if (ableRd.cmpNeq(ableRd2)) {
                    bl = Boolean.TRUE;
                    break;
                }
                bl = Boolean.FALSE;
                break;
            }
            case 18: {
                if (ableRd.logicalNOT(ableRd2)) {
                    bl = Boolean.TRUE;
                    break;
                }
                bl = Boolean.FALSE;
                break;
            }
            case 10: {
                if (ableRd2.getBooleanValue()) {
                    bl = Boolean.TRUE;
                    break;
                }
                bl = Boolean.FALSE;
                break;
            }
            case 6: {
                bl = null;
                ableAntecedentClause.setBooleanTruth(bl);
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsFuzzyIsInBoolean", (Object[])new Object[]{AbleData.OperatorRl((int)n), clsNm}));
            }
            case 1: 
            case 2: {
                bl = null;
                ableAntecedentClause.setBooleanTruth(bl);
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsAssignmentInAntecedant", (Object[])new Object[]{AbleData.OperatorRl((int)n), clsNm}));
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsBooleanOperatorInAntecedant", (Object[])new Object[]{AbleData.OperatorRl((int)n), clsNm}));
            }
            case 16: {
                if (ableRd.logicalAND(ableRd2)) {
                    bl = Boolean.TRUE;
                    break;
                }
                bl = Boolean.FALSE;
                break;
            }
            case 17: {
                if (ableRd.logicalOR(ableRd2)) {
                    bl = Boolean.TRUE;
                    break;
                }
                bl = Boolean.FALSE;
                break;
            }
            default: {
                bl = null;
                ableAntecedentClause.setBooleanTruth(bl);
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnrecognizedOperator", (Object[])new Object[]{Integer.toString(n), clsNm}));
            }
        }
        ableAntecedentClause.setBooleanTruth(bl);
        return bl;
    }

    public static Boolean evalAntecedentExpression(AbleExpression ableExpression) throws AbleDataException {
        if (ableExpression.getBooleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected void processConsequent(AbleConditionalRule ableConditionalRule) throws AbleDataException {
        Vector vector = ableConditionalRule.getThenClauses();
        this.setInferenceContext(ableConditionalRule);
        this.processConsequentClauses(vector);
        ableConditionalRule.setFired(true);
    }

    protected void processConsequent(AblePolicyRule ablePolicyRule) throws AbleDataException {
        Vector vector = ablePolicyRule.getPolicyDecisions();
        this.setInferenceContext(ablePolicyRule);
        this.processConsequentClauses(vector);
        ablePolicyRule.setFired(true);
    }

    protected void processConsequentClauses(Vector vector) throws AbleDataException {
        AbleConsequentClause ableConsequentClause = null;
        for (int i = 0; i < vector.size(); ++i) {
            ableConsequentClause = (AbleConsequentClause)vector.elementAt(i);
            this.evalConsequentClause(ableConsequentClause);
        }
    }

    protected void setInferenceContext(AbleRuleBlock ableRuleBlock) {
        this.myRuleSet.myInferenceContext.setRuleBlock(ableRuleBlock);
    }

    protected void setInferenceContext(AbleRule ableRule) {
        this.myRuleSet.myInferenceContext.setRule(ableRule);
    }

    protected void setInferenceContext(AbleClause ableClause) {
        this.myRuleSet.myInferenceContext.setClause(ableClause);
    }

    private void processConsequent(AblePatternMatchRule ablePatternMatchRule, Vector vector) throws AbleDataException {
        Object object;
        int n;
        Vector vector2 = ablePatternMatchRule.getDoActions();
        Vector vector3 = ablePatternMatchRule.getSelectorVariables();
        this.myRuleSet.myInferenceContext.setRule(ablePatternMatchRule);
        for (n = 0; n < vector3.size(); ++n) {
            object = (AbleVariable)vector3.elementAt(n);
            object.setGenericValue(vector.elementAt(n));
        }
        for (n = 0; n < vector2.size(); ++n) {
            object = (AbleConsequentClause)vector2.elementAt(n);
            this.evalConsequentClause((AbleConsequentClause)object);
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "processConsequent()", "Tr_Rs_FireRuleShowBinding", new Object[]{ablePatternMatchRule.getIdLabelString(), ablePatternMatchRule.getBindings()});
        }
        ablePatternMatchRule.setFired(true);
    }

    public void evalConsequentClause(AbleConsequentClause ableConsequentClause) throws AbleDataException {
        this.myRuleSet.myInferenceContext.clause = ableConsequentClause;
        if (this.myDebugLevel >= 5) {
            this.fireEngineBreakpoint();
        }
        AbleLhs ableLhs = null;
        int n = ableConsequentClause.getOp();
        AbleRd ableRd = ableConsequentClause.getRhs();
        if (ableRd instanceof AbleExpression) {
            ableRd = ableRd.getValue();
        }
        if (n != 10) {
            ableLhs = (AbleLhs)ableConsequentClause.getLhs();
        }
        switch (n) {
            case 1: {
                ableLhs.asgnEq(ableRd);
                break;
            }
            case 2: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsFuzzyIsInBoolean", (Object[])new Object[]{AbleData.OperatorRl((int)n), this.myRuleBlock.getEngineType()}));
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsComparisonInConsequent", (Object[])new Object[]{AbleData.OperatorRl((int)n), this.myRuleBlock.getEngineType()}));
            }
            case 10: {
                ableRd.getValue();
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsMathOperatorInConsequent", (Object[])new Object[]{AbleData.OperatorRl((int)n), this.myRuleBlock.getEngineType()}));
            }
            case 16: 
            case 17: 
            case 18: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsBooleanOperatorInConsequent", (Object[])new Object[]{AbleData.OperatorRl((int)n), this.myRuleBlock.getEngineType()}));
            }
            default: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnrecognizedOperator", (Object[])new Object[]{Integer.toString(n), this.myRuleBlock.getEngineType()}));
            }
        }
        if (this.myRuleSet.isInferenceTraceHigh() && n != 10) {
            this.myTracer.text(0x40000000000L, Able.NlsMsg((String)"Tr_Rule_ConsequentResult", (Object[])new Object[]{ableLhs.traceString(2), ableLhs.getStringValue()}));
        }
    }

    public final void setDebugLevel(int n) {
        this.myDebugLevel = n;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.myRuleSet.firePropertyChange(string, object, object2);
    }

    protected void fireEngineBreakpoint() throws AbleDataException {
        boolean bl = false;
        this.firePropertyChange("workingMemory", "old", "new");
        try {
            this.myRuleSet.invokeUserDefinedFunction("engineBreakpoint", new Object[]{this.myRuleSet});
            this.myRuleSet.notifyAbleEventListeners(new AbleEvent((Object)this.myRuleSet, (Object)this.myRuleSet.myInferenceContext, 5, false));
        }
        catch (AbleDataException ableDataException) {
            throw ableDataException;
        }
        catch (AbleException ableException) {
            throw new AbleDataException(ableException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = true;
        }
        catch (InvocationTargetException invocationTargetException) {
            bl = true;
        }
        catch (IllegalAccessException illegalAccessException) {
            bl = true;
        }
        if (bl) {
            this.myRuleSet.setDebugLevel(0);
            Able.MessageLog.message(4L, (Object)this, "fireEngineBreakpoint()", "Error can't invoke Debug lib, turning Debug off!");
            if (this.myTracer.isLogging()) {
                this.myTracer.text(262144L, (Object)this, "fireEngineBreakpoint()", "Error can't invoke Debug lib, turning Debug off!");
            }
        }
    }

    protected void startDebugConsole() {
        Throwable throwable = null;
        try {
            this.myRuleSet.invokeUserDefinedFunction("startDebugConsole", new Object[]{this.myRuleSet});
        }
        catch (AbleException ableException) {
            throwable = ableException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throwable = noSuchMethodException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throwable = illegalAccessException;
        }
        if (throwable != null) {
            this.myRuleSet.setDebugLevel(0);
            Able.MessageLog.message(4L, (Object)this, "startDebugConsole()", "Ex_RsStartDebugConsoleFailed", new Object[]{throwable.getLocalizedMessage()});
            if (this.myTracer.isLogging()) {
                this.myTracer.text(262144L, (Object)this, "startDebugConsole()", "Error can't invoke Debug lib, turning Debug off!");
                this.myTracer.exception(262144L, (Object)this, "startDebugConsole()", throwable);
            }
        }
    }

    protected void stopDebugConsole() {
        Throwable throwable = null;
        try {
            this.myRuleSet.invokeUserDefinedFunction("stopDebugConsole", new Object[]{this.myRuleSet});
        }
        catch (AbleException ableException) {
            throwable = ableException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throwable = noSuchMethodException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throwable = illegalAccessException;
        }
        if (throwable != null) {
            this.myRuleSet.setDebugLevel(0);
            if (this.myTracer.isLogging()) {
                this.myTracer.text(262144L, (Object)this, "stopDebugConsole()", "Error invoking Debug lib, turning Debug off!");
                this.myTracer.exception(262144L, (Object)this, "startDebugConsole()", throwable);
            }
        }
    }

    public void askUser(AbleVariable ableVariable) {
        Throwable throwable = null;
        try {
            if (this.myRuleSet.isImportedUserDefinedFunction("askUser/2")) {
                this.myRuleSet.invokeUserDefinedFunction("askUser", new Object[]{this.myRuleSet, ableVariable});
            } else if (this.myTracer.isLogging()) {
                this.myTracer.text(262144L, (Object)this, "askUser()", "askUser/2 not defined; can't request value for variable " + ableVariable);
            }
        }
        catch (AbleException ableException) {
            throwable = ableException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throwable = noSuchMethodException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throwable = illegalAccessException;
        }
        if (throwable != null) {
            Able.MessageLog.message(4L, (Object)this, "askUser()", "Ex_RsAskUserFailed", new Object[]{ableVariable, throwable.getLocalizedMessage()});
            if (this.myTracer.isLogging()) {
                this.myTracer.text(262144L, (Object)this, "askUser()", "Error can't invoke GUI lib to prompt for variable " + ableVariable);
                this.myTracer.exception(262144L, (Object)this, "startDebugConsole()", throwable);
            }
        }
    }

    public int getRulesFiredCount() {
        return this.myRulesFiredCount;
    }

    public void setWorkingMemory(AbleWorkingMemory ableWorkingMemory) {
        this.myWorkingMemory = ableWorkingMemory;
    }

    public final AbleWorkingMemory getWorkingMemory() {
        return this.myWorkingMemory;
    }

    public AbleWorkingMemory allocateWorkingMemory() {
        if (this.myWorkingMemory == null) {
            this.myWorkingMemory = new AbleObjectWorkingMemory(this.myRuleSet);
        }
        return this.myWorkingMemory;
    }

    public String toString() {
        return this.getClass().getName();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

