/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.data.AblePredicate;
import com.ibm.able.rules.AbleClause;
import com.ibm.able.rules.AbleLocation;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleSet;
import java.io.Serializable;

public class AbleInferenceContext
implements Serializable {
    static final long serialVersionUID = -4354122492440329943L;
    public AbleRuleSet ruleSet = null;
    public AbleRuleBlock ruleBlock = null;
    public AbleRule rule = null;
    public AbleClause clause = null;
    public AblePredicate predicate = null;
    public String errorMsg = null;
    public AbleLocation location = null;

    public AbleInferenceContext(AbleRuleSet ableRuleSet) {
        this.ruleSet = ableRuleSet;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(Able.NlsMsg((String)"Inf_RsContextTitle"));
        try {
            if (this.ruleSet != null) {
                stringBuffer.append(Able.NlsMsg((String)"Inf_RsContextRuleSet", (Object[])new Object[]{this.ruleSet.getName()}));
            }
            if (this.ruleBlock != null) {
                stringBuffer.append(Able.NlsMsg((String)"Inf_RsContextRuleBlock", (Object[])new Object[]{this.ruleBlock.getName()}));
            }
            if (this.rule != null) {
                stringBuffer.append("Line: " + this.getLine() + Able.LS);
                stringBuffer.append(Able.NlsMsg((String)"Inf_RsContextRule", (Object[])new Object[]{this.rule.getIdLabelString(), this.rule.traceString(2)}));
            }
            if (this.clause != null) {
                stringBuffer.append(Able.NlsMsg((String)"Inf_RsContextClause", (Object[])new Object[]{this.clause.traceString(2)}));
            }
            if (this.predicate != null) {
                stringBuffer.append(Able.NlsMsg((String)"Inf_RsContextPredicate", (Object[])new Object[]{this.predicate.traceString(2)}));
            }
            if (this.errorMsg != null) {
                stringBuffer.append(Able.NlsMsg((String)"Inf_RsContextErrorMsg", (Object[])new Object[]{this.errorMsg}));
            }
        }
        catch (Exception exception) {
            Able.MessageLog.text(4L, (Object)this, "toString()", exception.getLocalizedMessage());
        }
        stringBuffer.append(Able.LS);
        return stringBuffer.toString();
    }

    public String getStackFrame() {
        return "  at " + this.ruleSet.getName() + "." + this.ruleBlock.getName() + ".'" + this.rule.getLabel() + "':" + this.getLine() + Able.LS;
    }

    public void reset() {
        this.ruleBlock = null;
        this.rule = null;
        this.clause = null;
        this.predicate = null;
        this.errorMsg = null;
    }

    public void setRuleBlock(AbleRuleBlock ableRuleBlock) {
        this.ruleBlock = ableRuleBlock;
        this.rule = null;
        this.clause = null;
        this.predicate = null;
        this.errorMsg = null;
    }

    public void setRule(AbleRule ableRule) {
        this.rule = ableRule;
        this.clause = null;
        this.predicate = null;
        this.errorMsg = null;
    }

    public void setClause(AbleClause ableClause) {
        this.clause = ableClause;
        this.predicate = null;
        this.errorMsg = null;
    }

    public void setPredicate(AblePredicate ablePredicate) {
        this.predicate = ablePredicate;
        this.clause = null;
        this.errorMsg = null;
    }

    public AbleLocation getLocation() {
        if (this.clause != null) {
            return this.clause.getLocation();
        }
        if (this.rule != null) {
            return this.rule.getLocation();
        }
        return null;
    }

    public int getLine() {
        AbleLocation ableLocation;
        if (this.rule != null && (ableLocation = this.rule.getLocation()) != null) {
            return ableLocation.getLine();
        }
        return 0;
    }
}

