/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleRd;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleRule;
import java.io.Serializable;
import java.util.Vector;

public class AbleIfThenElseRule
extends AbleRule
implements Serializable {
    static final long serialVersionUID = 2001011800000000001L;
    static String clsNm = "AbleIfThenElseRule";
    protected AbleExpression myAntecedent;
    protected Vector myThenList = new Vector();
    protected Vector myElseList = new Vector();

    public AbleIfThenElseRule(String string, AbleRd ableRd, AbleExpression ableExpression, Vector vector, Vector vector2) {
        super(0, string, ableRd, null);
        this.myAntecedent = ableExpression;
        this.myThenList = (Vector)vector.clone();
        this.myElseList = (Vector)vector2.clone();
        this.ctorHelperSaveReferences();
    }

    private void ctorHelperSaveReferences() {
        AbleConsequentClause ableConsequentClause;
        int n;
        this.addRdReferences(this.myAntecedent.getReferents());
        if (!this.myThenList.isEmpty()) {
            for (n = 0; n < this.myThenList.size(); ++n) {
                ableConsequentClause = (AbleConsequentClause)this.myThenList.elementAt(n);
                ableConsequentClause.addRuleRef(this);
                this.addRdReferences(ableConsequentClause.getReferents());
                this.addWrReference(ableConsequentClause.getLhsReferent());
            }
        }
        if (!this.myElseList.isEmpty()) {
            for (n = 0; n < this.myElseList.size(); ++n) {
                ableConsequentClause = (AbleConsequentClause)this.myElseList.elementAt(n);
                ableConsequentClause.addRuleRef(this);
                this.addRdReferences(ableConsequentClause.getReferents());
                this.addWrReference(ableConsequentClause.getLhsReferent());
            }
        }
        this.addHeaderRdReferences();
    }

    public void addThenAction(AbleConsequentClause ableConsequentClause) {
        this.myThenList.add(ableConsequentClause);
    }

    public void setThenActions(Vector vector) {
        this.myThenList = vector;
    }

    public void addElseAction(AbleConsequentClause ableConsequentClause) {
        this.myElseList.add(ableConsequentClause);
    }

    public final AbleExpression getAntecedent() {
        return this.myAntecedent;
    }

    public long numberOfAntecedents() {
        return 1L;
    }

    public final Vector getThenClauses() {
        return this.myThenList;
    }

    public long numberOfThenClauses() {
        long l = 0L;
        if (this.myThenList != null) {
            l = this.myThenList.size();
        }
        return l;
    }

    public final Vector getElseClauses() {
        return this.myElseList;
    }

    public long numberOfElseClauses() {
        long l = 0L;
        if (this.myElseList != null) {
            l = this.myElseList.size();
        }
        return l;
    }

    public void reset() {
        this.myFiredFlag = false;
    }

    public String arlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "    " + this.myLabel;
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        if (this.myPriority == PriorityDefault) {
            stringBuffer3.append(": ");
        } else {
            stringBuffer3.append("[" + this.myPriority.arlCRdString() + "]: ");
        }
        stringBuffer2.append("      ");
        if (this.myComment.length() > 0 || !this.myProperties.isEmpty()) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        if (this.isTemplate()) {
            stringBuffer.append("template ");
        }
        stringBuffer.append(string);
        stringBuffer.append(this.arlPreConditionsString());
        stringBuffer.append(stringBuffer3.toString() + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "if (");
        stringBuffer.append(this.myAntecedent.arlCRdString());
        stringBuffer.append(")" + Able.LS);
        if (this.myThenList.size() == 1) {
            stringBuffer.append(stringBuffer2.toString() + "then ");
            stringBuffer.append(AbleIfThenElseRule.arlActionBlockString(" ", this.myThenList));
        } else {
            stringBuffer.append(stringBuffer2.toString() + "then { " + Able.LS);
            stringBuffer.append(AbleIfThenElseRule.arlActionBlockString(stringBuffer2.toString() + "    ", this.myThenList));
        }
        if (this.myThenList.size() > 1) {
            stringBuffer.append(stringBuffer2.toString() + "}");
        }
        if (!this.myElseList.isEmpty()) {
            if (this.myElseList.size() == 1) {
                stringBuffer.append(stringBuffer2.toString() + "else ");
                stringBuffer.append(AbleIfThenElseRule.arlActionBlockString(" ", this.myElseList));
            } else {
                stringBuffer.append(stringBuffer2.toString() + "else {" + Able.LS);
                stringBuffer.append(AbleIfThenElseRule.arlActionBlockString(stringBuffer2.toString() + "    ", this.myElseList));
            }
            if (this.myElseList.size() > 1) {
                stringBuffer.append(stringBuffer2.toString() + "}");
            }
        }
        return stringBuffer.toString();
    }

    public String xmlString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        stringBuffer.append("    <rule" + string + string2 + string3 + ">" + Able.LS);
        stringBuffer.append(this.xmlPreConditionsString());
        stringBuffer.append(this.xmlPriorityString());
        stringBuffer.append("      <if>" + Able.LS);
        stringBuffer.append("      <antecedent>" + Able.LS);
        stringBuffer.append(this.myAntecedent.xmlCRdString());
        stringBuffer.append("      </antecedent>" + Able.LS);
        stringBuffer.append("    </if>" + Able.LS);
        stringBuffer.append("    <then>" + Able.LS);
        for (n = 0; n < this.myThenList.size(); ++n) {
            stringBuffer.append("      <consequent>" + Able.LS);
            stringBuffer.append(((AbleConsequentClause)this.myThenList.elementAt(n)).xmlString());
            stringBuffer.append("      </consequent>" + Able.LS);
        }
        stringBuffer.append("    </then>" + Able.LS);
        stringBuffer.append("    <else>" + Able.LS);
        for (n = 0; n < this.myElseList.size(); ++n) {
            stringBuffer.append("      <consequent>" + Able.LS);
            stringBuffer.append(((AbleConsequentClause)this.myElseList.elementAt(n)).xmlString());
            stringBuffer.append("      </consequent>" + Able.LS);
        }
        stringBuffer.append("    </else>" + Able.LS);
        stringBuffer.append("     </rule>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        String string4 = this.myFinalFlag ? " final=\"true\"" : "";
        stringBuffer.append("    <IfThenElseRule" + string + string2 + string3 + string4 + ">" + Able.LS);
        stringBuffer.append(this.armlPreConditionsString());
        stringBuffer.append(this.armlPriorityString());
        stringBuffer.append(this.armlPropertiesString());
        stringBuffer.append("      <if>" + Able.LS);
        stringBuffer.append(this.myAntecedent.armlCRdString());
        stringBuffer.append("    </if>" + Able.LS);
        stringBuffer.append("    <then>" + Able.LS);
        for (n = 0; n < this.myThenList.size(); ++n) {
            stringBuffer.append(((AbleConsequentClause)this.myThenList.elementAt(n)).armlString());
        }
        stringBuffer.append("    </then>" + Able.LS);
        stringBuffer.append("    <else>" + Able.LS);
        for (n = 0; n < this.myElseList.size(); ++n) {
            stringBuffer.append(((AbleConsequentClause)this.myElseList.elementAt(n)).armlString());
        }
        stringBuffer.append("    </else>" + Able.LS);
        stringBuffer.append("     </IfThenElseRule>" + Able.LS);
        return stringBuffer.toString();
    }

    public String getTemplateString(Vector vector) throws AbleDataException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer("");
        stringBuffer.append(this.getTemplateHeaderString(vector));
        stringBuffer2.append("      ");
        stringBuffer.append("if (");
        stringBuffer.append(this.myAntecedent.getTemplateString(vector));
        stringBuffer.append(")" + Able.LS);
        if (this.myThenList.size() == 1) {
            stringBuffer.append(stringBuffer2.toString() + "then ");
            stringBuffer.append(AbleIfThenElseRule.getTemplateActionBlockString(vector, " ", this.myThenList));
        } else {
            stringBuffer.append(stringBuffer2.toString() + "then '{' " + Able.LS);
            stringBuffer.append(AbleIfThenElseRule.getTemplateActionBlockString(vector, stringBuffer2.toString() + "    ", this.myThenList));
        }
        if (this.myThenList.size() > 1) {
            stringBuffer.append(stringBuffer2.toString() + "'}'");
        }
        if (!this.myElseList.isEmpty()) {
            if (this.myElseList.size() == 1) {
                stringBuffer.append(stringBuffer2.toString() + "else ");
                stringBuffer.append(AbleIfThenElseRule.getTemplateActionBlockString(vector, " ", this.myElseList));
            } else {
                stringBuffer.append(stringBuffer2.toString() + "else '{'" + Able.LS);
                stringBuffer.append(AbleIfThenElseRule.getTemplateActionBlockString(vector, stringBuffer2.toString() + "    ", this.myElseList));
            }
            if (this.myElseList.size() > 1) {
                stringBuffer.append(stringBuffer2.toString() + "'}'");
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.arlString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlString();
            }
            case 4: {
                return this.arlString();
            }
            case 5: {
                return this.xmlString();
            }
        }
        return this.arlString();
    }

    private String trcString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "    " + this.myLabel;
        int n3 = this.myLabel.length();
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer2.append(" ");
        }
        if (this.myPriority == PriorityDefault) {
            stringBuffer3.append(": ");
        } else {
            stringBuffer3.append("[" + this.myPriority.traceString(n) + "]: ");
        }
        for (n2 = 0; n2 < stringBuffer3.length(); ++n2) {
            stringBuffer2.append(" ");
        }
        stringBuffer.append(string + stringBuffer3.toString() + "if\n");
        stringBuffer.append(stringBuffer2.toString() + "    " + this.myAntecedent.traceString(n));
        stringBuffer.append(Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "  then\n");
        for (n2 = 0; n2 < this.myThenList.size(); ++n2) {
            stringBuffer.append(stringBuffer2.toString() + "    " + ((AbleConsequentClause)this.myThenList.elementAt(n2)).traceString(n) + Able.LS);
        }
        if (!this.myElseList.isEmpty()) {
            stringBuffer.append(stringBuffer2.toString() + "  else\n");
            for (n2 = 0; n2 < this.myElseList.size(); ++n2) {
                stringBuffer.append(stringBuffer2.toString() + "    " + ((AbleConsequentClause)this.myElseList.elementAt(n2)).traceString(n) + Able.LS);
            }
        }
        return stringBuffer.toString();
    }
}

