/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleLogger;
import com.ibm.able.AbleTraceMsg;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleFuzzyVariable;
import com.ibm.able.data.AbleLhs;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleAntecedentClause;
import com.ibm.able.rules.AbleAssertionClause;
import com.ibm.able.rules.AbleAssertionRule;
import com.ibm.able.rules.AbleConditionalRule;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleInferenceEngine;
import com.ibm.able.rules.AbleIterationRule;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleSet;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class AbleFuzzyInferenceEngine
extends AbleInferenceEngine
implements Serializable {
    static final long serialVersionUID = 2000083100000000001L;
    static String clsNm = "AbleFuzzyInferenceEngine";
    private BitSet myFactBase = new BitSet();
    protected int myFuzzyInferenceMethod = 0;
    protected double myAlphaCut = 0.1;
    protected int myCorrelationMethod = 1;
    protected int myDefuzzifyMethod = 1;

    public AbleFuzzyInferenceEngine(AbleRuleSet ableRuleSet, AbleLogger ableLogger, AbleRuleBlock ableRuleBlock) {
        super(ableRuleSet, ableLogger, ableRuleBlock);
    }

    public boolean isRuleBlockValid(AbleRuleBlock ableRuleBlock) {
        boolean bl = true;
        String string = null;
        Iterator iterator = null;
        AbleRule ableRule = null;
        AbleRuleBlock ableRuleBlock2 = ableRuleBlock;
        String string2 = ableRuleBlock2.getName();
        String string3 = ableRuleBlock2.getEngineType();
        iterator = ableRuleBlock2.getPatternMatchRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoPatternMatchRulesAllowed", (Object[])new Object[]{string3, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        if (!AbleFuzzyInferenceEngine.conditionalRulesValid(this.myRuleSet, ableRuleBlock2)) {
            bl = false;
        }
        iterator = ableRuleBlock2.getPredicateRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoPredicateRulesAllowed", (Object[])new Object[]{string3, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getIterationRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoIterationRulesAllowed", (Object[])new Object[]{string3, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getIfThenElseRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoIfThenElseRulesAllowed", (Object[])new Object[]{string3, string2, ableRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        return bl;
    }

    public void infer(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        this.myFactBase = this.myRuleSet.getCurrentFactBase();
        this.myFactBase.set(0);
        AbleRuleBlock ableRuleBlock2 = ableRuleBlock;
        ableRuleBlock2.reset();
        this.myRulesFiredCount = 0;
        Enumeration enumeration = this.myRuleSet.getVariables().elements();
        while (enumeration.hasMoreElements()) {
            AbleVariable ableVariable = (AbleVariable)enumeration.nextElement();
            if (!(ableVariable instanceof AbleFuzzyVariable)) continue;
            ((AbleFuzzyVariable)ableVariable).setAlphaCut(this.myAlphaCut);
            ((AbleFuzzyVariable)ableVariable).setDefuzzifyMethod(this.myDefuzzifyMethod);
        }
        if (ableRuleBlock2 != null) {
            this.processAssertions(ableRuleBlock2, this.myFactBase);
        }
        if (ableRuleBlock2 != null) {
            this.processConditionalRules(ableRuleBlock2, this.myFactBase);
        }
    }

    public void processRuleBlock(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        this.processRuleBlock(ableRuleBlock, this.myFactBase);
    }

    private void processAssertions(AbleRuleBlock ableRuleBlock, BitSet bitSet) throws AbleDataException {
        Vector vector = ableRuleBlock.getAssertions();
        this.myRuleSet.myInferenceContext.setRuleBlock(ableRuleBlock);
        if (this.myDebugLevel == 3) {
            this.fireEngineBreakpoint();
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "processAssertions()", "Tr_Rs_RuleBlockAssertionsStarts", new Object[]{ableRuleBlock.getName()});
        }
        for (int i = 0; i < vector.size(); ++i) {
            AbleAssertionRule ableAssertionRule = (AbleAssertionRule)vector.elementAt(i);
            this.evalAssertionRule(ableAssertionRule, bitSet);
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "processAssertions()", "Tr_Rs_RuleBlockAssertionsEnds", new Object[]{ableRuleBlock.getName()});
        }
    }

    private void processConditionalRules(AbleRuleBlock ableRuleBlock, BitSet bitSet) throws AbleDataException {
        boolean bl = true;
        Vector<AbleRule> vector = new Vector<AbleRule>();
        this.myRuleSet.myInferenceContext.setRuleBlock(ableRuleBlock);
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "infer()", "Tr_Rs_RuleBlockInferStarts", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType});
        }
        while (bl) {
            Serializable serializable;
            Enumeration enumeration = ableRuleBlock.getEnabledConditionalRules().elements();
            if (this.myRuleSet.isInferenceTraceMedium()) {
                this.myTracer.message(0x20000000000L, (Object)this, "processConditionalRules", "Tr_Rs_CreateRuleSet");
            }
            while (enumeration.hasMoreElements()) {
                AbleRule ableRule = (AbleRule)enumeration.nextElement();
                if (!ableRule.isFired()) {
                    serializable = ableRule.getRdReferences();
                    BitSet bitSet2 = ableRule.getRdReferences();
                    bitSet2.and(bitSet);
                    if (this.myRuleSet.isInferenceTraceHigh()) {
                        this.myTracer.message(0x40000000000L, (Object)this, "processConditionalRules", "Tr_Rs_RuleFacts", new Object[]{serializable, bitSet, bitSet2});
                    }
                    if (bitSet2.equals(serializable)) {
                        vector.addElement(ableRule);
                        if (!this.myRuleSet.isInferenceTraceHigh()) continue;
                        this.myTracer.message(0x40000000000L, (Object)this, "processConditionalRules", "Tr_Rs_RuleSetAdd", new Object[]{Integer.toString(ableRule.getId()), ableRule.getLabel()});
                        this.myTracer.message(0x40000000000L, (Object)this, "processConditionalRules", "Tr_Rs_RuleFacts", new Object[]{serializable, bitSet, bitSet2});
                        continue;
                    }
                    if (!this.myRuleSet.isInferenceTraceHigh()) continue;
                    this.myTracer.message(0x40000000000L, (Object)this, "processConditionalRules", "Tr_Rs_RuleSkippedAntecedentsUnknown", new Object[]{ableRule.getIdLabelString(), bitSet, serializable});
                    continue;
                }
                if (!this.myRuleSet.isInferenceTraceHigh()) continue;
                this.myTracer.message(0x40000000000L, (Object)this, "processConditionalRules", "Tr_Rs_RuleSkippedAlreadyFired", new Object[]{ableRule.getIdLabelString()});
            }
            if (vector.isEmpty()) {
                bl = false;
                if (!this.myRuleSet.isInferenceTraceLow()) break;
                this.myTracer.message(0x10000000000L, (Object)this, "processConditionalRules", "Tr_Rs_RuleSetEmpty");
                break;
            }
            if (this.myDebugLevel == 2) {
                this.fireEngineBreakpoint();
            }
            for (int i = 0; i < vector.size(); ++i) {
                serializable = (AbleRule)vector.elementAt(i);
                if (this.myRuleSet.isInferenceTraceMedium()) {
                    this.myTracer.message(0x20000000000L, (Object)this, "processConditionalRules", "Tr_Rs_ProcessConditionalStart", new Object[]{((AbleRule)serializable).getIdLabelString()});
                }
                if (serializable instanceof AbleConditionalRule) {
                    this.evalConditionalRule((AbleConditionalRule)serializable, bitSet);
                }
                if (!this.myRuleSet.isInferenceTraceHigh()) continue;
                this.myTracer.message(0x40000000000L, (Object)this, "processConditionalRules", "Tr_Rs_ProcessRuleEnd", new Object[]{((AbleRule)serializable).getIdLabelString()});
                this.myTracer.message(0x40000000000L, (Object)this, "processConditionalRules", "Tr_Rs_CurrentFactBase", new Object[]{bitSet});
            }
            vector.removeAllElements();
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "infer()", "Tr_Rs_RuleBlockInferEnds", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType});
        }
    }

    private void processRuleBlock(AbleRuleBlock ableRuleBlock, BitSet bitSet) throws AbleDataException {
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "processRuleBlock()", "Tr_Rs_RuleBlockInferStarts", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType});
        }
        this.myRuleSet.myInferenceContext.setRuleBlock(ableRuleBlock);
        if (this.myDebugLevel == 3) {
            this.fireEngineBreakpoint();
        }
        Vector vector = ableRuleBlock.getEnabledRules();
        for (int i = 0; i < vector.size(); ++i) {
            AbleRule ableRule = (AbleRule)vector.elementAt(i);
            if (ableRule instanceof AbleAssertionRule) {
                this.evalAssertionRule((AbleAssertionRule)ableRule, bitSet);
                continue;
            }
            if (ableRule instanceof AbleConditionalRule) {
                this.evalConditionalRule((AbleConditionalRule)ableRule, bitSet);
                continue;
            }
            throw new AbleDataException(Able.NlsMsg((String)"Ex_IeUnexpectedRuleType", (Object[])new Object[]{this.myRuleBlock.getEngineType(), ableRule.getIdLabelString()}));
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "processRuleBlock()", "Tr_Rs_RuleBlockInferEnds", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType});
        }
    }

    private void evalAssertionRule(AbleAssertionRule ableAssertionRule, BitSet bitSet) throws AbleDataException {
        AbleAssertionClause ableAssertionClause;
        this.myRuleSet.myInferenceContext.setRule(ableAssertionRule);
        if (this.myDebugLevel == 4) {
            this.fireEngineBreakpoint();
        }
        BitSet bitSet2 = ableAssertionRule.getWrReferences();
        String string = ableAssertionRule.getIdLabelString();
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "evalAssertionRule", "Tr_Rs_ProcessAssertionStart", new Object[]{string});
        }
        if ((ableAssertionClause = ableAssertionRule.getAssertion()) != null) {
            this.evalAssertionClause(ableAssertionClause);
            bitSet.or(bitSet2);
            ableAssertionRule.setFired(true);
        }
        if (this.myRuleSet.isInferenceTraceHigh()) {
            this.myTracer.message(0x40000000000L, (Object)this, "evalAssertionRule", "Tr_Rs_ProcessRuleEnd", new Object[]{string});
            this.myTracer.message(0x40000000000L, (Object)this, "evalAssertionRule", "Tr_Rs_CurrentFactBase", new Object[]{bitSet});
        }
    }

    private void evalConditionalRule(AbleConditionalRule ableConditionalRule, BitSet bitSet) throws AbleDataException {
        Vector vector = ableConditionalRule.getAntecedents();
        BitSet bitSet2 = ableConditionalRule.getWrReferences();
        this.myRuleSet.myInferenceContext.setRule(ableConditionalRule);
        if (this.myDebugLevel == 4) {
            this.fireEngineBreakpoint();
        }
        double d = 1.0;
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            double d2 = this.evalFuzzyAntecedentClause((AbleAntecedentClause)vector.elementAt(i));
            if (this.myRuleSet.isInferenceTraceMedium()) {
                this.myTracer.message(0x20000000000L, (Object)this, "evalConditionalRule", "Tr_Rule_EvaluatedAntClause", new Object[]{Integer.toString(i), Double.toString(d2)});
            }
            ableConditionalRule.setFired(true);
            if (d2 <= this.myAlphaCut) {
                bl = true;
                if (!this.myRuleSet.isInferenceTraceMedium()) break;
                this.myTracer.message(0x20000000000L, (Object)this, "evalConditionalRule", "Tr_Rule_EvaluatedAntStop", new Object[]{Integer.toString(i), Double.toString(d2), Double.toString(this.myAlphaCut)});
                break;
            }
            if (!(d2 < d)) continue;
            d = d2;
        }
        if (!bl) {
            if (this.myRuleSet.isInferenceTraceHigh()) {
                this.myTracer.message(0x40000000000L, (Object)this, "evalConditionalRule", "Tr_Rs_EvaluatingConsequents");
            }
            Vector vector2 = ableConditionalRule.getThenClauses();
            for (int i = 0; i < vector2.size(); ++i) {
                AbleConsequentClause ableConsequentClause = (AbleConsequentClause)vector2.elementAt(i);
                this.evalConsequentClause(ableConsequentClause, d);
                bitSet.or(bitSet2);
            }
        }
    }

    protected void evaluateDoActions(AbleRule ableRule, BitSet bitSet, double d) throws AbleDataException {
        BitSet bitSet2 = ableRule.getWrReferences();
        Vector vector = ((AbleIterationRule)((Object)ableRule)).getDoActions();
        for (int i = 0; i < vector.size(); ++i) {
            AbleConsequentClause ableConsequentClause = (AbleConsequentClause)vector.elementAt(i);
            if (ableConsequentClause == null) continue;
            this.evalConsequentClause(ableConsequentClause, d);
            bitSet.or(bitSet2);
        }
    }

    protected void evalAssertionClause(AbleAssertionClause ableAssertionClause) throws AbleDataException {
        this.myRuleSet.myInferenceContext.setClause(ableAssertionClause);
        if (this.myDebugLevel >= 5) {
            this.fireEngineBreakpoint();
        }
        AbleLhs ableLhs = null;
        int n = ableAssertionClause.getOp();
        AbleRd ableRd = ableAssertionClause.getRhs();
        if (n != 10) {
            ableLhs = (AbleLhs)ableAssertionClause.getLhs();
        }
        if (ableRd instanceof AbleExpression) {
            ableRd = ableRd.getValue();
        }
        switch (n) {
            case 1: {
                ableLhs.asgnEq(ableRd);
                break;
            }
            case 2: {
                ableLhs.asgnIs(ableRd);
                break;
            }
            case 10: {
                ableRd.getValue();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsInvalidOperatorForAssertion", (Object[])new Object[]{AbleData.OperatorRl((int)n), this.myRuleBlock.getEngineType()}));
            }
            default: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnrecognizedOperator", (Object[])new Object[]{Integer.toString(n), this.myRuleBlock.getEngineType()}));
            }
        }
    }

    private double evalFuzzyAntecedentClause(AbleAntecedentClause ableAntecedentClause) throws AbleDataException {
        double d = 0.0;
        this.myRuleSet.myInferenceContext.setClause(ableAntecedentClause);
        if (this.myDebugLevel >= 5) {
            this.fireEngineBreakpoint();
        }
        AbleRd ableRd = ableAntecedentClause.getLhs();
        int n = ableAntecedentClause.getOp();
        AbleRd ableRd2 = ableAntecedentClause.getRhs();
        double d2 = ableAntecedentClause.getClauseWeight();
        while (ableRd instanceof AbleExpression) {
            ableRd = ableRd.getValue();
        }
        while (ableRd2 instanceof AbleExpression) {
            ableRd2 = ableRd2.getValue();
        }
        switch (n) {
            case 3: {
                if (!ableRd.cmpEq(ableRd2)) break;
                d = d2;
                break;
            }
            case 4: {
                if (!ableRd.cmpGt(ableRd2)) break;
                d = d2;
                break;
            }
            case 5: {
                if (!ableRd.cmpGtEq(ableRd2)) break;
                d = d2;
                break;
            }
            case 7: {
                if (!ableRd.cmpLt(ableRd2)) break;
                d = d2;
                break;
            }
            case 8: {
                if (!ableRd.cmpLtEq(ableRd2)) break;
                d = d2;
                break;
            }
            case 9: {
                if (!ableRd.cmpNeq(ableRd2)) break;
                d = d2;
                break;
            }
            case 6: {
                d = ableRd.cmpIs(ableRd2);
                break;
            }
            case 10: {
                d = ableRd2.getNumericValue();
                break;
            }
            case 1: 
            case 2: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsAssignmentInAntecedant", (Object[])new Object[]{AbleData.OperatorRl((int)n), this.myRuleBlock.getEngineType()}));
            }
            case 16: {
                if (ableRd.logicalAND(ableRd2)) {
                    d = d2;
                    break;
                }
                d = 0.0;
                break;
            }
            case 17: {
                if (ableRd.logicalOR(ableRd2)) {
                    d = d2;
                    break;
                }
                d = 0.0;
                break;
            }
            default: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnrecognizedOperator", (Object[])new Object[]{Integer.toString(n), this.myRuleBlock.getEngineType()}));
            }
        }
        return d;
    }

    private void evalConsequentClause(AbleConsequentClause ableConsequentClause, double d) throws AbleDataException {
        this.myRuleSet.myInferenceContext.setClause(ableConsequentClause);
        if (this.myDebugLevel >= 5) {
            this.fireEngineBreakpoint();
        }
        AbleLhs ableLhs = null;
        int n = ableConsequentClause.getOp();
        AbleRd ableRd = ableConsequentClause.getRhs();
        if (ableRd instanceof AbleExpression) {
            ableRd = ableRd.getValue();
        }
        if (n != 10) {
            ableLhs = (AbleLhs)ableConsequentClause.getLhs();
        }
        switch (n) {
            case 1: {
                ableLhs.asgnEq(ableRd);
                break;
            }
            case 2: {
                ableLhs.asgnIs(ableRd, d);
                break;
            }
            case 10: {
                ableRd.getValue();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsComparisonInConsequent", (Object[])new Object[]{AbleData.OperatorRl((int)n), this.myRuleBlock.getEngineType()}));
            }
            default: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnrecognizedOperator", (Object[])new Object[]{Integer.toString(n), this.myRuleBlock.getEngineType()}));
            }
        }
        if (this.myRuleSet.isInferenceTraceHigh() && n != 10) {
            this.myTracer.message(0x40000000000L, (Object)this, "evalConsequentClause", "Tr_Rule_ConsequentResult", new Object[]{ableLhs.traceString(2), ableLhs.getStringValue()});
        }
    }

    public void setControlParameter(String string, Object object) throws AbleDataException {
        if (string.equalsIgnoreCase("InferenceMethod")) {
            int n = 0;
            if (object instanceof Integer) {
                n = (Integer)object;
                this.setFuzzyInferenceMethod(n);
            } else if (object instanceof Double) {
                n = (int)((Double)object).doubleValue();
            }
            this.setFuzzyInferenceMethod(n);
        } else if (string.equalsIgnoreCase("AlphaCut")) {
            double d;
            if (object instanceof Integer) {
                d = ((Integer)object).intValue();
                this.setAlphaCut(d);
            }
            if (object instanceof Double) {
                d = (Double)object;
                this.setAlphaCut(d);
            }
        } else if (string.equalsIgnoreCase("CorrelationMethod")) {
            int n;
            if (object instanceof Integer) {
                n = (Integer)object;
                this.setCorrelationMethod(n);
            }
            if (object instanceof Double) {
                n = (int)((Double)object).doubleValue();
                this.setCorrelationMethod(n);
            }
        } else if (string.equalsIgnoreCase("DefuzzifyMethod")) {
            int n;
            if (object instanceof Integer) {
                n = (Integer)object;
                this.setDefuzzifyMethod(n);
            }
            if (object instanceof Double) {
                n = (int)((Double)object).doubleValue();
                this.setDefuzzifyMethod(n);
            }
        } else {
            throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnsupportedControlParameter", (Object[])new Object[]{clsNm, string}));
        }
    }

    public Object getControlParameter(String string) throws AbleDataException {
        if (string.equalsIgnoreCase("InferenceMethod")) {
            return new Integer(this.myFuzzyInferenceMethod);
        }
        if (string.equalsIgnoreCase("AlphaCut")) {
            return new Double(this.myAlphaCut);
        }
        if (string.equalsIgnoreCase("CorrelationMethod")) {
            return new Integer(this.myCorrelationMethod);
        }
        if (string.equalsIgnoreCase("DefuzzifyMethod")) {
            return new Integer(this.myDefuzzifyMethod);
        }
        throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnsupportedControlParameter", (Object[])new Object[]{clsNm, string}));
    }

    public final double getAlphaCut() {
        return this.myAlphaCut;
    }

    public void setAlphaCut(double d) throws AbleDataException {
        double d2 = this.myAlphaCut;
        if (d > 0.0 && d < 1.0) {
            this.myAlphaCut = d;
            Vector vector = this.myRuleSet.getFuzzyVariables();
            for (int i = 0; i < vector.size(); ++i) {
                AbleFuzzyVariable ableFuzzyVariable = (AbleFuzzyVariable)vector.get(i);
                ableFuzzyVariable.setAlphaCut(this.myAlphaCut);
            }
            this.myRuleSet.myChgSupport.firePropertyChange("AlphaCut", new Double(d2), new Double(d));
            if (this.myRuleSet.isBaseTraceHigh()) {
                this.myTracer.text(0x100000L, AbleTraceMsg.msg((String)"Tr_Rs_SetAlphaCut", (Object[])new Object[]{Double.toString(d)}));
            }
        } else {
            throw new AbleDataException(Able.NlsMsg((String)"Ex_OutOfRangeAlphaCut", (Object[])new Object[]{Double.toString(d)}));
        }
    }

    public final int getCorrelationMethod() {
        return this.myCorrelationMethod;
    }

    public void setCorrelationMethod(int n) throws AbleDataException {
        int n2 = this.myCorrelationMethod;
        switch (n) {
            case 1: 
            case 2: {
                this.myCorrelationMethod = n;
                this.myRuleSet.myChgSupport.firePropertyChange("CorrelationMethod", new Integer(n2), new Integer(n));
                if (!this.myRuleSet.isBaseTraceHigh()) break;
                this.myTracer.text(0x100000L, AbleTraceMsg.msg((String)"Tr_Rs_SetCorrMethod", (Object[])new Object[]{AbleFuzzySet.CorrelationMethod((int)n)}));
                break;
            }
            default: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnrecognizedCorrMethod", (Object[])new Object[]{AbleFuzzySet.CorrelationMethod((int)n)}));
            }
        }
    }

    public final int getDefuzzifyMethod() {
        return this.myDefuzzifyMethod;
    }

    public void setDefuzzifyMethod(int n) throws AbleDataException {
        int n2 = this.myDefuzzifyMethod;
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                this.myDefuzzifyMethod = n;
                this.myRuleSet.myChgSupport.firePropertyChange("DefuzzifyMethod", new Integer(n2), new Integer(n));
                if (!this.myRuleSet.isBaseTraceHigh()) break;
                this.myTracer.text(0x100000L, AbleTraceMsg.msg((String)"Tr_Rs_SetDefuzzMethod", (Object[])new Object[]{AbleFuzzySet.DefuzzifyMethod((int)n)}));
                break;
            }
            default: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnrecognizedDefuzzMethod", (Object[])new Object[]{AbleFuzzySet.DefuzzifyMethod((int)n)}));
            }
        }
    }

    public void setFuzzyInferenceMethod(int n) throws AbleDataException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.myFuzzyInferenceMethod = n;
                break;
            }
            default: {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnrecognizedInferMethod", (Object[])new Object[]{AbleFuzzySet.FuzzyInferenceMethod((int)n)}));
            }
        }
    }

    public final int getFuzzyInferenceMethod() {
        return this.myFuzzyInferenceMethod;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

