/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleLogger;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleAntecedentClause;
import com.ibm.able.rules.AbleClauseReferences;
import com.ibm.able.rules.AbleConditionalRule;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleInferenceEngine;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleBreakpoint;
import com.ibm.able.rules.AbleRuleSet;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class AbleForwardChainInferenceEngine
extends AbleInferenceEngine
implements Serializable {
    static final long serialVersionUID = 2000083100000000001L;
    static String clsNm = "AbleForwardChainInferenceEngine";
    public static final int FIRE_ALL_RULES = 0;
    public static final int FIRE_ONE_RULE = 1;
    public static final int FIRE_N_RULES = 2;
    private BitSet myFactBase = new BitSet();
    protected int myControlStrategy = 0;
    protected int myNumberOfRulesToFire = 0;

    public AbleForwardChainInferenceEngine(AbleRuleSet ableRuleSet, AbleLogger ableLogger) {
        super(ableRuleSet, ableLogger);
    }

    public AbleForwardChainInferenceEngine(AbleRuleSet ableRuleSet, AbleLogger ableLogger, AbleRuleBlock ableRuleBlock) {
        super(ableRuleSet, ableLogger, ableRuleBlock);
    }

    public boolean isRuleBlockValid(AbleRuleBlock ableRuleBlock) {
        boolean bl = true;
        String string = null;
        Iterator iterator = null;
        AbleRule ableRule = null;
        AbleRuleBlock ableRuleBlock2 = ableRuleBlock;
        String string2 = ableRuleBlock2.getName();
        String string3 = ableRuleBlock2.getEngineType();
        if (!AbleForwardChainInferenceEngine.conditionalRulesValid(this.myRuleSet, ableRuleBlock2)) {
            bl = false;
        }
        iterator = ableRuleBlock2.getPatternMatchRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoPatternMatchRulesAllowed", (Object[])new Object[]{string3, string2, ableRule.getIdLabelString()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getPredicateRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoPredicateRulesAllowed", (Object[])new Object[]{string3, string2, ableRule.getIdLabelString()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getIterationRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoIterationRulesAllowed", (Object[])new Object[]{string3, string2, ableRule.getIdLabelString()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getIfThenElseRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoIfThenElseRulesAllowed", (Object[])new Object[]{string3, string2, ableRule.getIdLabelString()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        return bl;
    }

    public void infer(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        AbleRuleBlock ableRuleBlock2 = ableRuleBlock;
        ableRuleBlock2.reset();
        this.myRulesFiredCount = 0;
        this.myWorkingMemory = this.myRuleSet.getWorkingMemory();
        if (ableRuleBlock2 != null) {
            this.processAssertions(ableRuleBlock2);
        }
        if (ableRuleBlock2 != null) {
            switch (this.myControlStrategy) {
                case 0: {
                    this.forwardChain(ableRuleBlock2);
                    break;
                }
                case 1: {
                    this.fireNTriggeredRules(ableRuleBlock2, 1);
                    break;
                }
                case 2: {
                    this.fireNTriggeredRules(ableRuleBlock2, this.myNumberOfRulesToFire);
                }
            }
        }
    }

    private void updateClauses() throws AbleDataException {
        BitSet bitSet = this.myRuleSet.getCurrentFactBase();
        bitSet.xor(this.myFactBase);
        Vector vector = this.myRuleSet.getVariables(bitSet);
        for (int i = 0; i < vector.size(); ++i) {
            AbleVariable ableVariable = (AbleVariable)vector.get(i);
            this.reevaluateClausesWithChangedVariable((AbleClauseReferences)ableVariable.getReferences());
        }
        this.myFactBase = this.myRuleSet.getCurrentFactBase();
    }

    protected void reevaluateClausesWithChangedVariable(AbleClauseReferences ableClauseReferences) throws AbleDataException {
        for (int i = 0; i < ableClauseReferences.size(); ++i) {
            Object object = ableClauseReferences.elementAt(i);
            if (!(object instanceof AbleAntecedentClause)) continue;
            this.myRuleSet.myInferenceContext.setClause((AbleAntecedentClause)object);
            AbleForwardChainInferenceEngine.evalAntecedentClause((AbleAntecedentClause)object);
        }
    }

    private void forwardChain(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        Vector vector = new Vector();
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "forwardChain()", "Tr_Rs_RuleBlockInferStarts", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType});
        }
        this.myRuleSet.myInferenceContext.setRuleBlock(ableRuleBlock);
        if (this.myDebugLevel == 3) {
            this.fireEngineBreakpoint();
        }
        vector = this.match(ableRuleBlock, true);
        while (vector.size() > 0) {
            Serializable serializable;
            AbleConditionalRule ableConditionalRule = this.selectRule(vector);
            this.myRuleSet.myInferenceContext.rule = ableConditionalRule;
            if (this.myDebugLevel == 4) {
                this.fireEngineBreakpoint();
            }
            if (this.myDebugLevel == 1 && (serializable = ableConditionalRule.getBreakpoint()) != null && ((AbleRuleBreakpoint)serializable).isEnabled()) {
                this.fireEngineBreakpoint();
            }
            this.processConsequent(ableConditionalRule);
            ++this.myRulesFiredCount;
            this.updateClauses();
            serializable = ableConditionalRule.getThenClauses();
            for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                AbleConsequentClause ableConsequentClause = (AbleConsequentClause)((Vector)serializable).get(i);
                AbleRd ableRd = ableConsequentClause.getLhs();
                if (!(ableRd instanceof AbleVariable)) continue;
                this.checkRules((Vector)((AbleVariable)ableRd).getReferences());
            }
            vector = this.match(ableRuleBlock, false);
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "forwardChain()", "Tr_Rs_RuleBlockInferEnds", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType});
        }
    }

    private Vector match(AbleRuleBlock ableRuleBlock, boolean bl) throws AbleDataException {
        Vector vector = new Vector();
        Enumeration enumeration = ableRuleBlock.getEnabledConditionalRules().elements();
        Boolean bl2 = null;
        while (enumeration.hasMoreElements()) {
            AbleConditionalRule ableConditionalRule = (AbleConditionalRule)enumeration.nextElement();
            if (bl) {
                this.checkRuleAntecedents(ableConditionalRule);
            }
            if ((bl2 = ableConditionalRule.getBooleanTruth()) == null || !bl2.booleanValue() || ableConditionalRule.isFired()) continue;
            this.addRuleToConflictSet(vector, ableConditionalRule);
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.logConflictSet(vector);
        }
        return vector;
    }

    private void fireNTriggeredRules(AbleRuleBlock ableRuleBlock, int n) throws AbleDataException {
        Vector vector = new Vector();
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "fireNTriggeredRules()", "Tr_Rs_FireNTriggeredRules", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType, Integer.toString(n)});
        }
        this.myRuleSet.myInferenceContext.ruleBlock = ableRuleBlock;
        if (this.myDebugLevel == 3) {
            this.fireEngineBreakpoint();
        }
        vector = this.matchFirstN(ableRuleBlock, n);
        for (int i = 0; i < vector.size(); ++i) {
            AbleConditionalRule ableConditionalRule = (AbleConditionalRule)vector.get(i);
            this.myRuleSet.myInferenceContext.setRule(ableConditionalRule);
            if (this.myDebugLevel == 4) {
                this.fireEngineBreakpoint();
            }
            this.processConsequent(ableConditionalRule);
            ++this.myRulesFiredCount;
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "forwardChain()", "Tr_Rs_RuleBlockInferEnds", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType});
        }
    }

    private Vector matchFirstN(AbleRuleBlock ableRuleBlock, int n) throws AbleDataException {
        Vector<AbleConditionalRule> vector = new Vector<AbleConditionalRule>();
        Enumeration enumeration = ableRuleBlock.getEnabledConditionalRules().elements();
        Boolean bl = null;
        while (enumeration.hasMoreElements()) {
            AbleConditionalRule ableConditionalRule = (AbleConditionalRule)enumeration.nextElement();
            this.checkRuleAntecedents(ableConditionalRule);
            bl = ableConditionalRule.getBooleanTruth();
            if (bl == null || !bl.booleanValue() || ableConditionalRule.isFired()) continue;
            vector.addElement(ableConditionalRule);
            if (vector.size() < n) continue;
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.logConflictSet(vector);
        }
        return vector;
    }

    private AbleConditionalRule selectRule(Vector vector) {
        AbleConditionalRule ableConditionalRule = null;
        ableConditionalRule = (AbleConditionalRule)vector.elementAt(0);
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "selectRule", "Tr_Rs_SelectRuleToFire", new Object[]{ableConditionalRule.getIdLabelString()});
        }
        return ableConditionalRule;
    }

    public void addRuleToConflictSet(Vector vector, AbleRule ableRule) throws AbleDataException {
        double d = ableRule.getPriority();
        long l = ((AbleConditionalRule)ableRule).numberOfAntecedents();
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            AbleConditionalRule ableConditionalRule = (AbleConditionalRule)vector.elementAt(i);
            if (d > ableConditionalRule.getPriority()) {
                vector.insertElementAt(ableRule, i);
                bl = true;
                break;
            }
            if (d != ableConditionalRule.getPriority() || l <= ableConditionalRule.numberOfAntecedents()) continue;
            vector.insertElementAt(ableRule, i);
            bl = true;
            break;
        }
        if (!bl) {
            vector.addElement(ableRule);
        }
    }

    private void checkRules(Vector vector) throws AbleDataException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof AbleAntecedentClause)) continue;
            AbleAntecedentClause ableAntecedentClause = (AbleAntecedentClause)e;
            Vector vector2 = ableAntecedentClause.getRuleRefs();
            for (int i = 0; i < vector2.size(); ++i) {
                this.checkRuleAntecedents((AbleConditionalRule)vector2.elementAt(i));
            }
        }
    }

    private Boolean checkRuleAntecedents(AbleConditionalRule ableConditionalRule) throws AbleDataException {
        Boolean bl = null;
        this.myRuleSet.myInferenceContext.setRule(ableConditionalRule);
        Vector vector = ableConditionalRule.getAntecedents();
        for (int i = 0; i < vector.size(); ++i) {
            AbleAntecedentClause ableAntecedentClause = (AbleAntecedentClause)vector.elementAt(i);
            this.myRuleSet.myInferenceContext.setClause(ableAntecedentClause);
            bl = AbleForwardChainInferenceEngine.evalAntecedentClause(ableAntecedentClause);
            if (bl == null) {
                if (this.myRuleSet.isInferenceTraceMedium()) {
                    this.myTracer.message(0x20000000000L, (Object)this, "checkRuleAntecedents()", "Tr_Rs_AntecedentNull", new Object[]{ableConditionalRule.getIdLabelString()});
                }
                ableConditionalRule.setBooleanTruth(bl);
                return bl;
            }
            if (bl.booleanValue()) continue;
            if (this.myRuleSet.isInferenceTraceMedium()) {
                this.myTracer.message(0x20000000000L, (Object)this, "checkRuleAntecedents", "Tr_Rs_AntecedentFalse", new Object[]{ableConditionalRule.getIdLabelString()});
            }
            ableConditionalRule.setBooleanTruth(bl);
            return bl;
        }
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "checkRuleAntecedents", "Tr_Rs_AntecedentTrue", new Object[]{ableConditionalRule.getIdLabelString()});
        }
        ableConditionalRule.setBooleanTruth(bl);
        return bl;
    }

    protected void logConflictSet(Vector vector) {
        AbleRule ableRule = null;
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < vector.size(); ++i) {
            ableRule = (AbleRule)vector.elementAt(i);
            if (i == 0) {
                stringBuffer.append(ableRule.getIdLabelString());
                continue;
            }
            stringBuffer.append(Able.LS + ableRule.getIdLabelString());
        }
        this.myTracer.message(0x20000000000L, (Object)this, "logConflictSet", "Tr_Rs_ConflictSetContents", new Object[]{Integer.toString(vector.size()), stringBuffer.toString()});
    }

    public void setControlParameter(String string, Object object) throws AbleDataException {
        if (string.equals("ControlStrategy")) {
            this.myControlStrategy = (Integer)object;
        } else if (string.equals("NumberOfRulesToFire")) {
            this.myNumberOfRulesToFire = (Integer)object;
        } else {
            throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnsupportedControlParameter", (Object[])new Object[]{this.myRuleBlock.getEngineType(), string}));
        }
    }

    public Object getControlParameter(String string) throws AbleDataException {
        if (string.equals("ControlStrategy")) {
            return new Integer(this.myControlStrategy);
        }
        if (string.equals("NumberOfRulesToFire")) {
            return new Integer(this.myNumberOfRulesToFire);
        }
        throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnsupportedControlParameter", (Object[])new Object[]{this.myRuleBlock.getEngineType(), string}));
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

