/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.data.AbleBooleanLiteral;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleRd;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleIterationRule;
import com.ibm.able.rules.AbleRule;
import java.io.Serializable;
import java.util.Vector;

public class AbleForLoopRule
extends AbleRule
implements AbleIterationRule,
Serializable {
    static final long serialVersionUID = 2001011800000000001L;
    static String clsNm = "AbleForLoopRule";
    protected Vector myInitialExpressionList;
    protected AbleExpression myTestExpression;
    protected Vector myIteratorExpressionList;
    protected Vector myConsequents;

    public AbleForLoopRule(String string, AbleRd ableRd, Vector vector, AbleExpression ableExpression, Vector vector2, Vector vector3) {
        super(0, string, ableRd, null);
        this.myInitialExpressionList = vector == null ? new Vector() : (Vector)vector.clone();
        this.myTestExpression = ableExpression == null ? new AbleExpression((AbleRd)AbleBooleanLiteral.TRUE, 3, (AbleRd)AbleBooleanLiteral.TRUE) : ableExpression;
        this.myIteratorExpressionList = vector2 == null ? new Vector() : (Vector)vector2.clone();
        this.myConsequents = (Vector)vector3.clone();
        this.ctorHelperSaveReferences();
    }

    private void ctorHelperSaveReferences() {
        int n;
        this.addHeaderRdReferences();
        for (n = 0; n < this.myInitialExpressionList.size(); ++n) {
            this.addRdReferences(((AbleExpression)this.myInitialExpressionList.get(n)).getReferents());
        }
        this.addRdReferences(this.myTestExpression.getReferents());
        for (n = 0; n < this.myIteratorExpressionList.size(); ++n) {
            this.addRdReferences(((AbleExpression)this.myIteratorExpressionList.get(n)).getReferents());
        }
    }

    public Vector getInitialExpressionList() {
        return this.myInitialExpressionList;
    }

    public AbleExpression getTestExpression() {
        return this.myTestExpression;
    }

    public Vector getIteratorExpressionList() {
        return this.myIteratorExpressionList;
    }

    public int getNumberOfDoActions() {
        int n = 0;
        if (this.myConsequents != null) {
            n = this.myConsequents.size();
        }
        return n;
    }

    public final Vector getDoActions() {
        return this.myConsequents;
    }

    public String arlString() {
        AbleExpression ableExpression;
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.myConsequents.size();
        String string = "    " + this.myLabel;
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        if (this.myPriority == PriorityDefault) {
            stringBuffer3.append(": ");
        } else {
            stringBuffer3.append("[" + this.myPriority.arlCRdString() + "]: ");
        }
        stringBuffer2.append("      ");
        if (this.myComment.length() > 0 || !this.myProperties.isEmpty()) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        if (this.isTemplate()) {
            stringBuffer.append("template ");
        }
        stringBuffer.append(string);
        stringBuffer.append(this.arlPreConditionsString());
        stringBuffer.append(stringBuffer3.toString() + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "for (");
        for (n = 0; n < this.myInitialExpressionList.size(); ++n) {
            ableExpression = (AbleExpression)this.myInitialExpressionList.get(n);
            if (n != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(ableExpression.arlCRdString());
        }
        stringBuffer.append("; ");
        stringBuffer.append(this.myTestExpression.arlCRdString() + "; ");
        for (n = 0; n < this.myIteratorExpressionList.size(); ++n) {
            ableExpression = (AbleExpression)this.myIteratorExpressionList.get(n);
            if (n != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(ableExpression.arlCRdString());
        }
        stringBuffer.append(")  {" + Able.LS);
        stringBuffer.append(AbleForLoopRule.arlActionBlockString(stringBuffer2.toString() + "  ", this.myConsequents));
        stringBuffer.append(stringBuffer2.toString() + "};" + Able.LS);
        return stringBuffer.toString();
    }

    public String xmlString() {
        AbleExpression ableExpression;
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.myConsequents.size();
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        stringBuffer.append("    <rule" + string + string2 + string3 + ">" + Able.LS);
        stringBuffer.append(this.xmlPreConditionsString());
        stringBuffer.append(this.xmlPriorityString());
        stringBuffer.append("    <for>" + Able.LS);
        stringBuffer.append("      <forInit>");
        for (n = 0; n < this.myInitialExpressionList.size(); ++n) {
            ableExpression = (AbleExpression)this.myInitialExpressionList.get(n);
            stringBuffer.append(ableExpression.xmlCRdString() + Able.LS);
        }
        stringBuffer.append("      </forInit>" + Able.LS);
        stringBuffer.append("      <forTest>");
        stringBuffer.append(this.myTestExpression.xmlCRdString() + Able.LS);
        stringBuffer.append("      </forTest>" + Able.LS);
        stringBuffer.append("      <forIter>");
        for (n = 0; n < this.myIteratorExpressionList.size(); ++n) {
            ableExpression = (AbleExpression)this.myIteratorExpressionList.get(n);
            stringBuffer.append(ableExpression.xmlCRdString() + Able.LS);
        }
        stringBuffer.append("      </forIter>" + Able.LS);
        stringBuffer.append("    <do_>" + Able.LS);
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("      <action_>" + Able.LS);
            stringBuffer.append(((AbleConsequentClause)this.myConsequents.elementAt(n)).xmlString() + Able.LS);
            stringBuffer.append("      </action_>" + Able.LS);
        }
        stringBuffer.append("    </do_>" + Able.LS);
        stringBuffer.append("    </for>" + Able.LS);
        stringBuffer.append("     </rule>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlString() {
        AbleExpression ableExpression;
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.myConsequents.size();
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        String string4 = this.myFinalFlag ? " final=\"true\"" : "";
        stringBuffer.append("    <ForLoopRule" + string + string2 + string3 + string4 + ">" + Able.LS);
        stringBuffer.append(this.armlPreConditionsString());
        stringBuffer.append(this.armlPriorityString());
        stringBuffer.append(this.armlPropertiesString());
        stringBuffer.append("      <forInit>");
        for (n = 0; n < this.myInitialExpressionList.size(); ++n) {
            ableExpression = (AbleExpression)this.myInitialExpressionList.get(n);
            stringBuffer.append(ableExpression.armlCRdString() + Able.LS);
        }
        stringBuffer.append("      </forInit>" + Able.LS);
        stringBuffer.append("      <forTest>");
        stringBuffer.append(this.myTestExpression.armlCRdString() + Able.LS);
        stringBuffer.append("      </forTest>" + Able.LS);
        stringBuffer.append("      <forIter>");
        for (n = 0; n < this.myIteratorExpressionList.size(); ++n) {
            ableExpression = (AbleExpression)this.myIteratorExpressionList.get(n);
            stringBuffer.append(ableExpression.armlCRdString() + Able.LS);
        }
        stringBuffer.append("      </forIter>" + Able.LS);
        stringBuffer.append("    <do>" + Able.LS);
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(((AbleConsequentClause)this.myConsequents.elementAt(n)).armlString());
        }
        stringBuffer.append("    </do>" + Able.LS);
        stringBuffer.append("     </ForLoopRule>" + Able.LS);
        return stringBuffer.toString();
    }

    public String getTemplateString(Vector vector) throws AbleDataException {
        AbleExpression ableExpression;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.myConsequents.size();
        StringBuffer stringBuffer2 = new StringBuffer("");
        stringBuffer2.append("      ");
        stringBuffer.append(this.getTemplateHeaderString(vector));
        stringBuffer.append(stringBuffer2.toString() + "for (");
        for (n = 0; n < this.myInitialExpressionList.size(); ++n) {
            ableExpression = (AbleExpression)this.myInitialExpressionList.get(n);
            if (n != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(ableExpression.getTemplateString(vector));
        }
        stringBuffer.append("; ");
        stringBuffer.append(this.myTestExpression.arlCRdString() + "; ");
        for (n = 0; n < this.myIteratorExpressionList.size(); ++n) {
            ableExpression = (AbleExpression)this.myIteratorExpressionList.get(n);
            if (n != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(ableExpression.getTemplateString(vector));
        }
        stringBuffer.append(")  '{'" + Able.LS);
        stringBuffer.append(AbleForLoopRule.getTemplateActionBlockString(vector, stringBuffer2.toString() + "  ", this.myConsequents));
        stringBuffer.append(stringBuffer2.toString() + "'}';" + Able.LS);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.arlString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlString();
            }
            case 4: {
                return this.arlString();
            }
            case 5: {
                return this.xmlString();
            }
        }
        return this.arlString();
    }

    private String trcString(int n) {
        AbleExpression ableExpression;
        int n2;
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "    " + this.myLabel;
        int n3 = this.myLabel.length();
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer2.append(" ");
        }
        if (this.myPriority == PriorityDefault) {
            stringBuffer3.append(": ");
        } else {
            stringBuffer3.append("[" + this.myPriority.traceString(n) + "]: ");
        }
        for (n2 = 0; n2 < stringBuffer3.length(); ++n2) {
            stringBuffer2.append(" ");
        }
        stringBuffer.append(string + stringBuffer3.toString() + "for (");
        for (n2 = 0; n2 < this.myInitialExpressionList.size(); ++n2) {
            ableExpression = (AbleExpression)this.myInitialExpressionList.get(n2);
            stringBuffer.append(ableExpression.toString() + ";");
        }
        stringBuffer.append(this.myTestExpression.toString() + ";");
        for (n2 = 0; n2 < this.myIteratorExpressionList.size(); ++n2) {
            ableExpression = (AbleExpression)this.myIteratorExpressionList.get(n2);
            stringBuffer.append(ableExpression.toString() + ";");
        }
        stringBuffer.append(") {" + Able.LS);
        for (n2 = 0; n2 < this.myConsequents.size(); ++n2) {
            stringBuffer.append(this.myConsequents.get(n2).toString() + Able.LS);
        }
        stringBuffer.append(stringBuffer2.toString() + "          };" + Able.LS);
        return stringBuffer.toString();
    }
}

